/* CodeMirror, copyright (c) by Marijn Haverbeke and others. Distributed under an MIT license: http://codemirror.net/LICENSE */
!function() {
    "use strict";
    class Text {
        lineAt(pos) {
            if (pos < 0 || pos > this.length) throw new RangeError(`Invalid position ${pos} in document of length ` + this.length);
            return this.lineInner(pos, !1, 1, 0);
        }
        line(n) {
            if (n < 1 || n > this.lines) throw new RangeError(`Invalid line number ${n} in ${this.lines}-line document`);
            return this.lineInner(n, !0, 1, 0);
        }
        replace(from, to, text) {
            [ from, to ] = clip(this, from, to);
            var parts = [];
            return this.decompose(0, from, parts, 2), text.length && text.decompose(0, text.length, parts, 3), 
            this.decompose(to, this.length, parts, 1), TextNode.from(parts, this.length - (to - from) + text.length);
        }
        append(other) {
            return this.replace(this.length, this.length, other);
        }
        slice(from, to = this.length) {
            [ from, to ] = clip(this, from, to);
            var parts = [];
            return this.decompose(from, to, parts, 0), TextNode.from(parts, to - from);
        }
        eq(other) {
            if (other == this) return !0;
            if (other.length != this.length || other.lines != this.lines) return !1;
            var start = this.scanIdentical(other, 1), end = this.length - this.scanIdentical(other, -1), a = new RawTextCursor(this), b = new RawTextCursor(other);
            for (let skip = start, pos = start; ;) {
                if (a.next(skip), b.next(skip), skip = 0, a.lineBreak != b.lineBreak || a.done != b.done || a.value != b.value) return !1;
                if (pos += a.value.length, a.done || pos >= end) return !0;
            }
        }
        iter(dir = 1) {
            return new RawTextCursor(this, dir);
        }
        iterRange(from, to = this.length) {
            return new PartialTextCursor(this, from, to);
        }
        iterLines(from, to) {
            let inner;
            return inner = null == from ? this.iter() : (null == to && (to = this.lines + 1), 
            from = this.line(from).from, this.iterRange(from, Math.max(from, to == this.lines + 1 ? this.length : to <= 1 ? 0 : this.line(to - 1).to))), 
            new LineCursor(inner);
        }
        toString() {
            return this.sliceString(0);
        }
        toJSON() {
            var lines = [];
            return this.flatten(lines), lines;
        }
        constructor() {}
        static of(text) {
            if (0 == text.length) throw new RangeError("A document must have at least one line");
            return 1 != text.length || text[0] ? text.length <= 32 ? new TextLeaf(text) : TextNode.from(TextLeaf.split(text, [])) : Text.empty;
        }
    }
    class TextLeaf extends Text {
        constructor(text, length = function(text) {
            let length = -1;
            for (var line of text) length += line.length + 1;
            return length;
        }(text)) {
            super(), this.text = text, this.length = length;
        }
        get lines() {
            return this.text.length;
        }
        get children() {
            return null;
        }
        lineInner(target, isLine, line, offset) {
            for (let i = 0; ;i++) {
                var string = this.text[i], end = offset + string.length;
                if (target <= (isLine ? line : end)) return new Line$1(offset, end, line, string);
                offset = end + 1, line++;
            }
        }
        decompose(from, to, target, open) {
            to = from <= 0 && to >= this.length ? this : new TextLeaf(sliceText(this.text, from, to), Math.min(to, this.length) - Math.max(0, from));
            1 & open ? (from = target.pop(), (open = appendText(to.text, from.text.slice(), 0, to.length)).length <= 32 ? target.push(new TextLeaf(open, from.length + to.length)) : (from = open.length >> 1, 
            target.push(new TextLeaf(open.slice(0, from)), new TextLeaf(open.slice(from))))) : target.push(to);
        }
        replace(from, to, text) {
            if (!(text instanceof TextLeaf)) return super.replace(from, to, text);
            [ from, to ] = clip(this, from, to);
            var lines = appendText(this.text, appendText(text.text, sliceText(this.text, 0, from)), to), text = this.length + text.length - (to - from);
            return lines.length <= 32 ? new TextLeaf(lines, text) : TextNode.from(TextLeaf.split(lines, []), text);
        }
        sliceString(from, to = this.length, lineSep = "\n") {
            [ from, to ] = clip(this, from, to);
            let result = "";
            for (let pos = 0, i = 0; pos <= to && i < this.text.length; i++) {
                var line = this.text[i], end = pos + line.length;
                pos > from && i && (result += lineSep), from < end && to > pos && (result += line.slice(Math.max(0, from - pos), to - pos)), 
                pos = end + 1;
            }
            return result;
        }
        flatten(target) {
            for (var line of this.text) target.push(line);
        }
        scanIdentical() {
            return 0;
        }
        static split(text, target) {
            let part = [], len = -1;
            for (var line of text) part.push(line), len += line.length + 1, 32 == part.length && (target.push(new TextLeaf(part, len)), 
            part = [], len = -1);
            return -1 < len && target.push(new TextLeaf(part, len)), target;
        }
    }
    class TextNode extends Text {
        constructor(children, length) {
            super(), this.children = children, this.length = length, this.lines = 0;
            for (var child of children) this.lines += child.lines;
        }
        lineInner(target, isLine, line, offset) {
            for (let i = 0; ;i++) {
                var child = this.children[i], end = offset + child.length, endLine = line + child.lines - 1;
                if (target <= (isLine ? endLine : end)) return child.lineInner(target, isLine, line, offset);
                offset = end + 1, line = 1 + endLine;
            }
        }
        decompose(from, to, target, open) {
            for (let i = 0, pos = 0; pos <= to && i < this.children.length; i++) {
                var childOpen, child = this.children[i], end = pos + child.length;
                from <= end && to >= pos && (childOpen = open & ((pos <= from ? 1 : 0) | (to <= end ? 2 : 0)), 
                pos >= from && end <= to && !childOpen ? target.push(child) : child.decompose(from - pos, to - pos, target, childOpen)), 
                pos = end + 1;
            }
        }
        replace(from, to, text) {
            if ([ from, to ] = clip(this, from, to), text.lines < this.lines) for (let i = 0, pos = 0; i < this.children.length; i++) {
                var updated, child = this.children[i], end = pos + child.length;
                if (from >= pos && to <= end) return updated = child.replace(from - pos, to - pos, text), 
                child = this.lines - child.lines + updated.lines, updated.lines < child >> 4 && updated.lines > child >> 6 ? ((child = this.children.slice())[i] = updated, 
                new TextNode(child, this.length - (to - from) + text.length)) : super.replace(pos, end, updated);
                pos = end + 1;
            }
            return super.replace(from, to, text);
        }
        sliceString(from, to = this.length, lineSep = "\n") {
            [ from, to ] = clip(this, from, to);
            let result = "";
            for (let i = 0, pos = 0; i < this.children.length && pos <= to; i++) {
                var child = this.children[i], end = pos + child.length;
                pos > from && i && (result += lineSep), from < end && to > pos && (result += child.sliceString(from - pos, to - pos, lineSep)), 
                pos = end + 1;
            }
            return result;
        }
        flatten(target) {
            for (var child of this.children) child.flatten(target);
        }
        scanIdentical(other, dir) {
            if (!(other instanceof TextNode)) return 0;
            let length = 0, [ iA, iB, eA, eB ] = 0 < dir ? [ 0, 0, this.children.length, other.children.length ] : [ this.children.length - 1, other.children.length - 1, -1, -1 ];
            for (;;iA += dir, iB += dir) {
                if (iA == eA || iB == eB) return length;
                var chA = this.children[iA], chB = other.children[iB];
                if (chA != chB) return length + chA.scanIdentical(chB, dir);
                length += chA.length + 1;
            }
        }
        static from(children, length = children.reduce((l, ch) => l + ch.length + 1, -1)) {
            let lines = 0;
            for (var ch of children) lines += ch.lines;
            if (lines < 32) {
                var flat = [];
                for (let ch of children) ch.flatten(flat);
                return new TextLeaf(flat, length);
            }
            let chunk = Math.max(32, lines >> 5), maxChunk = chunk << 1, minChunk = chunk >> 1, chunked = [], currentLines = 0, currentLen = -1, currentChunk = [];
            function flush() {
                0 != currentLines && (chunked.push(1 == currentChunk.length ? currentChunk[0] : TextNode.from(currentChunk, currentLen)), 
                currentLen = -1, currentLines = currentChunk.length = 0);
            }
            for (var child of children) !function add(child) {
                let last;
                if (child.lines > maxChunk && child instanceof TextNode) for (var node of child.children) add(node); else child.lines > minChunk && (currentLines > minChunk || !currentLines) ? (flush(), 
                chunked.push(child)) : child instanceof TextLeaf && currentLines && (last = currentChunk[currentChunk.length - 1]) instanceof TextLeaf && child.lines + last.lines <= 32 ? (currentLines += child.lines, 
                currentLen += child.length + 1, currentChunk[currentChunk.length - 1] = new TextLeaf(last.text.concat(child.text), last.length + 1 + child.length)) : (currentLines + child.lines > chunk && flush(), 
                currentLines += child.lines, currentLen += child.length + 1, currentChunk.push(child));
            }(child);
            return flush(), 1 == chunked.length ? chunked[0] : new TextNode(chunked, length);
        }
    }
    function appendText(text, target, from = 0, to = 1e9) {
        for (let pos = 0, i = 0, first = !0; i < text.length && pos <= to; i++) {
            let line = text[i], end = pos + line.length;
            from <= end && (to < end && (line = line.slice(0, to - pos)), pos < from && (line = line.slice(from - pos)), 
            first ? (target[target.length - 1] += line, first = !1) : target.push(line)), 
            pos = end + 1;
        }
        return target;
    }
    function sliceText(text, from, to) {
        return appendText(text, [ "" ], from, to);
    }
    Text.empty = new TextLeaf([ "" ], 0);
    class RawTextCursor {
        constructor(text, dir = 1) {
            this.dir = dir, this.done = !1, this.lineBreak = !1, this.value = "", 
            this.nodes = [ text ], this.offsets = [ 0 < dir ? 1 : (text instanceof TextLeaf ? text.text : text.children).length << 1 ];
        }
        nextInner(skip, dir) {
            for (this.done = this.lineBreak = !1; ;) {
                var last = this.nodes.length - 1, top = this.nodes[last], offsetValue = this.offsets[last], offset = offsetValue >> 1, size = (top instanceof TextLeaf ? top.text : top.children).length;
                if (offset == (0 < dir ? size : 0)) {
                    if (0 == last) return this.done = !0, this.value = "", this;
                    0 < dir && this.offsets[last - 1]++, this.nodes.pop(), this.offsets.pop();
                } else if ((1 & offsetValue) == (0 < dir ? 0 : 1)) {
                    if (this.offsets[last] += dir, 0 == skip) return this.lineBreak = !0, 
                    this.value = "\n", this;
                    skip--;
                } else if (top instanceof TextLeaf) {
                    size = top.text[offset + (dir < 0 ? -1 : 0)];
                    if (this.offsets[last] += dir, size.length > Math.max(0, skip)) return this.value = 0 == skip ? size : 0 < dir ? size.slice(skip) : size.slice(0, size.length - skip), 
                    this;
                    skip -= size.length;
                } else {
                    let next = top.children[offset + (dir < 0 ? -1 : 0)];
                    skip > next.length ? (skip -= next.length, this.offsets[last] += dir) : (dir < 0 && this.offsets[last]--, 
                    this.nodes.push(next), this.offsets.push(0 < dir ? 1 : (next instanceof TextLeaf ? next.text : next.children).length << 1));
                }
            }
        }
        next(skip = 0) {
            return skip < 0 && (this.nextInner(-skip, -this.dir), skip = this.value.length), 
            this.nextInner(skip, this.dir);
        }
    }
    class PartialTextCursor {
        constructor(text, start, end) {
            this.value = "", this.done = !1, this.cursor = new RawTextCursor(text, end < start ? -1 : 1), 
            this.pos = end < start ? text.length : 0, this.from = Math.min(start, end), 
            this.to = Math.max(start, end);
        }
        nextInner(skip, dir) {
            var limit, value;
            return (dir < 0 ? this.pos <= this.from : this.pos >= this.to) ? (this.value = "", 
            this.done = !0) : (skip += Math.max(0, dir < 0 ? this.pos - this.to : this.from - this.pos), 
            limit = dir < 0 ? this.pos - this.from : this.to - this.pos, value = (limit -= skip = limit < skip ? limit : skip, 
            this.cursor.next(skip))["value"], this.pos += (value.length + skip) * dir, 
            this.value = value.length <= limit ? value : dir < 0 ? value.slice(value.length - limit) : value.slice(0, limit), 
            this.done = !this.value), this;
        }
        next(skip = 0) {
            return skip < 0 ? skip = Math.max(skip, this.from - this.pos) : 0 < skip && (skip = Math.min(skip, this.to - this.pos)), 
            this.nextInner(skip, this.cursor.dir);
        }
        get lineBreak() {
            return this.cursor.lineBreak && "" != this.value;
        }
    }
    class LineCursor {
        constructor(inner) {
            this.inner = inner, this.afterBreak = !0, this.value = "", this.done = !1;
        }
        next(skip = 0) {
            var {
                done: skip,
                lineBreak,
                value
            } = this.inner.next(skip);
            return skip && this.afterBreak ? (this.value = "", this.afterBreak = !1) : skip ? (this.done = !0, 
            this.value = "") : lineBreak ? this.afterBreak ? this.value = "" : (this.afterBreak = !0, 
            this.next()) : (this.value = value, this.afterBreak = !1), this;
        }
        get lineBreak() {
            return !1;
        }
    }
    "undefined" != typeof Symbol && (Text.prototype[Symbol.iterator] = function() {
        return this.iter();
    }, RawTextCursor.prototype[Symbol.iterator] = PartialTextCursor.prototype[Symbol.iterator] = LineCursor.prototype[Symbol.iterator] = function() {
        return this;
    });
    let Line$1 = class {
        constructor(from, to, number, text) {
            this.from = from, this.to = to, this.number = number, this.text = text;
        }
        get length() {
            return this.to - this.from;
        }
    };
    function clip(text, from, to) {
        return [ from = Math.max(0, Math.min(text.length, from)), Math.max(from, Math.min(text.length, to)) ];
    }
    let extend = "lc,34,7n,7,7b,19,,,,2,,2,,,20,b,1c,l,g,,2t,7,2,6,2,2,,4,z,,u,r,2j,b,1m,9,9,,o,4,,9,,3,,5,17,3,3b,f,,w,1j,,,,4,8,4,,3,7,a,2,t,,1m,,,,2,4,8,,9,,a,2,q,,2,2,1l,,4,2,4,2,2,3,3,,u,2,3,,b,2,1l,,4,5,,2,4,,k,2,m,6,,,1m,,,2,,4,8,,7,3,a,2,u,,1n,,,,c,,9,,14,,3,,1l,3,5,3,,4,7,2,b,2,t,,1m,,2,,2,,3,,5,2,7,2,b,2,s,2,1l,2,,,2,4,8,,9,,a,2,t,,20,,4,,2,3,,,8,,29,,2,7,c,8,2q,,2,9,b,6,22,2,r,,,,,,1j,e,,5,,2,5,b,,10,9,,2u,4,,6,,2,2,2,p,2,4,3,g,4,d,,2,2,6,,f,,jj,3,qa,3,t,3,t,2,u,2,1s,2,,7,8,,2,b,9,,19,3,3b,2,y,,3a,3,4,2,9,,6,3,63,2,2,,1m,,,7,,,,,2,8,6,a,2,,1c,h,1r,4,1c,7,,,5,,14,9,c,2,w,4,2,2,,3,1k,,,2,3,,,3,1m,8,2,2,48,3,,d,,7,4,,6,,3,2,5i,1m,,5,ek,,5f,x,2da,3,3x,,2o,w,fe,6,2x,2,n9w,4,,a,w,2,28,2,7k,,3,,4,,p,2,5,,47,2,q,i,d,,12,8,p,b,1a,3,1c,,2,4,2,2,13,,1v,6,2,2,2,2,c,,8,,1b,,1f,,,3,2,2,5,2,,,16,2,8,,6m,,2,,4,,fn4,,kh,g,g,g,a6,2,gt,,6a,,45,5,1ae,3,,2,5,4,14,3,4,,4l,2,fx,4,ar,2,49,b,4w,,1i,f,1k,3,1d,4,2,2,1x,3,10,5,,8,1q,,c,2,1g,9,a,4,2,,2n,3,2,,,2,6,,4g,,3,8,l,2,1l,2,,,,,m,,e,7,3,5,5f,8,2,3,,,n,,29,,2,6,,,2,,,2,,2,6j,,2,4,6,2,,2,r,2,2d,8,2,,,2,2y,,,,2,6,,,2t,3,2,4,,5,77,9,,2,6t,,a,2,,,4,,40,4,2,2,4,,w,a,14,6,2,4,8,,9,6,2,3,1a,d,,2,ba,7,,6,,,2a,m,2,7,,2,,2,3e,6,3,,,2,,7,,,20,2,3,,,,9n,2,f0b,5,1n,7,t4,,1r,4,29,,f5k,2,43q,,,3,4,5,8,8,2,7,u,4,44,3,1iz,1j,4,1e,8,,e,,m,5,,f,11s,7,,h,2,7,,2,,5,79,7,c5,4,15s,7,31,7,240,5,gx7k,2o,3k,6o".split(",").map(s => s ? parseInt(s, 36) : 1);
    for (let i = 1; i < extend.length; i++) extend[i] += extend[i - 1];
    function isRegionalIndicator(code) {
        return 127462 <= code && code <= 127487;
    }
    const ZWJ = 8205;
    function findClusterBreak(str, pos, forward = !0, includeExtending = !0) {
        return (forward ? nextClusterBreak : prevClusterBreak)(str, pos, includeExtending);
    }
    function nextClusterBreak(str, pos, includeExtending) {
        if (pos != str.length) {
            pos && surrogateLow(str.charCodeAt(pos)) && surrogateHigh(str.charCodeAt(pos - 1)) && pos--;
            let prev = codePointAt(str, pos);
            for (pos += codePointSize(prev); pos < str.length; ) {
                var next = codePointAt(str, pos);
                if (prev == ZWJ || next == ZWJ || includeExtending && function(code) {
                    for (let i = 1; i < extend.length; i += 2) if (extend[i] > code) return extend[i - 1] <= code;
                }(next)) pos += next < 65536 ? 1 : 2, prev = next; else {
                    if (!isRegionalIndicator(next)) break;
                    {
                        let countBefore = 0, i = pos - 2;
                        for (;0 <= i && isRegionalIndicator(codePointAt(str, i)); ) countBefore++, 
                        i -= 2;
                        if (countBefore % 2 == 0) break;
                        pos += 2;
                    }
                }
            }
        }
        return pos;
    }
    function prevClusterBreak(str, pos, includeExtending) {
        for (;0 < pos; ) {
            var found = nextClusterBreak(str, pos - 2, includeExtending);
            if (found < pos) return found;
            pos--;
        }
        return 0;
    }
    function surrogateLow(ch) {
        return 56320 <= ch && ch < 57344;
    }
    function surrogateHigh(ch) {
        return 55296 <= ch && ch < 56320;
    }
    function codePointAt(str, pos) {
        var code0 = str.charCodeAt(pos);
        return surrogateHigh(code0) && pos + 1 != str.length && surrogateLow(str = str.charCodeAt(pos + 1)) ? str - 56320 + (code0 - 55296 << 10) + 65536 : code0;
    }
    function fromCodePoint(code) {
        return code <= 65535 ? String.fromCharCode(code) : (code -= 65536, String.fromCharCode(55296 + (code >> 10), 56320 + (1023 & code)));
    }
    function codePointSize(code) {
        return code < 65536 ? 1 : 2;
    }
    const DefaultSplit = /\r\n?|\n/;
    var MapMode = function(MapMode) {
        return MapMode[MapMode.Simple = 0] = "Simple", MapMode[MapMode.TrackDel = 1] = "TrackDel", 
        MapMode[MapMode.TrackBefore = 2] = "TrackBefore", MapMode[MapMode.TrackAfter = 3] = "TrackAfter", 
        MapMode;
    }(MapMode = MapMode || {});
    class ChangeDesc {
        constructor(sections) {
            this.sections = sections;
        }
        get length() {
            let result = 0;
            for (let i = 0; i < this.sections.length; i += 2) result += this.sections[i];
            return result;
        }
        get newLength() {
            let result = 0;
            for (let i = 0; i < this.sections.length; i += 2) {
                var ins = this.sections[i + 1];
                result += ins < 0 ? this.sections[i] : ins;
            }
            return result;
        }
        get empty() {
            return 0 == this.sections.length || 2 == this.sections.length && this.sections[1] < 0;
        }
        iterGaps(f) {
            for (let i = 0, posA = 0, posB = 0; i < this.sections.length; ) {
                var len = this.sections[i++], ins = this.sections[i++];
                ins < 0 ? (f(posA, posB, len), posB += len) : posB += ins, posA += len;
            }
        }
        iterChangedRanges(f, individual = !1) {
            iterChanges(this, f, individual);
        }
        get invertedDesc() {
            var sections = [];
            for (let i = 0; i < this.sections.length; ) {
                var len = this.sections[i++], ins = this.sections[i++];
                ins < 0 ? sections.push(len, ins) : sections.push(ins, len);
            }
            return new ChangeDesc(sections);
        }
        composeDesc(other) {
            return this.empty ? other : other.empty ? this : composeSets(this, other);
        }
        mapDesc(other, before = !1) {
            return other.empty ? this : mapSet(this, other, before);
        }
        mapPos(pos, assoc = -1, mode = MapMode.Simple) {
            let posA = 0, posB = 0;
            for (let i = 0; i < this.sections.length; ) {
                var len = this.sections[i++], ins = this.sections[i++], endA = posA + len;
                if (ins < 0) {
                    if (pos < endA) return posB + (pos - posA);
                    posB += len;
                } else {
                    if (mode != MapMode.Simple && pos <= endA && (mode == MapMode.TrackDel && posA < pos && pos < endA || mode == MapMode.TrackBefore && posA < pos || mode == MapMode.TrackAfter && pos < endA)) return null;
                    if (pos < endA || endA == pos && assoc < 0 && !len) return pos == posA || assoc < 0 ? posB : posB + ins;
                    posB += ins;
                }
                posA = endA;
            }
            if (pos > posA) throw new RangeError(`Position ${pos} is out of range for changeset of length ` + posA);
            return posB;
        }
        touchesRange(from, to = from) {
            for (let i = 0, pos = 0; i < this.sections.length && pos <= to; ) {
                var len = this.sections[i++], ins = this.sections[i++], len = pos + len;
                if (0 <= ins && pos <= to && from <= len) return !(pos < from && to < len) || "cover";
                pos = len;
            }
            return !1;
        }
        toString() {
            let result = "";
            for (let i = 0; i < this.sections.length; ) {
                var len = this.sections[i++], ins = this.sections[i++];
                result += (result ? " " : "") + len + (0 <= ins ? ":" + ins : "");
            }
            return result;
        }
        toJSON() {
            return this.sections;
        }
        static fromJSON(json) {
            if (!Array.isArray(json) || json.length % 2 || json.some(a => "number" != typeof a)) throw new RangeError("Invalid JSON representation of ChangeDesc");
            return new ChangeDesc(json);
        }
        static create(sections) {
            return new ChangeDesc(sections);
        }
    }
    class ChangeSet extends ChangeDesc {
        constructor(sections, inserted) {
            super(sections), this.inserted = inserted;
        }
        apply(doc) {
            if (this.length != doc.length) throw new RangeError("Applying change set to a document with the wrong length");
            return iterChanges(this, (fromA, toA, fromB, _toB, text) => doc = doc.replace(fromB, fromB + (toA - fromA), text), !1), 
            doc;
        }
        mapDesc(other, before = !1) {
            return mapSet(this, other, before, !0);
        }
        invert(doc) {
            var sections = this.sections.slice(), inserted = [];
            for (let i = 0, pos = 0; i < sections.length; i += 2) {
                var len = sections[i], ins = sections[i + 1];
                if (0 <= ins) {
                    sections[i] = ins, sections[i + 1] = len;
                    for (var index = i >> 1; inserted.length < index; ) inserted.push(Text.empty);
                    inserted.push(len ? doc.slice(pos, pos + len) : Text.empty);
                }
                pos += len;
            }
            return new ChangeSet(sections, inserted);
        }
        compose(other) {
            return this.empty ? other : other.empty ? this : composeSets(this, other, !0);
        }
        map(other, before = !1) {
            return other.empty ? this : mapSet(this, other, before, !0);
        }
        iterChanges(f, individual = !1) {
            iterChanges(this, f, individual);
        }
        get desc() {
            return ChangeDesc.create(this.sections);
        }
        filter(ranges) {
            var resultSections = [], resultInserted = [], filteredSections = [], iter = new SectionIter(this);
            done: for (let i = 0, pos = 0; ;) {
                for (var next = i == ranges.length ? 1e9 : ranges[i++]; pos < next || pos == next && 0 == iter.len; ) {
                    if (iter.done) break done;
                    var len = Math.min(iter.len, next - pos), ins = (addSection(filteredSections, len, -1), 
                    -1 == iter.ins ? -1 : 0 == iter.off ? iter.ins : 0);
                    addSection(resultSections, len, ins), 0 < ins && addInsert(resultInserted, resultSections, iter.text), 
                    iter.forward(len), pos += len;
                }
                for (var end = ranges[i++]; pos < end; ) {
                    if (iter.done) break done;
                    let len = Math.min(iter.len, end - pos);
                    addSection(resultSections, len, -1), addSection(filteredSections, len, -1 == iter.ins ? -1 : 0 == iter.off ? iter.ins : 0), 
                    iter.forward(len), pos += len;
                }
            }
            return {
                changes: new ChangeSet(resultSections, resultInserted),
                filtered: ChangeDesc.create(filteredSections)
            };
        }
        toJSON() {
            var parts = [];
            for (let i = 0; i < this.sections.length; i += 2) {
                var len = this.sections[i], ins = this.sections[i + 1];
                parts.push(ins < 0 ? len : 0 == ins ? [ len ] : [ len ].concat(this.inserted[i >> 1].toJSON()));
            }
            return parts;
        }
        static of(changes, length, lineSep) {
            let sections = [], inserted = [], pos = 0, total = null;
            function flush(force = !1) {
                (force || sections.length) && (pos < length && addSection(sections, length - pos, -1), 
                force = new ChangeSet(sections, inserted), total = total ? total.compose(force.map(total)) : force, 
                sections = [], inserted = [], pos = 0);
            }
            return function process(spec) {
                if (Array.isArray(spec)) for (var sub of spec) process(sub); else if (spec instanceof ChangeSet) {
                    if (spec.length != length) throw new RangeError(`Mismatched change set length (got ${spec.length}, expected ${length})`);
                    flush(), total = total ? total.compose(spec.map(total)) : spec;
                } else {
                    var {
                        from: spec,
                        to = spec,
                        insert
                    } = spec;
                    if (to < spec || spec < 0 || length < to) throw new RangeError(`Invalid change range ${spec} to ${to} (in doc of length ${length})`);
                    var insLen = (insert = insert ? "string" == typeof insert ? Text.of(insert.split(lineSep || DefaultSplit)) : insert : Text.empty).length;
                    spec == to && 0 == insLen || (spec < pos && flush(), spec > pos && addSection(sections, spec - pos, -1), 
                    addSection(sections, to - spec, insLen), addInsert(inserted, sections, insert), 
                    pos = to);
                }
            }(changes), flush(!total), total;
        }
        static empty(length) {
            return new ChangeSet(length ? [ length, -1 ] : [], []);
        }
        static fromJSON(json) {
            if (!Array.isArray(json)) throw new RangeError("Invalid JSON representation of ChangeSet");
            var sections = [], inserted = [];
            for (let i = 0; i < json.length; i++) {
                var part = json[i];
                if ("number" == typeof part) sections.push(part, -1); else {
                    if (!Array.isArray(part) || "number" != typeof part[0] || part.some((e, i) => i && "string" != typeof e)) throw new RangeError("Invalid JSON representation of ChangeSet");
                    if (1 == part.length) sections.push(part[0], 0); else {
                        for (;inserted.length < i; ) inserted.push(Text.empty);
                        inserted[i] = Text.of(part.slice(1)), sections.push(part[0], inserted[i].length);
                    }
                }
            }
            return new ChangeSet(sections, inserted);
        }
        static createSet(sections, inserted) {
            return new ChangeSet(sections, inserted);
        }
    }
    function addSection(sections, len, ins, forceJoin = !1) {
        var last;
        0 == len && ins <= 0 || (0 <= (last = sections.length - 2) && ins <= 0 && ins == sections[1 + last] ? sections[last] += len : 0 == len && 0 == sections[last] ? sections[1 + last] += ins : forceJoin ? (sections[last] += len, 
        sections[1 + last] += ins) : sections.push(len, ins));
    }
    function addInsert(values, sections, value) {
        if (0 != value.length) {
            var index = sections.length - 2 >> 1;
            if (index < values.length) values[values.length - 1] = values[values.length - 1].append(value); else {
                for (;values.length < index; ) values.push(Text.empty);
                values.push(value);
            }
        }
    }
    function iterChanges(desc, f, individual) {
        var inserted = desc.inserted;
        for (let posA = 0, posB = 0, i = 0; i < desc.sections.length; ) {
            let len = desc.sections[i++], ins = desc.sections[i++];
            if (ins < 0) posA += len, posB += len; else {
                let endA = posA, endB = posB, text = Text.empty;
                for (;endA += len, endB += ins, ins && inserted && (text = text.append(inserted[i - 2 >> 1])), 
                !(individual || i == desc.sections.length || desc.sections[i + 1] < 0); ) len = desc.sections[i++], 
                ins = desc.sections[i++];
                f(posA, endA, posB, endB, text), posA = endA, posB = endB;
            }
        }
    }
    function mapSet(setA, setB, before, mkSet = !1) {
        var sections = [], insert = mkSet ? [] : null, a = new SectionIter(setA), b = new SectionIter(setB);
        for (let inserted = -1; ;) if (-1 == a.ins && -1 == b.ins) {
            var len = Math.min(a.len, b.len);
            addSection(sections, len, -1), a.forward(len), b.forward(len);
        } else if (0 <= b.ins && (a.ins < 0 || inserted == a.i || 0 == a.off && (b.len < a.len || b.len == a.len && !before))) {
            let len = b.len;
            for (addSection(sections, b.ins, -1); len; ) {
                var piece = Math.min(a.len, len);
                0 <= a.ins && inserted < a.i && a.len <= piece && (addSection(sections, 0, a.ins), 
                insert && addInsert(insert, sections, a.text), inserted = a.i), 
                a.forward(piece), len -= piece;
            }
            b.next();
        } else {
            if (!(0 <= a.ins)) {
                if (a.done && b.done) return insert ? ChangeSet.createSet(sections, insert) : ChangeDesc.create(sections);
                throw new Error("Mismatched change set lengths");
            }
            {
                let len = 0, left = a.len;
                for (;left; ) if (-1 == b.ins) {
                    let piece = Math.min(left, b.len);
                    len += piece, left -= piece, b.forward(piece);
                } else {
                    if (!(0 == b.ins && b.len < left)) break;
                    left -= b.len, b.next();
                }
                addSection(sections, len, inserted < a.i ? a.ins : 0), insert && inserted < a.i && addInsert(insert, sections, a.text), 
                inserted = a.i, a.forward(a.len - left);
            }
        }
    }
    function composeSets(setA, setB, mkSet = !1) {
        var sections = [], insert = mkSet ? [] : null, a = new SectionIter(setA), b = new SectionIter(setB);
        for (let open = !1; ;) {
            if (a.done && b.done) return insert ? ChangeSet.createSet(sections, insert) : ChangeDesc.create(sections);
            if (0 == a.ins) addSection(sections, a.len, 0, open), a.next(); else if (0 != b.len || b.done) {
                if (a.done || b.done) throw new Error("Mismatched change set lengths");
                var insB, len = Math.min(a.len2, b.len), sectionLen = sections.length;
                -1 == a.ins ? (addSection(sections, len, insB = -1 == b.ins ? -1 : b.off ? 0 : b.ins, open), 
                insert && insB && addInsert(insert, sections, b.text)) : -1 == b.ins ? (addSection(sections, a.off ? 0 : a.len, len, open), 
                insert && addInsert(insert, sections, a.textBit(len))) : (addSection(sections, a.off ? 0 : a.len, b.off ? 0 : b.ins, open), 
                insert && !b.off && addInsert(insert, sections, b.text)), open = (a.ins > len || 0 <= b.ins && b.len > len) && (open || sectionLen < sections.length), 
                a.forward2(len), b.forward(len);
            } else addSection(sections, 0, b.ins, open), insert && addInsert(insert, sections, b.text), 
            b.next();
        }
    }
    class SectionIter {
        constructor(set) {
            this.set = set, this.i = 0, this.next();
        }
        next() {
            var sections = this.set["sections"];
            this.i < sections.length ? (this.len = sections[this.i++], this.ins = sections[this.i++]) : (this.len = 0, 
            this.ins = -2), this.off = 0;
        }
        get done() {
            return -2 == this.ins;
        }
        get len2() {
            return this.ins < 0 ? this.len : this.ins;
        }
        get text() {
            var inserted = this.set["inserted"], index = this.i - 2 >> 1;
            return index >= inserted.length ? Text.empty : inserted[index];
        }
        textBit(len) {
            var inserted = this.set["inserted"], index = this.i - 2 >> 1;
            return index >= inserted.length && !len ? Text.empty : inserted[index].slice(this.off, null == len ? void 0 : this.off + len);
        }
        forward(len) {
            len == this.len ? this.next() : (this.len -= len, this.off += len);
        }
        forward2(len) {
            -1 == this.ins ? this.forward(len) : len == this.ins ? this.next() : (this.ins -= len, 
            this.off += len);
        }
    }
    class SelectionRange {
        constructor(from, to, flags) {
            this.from = from, this.to = to, this.flags = flags;
        }
        get anchor() {
            return 32 & this.flags ? this.to : this.from;
        }
        get head() {
            return 32 & this.flags ? this.from : this.to;
        }
        get empty() {
            return this.from == this.to;
        }
        get assoc() {
            return 8 & this.flags ? -1 : 16 & this.flags ? 1 : 0;
        }
        get bidiLevel() {
            var level = 7 & this.flags;
            return 7 == level ? null : level;
        }
        get goalColumn() {
            var value = this.flags >> 6;
            return 16777215 == value ? void 0 : value;
        }
        map(change, assoc = -1) {
            let from, to;
            return this.empty ? from = to = change.mapPos(this.from, assoc) : (from = change.mapPos(this.from, 1), 
            to = change.mapPos(this.to, -1)), from == this.from && to == this.to ? this : new SelectionRange(from, to, this.flags);
        }
        extend(from, to = from) {
            return from <= this.anchor && to >= this.anchor ? EditorSelection.range(from, to) : (to = Math.abs(from - this.anchor) > Math.abs(to - this.anchor) ? from : to, 
            EditorSelection.range(this.anchor, to));
        }
        eq(other, includeAssoc = !1) {
            return !(this.anchor != other.anchor || this.head != other.head || includeAssoc && this.empty && this.assoc != other.assoc);
        }
        toJSON() {
            return {
                anchor: this.anchor,
                head: this.head
            };
        }
        static fromJSON(json) {
            if (json && "number" == typeof json.anchor && "number" == typeof json.head) return EditorSelection.range(json.anchor, json.head);
            throw new RangeError("Invalid JSON representation for SelectionRange");
        }
        static create(from, to, flags) {
            return new SelectionRange(from, to, flags);
        }
    }
    class EditorSelection {
        constructor(ranges, mainIndex) {
            this.ranges = ranges, this.mainIndex = mainIndex;
        }
        map(change, assoc = -1) {
            return change.empty ? this : EditorSelection.create(this.ranges.map(r => r.map(change, assoc)), this.mainIndex);
        }
        eq(other, includeAssoc = !1) {
            if (this.ranges.length != other.ranges.length || this.mainIndex != other.mainIndex) return !1;
            for (let i = 0; i < this.ranges.length; i++) if (!this.ranges[i].eq(other.ranges[i], includeAssoc)) return !1;
            return !0;
        }
        get main() {
            return this.ranges[this.mainIndex];
        }
        asSingle() {
            return 1 == this.ranges.length ? this : new EditorSelection([ this.main ], 0);
        }
        addRange(range, main = !0) {
            return EditorSelection.create([ range ].concat(this.ranges), main ? 0 : this.mainIndex + 1);
        }
        replaceRange(range, which = this.mainIndex) {
            var ranges = this.ranges.slice();
            return ranges[which] = range, EditorSelection.create(ranges, this.mainIndex);
        }
        toJSON() {
            return {
                ranges: this.ranges.map(r => r.toJSON()),
                main: this.mainIndex
            };
        }
        static fromJSON(json) {
            if (!json || !Array.isArray(json.ranges) || "number" != typeof json.main || json.main >= json.ranges.length) throw new RangeError("Invalid JSON representation for EditorSelection");
            return new EditorSelection(json.ranges.map(r => SelectionRange.fromJSON(r)), json.main);
        }
        static single(anchor, head = anchor) {
            return new EditorSelection([ EditorSelection.range(anchor, head) ], 0);
        }
        static create(ranges, mainIndex = 0) {
            if (0 == ranges.length) throw new RangeError("A selection needs at least one range");
            for (let pos = 0, i = 0; i < ranges.length; i++) {
                var range = ranges[i];
                if (range.empty ? range.from <= pos : range.from < pos) return EditorSelection.normalized(ranges.slice(), mainIndex);
                pos = range.to;
            }
            return new EditorSelection(ranges, mainIndex);
        }
        static cursor(pos, assoc = 0, bidiLevel, goalColumn) {
            return SelectionRange.create(pos, pos, (0 == assoc ? 0 : assoc < 0 ? 8 : 16) | (null == bidiLevel ? 7 : Math.min(6, bidiLevel)) | (null != goalColumn ? goalColumn : 16777215) << 6);
        }
        static range(anchor, head, goalColumn, bidiLevel) {
            goalColumn = (null != goalColumn ? goalColumn : 16777215) << 6 | (null == bidiLevel ? 7 : Math.min(6, bidiLevel));
            return head < anchor ? SelectionRange.create(head, anchor, 48 | goalColumn) : SelectionRange.create(anchor, head, (anchor < head ? 8 : 0) | goalColumn);
        }
        static normalized(ranges, mainIndex = 0) {
            var main = ranges[mainIndex];
            ranges.sort((a, b) => a.from - b.from), mainIndex = ranges.indexOf(main);
            for (let i = 1; i < ranges.length; i++) {
                var from, range = ranges[i], prev = ranges[i - 1];
                (range.empty ? range.from <= prev.to : range.from < prev.to) && (from = prev.from, 
                prev = Math.max(range.to, prev.to), i <= mainIndex && mainIndex--, 
                ranges.splice(--i, 2, range.anchor > range.head ? EditorSelection.range(prev, from) : EditorSelection.range(from, prev)));
            }
            return new EditorSelection(ranges, mainIndex);
        }
    }
    function checkSelection(selection, docLength) {
        for (var range of selection.ranges) if (range.to > docLength) throw new RangeError("Selection points outside of document");
    }
    let nextID = 0;
    class Facet {
        constructor(combine, compareInput, compare, isStatic, enables) {
            this.combine = combine, this.compareInput = compareInput, this.compare = compare, 
            this.isStatic = isStatic, this.id = nextID++, this.default = combine([]), 
            this.extensions = "function" == typeof enables ? enables(this) : enables;
        }
        get reader() {
            return this;
        }
        static define(config = {}) {
            return new Facet(config.combine || (a => a), config.compareInput || ((a, b) => a === b), config.compare || (config.combine ? (a, b) => a === b : sameArray$1), !!config.static, config.enables);
        }
        of(value) {
            return new FacetProvider([], this, 0, value);
        }
        compute(deps, get) {
            if (this.isStatic) throw new Error("Can't compute a static facet");
            return new FacetProvider(deps, this, 1, get);
        }
        computeN(deps, get) {
            if (this.isStatic) throw new Error("Can't compute a static facet");
            return new FacetProvider(deps, this, 2, get);
        }
        from(field, get) {
            return get = get || (x => x), this.compute([ field ], state => get(state.field(field)));
        }
    }
    function sameArray$1(a, b) {
        return a == b || a.length == b.length && a.every((e, i) => e === b[i]);
    }
    class FacetProvider {
        constructor(dependencies, facet, type, value) {
            this.dependencies = dependencies, this.facet = facet, this.type = type, 
            this.value = value, this.id = nextID++;
        }
        dynamicSlot(addresses) {
            var _a, dep;
            let getter = this.value, compare = this.facet.compareInput, id = this.id, idx = addresses[id] >> 1, multi = 2 == this.type, depDoc = !1, depSel = !1, depAddrs = [];
            for (dep of this.dependencies) "doc" == dep ? depDoc = !0 : "selection" == dep ? depSel = !0 : 0 == (1 & (null != (_a = addresses[dep.id]) ? _a : 1)) && depAddrs.push(addresses[dep.id]);
            return {
                create(state) {
                    return state.values[idx] = getter(state), 1;
                },
                update(state, tr) {
                    if (depDoc && tr.docChanged || depSel && (tr.docChanged || tr.selection) || ensureAll(state, depAddrs)) {
                        tr = getter(state);
                        if (multi ? !compareArray(tr, state.values[idx], compare) : !compare(tr, state.values[idx])) return state.values[idx] = tr, 
                        1;
                    }
                    return 0;
                },
                reconfigure: (state, oldState) => {
                    let newVal, oldAddr = oldState.config.address[id];
                    if (null != oldAddr) {
                        var oldVal = getAddr(oldState, oldAddr);
                        if (this.dependencies.every(dep => dep instanceof Facet ? oldState.facet(dep) === state.facet(dep) : !(dep instanceof StateField) || oldState.field(dep, !1) == state.field(dep, !1)) || (multi ? compareArray(newVal = getter(state), oldVal, compare) : compare(newVal = getter(state), oldVal))) return state.values[idx] = oldVal, 
                        0;
                    } else newVal = getter(state);
                    return state.values[idx] = newVal, 1;
                }
            };
        }
    }
    function compareArray(a, b, compare) {
        if (a.length == b.length) {
            for (let i = 0; i < a.length; i++) if (!compare(a[i], b[i])) return;
            return 1;
        }
    }
    function ensureAll(state, addrs) {
        let changed = !1;
        for (var addr of addrs) 1 & ensureAddr(state, addr) && (changed = !0);
        return changed;
    }
    const initField = Facet.define({
        static: !0
    });
    class StateField {
        constructor(id, createF, updateF, compareF, spec) {
            this.id = id, this.createF = createF, this.updateF = updateF, this.compareF = compareF, 
            this.spec = spec, this.provides = void 0;
        }
        static define(config) {
            var field = new StateField(nextID++, config.create, config.update, config.compare || ((a, b) => a === b), config);
            return config.provide && (field.provides = config.provide(field)), field;
        }
        create(state) {
            var init = state.facet(initField).find(i => i.field == this);
            return ((null == init ? void 0 : init.create) || this.createF)(state);
        }
        slot(addresses) {
            let idx = addresses[this.id] >> 1;
            return {
                create: state => (state.values[idx] = this.create(state), 1),
                update: (state, tr) => {
                    var oldVal = state.values[idx], tr = this.updateF(oldVal, tr);
                    return this.compareF(oldVal, tr) ? 0 : (state.values[idx] = tr, 
                    1);
                },
                reconfigure: (state, oldState) => null != oldState.config.address[this.id] ? (state.values[idx] = oldState.field(this), 
                0) : (state.values[idx] = this.create(state), 1)
            };
        }
        init(create) {
            return [ this, initField.of({
                field: this,
                create: create
            }) ];
        }
        get extension() {
            return this;
        }
    }
    const Prec_ = {
        lowest: 4,
        low: 3,
        default: 2,
        high: 1,
        highest: 0
    };
    function prec(value) {
        return ext => new PrecExtension(ext, value);
    }
    const Prec = {
        highest: prec(Prec_.highest),
        high: prec(Prec_.high),
        default: prec(Prec_.default),
        low: prec(Prec_.low),
        lowest: prec(Prec_.lowest)
    };
    class PrecExtension {
        constructor(inner, prec) {
            this.inner = inner, this.prec = prec;
        }
    }
    class Compartment {
        of(ext) {
            return new CompartmentInstance(this, ext);
        }
        reconfigure(content) {
            return Compartment.reconfigure.of({
                compartment: this,
                extension: content
            });
        }
        get(state) {
            return state.config.compartments.get(this);
        }
    }
    class CompartmentInstance {
        constructor(compartment, inner) {
            this.compartment = compartment, this.inner = inner;
        }
    }
    class Configuration {
        constructor(base, compartments, dynamicSlots, address, staticValues, facets) {
            for (this.base = base, this.compartments = compartments, this.dynamicSlots = dynamicSlots, 
            this.address = address, this.staticValues = staticValues, this.facets = facets, 
            this.statusTemplate = []; this.statusTemplate.length < dynamicSlots.length; ) this.statusTemplate.push(0);
        }
        staticFacet(facet) {
            var addr = this.address[facet.id];
            return null == addr ? facet.default : this.staticValues[addr >> 1];
        }
        static resolve(base, compartments, oldState) {
            var ext, fields = [], facets = Object.create(null), newCompartments = new Map();
            for (ext of function(extension, compartments, newCompartments) {
                let result = [ [], [], [], [], [] ], seen = new Map();
                return function inner(ext, prec) {
                    var known = seen.get(ext);
                    if (null != known) {
                        if (known <= prec) return;
                        var found = result[known].indexOf(ext);
                        -1 < found && result[known].splice(found, 1), ext instanceof CompartmentInstance && newCompartments.delete(ext.compartment);
                    }
                    if (seen.set(ext, prec), Array.isArray(ext)) for (var e of ext) inner(e, prec); else if (ext instanceof CompartmentInstance) {
                        if (newCompartments.has(ext.compartment)) throw new RangeError("Duplicate use of compartment in extensions");
                        known = compartments.get(ext.compartment) || ext.inner, 
                        newCompartments.set(ext.compartment, known), inner(known, prec);
                    } else if (ext instanceof PrecExtension) inner(ext.inner, ext.prec); else if (ext instanceof StateField) result[prec].push(ext), 
                    ext.provides && inner(ext.provides, prec); else if (ext instanceof FacetProvider) result[prec].push(ext), 
                    ext.facet.extensions && inner(ext.facet.extensions, Prec_.default); else {
                        let content = ext.extension;
                        if (!content) throw new Error(`Unrecognized extension value in extension set (${ext}). This sometimes happens because multiple instances of @codemirror/state are loaded, breaking instanceof checks.`);
                        inner(content, prec);
                    }
                }(extension, Prec_.default), result.reduce((a, b) => a.concat(b));
            }(base, compartments, newCompartments)) (ext instanceof StateField ? fields : facets[ext.facet.id] || (facets[ext.facet.id] = [])).push(ext);
            let address = Object.create(null);
            var staticValues = [], dynamicSlots = [];
            for (let field of fields) address[field.id] = dynamicSlots.length << 1, 
            dynamicSlots.push(a => field.slot(a));
            var id, oldFacets = null == oldState ? void 0 : oldState.config.facets;
            for (id in facets) {
                let providers = facets[id], facet = providers[0].facet;
                var oldProviders = oldFacets && oldFacets[id] || [];
                if (providers.every(p => 0 == p.type)) address[facet.id] = staticValues.length << 1 | 1, 
                sameArray$1(oldProviders, providers) ? staticValues.push(oldState.facet(facet)) : (oldProviders = facet.combine(providers.map(p => p.value)), 
                staticValues.push(oldState && facet.compare(oldProviders, oldState.facet(facet)) ? oldState.facet(facet) : oldProviders)); else {
                    for (let p of providers) 0 == p.type ? (address[p.id] = staticValues.length << 1 | 1, 
                    staticValues.push(p.value)) : (address[p.id] = dynamicSlots.length << 1, 
                    dynamicSlots.push(a => p.dynamicSlot(a)));
                    address[facet.id] = dynamicSlots.length << 1, dynamicSlots.push(a => function(addresses, facet, providers) {
                        let providerAddrs = providers.map(p => addresses[p.id]), providerTypes = providers.map(p => p.type), dynamic = providerAddrs.filter(p => !(1 & p)), idx = addresses[facet.id] >> 1;
                        function get(state) {
                            var values = [];
                            for (let i = 0; i < providerAddrs.length; i++) {
                                var value = getAddr(state, providerAddrs[i]);
                                if (2 == providerTypes[i]) for (var val of value) values.push(val); else values.push(value);
                            }
                            return facet.combine(values);
                        }
                        return {
                            create(state) {
                                for (var addr of providerAddrs) ensureAddr(state, addr);
                                return state.values[idx] = get(state), 1;
                            },
                            update(state, tr) {
                                var value;
                                return !ensureAll(state, dynamic) || (value = get(state), 
                                facet.compare(value, state.values[idx])) ? 0 : (state.values[idx] = value, 
                                1);
                            },
                            reconfigure(state, oldState) {
                                var depChanged = ensureAll(state, providerAddrs), oldProviders = oldState.config.facets[facet.id], oldState = oldState.facet(facet);
                                return oldProviders && !depChanged && sameArray$1(providers, oldProviders) || (depChanged = get(state), 
                                facet.compare(depChanged, oldState)) ? (state.values[idx] = oldState, 
                                0) : (state.values[idx] = depChanged, 1);
                            }
                        };
                    }(a, facet, providers));
                }
            }
            compartments = dynamicSlots.map(f => f(address));
            return new Configuration(base, newCompartments, compartments, address, staticValues, facets);
        }
    }
    function ensureAddr(state, addr) {
        if (1 & addr) return 2;
        var addr = addr >> 1, status = state.status[addr];
        if (4 == status) throw new Error("Cyclic dependency between fields and/or facets");
        if (2 & status) return status;
        state.status[addr] = 4;
        status = state.computeSlot(state, state.config.dynamicSlots[addr]);
        return state.status[addr] = 2 | status;
    }
    function getAddr(state, addr) {
        return (1 & addr ? state.config.staticValues : state.values)[addr >> 1];
    }
    const languageData = Facet.define(), allowMultipleSelections = Facet.define({
        combine: values => values.some(v => v),
        static: !0
    }), lineSeparator = Facet.define({
        combine: values => values.length ? values[0] : void 0,
        static: !0
    }), changeFilter = Facet.define(), transactionFilter = Facet.define(), transactionExtender = Facet.define(), readOnly = Facet.define({
        combine: values => !!values.length && values[0]
    });
    class Annotation {
        constructor(type, value) {
            this.type = type, this.value = value;
        }
        static define() {
            return new AnnotationType();
        }
    }
    class AnnotationType {
        of(value) {
            return new Annotation(this, value);
        }
    }
    class StateEffectType {
        constructor(map) {
            this.map = map;
        }
        of(value) {
            return new StateEffect(this, value);
        }
    }
    class StateEffect {
        constructor(type, value) {
            this.type = type, this.value = value;
        }
        map(mapping) {
            mapping = this.type.map(this.value, mapping);
            return void 0 === mapping ? void 0 : mapping == this.value ? this : new StateEffect(this.type, mapping);
        }
        is(type) {
            return this.type == type;
        }
        static define(spec = {}) {
            return new StateEffectType(spec.map || (v => v));
        }
        static mapEffects(effects, mapping) {
            if (!effects.length) return effects;
            var effect, result = [];
            for (effect of effects) {
                var mapped = effect.map(mapping);
                mapped && result.push(mapped);
            }
            return result;
        }
    }
    StateEffect.reconfigure = StateEffect.define(), StateEffect.appendConfig = StateEffect.define();
    class Transaction {
        constructor(startState, changes, selection, effects, annotations, scrollIntoView) {
            this.startState = startState, this.changes = changes, this.selection = selection, 
            this.effects = effects, this.annotations = annotations, this.scrollIntoView = scrollIntoView, 
            this._doc = null, this._state = null, selection && checkSelection(selection, changes.newLength), 
            annotations.some(a => a.type == Transaction.time) || (this.annotations = annotations.concat(Transaction.time.of(Date.now())));
        }
        static create(startState, changes, selection, effects, annotations, scrollIntoView) {
            return new Transaction(startState, changes, selection, effects, annotations, scrollIntoView);
        }
        get newDoc() {
            return this._doc || (this._doc = this.changes.apply(this.startState.doc));
        }
        get newSelection() {
            return this.selection || this.startState.selection.map(this.changes);
        }
        get state() {
            return this._state || this.startState.applyTransaction(this), this._state;
        }
        annotation(type) {
            for (var ann of this.annotations) if (ann.type == type) return ann.value;
        }
        get docChanged() {
            return !this.changes.empty;
        }
        get reconfigured() {
            return this.startState.config != this.state.config;
        }
        isUserEvent(event) {
            var e = this.annotation(Transaction.userEvent);
            return !(!e || !(e == event || e.length > event.length && e.slice(0, event.length) == event && "." == e[event.length]));
        }
    }
    function mergeTransaction(a, b, sequential) {
        let mapForA, mapForB, changes;
        return {
            changes: changes = sequential ? (mapForA = b.changes, mapForB = ChangeSet.empty(b.changes.length), 
            a.changes.compose(b.changes)) : (mapForA = b.changes.map(a.changes), 
            mapForB = a.changes.mapDesc(b.changes, !0), a.changes.compose(mapForA)),
            selection: b.selection ? b.selection.map(mapForB) : null == (sequential = a.selection) ? void 0 : sequential.map(mapForA),
            effects: StateEffect.mapEffects(a.effects, mapForA).concat(StateEffect.mapEffects(b.effects, mapForB)),
            annotations: a.annotations.length ? a.annotations.concat(b.annotations) : b.annotations,
            scrollIntoView: a.scrollIntoView || b.scrollIntoView
        };
    }
    function resolveTransactionInner(state, spec, docSize) {
        let sel = spec.selection, annotations = asArray$1(spec.annotations);
        return spec.userEvent && (annotations = annotations.concat(Transaction.userEvent.of(spec.userEvent))), 
        {
            changes: spec.changes instanceof ChangeSet ? spec.changes : ChangeSet.of(spec.changes || [], docSize, state.facet(lineSeparator)),
            selection: sel && (sel instanceof EditorSelection ? sel : EditorSelection.single(sel.anchor, sel.head)),
            effects: asArray$1(spec.effects),
            annotations: annotations,
            scrollIntoView: !!spec.scrollIntoView
        };
    }
    function resolveTransaction(state, specs, filter) {
        let s = resolveTransactionInner(state, specs.length ? specs[0] : {}, state.doc.length);
        specs.length && !1 === specs[0].filter && (filter = !1);
        for (let i = 1; i < specs.length; i++) {
            !1 === specs[i].filter && (filter = !1);
            var seq = !!specs[i].sequential;
            s = mergeTransaction(s, resolveTransactionInner(state, specs[i], seq ? s.changes.newLength : state.doc.length), seq);
        }
        var tr = Transaction.create(state, s.changes, s.selection, s.effects, s.annotations, s.scrollIntoView);
        return function(tr) {
            let state = tr.startState, extenders = state.facet(transactionExtender), spec = tr;
            for (let i = extenders.length - 1; 0 <= i; i--) {
                var extension = extenders[i](tr);
                extension && Object.keys(extension).length && (spec = mergeTransaction(spec, resolveTransactionInner(state, extension, tr.changes.newLength), !0));
            }
            return spec == tr ? tr : Transaction.create(state, tr.changes, tr.selection, spec.effects, spec.annotations, spec.scrollIntoView);
        }(filter ? function(tr) {
            let state = tr.startState, result = !0;
            for (var filter of state.facet(changeFilter)) {
                filter = filter(tr);
                if (!1 === filter) {
                    result = !1;
                    break;
                }
                Array.isArray(filter) && (result = !0 === result ? filter : function(a, b) {
                    var result = [];
                    for (let iA = 0, iB = 0; ;) {
                        let from, to;
                        if (iA < a.length && (iB == b.length || b[iB] >= a[iA])) from = a[iA++], 
                        to = a[iA++]; else {
                            if (!(iB < b.length)) return result;
                            from = b[iB++], to = b[iB++];
                        }
                        !result.length || result[result.length - 1] < from ? result.push(from, to) : result[result.length - 1] < to && (result[result.length - 1] = to);
                    }
                }(result, filter));
            }
            if (!0 !== result) {
                let changes, back;
                var filtered;
                !1 === result ? (back = tr.changes.invertedDesc, changes = ChangeSet.empty(state.doc.length)) : (filtered = tr.changes.filter(result), 
                changes = filtered.changes, back = filtered.filtered.mapDesc(filtered.changes).invertedDesc), 
                tr = Transaction.create(state, changes, tr.selection && tr.selection.map(back), StateEffect.mapEffects(tr.effects, back), tr.annotations, tr.scrollIntoView);
            }
            var filters = state.facet(transactionFilter);
            for (let i = filters.length - 1; 0 <= i; i--) {
                var filtered = filters[i](tr);
                tr = filtered instanceof Transaction ? filtered : Array.isArray(filtered) && 1 == filtered.length && filtered[0] instanceof Transaction ? filtered[0] : resolveTransaction(state, asArray$1(filtered), !1);
            }
            return tr;
        }(tr) : tr);
    }
    Transaction.time = Annotation.define(), Transaction.userEvent = Annotation.define(), 
    Transaction.addToHistory = Annotation.define(), Transaction.remote = Annotation.define();
    const none$3 = [];
    function asArray$1(value) {
        return null == value ? none$3 : Array.isArray(value) ? value : [ value ];
    }
    var CharCategory = function(CharCategory) {
        return CharCategory[CharCategory.Word = 0] = "Word", CharCategory[CharCategory.Space = 1] = "Space", 
        CharCategory[CharCategory.Other = 2] = "Other", CharCategory;
    }(CharCategory = CharCategory || {});
    const nonASCIISingleCaseWordChar = /[\u00df\u0587\u0590-\u05f4\u0600-\u06ff\u3040-\u309f\u30a0-\u30ff\u3400-\u4db5\u4e00-\u9fcc\uac00-\ud7af]/;
    let wordChar;
    try {
        wordChar = new RegExp("[\\p{Alphabetic}\\p{Number}_]", "u");
    } catch (_) {}
    function makeCategorizer(wordChars) {
        return char => {
            if (!/\S/.test(char)) return CharCategory.Space;
            if (function(str) {
                if (wordChar) return wordChar.test(str);
                for (let i = 0; i < str.length; i++) {
                    var ch = str[i];
                    if (/\w/.test(ch) || "\x80" < ch && (ch.toUpperCase() != ch.toLowerCase() || nonASCIISingleCaseWordChar.test(ch))) return 1;
                }
            }(char)) return CharCategory.Word;
            for (let i = 0; i < wordChars.length; i++) if (-1 < char.indexOf(wordChars[i])) return CharCategory.Word;
            return CharCategory.Other;
        };
    }
    class EditorState {
        constructor(config, doc, selection, values, computeSlot, tr) {
            this.config = config, this.doc = doc, this.selection = selection, this.values = values, 
            this.status = config.statusTemplate.slice(), this.computeSlot = computeSlot, 
            tr && (tr._state = this);
            for (let i = 0; i < this.config.dynamicSlots.length; i++) ensureAddr(this, i << 1);
            this.computeSlot = null;
        }
        field(field, require = !0) {
            field = this.config.address[field.id];
            if (null != field) return ensureAddr(this, field), getAddr(this, field);
            if (require) throw new RangeError("Field is not present in this state");
        }
        update(...specs) {
            return resolveTransaction(this, specs, !0);
        }
        applyTransaction(tr) {
            let conf = this.config, {
                base,
                compartments
            } = conf;
            for (var effect of tr.effects) effect.is(Compartment.reconfigure) ? (conf && (compartments = new Map(), 
            conf.compartments.forEach((val, key) => compartments.set(key, val)), 
            conf = null), compartments.set(effect.value.compartment, effect.value.extension)) : effect.is(StateEffect.reconfigure) ? (conf = null, 
            base = effect.value) : effect.is(StateEffect.appendConfig) && (conf = null, 
            base = asArray$1(base).concat(effect.value));
            let startValues;
            startValues = conf ? tr.startState.values.slice() : (conf = Configuration.resolve(base, compartments, this), 
            new EditorState(conf, this.doc, this.selection, conf.dynamicSlots.map(() => null), (state, slot) => slot.reconfigure(state, this), null).values);
            var selection = tr.startState.facet(allowMultipleSelections) ? tr.newSelection : tr.newSelection.asSingle();
            new EditorState(conf, tr.newDoc, selection, startValues, (state, slot) => slot.update(state, tr), tr);
        }
        replaceSelection(text) {
            return "string" == typeof text && (text = this.toText(text)), this.changeByRange(range => ({
                changes: {
                    from: range.from,
                    to: range.to,
                    insert: text
                },
                range: EditorSelection.cursor(range.from + text.length)
            }));
        }
        changeByRange(f) {
            var sel = this.selection, result1 = f(sel.ranges[0]);
            let changes = this.changes(result1.changes), ranges = [ result1.range ], effects = asArray$1(result1.effects);
            for (let i = 1; i < sel.ranges.length; i++) {
                var result = f(sel.ranges[i]), newChanges = this.changes(result.changes), newMapped = newChanges.map(changes);
                for (let j = 0; j < i; j++) ranges[j] = ranges[j].map(newMapped);
                newChanges = changes.mapDesc(newChanges, !0);
                ranges.push(result.range.map(newChanges)), changes = changes.compose(newMapped), 
                effects = StateEffect.mapEffects(effects, newMapped).concat(StateEffect.mapEffects(asArray$1(result.effects), newChanges));
            }
            return {
                changes: changes,
                selection: EditorSelection.create(ranges, sel.mainIndex),
                effects: effects
            };
        }
        changes(spec = []) {
            return spec instanceof ChangeSet ? spec : ChangeSet.of(spec, this.doc.length, this.facet(EditorState.lineSeparator));
        }
        toText(string) {
            return Text.of(string.split(this.facet(EditorState.lineSeparator) || DefaultSplit));
        }
        sliceDoc(from = 0, to = this.doc.length) {
            return this.doc.sliceString(from, to, this.lineBreak);
        }
        facet(facet) {
            var addr = this.config.address[facet.id];
            return null == addr ? facet.default : (ensureAddr(this, addr), getAddr(this, addr));
        }
        toJSON(fields) {
            var result = {
                doc: this.sliceDoc(),
                selection: this.selection.toJSON()
            };
            if (fields) for (var prop in fields) {
                var value = fields[prop];
                value instanceof StateField && null != this.config.address[value.id] && (result[prop] = value.spec.toJSON(this.field(fields[prop]), this));
            }
            return result;
        }
        static fromJSON(json, config = {}, fields) {
            if (!json || "string" != typeof json.doc) throw new RangeError("Invalid JSON representation for EditorState");
            var fieldInit = [];
            if (fields) for (var prop in fields) if (Object.prototype.hasOwnProperty.call(json, prop)) {
                let field = fields[prop], value = json[prop];
                fieldInit.push(field.init(state => field.spec.fromJSON(value, state)));
            }
            return EditorState.create({
                doc: json.doc,
                selection: EditorSelection.fromJSON(json.selection),
                extensions: config.extensions ? fieldInit.concat([ config.extensions ]) : fieldInit
            });
        }
        static create(config = {}) {
            var configuration = Configuration.resolve(config.extensions || [], new Map()), doc = config.doc instanceof Text ? config.doc : Text.of((config.doc || "").split(configuration.staticFacet(EditorState.lineSeparator) || DefaultSplit));
            let selection = config.selection ? config.selection instanceof EditorSelection ? config.selection : EditorSelection.single(config.selection.anchor, config.selection.head) : EditorSelection.single(0);
            return checkSelection(selection, doc.length), configuration.staticFacet(allowMultipleSelections) || (selection = selection.asSingle()), 
            new EditorState(configuration, doc, selection, configuration.dynamicSlots.map(() => null), (state, slot) => slot.create(state), null);
        }
        get tabSize() {
            return this.facet(EditorState.tabSize);
        }
        get lineBreak() {
            return this.facet(EditorState.lineSeparator) || "\n";
        }
        get readOnly() {
            return this.facet(readOnly);
        }
        phrase(phrase, ...insert) {
            for (var map of this.facet(EditorState.phrases)) if (Object.prototype.hasOwnProperty.call(map, phrase)) {
                phrase = map[phrase];
                break;
            }
            return phrase = insert.length ? phrase.replace(/\$(\$|\d*)/g, (m, i) => {
                return "$" == i ? "$" : !(i = +(i || 1)) || i > insert.length ? m : insert[i - 1];
            }) : phrase;
        }
        languageDataAt(name, pos, side = -1) {
            var provider, values = [];
            for (provider of this.facet(languageData)) for (var result of provider(this, pos, side)) Object.prototype.hasOwnProperty.call(result, name) && values.push(result[name]);
            return values;
        }
        charCategorizer(at) {
            return makeCategorizer(this.languageDataAt("wordChars", at).join(""));
        }
        wordAt(pos) {
            var {
                text,
                from,
                length
            } = this.doc.lineAt(pos), cat = this.charCategorizer(pos);
            let start = pos - from, end = pos - from;
            for (;0 < start; ) {
                var prev = findClusterBreak(text, start, !1);
                if (cat(text.slice(prev, start)) != CharCategory.Word) break;
                start = prev;
            }
            for (;end < length; ) {
                var next = findClusterBreak(text, end);
                if (cat(text.slice(end, next)) != CharCategory.Word) break;
                end = next;
            }
            return start == end ? null : EditorSelection.range(start + from, end + from);
        }
    }
    function combineConfig(configs, defaults, combine = {}) {
        var config, result = {};
        for (config of configs) for (var key of Object.keys(config)) {
            var value = config[key], current = result[key];
            if (void 0 === current) result[key] = value; else if (current !== value && void 0 !== value) {
                if (!Object.hasOwnProperty.call(combine, key)) throw new Error("Config merge conflict for field " + key);
                result[key] = combine[key](current, value);
            }
        }
        for (let key in defaults) void 0 === result[key] && (result[key] = defaults[key]);
        return result;
    }
    EditorState.allowMultipleSelections = allowMultipleSelections, EditorState.tabSize = Facet.define({
        combine: values => values.length ? values[0] : 4
    }), EditorState.lineSeparator = lineSeparator, EditorState.readOnly = readOnly, 
    EditorState.phrases = Facet.define({
        compare(a, b) {
            var kA = Object.keys(a), kB = Object.keys(b);
            return kA.length == kB.length && kA.every(k => a[k] == b[k]);
        }
    }), EditorState.languageData = languageData, EditorState.changeFilter = changeFilter, 
    EditorState.transactionFilter = transactionFilter, EditorState.transactionExtender = transactionExtender, 
    Compartment.reconfigure = StateEffect.define();
    class RangeValue {
        eq(other) {
            return this == other;
        }
        range(from, to = from) {
            return Range$1.create(from, to, this);
        }
    }
    RangeValue.prototype.startSide = RangeValue.prototype.endSide = 0, RangeValue.prototype.point = !1, 
    RangeValue.prototype.mapMode = MapMode.TrackDel;
    let Range$1 = class Range {
        constructor(from, to, value) {
            this.from = from, this.to = to, this.value = value;
        }
        static create(from, to, value) {
            return new Range(from, to, value);
        }
    };
    function cmpRange(a, b) {
        return a.from - b.from || a.value.startSide - b.value.startSide;
    }
    class Chunk {
        constructor(from, to, value, maxPoint) {
            this.from = from, this.to = to, this.value = value, this.maxPoint = maxPoint;
        }
        get length() {
            return this.to[this.to.length - 1];
        }
        findIndex(pos, side, end, startAt = 0) {
            var arr = end ? this.to : this.from;
            for (let lo = startAt, hi = arr.length; ;) {
                if (lo == hi) return lo;
                var mid = lo + hi >> 1, diff = arr[mid] - pos || (end ? this.value[mid].endSide : this.value[mid].startSide) - side;
                if (mid == lo) return 0 <= diff ? lo : hi;
                0 <= diff ? hi = mid : lo = 1 + mid;
            }
        }
        between(offset, from, to, f) {
            for (let i = this.findIndex(from, -1e9, !0), e = this.findIndex(to, 1e9, !1, i); i < e; i++) if (!1 === f(this.from[i] + offset, this.to[i] + offset, this.value[i])) return !1;
        }
        map(offset, changes) {
            let value = [], from = [], to = [], newPos = -1, maxPoint = -1;
            for (let i = 0; i < this.value.length; i++) {
                let val = this.value[i], curFrom = this.from[i] + offset, curTo = this.to[i] + offset, newFrom, newTo;
                if (curFrom == curTo) {
                    var mapped = changes.mapPos(curFrom, val.startSide, val.mapMode);
                    if (null == mapped) continue;
                    if (newFrom = newTo = mapped, val.startSide != val.endSide && (newTo = changes.mapPos(curFrom, val.endSide)) < newFrom) continue;
                } else if (newFrom = changes.mapPos(curFrom, val.startSide), newTo = changes.mapPos(curTo, val.endSide), 
                newFrom > newTo || newFrom == newTo && 0 < val.startSide && val.endSide <= 0) continue;
                (newTo - newFrom || val.endSide - val.startSide) < 0 || (newPos < 0 && (newPos = newFrom), 
                val.point && (maxPoint = Math.max(maxPoint, newTo - newFrom)), value.push(val), 
                from.push(newFrom - newPos), to.push(newTo - newPos));
            }
            return {
                mapped: value.length ? new Chunk(from, to, value, maxPoint) : null,
                pos: newPos
            };
        }
    }
    class RangeSet {
        constructor(chunkPos, chunk, nextLayer, maxPoint) {
            this.chunkPos = chunkPos, this.chunk = chunk, this.nextLayer = nextLayer, 
            this.maxPoint = maxPoint;
        }
        static create(chunkPos, chunk, nextLayer, maxPoint) {
            return new RangeSet(chunkPos, chunk, nextLayer, maxPoint);
        }
        get length() {
            var last = this.chunk.length - 1;
            return last < 0 ? 0 : Math.max(this.chunkEnd(last), this.nextLayer.length);
        }
        get size() {
            if (this.isEmpty) return 0;
            let size = this.nextLayer.size;
            for (var chunk of this.chunk) size += chunk.value.length;
            return size;
        }
        chunkEnd(index) {
            return this.chunkPos[index] + this.chunk[index].length;
        }
        update(updateSpec) {
            let {
                add = [],
                sort = !1,
                filterFrom = 0,
                filterTo = this.length
            } = updateSpec;
            var filter = updateSpec.filter;
            if (0 == add.length && !filter) return this;
            if (sort && (add = add.slice().sort(cmpRange)), this.isEmpty) return add.length ? RangeSet.of(add) : this;
            let cur = new LayerCursor(this, null, -1).goto(0), i = 0, spill = [];
            for (var range, builder = new RangeSetBuilder(); cur.value || i < add.length; ) i < add.length && 0 <= (cur.from - add[i].from || cur.startSide - add[i].value.startSide) ? (range = add[i++], 
            builder.addInner(range.from, range.to, range.value) || spill.push(range)) : 1 == cur.rangeIndex && cur.chunkIndex < this.chunk.length && (i == add.length || this.chunkEnd(cur.chunkIndex) < add[i].from) && (!filter || filterFrom > this.chunkEnd(cur.chunkIndex) || filterTo < this.chunkPos[cur.chunkIndex]) && builder.addChunk(this.chunkPos[cur.chunkIndex], this.chunk[cur.chunkIndex]) ? cur.nextChunk() : ((!filter || filterFrom > cur.to || filterTo < cur.from || filter(cur.from, cur.to, cur.value)) && !builder.addInner(cur.from, cur.to, cur.value) && spill.push(Range$1.create(cur.from, cur.to, cur.value)), 
            cur.next());
            return builder.finishInner(this.nextLayer.isEmpty && !spill.length ? RangeSet.empty : this.nextLayer.update({
                add: spill,
                filter: filter,
                filterFrom: filterFrom,
                filterTo: filterTo
            }));
        }
        map(changes) {
            if (changes.empty || this.isEmpty) return this;
            let chunks = [], chunkPos = [], maxPoint = -1;
            for (let i = 0; i < this.chunk.length; i++) {
                var start = this.chunkPos[i], chunk = this.chunk[i], touch = changes.touchesRange(start, start + chunk.length);
                !1 === touch ? (maxPoint = Math.max(maxPoint, chunk.maxPoint), chunks.push(chunk), 
                chunkPos.push(changes.mapPos(start))) : !0 === touch && ({
                    mapped: touch,
                    pos: chunk
                } = chunk.map(start, changes), touch) && (maxPoint = Math.max(maxPoint, touch.maxPoint), 
                chunks.push(touch), chunkPos.push(chunk));
            }
            var next = this.nextLayer.map(changes);
            return 0 == chunks.length ? next : new RangeSet(chunkPos, chunks, next || RangeSet.empty, maxPoint);
        }
        between(from, to, f) {
            if (!this.isEmpty) {
                for (let i = 0; i < this.chunk.length; i++) {
                    var start = this.chunkPos[i], chunk = this.chunk[i];
                    if (start <= to && from <= start + chunk.length && !1 === chunk.between(start, from - start, to - start, f)) return;
                }
                this.nextLayer.between(from, to, f);
            }
        }
        iter(from = 0) {
            return HeapCursor.from([ this ]).goto(from);
        }
        get isEmpty() {
            return this.nextLayer == this;
        }
        static iter(sets, from = 0) {
            return HeapCursor.from(sets).goto(from);
        }
        static compare(oldSets, newSets, textDiff, comparator, minPointSize = -1) {
            var oldSets = oldSets.filter(set => 0 < set.maxPoint || !set.isEmpty && set.maxPoint >= minPointSize), newSets = newSets.filter(set => 0 < set.maxPoint || !set.isEmpty && set.maxPoint >= minPointSize), sharedChunks = findSharedChunks(oldSets, newSets, textDiff);
            let sideA = new SpanCursor(oldSets, sharedChunks, minPointSize), sideB = new SpanCursor(newSets, sharedChunks, minPointSize);
            textDiff.iterGaps((fromA, fromB, length) => compare(sideA, fromA, sideB, fromB, length, comparator)), 
            textDiff.empty && 0 == textDiff.length && compare(sideA, 0, sideB, 0, 0, comparator);
        }
        static eq(oldSets, newSets, from = 0, to) {
            null == to && (to = 1e9 - 1);
            var a = oldSets.filter(set => !set.isEmpty && newSets.indexOf(set) < 0), b = newSets.filter(set => !set.isEmpty && oldSets.indexOf(set) < 0);
            if (a.length != b.length) return !1;
            if (!a.length) return !0;
            for (var sharedChunks = findSharedChunks(a, b), sideA = new SpanCursor(a, sharedChunks, 0).goto(from), sideB = new SpanCursor(b, sharedChunks, 0).goto(from); ;) {
                if (sideA.to != sideB.to || !sameValues(sideA.active, sideB.active) || sideA.point && (!sideB.point || !sideA.point.eq(sideB.point))) return !1;
                if (sideA.to > to) return !0;
                sideA.next(), sideB.next();
            }
        }
        static spans(sets, from, to, iterator, minPointSize = -1) {
            let cursor = new SpanCursor(sets, null, minPointSize).goto(from), pos = from, openRanges = cursor.openStart;
            for (;;) {
                var active, openCount, curTo = Math.min(cursor.to, to);
                if (cursor.point ? (active = cursor.activeForPoint(cursor.to), openCount = cursor.pointFrom < from ? active.length + 1 : cursor.point.startSide < 0 ? active.length : Math.min(active.length, openRanges), 
                iterator.point(pos, curTo, cursor.point, active, openCount, cursor.pointRank), 
                openRanges = Math.min(cursor.openEnd(curTo), active.length)) : curTo > pos && (iterator.span(pos, curTo, cursor.active, openRanges), 
                openRanges = cursor.openEnd(curTo)), cursor.to > to) return openRanges + (cursor.point && cursor.to > to ? 1 : 0);
                pos = cursor.to, cursor.next();
            }
        }
        static of(ranges, sort = !1) {
            var range, build = new RangeSetBuilder();
            for (range of ranges instanceof Range$1 ? [ ranges ] : sort ? function(ranges) {
                if (1 < ranges.length) for (let prev = ranges[0], i = 1; i < ranges.length; i++) {
                    var cur = ranges[i];
                    if (0 < cmpRange(prev, cur)) return ranges.slice().sort(cmpRange);
                    prev = cur;
                }
                return ranges;
            }(ranges) : ranges) build.add(range.from, range.to, range.value);
            return build.finish();
        }
        static join(sets) {
            if (!sets.length) return RangeSet.empty;
            let result = sets[sets.length - 1];
            for (let i = sets.length - 2; 0 <= i; i--) for (let layer = sets[i]; layer != RangeSet.empty; layer = layer.nextLayer) result = new RangeSet(layer.chunkPos, layer.chunk, result, Math.max(layer.maxPoint, result.maxPoint));
            return result;
        }
    }
    RangeSet.empty = new RangeSet([], [], null, -1), RangeSet.empty.nextLayer = RangeSet.empty;
    class RangeSetBuilder {
        finishChunk(newArrays) {
            this.chunks.push(new Chunk(this.from, this.to, this.value, this.maxPoint)), 
            this.chunkPos.push(this.chunkStart), this.chunkStart = -1, this.setMaxPoint = Math.max(this.setMaxPoint, this.maxPoint), 
            this.maxPoint = -1, newArrays && (this.from = [], this.to = [], this.value = []);
        }
        constructor() {
            this.chunks = [], this.chunkPos = [], this.chunkStart = -1, this.last = null, 
            this.lastFrom = -1e9, this.lastTo = -1e9, this.from = [], this.to = [], 
            this.value = [], this.maxPoint = -1, this.setMaxPoint = -1, this.nextLayer = null;
        }
        add(from, to, value) {
            this.addInner(from, to, value) || (this.nextLayer || (this.nextLayer = new RangeSetBuilder())).add(from, to, value);
        }
        addInner(from, to, value) {
            var diff = from - this.lastTo || value.startSide - this.last.endSide;
            if (diff <= 0 && (from - this.lastFrom || value.startSide - this.last.startSide) < 0) throw new Error("Ranges must be added sorted by `from` position and `startSide`");
            return !(diff < 0 || (250 == this.from.length && this.finishChunk(!0), 
            this.chunkStart < 0 && (this.chunkStart = from), this.from.push(from - this.chunkStart), 
            this.to.push(to - this.chunkStart), this.last = value, this.lastFrom = from, 
            this.lastTo = to, this.value.push(value), value.point && (this.maxPoint = Math.max(this.maxPoint, to - from)), 
            0));
        }
        addChunk(from, chunk) {
            if ((from - this.lastTo || chunk.value[0].startSide - this.last.endSide) < 0) return !1;
            this.from.length && this.finishChunk(!0), this.setMaxPoint = Math.max(this.setMaxPoint, chunk.maxPoint), 
            this.chunks.push(chunk), this.chunkPos.push(from);
            var last = chunk.value.length - 1;
            return this.last = chunk.value[last], this.lastFrom = chunk.from[last] + from, 
            this.lastTo = chunk.to[last] + from, !0;
        }
        finish() {
            return this.finishInner(RangeSet.empty);
        }
        finishInner(next) {
            return this.from.length && this.finishChunk(!1), 0 == this.chunks.length || (next = RangeSet.create(this.chunkPos, this.chunks, this.nextLayer ? this.nextLayer.finishInner(next) : next, this.setMaxPoint), 
            this.from = null), next;
        }
    }
    function findSharedChunks(a, b, textDiff) {
        var set, inA = new Map();
        for (set of a) for (let i = 0; i < set.chunk.length; i++) set.chunk[i].maxPoint <= 0 && inA.set(set.chunk[i], set.chunkPos[i]);
        var shared = new Set();
        for (let set of b) for (let i = 0; i < set.chunk.length; i++) {
            var known = inA.get(set.chunk[i]);
            null == known || (textDiff ? textDiff.mapPos(known) : known) != set.chunkPos[i] || null != textDiff && textDiff.touchesRange(known, known + set.chunk[i].length) || shared.add(set.chunk[i]);
        }
        return shared;
    }
    class LayerCursor {
        constructor(layer, skip, minPoint, rank = 0) {
            this.layer = layer, this.skip = skip, this.minPoint = minPoint, this.rank = rank;
        }
        get startSide() {
            return this.value ? this.value.startSide : 0;
        }
        get endSide() {
            return this.value ? this.value.endSide : 0;
        }
        goto(pos, side = -1e9) {
            return this.chunkIndex = this.rangeIndex = 0, this.gotoInner(pos, side, !1), 
            this;
        }
        gotoInner(pos, side, forward) {
            for (;this.chunkIndex < this.layer.chunk.length; ) {
                var next = this.layer.chunk[this.chunkIndex];
                if (!(this.skip && this.skip.has(next) || this.layer.chunkEnd(this.chunkIndex) < pos || next.maxPoint < this.minPoint)) break;
                this.chunkIndex++, forward = !1;
            }
            this.chunkIndex < this.layer.chunk.length && (side = this.layer.chunk[this.chunkIndex].findIndex(pos - this.layer.chunkPos[this.chunkIndex], side, !0), 
            !forward || this.rangeIndex < side) && this.setRangeIndex(side), this.next();
        }
        forward(pos, side) {
            (this.to - pos || this.endSide - side) < 0 && this.gotoInner(pos, side, !0);
        }
        next() {
            for (;;) {
                if (this.chunkIndex == this.layer.chunk.length) {
                    this.from = this.to = 1e9, this.value = null;
                    break;
                }
                var chunkPos = this.layer.chunkPos[this.chunkIndex], chunk = this.layer.chunk[this.chunkIndex], from = chunkPos + chunk.from[this.rangeIndex];
                if (this.from = from, this.to = chunkPos + chunk.to[this.rangeIndex], 
                this.value = chunk.value[this.rangeIndex], this.setRangeIndex(this.rangeIndex + 1), 
                this.minPoint < 0 || this.value.point && this.to - this.from >= this.minPoint) break;
            }
        }
        setRangeIndex(index) {
            if (index == this.layer.chunk[this.chunkIndex].value.length) {
                if (this.chunkIndex++, this.skip) for (;this.chunkIndex < this.layer.chunk.length && this.skip.has(this.layer.chunk[this.chunkIndex]); ) this.chunkIndex++;
                this.rangeIndex = 0;
            } else this.rangeIndex = index;
        }
        nextChunk() {
            this.chunkIndex++, this.rangeIndex = 0, this.next();
        }
        compare(other) {
            return this.from - other.from || this.startSide - other.startSide || this.rank - other.rank || this.to - other.to || this.endSide - other.endSide;
        }
    }
    class HeapCursor {
        constructor(heap) {
            this.heap = heap;
        }
        static from(sets, skip = null, minPoint = -1) {
            var heap = [];
            for (let i = 0; i < sets.length; i++) for (let cur = sets[i]; !cur.isEmpty; cur = cur.nextLayer) cur.maxPoint >= minPoint && heap.push(new LayerCursor(cur, skip, minPoint, i));
            return 1 == heap.length ? heap[0] : new HeapCursor(heap);
        }
        get startSide() {
            return this.value ? this.value.startSide : 0;
        }
        goto(pos, side = -1e9) {
            for (var cur of this.heap) cur.goto(pos, side);
            for (let i = this.heap.length >> 1; 0 <= i; i--) heapBubble(this.heap, i);
            return this.next(), this;
        }
        forward(pos, side) {
            for (var cur of this.heap) cur.forward(pos, side);
            for (let i = this.heap.length >> 1; 0 <= i; i--) heapBubble(this.heap, i);
            (this.to - pos || this.value.endSide - side) < 0 && this.next();
        }
        next() {
            var top;
            0 == this.heap.length ? (this.from = this.to = 1e9, this.value = null, 
            this.rank = -1) : (top = this.heap[0], this.from = top.from, this.to = top.to, 
            this.value = top.value, this.rank = top.rank, top.value && top.next(), 
            heapBubble(this.heap, 0));
        }
    }
    function heapBubble(heap, index) {
        for (var cur = heap[index]; ;) {
            let childIndex = 1 + (index << 1);
            if (childIndex >= heap.length) break;
            let child = heap[childIndex];
            if (childIndex + 1 < heap.length && 0 <= child.compare(heap[childIndex + 1]) && (child = heap[childIndex + 1], 
            childIndex++), cur.compare(child) < 0) break;
            heap[childIndex] = cur, heap[index] = child, index = childIndex;
        }
    }
    class SpanCursor {
        constructor(sets, skip, minPoint) {
            this.minPoint = minPoint, this.active = [], this.activeTo = [], this.activeRank = [], 
            this.minActive = -1, this.point = null, this.pointFrom = 0, this.pointRank = 0, 
            this.to = -1e9, this.endSide = 0, this.openStart = -1, this.cursor = HeapCursor.from(sets, skip, minPoint);
        }
        goto(pos, side = -1e9) {
            return this.cursor.goto(pos, side), this.active.length = this.activeTo.length = this.activeRank.length = 0, 
            this.minActive = -1, this.to = pos, this.endSide = side, this.openStart = -1, 
            this.next(), this;
        }
        forward(pos, side) {
            for (;-1 < this.minActive && (this.activeTo[this.minActive] - pos || this.active[this.minActive].endSide - side) < 0; ) this.removeActive(this.minActive);
            this.cursor.forward(pos, side);
        }
        removeActive(index) {
            remove(this.active, index), remove(this.activeTo, index), remove(this.activeRank, index), 
            this.minActive = findMinIndex(this.active, this.activeTo);
        }
        addActive(trackOpen) {
            let i = 0, {
                value,
                to,
                rank
            } = this.cursor;
            for (;i < this.activeRank.length && 0 < (rank - this.activeRank[i] || to - this.activeTo[i]); ) i++;
            insert(this.active, i, value), insert(this.activeTo, i, to), insert(this.activeRank, i, rank), 
            trackOpen && insert(trackOpen, i, this.cursor.from), this.minActive = findMinIndex(this.active, this.activeTo);
        }
        next() {
            for (var from = this.to, wasPoint = this.point, trackOpen = (this.point = null, 
            this.openStart < 0 ? [] : null); ;) {
                var a = this.minActive;
                if (-1 < a && (this.activeTo[a] - this.cursor.from || this.active[a].endSide - this.cursor.startSide) < 0) {
                    if (this.activeTo[a] > from) {
                        this.to = this.activeTo[a], this.endSide = this.active[a].endSide;
                        break;
                    }
                    this.removeActive(a), trackOpen && remove(trackOpen, a);
                } else {
                    if (!this.cursor.value) {
                        this.to = this.endSide = 1e9;
                        break;
                    }
                    if (this.cursor.from > from) {
                        this.to = this.cursor.from, this.endSide = this.cursor.startSide;
                        break;
                    }
                    a = this.cursor.value;
                    if (a.point) {
                        if (!(wasPoint && this.cursor.to == this.to && this.cursor.from < this.cursor.to)) {
                            this.point = a, this.pointFrom = this.cursor.from, this.pointRank = this.cursor.rank, 
                            this.to = this.cursor.to, this.endSide = a.endSide, 
                            this.cursor.next(), this.forward(this.to, this.endSide);
                            break;
                        }
                    } else this.addActive(trackOpen);
                    this.cursor.next();
                }
            }
            if (trackOpen) {
                this.openStart = 0;
                for (let i = trackOpen.length - 1; 0 <= i && trackOpen[i] < from; i--) this.openStart++;
            }
        }
        activeForPoint(to) {
            if (!this.active.length) return this.active;
            var active = [];
            for (let i = this.active.length - 1; 0 <= i && !(this.activeRank[i] < this.pointRank); i--) (this.activeTo[i] > to || this.activeTo[i] == to && this.active[i].endSide >= this.point.endSide) && active.push(this.active[i]);
            return active.reverse();
        }
        openEnd(to) {
            let open = 0;
            for (let i = this.activeTo.length - 1; 0 <= i && this.activeTo[i] > to; i--) open++;
            return open;
        }
    }
    function compare(a, startA, b, startB, length, comparator) {
        a.goto(startA), b.goto(startB);
        var endB = startB + length;
        let pos = startB, dPos = startB - startA;
        for (;;) {
            var diff = a.to + dPos - b.to || a.endSide - b.endSide, end = diff < 0 ? a.to + dPos : b.to, clipEnd = Math.min(end, endB);
            if (a.point || b.point ? a.point && b.point && (a.point == b.point || a.point.eq(b.point)) && sameValues(a.activeForPoint(a.to), b.activeForPoint(b.to)) || comparator.comparePoint(pos, clipEnd, a.point, b.point) : clipEnd > pos && !sameValues(a.active, b.active) && comparator.compareRange(pos, clipEnd, a.active, b.active), 
            endB < end) break;
            pos = end, diff <= 0 && a.next(), 0 <= diff && b.next();
        }
    }
    function sameValues(a, b) {
        if (a.length == b.length) {
            for (let i = 0; i < a.length; i++) if (a[i] != b[i] && !a[i].eq(b[i])) return;
            return 1;
        }
    }
    function remove(array, index) {
        for (let i = index, e = array.length - 1; i < e; i++) array[i] = array[i + 1];
        array.pop();
    }
    function insert(array, index, value) {
        for (let i = array.length - 1; i >= index; i--) array[i + 1] = array[i];
        array[index] = value;
    }
    function findMinIndex(value, array) {
        let found = -1, foundPos = 1e9;
        for (let i = 0; i < array.length; i++) (array[i] - foundPos || value[i].endSide - value[found].endSide) < 0 && (found = i, 
        foundPos = array[i]);
        return found;
    }
    function countColumn(string, tabSize, to = string.length) {
        let n = 0;
        for (let i = 0; i < to; ) 9 == string.charCodeAt(i) ? (n += tabSize - n % tabSize, 
        i++) : (n++, i = findClusterBreak(string, i));
        return n;
    }
    function findColumn(string, col, tabSize, strict) {
        for (let i = 0, n = 0; ;) {
            if (n >= col) return i;
            if (i == string.length) break;
            n += 9 == string.charCodeAt(i) ? tabSize - n % tabSize : 1, i = findClusterBreak(string, i);
        }
        return !0 === strict ? -1 : string.length;
    }
    const COUNT = "undefined" == typeof Symbol ? "__\u037c" : Symbol.for("\u037c"), SET = "undefined" == typeof Symbol ? "__styleSet" + Math.floor(1e8 * Math.random()) : Symbol("styleSet"), top = "undefined" != typeof globalThis ? globalThis : "undefined" != typeof window ? window : {};
    class StyleModule {
        constructor(spec, options) {
            this.rules = [];
            let finish = (options || {})["finish"];
            function splitSelector(selector) {
                return /^@/.test(selector) ? [ selector ] : selector.split(/,\s*/);
            }
            for (var prop in spec) !function render(selectors, spec, target, isKeyframes) {
                var prop, local = [], isAt = /^@(\w+)\b/.exec(selectors[0]), keyframes = isAt && "keyframes" == isAt[1];
                if (isAt && null == spec) return target.push(selectors[0] + ";");
                for (prop in spec) {
                    var value = spec[prop];
                    if (/&/.test(prop)) render(prop.split(/,\s*/).map(part => selectors.map(sel => part.replace(/&/, sel))).reduce((a, b) => a.concat(b)), value, target); else if (value && "object" == typeof value) {
                        if (!isAt) throw new RangeError("The value of a property (" + prop + ") should be a primitive value.");
                        render(splitSelector(prop), value, local, keyframes);
                    } else null != value && local.push(prop.replace(/_.*/, "").replace(/[A-Z]/g, l => "-" + l.toLowerCase()) + ": " + value + ";");
                }
                (local.length || keyframes) && target.push((!finish || isAt || isKeyframes ? selectors : selectors.map(finish)).join(", ") + " {" + local.join(" ") + "}");
            }(splitSelector(prop), spec[prop], this.rules);
        }
        getRules() {
            return this.rules.join("\n");
        }
        static newName() {
            var id = top[COUNT] || 1;
            return top[COUNT] = id + 1, "\u037c" + id.toString(36);
        }
        static mount(root, modules, options) {
            let set = root[SET], nonce = options && options.nonce;
            set ? nonce && set.setNonce(nonce) : set = new StyleSet(root, nonce), 
            set.mount(Array.isArray(modules) ? modules : [ modules ], root);
        }
    }
    let adoptedSet = new Map();
    class StyleSet {
        constructor(root, nonce) {
            var doc = root.ownerDocument || root, win = doc.defaultView;
            if (!root.head && root.adoptedStyleSheets && win.CSSStyleSheet) {
                var adopted = adoptedSet.get(doc);
                if (adopted) return root[SET] = adopted;
                this.sheet = new win.CSSStyleSheet(), adoptedSet.set(doc, this);
            } else this.styleTag = doc.createElement("style"), nonce && this.styleTag.setAttribute("nonce", nonce);
            this.modules = [], root[SET] = this;
        }
        mount(modules, root) {
            var sheet = this.sheet;
            let pos = 0, j = 0;
            for (let i = 0; i < modules.length; i++) {
                let mod = modules[i], index = this.modules.indexOf(mod);
                if (index < j && -1 < index && (this.modules.splice(index, 1), j--, 
                index = -1), -1 == index) {
                    if (this.modules.splice(j++, 0, mod), sheet) for (let k = 0; k < mod.rules.length; k++) sheet.insertRule(mod.rules[k], pos++);
                } else {
                    for (;j < index; ) pos += this.modules[j++].rules.length;
                    pos += mod.rules.length, j++;
                }
            }
            if (sheet) root.adoptedStyleSheets.indexOf(this.sheet) < 0 && (root.adoptedStyleSheets = [ this.sheet, ...root.adoptedStyleSheets ]); else {
                let text = "";
                for (let i = 0; i < this.modules.length; i++) text += this.modules[i].getRules() + "\n";
                this.styleTag.textContent = text;
                root = root.head || root;
                this.styleTag.parentNode != root && root.insertBefore(this.styleTag, root.firstChild);
            }
        }
        setNonce(nonce) {
            this.styleTag && this.styleTag.getAttribute("nonce") != nonce && this.styleTag.setAttribute("nonce", nonce);
        }
    }
    for (var base = {
        8: "Backspace",
        9: "Tab",
        10: "Enter",
        12: "NumLock",
        13: "Enter",
        16: "Shift",
        17: "Control",
        18: "Alt",
        20: "CapsLock",
        27: "Escape",
        32: " ",
        33: "PageUp",
        34: "PageDown",
        35: "End",
        36: "Home",
        37: "ArrowLeft",
        38: "ArrowUp",
        39: "ArrowRight",
        40: "ArrowDown",
        44: "PrintScreen",
        45: "Insert",
        46: "Delete",
        59: ";",
        61: "=",
        91: "Meta",
        92: "Meta",
        106: "*",
        107: "+",
        108: ",",
        109: "-",
        110: ".",
        111: "/",
        144: "NumLock",
        145: "ScrollLock",
        160: "Shift",
        161: "Shift",
        162: "Control",
        163: "Control",
        164: "Alt",
        165: "Alt",
        173: "-",
        186: ";",
        187: "=",
        188: ",",
        189: "-",
        190: ".",
        191: "/",
        192: "`",
        219: "[",
        220: "\\",
        221: "]",
        222: "'"
    }, shift = {
        48: ")",
        49: "!",
        50: "@",
        51: "#",
        52: "$",
        53: "%",
        54: "^",
        55: "&",
        56: "*",
        57: "(",
        59: ":",
        61: "+",
        173: "_",
        186: ":",
        187: "+",
        188: "<",
        189: "_",
        190: ">",
        191: "?",
        192: "~",
        219: "{",
        220: "|",
        221: "}",
        222: '"'
    }, mac = "undefined" != typeof navigator && /Mac/.test(navigator.platform), ie$1 = "undefined" != typeof navigator && /MSIE \d|Trident\/(?:[7-9]|\d{2,})\..*rv:(\d+)/.exec(navigator.userAgent), i = 0; i < 10; i++) base[48 + i] = base[96 + i] = String(i);
    for (i = 1; i <= 24; i++) base[i + 111] = "F" + i;
    for (var code, i = 65; i <= 90; i++) base[i] = String.fromCharCode(i + 32), 
    shift[i] = String.fromCharCode(i);
    for (code in base) shift.hasOwnProperty(code) || (shift[code] = base[code]);
    function getSelection(root) {
        let target;
        return (target = 11 != root.nodeType || root.getSelection ? root : root.ownerDocument).getSelection();
    }
    function contains(dom, node) {
        return !!node && (dom == node || dom.contains(1 != node.nodeType ? node.parentNode : node));
    }
    function hasSelection(dom, selection) {
        if (!selection.anchorNode) return !1;
        try {
            return contains(dom, selection.anchorNode);
        } catch (_) {
            return !1;
        }
    }
    function clientRectsFor(dom) {
        return 3 == dom.nodeType ? textRange(dom, 0, dom.nodeValue.length).getClientRects() : 1 == dom.nodeType ? dom.getClientRects() : [];
    }
    function isEquivalentPosition(node, off, targetNode, targetOff) {
        return !!targetNode && (scanFor(node, off, targetNode, targetOff, -1) || scanFor(node, off, targetNode, targetOff, 1));
    }
    function domIndex(node) {
        for (var index = 0; ;index++) if (!(node = node.previousSibling)) return index;
    }
    function isBlockElement(node) {
        return 1 == node.nodeType && /^(DIV|P|LI|UL|OL|BLOCKQUOTE|DD|DT|H\d|SECTION|PRE)$/.test(node.nodeName);
    }
    function scanFor(node, off, targetNode, targetOff, dir) {
        for (;;) {
            if (node == targetNode && off == targetOff) return !0;
            if (off == (dir < 0 ? 0 : maxOffset(node))) {
                if ("DIV" == node.nodeName) return !1;
                var parent = node.parentNode;
                if (!parent || 1 != parent.nodeType) return !1;
                off = domIndex(node) + (dir < 0 ? 0 : 1), node = parent;
            } else {
                if (1 != node.nodeType) return !1;
                if (1 == (node = node.childNodes[off + (dir < 0 ? -1 : 0)]).nodeType && "false" == node.contentEditable) return !1;
                off = dir < 0 ? maxOffset(node) : 0;
            }
        }
    }
    function maxOffset(node) {
        return (3 == node.nodeType ? node.nodeValue : node.childNodes).length;
    }
    function flattenRect(rect, left) {
        left = left ? rect.left : rect.right;
        return {
            left: left,
            right: left,
            top: rect.top,
            bottom: rect.bottom
        };
    }
    function getScale(elt, rect) {
        let scaleX = rect.width / elt.offsetWidth, scaleY = rect.height / elt.offsetHeight;
        return (.995 < scaleX && scaleX < 1.005 || !isFinite(scaleX) || Math.abs(rect.width - elt.offsetWidth) < 1) && (scaleX = 1), 
        (.995 < scaleY && scaleY < 1.005 || !isFinite(scaleY) || Math.abs(rect.height - elt.offsetHeight) < 1) && (scaleY = 1), 
        {
            scaleX: scaleX,
            scaleY: scaleY
        };
    }
    function scrollRectIntoView(dom, rect, side, x, y, xMargin, yMargin, ltr) {
        var boundingHeight, rectHeight, doc = dom.ownerDocument, win = doc.defaultView || window;
        for (let cur = dom, stop = !1; cur && !stop; ) if (1 == cur.nodeType) {
            let bounding, top = cur == doc.body, scaleX = 1, scaleY = 1;
            if (top) bounding = function(win) {
                var vp = win.visualViewport;
                return vp ? {
                    left: 0,
                    right: vp.width,
                    top: 0,
                    bottom: vp.height
                } : {
                    left: 0,
                    right: win.innerWidth,
                    top: 0,
                    bottom: win.innerHeight
                };
            }(win); else {
                if (/^(fixed|sticky)$/.test(getComputedStyle(cur).position) && (stop = !0), 
                cur.scrollHeight <= cur.clientHeight && cur.scrollWidth <= cur.clientWidth) {
                    cur = cur.assignedSlot || cur.parentNode;
                    continue;
                }
                let rect = cur.getBoundingClientRect();
                ({
                    scaleX,
                    scaleY
                } = getScale(cur, rect)), bounding = {
                    left: rect.left,
                    right: rect.left + cur.clientWidth * scaleX,
                    top: rect.top,
                    bottom: rect.top + cur.clientHeight * scaleY
                };
            }
            let moveX = 0, moveY = 0;
            if ("nearest" == y ? rect.top < bounding.top ? (moveY = -(bounding.top - rect.top + yMargin), 
            0 < side && rect.bottom > bounding.bottom + moveY && (moveY = rect.bottom - bounding.bottom + moveY + yMargin)) : rect.bottom > bounding.bottom && (moveY = rect.bottom - bounding.bottom + yMargin, 
            side < 0) && rect.top - moveY < bounding.top && (moveY = -(bounding.top + moveY - rect.top + yMargin)) : (rectHeight = rect.bottom - rect.top, 
            boundingHeight = bounding.bottom - bounding.top, rectHeight = "center" == y && rectHeight <= boundingHeight ? rect.top + rectHeight / 2 - boundingHeight / 2 : "start" == y || "center" == y && side < 0 ? rect.top - yMargin : rect.bottom - boundingHeight + yMargin, 
            moveY = rectHeight - bounding.top), "nearest" == x ? rect.left < bounding.left ? (moveX = -(bounding.left - rect.left + xMargin), 
            0 < side && rect.right > bounding.right + moveX && (moveX = rect.right - bounding.right + moveX + xMargin)) : rect.right > bounding.right && (moveX = rect.right - bounding.right + xMargin, 
            side < 0) && rect.left < bounding.left + moveX && (moveX = -(bounding.left + moveX - rect.left + xMargin)) : (boundingHeight = "center" == x ? rect.left + (rect.right - rect.left) / 2 - (bounding.right - bounding.left) / 2 : "start" == x == ltr ? rect.left - xMargin : rect.right - (bounding.right - bounding.left) + xMargin, 
            moveX = boundingHeight - bounding.left), moveX || moveY) if (top) win.scrollBy(moveX, moveY); else {
                let movedX = 0, movedY = 0;
                if (moveY && (rectHeight = cur.scrollTop, cur.scrollTop += moveY / scaleY, 
                movedY = (cur.scrollTop - rectHeight) * scaleY), moveX) {
                    let start = cur.scrollLeft;
                    cur.scrollLeft += moveX / scaleX, movedX = (cur.scrollLeft - start) * scaleX;
                }
                rect = {
                    left: rect.left - movedX,
                    top: rect.top - movedY,
                    right: rect.right - movedX,
                    bottom: rect.bottom - movedY
                }, movedX && Math.abs(movedX - moveX) < 1 && (x = "nearest"), movedY && Math.abs(movedY - moveY) < 1 && (y = "nearest");
            }
            if (top) break;
            cur = cur.assignedSlot || cur.parentNode;
        } else {
            if (11 != cur.nodeType) break;
            cur = cur.host;
        }
    }
    class DOMSelectionState {
        constructor() {
            this.anchorNode = null, this.anchorOffset = 0, this.focusNode = null, 
            this.focusOffset = 0;
        }
        eq(domSel) {
            return this.anchorNode == domSel.anchorNode && this.anchorOffset == domSel.anchorOffset && this.focusNode == domSel.focusNode && this.focusOffset == domSel.focusOffset;
        }
        setRange(range) {
            var {
                anchorNode,
                focusNode
            } = range;
            this.set(anchorNode, Math.min(range.anchorOffset, anchorNode ? maxOffset(anchorNode) : 0), focusNode, Math.min(range.focusOffset, focusNode ? maxOffset(focusNode) : 0));
        }
        set(anchorNode, anchorOffset, focusNode, focusOffset) {
            this.anchorNode = anchorNode, this.anchorOffset = anchorOffset, this.focusNode = focusNode, 
            this.focusOffset = focusOffset;
        }
    }
    let preventScrollSupported = null;
    function focusPreventScroll(dom) {
        if (dom.setActive) return dom.setActive();
        if (preventScrollSupported) return dom.focus(preventScrollSupported);
        var stack = [];
        for (let cur = dom; cur && (stack.push(cur, cur.scrollTop, cur.scrollLeft), 
        cur != cur.ownerDocument); cur = cur.parentNode);
        if (dom.focus(null == preventScrollSupported ? {
            get preventScroll() {
                return preventScrollSupported = {
                    preventScroll: !0
                }, !0;
            }
        } : void 0), !preventScrollSupported) {
            preventScrollSupported = !1;
            for (let i = 0; i < stack.length; ) {
                var elt = stack[i++], top = stack[i++], left = stack[i++];
                elt.scrollTop != top && (elt.scrollTop = top), elt.scrollLeft != left && (elt.scrollLeft = left);
            }
        }
    }
    let scratchRange;
    function textRange(node, from, to = from) {
        var range = scratchRange = scratchRange || document.createRange();
        return range.setEnd(node, to), range.setStart(node, from), range;
    }
    function dispatchKey(elt, name, code, mods) {
        name = {
            key: name,
            code: name,
            keyCode: code,
            which: code,
            cancelable: !0
        }, mods && ({
            altKey: name.altKey,
            ctrlKey: name.ctrlKey,
            shiftKey: name.shiftKey,
            metaKey: name.metaKey
        } = mods), code = new KeyboardEvent("keydown", name), code.synthetic = !0, 
        elt.dispatchEvent(code), mods = new KeyboardEvent("keyup", name);
        return mods.synthetic = !0, elt.dispatchEvent(mods), code.defaultPrevented || mods.defaultPrevented;
    }
    function clearAttributes(node) {
        for (;node.attributes.length; ) node.removeAttributeNode(node.attributes[0]);
    }
    function isScrolledToBottom(elt) {
        return elt.scrollTop > Math.max(1, elt.scrollHeight - elt.clientHeight - 4);
    }
    function textNodeBefore(startNode, startOffset) {
        for (let node = startNode, offset = startOffset; ;) {
            if (3 == node.nodeType && 0 < offset) return {
                node: node,
                offset: offset
            };
            if (1 == node.nodeType && 0 < offset) {
                if ("false" == node.contentEditable) return null;
                node = node.childNodes[offset - 1], offset = maxOffset(node);
            } else {
                if (!node.parentNode || isBlockElement(node)) return null;
                offset = domIndex(node), node = node.parentNode;
            }
        }
    }
    function textNodeAfter(startNode, startOffset) {
        for (let node = startNode, offset = startOffset; ;) {
            if (3 == node.nodeType && offset < node.nodeValue.length) return {
                node: node,
                offset: offset
            };
            if (1 == node.nodeType && offset < node.childNodes.length) {
                if ("false" == node.contentEditable) return null;
                node = node.childNodes[offset], offset = 0;
            } else {
                if (!node.parentNode || isBlockElement(node)) return null;
                offset = domIndex(node) + 1, node = node.parentNode;
            }
        }
    }
    class DOMPos {
        constructor(node, offset, precise = !0) {
            this.node = node, this.offset = offset, this.precise = precise;
        }
        static before(dom, precise) {
            return new DOMPos(dom.parentNode, domIndex(dom), precise);
        }
        static after(dom, precise) {
            return new DOMPos(dom.parentNode, domIndex(dom) + 1, precise);
        }
    }
    const noChildren = [];
    class ContentView {
        constructor() {
            this.parent = null, this.dom = null, this.flags = 2;
        }
        get overrideDOMText() {
            return null;
        }
        get posAtStart() {
            return this.parent ? this.parent.posBefore(this) : 0;
        }
        get posAtEnd() {
            return this.posAtStart + this.length;
        }
        posBefore(view) {
            let pos = this.posAtStart;
            for (var child of this.children) {
                if (child == view) return pos;
                pos += child.length + child.breakAfter;
            }
            throw new RangeError("Invalid child in posBefore");
        }
        posAfter(view) {
            return this.posBefore(view) + view.length;
        }
        sync(view, track) {
            if (2 & this.flags) {
                var child, contentView, parent = this.dom;
                let prev = null, next;
                for (child of this.children) {
                    if (7 & child.flags && (child.dom || !(next = prev ? prev.nextSibling : parent.firstChild) || (contentView = ContentView.get(next)) && (contentView.parent || !contentView.canReuseDOM(child)) || child.reuseDOM(next), 
                    child.sync(view, track), child.flags &= -8), next = prev ? prev.nextSibling : parent.firstChild, 
                    track && !track.written && track.node == parent && next != child.dom && (track.written = !0), 
                    child.dom.parentNode == parent) for (;next && next != child.dom; ) next = rm$1(next); else parent.insertBefore(child.dom, next);
                    prev = child.dom;
                }
                for ((next = prev ? prev.nextSibling : parent.firstChild) && track && track.node == parent && (track.written = !0); next; ) next = rm$1(next);
            } else if (1 & this.flags) for (let child of this.children) 7 & child.flags && (child.sync(view, track), 
            child.flags &= -8);
        }
        reuseDOM(_dom) {}
        localPosFromDOM(node, offset) {
            let after;
            if (node == this.dom) after = this.dom.childNodes[offset]; else {
                let bias = 0 == maxOffset(node) ? 0 : 0 == offset ? -1 : 1;
                for (;;) {
                    var parent = node.parentNode;
                    if (parent == this.dom) break;
                    0 == bias && parent.firstChild != parent.lastChild && (bias = node == parent.firstChild ? -1 : 1), 
                    node = parent;
                }
                after = bias < 0 ? node : node.nextSibling;
            }
            if (after == this.dom.firstChild) return 0;
            for (;after && !ContentView.get(after); ) after = after.nextSibling;
            if (!after) return this.length;
            for (let i = 0, pos = 0; ;i++) {
                var child = this.children[i];
                if (child.dom == after) return pos;
                pos += child.length + child.breakAfter;
            }
        }
        domBoundsAround(from, to, offset = 0) {
            let fromI = -1, fromStart = -1, toI = -1, toEnd = -1;
            for (let i = 0, pos = offset, prevEnd = offset; i < this.children.length; i++) {
                var child = this.children[i], end = pos + child.length;
                if (pos < from && to < end) return child.domBoundsAround(from, to, pos);
                if (from <= end && -1 == fromI && (fromI = i, fromStart = pos), 
                pos > to && child.dom.parentNode == this.dom) {
                    toI = i, toEnd = prevEnd;
                    break;
                }
                prevEnd = end, pos = end + child.breakAfter;
            }
            return {
                from: fromStart,
                to: toEnd < 0 ? offset + this.length : toEnd,
                startDOM: (fromI ? this.children[fromI - 1].dom.nextSibling : null) || this.dom.firstChild,
                endDOM: toI < this.children.length && 0 <= toI ? this.children[toI].dom : null
            };
        }
        markDirty(andParent = !1) {
            this.flags |= 2, this.markParentsDirty(andParent);
        }
        markParentsDirty(childList) {
            for (let parent = this.parent; parent; parent = parent.parent) {
                if (childList && (parent.flags |= 2), 1 & parent.flags) return;
                parent.flags |= 1, childList = !1;
            }
        }
        setParent(parent) {
            this.parent != parent && (this.parent = parent, 7 & this.flags) && this.markParentsDirty(!0);
        }
        setDOM(dom) {
            this.dom != dom && (this.dom && (this.dom.cmView = null), (this.dom = dom).cmView = this);
        }
        get rootView() {
            for (let v = this; ;) {
                var parent = v.parent;
                if (!parent) return v;
                v = parent;
            }
        }
        replaceChildren(from, to, children = noChildren) {
            this.markDirty();
            for (let i = from; i < to; i++) {
                var child = this.children[i];
                child.parent == this && children.indexOf(child) < 0 && child.destroy();
            }
            this.children.splice(from, to - from, ...children);
            for (let i = 0; i < children.length; i++) children[i].setParent(this);
        }
        ignoreMutation(_rec) {
            return !1;
        }
        ignoreEvent(_event) {
            return !1;
        }
        childCursor(pos = this.length) {
            return new ChildCursor(this.children, pos, this.children.length);
        }
        childPos(pos, bias = 1) {
            return this.childCursor().findPos(pos, bias);
        }
        toString() {
            var name = this.constructor.name.replace("View", "");
            return name + (this.children.length ? "(" + this.children.join() + ")" : this.length ? "[" + ("Text" == name ? this.text : this.length) + "]" : "") + (this.breakAfter ? "#" : "");
        }
        static get(node) {
            return node.cmView;
        }
        get isEditable() {
            return !0;
        }
        get isWidget() {
            return !1;
        }
        get isHidden() {
            return !1;
        }
        merge(from, to, source, hasStart, openStart, openEnd) {
            return !1;
        }
        become(other) {
            return !1;
        }
        canReuseDOM(other) {
            return other.constructor == this.constructor && !(8 & (this.flags | other.flags));
        }
        getSide() {
            return 0;
        }
        destroy() {
            for (var child of this.children) child.parent == this && child.destroy();
            this.parent = null;
        }
    }
    function rm$1(dom) {
        var next = dom.nextSibling;
        return dom.parentNode.removeChild(dom), next;
    }
    ContentView.prototype.breakAfter = 0;
    class ChildCursor {
        constructor(children, pos, i) {
            this.children = children, this.pos = pos, this.i = i, this.off = 0;
        }
        findPos(pos, bias = 1) {
            for (;;) {
                if (pos > this.pos || pos == this.pos && (0 < bias || 0 == this.i || this.children[this.i - 1].breakAfter)) return this.off = pos - this.pos, 
                this;
                var next = this.children[--this.i];
                this.pos -= next.length + next.breakAfter;
            }
        }
    }
    function replaceRange(parent, fromI, fromOff, toI, toOff, insert, breakAtStart, openStart, openEnd) {
        var children = parent["children"], before = children.length ? children[fromI] : null, last = insert.length ? insert[insert.length - 1] : null, breakAtEnd = last ? last.breakAfter : breakAtStart;
        if (!(fromI == toI && before && !breakAtStart && !breakAtEnd && insert.length < 2 && before.merge(fromOff, toOff, insert.length ? last : null, 0 == fromOff, openStart, openEnd))) {
            if (toI < children.length) {
                let after = children[toI];
                after && (toOff < after.length || after.breakAfter && null != last && last.breakAfter) ? (fromI == toI && (after = after.split(toOff), 
                toOff = 0), !breakAtEnd && last && after.merge(0, toOff, last, !0, 0, openEnd) ? insert[insert.length - 1] = after : ((toOff || after.children.length && !after.children[0].length) && after.merge(0, toOff, null, !1, 0, openEnd), 
                insert.push(after))) : null !== after && void 0 !== after && after.breakAfter && (last ? last.breakAfter = 1 : breakAtStart = 1), 
                toI++;
            }
            for (before && (before.breakAfter = breakAtStart, 0 < fromOff) && (!breakAtStart && insert.length && before.merge(fromOff, before.length, insert[0], !1, openStart, 0) ? before.breakAfter = insert.shift().breakAfter : (fromOff < before.length || before.children.length && 0 == before.children[before.children.length - 1].length) && before.merge(fromOff, before.length, null, !1, openStart, 0), 
            fromI++); fromI < toI && insert.length; ) if (children[toI - 1].become(insert[insert.length - 1])) toI--, 
            insert.pop(), openEnd = insert.length ? 0 : openStart; else {
                if (!children[fromI].become(insert[0])) break;
                fromI++, insert.shift(), openStart = insert.length ? 0 : openEnd;
            }
            !insert.length && fromI && toI < children.length && !children[fromI - 1].breakAfter && children[toI].merge(0, 0, children[fromI - 1], !1, openStart, openEnd) && fromI--, 
            (fromI < toI || insert.length) && parent.replaceChildren(fromI, toI, insert);
        }
    }
    function mergeChildrenInto(parent, from, to, insert, openStart, openEnd) {
        var view, cur = parent.childCursor(), {
            i: toI,
            off: toOff
        } = cur.findPos(to, 1), {
            i: cur,
            off: fromOff
        } = cur.findPos(from, -1);
        let dLen = from - to;
        for (view of insert) dLen += view.length;
        parent.length += dLen, replaceRange(parent, cur, fromOff, toI, toOff, insert, 0, openStart, openEnd);
    }
    var nav = "undefined" != typeof navigator ? navigator : {
        userAgent: "",
        vendor: "",
        platform: ""
    }, doc = "undefined" != typeof document ? document : {
        documentElement: {
            style: {}
        }
    }, ie_edge = /Edge\/(\d+)/.exec(nav.userAgent), ie_upto10 = /MSIE \d/.test(nav.userAgent), ie_11up = /Trident\/(?:[7-9]|\d{2,})\..*rv:(\d+)/.exec(nav.userAgent), ie = !!(ie_upto10 || ie_11up || ie_edge), gecko = !ie && /gecko\/(\d+)/i.test(nav.userAgent), chrome = !ie && /Chrome\/(\d+)/.exec(nav.userAgent), webkit = "webkitFontSmoothing" in doc.documentElement.style, safari = !ie && /Apple Computer/.test(nav.vendor), ios = safari && (/Mobile\/\w+/.test(nav.userAgent) || 2 < nav.maxTouchPoints), browser = {
        mac: ios || /Mac/.test(nav.platform),
        windows: /Win/.test(nav.platform),
        linux: /Linux|X11/.test(nav.platform),
        ie: ie,
        ie_version: ie_upto10 ? doc.documentMode || 6 : ie_11up ? +ie_11up[1] : ie_edge ? +ie_edge[1] : 0,
        gecko: gecko,
        gecko_version: gecko ? +(/Firefox\/(\d+)/.exec(nav.userAgent) || [ 0, 0 ])[1] : 0,
        chrome: !!chrome,
        chrome_version: chrome ? +chrome[1] : 0,
        ios: ios,
        android: /Android\b/.test(nav.userAgent),
        webkit: webkit,
        safari: safari,
        webkit_version: webkit ? +(/\bAppleWebKit\/(\d+)/.exec(navigator.userAgent) || [ 0, 0 ])[1] : 0,
        tabSize: null != doc.documentElement.style.tabSize ? "tab-size" : "-moz-tab-size"
    };
    class TextView extends ContentView {
        constructor(text) {
            super(), this.text = text;
        }
        get length() {
            return this.text.length;
        }
        createDOM(textDOM) {
            this.setDOM(textDOM || document.createTextNode(this.text));
        }
        sync(view, track) {
            this.dom || this.createDOM(), this.dom.nodeValue != this.text && (track && track.node == this.dom && (track.written = !0), 
            this.dom.nodeValue = this.text);
        }
        reuseDOM(dom) {
            3 == dom.nodeType && this.createDOM(dom);
        }
        merge(from, to, source) {
            return !(8 & this.flags || source && (!(source instanceof TextView) || 256 < this.length - (to - from) + source.length || 8 & source.flags) || (this.text = this.text.slice(0, from) + (source ? source.text : "") + this.text.slice(to), 
            this.markDirty(), 0));
        }
        split(from) {
            var result = new TextView(this.text.slice(from));
            return this.text = this.text.slice(0, from), this.markDirty(), result.flags |= 8 & this.flags, 
            result;
        }
        localPosFromDOM(node, offset) {
            return node == this.dom ? offset : offset ? this.text.length : 0;
        }
        domAtPos(pos) {
            return new DOMPos(this.dom, pos);
        }
        domBoundsAround(_from, _to, offset) {
            return {
                from: offset,
                to: offset + this.length,
                startDOM: this.dom,
                endDOM: this.dom.nextSibling
            };
        }
        coordsAt(pos, side) {
            return function(text, pos, side) {
                var length = text.nodeValue.length;
                length < pos && (pos = length);
                let from = pos, to = pos, flatten = 0;
                0 == pos && side < 0 || pos == length && 0 <= side ? browser.chrome || browser.gecko || (pos ? (from--, 
                flatten = 1) : to < length && (to++, flatten = -1)) : side < 0 ? from-- : to < length && to++;
                pos = textRange(text, from, to).getClientRects();
                if (!pos.length) return null;
                let rect = pos[(flatten ? flatten < 0 : 0 <= side) ? 0 : pos.length - 1];
                browser.safari && !flatten && 0 == rect.width && (rect = Array.prototype.find.call(pos, r => r.width) || rect);
                return flatten ? flattenRect(rect, flatten < 0) : rect || null;
            }(this.dom, pos, side);
        }
    }
    class MarkView extends ContentView {
        constructor(mark, children = [], length = 0) {
            super(), this.mark = mark, this.children = children, this.length = length;
            for (var ch of children) ch.setParent(this);
        }
        setAttrs(dom) {
            if (clearAttributes(dom), this.mark.class && (dom.className = this.mark.class), 
            this.mark.attrs) for (var name in this.mark.attrs) dom.setAttribute(name, this.mark.attrs[name]);
            return dom;
        }
        canReuseDOM(other) {
            return super.canReuseDOM(other) && !(8 & (this.flags | other.flags));
        }
        reuseDOM(node) {
            node.nodeName == this.mark.tagName.toUpperCase() && (this.setDOM(node), 
            this.flags |= 6);
        }
        sync(view, track) {
            this.dom ? 4 & this.flags && this.setAttrs(this.dom) : this.setDOM(this.setAttrs(document.createElement(this.mark.tagName))), 
            super.sync(view, track);
        }
        merge(from, to, source, _hasStart, openStart, openEnd) {
            return !(source && (!(source instanceof MarkView && source.mark.eq(this.mark)) || from && openStart <= 0 || to < this.length && openEnd <= 0) || (mergeChildrenInto(this, from, to, source ? source.children.slice() : [], openStart - 1, openEnd - 1), 
            this.markDirty(), 0));
        }
        split(from) {
            let result = [], off = 0, detachFrom = -1, i = 0;
            for (var elt of this.children) {
                var end = off + elt.length;
                from < end && result.push(off < from ? elt.split(from - off) : elt), 
                detachFrom < 0 && off >= from && (detachFrom = i), off = end, i++;
            }
            var length = this.length - from;
            return this.length = from, -1 < detachFrom && (this.children.length = detachFrom, 
            this.markDirty()), new MarkView(this.mark, result, length);
        }
        domAtPos(pos) {
            return inlineDOMAtPos(this, pos);
        }
        coordsAt(pos, side) {
            return coordsInChildren(this, pos, side);
        }
    }
    class WidgetView extends ContentView {
        static create(widget, length, side) {
            return new WidgetView(widget, length, side);
        }
        constructor(widget, length, side) {
            super(), this.widget = widget, this.length = length, this.side = side, 
            this.prevWidget = null;
        }
        split(from) {
            var result = WidgetView.create(this.widget, this.length - from, this.side);
            return this.length -= from, result;
        }
        sync(view) {
            this.dom && this.widget.updateDOM(this.dom, view) || (this.dom && this.prevWidget && this.prevWidget.destroy(this.dom), 
            this.prevWidget = null, this.setDOM(this.widget.toDOM(view)), this.widget.editable) || (this.dom.contentEditable = "false");
        }
        getSide() {
            return this.side;
        }
        merge(from, to, source, hasStart, openStart, openEnd) {
            return !(source && (!(source instanceof WidgetView && this.widget.compare(source.widget)) || 0 < from && openStart <= 0 || to < this.length && openEnd <= 0) || (this.length = from + (source ? source.length : 0) + (this.length - to), 
            0));
        }
        become(other) {
            return other instanceof WidgetView && other.side == this.side && this.widget.constructor == other.widget.constructor && (this.widget.compare(other.widget) || this.markDirty(!0), 
            this.dom && !this.prevWidget && (this.prevWidget = this.widget), this.widget = other.widget, 
            this.length = other.length, !0);
        }
        ignoreMutation() {
            return !0;
        }
        ignoreEvent(event) {
            return this.widget.ignoreEvent(event);
        }
        get overrideDOMText() {
            if (0 == this.length) return Text.empty;
            let top = this;
            for (;top.parent; ) top = top.parent;
            var view = top["view"], view = view && view.state.doc, start = this.posAtStart;
            return view ? view.slice(start, start + this.length) : Text.empty;
        }
        domAtPos(pos) {
            return (this.length ? 0 == pos : 0 < this.side) ? DOMPos.before(this.dom) : DOMPos.after(this.dom, pos == this.length);
        }
        domBoundsAround() {
            return null;
        }
        coordsAt(pos, side) {
            side = this.widget.coordsAt(this.dom, pos, side);
            if (side) return side;
            let rects = this.dom.getClientRects(), rect = null;
            if (!rects.length) return null;
            var fromBack = this.side ? this.side < 0 : 0 < pos;
            for (let i = fromBack ? rects.length - 1 : 0; rect = rects[i], !(0 < pos ? 0 == i : i == rects.length - 1 || rect.top < rect.bottom); i += fromBack ? -1 : 1);
            return flattenRect(rect, !fromBack);
        }
        get isEditable() {
            return !1;
        }
        get isWidget() {
            return !0;
        }
        get isHidden() {
            return this.widget.isHidden;
        }
        destroy() {
            super.destroy(), this.dom && this.widget.destroy(this.dom);
        }
    }
    class WidgetBufferView extends ContentView {
        constructor(side) {
            super(), this.side = side;
        }
        get length() {
            return 0;
        }
        merge() {
            return !1;
        }
        become(other) {
            return other instanceof WidgetBufferView && other.side == this.side;
        }
        split() {
            return new WidgetBufferView(this.side);
        }
        sync() {
            var dom;
            this.dom || ((dom = document.createElement("img")).className = "cm-widgetBuffer", 
            dom.setAttribute("aria-hidden", "true"), this.setDOM(dom));
        }
        getSide() {
            return this.side;
        }
        domAtPos(pos) {
            return 0 < this.side ? DOMPos.before(this.dom) : DOMPos.after(this.dom);
        }
        localPosFromDOM() {
            return 0;
        }
        domBoundsAround() {
            return null;
        }
        coordsAt(pos) {
            return this.dom.getBoundingClientRect();
        }
        get overrideDOMText() {
            return Text.empty;
        }
        get isHidden() {
            return !0;
        }
    }
    function inlineDOMAtPos(parent, pos) {
        let dom = parent.dom, children = parent["children"], i = 0;
        for (let off = 0; i < children.length; i++) {
            var child = children[i], end = off + child.length;
            if (!(end == off && child.getSide() <= 0)) {
                if (pos > off && pos < end && child.dom.parentNode == dom) return child.domAtPos(pos - off);
                if (pos <= off) break;
                off = end;
            }
        }
        for (let j = i; 0 < j; j--) {
            var prev = children[j - 1];
            if (prev.dom.parentNode == dom) return prev.domAtPos(prev.length);
        }
        for (let j = i; j < children.length; j++) {
            var next = children[j];
            if (next.dom.parentNode == dom) return next.domAtPos(0);
        }
        return new DOMPos(dom, 0);
    }
    function coordsInChildren(view, pos, side) {
        let before = null, beforePos = -1, after = null, afterPos = -1;
        !function scan(view, pos) {
            for (let i = 0, off = 0; i < view.children.length && off <= pos; i++) {
                var child = view.children[i], end = off + child.length;
                pos <= end && (child.children.length ? scan(child, pos - off) : (!after || after.isHidden && 0 < side) && (pos < end || off == end && 0 < child.getSide()) ? (after = child, 
                afterPos = pos - off) : (off < pos || off == end && child.getSide() < 0 && !child.isHidden) && (before = child, 
                beforePos = pos - off)), off = end;
            }
        }(view, pos);
        pos = (side < 0 ? before : after) || before || after;
        return pos ? pos.coordsAt(Math.max(0, pos == before ? beforePos : afterPos), side) : function(view) {
            var last = view.dom.lastChild;
            if (!last) return view.dom.getBoundingClientRect();
            view = clientRectsFor(last);
            return view[view.length - 1] || null;
        }(view);
    }
    function combineAttrs(source, target) {
        for (var name in source) "class" == name && target.class ? target.class += " " + source.class : "style" == name && target.style ? target.style += ";" + source.style : target[name] = source[name];
        return target;
    }
    TextView.prototype.children = WidgetView.prototype.children = WidgetBufferView.prototype.children = noChildren;
    const noAttrs = Object.create(null);
    function attrsEq(a, b, ignore) {
        if (a != b) {
            a = a || noAttrs, b = b || noAttrs;
            var key, keysA = Object.keys(a), keysB = Object.keys(b);
            if (keysA.length - (ignore && -1 < keysA.indexOf(ignore) ? 1 : 0) != keysB.length - (ignore && -1 < keysB.indexOf(ignore) ? 1 : 0)) return !1;
            for (key of keysA) if (key != ignore && (-1 == keysB.indexOf(key) || a[key] !== b[key])) return !1;
        }
        return !0;
    }
    function updateAttrs(dom, prev, attrs) {
        let changed = !1;
        if (prev) for (var name in prev) attrs && name in attrs || (changed = !0, 
        "style" == name ? dom.style.cssText = "" : dom.removeAttribute(name));
        if (attrs) for (let name in attrs) prev && prev[name] == attrs[name] || (changed = !0, 
        "style" == name ? dom.style.cssText = attrs[name] : dom.setAttribute(name, attrs[name]));
        return changed;
    }
    class LineView extends ContentView {
        constructor() {
            super(...arguments), this.children = [], this.length = 0, this.prevAttrs = void 0, 
            this.attrs = null, this.breakAfter = 0;
        }
        merge(from, to, source, hasStart, openStart, openEnd) {
            if (source) {
                if (!(source instanceof LineView)) return !1;
                this.dom || source.transferDOM(this);
            }
            return hasStart && this.setDeco(source ? source.attrs : null), mergeChildrenInto(this, from, to, source ? source.children.slice() : [], openStart, openEnd), 
            !0;
        }
        split(at) {
            var end = new LineView();
            if (end.breakAfter = this.breakAfter, 0 != this.length) {
                let {
                    i,
                    off
                } = this.childPos(at);
                off && (end.append(this.children[i].split(off), 0), this.children[i].merge(off, this.children[i].length, null, !1, 0, 0), 
                i++);
                for (let j = i; j < this.children.length; j++) end.append(this.children[j], 0);
                for (;0 < i && 0 == this.children[i - 1].length; ) this.children[--i].destroy();
                this.children.length = i, this.markDirty(), this.length = at;
            }
            return end;
        }
        transferDOM(other) {
            this.dom && (this.markDirty(), other.setDOM(this.dom), other.prevAttrs = void 0 === this.prevAttrs ? this.attrs : this.prevAttrs, 
            this.prevAttrs = void 0, this.dom = null);
        }
        setDeco(attrs) {
            attrsEq(this.attrs, attrs) || (this.dom && (this.prevAttrs = this.attrs, 
            this.markDirty()), this.attrs = attrs);
        }
        append(child, openStart) {
            !function joinInlineInto(parent, view, open) {
                let last, children = parent.children;
                0 < open && view instanceof MarkView && children.length && (last = children[children.length - 1]) instanceof MarkView && last.mark.eq(view.mark) ? joinInlineInto(last, view.children[0], open - 1) : (children.push(view), 
                view.setParent(parent)), parent.length += view.length;
            }(this, child, openStart);
        }
        addLineDeco(deco) {
            var attrs = deco.spec.attributes, deco = deco.spec.class;
            attrs && (this.attrs = combineAttrs(attrs, this.attrs || {})), deco && (this.attrs = combineAttrs({
                class: deco
            }, this.attrs || {}));
        }
        domAtPos(pos) {
            return inlineDOMAtPos(this, pos);
        }
        reuseDOM(node) {
            "DIV" == node.nodeName && (this.setDOM(node), this.flags |= 6);
        }
        sync(view, track) {
            this.dom ? 4 & this.flags && (clearAttributes(this.dom), this.dom.className = "cm-line", 
            this.prevAttrs = this.attrs ? null : void 0) : (this.setDOM(document.createElement("div")), 
            this.dom.className = "cm-line", this.prevAttrs = this.attrs ? null : void 0), 
            void 0 !== this.prevAttrs && (updateAttrs(this.dom, this.prevAttrs, this.attrs), 
            this.dom.classList.add("cm-line"), this.prevAttrs = void 0), super.sync(view, track);
            let last = this.dom.lastChild;
            for (;last && ContentView.get(last) instanceof MarkView; ) last = last.lastChild;
            last && this.length && ("BR" == last.nodeName || 0 != (null == (view = ContentView.get(last)) ? void 0 : view.isEditable) || browser.ios && this.children.some(ch => ch instanceof TextView)) || ((track = document.createElement("BR")).cmIgnore = !0, 
            this.dom.appendChild(track));
        }
        measureTextSize() {
            if (0 == this.children.length || 20 < this.length) return null;
            let totalWidth = 0, textHeight;
            for (var child of this.children) {
                if (!(child instanceof TextView) || /[^ -~]/.test(child.text)) return null;
                child = clientRectsFor(child.dom);
                if (1 != child.length) return null;
                totalWidth += child[0].width, textHeight = child[0].height;
            }
            return totalWidth ? {
                lineHeight: this.dom.getBoundingClientRect().height,
                charWidth: totalWidth / this.length,
                textHeight: textHeight
            } : null;
        }
        coordsAt(pos, side) {
            pos = coordsInChildren(this, pos, side);
            if (!this.children.length && pos && this.parent) {
                var side = this.parent.view.viewState["heightOracle"], height = pos.bottom - pos.top;
                if (Math.abs(height - side.lineHeight) < 2 && side.textHeight < height) return height = (height - side.textHeight) / 2, 
                {
                    top: pos.top + height,
                    bottom: pos.bottom - height,
                    left: pos.left,
                    right: pos.left
                };
            }
            return pos;
        }
        become(_other) {
            return !1;
        }
        covers() {
            return !0;
        }
        static find(docView, pos) {
            for (let i = 0, off = 0; i < docView.children.length; i++) {
                var block = docView.children[i], end = off + block.length;
                if (pos <= end) {
                    if (block instanceof LineView) return block;
                    if (pos < end) break;
                }
                off = end + block.breakAfter;
            }
            return null;
        }
    }
    class BlockWidgetView extends ContentView {
        constructor(widget, length, deco) {
            super(), this.widget = widget, this.length = length, this.deco = deco, 
            this.breakAfter = 0, this.prevWidget = null;
        }
        merge(from, to, source, _takeDeco, openStart, openEnd) {
            return !(source && (!(source instanceof BlockWidgetView && this.widget.compare(source.widget)) || 0 < from && openStart <= 0 || to < this.length && openEnd <= 0) || (this.length = from + (source ? source.length : 0) + (this.length - to), 
            0));
        }
        domAtPos(pos) {
            return 0 == pos ? DOMPos.before(this.dom) : DOMPos.after(this.dom, pos == this.length);
        }
        split(at) {
            var len = this.length - at, at = (this.length = at, new BlockWidgetView(this.widget, len, this.deco));
            return at.breakAfter = this.breakAfter, at;
        }
        get children() {
            return noChildren;
        }
        sync(view) {
            this.dom && this.widget.updateDOM(this.dom, view) || (this.dom && this.prevWidget && this.prevWidget.destroy(this.dom), 
            this.prevWidget = null, this.setDOM(this.widget.toDOM(view)), this.widget.editable) || (this.dom.contentEditable = "false");
        }
        get overrideDOMText() {
            return this.parent ? this.parent.view.state.doc.slice(this.posAtStart, this.posAtEnd) : Text.empty;
        }
        domBoundsAround() {
            return null;
        }
        become(other) {
            return other instanceof BlockWidgetView && other.widget.constructor == this.widget.constructor && (other.widget.compare(this.widget) || this.markDirty(!0), 
            this.dom && !this.prevWidget && (this.prevWidget = this.widget), this.widget = other.widget, 
            this.length = other.length, this.deco = other.deco, this.breakAfter = other.breakAfter, 
            !0);
        }
        ignoreMutation() {
            return !0;
        }
        ignoreEvent(event) {
            return this.widget.ignoreEvent(event);
        }
        get isEditable() {
            return !1;
        }
        get isWidget() {
            return !0;
        }
        coordsAt(pos, side) {
            return this.widget.coordsAt(this.dom, pos, side);
        }
        destroy() {
            super.destroy(), this.dom && this.widget.destroy(this.dom);
        }
        covers(side) {
            var {
                startSide,
                endSide
            } = this.deco;
            return startSide != endSide && (side < 0 ? startSide < 0 : 0 < endSide);
        }
    }
    class WidgetType {
        eq(widget) {
            return !1;
        }
        updateDOM(dom, view) {
            return !1;
        }
        compare(other) {
            return this == other || this.constructor == other.constructor && this.eq(other);
        }
        get estimatedHeight() {
            return -1;
        }
        get lineBreaks() {
            return 0;
        }
        ignoreEvent(event) {
            return !0;
        }
        coordsAt(dom, pos, side) {
            return null;
        }
        get isHidden() {
            return !1;
        }
        get editable() {
            return !1;
        }
        destroy(dom) {}
    }
    var BlockType = function(BlockType) {
        return BlockType[BlockType.Text = 0] = "Text", BlockType[BlockType.WidgetBefore = 1] = "WidgetBefore", 
        BlockType[BlockType.WidgetAfter = 2] = "WidgetAfter", BlockType[BlockType.WidgetRange = 3] = "WidgetRange", 
        BlockType;
    }(BlockType = BlockType || {});
    class Decoration extends RangeValue {
        constructor(startSide, endSide, widget, spec) {
            super(), this.startSide = startSide, this.endSide = endSide, this.widget = widget, 
            this.spec = spec;
        }
        get heightRelevant() {
            return !1;
        }
        static mark(spec) {
            return new MarkDecoration(spec);
        }
        static widget(spec) {
            var side = Math.max(-1e4, Math.min(1e4, spec.side || 0)), block = !!spec.block;
            return side += block && !spec.inlineOrder ? 0 < side ? 3e8 : -4e8 : 0 < side ? 1e8 : -1e8, 
            new PointDecoration(spec, side, side, block, spec.widget || null, !1);
        }
        static replace(spec) {
            let block = !!spec.block, startSide, endSide;
            var start, end;
            return endSide = spec.isBlockGap ? (startSide = -5e8, 4e8) : ({
                start,
                end
            } = getInclusive(spec, block), startSide = (start ? block ? -3e8 : -1 : 5e8) - 1, 
            1 + (end ? block ? 2e8 : 1 : -6e8)), new PointDecoration(spec, startSide, endSide, block, spec.widget || null, !0);
        }
        static line(spec) {
            return new LineDecoration(spec);
        }
        static set(of, sort = !1) {
            return RangeSet.of(of, sort);
        }
        hasHeight() {
            return !!this.widget && -1 < this.widget.estimatedHeight;
        }
    }
    Decoration.none = RangeSet.empty;
    class MarkDecoration extends Decoration {
        constructor(spec) {
            var {
                start,
                end
            } = getInclusive(spec);
            super(start ? -1 : 5e8, end ? 1 : -6e8, null, spec), this.tagName = spec.tagName || "span", 
            this.class = spec.class || "", this.attrs = spec.attributes || null;
        }
        eq(other) {
            var _a;
            return this == other || other instanceof MarkDecoration && this.tagName == other.tagName && (this.class || (null == (_a = this.attrs) ? void 0 : _a.class)) == (other.class || (null == (_a = other.attrs) ? void 0 : _a.class)) && attrsEq(this.attrs, other.attrs, "class");
        }
        range(from, to = from) {
            if (to <= from) throw new RangeError("Mark decorations may not be empty");
            return super.range(from, to);
        }
    }
    MarkDecoration.prototype.point = !1;
    class LineDecoration extends Decoration {
        constructor(spec) {
            super(-2e8, -2e8, null, spec);
        }
        eq(other) {
            return other instanceof LineDecoration && this.spec.class == other.spec.class && attrsEq(this.spec.attributes, other.spec.attributes);
        }
        range(from, to = from) {
            if (to != from) throw new RangeError("Line decoration ranges must be zero-length");
            return super.range(from, to);
        }
    }
    LineDecoration.prototype.mapMode = MapMode.TrackBefore, LineDecoration.prototype.point = !0;
    class PointDecoration extends Decoration {
        constructor(spec, startSide, endSide, block, widget, isReplace) {
            super(startSide, endSide, widget, spec), this.block = block, this.isReplace = isReplace, 
            this.mapMode = block ? startSide <= 0 ? MapMode.TrackBefore : MapMode.TrackAfter : MapMode.TrackDel;
        }
        get type() {
            return this.startSide != this.endSide ? BlockType.WidgetRange : this.startSide <= 0 ? BlockType.WidgetBefore : BlockType.WidgetAfter;
        }
        get heightRelevant() {
            return this.block || !!this.widget && (5 <= this.widget.estimatedHeight || 0 < this.widget.lineBreaks);
        }
        eq(other) {
            return other instanceof PointDecoration && (a = this.widget, b = other.widget, 
            a == b || !!(a && b && a.compare(b))) && this.block == other.block && this.startSide == other.startSide && this.endSide == other.endSide;
            var a, b;
        }
        range(from, to = from) {
            if (this.isReplace && (to < from || from == to && 0 < this.startSide && this.endSide <= 0)) throw new RangeError("Invalid range for replacement decoration");
            if (this.isReplace || to == from) return super.range(from, to);
            throw new RangeError("Widget decorations can only have zero-length ranges");
        }
    }
    function getInclusive(spec, block = !1) {
        let {
            inclusiveStart: start,
            inclusiveEnd: end
        } = spec;
        return null == start && (start = spec.inclusive), null == end && (end = spec.inclusive), 
        {
            start: null !== start && void 0 !== start ? start : block,
            end: null !== end && void 0 !== end ? end : block
        };
    }
    function addRange(from, to, ranges, margin = 0) {
        var last = ranges.length - 1;
        0 <= last && ranges[last] + margin >= from ? ranges[last] = Math.max(ranges[last], to) : ranges.push(from, to);
    }
    PointDecoration.prototype.point = !0;
    class ContentBuilder {
        constructor(doc, pos, end, disallowBlockEffectsFor) {
            this.doc = doc, this.pos = pos, this.end = end, this.disallowBlockEffectsFor = disallowBlockEffectsFor, 
            this.content = [], this.curLine = null, this.breakAtStart = 0, this.pendingBuffer = 0, 
            this.bufferMarks = [], this.atCursorPos = !0, this.openStart = -1, this.openEnd = -1, 
            this.text = "", this.textOff = 0, this.cursor = doc.iter(), this.skip = pos;
        }
        posCovered() {
            var last;
            return 0 == this.content.length ? !this.breakAtStart && this.doc.lineAt(this.pos).from != this.pos : !((last = this.content[this.content.length - 1]).breakAfter || last instanceof BlockWidgetView && last.deco.endSide < 0);
        }
        getLine() {
            return this.curLine || (this.content.push(this.curLine = new LineView()), 
            this.atCursorPos = !0), this.curLine;
        }
        flushBuffer(active = this.bufferMarks) {
            this.pendingBuffer && (this.curLine.append(wrapMarks(new WidgetBufferView(-1), active), active.length), 
            this.pendingBuffer = 0);
        }
        addBlockWidget(view) {
            this.flushBuffer(), this.curLine = null, this.content.push(view);
        }
        finish(openEnd) {
            this.pendingBuffer && openEnd <= this.bufferMarks.length ? this.flushBuffer() : this.pendingBuffer = 0, 
            this.posCovered() || openEnd && this.content.length && this.content[this.content.length - 1] instanceof BlockWidgetView || this.getLine();
        }
        buildText(length, active, openStart) {
            for (;0 < length; ) {
                if (this.textOff == this.text.length) {
                    var {
                        value,
                        lineBreak,
                        done
                    } = this.cursor.next(this.skip);
                    if (this.skip = 0, done) throw new Error("Ran out of text content when drawing inline views");
                    if (lineBreak) {
                        this.posCovered() || this.getLine(), this.content.length ? this.content[this.content.length - 1].breakAfter = 1 : this.breakAtStart = 1, 
                        this.flushBuffer(), this.curLine = null, this.atCursorPos = !0, 
                        length--;
                        continue;
                    }
                    this.text = value, this.textOff = 0;
                }
                done = Math.min(this.text.length - this.textOff, length, 512);
                this.flushBuffer(active.slice(active.length - openStart)), this.getLine().append(wrapMarks(new TextView(this.text.slice(this.textOff, this.textOff + done)), active), openStart), 
                this.atCursorPos = !0, this.textOff += done, length -= done, openStart = 0;
            }
        }
        span(from, to, active, openStart) {
            this.buildText(to - from, active, openStart), this.pos = to, this.openStart < 0 && (this.openStart = openStart);
        }
        point(from, to, deco, active, openStart, index) {
            if (this.disallowBlockEffectsFor[index] && deco instanceof PointDecoration) {
                if (deco.block) throw new RangeError("Block decorations may not be specified via plugins");
                if (to > this.doc.lineAt(this.pos).to) throw new RangeError("Decorations that replace line breaks may not be specified via plugins");
            }
            var view, cursorBefore, cursorAfter, line, index = to - from;
            deco instanceof PointDecoration ? deco.block ? (0 < deco.startSide && !this.posCovered() && this.getLine(), 
            this.addBlockWidget(new BlockWidgetView(deco.widget || NullWidget.block, index, deco))) : (view = WidgetView.create(deco.widget || NullWidget.inline, index, index ? 0 : deco.startSide), 
            cursorBefore = this.atCursorPos && !view.isEditable && openStart <= active.length && (from < to || 0 < deco.startSide), 
            cursorAfter = !view.isEditable && (from < to || openStart > active.length || deco.startSide <= 0), 
            line = this.getLine(), 2 != this.pendingBuffer || cursorBefore || view.isEditable || (this.pendingBuffer = 0), 
            this.flushBuffer(active), cursorBefore && (line.append(wrapMarks(new WidgetBufferView(1), active), openStart), 
            openStart = active.length + Math.max(0, openStart - active.length)), 
            line.append(wrapMarks(view, active), openStart), this.atCursorPos = cursorAfter, 
            this.pendingBuffer = cursorAfter ? from < to || openStart > active.length ? 1 : 2 : 0, 
            this.pendingBuffer && (this.bufferMarks = active.slice())) : this.doc.lineAt(this.pos).from == this.pos && this.getLine().addLineDeco(deco), 
            index && (this.textOff + index <= this.text.length ? this.textOff += index : (this.skip += index - (this.text.length - this.textOff), 
            this.text = "", this.textOff = 0), this.pos = to), this.openStart < 0 && (this.openStart = openStart);
        }
        static build(text, from, to, decorations, dynamicDecorationMap) {
            text = new ContentBuilder(text, from, to, dynamicDecorationMap);
            return text.openEnd = RangeSet.spans(decorations, from, to, text), text.openStart < 0 && (text.openStart = text.openEnd), 
            text.finish(text.openEnd), text;
        }
    }
    function wrapMarks(view, active) {
        for (var mark of active) view = new MarkView(mark, [ view ], view.length);
        return view;
    }
    class NullWidget extends WidgetType {
        constructor(tag) {
            super(), this.tag = tag;
        }
        eq(other) {
            return other.tag == this.tag;
        }
        toDOM() {
            return document.createElement(this.tag);
        }
        updateDOM(elt) {
            return elt.nodeName.toLowerCase() == this.tag;
        }
        get isHidden() {
            return !0;
        }
    }
    NullWidget.inline = new NullWidget("span"), NullWidget.block = new NullWidget("div");
    var p, Direction = function(Direction) {
        return Direction[Direction.LTR = 0] = "LTR", Direction[Direction.RTL = 1] = "RTL", 
        Direction;
    }(Direction = Direction || {});
    const LTR = Direction.LTR, RTL = Direction.RTL;
    function dec(str) {
        var result = [];
        for (let i = 0; i < str.length; i++) result.push(1 << +str[i]);
        return result;
    }
    const LowTypes = dec("88888888888888888888888888888888888666888888787833333333337888888000000000000000000000000008888880000000000000000000000000088888888888888888888888888888888888887866668888088888663380888308888800000000000000000000000800000000000000000000000000000008"), ArabicTypes = dec("4444448826627288999999999992222222222222222222222222222222222222222222222229999999999999999999994444444444644222822222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222999999949999999229989999223333333333"), Brackets = Object.create(null), BracketStack = [];
    for (p of [ "()", "[]", "{}" ]) {
        var l = p.charCodeAt(0), r = p.charCodeAt(1);
        Brackets[l] = r, Brackets[r] = -l;
    }
    function charType(ch) {
        return ch <= 247 ? LowTypes[ch] : 1424 <= ch && ch <= 1524 ? 2 : 1536 <= ch && ch <= 1785 ? ArabicTypes[ch - 1536] : 1774 <= ch && ch <= 2220 ? 4 : 8192 <= ch && ch <= 8204 ? 256 : 64336 <= ch && ch <= 65023 ? 4 : 1;
    }
    const BidiRE = /[\u0590-\u05f4\u0600-\u06ff\u0700-\u08ac\ufb50-\ufdff]/;
    class BidiSpan {
        get dir() {
            return this.level % 2 ? RTL : LTR;
        }
        constructor(from, to, level) {
            this.from = from, this.to = to, this.level = level;
        }
        side(end, dir) {
            return this.dir == dir == end ? this.to : this.from;
        }
        forward(forward, dir) {
            return forward == (this.dir == dir);
        }
        static find(order, index, level, assoc) {
            let maybe = -1;
            for (let i = 0; i < order.length; i++) {
                var span = order[i];
                if (span.from <= index && span.to >= index) {
                    if (span.level == level) return i;
                    (maybe < 0 || (0 != assoc ? assoc < 0 ? span.from < index : span.to > index : order[maybe].level > span.level)) && (maybe = i);
                }
            }
            if (maybe < 0) throw new RangeError("Index out of range");
            return maybe;
        }
    }
    const types = [];
    function computeSectionOrder(line, level, baseLevel, isolates, from, to, order) {
        var outerType = level % 2 ? 2 : 1;
        !function(line, rFrom, rTo, isolates, outerType) {
            for (let iI = 0; iI <= isolates.length; iI++) {
                var from = iI ? isolates[iI - 1].to : rFrom, to = iI < isolates.length ? isolates[iI].from : rTo, prevType = iI ? 256 : outerType;
                for (let i = from, prev = prevType, prevStrong = prevType; i < to; i++) {
                    let type = charType(line.charCodeAt(i));
                    512 == type ? type = prev : 8 == type && 4 == prevStrong && (type = 16), 
                    types[i] = 4 == type ? 2 : type, 7 & type && (prevStrong = type), 
                    prev = type;
                }
                for (let i = from, prev = prevType, prevStrong = prevType; i < to; i++) {
                    let type = types[i];
                    if (128 == type) i < to - 1 && prev == types[i + 1] && 24 & prev ? type = types[i] = prev : types[i] = 256; else if (64 == type) {
                        let end = i + 1;
                        for (;end < to && 64 == types[end]; ) end++;
                        var replace = i && 8 == prev || end < rTo && 8 == types[end] ? 1 == prevStrong ? 1 : 8 : 256;
                        for (let j = i; j < end; j++) types[j] = replace;
                        i = end - 1;
                    } else 8 == type && 1 == prevStrong && (types[i] = 1);
                    7 & (prev = type) && (prevStrong = type);
                }
            }
        }(line, from, to, isolates, outerType), function(line, rFrom, rTo, isolates, outerType) {
            var oppositeType = 1 == outerType ? 2 : 1;
            for (let iI = 0, sI = 0, context = 0; iI <= isolates.length; iI++) {
                var from = iI ? isolates[iI - 1].to : rFrom, to = iI < isolates.length ? isolates[iI].from : rTo;
                for (let i = from, ch, br, type; i < to; i++) if (br = Brackets[ch = line.charCodeAt(i)]) if (br < 0) {
                    for (let sJ = sI - 3; 0 <= sJ; sJ -= 3) if (BracketStack[sJ + 1] == -br) {
                        var flags = BracketStack[sJ + 2];
                        let type = 2 & flags ? outerType : 4 & flags ? 1 & flags ? oppositeType : outerType : 0;
                        type && (types[i] = types[BracketStack[sJ]] = type), sI = sJ;
                        break;
                    }
                } else {
                    if (189 == BracketStack.length) break;
                    BracketStack[sI++] = i, BracketStack[sI++] = ch, BracketStack[sI++] = context;
                } else if (2 == (type = types[i]) || 1 == type) {
                    var embed = type == outerType;
                    context = embed ? 0 : 1;
                    for (let sJ = sI - 3; 0 <= sJ; sJ -= 3) {
                        var cur = BracketStack[sJ + 2];
                        if (2 & cur) break;
                        if (embed) BracketStack[sJ + 2] |= 2; else {
                            if (4 & cur) break;
                            BracketStack[sJ + 2] |= 4;
                        }
                    }
                }
            }
        }(line, from, to, isolates, outerType), function(rFrom, rTo, isolates, outerType) {
            for (let iI = 0, prev = outerType; iI <= isolates.length; iI++) {
                let from = iI ? isolates[iI - 1].to : rFrom, to = iI < isolates.length ? isolates[iI].from : rTo;
                for (let i = from; i < to; ) {
                    var type = types[i];
                    if (256 == type) {
                        let end = i + 1;
                        for (;;) if (end == to) {
                            if (iI == isolates.length) break;
                            end = isolates[iI++].to, to = iI < isolates.length ? isolates[iI].from : rTo;
                        } else {
                            if (256 != types[end]) break;
                            end++;
                        }
                        var beforeL = 1 == prev, replace = beforeL == (1 == (end < rTo ? types[end] : outerType)) ? beforeL ? 1 : 2 : outerType;
                        for (let j = end, jI = iI, fromJ = jI ? isolates[jI - 1].to : rFrom; j > i; ) j == fromJ && (j = isolates[--jI].from, 
                        fromJ = jI ? isolates[jI - 1].to : rFrom), types[--j] = replace;
                        i = end;
                    } else prev = type, i++;
                }
            }
        }(from, to, isolates, outerType), function emitSpans(line, from, to, level, baseLevel, isolates, order) {
            var ourType = level % 2 ? 2 : 1;
            if (level % 2 == baseLevel % 2) for (let iCh = from, iI = 0; iCh < to; ) {
                let sameDir = !0, isNum = !1;
                (iI == isolates.length || iCh < isolates[iI].from) && (next = types[iCh]) != ourType && (sameDir = !1, 
                isNum = 16 == next);
                var next, recurse = sameDir || 1 != ourType ? null : [], localLevel = sameDir ? level : level + 1;
                let iScan = iCh;
                run: for (;;) if (iI < isolates.length && iScan == isolates[iI].from) {
                    if (isNum) break;
                    var iso = isolates[iI];
                    if (!sameDir) for (let upto = iso.to, jI = iI + 1; ;) {
                        if (upto == to) break run;
                        if (!(jI < isolates.length && isolates[jI].from == upto)) {
                            if (types[upto] == ourType) break run;
                            break;
                        }
                        upto = isolates[jI++].to;
                    }
                    iI++, recurse ? recurse.push(iso) : (iso.from > iCh && order.push(new BidiSpan(iCh, iso.from, localLevel)), 
                    computeSectionOrder(line, iso.direction == LTR != !(localLevel % 2) ? level + 1 : level, baseLevel, iso.inner, iso.from, iso.to, order), 
                    iCh = iso.to), iScan = iso.to;
                } else {
                    if (iScan == to || (sameDir ? types[iScan] != ourType : types[iScan] == ourType)) break;
                    iScan++;
                }
                recurse ? emitSpans(line, iCh, iScan, level + 1, baseLevel, recurse, order) : iCh < iScan && order.push(new BidiSpan(iCh, iScan, localLevel)), 
                iCh = iScan;
            } else for (let iCh = to, iI = isolates.length; iCh > from; ) {
                let sameDir = !0, isNum = !1;
                if (!iI || iCh > isolates[iI - 1].to) {
                    let next = types[iCh - 1];
                    next != ourType && (sameDir = !1, isNum = 16 == next);
                }
                let recurse = sameDir || 1 != ourType ? null : [], localLevel = sameDir ? level : level + 1, iScan = iCh;
                run: for (;;) if (iI && iScan == isolates[iI - 1].to) {
                    if (isNum) break;
                    let iso = isolates[--iI];
                    if (!sameDir) for (let upto = iso.from, jI = iI; ;) {
                        if (upto == from) break run;
                        if (!jI || isolates[jI - 1].to != upto) {
                            if (types[upto - 1] == ourType) break run;
                            break;
                        }
                        upto = isolates[--jI].from;
                    }
                    if (recurse) recurse.push(iso); else {
                        iso.to < iCh && order.push(new BidiSpan(iso.to, iCh, localLevel));
                        let dirSwap = iso.direction == LTR != !(localLevel % 2);
                        computeSectionOrder(line, dirSwap ? level + 1 : level, baseLevel, iso.inner, iso.from, iso.to, order), 
                        iCh = iso.from;
                    }
                    iScan = iso.from;
                } else {
                    if (iScan == from || (sameDir ? types[iScan - 1] != ourType : types[iScan - 1] == ourType)) break;
                    iScan--;
                }
                recurse ? emitSpans(line, iScan, iCh, level + 1, baseLevel, recurse, order) : iScan < iCh && order.push(new BidiSpan(iScan, iCh, localLevel)), 
                iCh = iScan;
            }
        }(line, from, to, level, baseLevel, isolates, order);
    }
    function trivialOrder(length) {
        return [ new BidiSpan(0, length, 0) ];
    }
    let movedOver = "";
    const clickAddsSelectionRange = Facet.define(), dragMovesSelection$1 = Facet.define(), mouseSelectionStyle = Facet.define(), exceptionSink = Facet.define(), updateListener = Facet.define(), inputHandler$1 = Facet.define(), focusChangeEffect = Facet.define(), perLineTextDirection = Facet.define({
        combine: values => values.some(x => x)
    }), nativeSelectionHidden = Facet.define({
        combine: values => values.some(x => x)
    }), scrollHandler = Facet.define();
    class ScrollTarget {
        constructor(range, y = "nearest", x = "nearest", yMargin = 5, xMargin = 5, isSnapshot = !1) {
            this.range = range, this.y = y, this.x = x, this.yMargin = yMargin, 
            this.xMargin = xMargin, this.isSnapshot = isSnapshot;
        }
        map(changes) {
            return changes.empty ? this : new ScrollTarget(this.range.map(changes), this.y, this.x, this.yMargin, this.xMargin, this.isSnapshot);
        }
        clip(state) {
            return this.range.to <= state.doc.length ? this : new ScrollTarget(EditorSelection.cursor(state.doc.length), this.y, this.x, this.yMargin, this.xMargin, this.isSnapshot);
        }
    }
    const scrollIntoView$1 = StateEffect.define({
        map: (t, ch) => t.map(ch)
    });
    function logException(state, exception, context) {
        state = state.facet(exceptionSink);
        state.length ? state[0](exception) : window.onerror ? window.onerror(String(exception), context, void 0, void 0, exception) : context ? console.error(context + ":", exception) : console.error(exception);
    }
    const editable = Facet.define({
        combine: values => !values.length || values[0]
    });
    let nextPluginID = 0;
    const viewPlugin = Facet.define();
    class ViewPlugin {
        constructor(id, create, domEventHandlers, domEventObservers, buildExtensions) {
            this.id = id, this.create = create, this.domEventHandlers = domEventHandlers, 
            this.domEventObservers = domEventObservers, this.extension = buildExtensions(this);
        }
        static define(create, spec) {
            const {
                eventHandlers,
                eventObservers,
                provide,
                decorations: deco
            } = spec || {};
            return new ViewPlugin(nextPluginID++, create, eventHandlers, eventObservers, plugin => {
                var ext = [ viewPlugin.of(plugin) ];
                return deco && ext.push(decorations.of(view => {
                    view = view.plugin(plugin);
                    return view ? deco(view) : Decoration.none;
                })), provide && ext.push(provide(plugin)), ext;
            });
        }
        static fromClass(cls, spec) {
            return ViewPlugin.define(view => new cls(view), spec);
        }
    }
    class PluginInstance {
        constructor(spec) {
            this.spec = spec, this.mustUpdate = null, this.value = null;
        }
        update(view) {
            if (this.value) {
                if (this.mustUpdate) {
                    var update = this.mustUpdate;
                    if (this.mustUpdate = null, this.value.update) try {
                        this.value.update(update);
                    } catch (e) {
                        if (logException(update.state, e, "CodeMirror plugin crashed"), 
                        this.value.destroy) try {
                            this.value.destroy();
                        } catch (_) {}
                        this.deactivate();
                    }
                }
            } else if (this.spec) try {
                this.value = this.spec.create(view);
            } catch (e) {
                logException(view.state, e, "CodeMirror plugin crashed"), this.deactivate();
            }
            return this;
        }
        destroy(view) {
            var _a;
            if (null != (_a = this.value) && _a.destroy) try {
                this.value.destroy();
            } catch (e) {
                logException(view.state, e, "CodeMirror plugin crashed");
            }
        }
        deactivate() {
            this.spec = this.value = null;
        }
    }
    const editorAttributes = Facet.define(), contentAttributes = Facet.define(), decorations = Facet.define(), outerDecorations = Facet.define(), atomicRanges = Facet.define(), bidiIsolatedRanges = Facet.define();
    function getIsolatedRanges(view, line) {
        var isolates = view.state.facet(bidiIsolatedRanges);
        if (!isolates.length) return isolates;
        isolates = isolates.map(i => i instanceof Function ? i(view) : i);
        let result = [];
        return RangeSet.spans(isolates, line.from, line.to, {
            point() {},
            span(fromDoc, toDoc, active, open) {
                var add, from = fromDoc - line.from, to = toDoc - line.from;
                let level = result;
                for (let i = active.length - 1; 0 <= i; i--, open--) {
                    let direction = active[i].spec.bidiIsolate, update;
                    null == direction && (direction = function(text, from, to) {
                        for (let i = from; i < to; i++) {
                            var type = charType(text.charCodeAt(i));
                            if (1 == type) return LTR;
                            if (2 == type || 4 == type) return RTL;
                        }
                        return LTR;
                    }(line.text, from, to)), level = (0 < open && level.length && (update = level[level.length - 1]).to == from && update.direction == direction ? (update.to = to, 
                    update) : (add = {
                        from: from,
                        to: to,
                        direction: direction,
                        inner: []
                    }, level.push(add), add)).inner;
                }
            }
        }), result;
    }
    const scrollMargins = Facet.define();
    function getScrollMargins(view) {
        let left = 0, right = 0, top = 0, bottom = 0;
        for (var source of view.state.facet(scrollMargins)) {
            source = source(view);
            source && (null != source.left && (left = Math.max(left, source.left)), 
            null != source.right && (right = Math.max(right, source.right)), null != source.top && (top = Math.max(top, source.top)), 
            null != source.bottom) && (bottom = Math.max(bottom, source.bottom));
        }
        return {
            left: left,
            right: right,
            top: top,
            bottom: bottom
        };
    }
    const styleModule = Facet.define();
    class ChangedRange {
        constructor(fromA, toA, fromB, toB) {
            this.fromA = fromA, this.toA = toA, this.fromB = fromB, this.toB = toB;
        }
        join(other) {
            return new ChangedRange(Math.min(this.fromA, other.fromA), Math.max(this.toA, other.toA), Math.min(this.fromB, other.fromB), Math.max(this.toB, other.toB));
        }
        addToSet(set) {
            let i = set.length, me = this;
            for (;0 < i; i--) {
                var range = set[i - 1];
                if (!(range.fromA > me.toA)) {
                    if (range.toA < me.fromA) break;
                    me = me.join(range), set.splice(i - 1, 1);
                }
            }
            return set.splice(i, 0, me), set;
        }
        static extendWithRanges(diff, ranges) {
            if (0 == ranges.length) return diff;
            var result = [];
            for (let dI = 0, rI = 0, posA = 0, posB = 0; ;dI++) {
                for (var next = dI == diff.length ? null : diff[dI], off = posA - posB, end = next ? next.fromB : 1e9; rI < ranges.length && ranges[rI] < end; ) {
                    var from = ranges[rI], to = ranges[rI + 1], from = Math.max(posB, from), toB = Math.min(end, to);
                    if (from <= toB && new ChangedRange(from + off, toB + off, from, toB).addToSet(result), 
                    end < to) break;
                    rI += 2;
                }
                if (!next) return result;
                new ChangedRange(next.fromA, next.toA, next.fromB, next.toB).addToSet(result), 
                posA = next.toA, posB = next.toB;
            }
        }
    }
    class ViewUpdate {
        constructor(view, state, transactions) {
            this.view = view, this.state = state, this.transactions = transactions, 
            this.flags = 0, this.startState = view.state, this.changes = ChangeSet.empty(this.startState.doc.length);
            for (var tr of transactions) this.changes = this.changes.compose(tr.changes);
            let changedRanges = [];
            this.changes.iterChangedRanges((fromA, toA, fromB, toB) => changedRanges.push(new ChangedRange(fromA, toA, fromB, toB))), 
            this.changedRanges = changedRanges;
        }
        static create(view, state, transactions) {
            return new ViewUpdate(view, state, transactions);
        }
        get viewportChanged() {
            return 0 < (4 & this.flags);
        }
        get heightChanged() {
            return 0 < (2 & this.flags);
        }
        get geometryChanged() {
            return this.docChanged || 0 < (10 & this.flags);
        }
        get focusChanged() {
            return 0 < (1 & this.flags);
        }
        get docChanged() {
            return !this.changes.empty;
        }
        get selectionSet() {
            return this.transactions.some(tr => tr.selection);
        }
        get empty() {
            return 0 == this.flags && 0 == this.transactions.length;
        }
    }
    class DocView extends ContentView {
        get length() {
            return this.view.state.doc.length;
        }
        constructor(view) {
            super(), this.view = view, this.decorations = [], this.dynamicDecorationMap = [], 
            this.domChanged = null, this.hasComposition = null, this.markedForComposition = new Set(), 
            this.lastCompositionAfterCursor = !1, this.minWidth = 0, this.minWidthFrom = 0, 
            this.minWidthTo = 0, this.impreciseAnchor = null, this.impreciseHead = null, 
            this.forceSelection = !1, this.lastUpdate = Date.now(), this.setDOM(view.contentDOM), 
            this.children = [ new LineView() ], this.children[0].setParent(this), 
            this.updateDeco(), this.updateInner([ new ChangedRange(0, 0, 0, view.state.doc.length) ], 0, null);
        }
        update(update) {
            let changedRanges = update.changedRanges, readCompositionAt = (0 < this.minWidth && changedRanges.length && (changedRanges.every(({
                fromA,
                toA
            }) => toA < this.minWidthFrom || fromA > this.minWidthTo) ? (this.minWidthFrom = update.changes.mapPos(this.minWidthFrom, 1), 
            this.minWidthTo = update.changes.mapPos(this.minWidthTo, 1)) : this.minWidth = this.minWidthFrom = this.minWidthTo = 0), 
            -1);
            0 <= this.view.inputState.composing && (null != (_a = this.domChanged) && _a.newSel ? readCompositionAt = this.domChanged.newSel.head : function(changes, composition) {
                let touched = !1;
                composition && changes.iterChangedRanges((from, to) => {
                    from < composition.to && to > composition.from && (touched = !0);
                });
                return touched;
            }(update.changes, this.hasComposition) || update.selectionSet || (readCompositionAt = update.state.selection.main.head));
            var comp, _a = -1 < readCompositionAt ? function(view, changes, headPos) {
                headPos = findCompositionNode(view, headPos);
                if (!headPos) return null;
                var {
                    node: textNode,
                    from,
                    to
                } = headPos, text = textNode.nodeValue;
                if (/[\n\r]/.test(text)) return null;
                if (view.state.doc.sliceString(headPos.from, headPos.to) != text) return null;
                var headPos = changes.invertedDesc, range = new ChangedRange(headPos.mapPos(from), headPos.mapPos(to), from, to), marks = [];
                for (let parent = textNode.parentNode; ;parent = parent.parentNode) {
                    var parentView = ContentView.get(parent);
                    if (parentView instanceof MarkView) marks.push({
                        node: parent,
                        deco: parentView.mark
                    }); else {
                        if (parentView instanceof LineView || "DIV" == parent.nodeName && parent.parentNode == view.contentDOM) return {
                            range: range,
                            text: textNode,
                            marks: marks,
                            line: parent
                        };
                        if (parent == view.contentDOM) return null;
                        marks.push({
                            node: parent,
                            deco: new MarkDecoration({
                                inclusive: !0,
                                attributes: function(dom) {
                                    var attrs = Object.create(null);
                                    for (let i = 0; i < dom.attributes.length; i++) {
                                        var attr = dom.attributes[i];
                                        attrs[attr.name] = attr.value;
                                    }
                                    return attrs;
                                }(parent),
                                tagName: parent.tagName.toLowerCase()
                            })
                        });
                    }
                }
            }(this.view, update.changes, readCompositionAt) : null, from = (this.domChanged = null, 
            this.hasComposition && (this.markedForComposition.clear(), {
                from,
                to
            } = this.hasComposition, changedRanges = new ChangedRange(from, to, update.changes.mapPos(from, -1), update.changes.mapPos(to, 1)).addToSet(changedRanges.slice())), 
            this.hasComposition = _a ? {
                from: _a.range.fromB,
                to: _a.range.toB
            } : null, (browser.ie || browser.chrome) && !_a && update && update.state.doc.lines != update.startState.doc.lines && (this.forceSelection = !0), 
            this.decorations), to = this.updateDeco(), diff = (from = from, to = to, 
            diff = update.changes, comp = new DecorationComparator$1(), RangeSet.compare(from, to, diff, comp), 
            comp.changes);
            return changedRanges = ChangedRange.extendWithRanges(changedRanges, diff), 
            !!(7 & this.flags || 0 != changedRanges.length) && (this.updateInner(changedRanges, update.startState.doc.length, _a), 
            update.transactions.length && (this.lastUpdate = Date.now()), !0);
        }
        updateInner(changes, oldLength, composition) {
            this.view.viewState.mustMeasureContent = !0, this.updateChildren(changes, oldLength, composition);
            let observer = this.view["observer"];
            observer.ignore(() => {
                this.dom.style.height = this.view.viewState.contentHeight / this.view.scaleY + "px", 
                this.dom.style.flexBasis = this.minWidth ? this.minWidth + "px" : "";
                var track = browser.chrome || browser.ios ? {
                    node: observer.selectionRange.focusNode,
                    written: !1
                } : void 0;
                this.sync(this.view, track), this.flags &= -8, track && (track.written || observer.selectionRange.focusNode != track.node) && (this.forceSelection = !0), 
                this.dom.style.height = "";
            }), this.markedForComposition.forEach(cView => cView.flags &= -9);
            var gaps = [];
            if (this.view.viewport.from || this.view.viewport.to < this.view.state.doc.length) for (var child of this.children) child instanceof BlockWidgetView && child.widget instanceof BlockGapWidget && gaps.push(child.dom);
            observer.updateGaps(gaps);
        }
        updateChildren(changes, oldLength, composition) {
            var ranges = composition ? composition.range.addToSet(changes.slice()) : changes, cursor = this.childCursor(oldLength);
            for (let i = ranges.length - 1; ;i--) {
                var next = 0 <= i ? ranges[i] : null;
                if (!next) break;
                let {
                    fromA,
                    toA,
                    fromB,
                    toB
                } = next, content, breakAtStart, openStart, openEnd;
                composition && composition.range.fromB < toB && composition.range.toB > fromB ? (next = ContentBuilder.build(this.view.state.doc, fromB, composition.range.fromB, this.decorations, this.dynamicDecorationMap), 
                after = ContentBuilder.build(this.view.state.doc, composition.range.toB, toB, this.decorations, this.dynamicDecorationMap), 
                breakAtStart = next.breakAtStart, openStart = next.openStart, openEnd = after.openEnd, 
                compLine = this.compositionView(composition), after.breakAtStart ? compLine.breakAfter = 1 : after.content.length && compLine.merge(compLine.length, compLine.length, after.content[0], !1, after.openStart, 0) && (compLine.breakAfter = after.content[0].breakAfter, 
                after.content.shift()), next.content.length && compLine.merge(0, 0, next.content[next.content.length - 1], !0, 0, next.openEnd) && next.content.pop(), 
                content = next.content.concat(compLine).concat(after.content)) : {
                    content,
                    breakAtStart,
                    openStart,
                    openEnd
                } = ContentBuilder.build(this.view.state.doc, fromB, toB, this.decorations, this.dynamicDecorationMap);
                var {
                    i: next,
                    off: compLine
                } = cursor.findPos(toA, 1), {
                    i: after,
                    off: fromOff
                } = cursor.findPos(fromA, -1);
                replaceRange(this, after, fromOff, next, compLine, content, breakAtStart, openStart, openEnd);
            }
            composition && this.fixCompositionDOM(composition);
        }
        compositionView(composition) {
            let cur = new TextView(composition.text.nodeValue);
            cur.flags |= 8;
            for (var {
                deco
            } of composition.marks) cur = new MarkView(deco, [ cur ], cur.length);
            composition = new LineView();
            return composition.append(cur, 0), composition;
        }
        fixCompositionDOM(composition) {
            var fix = (dom, cView) => {
                cView.flags |= 8 | (cView.children.some(c => 7 & c.flags) ? 1 : 0), 
                this.markedForComposition.add(cView);
                var prev = ContentView.get(dom);
                prev && prev != cView && (prev.dom = null), cView.setDOM(dom);
            };
            let pos = this.childPos(composition.range.fromB, 1), cView = this.children[pos.i];
            fix(composition.line, cView);
            for (let i = composition.marks.length - 1; -1 <= i; i--) pos = cView.childPos(pos.off, 1), 
            cView = cView.children[pos.i], fix(0 <= i ? composition.marks[i].node : composition.text, cView);
        }
        updateSelection(mustRead = !1, fromPointer = !1) {
            !mustRead && this.view.observer.selectionRange.focusNode || this.view.observer.readSelectionRange();
            let activeElt = this.view.root.activeElement, focused = activeElt == this.dom, selectionNotFocus = !focused && hasSelection(this.dom, this.view.observer.selectionRange) && !(activeElt && this.dom.contains(activeElt));
            if (focused || fromPointer || selectionNotFocus) {
                let force = this.forceSelection, main = (this.forceSelection = !1, 
                this.view.state.selection.main), anchor = this.moveToLine(this.domAtPos(main.anchor)), head = main.empty ? anchor : this.moveToLine(this.domAtPos(main.head));
                if (browser.gecko && main.empty && !this.hasComposition && 1 == (mustRead = anchor).node.nodeType && mustRead.node.firstChild && (0 == mustRead.offset || "false" == mustRead.node.childNodes[mustRead.offset - 1].contentEditable) && (mustRead.offset == mustRead.node.childNodes.length || "false" == mustRead.node.childNodes[mustRead.offset].contentEditable)) {
                    let dummy = document.createTextNode("");
                    this.view.observer.ignore(() => anchor.node.insertBefore(dummy, anchor.node.childNodes[anchor.offset] || null)), 
                    anchor = head = new DOMPos(dummy, 0), force = !0;
                }
                let domSel = this.view.observer.selectionRange;
                !force && domSel.focusNode && (isEquivalentPosition(anchor.node, anchor.offset, domSel.anchorNode, domSel.anchorOffset) && isEquivalentPosition(head.node, head.offset, domSel.focusNode, domSel.focusOffset) || this.suppressWidgetCursorChange(domSel, main)) || (this.view.observer.ignore(() => {
                    browser.android && browser.chrome && this.dom.contains(domSel.focusNode) && function(node, inside) {
                        for (let cur = node; cur && cur != inside; cur = cur.assignedSlot || cur.parentNode) if (1 == cur.nodeType && "false" == cur.contentEditable) return 1;
                        return;
                    }(domSel.focusNode, this.dom) && (this.dom.blur(), this.dom.focus({
                        preventScroll: !0
                    }));
                    var offset, rawSel = getSelection(this.view.root);
                    if (rawSel) if (main.empty) browser.gecko && (node = anchor.node, 
                    offset = anchor.offset, node = 1 != node.nodeType ? 0 : (offset && "false" == node.childNodes[offset - 1].contentEditable ? 1 : 0) | (offset < node.childNodes.length && "false" == node.childNodes[offset].contentEditable ? 2 : 0)) && 3 != node && (offset = (1 == node ? textNodeBefore : textNodeAfter)(anchor.node, anchor.offset)) && (anchor = new DOMPos(offset.node, offset.offset)), 
                    rawSel.collapse(anchor.node, anchor.offset), null != main.bidiLevel && void 0 !== rawSel.caretBidiLevel && (rawSel.caretBidiLevel = main.bidiLevel); else if (rawSel.extend) {
                        rawSel.collapse(anchor.node, anchor.offset);
                        try {
                            rawSel.extend(head.node, head.offset);
                        } catch (_) {}
                    } else {
                        var node = document.createRange();
                        main.anchor > main.head && ([ anchor, head ] = [ head, anchor ]), 
                        node.setEnd(head.node, head.offset), node.setStart(anchor.node, anchor.offset), 
                        rawSel.removeAllRanges(), rawSel.addRange(node);
                    }
                    selectionNotFocus && this.view.root.activeElement == this.dom && (this.dom.blur(), 
                    activeElt) && activeElt.focus();
                }), this.view.observer.setSelectionRange(anchor, head)), this.impreciseAnchor = anchor.precise ? null : new DOMPos(domSel.anchorNode, domSel.anchorOffset), 
                this.impreciseHead = head.precise ? null : new DOMPos(domSel.focusNode, domSel.focusOffset);
            }
        }
        suppressWidgetCursorChange(sel, cursor) {
            return this.hasComposition && cursor.empty && isEquivalentPosition(sel.focusNode, sel.focusOffset, sel.anchorNode, sel.anchorOffset) && this.posFromDOM(sel.focusNode, sel.focusOffset) == cursor.head;
        }
        enforceCursorAssoc() {
            var view, cursor, sel, anchorNode, anchorOffset, lineStart, line;
            this.hasComposition || (view = this["view"], cursor = view.state.selection.main, 
            sel = getSelection(view.root), {
                anchorNode,
                anchorOffset
            } = view.observer.selectionRange, sel && cursor.empty && cursor.assoc && sel.modify && (line = LineView.find(this, cursor.head)) && (lineStart = line.posAtStart, 
            cursor.head == lineStart || cursor.head == lineStart + line.length || (lineStart = this.coordsAt(cursor.head, -1), 
            line = this.coordsAt(cursor.head, 1), !lineStart) || !line || lineStart.bottom > line.top || (lineStart = this.domAtPos(cursor.head + cursor.assoc), 
            sel.collapse(lineStart.node, lineStart.offset), sel.modify("move", cursor.assoc < 0 ? "forward" : "backward", "lineboundary"), 
            view.observer.readSelectionRange(), line = view.observer.selectionRange, 
            view.docView.posFromDOM(line.anchorNode, line.anchorOffset) != cursor.from && sel.collapse(anchorNode, anchorOffset))));
        }
        moveToLine(pos) {
            let dom = this.dom, newPos;
            if (pos.node != dom) return pos;
            for (let i = pos.offset; !newPos && i < dom.childNodes.length; i++) {
                var view = ContentView.get(dom.childNodes[i]);
                view instanceof LineView && (newPos = view.domAtPos(0));
            }
            for (let i = pos.offset - 1; !newPos && 0 <= i; i--) {
                let view = ContentView.get(dom.childNodes[i]);
                view instanceof LineView && (newPos = view.domAtPos(view.length));
            }
            return newPos ? new DOMPos(newPos.node, newPos.offset, !0) : pos;
        }
        nearest(dom) {
            for (let cur = dom; cur; ) {
                var domView = ContentView.get(cur);
                if (domView && domView.rootView == this) return domView;
                cur = cur.parentNode;
            }
            return null;
        }
        posFromDOM(node, offset) {
            var view = this.nearest(node);
            if (view) return view.localPosFromDOM(node, offset) + view.posAtStart;
            throw new RangeError("Trying to find position for a DOM position outside of the document");
        }
        domAtPos(pos) {
            let {
                i,
                off
            } = this.childCursor().findPos(pos, -1);
            for (;i < this.children.length - 1; ) {
                var child = this.children[i];
                if (off < child.length || child instanceof LineView) break;
                i++, off = 0;
            }
            return this.children[i].domAtPos(off);
        }
        coordsAt(pos, side) {
            let best = null, bestPos = 0;
            for (let off = this.length, i = this.children.length - 1; 0 <= i; i--) {
                var child = this.children[i], end = off - child.breakAfter, start = end - child.length;
                if (end < pos) break;
                start <= pos && (start < pos || child.covers(-1)) && (pos < end || child.covers(1)) && (!best || child instanceof LineView && !(best instanceof LineView && 0 <= side)) && (best = child, 
                bestPos = start), off = start;
            }
            return best ? best.coordsAt(pos - bestPos, side) : null;
        }
        coordsForChar(pos) {
            let {
                i,
                off
            } = this.childPos(pos, 1), child = this.children[i];
            if (child instanceof LineView) {
                for (;child.children.length; ) {
                    let {
                        i,
                        off: childOff
                    } = child.childPos(off, 1);
                    for (;;i++) {
                        if (i == child.children.length) return null;
                        if ((child = child.children[i]).length) break;
                    }
                    off = childOff;
                }
                if (child instanceof TextView) {
                    pos = findClusterBreak(child.text, off);
                    if (pos != off) {
                        var rects = textRange(child.dom, off, pos).getClientRects();
                        for (let i = 0; i < rects.length; i++) {
                            var rect = rects[i];
                            if (i == rects.length - 1 || rect.top < rect.bottom && rect.left < rect.right) return rect;
                        }
                    }
                }
            }
            return null;
        }
        measureVisibleLineHeights(viewport) {
            var result = [], {
                from,
                to
            } = viewport, contentWidth = this.view.contentDOM.clientWidth, isWider = contentWidth > Math.max(this.view.scrollDOM.clientWidth, this.minWidth) + 1;
            let widest = -1, ltr = this.view.textDirection == Direction.LTR;
            for (let pos = 0, i = 0; i < this.children.length; i++) {
                var last, childRect, child = this.children[i], end = pos + child.length;
                if (to < end) break;
                pos >= from && (childRect = child.dom.getBoundingClientRect(), result.push(childRect.height), 
                isWider) && (last = (last = child.dom.lastChild) ? clientRectsFor(last) : []).length && (last = last[last.length - 1], 
                (childRect = ltr ? last.right - childRect.left : childRect.right - last.left) > widest) && (widest = childRect, 
                this.minWidth = contentWidth, this.minWidthFrom = pos, this.minWidthTo = end), 
                pos = end + child.breakAfter;
            }
            return result;
        }
        textDirectionAt(pos) {
            pos = this.childPos(pos, 1).i;
            return "rtl" == getComputedStyle(this.children[pos].dom).direction ? Direction.RTL : Direction.LTR;
        }
        measureTextSize() {
            for (var child of this.children) if (child instanceof LineView) {
                child = child.measureTextSize();
                if (child) return child;
            }
            let dummy = document.createElement("div"), lineHeight, charWidth, textHeight;
            return dummy.className = "cm-line", dummy.style.width = "99999px", dummy.style.position = "absolute", 
            dummy.textContent = "abc def ghi jkl mno pqr stu", this.view.observer.ignore(() => {
                this.dom.appendChild(dummy);
                var rect = clientRectsFor(dummy.firstChild)[0];
                lineHeight = dummy.getBoundingClientRect().height, charWidth = rect ? rect.width / 27 : 7, 
                textHeight = rect ? rect.height : lineHeight, dummy.remove();
            }), {
                lineHeight: lineHeight,
                charWidth: charWidth,
                textHeight: textHeight
            };
        }
        childCursor(pos = this.length) {
            let i = this.children.length;
            return i && (pos -= this.children[--i].length), new ChildCursor(this.children, pos, i);
        }
        computeBlockGapDeco() {
            var deco = [], vs = this.view.viewState;
            for (let pos = 0, i = 0; ;i++) {
                var height, next = i == vs.viewports.length ? null : vs.viewports[i], end = next ? next.from - 1 : this.length;
                if (end > pos && (height = (vs.lineBlockAt(end).bottom - vs.lineBlockAt(pos).top) / this.view.scaleY, 
                deco.push(Decoration.replace({
                    widget: new BlockGapWidget(height),
                    block: !0,
                    inclusive: !0,
                    isBlockGap: !0
                }).range(pos, end))), !next) break;
                pos = next.to + 1;
            }
            return Decoration.set(deco);
        }
        updateDeco() {
            let i = 0;
            var allDeco = this.view.state.facet(decorations).map(d => {
                return (this.dynamicDecorationMap[i++] = "function" == typeof d) ? d(this.view) : d;
            });
            let dynamicOuter = !1, outerDeco = this.view.state.facet(outerDecorations).map((d, i) => {
                var dynamic = "function" == typeof d;
                return dynamic && (dynamicOuter = !0), dynamic ? d(this.view) : d;
            });
            for (outerDeco.length && (this.dynamicDecorationMap[i++] = dynamicOuter, 
            allDeco.push(RangeSet.join(outerDeco))), this.decorations = [ ...allDeco, this.computeBlockGapDeco(), this.view.viewState.lineGapDeco ]; i < this.decorations.length; ) this.dynamicDecorationMap[i++] = !1;
            return this.decorations;
        }
        scrollIntoView(target) {
            if (target.isSnapshot) ref = this.view.viewState.lineBlockAt(target.range.head), 
            this.view.scrollDOM.scrollTop = ref.top - target.yMargin, this.view.scrollDOM.scrollLeft = target.xMargin; else {
                for (var handler of this.view.state.facet(scrollHandler)) try {
                    if (handler(this.view, target.range, target)) return !0;
                } catch (e) {
                    logException(this.view.state, e, "scroll handler");
                }
                var margins, offsetWidth, offsetHeight, ref = target["range"];
                let rect = this.coordsAt(ref.head, ref.empty ? ref.assoc : ref.head > ref.anchor ? -1 : 1), other;
                rect && (!ref.empty && (other = this.coordsAt(ref.anchor, ref.anchor > ref.head ? -1 : 1)) && (rect = {
                    left: Math.min(rect.left, other.left),
                    top: Math.min(rect.top, other.top),
                    right: Math.max(rect.right, other.right),
                    bottom: Math.max(rect.bottom, other.bottom)
                }), margins = getScrollMargins(this.view), margins = {
                    left: rect.left - margins.left,
                    top: rect.top - margins.top,
                    right: rect.right + margins.right,
                    bottom: rect.bottom + margins.bottom
                }, {
                    offsetWidth,
                    offsetHeight
                } = this.view.scrollDOM, scrollRectIntoView(this.view.scrollDOM, margins, ref.head < ref.anchor ? -1 : 1, target.x, target.y, Math.max(Math.min(target.xMargin, offsetWidth), -offsetWidth), Math.max(Math.min(target.yMargin, offsetHeight), -offsetHeight), this.view.textDirection == Direction.LTR));
            }
        }
    }
    class BlockGapWidget extends WidgetType {
        constructor(height) {
            super(), this.height = height;
        }
        toDOM() {
            var elt = document.createElement("div");
            return elt.className = "cm-gap", this.updateDOM(elt), elt;
        }
        eq(other) {
            return other.height == this.height;
        }
        updateDOM(elt) {
            return elt.style.height = this.height + "px", !0;
        }
        get editable() {
            return !0;
        }
        get estimatedHeight() {
            return this.height;
        }
        ignoreEvent() {
            return !1;
        }
    }
    function findCompositionNode(view, headPos) {
        var sel = view.observer.selectionRange;
        if (!sel.focusNode) return null;
        var descAfter, textBefore = textNodeBefore(sel.focusNode, sel.focusOffset), sel = textNodeAfter(sel.focusNode, sel.focusOffset);
        let textNode = textBefore || sel;
        return sel && textBefore && sel.node != textBefore.node && (!(descAfter = ContentView.get(sel.node)) || descAfter instanceof TextView && descAfter.text != sel.node.nodeValue || view.docView.lastCompositionAfterCursor && (descAfter = ContentView.get(textBefore.node)) && !(descAfter instanceof TextView && descAfter.text != textBefore.node.nodeValue)) && (textNode = sel), 
        view.docView.lastCompositionAfterCursor = textNode != textBefore, textNode ? {
            from: descAfter = headPos - textNode.offset,
            to: descAfter + textNode.node.nodeValue.length,
            node: textNode.node
        } : null;
    }
    let DecorationComparator$1 = class {
        constructor() {
            this.changes = [];
        }
        compareRange(from, to) {
            addRange(from, to, this.changes);
        }
        comparePoint(from, to) {
            addRange(from, to, this.changes);
        }
    };
    function yOverlap(a, b) {
        return a.top < b.bottom - 1 && a.bottom > b.top + 1;
    }
    function upTop(rect, top) {
        return top < rect.top ? {
            top: top,
            left: rect.left,
            right: rect.right,
            bottom: rect.bottom
        } : rect;
    }
    function upBot(rect, bottom) {
        return bottom > rect.bottom ? {
            top: rect.top,
            left: rect.left,
            right: rect.right,
            bottom: bottom
        } : rect;
    }
    function domPosAtCoords(parent, x, y) {
        let closest, closestRect, closestX, closestY, closestOverlap = !1, above, below, aboveRect, belowRect;
        for (let child = parent.firstChild; child; child = child.nextSibling) {
            var rects = clientRectsFor(child);
            for (let i = 0; i < rects.length; i++) {
                let rect = rects[i];
                var dx = function(x, rect) {
                    return rect.left > x ? rect.left - x : Math.max(0, x - rect.right);
                }(x, rect = closestRect && yOverlap(closestRect, rect) ? upTop(upBot(rect, closestRect.bottom), closestRect.top) : rect), dy = function(y, rect) {
                    return rect.top > y ? rect.top - y : Math.max(0, y - rect.bottom);
                }(y, rect);
                if (0 == dx && 0 == dy) return (3 == child.nodeType ? domPosInText : domPosAtCoords)(child, x, y);
                (!closest || closestY > dy || closestY == dy && closestX > dx) && (closest = child, 
                closestRect = rect, closestX = dx, dy = (closestY = dy) ? y < rect.top ? -1 : 1 : dx ? x < rect.left ? -1 : 1 : 0, 
                closestOverlap = !dy || (0 < dy ? i < rects.length - 1 : 0 < i)), 
                0 == dx ? y > rect.bottom && (!aboveRect || aboveRect.bottom < rect.bottom) ? (above = child, 
                aboveRect = rect) : y < rect.top && (!belowRect || belowRect.top > rect.top) && (below = child, 
                belowRect = rect) : aboveRect && yOverlap(aboveRect, rect) ? aboveRect = upBot(aboveRect, rect.bottom) : belowRect && yOverlap(belowRect, rect) && (belowRect = upTop(belowRect, rect.top));
            }
        }
        var clipX;
        return aboveRect && aboveRect.bottom >= y ? (closest = above, closestRect = aboveRect) : belowRect && belowRect.top <= y && (closest = below, 
        closestRect = belowRect), closest ? (clipX = Math.max(closestRect.left, Math.min(closestRect.right, x)), 
        3 == closest.nodeType ? domPosInText(closest, clipX, y) : closestOverlap && "false" != closest.contentEditable ? domPosAtCoords(closest, clipX, y) : {
            node: parent,
            offset: Array.prototype.indexOf.call(parent.childNodes, closest) + (x >= (closestRect.left + closestRect.right) / 2 ? 1 : 0)
        }) : {
            node: parent,
            offset: 0
        };
    }
    function domPosInText(node, x, y) {
        var len = node.nodeValue.length;
        let closestOffset = -1, closestDY = 1e9, generalSide = 0;
        for (let i = 0; i < len; i++) {
            var rects = textRange(node, i, i + 1).getClientRects();
            for (let j = 0; j < rects.length; j++) {
                var rect = rects[j];
                if (rect.top != rect.bottom) {
                    generalSide = generalSide || x - rect.left;
                    var dy = (rect.top > y ? rect.top - y : y - rect.bottom) - 1;
                    if (rect.left - 1 <= x && rect.right + 1 >= x && dy < closestDY) {
                        let right = x >= (rect.left + rect.right) / 2, after = right;
                        if ((browser.chrome || browser.gecko) && textRange(node, i).getBoundingClientRect().left == rect.right && (after = !right), 
                        dy <= 0) return {
                            node: node,
                            offset: i + (after ? 1 : 0)
                        };
                        closestOffset = i + (after ? 1 : 0), closestDY = dy;
                    }
                }
            }
        }
        return {
            node: node,
            offset: -1 < closestOffset ? closestOffset : 0 < generalSide ? node.nodeValue.length : 0
        };
    }
    function posAtCoords(view, coords, precise, bias = -1) {
        var content = view.contentDOM.getBoundingClientRect(), docTop = content.top + view.viewState.paddingTop;
        let block, docHeight = view.viewState["docHeight"], {
            x,
            y
        } = coords, yOffset = y - docTop;
        if (yOffset < 0) return 0;
        if (yOffset > docHeight) return view.state.doc.length;
        for (let halfLine = view.viewState.heightOracle.textHeight / 2, bounced = !1; (block = view.elementAtHeight(yOffset)).type != BlockType.Text; ) for (;!(0 <= (yOffset = 0 < bias ? block.bottom + halfLine : block.top - halfLine) && yOffset <= docHeight); ) {
            if (bounced) return precise ? null : 0;
            bounced = !0, bias = -bias;
        }
        y = docTop + yOffset;
        docTop = block.from;
        if (docTop < view.viewport.from) return 0 == view.viewport.from ? 0 : precise ? null : posAtCoordsImprecise(view, content, block, x, y);
        if (docTop > view.viewport.to) return view.viewport.to == view.state.doc.length ? view.state.doc.length : precise ? null : posAtCoordsImprecise(view, content, block, x, y);
        var doc = view.dom.ownerDocument, root = view.root.elementFromPoint ? view.root : doc;
        let element = root.elementFromPoint(x, y);
        (element = element && !view.contentDOM.contains(element) ? null : element) || (x = Math.max(content.left + 1, Math.min(content.right - 1, x)), 
        (element = root.elementFromPoint(x, y)) && !view.contentDOM.contains(element) && (element = null));
        let node, offset = -1;
        if (element && 0 != (null == (content = view.docView.nearest(element)) ? void 0 : content.isEditable) && (doc.caretPositionFromPoint ? (root = doc.caretPositionFromPoint(x, y)) && ({
            offsetNode: node,
            offset
        } = root) : doc.caretRangeFromPoint && (content = doc.caretRangeFromPoint(x, y)) && ({
            startContainer: node,
            startOffset: offset
        } = content, !view.contentDOM.contains(node) || browser.safari && function(node, offset, x) {
            let len;
            if (3 != node.nodeType || offset != (len = node.nodeValue.length)) return;
            for (let next = node.nextSibling; next; next = next.nextSibling) if (1 != next.nodeType || "BR" != next.nodeName) return;
            return textRange(node, len - 1, len).getBoundingClientRect().left > x;
        }(node, offset, x) || browser.chrome && function(node, offset, x) {
            if (0 != offset) return;
            for (let cur = node; ;) {
                var parent = cur.parentNode;
                if (!parent || 1 != parent.nodeType || parent.firstChild != cur) return;
                if (parent.classList.contains("cm-line")) break;
                cur = parent;
            }
            offset = (1 == node.nodeType ? node : textRange(node, 0, Math.max(node.nodeValue.length, 1))).getBoundingClientRect();
            return 5 < x - offset.left;
        }(node, offset, x)) && (node = void 0)), !node || !view.docView.dom.contains(node)) {
            root = LineView.find(view.docView, docTop);
            if (!root) return yOffset > block.top + block.height / 2 ? block.to : block.from;
            ({
                node,
                offset
            } = domPosAtCoords(root.dom, x, y));
        }
        doc = view.docView.nearest(node);
        return doc ? doc.isWidget && 1 == (null == (content = doc.dom) ? void 0 : content.nodeType) ? (docTop = doc.dom.getBoundingClientRect(), 
        coords.y < docTop.top || coords.y <= docTop.bottom && coords.x <= (docTop.left + docTop.right) / 2 ? doc.posAtStart : doc.posAtEnd) : doc.localPosFromDOM(node, offset) + doc.posAtStart : null;
    }
    function posAtCoordsImprecise(view, contentRect, block, x, y) {
        let into = Math.round((x - contentRect.left) * view.defaultCharacterWidth);
        view.lineWrapping && block.height > 1.5 * view.defaultLineHeight && (x = view.viewState.heightOracle.textHeight, 
        contentRect = Math.floor((y - block.top - .5 * (view.defaultLineHeight - x)) / x), 
        into += contentRect * view.viewState.heightOracle.lineLength);
        y = view.state.sliceDoc(block.from, block.to);
        return block.from + findColumn(y, into, view.state.tabSize);
    }
    function blockAt(view, pos) {
        var line = view.lineBlockAt(pos);
        if (Array.isArray(line.type)) for (var l of line.type) if (l.to > pos || l.to == pos && (l.to == line.to || l.type == BlockType.Text)) return l;
        return line;
    }
    function moveByChar(view, start, forward, by) {
        let line = view.state.doc.lineAt(start.head), spans = view.bidiSpans(line);
        var direction = view.textDirectionAt(line.from);
        for (let cur = start, check = null; ;) {
            let next = function(line, order, dir, start, forward) {
                let startIndex = start.head - line.from, spanI = BidiSpan.find(order, startIndex, null != (_a = start.bidiLevel) ? _a : -1, start.assoc), span = order[spanI], spanEnd = span.side(forward, dir);
                if (startIndex == spanEnd) {
                    var _a = spanI += forward ? 1 : -1;
                    if (_a < 0 || _a >= order.length) return null;
                    span = order[spanI = _a], startIndex = span.side(!forward, dir), 
                    spanEnd = span.side(forward, dir);
                }
                let nextIndex = findClusterBreak(line.text, startIndex, span.forward(forward, dir));
                return (nextIndex < span.from || nextIndex > span.to) && (nextIndex = spanEnd), 
                movedOver = line.text.slice(Math.min(startIndex, nextIndex), Math.max(startIndex, nextIndex)), 
                (start = spanI == (forward ? order.length - 1 : 0) ? null : order[spanI + (forward ? 1 : -1)]) && nextIndex == spanEnd && start.level + (forward ? 0 : 1) < span.level ? EditorSelection.cursor(start.side(!forward, dir) + line.from, start.forward(forward, dir) ? 1 : -1, start.level) : EditorSelection.cursor(nextIndex + line.from, span.forward(forward, dir) ? -1 : 1, span.level);
            }(line, spans, direction, cur, forward), char = movedOver;
            if (!next) {
                if (line.number == (forward ? view.state.doc.lines : 1)) return cur;
                char = "\n", line = view.state.doc.line(line.number + (forward ? 1 : -1)), 
                spans = view.bidiSpans(line), next = view.visualLineSide(line, !forward);
            }
            if (check) {
                if (!check(char)) return cur;
            } else {
                if (!by) return next;
                check = by(char);
            }
            cur = next;
        }
    }
    function skipAtomicRanges(atoms, pos, bias) {
        for (;;) {
            let moved = 0;
            for (var set of atoms) set.between(pos - 1, pos + 1, (from, to, value) => {
                var side;
                from < pos && pos < to && (side = moved || bias || (pos - from < to - pos ? -1 : 1), 
                pos = side < 0 ? from : to, moved = side);
            });
            if (!moved) return pos;
        }
    }
    function skipAtoms(view, oldPos, pos) {
        oldPos = skipAtomicRanges(view.state.facet(atomicRanges).map(f => f(view)), pos.from, oldPos.head > pos.from ? -1 : 1);
        return oldPos == pos.from ? pos : EditorSelection.cursor(oldPos, oldPos < pos.from ? 1 : -1);
    }
    class InputState {
        setSelectionOrigin(origin) {
            this.lastSelectionOrigin = origin, this.lastSelectionTime = Date.now();
        }
        constructor(view) {
            this.view = view, this.lastKeyCode = 0, this.lastKeyTime = 0, this.lastTouchTime = 0, 
            this.lastFocusTime = 0, this.lastScrollTop = 0, this.lastScrollLeft = 0, 
            this.pendingIOSKey = void 0, this.lastSelectionOrigin = null, this.lastSelectionTime = 0, 
            this.lastEscPress = 0, this.lastContextMenu = 0, this.scrollHandlers = [], 
            this.handlers = Object.create(null), this.composing = -1, this.compositionFirstChange = null, 
            this.compositionEndedAt = 0, this.compositionPendingKey = !1, this.compositionPendingChange = !1, 
            this.mouseSelection = null, this.draggedContent = null, this.handleEvent = this.handleEvent.bind(this), 
            this.notifiedFocused = view.hasFocus, browser.safari && view.contentDOM.addEventListener("input", () => null), 
            browser.gecko && (view = view.contentDOM.ownerDocument, appliedFirefoxHack.has(view) || (appliedFirefoxHack.add(view), 
            view.addEventListener("copy", () => {}), view.addEventListener("cut", () => {})));
        }
        handleEvent(event) {
            !function(view, event) {
                if (event.bubbles) {
                    if (event.defaultPrevented) return;
                    for (let node = event.target, cView; node != view.contentDOM; node = node.parentNode) if (!node || 11 == node.nodeType || (cView = ContentView.get(node)) && cView.ignoreEvent(event)) return;
                }
                return 1;
            }(this.view, event) || this.ignoreDuringComposition(event) || "keydown" == event.type && this.keydown(event) || this.runHandlers(event.type, event);
        }
        runHandlers(type, event) {
            type = this.handlers[type];
            if (type) {
                for (var observer of type.observers) observer(this.view, event);
                for (var handler of type.handlers) {
                    if (event.defaultPrevented) break;
                    if (handler(this.view, event)) {
                        event.preventDefault();
                        break;
                    }
                }
            }
        }
        ensureHandlers(plugins) {
            var type, handlers = computeHandlers(plugins), prev = this.handlers, dom = this.view.contentDOM;
            for (type in handlers) if ("scroll" != type) {
                var passive = !handlers[type].handlers.length;
                let exists = prev[type];
                exists && passive != !exists.handlers.length && (dom.removeEventListener(type, this.handleEvent), 
                exists = null), exists || dom.addEventListener(type, this.handleEvent, {
                    passive: passive
                });
            }
            for (let type in prev) "scroll" == type || handlers[type] || dom.removeEventListener(type, this.handleEvent);
            this.handlers = handlers;
        }
        keydown(event) {
            if (this.lastKeyCode = event.keyCode, this.lastKeyTime = Date.now(), 
            9 == event.keyCode && Date.now() < this.lastEscPress + 2e3) return !0;
            if (27 != event.keyCode && modifierCodes.indexOf(event.keyCode) < 0 && (this.view.inputState.lastEscPress = 0), 
            browser.android && browser.chrome && !event.synthetic && (13 == event.keyCode || 8 == event.keyCode)) return this.view.observer.delayAndroidKey(event.key, event.keyCode), 
            !0;
            let pending;
            return !browser.ios || event.synthetic || event.altKey || event.metaKey || !((pending = PendingKeys.find(key => key.keyCode == event.keyCode)) && !event.ctrlKey || -1 < EmacsyPendingKeys.indexOf(event.key) && event.ctrlKey && !event.shiftKey) ? (229 != event.keyCode && this.view.observer.forceFlush(), 
            !1) : (this.pendingIOSKey = pending || event, setTimeout(() => this.flushIOSKey(), 250), 
            !0);
        }
        flushIOSKey(change) {
            var key = this.pendingIOSKey;
            return !(!key || "Enter" == key.key && change && change.from < change.to && /^\S+$/.test(change.insert.toString())) && (this.pendingIOSKey = void 0, 
            dispatchKey(this.view.contentDOM, key.key, key.keyCode, key instanceof KeyboardEvent ? key : void 0));
        }
        ignoreDuringComposition(event) {
            return !!/^key/.test(event.type) && (0 < this.composing || !!(browser.safari && !browser.ios && this.compositionPendingKey && Date.now() - this.compositionEndedAt < 100) && !(this.compositionPendingKey = !1));
        }
        startMouseSelection(mouseSelection) {
            this.mouseSelection && this.mouseSelection.destroy(), this.mouseSelection = mouseSelection;
        }
        update(update) {
            this.mouseSelection && this.mouseSelection.update(update), this.draggedContent && update.docChanged && (this.draggedContent = this.draggedContent.map(update.changes)), 
            update.transactions.length && (this.lastKeyCode = this.lastSelectionTime = 0);
        }
        destroy() {
            this.mouseSelection && this.mouseSelection.destroy();
        }
    }
    function bindHandler(plugin, handler) {
        return (view, event) => {
            try {
                return handler.call(plugin, event, view);
            } catch (e) {
                logException(view.state, e);
            }
        };
    }
    function computeHandlers(plugins) {
        let result = Object.create(null);
        function record(type) {
            return result[type] || (result[type] = {
                observers: [],
                handlers: []
            });
        }
        for (var plugin of plugins) {
            var spec = plugin.spec;
            if (spec && spec.domEventHandlers) for (var type in spec.domEventHandlers) {
                var f = spec.domEventHandlers[type];
                f && record(type).handlers.push(bindHandler(plugin.value, f));
            }
            if (spec && spec.domEventObservers) for (let type in spec.domEventObservers) {
                let f = spec.domEventObservers[type];
                f && record(type).observers.push(bindHandler(plugin.value, f));
            }
        }
        for (let type in handlers) record(type).handlers.push(handlers[type]);
        for (let type in observers) record(type).observers.push(observers[type]);
        return result;
    }
    const PendingKeys = [ {
        key: "Backspace",
        keyCode: 8,
        inputType: "deleteContentBackward"
    }, {
        key: "Enter",
        keyCode: 13,
        inputType: "insertParagraph"
    }, {
        key: "Enter",
        keyCode: 13,
        inputType: "insertLineBreak"
    }, {
        key: "Delete",
        keyCode: 46,
        inputType: "deleteContentForward"
    } ], EmacsyPendingKeys = "dthko", modifierCodes = [ 16, 17, 18, 20, 91, 92, 224, 225 ];
    function dragScrollSpeed(dist) {
        return .7 * Math.max(0, dist) + 8;
    }
    class MouseSelection {
        constructor(view, startEvent, style, mustSelect) {
            this.view = view, this.startEvent = startEvent, this.style = style, 
            this.mustSelect = mustSelect, this.scrollSpeed = {
                x: 0,
                y: 0
            }, this.scrolling = -1, this.lastEvent = startEvent, this.scrollParent = function(dom) {
                var doc = dom.ownerDocument;
                for (let cur = dom.parentNode; cur && cur != doc.body; ) if (1 == cur.nodeType) {
                    if (cur.scrollHeight > cur.clientHeight || cur.scrollWidth > cur.clientWidth) return cur;
                    cur = cur.assignedSlot || cur.parentNode;
                } else {
                    if (11 != cur.nodeType) break;
                    cur = cur.host;
                }
                return null;
            }(view.contentDOM), this.atoms = view.state.facet(atomicRanges).map(f => f(view));
            style = view.contentDOM.ownerDocument;
            style.addEventListener("mousemove", this.move = this.move.bind(this)), 
            style.addEventListener("mouseup", this.up = this.up.bind(this)), this.extend = startEvent.shiftKey, 
            this.multiple = view.state.facet(EditorState.allowMultipleSelections) && function(view, event) {
                view = view.state.facet(clickAddsSelectionRange);
                return view.length ? view[0](event) : browser.mac ? event.metaKey : event.ctrlKey;
            }(view, startEvent), this.dragging = !(!function(view, event) {
                var main = view.state.selection["main"];
                if (!main.empty) {
                    main = getSelection(view.root);
                    if (!main || 0 == main.rangeCount) return 1;
                    var rects = main.getRangeAt(0).getClientRects();
                    for (let i = 0; i < rects.length; i++) {
                        var rect = rects[i];
                        if (rect.left <= event.clientX && rect.right >= event.clientX && rect.top <= event.clientY && rect.bottom >= event.clientY) return 1;
                    }
                }
                return;
            }(view, startEvent) || 1 != getClickType(startEvent)) && null;
        }
        start(event) {
            !1 === this.dragging && this.select(event);
        }
        move(event) {
            var a;
            if (0 == event.buttons) return this.destroy();
            if (!(this.dragging || null == this.dragging && (a = this.startEvent, 
            b = event, Math.max(Math.abs(a.clientX - b.clientX), Math.abs(a.clientY - b.clientY)) < 10))) {
                this.select(this.lastEvent = event);
                let sx = 0, sy = 0;
                var b = (null == (a = this.scrollParent) ? void 0 : a.getBoundingClientRect()) || {
                    left: 0,
                    top: 0,
                    right: this.view.win.innerWidth,
                    bottom: this.view.win.innerHeight
                }, margins = getScrollMargins(this.view);
                event.clientX - margins.left <= b.left + 6 ? sx = -dragScrollSpeed(b.left - event.clientX) : event.clientX + margins.right >= b.right - 6 && (sx = dragScrollSpeed(event.clientX - b.right)), 
                event.clientY - margins.top <= b.top + 6 ? sy = -dragScrollSpeed(b.top - event.clientY) : event.clientY + margins.bottom >= b.bottom - 6 && (sy = dragScrollSpeed(event.clientY - b.bottom)), 
                this.setScrollSpeed(sx, sy);
            }
        }
        up(event) {
            null == this.dragging && this.select(this.lastEvent), this.dragging || event.preventDefault(), 
            this.destroy();
        }
        destroy() {
            this.setScrollSpeed(0, 0);
            var doc = this.view.contentDOM.ownerDocument;
            doc.removeEventListener("mousemove", this.move), doc.removeEventListener("mouseup", this.up), 
            this.view.inputState.mouseSelection = this.view.inputState.draggedContent = null;
        }
        setScrollSpeed(sx, sy) {
            this.scrollSpeed = {
                x: sx,
                y: sy
            }, sx || sy ? this.scrolling < 0 && (this.scrolling = setInterval(() => this.scroll(), 50)) : -1 < this.scrolling && (clearInterval(this.scrolling), 
            this.scrolling = -1);
        }
        scroll() {
            this.scrollParent ? (this.scrollParent.scrollLeft += this.scrollSpeed.x, 
            this.scrollParent.scrollTop += this.scrollSpeed.y) : this.view.win.scrollBy(this.scrollSpeed.x, this.scrollSpeed.y), 
            !1 === this.dragging && this.select(this.lastEvent);
        }
        skipAtoms(sel) {
            let ranges = null;
            for (let i = 0; i < sel.ranges.length; i++) {
                let range = sel.ranges[i], updated = null;
                var pos, to;
                range.empty ? (pos = skipAtomicRanges(this.atoms, range.from, 0)) != range.from && (updated = EditorSelection.cursor(pos, -1)) : (pos = skipAtomicRanges(this.atoms, range.from, -1), 
                to = skipAtomicRanges(this.atoms, range.to, 1), pos == range.from && to == range.to || (updated = EditorSelection.range(range.from == range.anchor ? pos : to, range.from == range.head ? pos : to))), 
                updated && ((ranges = ranges || sel.ranges.slice())[i] = updated);
            }
            return ranges ? EditorSelection.create(ranges, sel.mainIndex) : sel;
        }
        select(event) {
            var view = this["view"], event = this.skipAtoms(this.style.get(event, this.extend, this.multiple));
            !this.mustSelect && event.eq(view.state.selection, !1 === this.dragging) || this.view.dispatch({
                selection: event,
                userEvent: "select.pointer"
            }), this.mustSelect = !1;
        }
        update(update) {
            this.style.update(update) && setTimeout(() => this.select(this.lastEvent), 20);
        }
    }
    const handlers = Object.create(null), observers = Object.create(null), brokenClipboardAPI = browser.ie && browser.ie_version < 15 || browser.ios && browser.webkit_version < 604;
    function doPaste(view, input) {
        let state = view["state"], changes, i = 1, text = state.toText(input), byLine = text.lines == state.selection.ranges.length;
        if (null != lastLinewiseCopy && state.selection.ranges.every(r => r.empty) && lastLinewiseCopy == text.toString()) {
            let lastLine = -1;
            changes = state.changeByRange(range => {
                var line = state.doc.lineAt(range.from);
                if (line.from == lastLine) return {
                    range: range
                };
                lastLine = line.from;
                var insert = state.toText((byLine ? text.line(i++).text : input) + state.lineBreak);
                return {
                    changes: {
                        from: line.from,
                        insert: insert
                    },
                    range: EditorSelection.cursor(range.from + insert.length)
                };
            });
        } else changes = byLine ? state.changeByRange(range => {
            var line = text.line(i++);
            return {
                changes: {
                    from: range.from,
                    to: range.to,
                    insert: line.text
                },
                range: EditorSelection.cursor(range.from + line.length)
            };
        }) : state.replaceSelection(text);
        view.dispatch(changes, {
            userEvent: "input.paste",
            scrollIntoView: !0
        });
    }
    function rangeForClick(view, pos, bias, type) {
        if (1 == type) return EditorSelection.cursor(pos, bias);
        if (2 == type) return function(state, pos, bias = 1) {
            var categorize = state.charCategorizer(pos), line = state.doc.lineAt(pos), state = pos - line.from;
            if (0 == line.length) return EditorSelection.cursor(pos);
            0 == state ? bias = 1 : state == line.length && (bias = -1);
            let from = state, to = state;
            bias < 0 ? from = findClusterBreak(line.text, state, !1) : to = findClusterBreak(line.text, state);
            for (var cat = categorize(line.text.slice(from, to)); 0 < from; ) {
                var prev = findClusterBreak(line.text, from, !1);
                if (categorize(line.text.slice(prev, from)) != cat) break;
                from = prev;
            }
            for (;to < line.length; ) {
                var next = findClusterBreak(line.text, to);
                if (categorize(line.text.slice(to, next)) != cat) break;
                to = next;
            }
            return EditorSelection.range(from + line.from, to + line.from);
        }(view.state, pos, bias);
        {
            type = LineView.find(view.docView, pos), bias = view.state.doc.lineAt(type ? type.posAtEnd : pos);
            let from = type ? type.posAtStart : bias.from, to = type ? type.posAtEnd : bias.to;
            return to < view.state.doc.length && to == bias.to && to++, EditorSelection.range(from, to);
        }
    }
    observers.scroll = view => {
        view.inputState.lastScrollTop = view.scrollDOM.scrollTop, view.inputState.lastScrollLeft = view.scrollDOM.scrollLeft;
    }, handlers.keydown = (view, event) => (view.inputState.setSelectionOrigin("select"), 
    27 == event.keyCode && (view.inputState.lastEscPress = Date.now()), !1), observers.touchstart = (view, e) => {
        view.inputState.lastTouchTime = Date.now(), view.inputState.setSelectionOrigin("select.pointer");
    }, observers.touchmove = view => {
        view.inputState.setSelectionOrigin("select.pointer");
    }, handlers.mousedown = (view, event) => {
        if (view.observer.flush(), !(view.inputState.lastTouchTime > Date.now() - 2e3)) {
            let style = null;
            for (var makeStyle of view.state.facet(mouseSelectionStyle)) if (style = makeStyle(view, event)) break;
            if (style = style || 0 != event.button ? style : function(view, event) {
                let start = queryPos(view, event), type = getClickType(event), startSel = view.state.selection;
                return {
                    update(update) {
                        update.docChanged && (start.pos = update.changes.mapPos(start.pos), 
                        startSel = startSel.map(update.changes));
                    },
                    get(event, extend, multiple) {
                        let cur = queryPos(view, event), removed, range = rangeForClick(view, cur.pos, cur.bias, type);
                        var from;
                        return start.pos == cur.pos || extend || (event = rangeForClick(view, start.pos, start.bias, type), 
                        from = Math.min(event.from, range.from), event = Math.max(event.to, range.to), 
                        range = from < range.from ? EditorSelection.range(from, event) : EditorSelection.range(event, from)), 
                        extend ? startSel.replaceRange(startSel.main.extend(range.from, range.to)) : multiple && 1 == type && 1 < startSel.ranges.length && (removed = function(sel, pos) {
                            for (let i = 0; i < sel.ranges.length; i++) {
                                var {
                                    from,
                                    to
                                } = sel.ranges[i];
                                if (from <= pos && pos <= to) return EditorSelection.create(sel.ranges.slice(0, i).concat(sel.ranges.slice(i + 1)), sel.mainIndex == i ? 0 : sel.mainIndex - (sel.mainIndex > i ? 1 : 0));
                            }
                            return null;
                        }(startSel, cur.pos)) ? removed : multiple ? startSel.addRange(range) : EditorSelection.create([ range ]);
                    }
                };
            }(view, event)) {
                var mustFocus = !view.hasFocus, mustFocus = (view.inputState.startMouseSelection(new MouseSelection(view, event, style, mustFocus)), 
                mustFocus && view.observer.ignore(() => focusPreventScroll(view.contentDOM)), 
                view.inputState.mouseSelection);
                if (mustFocus) return mustFocus.start(event), !1 === mustFocus.dragging;
            }
        }
        return !1;
    };
    let insideY = (y, rect) => y >= rect.top && y <= rect.bottom, inside = (x, y, rect) => insideY(y, rect) && x >= rect.left && x <= rect.right;
    function queryPos(view, event) {
        var pos = view.posAtCoords({
            x: event.clientX,
            y: event.clientY
        }, !1);
        return {
            pos: pos,
            bias: function(view, pos, x, y) {
                var before;
                return (view = LineView.find(view.docView, pos)) && 0 != (pos = pos - view.posAtStart) && (pos == view.length || (before = view.coordsAt(pos, -1)) && inside(x, y, before) || (!(view = view.coordsAt(pos, 1)) || !inside(x, y, view)) && before && insideY(y, before)) ? -1 : 1;
            }(view, pos, event.clientX, event.clientY)
        };
    }
    const BadMouseDetail = browser.ie && browser.ie_version <= 11;
    let lastMouseDown = null, lastMouseDownCount = 0, lastMouseDownTime = 0;
    function getClickType(event) {
        var last, lastTime;
        return BadMouseDetail ? (last = lastMouseDown, lastTime = lastMouseDownTime, 
        lastMouseDown = event, lastMouseDownTime = Date.now(), lastMouseDownCount = !last || lastTime > Date.now() - 400 && Math.abs(last.clientX - event.clientX) < 2 && Math.abs(last.clientY - event.clientY) < 2 ? (lastMouseDownCount + 1) % 3 : 1) : event.detail;
    }
    function dropText(view, event, text, direct) {
        var dropPos, draggedContent;
        text && (dropPos = view.posAtCoords({
            x: event.clientX,
            y: event.clientY
        }, !1), draggedContent = view.inputState["draggedContent"], direct = direct && draggedContent && function(view, event) {
            return (view = view.state.facet(dragMovesSelection$1)).length ? view[0](event) : browser.mac ? !event.altKey : !event.ctrlKey;
        }(view, event) ? {
            from: draggedContent.from,
            to: draggedContent.to
        } : null, event = {
            from: dropPos,
            insert: text
        }, draggedContent = view.state.changes(direct ? [ direct, event ] : event), 
        view.focus(), view.dispatch({
            changes: draggedContent,
            selection: {
                anchor: draggedContent.mapPos(dropPos, -1),
                head: draggedContent.mapPos(dropPos, 1)
            },
            userEvent: direct ? "move.drop" : "input.drop"
        }), view.inputState.draggedContent = null);
    }
    handlers.dragstart = (view, event) => {
        let range = view.state["selection"]["main"];
        var cView, from = (event.target.draggable && (cView = view.docView.nearest(event.target)) && cView.isWidget && (cView = (from = cView.posAtStart) + cView.length, 
        from >= range.to || cView <= range.from) && (range = EditorSelection.range(from, cView)), 
        view)["inputState"];
        return from.mouseSelection && (from.mouseSelection.dragging = !0), from.draggedContent = range, 
        event.dataTransfer && (event.dataTransfer.setData("Text", view.state.sliceDoc(range.from, range.to)), 
        event.dataTransfer.effectAllowed = "copyMove"), !1;
    }, handlers.dragend = view => (view.inputState.draggedContent = null, !1), handlers.drop = (view, event) => {
        if (!event.dataTransfer) return !1;
        if (view.state.readOnly) return !0;
        let files = event.dataTransfer.files;
        if (files && files.length) {
            let text = Array(files.length), read = 0, finishFile = () => {
                ++read == files.length && dropText(view, event, text.filter(s => null != s).join(view.state.lineBreak), !1);
            };
            for (let i = 0; i < files.length; i++) {
                let reader = new FileReader();
                reader.onerror = finishFile, reader.onload = () => {
                    /[\x00-\x08\x0e-\x1f]{2}/.test(reader.result) || (text[i] = reader.result), 
                    finishFile();
                }, reader.readAsText(files[i]);
            }
            return !0;
        }
        var text = event.dataTransfer.getData("Text");
        return !!text && (dropText(view, event, text, !0), !0);
    }, handlers.paste = (view, event) => {
        if (view.state.readOnly) return !0;
        view.observer.flush();
        event = brokenClipboardAPI ? null : event.clipboardData;
        return event ? (doPaste(view, event.getData("text/plain") || event.getData("text/uri-list")), 
        !0) : (function(view) {
            var parent = view.dom.parentNode;
            if (parent) {
                let target = parent.appendChild(document.createElement("textarea"));
                target.style.cssText = "position: fixed; left: -10000px; top: 10px", 
                target.focus(), setTimeout(() => {
                    view.focus(), target.remove(), doPaste(view, target.value);
                }, 50);
            }
        }(view), !1);
    };
    let lastLinewiseCopy = null;
    handlers.copy = handlers.cut = (view, event) => {
        var {
            text,
            ranges,
            linewise
        } = function(state) {
            let content = [], ranges = [], linewise = !1;
            for (var range of state.selection.ranges) range.empty || (content.push(state.sliceDoc(range.from, range.to)), 
            ranges.push(range));
            if (!content.length) {
                let upto = -1;
                for (var {
                    from
                } of state.selection.ranges) {
                    from = state.doc.lineAt(from);
                    from.number > upto && (content.push(from.text), ranges.push({
                        from: from.from,
                        to: Math.min(state.doc.length, from.to + 1)
                    })), upto = from.number;
                }
                linewise = !0;
            }
            return {
                text: content.join(state.lineBreak),
                ranges: ranges,
                linewise: linewise
            };
        }(view.state);
        if (!text && !linewise) return !1;
        lastLinewiseCopy = linewise ? text : null, "cut" != event.type || view.state.readOnly || view.dispatch({
            changes: ranges,
            scrollIntoView: !0,
            userEvent: "delete.cut"
        });
        linewise = brokenClipboardAPI ? null : event.clipboardData;
        return linewise ? (linewise.clearData(), linewise.setData("text/plain", text), 
        !0) : (function(view, text) {
            var parent = view.dom.parentNode;
            if (parent) {
                let target = parent.appendChild(document.createElement("textarea"));
                target.style.cssText = "position: fixed; left: -10000px; top: 10px", 
                target.value = text, target.focus(), target.selectionEnd = text.length, 
                target.selectionStart = 0, setTimeout(() => {
                    target.remove(), view.focus();
                }, 50);
            }
        }(view, text), !1);
    };
    const isFocusChange = Annotation.define();
    function focusChangeTransaction(state, focus) {
        var getEffect, effects = [];
        for (getEffect of state.facet(focusChangeEffect)) {
            var effect = getEffect(state, focus);
            effect && effects.push(effect);
        }
        return effects ? state.update({
            effects: effects,
            annotations: isFocusChange.of(!0)
        }) : null;
    }
    function updateForFocusChange(view) {
        setTimeout(() => {
            var focus = view.hasFocus;
            focus != view.inputState.notifiedFocused && ((focus = focusChangeTransaction(view.state, focus)) ? view.dispatch(focus) : view.update([]));
        }, 10);
    }
    observers.focus = view => {
        view.inputState.lastFocusTime = Date.now(), view.scrollDOM.scrollTop || !view.inputState.lastScrollTop && !view.inputState.lastScrollLeft || (view.scrollDOM.scrollTop = view.inputState.lastScrollTop, 
        view.scrollDOM.scrollLeft = view.inputState.lastScrollLeft), updateForFocusChange(view);
    }, observers.blur = view => {
        view.observer.clearSelectionRange(), updateForFocusChange(view);
    }, observers.compositionstart = observers.compositionupdate = view => {
        null == view.inputState.compositionFirstChange && (view.inputState.compositionFirstChange = !0), 
        view.inputState.composing < 0 && (view.inputState.composing = 0);
    }, observers.compositionend = view => {
        view.inputState.composing = -1, view.inputState.compositionEndedAt = Date.now(), 
        view.inputState.compositionPendingKey = !0, view.inputState.compositionPendingChange = 0 < view.observer.pendingRecords().length, 
        view.inputState.compositionFirstChange = null, browser.chrome && browser.android ? view.observer.flushSoon() : view.inputState.compositionPendingChange ? Promise.resolve().then(() => view.observer.flush()) : setTimeout(() => {
            view.inputState.composing < 0 && view.docView.hasComposition && view.update([]);
        }, 50);
    }, observers.contextmenu = view => {
        view.inputState.lastContextMenu = Date.now();
    }, handlers.beforeinput = (view, event) => {
        var _a;
        let pending;
        if (browser.chrome && browser.android && (pending = PendingKeys.find(key => key.inputType == event.inputType)) && (view.observer.delayAndroidKey(pending.key, pending.keyCode), 
        "Backspace" == pending.key || "Delete" == pending.key)) {
            let startViewHeight = (null == (_a = window.visualViewport) ? void 0 : _a.height) || 0;
            setTimeout(() => {
                var _a;
                ((null == (_a = window.visualViewport) ? void 0 : _a.height) || 0) > startViewHeight + 10 && view.hasFocus && (view.contentDOM.blur(), 
                view.focus());
            }, 100);
        }
        return browser.ios && "deleteContentForward" == event.inputType && view.observer.flushSoon(), 
        browser.safari && "insertText" == event.inputType && 0 <= view.inputState.composing && setTimeout(() => observers.compositionend(view, event), 20), 
        !1;
    };
    const appliedFirefoxHack = new Set();
    const wrappingWhiteSpace = [ "pre-wrap", "normal", "pre-line", "break-spaces" ];
    class HeightOracle {
        constructor(lineWrapping) {
            this.lineWrapping = lineWrapping, this.doc = Text.empty, this.heightSamples = {}, 
            this.lineHeight = 14, this.charWidth = 7, this.textHeight = 14, this.lineLength = 30, 
            this.heightChanged = !1;
        }
        heightForGap(from, to) {
            let lines = this.doc.lineAt(to).number - this.doc.lineAt(from).number + 1;
            return this.lineWrapping && (lines += Math.max(0, Math.ceil((to - from - lines * this.lineLength * .5) / this.lineLength))), 
            this.lineHeight * lines;
        }
        heightForLine(length) {
            return this.lineWrapping ? (1 + Math.max(0, Math.ceil((length - this.lineLength) / (this.lineLength - 5)))) * this.lineHeight : this.lineHeight;
        }
        setDoc(doc) {
            return this.doc = doc, this;
        }
        mustRefreshForWrapping(whiteSpace) {
            return -1 < wrappingWhiteSpace.indexOf(whiteSpace) != this.lineWrapping;
        }
        mustRefreshForHeights(lineHeights) {
            let newHeight = !1;
            for (let i = 0; i < lineHeights.length; i++) {
                var h = lineHeights[i];
                h < 0 ? i++ : this.heightSamples[Math.floor(10 * h)] || (newHeight = !0, 
                this.heightSamples[Math.floor(10 * h)] = !0);
            }
            return newHeight;
        }
        refresh(whiteSpace, lineHeight, charWidth, textHeight, lineLength, knownHeights) {
            var whiteSpace = -1 < wrappingWhiteSpace.indexOf(whiteSpace), changed = Math.round(lineHeight) != Math.round(this.lineHeight) || this.lineWrapping != whiteSpace;
            if (this.lineWrapping = whiteSpace, this.lineHeight = lineHeight, this.charWidth = charWidth, 
            this.textHeight = textHeight, this.lineLength = lineLength, changed) {
                this.heightSamples = {};
                for (let i = 0; i < knownHeights.length; i++) {
                    var h = knownHeights[i];
                    h < 0 ? i++ : this.heightSamples[Math.floor(10 * h)] = !0;
                }
            }
            return changed;
        }
    }
    class MeasuredHeights {
        constructor(from, heights) {
            this.from = from, this.heights = heights, this.index = 0;
        }
        get more() {
            return this.index < this.heights.length;
        }
    }
    class BlockInfo {
        constructor(from, length, top, height, _content) {
            this.from = from, this.length = length, this.top = top, this.height = height, 
            this._content = _content;
        }
        get type() {
            return "number" == typeof this._content ? BlockType.Text : Array.isArray(this._content) ? this._content : this._content.type;
        }
        get to() {
            return this.from + this.length;
        }
        get bottom() {
            return this.top + this.height;
        }
        get widget() {
            return this._content instanceof PointDecoration ? this._content.widget : null;
        }
        get widgetLineBreaks() {
            return "number" == typeof this._content ? this._content : 0;
        }
        join(other) {
            var content = (Array.isArray(this._content) ? this._content : [ this ]).concat(Array.isArray(other._content) ? other._content : [ other ]);
            return new BlockInfo(this.from, this.length + other.length, this.top, this.height + other.height, content);
        }
    }
    var QueryType$1 = function(QueryType) {
        return QueryType[QueryType.ByPos = 0] = "ByPos", QueryType[QueryType.ByHeight = 1] = "ByHeight", 
        QueryType[QueryType.ByPosNoHeight = 2] = "ByPosNoHeight", QueryType;
    }(QueryType$1 = QueryType$1 || {});
    class HeightMap {
        constructor(length, height, flags = 2) {
            this.length = length, this.height = height, this.flags = flags;
        }
        get outdated() {
            return 0 < (2 & this.flags);
        }
        set outdated(value) {
            this.flags = (value ? 2 : 0) | -3 & this.flags;
        }
        setHeight(oracle, height) {
            this.height != height && (.001 < Math.abs(this.height - height) && (oracle.heightChanged = !0), 
            this.height = height);
        }
        replace(_from, _to, nodes) {
            return HeightMap.of(nodes);
        }
        decomposeLeft(_to, result) {
            result.push(this);
        }
        decomposeRight(_from, result) {
            result.push(this);
        }
        applyChanges(decorations, oldDoc, oracle, changes) {
            let me = this, doc = oracle.doc;
            for (let i = changes.length - 1; 0 <= i; i--) {
                let {
                    fromA,
                    toA,
                    fromB,
                    toB
                } = changes[i], start = me.lineAt(fromA, QueryType$1.ByPosNoHeight, oracle.setDoc(oldDoc), 0, 0);
                var end = start.to >= toA ? start : me.lineAt(toA, QueryType$1.ByPosNoHeight, oracle, 0, 0);
                for (toB += end.to - toA, toA = end.to; 0 < i && start.from <= changes[i - 1].toA; ) fromA = changes[i - 1].fromA, 
                fromB = changes[i - 1].fromB, i--, fromA < start.from && (start = me.lineAt(fromA, QueryType$1.ByPosNoHeight, oracle, 0, 0));
                fromB += start.from - fromA, fromA = start.from;
                end = NodeBuilder.build(oracle.setDoc(doc), decorations, fromB, toB);
                me = me.replace(fromA, toA, end);
            }
            return me.updateHeight(oracle, 0);
        }
        static empty() {
            return new HeightMapText(0, 0);
        }
        static of(nodes) {
            if (1 == nodes.length) return nodes[0];
            let i = 0, j = nodes.length, before = 0, after = 0;
            for (;;) if (i == j) if (before > 2 * after) {
                var split = nodes[i - 1];
                split.break ? nodes.splice(--i, 1, split.left, null, split.right) : nodes.splice(--i, 1, split.left, split.right), 
                j += 1 + split.break, before -= split.size;
            } else {
                if (!(after > 2 * before)) break;
                {
                    let split = nodes[j];
                    split.break ? nodes.splice(j, 1, split.left, null, split.right) : nodes.splice(j, 1, split.left, split.right), 
                    j += 2 + split.break, after -= split.size;
                }
            } else if (before < after) {
                split = nodes[i++];
                split && (before += split.size);
            } else {
                let next = nodes[--j];
                next && (after += next.size);
            }
            let brk = 0;
            return null == nodes[i - 1] ? (brk = 1, i--) : null == nodes[i] && (brk = 1, 
            j++), new HeightMapBranch(HeightMap.of(nodes.slice(0, i)), brk, HeightMap.of(nodes.slice(j)));
        }
    }
    HeightMap.prototype.size = 1;
    class HeightMapBlock extends HeightMap {
        constructor(length, height, deco) {
            super(length, height), this.deco = deco;
        }
        blockAt(_height, _oracle, top, offset) {
            return new BlockInfo(offset, this.length, top, this.height, this.deco || 0);
        }
        lineAt(_value, _type, oracle, top, offset) {
            return this.blockAt(0, oracle, top, offset);
        }
        forEachLine(from, to, oracle, top, offset, f) {
            from <= offset + this.length && offset <= to && f(this.blockAt(0, oracle, top, offset));
        }
        updateHeight(oracle, offset = 0, _force, measured) {
            return measured && measured.from <= offset && measured.more && this.setHeight(oracle, measured.heights[measured.index++]), 
            this.outdated = !1, this;
        }
        toString() {
            return `block(${this.length})`;
        }
    }
    class HeightMapText extends HeightMapBlock {
        constructor(length, height) {
            super(length, height, null), this.collapsed = 0, this.widgetHeight = 0, 
            this.breaks = 0;
        }
        blockAt(_height, _oracle, top, offset) {
            return new BlockInfo(offset, this.length, top, this.height, this.breaks);
        }
        replace(_from, _to, nodes) {
            let node = nodes[0];
            return 1 == nodes.length && (node instanceof HeightMapText || node instanceof HeightMapGap && 4 & node.flags) && Math.abs(this.length - node.length) < 10 ? (node instanceof HeightMapGap ? node = new HeightMapText(node.length, this.height) : node.height = this.height, 
            this.outdated || (node.outdated = !1), node) : HeightMap.of(nodes);
        }
        updateHeight(oracle, offset = 0, force = !1, measured) {
            return measured && measured.from <= offset && measured.more ? this.setHeight(oracle, measured.heights[measured.index++]) : (force || this.outdated) && this.setHeight(oracle, Math.max(this.widgetHeight, oracle.heightForLine(this.length - this.collapsed)) + this.breaks * oracle.lineHeight), 
            this.outdated = !1, this;
        }
        toString() {
            return `line(${this.length}${this.collapsed ? -this.collapsed : ""}${this.widgetHeight ? ":" + this.widgetHeight : ""})`;
        }
    }
    class HeightMapGap extends HeightMap {
        constructor(length) {
            super(length, 0);
        }
        heightMetrics(oracle, offset) {
            var firstLine = oracle.doc.lineAt(offset).number, offset = oracle.doc.lineAt(offset + this.length).number, lines = offset - firstLine + 1;
            let perLine, perChar = 0;
            return oracle.lineWrapping ? (oracle = Math.min(this.height, oracle.lineHeight * lines), 
            perLine = oracle / lines, this.length > 1 + lines && (perChar = (this.height - oracle) / (this.length - lines - 1))) : perLine = this.height / lines, 
            {
                firstLine: firstLine,
                lastLine: offset,
                perLine: perLine,
                perChar: perChar
            };
        }
        blockAt(height, oracle, top, offset) {
            var {
                firstLine,
                lastLine,
                perLine,
                perChar
            } = this.heightMetrics(oracle, offset);
            if (oracle.lineWrapping) return offset = offset + (height < oracle.lineHeight ? 0 : Math.round(Math.max(0, Math.min(1, (height - top) / this.height)) * this.length)), 
            perChar = perLine + (offset = oracle.doc.lineAt(offset)).length * perChar, 
            lineTop = Math.max(top, height - perChar / 2), new BlockInfo(offset.from, offset.length, lineTop, perChar, 0);
            {
                let line = Math.max(0, Math.min(lastLine - firstLine, Math.floor((height - top) / perLine)));
                var {
                    from: offset,
                    length: lineTop
                } = oracle.doc.line(firstLine + line);
                return new BlockInfo(offset, lineTop, top + perLine * line, perLine, 0);
            }
        }
        lineAt(value, type, oracle, top, offset) {
            var perChar, to;
            return type == QueryType$1.ByHeight ? this.blockAt(value, oracle, top, offset) : type == QueryType$1.ByPosNoHeight ? ({
                from: type,
                to
            } = oracle.doc.lineAt(value), new BlockInfo(type, to - type, 0, 0, 0)) : ({
                firstLine: to,
                perLine: type,
                perChar
            } = this.heightMetrics(oracle, offset), value = type + (oracle = oracle.doc.lineAt(value)).length * perChar, 
            to = top + type * (type = oracle.number - to) + perChar * (oracle.from - offset - type), 
            new BlockInfo(oracle.from, oracle.length, Math.max(top, Math.min(to, top + this.height - value)), value, 0));
        }
        forEachLine(from, to, oracle, top, offset, f) {
            from = Math.max(from, offset), to = Math.min(to, offset + this.length);
            var {
                firstLine,
                perLine,
                perChar
            } = this.heightMetrics(oracle, offset);
            for (let pos = from, lineTop = top; pos <= to; ) {
                var line = oracle.doc.lineAt(pos), linesAbove = (pos == from && (linesAbove = line.number - firstLine, 
                lineTop += perLine * linesAbove + perChar * (from - offset - linesAbove)), 
                perLine + perChar * line.length);
                f(new BlockInfo(line.from, line.length, lineTop, linesAbove, 0)), 
                lineTop += linesAbove, pos = line.to + 1;
            }
        }
        replace(from, to, nodes) {
            var last, to = this.length - to;
            return 0 < to && ((last = nodes[nodes.length - 1]) instanceof HeightMapGap ? nodes[nodes.length - 1] = new HeightMapGap(last.length + to) : nodes.push(null, new HeightMapGap(to - 1))), 
            0 < from && ((last = nodes[0]) instanceof HeightMapGap ? nodes[0] = new HeightMapGap(from + last.length) : nodes.unshift(new HeightMapGap(from - 1), null)), 
            HeightMap.of(nodes);
        }
        decomposeLeft(to, result) {
            result.push(new HeightMapGap(to - 1), null);
        }
        decomposeRight(from, result) {
            result.push(null, new HeightMapGap(this.length - from - 1));
        }
        updateHeight(oracle, offset = 0, force = !1, measured) {
            var end = offset + this.length;
            if (measured && measured.from <= offset + this.length && measured.more) {
                let nodes = [], pos = Math.max(offset, measured.from), singleHeight = -1;
                for (measured.from > offset && nodes.push(new HeightMapGap(measured.from - offset - 1).updateHeight(oracle, offset)); pos <= end && measured.more; ) {
                    var len = oracle.doc.lineAt(pos).length, height = (nodes.length && nodes.push(null), 
                    measured.heights[measured.index++]), height = (-1 == singleHeight ? singleHeight = height : .001 <= Math.abs(height - singleHeight) && (singleHeight = -2), 
                    new HeightMapText(len, height));
                    height.outdated = !1, nodes.push(height), pos += len + 1;
                }
                pos <= end && nodes.push(null, new HeightMapGap(end - pos).updateHeight(oracle, pos));
                var result = HeightMap.of(nodes);
                return (singleHeight < 0 || .001 <= Math.abs(result.height - this.height) || .001 <= Math.abs(singleHeight - this.heightMetrics(oracle, offset).perLine)) && (oracle.heightChanged = !0), 
                result;
            }
            return (force || this.outdated) && (this.setHeight(oracle, oracle.heightForGap(offset, offset + this.length)), 
            this.outdated = !1), this;
        }
        toString() {
            return `gap(${this.length})`;
        }
    }
    class HeightMapBranch extends HeightMap {
        constructor(left, brk, right) {
            super(left.length + brk + right.length, left.height + right.height, brk | (left.outdated || right.outdated ? 2 : 0)), 
            this.left = left, this.right = right, this.size = left.size + right.size;
        }
        get break() {
            return 1 & this.flags;
        }
        blockAt(height, oracle, top, offset) {
            var mid = top + this.left.height;
            return height < mid ? this.left.blockAt(height, oracle, top, offset) : this.right.blockAt(height, oracle, mid, offset + this.left.length + this.break);
        }
        lineAt(value, type, oracle, top, offset) {
            var rightTop = top + this.left.height, rightOffset = offset + this.left.length + this.break, left = type == QueryType$1.ByHeight ? value < rightTop : value < rightOffset, value = left ? this.left.lineAt(value, type, oracle, top, offset) : this.right.lineAt(value, type, oracle, rightTop, rightOffset);
            return this.break || (left ? value.to < rightOffset : value.from > rightOffset) ? value : (type = type == QueryType$1.ByPosNoHeight ? QueryType$1.ByPosNoHeight : QueryType$1.ByPos, 
            left ? value.join(this.right.lineAt(rightOffset, type, oracle, rightTop, rightOffset)) : this.left.lineAt(rightOffset, type, oracle, top, offset).join(value));
        }
        forEachLine(from, to, oracle, top, offset, f) {
            var mid, rightTop = top + this.left.height, rightOffset = offset + this.left.length + this.break;
            this.break ? (from < rightOffset && this.left.forEachLine(from, to, oracle, top, offset, f), 
            rightOffset <= to && this.right.forEachLine(from, to, oracle, rightTop, rightOffset, f)) : (from < (mid = this.lineAt(rightOffset, QueryType$1.ByPos, oracle, top, offset)).from && this.left.forEachLine(from, mid.from - 1, oracle, top, offset, f), 
            mid.to >= from && mid.from <= to && f(mid), to > mid.to && this.right.forEachLine(mid.to + 1, to, oracle, rightTop, rightOffset, f));
        }
        replace(from, to, nodes) {
            var rightStart = this.left.length + this.break;
            if (to < rightStart) return this.balanced(this.left.replace(from, to, nodes), this.right);
            if (from > this.left.length) return this.balanced(this.left, this.right.replace(from - rightStart, to - rightStart, nodes));
            var node, result = [], rightStart = (0 < from && this.decomposeLeft(from, result), 
            result.length);
            for (node of nodes) result.push(node);
            return 0 < from && mergeGaps(result, rightStart - 1), to < this.length && (nodes = result.length, 
            this.decomposeRight(to, result), mergeGaps(result, nodes)), HeightMap.of(result);
        }
        decomposeLeft(to, result) {
            let left = this.left.length;
            if (to <= left) return this.left.decomposeLeft(to, result);
            result.push(this.left), this.break && to >= ++left && result.push(null), 
            to > left && this.right.decomposeLeft(to - left, result);
        }
        decomposeRight(from, result) {
            var left = this.left.length, right = left + this.break;
            if (right <= from) return this.right.decomposeRight(from - right, result);
            from < left && this.left.decomposeRight(from, result), this.break && from < right && result.push(null), 
            result.push(this.right);
        }
        balanced(left, right) {
            return left.size > 2 * right.size || right.size > 2 * left.size ? HeightMap.of(this.break ? [ left, null, right ] : [ left, right ]) : (this.left = left, 
            this.right = right, this.height = left.height + right.height, this.outdated = left.outdated || right.outdated, 
            this.size = left.size + right.size, this.length = left.length + this.break + right.length, 
            this);
        }
        updateHeight(oracle, offset = 0, force = !1, measured) {
            let {
                left,
                right
            } = this, rightStart = offset + left.length + this.break, rebalance = null;
            return measured && measured.from <= offset + left.length && measured.more ? rebalance = left = left.updateHeight(oracle, offset, force, measured) : left.updateHeight(oracle, offset, force), 
            measured && measured.from <= rightStart + right.length && measured.more ? rebalance = right = right.updateHeight(oracle, rightStart, force, measured) : right.updateHeight(oracle, rightStart, force), 
            rebalance ? this.balanced(left, right) : (this.height = this.left.height + this.right.height, 
            this.outdated = !1, this);
        }
        toString() {
            return this.left + (this.break ? " " : "-") + this.right;
        }
    }
    function mergeGaps(nodes, around) {
        let before, after;
        null == nodes[around] && (before = nodes[around - 1]) instanceof HeightMapGap && (after = nodes[around + 1]) instanceof HeightMapGap && nodes.splice(around - 1, 3, new HeightMapGap(before.length + 1 + after.length));
    }
    class NodeBuilder {
        constructor(pos, oracle) {
            this.pos = pos, this.oracle = oracle, this.nodes = [], this.lineStart = -1, 
            this.lineEnd = -1, this.covering = null, this.writtenTo = pos;
        }
        get isCovered() {
            return this.covering && this.nodes[this.nodes.length - 1] == this.covering;
        }
        span(_from, to) {
            var end, last;
            -1 < this.lineStart && (end = Math.min(to, this.lineEnd), (last = this.nodes[this.nodes.length - 1]) instanceof HeightMapText ? last.length += end - this.pos : (end > this.pos || !this.isCovered) && this.nodes.push(new HeightMapText(end - this.pos, -1)), 
            (this.writtenTo = end) < to) && (this.nodes.push(null), this.writtenTo++, 
            this.lineStart = -1), this.pos = to;
        }
        point(from, to, deco) {
            if (from < to || deco.heightRelevant) {
                let height = deco.widget ? deco.widget.estimatedHeight : 0;
                var breaks = deco.widget ? deco.widget.lineBreaks : 0, len = (height < 0 && (height = this.oracle.lineHeight), 
                to - from);
                deco.block ? this.addBlock(new HeightMapBlock(len, height, deco)) : (len || breaks || 5 <= height) && this.addLineDeco(height, breaks, len);
            } else from < to && this.span(from, to);
            -1 < this.lineEnd && this.lineEnd < this.pos && (this.lineEnd = this.oracle.doc.lineAt(this.pos).to);
        }
        enterLine() {
            var from, to;
            -1 < this.lineStart || ({
                from,
                to
            } = this.oracle.doc.lineAt(this.pos), this.lineStart = from, this.lineEnd = to, 
            this.writtenTo < from && ((this.writtenTo < from - 1 || null == this.nodes[this.nodes.length - 1]) && this.nodes.push(this.blankContent(this.writtenTo, from - 1)), 
            this.nodes.push(null)), this.pos > from && this.nodes.push(new HeightMapText(this.pos - from, -1)), 
            this.writtenTo = this.pos);
        }
        blankContent(from, to) {
            var gap = new HeightMapGap(to - from);
            return this.oracle.doc.lineAt(from).to == to && (gap.flags |= 4), gap;
        }
        ensureLine() {
            this.enterLine();
            var last = this.nodes.length ? this.nodes[this.nodes.length - 1] : null;
            return last instanceof HeightMapText || (last = new HeightMapText(0, -1), 
            this.nodes.push(last)), last;
        }
        addBlock(block) {
            this.enterLine();
            var deco = block.deco;
            deco && 0 < deco.startSide && !this.isCovered && this.ensureLine(), 
            this.nodes.push(block), this.writtenTo = this.pos = this.pos + block.length, 
            deco && 0 < deco.endSide && (this.covering = block);
        }
        addLineDeco(height, breaks, length) {
            var line = this.ensureLine();
            line.length += length, line.collapsed += length, line.widgetHeight = Math.max(line.widgetHeight, height), 
            line.breaks += breaks, this.writtenTo = this.pos = this.pos + length;
        }
        finish(from) {
            var node, last = 0 == this.nodes.length ? null : this.nodes[this.nodes.length - 1];
            !(-1 < this.lineStart) || last instanceof HeightMapText || this.isCovered ? (this.writtenTo < this.pos || null == last) && this.nodes.push(this.blankContent(this.writtenTo, this.pos)) : this.nodes.push(new HeightMapText(0, -1));
            let pos = from;
            for (node of this.nodes) node instanceof HeightMapText && node.updateHeight(this.oracle, pos), 
            pos += node ? node.length : 1;
            return this.nodes;
        }
        static build(oracle, decorations, from, to) {
            oracle = new NodeBuilder(from, oracle);
            return RangeSet.spans(decorations, from, to, oracle, 0), oracle.finish(from);
        }
    }
    class DecorationComparator {
        constructor() {
            this.changes = [];
        }
        compareRange() {}
        comparePoint(from, to, a, b) {
            (from < to || a && a.heightRelevant || b && b.heightRelevant) && addRange(from, to, this.changes, 5);
        }
    }
    class LineGap {
        constructor(from, to, size) {
            this.from = from, this.to = to, this.size = size;
        }
        static same(a, b) {
            if (a.length != b.length) return !1;
            for (let i = 0; i < a.length; i++) {
                var gA = a[i], gB = b[i];
                if (gA.from != gB.from || gA.to != gB.to || gA.size != gB.size) return !1;
            }
            return !0;
        }
        draw(viewState, wrapping) {
            return Decoration.replace({
                widget: new LineGapWidget(this.size * (wrapping ? viewState.scaleY : viewState.scaleX), wrapping)
            }).range(this.from, this.to);
        }
    }
    class LineGapWidget extends WidgetType {
        constructor(size, vertical) {
            super(), this.size = size, this.vertical = vertical;
        }
        eq(other) {
            return other.size == this.size && other.vertical == this.vertical;
        }
        toDOM() {
            var elt = document.createElement("div");
            return this.vertical ? elt.style.height = this.size + "px" : (elt.style.width = this.size + "px", 
            elt.style.height = "2px", elt.style.display = "inline-block"), elt;
        }
        get estimatedHeight() {
            return this.vertical ? this.size : -1;
        }
    }
    class ViewState {
        constructor(state) {
            this.state = state, this.pixelViewport = {
                left: 0,
                right: window.innerWidth,
                top: 0,
                bottom: 0
            }, this.inView = !0, this.paddingTop = 0, this.paddingBottom = 0, this.contentDOMWidth = 0, 
            this.contentDOMHeight = 0, this.editorHeight = 0, this.editorWidth = 0, 
            this.scrollTop = 0, this.scrolledToBottom = !1, this.scaleX = 1, this.scaleY = 1, 
            this.scrollAnchorPos = 0, this.scrollAnchorHeight = -1, this.scaler = IdScaler, 
            this.scrollTarget = null, this.printing = !1, this.mustMeasureContent = !0, 
            this.defaultTextDirection = Direction.LTR, this.visibleRanges = [], 
            this.mustEnforceCursorAssoc = !1;
            var guessWrapping = state.facet(contentAttributes).some(v => "function" != typeof v && "cm-lineWrapping" == v.class);
            this.heightOracle = new HeightOracle(guessWrapping), this.stateDeco = state.facet(decorations).filter(d => "function" != typeof d), 
            this.heightMap = HeightMap.empty().applyChanges(this.stateDeco, Text.empty, this.heightOracle.setDoc(state.doc), [ new ChangedRange(0, 0, 0, state.doc.length) ]), 
            this.viewport = this.getViewport(0, null), this.updateViewportLines(), 
            this.updateForViewport(), this.lineGaps = this.ensureLineGaps([]), this.lineGapDeco = Decoration.set(this.lineGaps.map(gap => gap.draw(this, !1))), 
            this.computeVisibleRanges();
        }
        updateForViewport() {
            var from, to, viewports = [ this.viewport ], main = this.state.selection["main"];
            for (let i = 0; i <= 1; i++) {
                let pos = i ? main.head : main.anchor;
                viewports.some(({
                    from,
                    to
                }) => pos >= from && pos <= to) || ({
                    from,
                    to
                } = this.lineBlockAt(pos), viewports.push(new Viewport(from, to)));
            }
            this.viewports = viewports.sort((a, b) => a.from - b.from), this.scaler = this.heightMap.height <= 7e6 ? IdScaler : new BigScaler(this.heightOracle, this.heightMap, this.viewports);
        }
        updateViewportLines() {
            this.viewportLines = [], this.heightMap.forEachLine(this.viewport.from, this.viewport.to, this.heightOracle.setDoc(this.state.doc), 0, 0, block => {
                this.viewportLines.push(1 == this.scaler.scale ? block : scaleBlock(block, this.scaler));
            });
        }
        update(update, scrollTarget = null) {
            this.state = update.state;
            var prevDeco = this.stateDeco, contentChanges = (this.stateDeco = this.state.facet(decorations).filter(d => "function" != typeof d), 
            update.changedRanges), contentChanges = ChangedRange.extendWithRanges(contentChanges, (contentChanges = prevDeco, 
            prevDeco = this.stateDeco, diff = update ? update.changes : ChangeSet.empty(this.state.doc.length), 
            comp = new DecorationComparator(), RangeSet.compare(contentChanges, prevDeco, diff, comp, 0), 
            comp.changes)), prevDeco = this.heightMap.height, diff = this.scrolledToBottom ? null : this.scrollAnchorAt(this.scrollTop);
            this.heightMap = this.heightMap.applyChanges(this.stateDeco, update.startState.doc, this.heightOracle.setDoc(this.state.doc), contentChanges), 
            this.heightMap.height != prevDeco && (update.flags |= 2), diff ? (this.scrollAnchorPos = update.changes.mapPos(diff.from, -1), 
            this.scrollAnchorHeight = diff.top) : (this.scrollAnchorPos = -1, this.scrollAnchorHeight = this.heightMap.height);
            let viewport = contentChanges.length ? this.mapViewport(this.viewport, update.changes) : this.viewport;
            (scrollTarget && (scrollTarget.range.head < viewport.from || scrollTarget.range.head > viewport.to) || !this.viewportIsAppropriate(viewport)) && (viewport = this.getViewport(0, scrollTarget));
            var comp = !update.changes.empty || 2 & update.flags || viewport.from != this.viewport.from || viewport.to != this.viewport.to;
            this.viewport = viewport, this.updateForViewport(), comp && this.updateViewportLines(), 
            (this.lineGaps.length || 4e3 < this.viewport.to - this.viewport.from) && this.updateLineGaps(this.ensureLineGaps(this.mapLineGaps(this.lineGaps, update.changes))), 
            update.flags |= this.computeVisibleRanges(), scrollTarget && (this.scrollTarget = scrollTarget), 
            !this.mustEnforceCursorAssoc && update.selectionSet && update.view.lineWrapping && update.state.selection.main.empty && update.state.selection.main.assoc && !update.state.facet(nativeSelectionHidden) && (this.mustEnforceCursorAssoc = !0);
        }
        measure(view) {
            var dom = view.contentDOM, style = window.getComputedStyle(dom), oracle = this.heightOracle, whiteSpace = style.whiteSpace;
            this.defaultTextDirection = "rtl" == style.direction ? Direction.RTL : Direction.LTR;
            let refresh = this.heightOracle.mustRefreshForWrapping(whiteSpace);
            var domRect = dom.getBoundingClientRect();
            let measureContent = refresh || this.mustMeasureContent || this.contentDOMHeight != domRect.height, result = (this.contentDOMHeight = domRect.height, 
            this.mustMeasureContent = !1, 0), bias = 0;
            domRect.width && domRect.height && ({
                scaleX,
                scaleY
            } = getScale(dom, domRect), .005 < scaleX && .005 < Math.abs(this.scaleX - scaleX) || .005 < scaleY && .005 < Math.abs(this.scaleY - scaleY)) && (this.scaleX = scaleX, 
            this.scaleY = scaleY, result |= 8, refresh = measureContent = !0);
            var scaleX = (parseInt(style.paddingTop) || 0) * this.scaleY, scaleY = (parseInt(style.paddingBottom) || 0) * this.scaleY, style = (this.paddingTop == scaleX && this.paddingBottom == scaleY || (this.paddingTop = scaleX, 
            this.paddingBottom = scaleY, result |= 10), this.editorWidth != view.scrollDOM.clientWidth && (oracle.lineWrapping && (measureContent = !0), 
            this.editorWidth = view.scrollDOM.clientWidth, result |= 8), view.scrollDOM.scrollTop * this.scaleY), scaleX = (this.scrollTop != style && (this.scrollAnchorHeight = -1, 
            this.scrollTop = style), this.scrolledToBottom = isScrolledToBottom(view.scrollDOM), 
            (this.printing ? function(dom, paddingTop) {
                return {
                    left: 0,
                    right: (dom = dom.getBoundingClientRect()).right - dom.left,
                    top: paddingTop,
                    bottom: dom.bottom - (dom.top + paddingTop)
                };
            } : function(dom, paddingTop) {
                var rect = dom.getBoundingClientRect(), doc = dom.ownerDocument, win = doc.defaultView || window;
                let left = Math.max(0, rect.left), right = Math.min(win.innerWidth, rect.right), top = Math.max(0, rect.top), bottom = Math.min(win.innerHeight, rect.bottom);
                for (let parent = dom.parentNode; parent && parent != doc.body; ) if (1 == parent.nodeType) {
                    var parentRect, elt = parent, style = window.getComputedStyle(elt);
                    (elt.scrollHeight > elt.clientHeight || elt.scrollWidth > elt.clientWidth) && "visible" != style.overflow && (parentRect = elt.getBoundingClientRect(), 
                    left = Math.max(left, parentRect.left), right = Math.min(right, parentRect.right), 
                    top = Math.max(top, parentRect.top), bottom = parent == dom.parentNode ? parentRect.bottom : Math.min(bottom, parentRect.bottom)), 
                    parent = "absolute" == style.position || "fixed" == style.position ? elt.offsetParent : elt.parentNode;
                } else {
                    if (11 != parent.nodeType) break;
                    parent = parent.host;
                }
                return {
                    left: left - rect.left,
                    right: Math.max(left, right) - rect.left,
                    top: top - (rect.top + paddingTop),
                    bottom: Math.max(top, bottom) - (rect.top + paddingTop)
                };
            })(dom, this.paddingTop)), scaleY = scaleX.top - this.pixelViewport.top, style = scaleX.bottom - this.pixelViewport.bottom, dom = (this.pixelViewport = scaleX, 
            this.pixelViewport.bottom > this.pixelViewport.top && this.pixelViewport.right > this.pixelViewport.left);
            if (dom != this.inView && (this.inView = dom) && (measureContent = !0), 
            !this.inView && !this.scrollTarget) return 0;
            scaleX = domRect.width;
            if (this.contentDOMWidth == scaleX && this.editorHeight == view.scrollDOM.clientHeight || (this.contentDOMWidth = domRect.width, 
            this.editorHeight = view.scrollDOM.clientHeight, result |= 8), measureContent) {
                var textHeight, vp, lineHeights = view.docView.measureVisibleLineHeights(this.viewport);
                ((refresh = oracle.mustRefreshForHeights(lineHeights) ? !0 : refresh) || oracle.lineWrapping && Math.abs(scaleX - this.contentDOMWidth) > oracle.charWidth) && ({
                    lineHeight: dom,
                    charWidth: domRect,
                    textHeight
                } = view.docView.measureTextSize(), refresh = 0 < dom && oracle.refresh(whiteSpace, dom, domRect, textHeight, scaleX / domRect, lineHeights)) && (view.docView.minWidth = 0, 
                result |= 8), 0 < scaleY && 0 < style ? bias = Math.max(scaleY, style) : scaleY < 0 && style < 0 && (bias = Math.min(scaleY, style)), 
                oracle.heightChanged = !1;
                for (vp of this.viewports) {
                    var heights = vp.from == this.viewport.from ? lineHeights : view.docView.measureVisibleLineHeights(vp);
                    this.heightMap = (refresh ? HeightMap.empty().applyChanges(this.stateDeco, Text.empty, this.heightOracle, [ new ChangedRange(0, 0, 0, view.state.doc.length) ]) : this.heightMap).updateHeight(oracle, 0, refresh, new MeasuredHeights(vp.from, heights));
                }
                oracle.heightChanged && (result |= 2);
            }
            whiteSpace = !this.viewportIsAppropriate(this.viewport, bias) || this.scrollTarget && (this.scrollTarget.range.head < this.viewport.from || this.scrollTarget.range.head > this.viewport.to);
            return whiteSpace && (this.viewport = this.getViewport(bias, this.scrollTarget)), 
            this.updateForViewport(), (2 & result || whiteSpace) && this.updateViewportLines(), 
            (this.lineGaps.length || 4e3 < this.viewport.to - this.viewport.from) && this.updateLineGaps(this.ensureLineGaps(refresh ? [] : this.lineGaps, view)), 
            result |= this.computeVisibleRanges(), this.mustEnforceCursorAssoc && (this.mustEnforceCursorAssoc = !1, 
            view.docView.enforceCursorAssoc()), result;
        }
        get visibleTop() {
            return this.scaler.fromDOM(this.pixelViewport.top);
        }
        get visibleBottom() {
            return this.scaler.fromDOM(this.pixelViewport.bottom);
        }
        getViewport(bias, scrollTarget) {
            var bias = .5 - Math.max(-.5, Math.min(.5, bias / 1e3 / 2)), map = this.heightMap, oracle = this.heightOracle, {
                visibleTop,
                visibleBottom
            } = this;
            let viewport = new Viewport(map.lineAt(visibleTop - 1e3 * bias, QueryType$1.ByHeight, oracle, 0, 0).from, map.lineAt(visibleBottom + 1e3 * (1 - bias), QueryType$1.ByHeight, oracle, 0, 0).to);
            if (scrollTarget) {
                visibleTop = scrollTarget.range["head"];
                if (visibleTop < viewport.from || visibleTop > viewport.to) {
                    visibleBottom = Math.min(this.editorHeight, this.pixelViewport.bottom - this.pixelViewport.top);
                    let block = map.lineAt(visibleTop, QueryType$1.ByPos, oracle, 0, 0), topPos;
                    topPos = "center" == scrollTarget.y ? (block.top + block.bottom) / 2 - visibleBottom / 2 : "start" == scrollTarget.y || "nearest" == scrollTarget.y && visibleTop < viewport.from ? block.top : block.bottom - visibleBottom, 
                    viewport = new Viewport(map.lineAt(topPos - 500, QueryType$1.ByHeight, oracle, 0, 0).from, map.lineAt(topPos + visibleBottom + 500, QueryType$1.ByHeight, oracle, 0, 0).to);
                }
            }
            return viewport;
        }
        mapViewport(viewport, changes) {
            var from = changes.mapPos(viewport.from, -1), changes = changes.mapPos(viewport.to, 1);
            return new Viewport(this.heightMap.lineAt(from, QueryType$1.ByPos, this.heightOracle, 0, 0).from, this.heightMap.lineAt(changes, QueryType$1.ByPos, this.heightOracle, 0, 0).to);
        }
        viewportIsAppropriate({
            from,
            to
        }, bias = 0) {
            var top, bottom, visibleTop, visibleBottom;
            return !this.inView || (top = this.heightMap.lineAt(from, QueryType$1.ByPos, this.heightOracle, 0, 0)["top"], 
            bottom = this.heightMap.lineAt(to, QueryType$1.ByPos, this.heightOracle, 0, 0)["bottom"], 
            {
                visibleTop,
                visibleBottom
            } = this, (0 == from || top <= visibleTop - Math.max(10, Math.min(-bias, 250))) && (to == this.state.doc.length || bottom >= visibleBottom + Math.max(10, Math.min(bias, 250))) && visibleTop - 2e3 < top && bottom < visibleBottom + 2e3);
        }
        mapLineGaps(gaps, changes) {
            if (!gaps.length || changes.empty) return gaps;
            var gap, mapped = [];
            for (gap of gaps) changes.touchesRange(gap.from, gap.to) || mapped.push(new LineGap(changes.mapPos(gap.from), changes.mapPos(gap.to), gap.size));
            return mapped;
        }
        ensureLineGaps(current, mayMeasure) {
            let wrapping = this.heightOracle.lineWrapping, margin = wrapping ? 1e4 : 2e3, halfMargin = margin >> 1, doubleMargin = margin << 1;
            if (this.defaultTextDirection != Direction.LTR && !wrapping) return [];
            let gaps = [], addGap = (from, to, line, structure) => {
                if (!(to - from < halfMargin)) {
                    let sel = this.state.selection.main, avoid = [ sel.from ];
                    sel.empty || avoid.push(sel.to);
                    for (var pos of avoid) if (pos > from && pos < to) return addGap(from, pos - 10, line, structure), 
                    void addGap(pos + 10, to, line, structure);
                    let gap = function(array, f) {
                        for (var val of array) if (f(val)) return val;
                        return;
                    }(current, gap => gap.from >= line.from && gap.to <= line.to && Math.abs(gap.from - from) < halfMargin && Math.abs(gap.to - to) < halfMargin && !avoid.some(pos => gap.from < pos && gap.to > pos));
                    var lineStart;
                    gap || (to < line.to && mayMeasure && wrapping && mayMeasure.visibleRanges.some(r => r.from <= to && r.to >= to) && (lineStart = mayMeasure.moveToLineBoundary(EditorSelection.cursor(to), !1, !0).head, 
                    from < lineStart) && (to = lineStart), gap = new LineGap(from, to, this.gapSize(line, from, to, structure))), 
                    gaps.push(gap);
                }
            };
            for (var line of this.viewportLines) if (!(line.length < doubleMargin)) {
                var structure = function(from, to, stateDeco) {
                    let ranges = [], pos = from, total = 0;
                    RangeSet.spans(stateDeco, from, to, {
                        span() {},
                        point(from, to) {
                            from > pos && (ranges.push({
                                from: pos,
                                to: from
                            }), total += from - pos), pos = to;
                        }
                    }, 20), pos < to && (ranges.push({
                        from: pos,
                        to: to
                    }), total += to - pos);
                    return {
                        total: total,
                        ranges: ranges
                    };
                }(line.from, line.to, this.stateDeco);
                if (!(structure.total < doubleMargin)) {
                    var target = this.scrollTarget ? this.scrollTarget.range.head : null;
                    let viewFrom, viewTo;
                    if (wrapping) {
                        var targetFrac, spaceFrac, marginHeight = margin / this.heightOracle.lineLength * this.heightOracle.lineHeight;
                        let top, bot;
                        bot = null != target ? (targetFrac = findFraction(structure, target), 
                        spaceFrac = ((this.visibleBottom - this.visibleTop) / 2 + marginHeight) / line.height, 
                        top = targetFrac - spaceFrac, targetFrac + spaceFrac) : (top = (this.visibleTop - line.top - marginHeight) / line.height, 
                        (this.visibleBottom - line.top + marginHeight) / line.height), 
                        viewFrom = findPosition(structure, top), viewTo = findPosition(structure, bot);
                    } else {
                        var marginHeight = structure.total * this.heightOracle.charWidth, marginWidth = margin * this.heightOracle.charWidth;
                        let left, right;
                        if (null != target) {
                            let targetFrac = findFraction(structure, target), spaceFrac = ((this.pixelViewport.right - this.pixelViewport.left) / 2 + marginWidth) / marginHeight;
                            left = targetFrac - spaceFrac, right = targetFrac + spaceFrac;
                        } else left = (this.pixelViewport.left - marginWidth) / marginHeight, 
                        right = (this.pixelViewport.right + marginWidth) / marginHeight;
                        viewFrom = findPosition(structure, left), viewTo = findPosition(structure, right);
                    }
                    viewFrom > line.from && addGap(line.from, viewFrom, line, structure), 
                    viewTo < line.to && addGap(viewTo, line.to, line, structure);
                }
            }
            return gaps;
        }
        gapSize(line, from, to, structure) {
            to = findFraction(structure, to) - findFraction(structure, from);
            return this.heightOracle.lineWrapping ? line.height * to : structure.total * this.heightOracle.charWidth * to;
        }
        updateLineGaps(gaps) {
            LineGap.same(gaps, this.lineGaps) || (this.lineGaps = gaps, this.lineGapDeco = Decoration.set(gaps.map(gap => gap.draw(this, this.heightOracle.lineWrapping))));
        }
        computeVisibleRanges() {
            let deco = this.stateDeco, ranges = (this.lineGaps.length && (deco = deco.concat(this.lineGapDeco)), 
            []);
            RangeSet.spans(deco, this.viewport.from, this.viewport.to, {
                span(from, to) {
                    ranges.push({
                        from: from,
                        to: to
                    });
                },
                point() {}
            }, 20);
            var changed = ranges.length != this.visibleRanges.length || this.visibleRanges.some((r, i) => r.from != ranges[i].from || r.to != ranges[i].to);
            return this.visibleRanges = ranges, changed ? 4 : 0;
        }
        lineBlockAt(pos) {
            return pos >= this.viewport.from && pos <= this.viewport.to && this.viewportLines.find(b => b.from <= pos && b.to >= pos) || scaleBlock(this.heightMap.lineAt(pos, QueryType$1.ByPos, this.heightOracle, 0, 0), this.scaler);
        }
        lineBlockAtHeight(height) {
            return scaleBlock(this.heightMap.lineAt(this.scaler.fromDOM(height), QueryType$1.ByHeight, this.heightOracle, 0, 0), this.scaler);
        }
        scrollAnchorAt(scrollTop) {
            var block = this.lineBlockAtHeight(scrollTop + 8);
            return block.from >= this.viewport.from || 200 < this.viewportLines[0].top - scrollTop ? block : this.viewportLines[0];
        }
        elementAtHeight(height) {
            return scaleBlock(this.heightMap.blockAt(this.scaler.fromDOM(height), this.heightOracle, 0, 0), this.scaler);
        }
        get docHeight() {
            return this.scaler.toDOM(this.heightMap.height);
        }
        get contentHeight() {
            return this.docHeight + this.paddingTop + this.paddingBottom;
        }
    }
    class Viewport {
        constructor(from, to) {
            this.from = from, this.to = to;
        }
    }
    function findPosition({
        total,
        ranges
    }, ratio) {
        if (ratio <= 0) return ranges[0].from;
        if (1 <= ratio) return ranges[ranges.length - 1].to;
        let dist = Math.floor(total * ratio);
        for (let i = 0; ;i++) {
            var {
                from,
                to
            } = ranges[i], to = to - from;
            if (dist <= to) return from + dist;
            dist -= to;
        }
    }
    function findFraction(structure, pos) {
        let counted = 0;
        for (var {
            from,
            to
        } of structure.ranges) {
            if (pos <= to) {
                counted += pos - from;
                break;
            }
            counted += to - from;
        }
        return counted / structure.total;
    }
    const IdScaler = {
        toDOM(n) {
            return n;
        },
        fromDOM(n) {
            return n;
        },
        scale: 1
    };
    class BigScaler {
        constructor(oracle, heightMap, viewports) {
            let vpHeight = 0, base = 0, domBase = 0;
            this.viewports = viewports.map(({
                from,
                to
            }) => {
                var top = heightMap.lineAt(from, QueryType$1.ByPos, oracle, 0, 0).top, bottom = heightMap.lineAt(to, QueryType$1.ByPos, oracle, 0, 0).bottom;
                return vpHeight += bottom - top, {
                    from: from,
                    to: to,
                    top: top,
                    bottom: bottom,
                    domTop: 0,
                    domBottom: 0
                };
            }), this.scale = (7e6 - vpHeight) / (heightMap.height - vpHeight);
            for (var obj of this.viewports) obj.domTop = domBase + (obj.top - base) * this.scale, 
            domBase = obj.domBottom = obj.domTop + (obj.bottom - obj.top), base = obj.bottom;
        }
        toDOM(n) {
            for (let i = 0, base = 0, domBase = 0; ;i++) {
                var vp = i < this.viewports.length ? this.viewports[i] : null;
                if (!vp || n < vp.top) return domBase + (n - base) * this.scale;
                if (n <= vp.bottom) return vp.domTop + (n - vp.top);
                base = vp.bottom, domBase = vp.domBottom;
            }
        }
        fromDOM(n) {
            for (let i = 0, base = 0, domBase = 0; ;i++) {
                var vp = i < this.viewports.length ? this.viewports[i] : null;
                if (!vp || n < vp.domTop) return base + (n - domBase) / this.scale;
                if (n <= vp.domBottom) return vp.top + (n - vp.domTop);
                base = vp.bottom, domBase = vp.domBottom;
            }
        }
    }
    function scaleBlock(block, scaler) {
        var bTop, bBottom;
        return 1 == scaler.scale ? block : (bTop = scaler.toDOM(block.top), bBottom = scaler.toDOM(block.bottom), 
        new BlockInfo(block.from, block.length, bTop, bBottom - bTop, Array.isArray(block._content) ? block._content.map(b => scaleBlock(b, scaler)) : block._content));
    }
    const theme = Facet.define({
        combine: strs => strs.join(" ")
    }), darkTheme = Facet.define({
        combine: values => -1 < values.indexOf(!0)
    }), baseThemeID = StyleModule.newName(), baseLightID = StyleModule.newName(), baseDarkID = StyleModule.newName(), lightDarkIDs = {
        "&light": "." + baseLightID,
        "&dark": "." + baseDarkID
    };
    function buildTheme(main, spec, scopes) {
        return new StyleModule(spec, {
            finish(sel) {
                return /&/.test(sel) ? sel.replace(/&\w*/, m => {
                    if ("&" == m) return main;
                    if (scopes && scopes[m]) return scopes[m];
                    throw new RangeError("Unsupported selector: " + m);
                }) : main + " " + sel;
            }
        });
    }
    const baseTheme$1$2 = buildTheme("." + baseThemeID, {
        "&": {
            position: "relative !important",
            boxSizing: "border-box",
            "&.cm-focused": {
                outline: "1px dotted #212121"
            },
            display: "flex !important",
            flexDirection: "column"
        },
        ".cm-scroller": {
            display: "flex !important",
            alignItems: "flex-start !important",
            fontFamily: "monospace",
            lineHeight: 1.4,
            height: "100%",
            overflowX: "auto",
            position: "relative",
            zIndex: 0
        },
        ".cm-content": {
            margin: 0,
            flexGrow: 2,
            flexShrink: 0,
            display: "block",
            whiteSpace: "pre",
            wordWrap: "normal",
            boxSizing: "border-box",
            minHeight: "100%",
            padding: "4px 0",
            outline: "none",
            "&[contenteditable=true]": {
                WebkitUserModify: "read-write-plaintext-only"
            }
        },
        ".cm-lineWrapping": {
            whiteSpace_fallback: "pre-wrap",
            whiteSpace: "break-spaces",
            wordBreak: "break-word",
            overflowWrap: "anywhere",
            flexShrink: 1
        },
        "&light .cm-content": {
            caretColor: "black"
        },
        "&dark .cm-content": {
            caretColor: "white"
        },
        ".cm-line": {
            display: "block",
            padding: "0 2px 0 6px"
        },
        ".cm-layer": {
            position: "absolute",
            left: 0,
            top: 0,
            contain: "size style",
            "& > *": {
                position: "absolute"
            }
        },
        "&light .cm-selectionBackground": {
            background: "#d9d9d9"
        },
        "&dark .cm-selectionBackground": {
            background: "#222"
        },
        "&light.cm-focused > .cm-scroller > .cm-selectionLayer .cm-selectionBackground": {
            background: "#d7d4f0"
        },
        "&dark.cm-focused > .cm-scroller > .cm-selectionLayer .cm-selectionBackground": {
            background: "#233"
        },
        ".cm-cursorLayer": {
            pointerEvents: "none"
        },
        "&.cm-focused > .cm-scroller > .cm-cursorLayer": {
            animation: "steps(1) cm-blink 1.2s infinite"
        },
        "@keyframes cm-blink": {
            "0%": {},
            "50%": {
                opacity: 0
            },
            "100%": {}
        },
        "@keyframes cm-blink2": {
            "0%": {},
            "50%": {
                opacity: 0
            },
            "100%": {}
        },
        ".cm-cursor, .cm-dropCursor": {
            borderLeft: "1.2px solid black",
            marginLeft: "-0.6px",
            pointerEvents: "none"
        },
        ".cm-cursor": {
            display: "none"
        },
        "&dark .cm-cursor": {
            borderLeftColor: "#444"
        },
        ".cm-dropCursor": {
            position: "absolute"
        },
        "&.cm-focused > .cm-scroller > .cm-cursorLayer .cm-cursor": {
            display: "block"
        },
        ".cm-iso": {
            unicodeBidi: "isolate"
        },
        ".cm-announced": {
            position: "fixed",
            top: "-10000px"
        },
        "@media print": {
            ".cm-announced": {
                display: "none"
            }
        },
        "&light .cm-activeLine": {
            backgroundColor: "#cceeff44"
        },
        "&dark .cm-activeLine": {
            backgroundColor: "#99eeff33"
        },
        "&light .cm-specialChar": {
            color: "red"
        },
        "&dark .cm-specialChar": {
            color: "#f78"
        },
        ".cm-gutters": {
            flexShrink: 0,
            display: "flex",
            height: "100%",
            boxSizing: "border-box",
            insetInlineStart: 0,
            zIndex: 200
        },
        "&light .cm-gutters": {
            backgroundColor: "#f5f5f5",
            color: "#6c6c6c",
            borderRight: "1px solid #ddd"
        },
        "&dark .cm-gutters": {
            backgroundColor: "#333338",
            color: "#ccc"
        },
        ".cm-gutter": {
            display: "flex !important",
            flexDirection: "column",
            flexShrink: 0,
            boxSizing: "border-box",
            minHeight: "100%",
            overflow: "hidden"
        },
        ".cm-gutterElement": {
            boxSizing: "border-box"
        },
        ".cm-lineNumbers .cm-gutterElement": {
            padding: "0 3px 0 5px",
            minWidth: "20px",
            textAlign: "right",
            whiteSpace: "nowrap"
        },
        "&light .cm-activeLineGutter": {
            backgroundColor: "#e2f2ff"
        },
        "&dark .cm-activeLineGutter": {
            backgroundColor: "#222227"
        },
        ".cm-panels": {
            boxSizing: "border-box",
            position: "sticky",
            left: 0,
            right: 0
        },
        "&light .cm-panels": {
            backgroundColor: "#f5f5f5",
            color: "black"
        },
        "&light .cm-panels-top": {
            borderBottom: "1px solid #ddd"
        },
        "&light .cm-panels-bottom": {
            borderTop: "1px solid #ddd"
        },
        "&dark .cm-panels": {
            backgroundColor: "#333338",
            color: "white"
        },
        ".cm-tab": {
            display: "inline-block",
            overflow: "hidden",
            verticalAlign: "bottom"
        },
        ".cm-widgetBuffer": {
            verticalAlign: "text-top",
            height: "1em",
            width: 0,
            display: "inline"
        },
        ".cm-placeholder": {
            color: "#888",
            display: "inline-block",
            verticalAlign: "top"
        },
        ".cm-highlightSpace:before": {
            content: "attr(data-display)",
            position: "absolute",
            pointerEvents: "none",
            color: "#888"
        },
        ".cm-highlightTab": {
            backgroundImage: `url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" width="200" height="20"><path stroke="%23888" stroke-width="1" fill="none" d="M1 10H196L190 5M190 15L196 10M197 4L197 16"/></svg>')`,
            backgroundSize: "auto 100%",
            backgroundPosition: "right 90%",
            backgroundRepeat: "no-repeat"
        },
        ".cm-trailingSpace": {
            backgroundColor: "#ff332255"
        },
        ".cm-button": {
            verticalAlign: "middle",
            color: "inherit",
            fontSize: "70%",
            padding: ".2em 1em",
            borderRadius: "1px"
        },
        "&light .cm-button": {
            backgroundImage: "linear-gradient(#eff1f5, #d9d9df)",
            border: "1px solid #888",
            "&:active": {
                backgroundImage: "linear-gradient(#b4b4b4, #d0d3d6)"
            }
        },
        "&dark .cm-button": {
            backgroundImage: "linear-gradient(#393939, #111)",
            border: "1px solid #888",
            "&:active": {
                backgroundImage: "linear-gradient(#111, #333)"
            }
        },
        ".cm-textfield": {
            verticalAlign: "middle",
            color: "inherit",
            fontSize: "70%",
            border: "1px solid silver",
            padding: ".2em .5em"
        },
        "&light .cm-textfield": {
            backgroundColor: "white"
        },
        "&dark .cm-textfield": {
            border: "1px solid #555",
            backgroundColor: "inherit"
        }
    }, lightDarkIDs);
    class DOMReader {
        constructor(points, state) {
            this.points = points, this.text = "", this.lineSeparator = state.facet(EditorState.lineSeparator);
        }
        append(text) {
            this.text += text;
        }
        lineBreak() {
            this.text += "\uffff";
        }
        readRange(start, end) {
            if (start) {
                var parent = start.parentNode;
                for (let cur = start; ;) {
                    this.findPointBefore(parent, cur);
                    var oldLen = this.text.length, next = (this.readNode(cur), cur.nextSibling);
                    if (next == end) break;
                    var view = ContentView.get(cur), nextView = ContentView.get(next);
                    (view && nextView ? view.breakAfter : (view ? view.breakAfter : isBlockElement(cur)) || isBlockElement(next) && ("BR" != cur.nodeName || cur.cmIgnore) && this.text.length > oldLen) && this.lineBreak(), 
                    cur = next;
                }
                this.findPointBefore(parent, end);
            }
            return this;
        }
        readTextNode(node) {
            var point, text = node.nodeValue;
            for (point of this.points) point.node == node && (point.pos = this.text.length + Math.min(point.offset, text.length));
            for (let off = 0, re = this.lineSeparator ? null : /\r\n?|\n/g; ;) {
                let nextBreak = -1, breakSize = 1, m;
                if (this.lineSeparator ? (nextBreak = text.indexOf(this.lineSeparator, off), 
                breakSize = this.lineSeparator.length) : (m = re.exec(text)) && (nextBreak = m.index, 
                breakSize = m[0].length), this.append(text.slice(off, nextBreak < 0 ? text.length : nextBreak)), 
                nextBreak < 0) break;
                if (this.lineBreak(), 1 < breakSize) for (let point of this.points) point.node == node && point.pos > this.text.length && (point.pos -= breakSize - 1);
                off = nextBreak + breakSize;
            }
        }
        readNode(node) {
            if (!node.cmIgnore) {
                var view = ContentView.get(node), view = view && view.overrideDOMText;
                if (null != view) {
                    this.findPointInside(node, view.length);
                    for (var i = view.iter(); !i.next().done; ) i.lineBreak ? this.lineBreak() : this.append(i.value);
                } else 3 == node.nodeType ? this.readTextNode(node) : "BR" == node.nodeName ? node.nextSibling && this.lineBreak() : 1 == node.nodeType && this.readRange(node.firstChild, null);
            }
        }
        findPointBefore(node, next) {
            for (var point of this.points) point.node == node && node.childNodes[point.offset] == next && (point.pos = this.text.length);
        }
        findPointInside(node, length) {
            for (var point of this.points) (3 == node.nodeType ? point.node == node : node.contains(point.node)) && (point.pos = this.text.length + (function(parent, node, offset) {
                for (;;) {
                    if (!node || offset < maxOffset(node)) return;
                    if (node == parent) return 1;
                    offset = domIndex(node) + 1, node = node.parentNode;
                }
            }(node, point.node, point.offset) ? length : 0));
        }
    }
    class DOMPoint {
        constructor(node, offset) {
            this.node = node, this.offset = offset, this.pos = -1;
        }
    }
    class DOMChange {
        constructor(view, start, end, typeOver) {
            this.typeOver = typeOver, this.bounds = null, this.text = "";
            var {
                impreciseHead: typeOver,
                impreciseAnchor: iAnchor
            } = view.docView;
            if (view.state.readOnly && -1 < start) this.newSel = null; else if (-1 < start && (this.bounds = view.docView.domBoundsAround(start, end, 0))) {
                start = typeOver || iAnchor ? [] : function(view) {
                    var result = [];
                    var anchorOffset, focusNode, focusOffset;
                    return view.root.activeElement == view.contentDOM && ({
                        anchorNode: view,
                        anchorOffset,
                        focusNode,
                        focusOffset
                    } = view.observer.selectionRange, view) && (result.push(new DOMPoint(view, anchorOffset)), 
                    focusNode == view && focusOffset == anchorOffset || result.push(new DOMPoint(focusNode, focusOffset))), 
                    result;
                }(view), end = new DOMReader(start, view.state);
                end.readRange(this.bounds.startDOM, this.bounds.endDOM), this.text = end.text, 
                this.newSel = function(points, base) {
                    if (0 == points.length) return null;
                    var anchor = points[0].pos, points = 2 == points.length ? points[1].pos : anchor;
                    return -1 < anchor && -1 < points ? EditorSelection.single(anchor + base, points + base) : null;
                }(start, this.bounds.from);
            } else {
                end = view.observer.selectionRange;
                let head = typeOver && typeOver.node == end.focusNode && typeOver.offset == end.focusOffset || !contains(view.contentDOM, end.focusNode) ? view.state.selection.main.head : view.docView.posFromDOM(end.focusNode, end.focusOffset), anchor = iAnchor && iAnchor.node == end.anchorNode && iAnchor.offset == end.anchorOffset || !contains(view.contentDOM, end.anchorNode) ? view.state.selection.main.anchor : view.docView.posFromDOM(end.anchorNode, end.anchorOffset);
                var start = view.viewport;
                (browser.ios || browser.chrome) && view.state.selection.main.empty && head != anchor && (0 < start.from || start.to < view.state.doc.length) && (typeOver = Math.min(head, anchor), 
                iAnchor = Math.max(head, anchor), end = start.from - typeOver, start = start.to - iAnchor, 
                0 != end && 1 != end && 0 != typeOver || 0 != start && -1 != start && iAnchor != view.state.doc.length || (head = 0, 
                anchor = view.state.doc.length)), this.newSel = EditorSelection.single(anchor, head);
            }
        }
    }
    function applyDOMChange(view, domChange) {
        let change, newSel = domChange["newSel"], sel = view.state.selection.main;
        var lastKey = view.inputState.lastKeyTime > Date.now() - 100 ? view.inputState.lastKeyCode : -1;
        if (domChange.bounds) {
            var {
                from,
                to
            } = domChange.bounds;
            let preferredPos = sel.from, preferredSide = null;
            (8 === lastKey || browser.android && domChange.text.length < to - from) && (preferredPos = sel.to, 
            preferredSide = "end");
            to = function(a, b, preferredPos, preferredSide) {
                let minLen = Math.min(a.length, b.length), from = 0;
                for (;from < minLen && a.charCodeAt(from) == b.charCodeAt(from); ) from++;
                if (from == minLen && a.length == b.length) return null;
                let toA = a.length, toB = b.length;
                for (;0 < toA && 0 < toB && a.charCodeAt(toA - 1) == b.charCodeAt(toB - 1); ) toA--, 
                toB--;
                "end" == preferredSide && (preferredSide = Math.max(0, from - Math.min(toA, toB)), 
                preferredPos -= toA + preferredSide - from);
                {
                    var move;
                    toA < from && a.length < b.length ? (move = preferredPos <= from && preferredPos >= toA ? from - preferredPos : 0, 
                    from -= move, toB = from + (toB - toA), toA = from) : toB < from && (preferredSide = preferredPos <= from && preferredPos >= toB ? from - preferredPos : 0, 
                    from -= preferredSide, toA = from + (toA - toB), toB = from);
                }
                return {
                    from: from,
                    toA: toA,
                    toB: toB
                };
            }(view.state.doc.sliceString(from, to, "\uffff"), domChange.text, preferredPos - from, preferredSide);
            to && (browser.chrome && 13 == lastKey && to.toB == to.from + 2 && "\uffff\uffff" == domChange.text.slice(to.from, to.toB) && to.toB--, 
            change = {
                from: from + to.from,
                to: from + to.toA,
                insert: Text.of(domChange.text.slice(to.from, to.toB).split("\uffff"))
            });
        } else newSel && (!view.hasFocus && view.state.facet(editable) || newSel.main.eq(sel)) && (newSel = null);
        if (!change && !newSel) return !1;
        if (!change && domChange.typeOver && !sel.empty && newSel && newSel.main.empty ? change = {
            from: sel.from,
            to: sel.to,
            insert: view.state.doc.slice(sel.from, sel.to)
        } : change && change.from >= sel.from && change.to <= sel.to && (change.from != sel.from || change.to != sel.to) && sel.to - sel.from - (change.to - change.from) <= 4 ? change = {
            from: sel.from,
            to: sel.to,
            insert: view.state.doc.slice(sel.from, change.from).append(change.insert).append(view.state.doc.slice(change.to, sel.to))
        } : (browser.mac || browser.android) && change && change.from == change.to && change.from == sel.head - 1 && /^\. ?$/.test(change.insert.toString()) && "off" == view.contentDOM.getAttribute("autocorrect") ? (newSel && 2 == change.insert.length && (newSel = EditorSelection.single(newSel.main.anchor - 1, newSel.main.head - 1)), 
        change = {
            from: sel.from,
            to: sel.to,
            insert: Text.of([ " " ])
        }) : browser.chrome && change && change.from == change.to && change.from == sel.head && "\n " == change.insert.toString() && view.lineWrapping && (newSel = newSel && EditorSelection.single(newSel.main.anchor - 1, newSel.main.head - 1), 
        change = {
            from: sel.from,
            to: sel.to,
            insert: Text.of([ " " ])
        }), change) {
            if ((!browser.ios || !view.inputState.flushIOSKey(change)) && (!browser.android || !(change.to == sel.to && (change.from == sel.from || change.from == sel.from - 1 && " " == view.state.sliceDoc(change.from, sel.from)) && 1 == change.insert.length && 2 == change.insert.lines && dispatchKey(view.contentDOM, "Enter", 13) || (change.from == sel.from - 1 && change.to == sel.to && 0 == change.insert.length || 8 == lastKey && change.insert.length < change.to - change.from && change.to > sel.head) && dispatchKey(view.contentDOM, "Backspace", 8) || change.from == sel.from && change.to == sel.to + 1 && 0 == change.insert.length && dispatchKey(view.contentDOM, "Delete", 46)))) {
                let text = change.insert.toString();
                0 <= view.inputState.composing && view.inputState.composing++;
                let defaultTr, defaultInsert = () => defaultTr = defaultTr || function(view, change, newSel) {
                    let tr, startState = view.state, sel = startState.selection.main;
                    if (change.from >= sel.from && change.to <= sel.to && change.to - change.from >= (sel.to - sel.from) / 3 && (!newSel || newSel.main.empty && newSel.main.from == change.from + change.insert.length) && view.inputState.composing < 0) {
                        var before = sel.from < change.from ? startState.sliceDoc(sel.from, change.from) : "", after = sel.to > change.to ? startState.sliceDoc(change.to, sel.to) : "";
                        tr = startState.replaceSelection(view.state.toText(before + change.insert.sliceString(0, void 0, view.state.lineBreak) + after));
                    } else {
                        let changes = startState.changes(change), mainSel = newSel && newSel.main.to <= changes.newLength ? newSel.main : void 0;
                        if (1 < startState.selection.ranges.length && 0 <= view.inputState.composing && change.to <= sel.to && change.to >= sel.to - 10) {
                            let replaced = view.state.sliceDoc(change.from, change.to), compositionRange, composition = newSel && findCompositionNode(view, newSel.main.head);
                            compositionRange = composition ? (before = change.insert.length - (change.to - change.from), 
                            {
                                from: composition.from,
                                to: composition.to - before
                            }) : view.state.doc.lineAt(sel.head);
                            let offset = sel.to - change.to, size = sel.to - sel.from;
                            tr = startState.changeByRange(range => {
                                var from, to;
                                return range.from == sel.from && range.to == sel.to ? {
                                    changes: changes,
                                    range: mainSel || range.map(changes)
                                } : (from = (to = range.to - offset) - replaced.length, 
                                range.to - range.from != size || view.state.sliceDoc(from, to) != replaced || range.to >= compositionRange.from && range.from <= compositionRange.to ? {
                                    range: range
                                } : (from = startState.changes({
                                    from: from,
                                    to: to,
                                    insert: change.insert
                                }), to = range.to - sel.to, {
                                    changes: from,
                                    range: mainSel ? EditorSelection.range(Math.max(0, mainSel.anchor + to), Math.max(0, mainSel.head + to)) : range.map(from)
                                }));
                            });
                        } else tr = {
                            changes: changes,
                            selection: mainSel && startState.selection.replaceRange(mainSel)
                        };
                    }
                    let userEvent = "input.type";
                    (view.composing || view.inputState.compositionPendingChange && view.inputState.compositionEndedAt > Date.now() - 50) && (view.inputState.compositionPendingChange = !1, 
                    userEvent += ".compose", view.inputState.compositionFirstChange) && (userEvent += ".start", 
                    view.inputState.compositionFirstChange = !1);
                    return startState.update(tr, {
                        userEvent: userEvent,
                        scrollIntoView: !0
                    });
                }(view, change, newSel);
                view.state.facet(inputHandler$1).some(h => h(view, change.from, change.to, text, defaultInsert)) || view.dispatch(defaultInsert());
            }
            return !0;
        }
        if (!newSel || newSel.main.eq(sel)) return !1;
        {
            let scrollIntoView = !1, userEvent = "select";
            return view.inputState.lastSelectionTime > Date.now() - 50 && ("select" == view.inputState.lastSelectionOrigin && (scrollIntoView = !0), 
            userEvent = view.inputState.lastSelectionOrigin), view.dispatch({
                selection: newSel,
                scrollIntoView: scrollIntoView,
                userEvent: userEvent
            }), !0;
        }
    }
    const observeOptions = {
        childList: !0,
        characterData: !0,
        subtree: !0,
        attributes: !0,
        characterDataOldValue: !0
    }, useCharData = browser.ie && browser.ie_version <= 11;
    class DOMObserver {
        constructor(view) {
            this.view = view, this.active = !1, this.selectionRange = new DOMSelectionState(), 
            this.selectionChanged = !1, this.delayedFlush = -1, this.resizeTimeout = -1, 
            this.queue = [], this.delayedAndroidKey = null, this.flushingAndroidKey = -1, 
            this.lastChange = 0, this.scrollTargets = [], this.intersection = null, 
            this.resizeScroll = null, this.intersecting = !1, this.gapIntersection = null, 
            this.gaps = [], this.printQuery = null, this.parentCheck = -1, this.dom = view.contentDOM, 
            this.observer = new MutationObserver(mutations => {
                for (var mut of mutations) this.queue.push(mut);
                (browser.ie && browser.ie_version <= 11 || browser.ios && view.composing) && mutations.some(m => "childList" == m.type && m.removedNodes.length || "characterData" == m.type && m.oldValue.length > m.target.nodeValue.length) ? this.flushSoon() : this.flush();
            }), useCharData && (this.onCharData = event => {
                this.queue.push({
                    target: event.target,
                    type: "characterData",
                    oldValue: event.prevValue
                }), this.flushSoon();
            }), this.onSelectionChange = this.onSelectionChange.bind(this), this.onResize = this.onResize.bind(this), 
            this.onPrint = this.onPrint.bind(this), this.onScroll = this.onScroll.bind(this), 
            window.matchMedia && (this.printQuery = window.matchMedia("print")), 
            "function" == typeof ResizeObserver && (this.resizeScroll = new ResizeObserver(() => {
                var _a;
                (null == (_a = this.view.docView) ? void 0 : _a.lastUpdate) < Date.now() - 75 && this.onResize();
            }), this.resizeScroll.observe(view.scrollDOM)), this.addWindowListeners(this.win = view.win), 
            this.start(), "function" == typeof IntersectionObserver && (this.intersection = new IntersectionObserver(entries => {
                this.parentCheck < 0 && (this.parentCheck = setTimeout(this.listenForScroll.bind(this), 1e3)), 
                0 < entries.length && 0 < entries[entries.length - 1].intersectionRatio != this.intersecting && (this.intersecting = !this.intersecting, 
                this.intersecting != this.view.inView) && this.onScrollChanged(document.createEvent("Event"));
            }, {
                threshold: [ 0, .001 ]
            }), this.intersection.observe(this.dom), this.gapIntersection = new IntersectionObserver(entries => {
                0 < entries.length && 0 < entries[entries.length - 1].intersectionRatio && this.onScrollChanged(document.createEvent("Event"));
            }, {})), this.listenForScroll(), this.readSelectionRange();
        }
        onScrollChanged(e) {
            this.view.inputState.runHandlers("scroll", e), this.intersecting && this.view.measure();
        }
        onScroll(e) {
            this.intersecting && this.flush(!1), this.onScrollChanged(e);
        }
        onResize() {
            this.resizeTimeout < 0 && (this.resizeTimeout = setTimeout(() => {
                this.resizeTimeout = -1, this.view.requestMeasure();
            }, 50));
        }
        onPrint(event) {
            "change" == event.type && !event.matches || (this.view.viewState.printing = !0, 
            this.view.measure(), setTimeout(() => {
                this.view.viewState.printing = !1, this.view.requestMeasure();
            }, 500));
        }
        updateGaps(gaps) {
            if (this.gapIntersection && (gaps.length != this.gaps.length || this.gaps.some((g, i) => g != gaps[i]))) {
                this.gapIntersection.disconnect();
                for (var gap of gaps) this.gapIntersection.observe(gap);
                this.gaps = gaps;
            }
        }
        onSelectionChange(event) {
            var view, sel, context, wasChanged = this.selectionChanged;
            this.readSelectionRange() && !this.delayedAndroidKey && (view = this.view, 
            sel = this.selectionRange, view.state.facet(editable) ? view.root.activeElement == this.dom : hasSelection(view.dom, sel)) && ((context = sel.anchorNode && view.docView.nearest(sel.anchorNode)) && context.ignoreEvent(event) ? wasChanged || (this.selectionChanged = !1) : (browser.ie && browser.ie_version <= 11 || browser.android && browser.chrome) && !view.state.selection.main.empty && sel.focusNode && isEquivalentPosition(sel.focusNode, sel.focusOffset, sel.anchorNode, sel.anchorOffset) ? this.flushSoon() : this.flush(!1));
        }
        readSelectionRange() {
            var local, view = this["view"], selection = getSelection(view.root);
            return !!selection && !(!(selection = browser.safari && 11 == view.root.nodeType && function(doc) {
                let elt = doc.activeElement;
                for (;elt && elt.shadowRoot; ) elt = elt.shadowRoot.activeElement;
                return elt;
            }(this.dom.ownerDocument) == this.dom && function(view, selection) {
                if (selection.getComposedRanges) {
                    selection = selection.getComposedRanges(view.root)[0];
                    if (selection) return buildSelectionRangeFromRange(view, selection);
                }
                let found = null;
                function read(event) {
                    event.preventDefault(), event.stopImmediatePropagation(), found = event.getTargetRanges()[0];
                }
                return view.contentDOM.addEventListener("beforeinput", read, !0), 
                view.dom.ownerDocument.execCommand("indent"), view.contentDOM.removeEventListener("beforeinput", read, !0), 
                found ? buildSelectionRangeFromRange(view, found) : null;
            }(this.view, selection) || selection) || this.selectionRange.eq(selection) || ((local = hasSelection(this.dom, selection)) && !this.selectionChanged && view.inputState.lastFocusTime > Date.now() - 200 && view.inputState.lastTouchTime < Date.now() - 300 && function(doc, selection) {
                let node = selection.focusNode, offset = selection.focusOffset;
                if (node && selection.anchorNode == node && selection.anchorOffset == offset) for (offset = Math.min(offset, maxOffset(node)); ;) if (offset) {
                    if (1 != node.nodeType) return;
                    var prev = node.childNodes[offset - 1];
                    "false" == prev.contentEditable ? offset-- : (node = prev, offset = maxOffset(node));
                } else {
                    if (node == doc) return 1;
                    offset = domIndex(node), node = node.parentNode;
                }
            }(this.dom, selection) ? (this.view.inputState.lastFocusTime = 0, view.docView.updateSelection(), 
            1) : (this.selectionRange.setRange(selection), local && (this.selectionChanged = !0), 
            0)));
        }
        setSelectionRange(anchor, head) {
            this.selectionRange.set(anchor.node, anchor.offset, head.node, head.offset), 
            this.selectionChanged = !1;
        }
        clearSelectionRange() {
            this.selectionRange.set(null, 0, null, 0);
        }
        listenForScroll() {
            this.parentCheck = -1;
            let i = 0, changed = null;
            for (let dom = this.dom; dom; ) if (1 == dom.nodeType) !changed && i < this.scrollTargets.length && this.scrollTargets[i] == dom ? i++ : changed = changed || this.scrollTargets.slice(0, i), 
            changed && changed.push(dom), dom = dom.assignedSlot || dom.parentNode; else {
                if (11 != dom.nodeType) break;
                dom = dom.host;
            }
            if (changed = i < this.scrollTargets.length && !changed ? this.scrollTargets.slice(0, i) : changed) {
                for (var dom of this.scrollTargets) dom.removeEventListener("scroll", this.onScroll);
                for (let dom of this.scrollTargets = changed) dom.addEventListener("scroll", this.onScroll);
            }
        }
        ignore(f) {
            if (!this.active) return f();
            try {
                return this.stop(), f();
            } finally {
                this.start(), this.clear();
            }
        }
        start() {
            this.active || (this.observer.observe(this.dom, observeOptions), useCharData && this.dom.addEventListener("DOMCharacterDataModified", this.onCharData), 
            this.active = !0);
        }
        stop() {
            this.active && (this.active = !1, this.observer.disconnect(), useCharData) && this.dom.removeEventListener("DOMCharacterDataModified", this.onCharData);
        }
        clear() {
            this.processRecords(), this.queue.length = 0, this.selectionChanged = !1;
        }
        delayAndroidKey(key, keyCode) {
            this.delayedAndroidKey || (this.flushingAndroidKey = this.view.win.requestAnimationFrame(() => {
                var key = this.delayedAndroidKey;
                key && (this.clearDelayedAndroidKey(), this.view.inputState.lastKeyCode = key.keyCode, 
                this.view.inputState.lastKeyTime = Date.now(), !this.flush()) && key.force && dispatchKey(this.dom, key.key, key.keyCode);
            })), this.delayedAndroidKey && "Enter" != key || (this.delayedAndroidKey = {
                key: key,
                keyCode: keyCode,
                force: this.lastChange < Date.now() - 50 || !(null == (key = this.delayedAndroidKey) || !key.force)
            });
        }
        clearDelayedAndroidKey() {
            this.win.cancelAnimationFrame(this.flushingAndroidKey), this.delayedAndroidKey = null, 
            this.flushingAndroidKey = -1;
        }
        flushSoon() {
            this.delayedFlush < 0 && (this.delayedFlush = this.view.win.requestAnimationFrame(() => {
                this.delayedFlush = -1, this.flush();
            }));
        }
        forceFlush() {
            0 <= this.delayedFlush && (this.view.win.cancelAnimationFrame(this.delayedFlush), 
            this.delayedFlush = -1), this.flush();
        }
        pendingRecords() {
            for (var mut of this.observer.takeRecords()) this.queue.push(mut);
            return this.queue;
        }
        processRecords() {
            var record, records = this.pendingRecords();
            records.length && (this.queue = []);
            let from = -1, to = -1, typeOver = !1;
            for (record of records) {
                var range = this.readMutation(record);
                range && (range.typeOver && (typeOver = !0), -1 == from ? {
                    from,
                    to
                } = range : (from = Math.min(range.from, from), to = Math.max(range.to, to)));
            }
            return {
                from: from,
                to: to,
                typeOver: typeOver
            };
        }
        readChange() {
            var {
                from,
                to,
                typeOver
            } = this.processRecords(), newSel = this.selectionChanged && hasSelection(this.dom, this.selectionRange);
            if (from < 0 && !newSel) return null;
            -1 < from && (this.lastChange = Date.now()), this.view.inputState.lastFocusTime = 0, 
            this.selectionChanged = !1;
            newSel = new DOMChange(this.view, from, to, typeOver);
            return this.view.docView.domChanged = {
                newSel: newSel.newSel ? newSel.newSel.main : null
            }, newSel;
        }
        flush(readSelection = !0) {
            if (0 <= this.delayedFlush || this.delayedAndroidKey) return !1;
            readSelection && this.readSelectionRange();
            var startState, readSelection = this.readChange();
            return readSelection ? (startState = this.view.state, readSelection = applyDOMChange(this.view, readSelection), 
            this.view.state == startState && this.view.update([]), readSelection) : (this.view.requestMeasure(), 
            !1);
        }
        readMutation(rec) {
            var childBefore, childAfter, cView = this.view.docView.nearest(rec.target);
            return !cView || cView.ignoreMutation(rec) ? null : (cView.markDirty("attributes" == rec.type), 
            "attributes" == rec.type && (cView.flags |= 4), "childList" == rec.type ? (childBefore = findChild(cView, rec.previousSibling || rec.target.previousSibling, -1), 
            childAfter = findChild(cView, rec.nextSibling || rec.target.nextSibling, 1), 
            {
                from: childBefore ? cView.posAfter(childBefore) : cView.posAtStart,
                to: childAfter ? cView.posBefore(childAfter) : cView.posAtEnd,
                typeOver: !1
            }) : "characterData" == rec.type ? {
                from: cView.posAtStart,
                to: cView.posAtEnd,
                typeOver: rec.target.nodeValue == rec.oldValue
            } : null);
        }
        setWindow(win) {
            win != this.win && (this.removeWindowListeners(this.win), this.win = win, 
            this.addWindowListeners(this.win));
        }
        addWindowListeners(win) {
            win.addEventListener("resize", this.onResize), this.printQuery ? this.printQuery.addEventListener("change", this.onPrint) : win.addEventListener("beforeprint", this.onPrint), 
            win.addEventListener("scroll", this.onScroll), win.document.addEventListener("selectionchange", this.onSelectionChange);
        }
        removeWindowListeners(win) {
            win.removeEventListener("scroll", this.onScroll), win.removeEventListener("resize", this.onResize), 
            this.printQuery ? this.printQuery.removeEventListener("change", this.onPrint) : win.removeEventListener("beforeprint", this.onPrint), 
            win.document.removeEventListener("selectionchange", this.onSelectionChange);
        }
        destroy() {
            var _a, dom;
            this.stop(), null != (_a = this.intersection) && _a.disconnect(), null != (_a = this.gapIntersection) && _a.disconnect(), 
            null != (_a = this.resizeScroll) && _a.disconnect();
            for (dom of this.scrollTargets) dom.removeEventListener("scroll", this.onScroll);
            this.removeWindowListeners(this.win), clearTimeout(this.parentCheck), 
            clearTimeout(this.resizeTimeout), this.win.cancelAnimationFrame(this.delayedFlush), 
            this.win.cancelAnimationFrame(this.flushingAndroidKey);
        }
    }
    function findChild(cView, dom, dir) {
        for (;dom; ) {
            var curView = ContentView.get(dom);
            if (curView && curView.parent == cView) return curView;
            curView = dom.parentNode;
            dom = curView != cView.dom ? curView : 0 < dir ? dom.nextSibling : dom.previousSibling;
        }
        return null;
    }
    function buildSelectionRangeFromRange(view, range) {
        let anchorNode = range.startContainer, anchorOffset = range.startOffset, focusNode = range.endContainer, focusOffset = range.endOffset;
        range = view.docView.domAtPos(view.state.selection.main.anchor);
        return isEquivalentPosition(range.node, range.offset, focusNode, focusOffset) && ([ anchorNode, anchorOffset, focusNode, focusOffset ] = [ focusNode, focusOffset, anchorNode, anchorOffset ]), 
        {
            anchorNode: anchorNode,
            anchorOffset: anchorOffset,
            focusNode: focusNode,
            focusOffset: focusOffset
        };
    }
    class EditorView {
        get state() {
            return this.viewState.state;
        }
        get viewport() {
            return this.viewState.viewport;
        }
        get visibleRanges() {
            return this.viewState.visibleRanges;
        }
        get inView() {
            return this.viewState.inView;
        }
        get composing() {
            return 0 < this.inputState.composing;
        }
        get compositionStarted() {
            return 0 <= this.inputState.composing;
        }
        get root() {
            return this._root;
        }
        get win() {
            return this.dom.ownerDocument.defaultView || window;
        }
        constructor(config = {}) {
            this.plugins = [], this.pluginMap = new Map(), this.editorAttrs = {}, 
            this.contentAttrs = {}, this.bidiCache = [], this.destroyed = !1, this.updateState = 2, 
            this.measureScheduled = -1, this.measureRequests = [], this.contentDOM = document.createElement("div"), 
            this.scrollDOM = document.createElement("div"), this.scrollDOM.tabIndex = -1, 
            this.scrollDOM.className = "cm-scroller", this.scrollDOM.appendChild(this.contentDOM), 
            this.announceDOM = document.createElement("div"), this.announceDOM.className = "cm-announced", 
            this.announceDOM.setAttribute("aria-live", "polite"), this.dom = document.createElement("div"), 
            this.dom.appendChild(this.announceDOM), this.dom.appendChild(this.scrollDOM), 
            config.parent && config.parent.appendChild(this.dom);
            let dispatch = config["dispatch"];
            this.dispatchTransactions = config.dispatchTransactions || (dispatch ? trs => trs.forEach(tr => dispatch(tr, this)) : trs => this.update(trs)), 
            this.dispatch = this.dispatch.bind(this), this._root = config.root || function(node) {
                for (;node; ) {
                    if (node && (9 == node.nodeType || 11 == node.nodeType && node.host)) return node;
                    node = node.assignedSlot || node.parentNode;
                }
                return null;
            }(config.parent) || document, this.viewState = new ViewState(config.state || EditorState.create(config)), 
            config.scrollTo && config.scrollTo.is(scrollIntoView$1) && (this.viewState.scrollTarget = config.scrollTo.value.clip(this.viewState.state)), 
            this.plugins = this.state.facet(viewPlugin).map(spec => new PluginInstance(spec));
            for (var plugin of this.plugins) plugin.update(this);
            this.observer = new DOMObserver(this), this.inputState = new InputState(this), 
            this.inputState.ensureHandlers(this.plugins), this.docView = new DocView(this), 
            this.mountStyles(), this.updateAttrs(), this.updateState = 0, this.requestMeasure();
        }
        dispatch(...input) {
            input = 1 == input.length && input[0] instanceof Transaction ? input : 1 == input.length && Array.isArray(input[0]) ? input[0] : [ this.state.update(...input) ];
            this.dispatchTransactions(input, this);
        }
        update(transactions) {
            if (0 != this.updateState) throw new Error("Calls to EditorView.update are not allowed while an update is in progress");
            let redrawn = !1, attrsChanged = !1, update, state = this.state;
            for (var tr of transactions) {
                if (tr.startState != state) throw new RangeError("Trying to update state with a transaction that doesn't start from the previous state.");
                state = tr.state;
            }
            if (this.destroyed) this.viewState.state = state; else {
                let focus = this.hasFocus, focusFlag = 0, dispatchFocus = null, pendingKey = (transactions.some(tr => tr.annotation(isFocusChange)) ? (this.inputState.notifiedFocused = focus, 
                focusFlag = 1) : focus == this.inputState.notifiedFocused || (this.inputState.notifiedFocused = focus, 
                dispatchFocus = focusChangeTransaction(state, focus)) || (focusFlag = 1), 
                this.observer.delayedAndroidKey), domChange = null;
                if (pendingKey ? (this.observer.clearDelayedAndroidKey(), (!(domChange = this.observer.readChange()) || this.state.doc.eq(state.doc)) && this.state.selection.eq(state.selection) || (domChange = null)) : this.observer.clear(), 
                state.facet(EditorState.phrases) != this.state.facet(EditorState.phrases)) return this.setState(state);
                (update = ViewUpdate.create(this, state, transactions)).flags |= focusFlag;
                let scrollTarget = this.viewState.scrollTarget;
                try {
                    this.updateState = 2;
                    for (let tr of transactions) {
                        var main, e;
                        scrollTarget = scrollTarget && scrollTarget.map(tr.changes), 
                        tr.scrollIntoView && (main = tr.state.selection["main"], 
                        scrollTarget = new ScrollTarget(main.empty ? main : EditorSelection.cursor(main.head, main.head > main.anchor ? -1 : 1)));
                        for (e of tr.effects) e.is(scrollIntoView$1) && (scrollTarget = e.value.clip(this.state));
                    }
                    this.viewState.update(update, scrollTarget), this.bidiCache = CachedOrder.update(this.bidiCache, update.changes), 
                    update.empty || (this.updatePlugins(update), this.inputState.update(update)), 
                    redrawn = this.docView.update(update), this.state.facet(styleModule) != this.styleModules && this.mountStyles(), 
                    attrsChanged = this.updateAttrs(), this.showAnnouncements(transactions), 
                    this.docView.updateSelection(redrawn, transactions.some(tr => tr.isUserEvent("select.pointer")));
                } finally {
                    this.updateState = 0;
                }
                if (update.startState.facet(theme) != update.state.facet(theme) && (this.viewState.mustMeasureContent = !0), 
                (redrawn || attrsChanged || scrollTarget || this.viewState.mustEnforceCursorAssoc || this.viewState.mustMeasureContent) && this.requestMeasure(), 
                redrawn && this.docViewUpdate(), !update.empty) for (var listener of this.state.facet(updateListener)) try {
                    listener(update);
                } catch (e) {
                    logException(this.state, e, "update listener");
                }
                (dispatchFocus || domChange) && Promise.resolve().then(() => {
                    dispatchFocus && this.state == dispatchFocus.startState && this.dispatch(dispatchFocus), 
                    domChange && !applyDOMChange(this, domChange) && pendingKey.force && dispatchKey(this.contentDOM, pendingKey.key, pendingKey.keyCode);
                });
            }
        }
        setState(newState) {
            if (0 != this.updateState) throw new Error("Calls to EditorView.setState are not allowed while an update is in progress");
            if (this.destroyed) this.viewState.state = newState; else {
                this.updateState = 2;
                var hadFocus = this.hasFocus;
                try {
                    for (var plugin of this.plugins) plugin.destroy(this);
                    this.viewState = new ViewState(newState), this.plugins = newState.facet(viewPlugin).map(spec => new PluginInstance(spec)), 
                    this.pluginMap.clear();
                    for (let plugin of this.plugins) plugin.update(this);
                    this.docView.destroy(), this.docView = new DocView(this), this.inputState.ensureHandlers(this.plugins), 
                    this.mountStyles(), this.updateAttrs(), this.bidiCache = [];
                } finally {
                    this.updateState = 0;
                }
                hadFocus && this.focus(), this.requestMeasure();
            }
        }
        updatePlugins(update) {
            var prevSpecs = update.startState.facet(viewPlugin), specs = update.state.facet(viewPlugin);
            if (prevSpecs != specs) {
                var spec, newPlugins = [];
                for (spec of specs) {
                    var found = prevSpecs.indexOf(spec);
                    found < 0 ? newPlugins.push(new PluginInstance(spec)) : ((found = this.plugins[found]).mustUpdate = update, 
                    newPlugins.push(found));
                }
                for (let plugin of this.plugins) plugin.mustUpdate != update && plugin.destroy(this);
                this.plugins = newPlugins, this.pluginMap.clear();
            } else for (var p of this.plugins) p.mustUpdate = update;
            for (let i = 0; i < this.plugins.length; i++) this.plugins[i].update(this);
            prevSpecs != specs && this.inputState.ensureHandlers(this.plugins);
        }
        docViewUpdate() {
            for (var plugin of this.plugins) {
                plugin = plugin.value;
                if (plugin && plugin.docViewUpdate) try {
                    plugin.docViewUpdate(this);
                } catch (e) {
                    logException(this.state, e, "doc view update listener");
                }
            }
        }
        measure(flush = !0) {
            if (!this.destroyed) if (-1 < this.measureScheduled && this.win.cancelAnimationFrame(this.measureScheduled), 
            this.observer.delayedAndroidKey) this.measureScheduled = -1, this.requestMeasure(); else {
                this.measureScheduled = 0, flush && this.observer.forceFlush();
                let updated = null, sDOM = this.scrollDOM, scrollTop = sDOM.scrollTop * this.scaleY, {
                    scrollAnchorPos,
                    scrollAnchorHeight
                } = this.viewState;
                1 < Math.abs(scrollTop - this.viewState.scrollTop) && (scrollAnchorHeight = -1), 
                this.viewState.scrollAnchorHeight = -1;
                try {
                    for (let i = 0; ;i++) {
                        scrollAnchorHeight < 0 && (scrollAnchorHeight = isScrolledToBottom(sDOM) ? (scrollAnchorPos = -1, 
                        this.viewState.heightMap.height) : (block = this.viewState.scrollAnchorAt(scrollTop), 
                        scrollAnchorPos = block.from, block.top)), this.updateState = 1;
                        var block, changed = this.viewState.measure(this);
                        if (!changed && !this.measureRequests.length && null == this.viewState.scrollTarget) break;
                        if (5 < i) {
                            console.warn(this.measureRequests.length ? "Measure loop restarted more than 5 times" : "Viewport failed to stabilize");
                            break;
                        }
                        let measuring = [];
                        4 & changed || ([ this.measureRequests, measuring ] = [ measuring, this.measureRequests ]);
                        var measured = measuring.map(m => {
                            try {
                                return m.read(this);
                            } catch (e) {
                                return logException(this.state, e), BadMeasure;
                            }
                        });
                        let update = ViewUpdate.create(this, this.state, []), redrawn = !1;
                        update.flags |= changed, updated ? updated.flags |= changed : updated = update, 
                        this.updateState = 2, !update.empty && (this.updatePlugins(update), 
                        this.inputState.update(update), this.updateAttrs(), redrawn = this.docView.update(update)) && this.docViewUpdate();
                        for (let i = 0; i < measuring.length; i++) if (measured[i] != BadMeasure) try {
                            var m = measuring[i];
                            m.write && m.write(measured[i], this);
                        } catch (e) {
                            logException(this.state, e);
                        }
                        if (redrawn && this.docView.updateSelection(!0), !update.viewportChanged && 0 == this.measureRequests.length) {
                            if (this.viewState.editorHeight) {
                                if (this.viewState.scrollTarget) {
                                    this.docView.scrollIntoView(this.viewState.scrollTarget), 
                                    this.viewState.scrollTarget = null, scrollAnchorHeight = -1;
                                    continue;
                                }
                                var diff = (scrollAnchorPos < 0 ? this.viewState.heightMap.height : this.viewState.lineBlockAt(scrollAnchorPos).top) - scrollAnchorHeight;
                                if (1 < diff || diff < -1) {
                                    scrollTop += diff, sDOM.scrollTop = scrollTop / this.scaleY, 
                                    scrollAnchorHeight = -1;
                                    continue;
                                }
                            }
                            break;
                        }
                    }
                } finally {
                    this.updateState = 0, this.measureScheduled = -1;
                }
                if (updated && !updated.empty) for (var listener of this.state.facet(updateListener)) listener(updated);
            }
        }
        get themeClasses() {
            return baseThemeID + " " + (this.state.facet(darkTheme) ? baseDarkID : baseLightID) + " " + this.state.facet(theme);
        }
        updateAttrs() {
            let editorAttrs = attrsFromFacet(this, editorAttributes, {
                class: "cm-editor" + (this.hasFocus ? " cm-focused " : " ") + this.themeClasses
            }), contentAttrs = {
                spellcheck: "false",
                autocorrect: "off",
                autocapitalize: "off",
                translate: "no",
                contenteditable: this.state.facet(editable) ? "true" : "false",
                class: "cm-content",
                style: browser.tabSize + ": " + this.state.tabSize,
                role: "textbox",
                "aria-multiline": "true"
            };
            this.state.readOnly && (contentAttrs["aria-readonly"] = "true"), attrsFromFacet(this, contentAttributes, contentAttrs);
            var changed = this.observer.ignore(() => {
                var changedContent = updateAttrs(this.contentDOM, this.contentAttrs, contentAttrs), changedEditor = updateAttrs(this.dom, this.editorAttrs, editorAttrs);
                return changedContent || changedEditor;
            });
            return this.editorAttrs = editorAttrs, this.contentAttrs = contentAttrs, 
            changed;
        }
        showAnnouncements(trs) {
            let first = !0;
            for (var tr of trs) for (var effect of tr.effects) effect.is(EditorView.announce) && (first && (this.announceDOM.textContent = ""), 
            first = !1, this.announceDOM.appendChild(document.createElement("div")).textContent = effect.value);
        }
        mountStyles() {
            this.styleModules = this.state.facet(styleModule);
            var nonce = this.state.facet(EditorView.cspNonce);
            StyleModule.mount(this.root, this.styleModules.concat(baseTheme$1$2).reverse(), nonce ? {
                nonce: nonce
            } : void 0);
        }
        readMeasured() {
            if (2 == this.updateState) throw new Error("Reading the editor layout isn't allowed during an update");
            0 == this.updateState && -1 < this.measureScheduled && this.measure(!1);
        }
        requestMeasure(request) {
            if (this.measureScheduled < 0 && (this.measureScheduled = this.win.requestAnimationFrame(() => this.measure())), 
            request && !(-1 < this.measureRequests.indexOf(request))) {
                if (null != request.key) for (let i = 0; i < this.measureRequests.length; i++) if (this.measureRequests[i].key === request.key) return void (this.measureRequests[i] = request);
                this.measureRequests.push(request);
            }
        }
        plugin(plugin) {
            let known = this.pluginMap.get(plugin);
            return (void 0 === known || known && known.spec != plugin) && this.pluginMap.set(plugin, known = this.plugins.find(p => p.spec == plugin) || null), 
            known && known.update(this).value;
        }
        get documentTop() {
            return this.contentDOM.getBoundingClientRect().top + this.viewState.paddingTop;
        }
        get documentPadding() {
            return {
                top: this.viewState.paddingTop,
                bottom: this.viewState.paddingBottom
            };
        }
        get scaleX() {
            return this.viewState.scaleX;
        }
        get scaleY() {
            return this.viewState.scaleY;
        }
        elementAtHeight(height) {
            return this.readMeasured(), this.viewState.elementAtHeight(height);
        }
        lineBlockAtHeight(height) {
            return this.readMeasured(), this.viewState.lineBlockAtHeight(height);
        }
        get viewportLineBlocks() {
            return this.viewState.viewportLines;
        }
        lineBlockAt(pos) {
            return this.viewState.lineBlockAt(pos);
        }
        get contentHeight() {
            return this.viewState.contentHeight;
        }
        moveByChar(start, forward, by) {
            return skipAtoms(this, start, moveByChar(this, start, forward, by));
        }
        moveByGroup(start, forward) {
            return skipAtoms(this, start, moveByChar(this, start, forward, initial => function(view, pos, start) {
                let categorize = view.state.charCategorizer(pos), cat = categorize(start);
                return next => {
                    next = categorize(next);
                    return (cat = cat == CharCategory.Space ? next : cat) == next;
                };
            }(this, start.head, initial)));
        }
        visualLineSide(line, end) {
            var order = this.bidiSpans(line), dir = this.textDirectionAt(line.from), order = order[end ? order.length - 1 : 0];
            return EditorSelection.cursor(order.side(end, dir) + line.from, order.forward(!end, dir) ? 1 : -1);
        }
        moveToLineBoundary(start, forward, includeWrap = !0) {
            return function(view, start, forward, includeWrap) {
                var line = blockAt(view, start.head);
                if (includeWrap = includeWrap && line.type == BlockType.Text && (view.lineWrapping || line.widgetLineBreaks) ? view.coordsAtPos(start.assoc < 0 && start.head > line.from ? start.head - 1 : start.head) : null) {
                    var start = view.dom.getBoundingClientRect(), direction = view.textDirectionAt(line.from), view = view.posAtCoords({
                        x: forward == (direction == Direction.LTR) ? start.right - 1 : start.left + 1,
                        y: (includeWrap.top + includeWrap.bottom) / 2
                    });
                    if (null != view) return EditorSelection.cursor(view, forward ? -1 : 1);
                }
                return EditorSelection.cursor(forward ? line.to : line.from, forward ? -1 : 1);
            }(this, start, forward, includeWrap);
        }
        moveVertically(start, forward, distance) {
            return skipAtoms(this, start, function(view, start, forward, distance) {
                var startPos = start.head, dir = forward ? 1 : -1;
                if (startPos == (forward ? view.state.doc.length : 0)) return EditorSelection.cursor(startPos, start.assoc);
                let goal = start.goalColumn, startY;
                var rect = view.contentDOM.getBoundingClientRect(), forward = view.coordsAtPos(startPos, start.assoc || -1), start = view.documentTop, resolvedGoal = (startY = forward ? (null == goal && (goal = forward.left - rect.left), 
                dir < 0 ? forward.top : forward.bottom) : (forward = view.viewState.lineBlockAt(startPos), 
                null == goal && (goal = Math.min(rect.right - rect.left, view.defaultCharacterWidth * (startPos - forward.from))), 
                (dir < 0 ? forward.top : forward.bottom) + start), rect.left + goal), dist = null != distance ? distance : view.viewState.heightOracle.textHeight >> 1;
                for (let extra = 0; ;extra += 10) {
                    var charRect, curY = startY + (dist + extra) * dir, pos = posAtCoords(view, {
                        x: resolvedGoal,
                        y: curY
                    }, !1, dir);
                    if (curY < rect.top || curY > rect.bottom || (dir < 0 ? pos < startPos : startPos < pos)) return curY = !(charRect = view.docView.coordsForChar(pos)) || curY < charRect.top ? -1 : 1, 
                    EditorSelection.cursor(pos, curY, void 0, goal);
                }
            }(this, start, forward, distance));
        }
        domAtPos(pos) {
            return this.docView.domAtPos(pos);
        }
        posAtDOM(node, offset = 0) {
            return this.docView.posFromDOM(node, offset);
        }
        posAtCoords(coords, precise = !0) {
            return this.readMeasured(), posAtCoords(this, coords, precise);
        }
        coordsAtPos(pos, side = 1) {
            this.readMeasured();
            var line, order, rect = this.docView.coordsAt(pos, side);
            return rect && rect.left != rect.right ? (line = this.state.doc.lineAt(pos), 
            flattenRect(rect, (order = this.bidiSpans(line))[BidiSpan.find(order, pos - line.from, -1, side)].dir == Direction.LTR == 0 < side)) : rect;
        }
        coordsForChar(pos) {
            return this.readMeasured(), this.docView.coordsForChar(pos);
        }
        get defaultCharacterWidth() {
            return this.viewState.heightOracle.charWidth;
        }
        get defaultLineHeight() {
            return this.viewState.heightOracle.lineHeight;
        }
        get textDirection() {
            return this.viewState.defaultTextDirection;
        }
        textDirectionAt(pos) {
            return !this.state.facet(perLineTextDirection) || pos < this.viewport.from || pos > this.viewport.to ? this.textDirection : (this.readMeasured(), 
            this.docView.textDirectionAt(pos));
        }
        get lineWrapping() {
            return this.viewState.heightOracle.lineWrapping;
        }
        bidiSpans(line) {
            if (line.length > MaxBidiLine) return trivialOrder(line.length);
            let dir = this.textDirectionAt(line.from), isolates;
            for (var entry of this.bidiCache) if (entry.from == line.from && entry.dir == dir && (entry.fresh || function isolatesEq(a, b) {
                if (a.length == b.length) {
                    for (let i = 0; i < a.length; i++) {
                        var iA = a[i], iB = b[i];
                        if (iA.from != iB.from || iA.to != iB.to || iA.direction != iB.direction || !isolatesEq(iA.inner, iB.inner)) return;
                    }
                    return 1;
                }
            }(entry.isolates, isolates = getIsolatedRanges(this, line)))) return entry.order;
            isolates = isolates || getIsolatedRanges(this, line);
            var order = function(line, direction, isolates) {
                if (!line) return [ new BidiSpan(0, 0, direction == RTL ? 1 : 0) ];
                if (direction == LTR && !isolates.length && !BidiRE.test(line)) return trivialOrder(line.length);
                if (isolates.length) for (;line.length > types.length; ) types[types.length] = 256;
                var order = [], direction = direction == LTR ? 0 : 1;
                return computeSectionOrder(line, direction, direction, isolates, 0, line.length, order), 
                order;
            }(line.text, dir, isolates);
            return this.bidiCache.push(new CachedOrder(line.from, line.to, dir, isolates, !0, order)), 
            order;
        }
        get hasFocus() {
            var _a;
            return (this.dom.ownerDocument.hasFocus() || browser.safari && (null == (_a = this.inputState) ? void 0 : _a.lastContextMenu) > Date.now() - 3e4) && this.root.activeElement == this.contentDOM;
        }
        focus() {
            this.observer.ignore(() => {
                focusPreventScroll(this.contentDOM), this.docView.updateSelection();
            });
        }
        setRoot(root) {
            this._root != root && (this._root = root, this.observer.setWindow((9 == root.nodeType ? root : root.ownerDocument).defaultView || window), 
            this.mountStyles());
        }
        destroy() {
            for (var plugin of this.plugins) plugin.destroy(this);
            this.plugins = [], this.inputState.destroy(), this.docView.destroy(), 
            this.dom.remove(), this.observer.destroy(), -1 < this.measureScheduled && this.win.cancelAnimationFrame(this.measureScheduled), 
            this.destroyed = !0;
        }
        static scrollIntoView(pos, options = {}) {
            return scrollIntoView$1.of(new ScrollTarget("number" == typeof pos ? EditorSelection.cursor(pos) : pos, options.y, options.x, options.yMargin, options.xMargin));
        }
        scrollSnapshot() {
            var {
                scrollTop,
                scrollLeft
            } = this.scrollDOM, ref = this.viewState.scrollAnchorAt(scrollTop);
            return scrollIntoView$1.of(new ScrollTarget(EditorSelection.cursor(ref.from), "start", "start", ref.top - scrollTop, scrollLeft, !0));
        }
        static domEventHandlers(handlers) {
            return ViewPlugin.define(() => ({}), {
                eventHandlers: handlers
            });
        }
        static domEventObservers(observers) {
            return ViewPlugin.define(() => ({}), {
                eventObservers: observers
            });
        }
        static theme(spec, options) {
            var prefix = StyleModule.newName(), prefix = [ theme.of(prefix), styleModule.of(buildTheme("." + prefix, spec)) ];
            return options && options.dark && prefix.push(darkTheme.of(!0)), prefix;
        }
        static baseTheme(spec) {
            return Prec.lowest(styleModule.of(buildTheme("." + baseThemeID, spec, lightDarkIDs)));
        }
        static findFromDOM(dom) {
            var content = dom.querySelector(".cm-content"), content = content && ContentView.get(content) || ContentView.get(dom);
            return (null == (dom = null == content ? void 0 : content.rootView) ? void 0 : dom.view) || null;
        }
    }
    EditorView.styleModule = styleModule, EditorView.inputHandler = inputHandler$1, 
    EditorView.scrollHandler = scrollHandler, EditorView.focusChangeEffect = focusChangeEffect, 
    EditorView.perLineTextDirection = perLineTextDirection, EditorView.exceptionSink = exceptionSink, 
    EditorView.updateListener = updateListener, EditorView.editable = editable, 
    EditorView.mouseSelectionStyle = mouseSelectionStyle, EditorView.dragMovesSelection = dragMovesSelection$1, 
    EditorView.clickAddsSelectionRange = clickAddsSelectionRange, EditorView.decorations = decorations, 
    EditorView.outerDecorations = outerDecorations, EditorView.atomicRanges = atomicRanges, 
    EditorView.bidiIsolatedRanges = bidiIsolatedRanges, EditorView.scrollMargins = scrollMargins, 
    EditorView.darkTheme = darkTheme, EditorView.cspNonce = Facet.define({
        combine: values => values.length ? values[0] : ""
    }), EditorView.contentAttributes = contentAttributes, EditorView.editorAttributes = editorAttributes, 
    EditorView.lineWrapping = EditorView.contentAttributes.of({
        class: "cm-lineWrapping"
    }), EditorView.announce = StateEffect.define();
    const MaxBidiLine = 4096, BadMeasure = {};
    class CachedOrder {
        constructor(from, to, dir, isolates, fresh, order) {
            this.from = from, this.to = to, this.dir = dir, this.isolates = isolates, 
            this.fresh = fresh, this.order = order;
        }
        static update(cache, changes) {
            if (changes.empty && !cache.some(c => c.fresh)) return cache;
            var result = [], lastDir = cache.length ? cache[cache.length - 1].dir : Direction.LTR;
            for (let i = Math.max(0, cache.length - 10); i < cache.length; i++) {
                var entry = cache[i];
                entry.dir != lastDir || changes.touchesRange(entry.from, entry.to) || result.push(new CachedOrder(changes.mapPos(entry.from, 1), changes.mapPos(entry.to, -1), entry.dir, entry.isolates, !1, entry.order));
            }
            return result;
        }
    }
    function attrsFromFacet(view, facet, base) {
        for (let sources = view.state.facet(facet), i = sources.length - 1; 0 <= i; i--) {
            var source = sources[i], source = "function" == typeof source ? source(view) : source;
            source && combineAttrs(source, base);
        }
        return base;
    }
    const currentPlatform = browser.mac ? "mac" : browser.windows ? "win" : browser.linux ? "linux" : "key";
    function modifiers(name, event, shift) {
        return event.altKey && (name = "Alt-" + name), event.ctrlKey && (name = "Ctrl-" + name), 
        event.metaKey && (name = "Meta-" + name), name = !1 !== shift && event.shiftKey ? "Shift-" + name : name;
    }
    ie = Prec.default(EditorView.domEventHandlers({
        keydown(event, view) {
            return runHandlers(getKeymap(view.state), event, view, "editor");
        }
    }));
    const keymap = Facet.define({
        enables: ie
    }), Keymaps = new WeakMap();
    function getKeymap(state) {
        state = state.facet(keymap);
        let map = Keymaps.get(state);
        return map || Keymaps.set(state, map = function(bindings, platform = currentPlatform) {
            let bound = Object.create(null), isPrefix = Object.create(null), checkPrefix = (name, is) => {
                var current = isPrefix[name];
                if (null == current) isPrefix[name] = is; else if (current != is) throw new Error("Key binding " + name + " is used both as a regular binding and as a multi-stroke prefix");
            }, add = (scope, key, command, preventDefault, stopPropagation) => {
                var scopeObj = bound[scope] || (bound[scope] = Object.create(null)), parts = key.split(/ (?!$)/).map(k => function(name, platform) {
                    var parts = name.split(/-(?!$)/);
                    let result = parts[parts.length - 1];
                    "Space" == result && (result = " ");
                    let alt, ctrl, shift, meta;
                    for (let i = 0; i < parts.length - 1; ++i) {
                        var mod = parts[i];
                        if (/^(cmd|meta|m)$/i.test(mod)) meta = !0; else if (/^a(lt)?$/i.test(mod)) alt = !0; else if (/^(c|ctrl|control)$/i.test(mod)) ctrl = !0; else if (/^s(hift)?$/i.test(mod)) shift = !0; else {
                            if (!/^mod$/i.test(mod)) throw new Error("Unrecognized modifier name: " + mod);
                            "mac" == platform ? meta = !0 : ctrl = !0;
                        }
                    }
                    return alt && (result = "Alt-" + result), ctrl && (result = "Ctrl-" + result), 
                    meta && (result = "Meta-" + result), result = shift ? "Shift-" + result : result;
                }(k, platform));
                for (let i = 1; i < parts.length; i++) {
                    let prefix = parts.slice(0, i).join(" ");
                    checkPrefix(prefix, !0), scopeObj[prefix] || (scopeObj[prefix] = {
                        preventDefault: !0,
                        stopPropagation: !1,
                        run: [ view => {
                            let ourObj = storedPrefix = {
                                view: view,
                                prefix: prefix,
                                scope: scope
                            };
                            return setTimeout(() => {
                                storedPrefix == ourObj && (storedPrefix = null);
                            }, PrefixTimeout), !0;
                        } ]
                    });
                }
                var key = parts.join(" "), key = (checkPrefix(key, !1), scopeObj[key] || (scopeObj[key] = {
                    preventDefault: !1,
                    stopPropagation: !1,
                    run: (null == (key = null == (key = scopeObj._any) ? void 0 : key.run) ? void 0 : key.slice()) || []
                }));
                command && key.run.push(command), preventDefault && (key.preventDefault = !0), 
                stopPropagation && (key.stopPropagation = !0);
            };
            for (var b of bindings) {
                var scopes = b.scope ? b.scope.split(" ") : [ "editor" ];
                if (b.any) for (var scope of scopes) {
                    var key, scopeObj = bound[scope] || (bound[scope] = Object.create(null));
                    for (key in scopeObj._any || (scopeObj._any = {
                        preventDefault: !1,
                        stopPropagation: !1,
                        run: []
                    }), scopeObj) scopeObj[key].run.push(b.any);
                }
                var name = b[platform] || b.key;
                if (name) for (let scope of scopes) add(scope, name, b.run, b.preventDefault, b.stopPropagation), 
                b.shift && add(scope, "Shift-" + name, b.shift, b.preventDefault, b.stopPropagation);
            }
            return bound;
        }(state.reduce((a, b) => a.concat(b), []))), map;
    }
    let storedPrefix = null;
    const PrefixTimeout = 4e3;
    function runHandlers(map, event, view, scope) {
        var name = function(event) {
            return event = "Down" == (event = "Right" == (event = "Up" == (event = "Left" == (event = "Del" == (event = "Esc" == (event = !(mac && event.metaKey && event.shiftKey && !event.ctrlKey && !event.altKey || ie$1 && event.shiftKey && event.key && 1 == event.key.length || "Unidentified" == event.key) && event.key || (event.shiftKey ? shift : base)[event.keyCode] || event.key || "Unidentified") ? "Escape" : event) ? "Delete" : event) ? "ArrowLeft" : event) ? "ArrowUp" : event) ? "ArrowRight" : event) ? "ArrowDown" : event;
        }(event), isChar = (codePointAt(name, 0) < 65536 ? 1 : 2) == name.length && " " != name;
        let prefix = "", handled = !1, prevented = !1, stopPropagation = !1, ran = (storedPrefix && storedPrefix.view == view && storedPrefix.scope == scope && (prefix = storedPrefix.prefix + " ", 
        modifierCodes.indexOf(event.keyCode) < 0) && (prevented = !0, storedPrefix = null), 
        new Set());
        var runFor = binding => {
            if (binding) {
                for (var cmd of binding.run) if (!ran.has(cmd) && (ran.add(cmd), 
                cmd(view, event))) return binding.stopPropagation && (stopPropagation = !0), 
                !0;
                binding.preventDefault && (binding.stopPropagation && (stopPropagation = !0), 
                prevented = !0);
            }
            return !1;
        };
        let scopeObj = map[scope], baseName, shiftName;
        return scopeObj && (runFor(scopeObj[prefix + modifiers(name, event, !isChar)]) ? handled = !0 : isChar && (event.altKey || event.metaKey || event.ctrlKey) && !(browser.windows && event.ctrlKey && event.altKey) && (baseName = base[event.keyCode]) && baseName != name ? (runFor(scopeObj[prefix + modifiers(baseName, event, !0)]) || event.shiftKey && (shiftName = shift[event.keyCode]) != name && shiftName != baseName && runFor(scopeObj[prefix + modifiers(shiftName, event, !1)])) && (handled = !0) : isChar && event.shiftKey && runFor(scopeObj[prefix + modifiers(name, event, !0)]) && (handled = !0), 
        !handled) && runFor(scopeObj._any) && (handled = !0), (handled = prevented ? !0 : handled) && stopPropagation && event.stopPropagation(), 
        handled;
    }
    class RectangleMarker {
        constructor(className, left, top, width, height) {
            this.className = className, this.left = left, this.top = top, this.width = width, 
            this.height = height;
        }
        draw() {
            var elt = document.createElement("div");
            return elt.className = this.className, this.adjust(elt), elt;
        }
        update(elt, prev) {
            return prev.className == this.className && (this.adjust(elt), !0);
        }
        adjust(elt) {
            elt.style.left = this.left + "px", elt.style.top = this.top + "px", 
            null != this.width && (elt.style.width = this.width + "px"), elt.style.height = this.height + "px";
        }
        eq(p) {
            return this.left == p.left && this.top == p.top && this.width == p.width && this.height == p.height && this.className == p.className;
        }
        static forRange(view, className, range) {
            var pos, base;
            return range.empty ? (pos = view.coordsAtPos(range.head, range.assoc || 1)) ? (base = getBase(view), 
            [ new RectangleMarker(className, pos.left - base.left, pos.top - base.top, null, pos.bottom - pos.top) ]) : [] : function(view, className, range) {
                if (range.to <= view.viewport.from || range.from >= view.viewport.to) return [];
                let from = Math.max(range.from, view.viewport.from), to = Math.min(range.to, view.viewport.to), ltr = view.textDirection == Direction.LTR, content = view.contentDOM, contentRect = content.getBoundingClientRect(), base = getBase(view), lineElt = content.querySelector(".cm-line"), lineStyle = lineElt && window.getComputedStyle(lineElt), leftSide = contentRect.left + (lineStyle ? parseInt(lineStyle.paddingLeft) + Math.min(0, parseInt(lineStyle.textIndent)) : 0), rightSide = contentRect.right - (lineStyle ? parseInt(lineStyle.paddingRight) : 0), startBlock = blockAt(view, from), endBlock = blockAt(view, to), visualStart = startBlock.type == BlockType.Text ? startBlock : null, visualEnd = endBlock.type == BlockType.Text ? endBlock : null;
                visualStart && (view.lineWrapping || startBlock.widgetLineBreaks) && (visualStart = wrappedLine(view, from, visualStart));
                visualEnd && (view.lineWrapping || endBlock.widgetLineBreaks) && (visualEnd = wrappedLine(view, to, visualEnd));
                {
                    var top, between;
                    return visualStart && visualEnd && visualStart.from == visualEnd.from ? pieces(drawForLine(range.from, range.to, visualStart)) : (top = visualStart ? drawForLine(range.from, null, visualStart) : drawForWidget(startBlock, !1), 
                    range = visualEnd ? drawForLine(null, range.to, visualEnd) : drawForWidget(endBlock, !0), 
                    between = [], (visualStart || startBlock).to < (visualEnd || endBlock).from - (visualStart && visualEnd ? 1 : 0) || 1 < startBlock.widgetLineBreaks && top.bottom + view.defaultLineHeight / 2 < range.top ? between.push(piece(leftSide, top.bottom, rightSide, range.top)) : top.bottom < range.top && view.elementAtHeight((top.bottom + range.top) / 2).type == BlockType.Text && (top.bottom = range.top = (top.bottom + range.top) / 2), 
                    pieces(top).concat(between).concat(pieces(range)));
                }
                function piece(left, top, right, bottom) {
                    return new RectangleMarker(className, left - base.left, top - base.top - .01, right - left, bottom - top + .01);
                }
                function pieces({
                    top,
                    bottom,
                    horizontal
                }) {
                    var pieces = [];
                    for (let i = 0; i < horizontal.length; i += 2) pieces.push(piece(horizontal[i], top, horizontal[i + 1], bottom));
                    return pieces;
                }
                function drawForLine(from, to, line) {
                    let top = 1e9, bottom = -1e9, horizontal = [];
                    function addSpan(from, fromOpen, to, toOpen, dir) {
                        from = view.coordsAtPos(from, from == line.to ? -2 : 2), 
                        to = view.coordsAtPos(to, to == line.from ? 2 : -2);
                        from && to && (top = Math.min(from.top, to.top, top), bottom = Math.max(from.bottom, to.bottom, bottom), 
                        dir == Direction.LTR ? horizontal.push(ltr && fromOpen ? leftSide : from.left, ltr && toOpen ? rightSide : to.right) : horizontal.push(!ltr && toOpen ? leftSide : to.left, !ltr && fromOpen ? rightSide : from.right));
                    }
                    var r, start = null != from ? from : line.from, end = null != to ? to : line.to;
                    for (r of view.visibleRanges) if (r.to > start && r.from < end) for (let pos = Math.max(r.from, start), endPos = Math.min(r.to, end); ;) {
                        var span, docLine = view.state.doc.lineAt(pos);
                        for (span of view.bidiSpans(docLine)) {
                            var spanFrom = span.from + docLine.from, spanTo = span.to + docLine.from;
                            if (endPos <= spanFrom) break;
                            spanTo > pos && addSpan(Math.max(spanFrom, pos), null == from && spanFrom <= start, Math.min(spanTo, endPos), null == to && end <= spanTo, span.dir);
                        }
                        if ((pos = docLine.to + 1) >= endPos) break;
                    }
                    return 0 == horizontal.length && addSpan(start, null == from, end, null == to, view.textDirection), 
                    {
                        top: top,
                        bottom: bottom,
                        horizontal: horizontal
                    };
                }
                function drawForWidget(block, top) {
                    top = contentRect.top + (top ? block.top : block.bottom);
                    return {
                        top: top,
                        bottom: top,
                        horizontal: []
                    };
                }
            }(view, className, range);
        }
    }
    function getBase(view) {
        var rect = view.scrollDOM.getBoundingClientRect();
        return {
            left: (view.textDirection == Direction.LTR ? rect.left : rect.right - view.scrollDOM.clientWidth * view.scaleX) - view.scrollDOM.scrollLeft * view.scaleX,
            top: rect.top - view.scrollDOM.scrollTop * view.scaleY
        };
    }
    function wrappedLine(view, pos, inside) {
        pos = EditorSelection.cursor(pos);
        return {
            from: Math.max(inside.from, view.moveToLineBoundary(pos, !1, !0).from),
            to: Math.min(inside.to, view.moveToLineBoundary(pos, !0, !0).from),
            type: BlockType.Text
        };
    }
    class LayerView {
        constructor(view, layer) {
            this.view = view, this.layer = layer, this.drawn = [], this.scaleX = 1, 
            this.scaleY = 1, this.measureReq = {
                read: this.measure.bind(this),
                write: this.draw.bind(this)
            }, this.dom = view.scrollDOM.appendChild(document.createElement("div")), 
            this.dom.classList.add("cm-layer"), layer.above && this.dom.classList.add("cm-layer-above"), 
            layer.class && this.dom.classList.add(layer.class), this.scale(), this.dom.setAttribute("aria-hidden", "true"), 
            this.setOrder(view.state), view.requestMeasure(this.measureReq), layer.mount && layer.mount(this.dom, view);
        }
        update(update) {
            update.startState.facet(layerOrder) != update.state.facet(layerOrder) && this.setOrder(update.state), 
            (this.layer.update(update, this.dom) || update.geometryChanged) && (this.scale(), 
            update.view.requestMeasure(this.measureReq));
        }
        docViewUpdate(view) {
            !1 !== this.layer.updateOnDocViewUpdate && view.requestMeasure(this.measureReq);
        }
        setOrder(state) {
            let pos = 0, order = state.facet(layerOrder);
            for (;pos < order.length && order[pos] != this.layer; ) pos++;
            this.dom.style.zIndex = String((this.layer.above ? 150 : -1) - pos);
        }
        measure() {
            return this.layer.markers(this.view);
        }
        scale() {
            var {
                scaleX,
                scaleY
            } = this.view;
            scaleX == this.scaleX && scaleY == this.scaleY || (this.scaleX = scaleX, 
            this.scaleY = scaleY, this.dom.style.transform = `scale(${1 / scaleX}, ${1 / scaleY})`);
        }
        draw(markers) {
            if (markers.length != this.drawn.length || markers.some((p, i) => {
                return p = p, i = this.drawn[i], !(p.constructor == i.constructor && p.eq(i));
            })) {
                let old = this.dom.firstChild, oldI = 0;
                for (var marker of markers) marker.update && old && marker.constructor && this.drawn[oldI].constructor && marker.update(old, this.drawn[oldI]) ? (old = old.nextSibling, 
                oldI++) : this.dom.insertBefore(marker.draw(), old);
                for (;old; ) {
                    var next = old.nextSibling;
                    old.remove(), old = next;
                }
                this.drawn = markers;
            }
        }
        destroy() {
            this.layer.destroy && this.layer.destroy(this.dom, this.view), this.dom.remove();
        }
    }
    const layerOrder = Facet.define();
    function layer(config) {
        return [ ViewPlugin.define(v => new LayerView(v, config)), layerOrder.of(config) ];
    }
    const CanHidePrimary = !browser.ios, selectionConfig = Facet.define({
        combine(configs) {
            return combineConfig(configs, {
                cursorBlinkRate: 1200,
                drawRangeCursor: !0
            }, {
                cursorBlinkRate: (a, b) => Math.min(a, b),
                drawRangeCursor: (a, b) => a || b
            });
        }
    });
    function configChanged(update) {
        return update.startState.facet(selectionConfig) != update.state.facet(selectionConfig);
    }
    const cursorLayer = layer({
        above: !0,
        markers(view) {
            var r, state = view["state"], conf = state.facet(selectionConfig), cursors = [];
            for (r of state.selection.ranges) {
                var prim = r == state.selection.main;
                if (r.empty ? !prim || CanHidePrimary : conf.drawRangeCursor) {
                    var piece, prim = prim ? "cm-cursor cm-cursor-primary" : "cm-cursor cm-cursor-secondary", cursor = r.empty ? r : EditorSelection.cursor(r.head, r.head > r.anchor ? -1 : 1);
                    for (piece of RectangleMarker.forRange(view, prim, cursor)) cursors.push(piece);
                }
            }
            return cursors;
        },
        update(update, dom) {
            update.transactions.some(tr => tr.selection) && (dom.style.animationName = "cm-blink" == dom.style.animationName ? "cm-blink2" : "cm-blink");
            var confChange = configChanged(update);
            return confChange && setBlinkRate(update.state, dom), update.docChanged || update.selectionSet || confChange;
        },
        mount(dom, view) {
            setBlinkRate(view.state, dom);
        },
        class: "cm-cursorLayer"
    });
    function setBlinkRate(state, dom) {
        dom.style.animationDuration = state.facet(selectionConfig).cursorBlinkRate + "ms";
    }
    const selectionLayer = layer({
        above: !1,
        markers(view) {
            return view.state.selection.ranges.map(r => r.empty ? [] : RectangleMarker.forRange(view, "cm-selectionBackground", r)).reduce((a, b) => a.concat(b));
        },
        update(update, dom) {
            return update.docChanged || update.selectionSet || update.viewportChanged || configChanged(update);
        },
        class: "cm-selectionLayer"
    });
    ie_upto10 = {
        ".cm-line": {
            "& ::selection": {
                backgroundColor: "transparent !important"
            },
            "&::selection": {
                backgroundColor: "transparent !important"
            }
        }
    };
    CanHidePrimary && (ie_upto10[".cm-line"].caretColor = "transparent !important", 
    ie_upto10[".cm-content"] = {
        caretColor: "transparent !important"
    });
    const hideNativeSelection = Prec.highest(EditorView.theme(ie_upto10)), setDropCursorPos = StateEffect.define({
        map(pos, mapping) {
            return null == pos ? null : mapping.mapPos(pos);
        }
    }), dropCursorPos = StateField.define({
        create() {
            return null;
        },
        update(pos, tr) {
            return null != pos && (pos = tr.changes.mapPos(pos)), tr.effects.reduce((pos, e) => e.is(setDropCursorPos) ? e.value : pos, pos);
        }
    }), drawDropCursor = ViewPlugin.fromClass(class {
        constructor(view) {
            this.view = view, this.cursor = null, this.measureReq = {
                read: this.readPos.bind(this),
                write: this.drawCursor.bind(this)
            };
        }
        update(update) {
            var _a, cursorPos = update.state.field(dropCursorPos);
            null == cursorPos ? null != this.cursor && (null != (_a = this.cursor) && _a.remove(), 
            this.cursor = null) : (this.cursor || (this.cursor = this.view.scrollDOM.appendChild(document.createElement("div")), 
            this.cursor.className = "cm-dropCursor"), (update.startState.field(dropCursorPos) != cursorPos || update.docChanged || update.geometryChanged) && this.view.requestMeasure(this.measureReq));
        }
        readPos() {
            var outer, view = this["view"], pos = view.state.field(dropCursorPos), pos = null != pos && view.coordsAtPos(pos);
            return pos ? (outer = view.scrollDOM.getBoundingClientRect(), {
                left: pos.left - outer.left + view.scrollDOM.scrollLeft * view.scaleX,
                top: pos.top - outer.top + view.scrollDOM.scrollTop * view.scaleY,
                height: pos.bottom - pos.top
            }) : null;
        }
        drawCursor(pos) {
            var scaleX, scaleY;
            this.cursor && ({
                scaleX,
                scaleY
            } = this.view, pos ? (this.cursor.style.left = pos.left / scaleX + "px", 
            this.cursor.style.top = pos.top / scaleY + "px", this.cursor.style.height = pos.height / scaleY + "px") : this.cursor.style.left = "-100000px");
        }
        destroy() {
            this.cursor && this.cursor.remove();
        }
        setDropPos(pos) {
            this.view.state.field(dropCursorPos) != pos && this.view.dispatch({
                effects: setDropCursorPos.of(pos)
            });
        }
    }, {
        eventObservers: {
            dragover(event) {
                this.setDropPos(this.view.posAtCoords({
                    x: event.clientX,
                    y: event.clientY
                }));
            },
            dragleave(event) {
                event.target != this.view.contentDOM && this.view.contentDOM.contains(event.relatedTarget) || this.setDropPos(null);
            },
            dragend() {
                this.setDropPos(null);
            },
            drop() {
                this.setDropPos(null);
            }
        }
    });
    function iterMatches(doc, re, from, to, f) {
        re.lastIndex = 0;
        for (let cursor = doc.iterRange(from, to), pos = from, m; !cursor.next().done; pos += cursor.value.length) if (!cursor.lineBreak) for (;m = re.exec(cursor.value); ) f(pos + m.index, m);
    }
    class MatchDecorator {
        constructor(config) {
            const {
                regexp,
                decoration,
                decorate,
                boundary,
                maxLength = 1e3
            } = config;
            if (!regexp.global) throw new RangeError("The regular expression given to MatchDecorator should have its 'g' flag set");
            if (this.regexp = regexp, decorate) this.addMatch = (match, view, from, add) => decorate(add, from, from + match[0].length, match, view); else if ("function" == typeof decoration) this.addMatch = (match, view, from, add) => {
                view = decoration(match, view, from);
                view && add(from, from + match[0].length, view);
            }; else {
                if (!decoration) throw new RangeError("Either 'decorate' or 'decoration' should be provided to MatchDecorator");
                this.addMatch = (match, _view, from, add) => add(from, from + match[0].length, decoration);
            }
            this.boundary = boundary, this.maxLength = maxLength;
        }
        createDeco(view) {
            let build = new RangeSetBuilder(), add = build.add.bind(build);
            for (var {
                from,
                to
            } of function(view, maxLength) {
                var visible = view.visibleRanges;
                if (1 == visible.length && visible[0].from == view.viewport.from && visible[0].to == view.viewport.to) return visible;
                var from, to, result = [];
                for ({
                    from,
                    to
                } of visible) from = Math.max(view.state.doc.lineAt(from).from, from - maxLength), 
                to = Math.min(view.state.doc.lineAt(to).to, to + maxLength), result.length && result[result.length - 1].to >= from ? result[result.length - 1].to = to : result.push({
                    from: from,
                    to: to
                });
                return result;
            }(view, this.maxLength)) iterMatches(view.state.doc, this.regexp, from, to, (from, m) => this.addMatch(m, view, from, add));
            return build.finish();
        }
        updateDeco(update, deco) {
            let changeFrom = 1e9, changeTo = -1;
            return update.docChanged && update.changes.iterChanges((_f, _t, from, to) => {
                to > update.view.viewport.from && from < update.view.viewport.to && (changeFrom = Math.min(from, changeFrom), 
                changeTo = Math.max(to, changeTo));
            }), update.viewportChanged || 1e3 < changeTo - changeFrom ? this.createDeco(update.view) : -1 < changeTo ? this.updateRange(update.view, deco.map(update.changes), changeFrom, changeTo) : deco;
        }
        updateRange(view, deco, updateFrom, updateTo) {
            for (var r of view.visibleRanges) {
                let from = Math.max(r.from, updateFrom), to = Math.min(r.to, updateTo);
                if (to > from) {
                    var fromLine = view.state.doc.lineAt(from), toLine = fromLine.to < to ? view.state.doc.lineAt(to) : fromLine;
                    let start = Math.max(r.from, fromLine.from), end = Math.min(r.to, toLine.to);
                    if (this.boundary) {
                        for (;from > fromLine.from; from--) if (this.boundary.test(fromLine.text[from - 1 - fromLine.from])) {
                            start = from;
                            break;
                        }
                        for (;to < toLine.to; to++) if (this.boundary.test(toLine.text[to - toLine.from])) {
                            end = to;
                            break;
                        }
                    }
                    let ranges = [], m, add = (from, to, deco) => ranges.push(deco.range(from, to));
                    if (fromLine == toLine) for (this.regexp.lastIndex = start - fromLine.from; (m = this.regexp.exec(fromLine.text)) && m.index < end - fromLine.from; ) this.addMatch(m, view, m.index + fromLine.from, add); else iterMatches(view.state.doc, this.regexp, start, end, (from, m) => this.addMatch(m, view, from, add));
                    deco = deco.update({
                        filterFrom: start,
                        filterTo: end,
                        filter: (from, to) => from < start || to > end,
                        add: ranges
                    });
                }
            }
            return deco;
        }
    }
    const UnicodeRegexpSupport = null != /x/.unicode ? "gu" : "g", Specials = new RegExp("[\0-\b\n-\x1f\x7f-\x9f\xad\u061c\u200b\u200e\u200f\u2028\u2029\u202d\u202e\u2066\u2067\u2069\ufeff\ufff9-\ufffc]", UnicodeRegexpSupport), Names = {
        0: "null",
        7: "bell",
        8: "backspace",
        10: "newline",
        11: "vertical tab",
        13: "carriage return",
        27: "escape",
        8203: "zero width space",
        8204: "zero width non-joiner",
        8205: "zero width joiner",
        8206: "left-to-right mark",
        8207: "right-to-left mark",
        8232: "line separator",
        8237: "left-to-right override",
        8238: "right-to-left override",
        8294: "left-to-right isolate",
        8295: "right-to-left isolate",
        8297: "pop directional isolate",
        8233: "paragraph separator",
        65279: "zero width no-break space",
        65532: "object replacement"
    };
    let _supportsTabSize = null;
    const specialCharConfig = Facet.define({
        combine(configs) {
            var _a, styles, configs = combineConfig(configs, {
                render: null,
                specialChars: Specials,
                addSpecialChars: null
            });
            return (configs.replaceTabs = (null == _supportsTabSize && "undefined" != typeof document && document.body && (styles = document.body.style, 
            _supportsTabSize = null != (null != (_a = styles.tabSize) ? _a : styles.MozTabSize)), 
            !_supportsTabSize)) && (configs.specialChars = new RegExp("\t|" + configs.specialChars.source, UnicodeRegexpSupport)), 
            configs.addSpecialChars && (configs.specialChars = new RegExp(configs.specialChars.source + "|" + configs.addSpecialChars.source, UnicodeRegexpSupport)), 
            configs;
        }
    });
    let _plugin = null;
    class SpecialCharWidget extends WidgetType {
        constructor(options, code) {
            super(), this.options = options, this.code = code;
        }
        eq(other) {
            return other.code == this.code;
        }
        toDOM(view) {
            var code = 32 <= (code = this.code) ? "\u2022" : 10 == code ? "\u2424" : String.fromCharCode(9216 + code), view = view.state.phrase("Control character") + " " + (Names[this.code] || "0x" + this.code.toString(16)), custom = this.options.render && this.options.render(this.code, view, code);
            return custom || ((custom = document.createElement("span")).textContent = code, 
            custom.title = view, custom.setAttribute("aria-label", view), custom.className = "cm-specialChar", 
            custom);
        }
        ignoreEvent() {
            return !1;
        }
    }
    class TabWidget extends WidgetType {
        constructor(width) {
            super(), this.width = width;
        }
        eq(other) {
            return other.width == this.width;
        }
        toDOM() {
            var span = document.createElement("span");
            return span.textContent = "\t", span.className = "cm-tab", span.style.width = this.width + "px", 
            span;
        }
        ignoreEvent() {
            return !1;
        }
    }
    const lineDeco = Decoration.line({
        class: "cm-activeLine"
    }), activeLineHighlighter = ViewPlugin.fromClass(class {
        constructor(view) {
            this.decorations = this.getDeco(view);
        }
        update(update) {
            (update.docChanged || update.selectionSet) && (this.decorations = this.getDeco(update.view));
        }
        getDeco(view) {
            let lastLineStart = -1, deco = [];
            for (var r of view.state.selection.ranges) {
                r = view.lineBlockAt(r.head);
                r.from > lastLineStart && (deco.push(lineDeco.range(r.from)), lastLineStart = r.from);
            }
            return Decoration.set(deco);
        }
    }, {
        decorations: v => v.decorations
    }), MaxOff = 2e3;
    function getPos(view, event) {
        var offset = view.posAtCoords({
            x: event.clientX,
            y: event.clientY
        }, !1), line = view.state.doc.lineAt(offset), off = offset - line.from, event = off > MaxOff ? -1 : off == line.length ? function(view, x) {
            var ref = view.coordsAtPos(view.viewport.from);
            return ref ? Math.round(Math.abs((ref.left - x) / view.defaultCharacterWidth)) : -1;
        }(view, event.clientX) : countColumn(line.text, view.state.tabSize, offset - line.from);
        return {
            line: line.number,
            col: event,
            off: off
        };
    }
    function rectangleSelectionStyle(view, event) {
        let start = getPos(view, event), startSel = view.state.selection;
        return start ? {
            update(update) {
                var newStart;
                update.docChanged && (newStart = update.changes.mapPos(update.startState.doc.line(start.line).from), 
                newStart = update.state.doc.lineAt(newStart), start = {
                    line: newStart.number,
                    col: start.col,
                    off: Math.min(start.off, newStart.length)
                }, startSel = startSel.map(update.changes));
            },
            get(event, _extend, multiple) {
                var event = getPos(view, event);
                return event && (event = function(state, a, b) {
                    var startLine = Math.min(a.line, b.line), endLine = Math.max(a.line, b.line), ranges = [];
                    if (a.off > MaxOff || b.off > MaxOff || a.col < 0 || b.col < 0) {
                        var startOff = Math.min(a.off, b.off), endOff = Math.max(a.off, b.off);
                        for (let i = startLine; i <= endLine; i++) {
                            var line = state.doc.line(i);
                            line.length <= endOff && ranges.push(EditorSelection.range(line.from + startOff, line.to + endOff));
                        }
                    } else {
                        var startCol = Math.min(a.col, b.col), endCol = Math.max(a.col, b.col);
                        for (let i = startLine; i <= endLine; i++) {
                            let line = state.doc.line(i);
                            var end, start = findColumn(line.text, startCol, state.tabSize, !0);
                            start < 0 ? ranges.push(EditorSelection.cursor(line.to)) : (end = findColumn(line.text, endCol, state.tabSize), 
                            ranges.push(EditorSelection.range(line.from + start, line.from + end)));
                        }
                    }
                    return ranges;
                }(view.state, start, event)).length ? multiple ? EditorSelection.create(event.concat(startSel.ranges)) : EditorSelection.create(event) : startSel;
            }
        } : null;
    }
    const keys = {
        Alt: [ 18, e => !!e.altKey ],
        Control: [ 17, e => !!e.ctrlKey ],
        Shift: [ 16, e => !!e.shiftKey ],
        Meta: [ 91, e => !!e.metaKey ]
    }, showCrosshair = {
        style: "cursor: crosshair"
    };
    class TooltipViewManager {
        constructor(view, facet, createTooltipView, removeTooltipView) {
            this.facet = facet, this.createTooltipView = createTooltipView, this.removeTooltipView = removeTooltipView, 
            this.input = view.state.facet(facet), this.tooltips = this.input.filter(t => t);
            let prev = null;
            this.tooltipViews = this.tooltips.map(t => prev = createTooltipView(t, prev));
        }
        update(update, above) {
            var _a, input = update.state.facet(this.facet), tooltips = input.filter(x => x);
            if (input === this.input) {
                for (var t of this.tooltipViews) t.update && t.update(update);
                return !1;
            }
            var tooltipView, tooltipViews = [], newAbove = above ? [] : null;
            for (let i = 0; i < tooltips.length; i++) {
                let tip = tooltips[i], known = -1;
                if (tip) {
                    for (let i = 0; i < this.tooltips.length; i++) {
                        var other = this.tooltips[i];
                        other && other.create == tip.create && (known = i);
                    }
                    known < 0 ? (tooltipViews[i] = this.createTooltipView(tip, i ? tooltipViews[i - 1] : null), 
                    newAbove && (newAbove[i] = !!tip.above)) : (tooltipView = tooltipViews[i] = this.tooltipViews[known], 
                    newAbove && (newAbove[i] = above[known]), tooltipView.update && tooltipView.update(update));
                }
            }
            for (let t of this.tooltipViews) tooltipViews.indexOf(t) < 0 && (this.removeTooltipView(t), 
            null != (_a = t.destroy)) && _a.call(t);
            return above && (newAbove.forEach((val, i) => above[i] = val), above.length = newAbove.length), 
            this.input = input, this.tooltips = tooltips, this.tooltipViews = tooltipViews, 
            !0;
        }
    }
    function windowSpace(view) {
        view = view.win;
        return {
            top: 0,
            left: 0,
            bottom: view.innerHeight,
            right: view.innerWidth
        };
    }
    const tooltipConfig = Facet.define({
        combine: values => {
            var _a;
            return {
                position: browser.ios ? "absolute" : (null == (_a = values.find(conf => conf.position)) ? void 0 : _a.position) || "fixed",
                parent: (null == (_a = values.find(conf => conf.parent)) ? void 0 : _a.parent) || null,
                tooltipSpace: (null == (_a = values.find(conf => conf.tooltipSpace)) ? void 0 : _a.tooltipSpace) || windowSpace
            };
        }
    }), knownHeight = new WeakMap(), tooltipPlugin = ViewPlugin.fromClass(class {
        constructor(view) {
            this.view = view, this.above = [], this.inView = !0, this.madeAbsolute = !1, 
            this.lastTransaction = 0, this.measureTimeout = -1;
            var config = view.state.facet(tooltipConfig);
            this.position = config.position, this.parent = config.parent, this.classes = view.themeClasses, 
            this.createContainer(), this.measureReq = {
                read: this.readMeasure.bind(this),
                write: this.writeMeasure.bind(this),
                key: this
            }, this.resizeObserver = "function" == typeof ResizeObserver ? new ResizeObserver(() => this.measureSoon()) : null, 
            this.manager = new TooltipViewManager(view, showTooltip, (t, p) => this.createTooltip(t, p), t => {
                this.resizeObserver && this.resizeObserver.unobserve(t.dom), t.dom.remove();
            }), this.above = this.manager.tooltips.map(t => !!t.above), this.intersectionObserver = "function" == typeof IntersectionObserver ? new IntersectionObserver(entries => {
                Date.now() > this.lastTransaction - 50 && 0 < entries.length && entries[entries.length - 1].intersectionRatio < 1 && this.measureSoon();
            }, {
                threshold: [ 1 ]
            }) : null, this.observeIntersection(), view.win.addEventListener("resize", this.measureSoon = this.measureSoon.bind(this)), 
            this.maybeMeasure();
        }
        createContainer() {
            this.parent ? (this.container = document.createElement("div"), this.container.style.position = "relative", 
            this.container.className = this.view.themeClasses, this.parent.appendChild(this.container)) : this.container = this.view.dom;
        }
        observeIntersection() {
            if (this.intersectionObserver) {
                this.intersectionObserver.disconnect();
                for (var tooltip of this.manager.tooltipViews) this.intersectionObserver.observe(tooltip.dom);
            }
        }
        measureSoon() {
            this.measureTimeout < 0 && (this.measureTimeout = setTimeout(() => {
                this.measureTimeout = -1, this.maybeMeasure();
            }, 50));
        }
        update(update) {
            update.transactions.length && (this.lastTransaction = Date.now());
            var updated = this.manager.update(update, this.above);
            updated && this.observeIntersection();
            let shouldMeasure = updated || update.geometryChanged;
            updated = update.state.facet(tooltipConfig);
            if (updated.position != this.position && !this.madeAbsolute) {
                this.position = updated.position;
                for (var t of this.manager.tooltipViews) t.dom.style.position = this.position;
                shouldMeasure = !0;
            }
            if (updated.parent != this.parent) {
                this.parent && this.container.remove(), this.parent = updated.parent, 
                this.createContainer();
                for (let t of this.manager.tooltipViews) this.container.appendChild(t.dom);
                shouldMeasure = !0;
            } else this.parent && this.view.themeClasses != this.classes && (this.classes = this.container.className = this.view.themeClasses);
            shouldMeasure && this.maybeMeasure();
        }
        createTooltip(tooltip, prev) {
            var tooltipView = tooltip.create(this.view), prev = prev ? prev.dom : null;
            return tooltipView.dom.classList.add("cm-tooltip"), tooltip.arrow && !tooltipView.dom.querySelector(".cm-tooltip > .cm-tooltip-arrow") && ((tooltip = document.createElement("div")).className = "cm-tooltip-arrow", 
            tooltipView.dom.appendChild(tooltip)), tooltipView.dom.style.position = this.position, 
            tooltipView.dom.style.top = "-10000px", tooltipView.dom.style.left = "0px", 
            this.container.insertBefore(tooltipView.dom, prev), tooltipView.mount && tooltipView.mount(this.view), 
            this.resizeObserver && this.resizeObserver.observe(tooltipView.dom), 
            tooltipView;
        }
        destroy() {
            var _a, _b, tooltipView;
            this.view.win.removeEventListener("resize", this.measureSoon);
            for (tooltipView of this.manager.tooltipViews) tooltipView.dom.remove(), 
            null != (_a = tooltipView.destroy) && _a.call(tooltipView);
            this.parent && this.container.remove(), null != (_b = this.resizeObserver) && _b.disconnect(), 
            null != (_b = this.intersectionObserver) && _b.disconnect(), clearTimeout(this.measureTimeout);
        }
        readMeasure() {
            var dom, editor = this.view.dom.getBoundingClientRect();
            let scaleX = 1, scaleY = 1, makeAbsolute = !1;
            if ("fixed" == this.position && this.manager.tooltipViews.length && (dom = this.manager.tooltipViews[0]["dom"], 
            browser.gecko ? makeAbsolute = dom.offsetParent != this.container.ownerDocument.body : "-10000px" == dom.style.top && "0px" == dom.style.left && (dom = dom.getBoundingClientRect(), 
            makeAbsolute = 1 < Math.abs(dom.top + 1e4) || 1 < Math.abs(dom.left))), 
            makeAbsolute || "absolute" == this.position) if (this.parent) {
                let rect = this.parent.getBoundingClientRect();
                rect.width && rect.height && (scaleX = rect.width / this.parent.offsetWidth, 
                scaleY = rect.height / this.parent.offsetHeight);
            } else ({
                scaleX,
                scaleY
            } = this.view.viewState);
            return {
                editor: editor,
                parent: this.parent ? this.container.getBoundingClientRect() : editor,
                pos: this.manager.tooltips.map((t, i) => {
                    i = this.manager.tooltipViews[i];
                    return i.getCoords ? i.getCoords(t.pos) : this.view.coordsAtPos(t.pos);
                }),
                size: this.manager.tooltipViews.map(({
                    dom
                }) => dom.getBoundingClientRect()),
                space: this.view.state.facet(tooltipConfig).tooltipSpace(this.view),
                scaleX: scaleX,
                scaleY: scaleY,
                makeAbsolute: makeAbsolute
            };
        }
        writeMeasure(measured) {
            if (measured.makeAbsolute) {
                this.madeAbsolute = !0, this.position = "absolute";
                for (var t of this.manager.tooltipViews) t.dom.style.position = "absolute";
            }
            var {
                editor,
                space,
                scaleX,
                scaleY
            } = measured, others = [];
            for (let i = 0; i < this.manager.tooltips.length; i++) {
                var tooltip = this.manager.tooltips[i], tView = this.manager.tooltipViews[i], dom = tView["dom"], pos = measured.pos[i], size = measured.size[i];
                if (!pos || pos.bottom <= Math.max(editor.top, space.top) || pos.top >= Math.min(editor.bottom, space.bottom) || pos.right < Math.max(editor.left, space.left) - .1 || pos.left > Math.min(editor.right, space.right) + .1) dom.style.top = "-10000px"; else {
                    var arrow = tooltip.arrow ? tView.dom.querySelector(".cm-tooltip-arrow") : null, arrowHeight = arrow ? 7 : 0;
                    let width = size.right - size.left, height = null != (_a = knownHeight.get(tView)) ? _a : size.bottom - size.top;
                    var _a = tView.offset || noOffset, ltr = this.view.textDirection == Direction.LTR, left = size.width > space.right - space.left ? ltr ? space.left : space.right - size.width : ltr ? Math.min(pos.left - (arrow ? 14 : 0) + _a.x, space.right - width) : Math.max(space.left, pos.left - width + (arrow ? 14 : 0) - _a.x);
                    let above = this.above[i];
                    tooltip = ((above = !tooltip.strictSide && (above ? pos.top - (size.bottom - size.top) - _a.y < space.top : pos.bottom + (size.bottom - size.top) + _a.y > space.bottom) && above == space.bottom - pos.bottom > pos.top - space.top ? this.above[i] = !above : above) ? pos.top - space.top : space.bottom - pos.bottom) - arrowHeight;
                    if (tooltip < height && !1 !== tView.resize) {
                        if (tooltip < this.view.defaultLineHeight) {
                            dom.style.top = "-10000px";
                            continue;
                        }
                        knownHeight.set(tView, height), dom.style.height = (height = tooltip) / scaleY + "px";
                    } else dom.style.height && (dom.style.height = "");
                    let top = above ? pos.top - height - arrowHeight - _a.y : pos.bottom + arrowHeight + _a.y;
                    var right = left + width;
                    if (!0 !== tView.overlap) for (var r of others) r.left < right && r.right > left && r.top < top + height && r.bottom > top && (top = above ? r.top - height - 2 - arrowHeight : r.bottom + arrowHeight + 2);
                    "absolute" == this.position ? (dom.style.top = (top - measured.parent.top) / scaleY + "px", 
                    dom.style.left = (left - measured.parent.left) / scaleX + "px") : (dom.style.top = top / scaleY + "px", 
                    dom.style.left = left / scaleX + "px"), arrow && (size = pos.left + (ltr ? _a.x : -_a.x) - (left + 14 - 7), 
                    arrow.style.left = size / scaleX + "px"), !0 !== tView.overlap && others.push({
                        left: left,
                        top: top,
                        right: right,
                        bottom: top + height
                    }), dom.classList.toggle("cm-tooltip-above", above), dom.classList.toggle("cm-tooltip-below", !above), 
                    tView.positioned && tView.positioned(measured.space);
                }
            }
        }
        maybeMeasure() {
            if (this.manager.tooltips.length && (this.view.inView && this.view.requestMeasure(this.measureReq), 
            this.inView != this.view.inView) && (this.inView = this.view.inView, 
            !this.inView)) for (var tv of this.manager.tooltipViews) tv.dom.style.top = "-10000px";
        }
    }, {
        eventObservers: {
            scroll() {
                this.maybeMeasure();
            }
        }
    });
    var IterMode, ie_11up = EditorView.baseTheme({
        ".cm-tooltip": {
            zIndex: 100,
            boxSizing: "border-box"
        },
        "&light .cm-tooltip": {
            border: "1px solid #bbb",
            backgroundColor: "#f5f5f5"
        },
        "&light .cm-tooltip-section:not(:first-child)": {
            borderTop: "1px solid #bbb"
        },
        "&dark .cm-tooltip": {
            backgroundColor: "#333338",
            color: "white"
        },
        ".cm-tooltip-arrow": {
            height: "7px",
            width: "14px",
            position: "absolute",
            zIndex: -1,
            overflow: "hidden",
            "&:before, &:after": {
                content: "''",
                position: "absolute",
                width: 0,
                height: 0,
                borderLeft: "7px solid transparent",
                borderRight: "7px solid transparent"
            },
            ".cm-tooltip-above &": {
                bottom: "-7px",
                "&:before": {
                    borderTop: "7px solid #bbb"
                },
                "&:after": {
                    borderTop: "7px solid #f5f5f5",
                    bottom: "1px"
                }
            },
            ".cm-tooltip-below &": {
                top: "-7px",
                "&:before": {
                    borderBottom: "7px solid #bbb"
                },
                "&:after": {
                    borderBottom: "7px solid #f5f5f5",
                    top: "1px"
                }
            }
        },
        "&dark .cm-tooltip .cm-tooltip-arrow": {
            "&:before": {
                borderTopColor: "#333338",
                borderBottomColor: "#333338"
            },
            "&:after": {
                borderTopColor: "transparent",
                borderBottomColor: "transparent"
            }
        }
    });
    const noOffset = {
        x: 0,
        y: 0
    }, showTooltip = Facet.define({
        enables: [ tooltipPlugin, ie_11up ]
    });
    const panelConfig = Facet.define({
        combine(configs) {
            let topContainer, bottomContainer;
            for (var c of configs) topContainer = topContainer || c.topContainer, 
            bottomContainer = bottomContainer || c.bottomContainer;
            return {
                topContainer: topContainer,
                bottomContainer: bottomContainer
            };
        }
    });
    function getPanel(view, panel) {
        view = view.plugin(panelPlugin), panel = view ? view.specs.indexOf(panel) : -1;
        return -1 < panel ? view.panels[panel] : null;
    }
    const panelPlugin = ViewPlugin.fromClass(class {
        constructor(view) {
            this.input = view.state.facet(showPanel), this.specs = this.input.filter(s => s), 
            this.panels = this.specs.map(spec => spec(view));
            var p, conf = view.state.facet(panelConfig);
            this.top = new PanelGroup(view, !0, conf.topContainer), this.bottom = new PanelGroup(view, !1, conf.bottomContainer), 
            this.top.sync(this.panels.filter(p => p.top)), this.bottom.sync(this.panels.filter(p => !p.top));
            for (p of this.panels) p.dom.classList.add("cm-panel"), p.mount && p.mount();
        }
        update(update) {
            var conf = update.state.facet(panelConfig), conf = (this.top.container != conf.topContainer && (this.top.sync([]), 
            this.top = new PanelGroup(update.view, !0, conf.topContainer)), this.bottom.container != conf.bottomContainer && (this.bottom.sync([]), 
            this.bottom = new PanelGroup(update.view, !1, conf.bottomContainer)), 
            this.top.syncClasses(), this.bottom.syncClasses(), update.state.facet(showPanel));
            if (conf != this.input) {
                var spec, p, conf = conf.filter(x => x), panels = [], top = [], bottom = [], mount = [];
                for (spec of conf) {
                    let known = this.specs.indexOf(spec), panel;
                    known < 0 ? (panel = spec(update.view), mount.push(panel)) : (panel = this.panels[known]).update && panel.update(update), 
                    panels.push(panel), (panel.top ? top : bottom).push(panel);
                }
                this.specs = conf, this.panels = panels, this.top.sync(top), this.bottom.sync(bottom);
                for (p of mount) p.dom.classList.add("cm-panel"), p.mount && p.mount();
            } else for (let p of this.panels) p.update && p.update(update);
        }
        destroy() {
            this.top.sync([]), this.bottom.sync([]);
        }
    }, {
        provide: plugin => EditorView.scrollMargins.of(view => {
            view = view.plugin(plugin);
            return view && {
                top: view.top.scrollMargin(),
                bottom: view.bottom.scrollMargin()
            };
        })
    });
    class PanelGroup {
        constructor(view, top, container) {
            this.view = view, this.top = top, this.container = container, this.dom = void 0, 
            this.classes = "", this.panels = [], this.syncClasses();
        }
        sync(panels) {
            for (var p of this.panels) p.destroy && panels.indexOf(p) < 0 && p.destroy();
            this.panels = panels, this.syncDOM();
        }
        syncDOM() {
            if (0 == this.panels.length) this.dom && (this.dom.remove(), this.dom = void 0); else {
                var parent, panel;
                this.dom || (this.dom = document.createElement("div"), this.dom.className = this.top ? "cm-panels cm-panels-top" : "cm-panels cm-panels-bottom", 
                this.dom.style[this.top ? "top" : "bottom"] = "0", (parent = this.container || this.view.dom).insertBefore(this.dom, this.top ? parent.firstChild : null));
                let curDOM = this.dom.firstChild;
                for (panel of this.panels) if (panel.dom.parentNode == this.dom) {
                    for (;curDOM != panel.dom; ) curDOM = rm(curDOM);
                    curDOM = curDOM.nextSibling;
                } else this.dom.insertBefore(panel.dom, curDOM);
                for (;curDOM; ) curDOM = rm(curDOM);
            }
        }
        scrollMargin() {
            return !this.dom || this.container ? 0 : Math.max(0, this.top ? this.dom.getBoundingClientRect().bottom - Math.max(0, this.view.scrollDOM.getBoundingClientRect().top) : Math.min(innerHeight, this.view.scrollDOM.getBoundingClientRect().bottom) - this.dom.getBoundingClientRect().top);
        }
        syncClasses() {
            if (this.container && this.classes != this.view.themeClasses) {
                for (var cls of this.classes.split(" ")) cls && this.container.classList.remove(cls);
                for (let cls of (this.classes = this.view.themeClasses).split(" ")) cls && this.container.classList.add(cls);
            }
        }
    }
    function rm(node) {
        var next = node.nextSibling;
        return node.remove(), next;
    }
    const showPanel = Facet.define({
        enables: panelPlugin
    });
    class GutterMarker extends RangeValue {
        compare(other) {
            return this == other || this.constructor == other.constructor && this.eq(other);
        }
        eq(other) {
            return !1;
        }
        destroy(dom) {}
    }
    GutterMarker.prototype.elementClass = "", GutterMarker.prototype.toDOM = void 0, 
    GutterMarker.prototype.mapMode = MapMode.TrackBefore, GutterMarker.prototype.startSide = GutterMarker.prototype.endSide = -1;
    const gutterLineClass = Facet.define(), defaults$1 = {
        class: "",
        renderEmptyElements: !(GutterMarker.prototype.point = !0),
        elementStyle: "",
        markers: () => RangeSet.empty,
        lineMarker: () => null,
        widgetMarker: () => null,
        lineMarkerChange: null,
        initialSpacer: null,
        updateSpacer: null,
        domEventHandlers: {}
    }, activeGutters = Facet.define();
    const unfixGutters = Facet.define({
        combine: values => values.some(x => x)
    });
    function gutters() {
        return [ gutterView ];
    }
    const gutterView = ViewPlugin.fromClass(class {
        constructor(view) {
            this.view = view, this.prevViewport = view.viewport, this.dom = document.createElement("div"), 
            this.dom.className = "cm-gutters", this.dom.setAttribute("aria-hidden", "true"), 
            this.dom.style.minHeight = this.view.contentHeight / this.view.scaleY + "px", 
            this.gutters = view.state.facet(activeGutters).map(conf => new SingleGutterView(view, conf));
            for (var gutter of this.gutters) this.dom.appendChild(gutter.dom);
            this.fixed = !view.state.facet(unfixGutters), this.fixed && (this.dom.style.position = "sticky"), 
            this.syncGutters(!1), view.scrollDOM.insertBefore(this.dom, view.contentDOM);
        }
        update(update) {
            var vpB, vpA;
            this.updateGutters(update) && (vpA = this.prevViewport, vpB = update.view.viewport, 
            vpA = Math.min(vpA.to, vpB.to) - Math.max(vpA.from, vpB.from), this.syncGutters(vpA < .8 * (vpB.to - vpB.from))), 
            update.geometryChanged && (this.dom.style.minHeight = this.view.contentHeight / this.view.scaleY + "px"), 
            this.view.state.facet(unfixGutters) != !this.fixed && (this.fixed = !this.fixed, 
            this.dom.style.position = this.fixed ? "sticky" : ""), this.prevViewport = update.view.viewport;
        }
        syncGutters(detach) {
            var after = this.dom.nextSibling, lineClasses = (detach && this.dom.remove(), 
            RangeSet.iter(this.view.state.facet(gutterLineClass), this.view.viewport.from));
            let classSet = [];
            var line, contexts = this.gutters.map(gutter => new UpdateContext(gutter, this.view.viewport, -this.view.documentPadding.top));
            for (line of this.view.viewportLineBlocks) if (classSet.length && (classSet = []), 
            Array.isArray(line.type)) {
                let first = !0;
                for (var b of line.type) if (b.type == BlockType.Text && first) {
                    advanceCursor(lineClasses, classSet, b.from);
                    for (var cx of contexts) cx.line(this.view, b, classSet);
                    first = !1;
                } else if (b.widget) for (let cx of contexts) cx.widget(this.view, b);
            } else if (line.type == BlockType.Text) {
                advanceCursor(lineClasses, classSet, line.from);
                for (let cx of contexts) cx.line(this.view, line, classSet);
            } else if (line.widget) for (let cx of contexts) cx.widget(this.view, line);
            for (let cx of contexts) cx.finish();
            detach && this.view.scrollDOM.insertBefore(this.dom, after);
        }
        updateGutters(update) {
            var prev = update.startState.facet(activeGutters), cur = update.state.facet(activeGutters);
            let change = update.docChanged || update.heightChanged || update.viewportChanged || !RangeSet.eq(update.startState.facet(gutterLineClass), update.state.facet(gutterLineClass), update.view.viewport.from, update.view.viewport.to);
            if (prev == cur) for (var gutter of this.gutters) gutter.update(update) && (change = !0); else {
                change = !0;
                var conf, g, gutters = [];
                for (conf of cur) {
                    var known = prev.indexOf(conf);
                    known < 0 ? gutters.push(new SingleGutterView(this.view, conf)) : (this.gutters[known].update(update), 
                    gutters.push(this.gutters[known]));
                }
                for (g of this.gutters) g.dom.remove(), gutters.indexOf(g) < 0 && g.destroy();
                for (let g of gutters) this.dom.appendChild(g.dom);
                this.gutters = gutters;
            }
            return change;
        }
        destroy() {
            for (var view of this.gutters) view.destroy();
            this.dom.remove();
        }
    }, {
        provide: plugin => EditorView.scrollMargins.of(view => {
            var value = view.plugin(plugin);
            return value && 0 != value.gutters.length && value.fixed ? view.textDirection == Direction.LTR ? {
                left: value.dom.offsetWidth * view.scaleX
            } : {
                right: value.dom.offsetWidth * view.scaleX
            } : null;
        })
    });
    function asArray(val) {
        return Array.isArray(val) ? val : [ val ];
    }
    function advanceCursor(cursor, collect, pos) {
        for (;cursor.value && cursor.from <= pos; ) cursor.from == pos && collect.push(cursor.value), 
        cursor.next();
    }
    class UpdateContext {
        constructor(gutter, viewport, height) {
            this.gutter = gutter, this.height = height, this.i = 0, this.cursor = RangeSet.iter(gutter.markers, viewport.from);
        }
        addElement(view, block, markers) {
            var newElt, gutter = this["gutter"], above = (block.top - this.height) / view.scaleY, height = block.height / view.scaleY;
            this.i == gutter.elements.length ? (newElt = new GutterElement(view, height, above, markers), 
            gutter.elements.push(newElt), gutter.dom.appendChild(newElt.dom)) : gutter.elements[this.i].update(view, height, above, markers), 
            this.height = block.bottom, this.i++;
        }
        line(view, line, extraMarkers) {
            let localMarkers = [];
            advanceCursor(this.cursor, localMarkers, line.from), extraMarkers.length && (localMarkers = localMarkers.concat(extraMarkers));
            extraMarkers = this.gutter.config.lineMarker(view, line, localMarkers), 
            extraMarkers && localMarkers.unshift(extraMarkers), extraMarkers = this.gutter;
            0 == localMarkers.length && !extraMarkers.config.renderEmptyElements || this.addElement(view, line, localMarkers);
        }
        widget(view, block) {
            var marker = this.gutter.config.widgetMarker(view, block.widget, block);
            marker && this.addElement(view, block, [ marker ]);
        }
        finish() {
            for (var gutter = this.gutter; gutter.elements.length > this.i; ) {
                var last = gutter.elements.pop();
                gutter.dom.removeChild(last.dom), last.destroy();
            }
        }
    }
    class SingleGutterView {
        constructor(view, config) {
            this.view = view, this.config = config, this.elements = [], this.spacer = null, 
            this.dom = document.createElement("div"), this.dom.className = "cm-gutter" + (this.config.class ? " " + this.config.class : "");
            for (let prop in config.domEventHandlers) this.dom.addEventListener(prop, event => {
                let target = event.target, y;
                if (target != this.dom && this.dom.contains(target)) {
                    for (;target.parentNode != this.dom; ) target = target.parentNode;
                    var rect = target.getBoundingClientRect();
                    y = (rect.top + rect.bottom) / 2;
                } else y = event.clientY;
                rect = view.lineBlockAtHeight(y - view.documentTop);
                config.domEventHandlers[prop](view, rect, event) && event.preventDefault();
            });
            this.markers = asArray(config.markers(view)), config.initialSpacer && (this.spacer = new GutterElement(view, 0, 0, [ config.initialSpacer(view) ]), 
            this.dom.appendChild(this.spacer.dom), this.spacer.dom.style.cssText += "visibility: hidden; pointer-events: none");
        }
        update(update) {
            var prevMarkers = this.markers, updated = (this.markers = asArray(this.config.markers(update.view)), 
            this.spacer && this.config.updateSpacer && (updated = this.config.updateSpacer(this.spacer.markers[0], update)) != this.spacer.markers[0] && this.spacer.update(update.view, 0, 0, [ updated ]), 
            update.view.viewport);
            return !RangeSet.eq(this.markers, prevMarkers, updated.from, updated.to) || !!this.config.lineMarkerChange && this.config.lineMarkerChange(update);
        }
        destroy() {
            for (var elt of this.elements) elt.destroy();
        }
    }
    class GutterElement {
        constructor(view, height, above, markers) {
            this.height = -1, this.above = 0, this.markers = [], this.dom = document.createElement("div"), 
            this.dom.className = "cm-gutterElement", this.update(view, height, above, markers);
        }
        update(view, height, above, markers) {
            this.height != height && (this.height = height, this.dom.style.height = height + "px"), 
            this.above != above && (this.dom.style.marginTop = (this.above = above) ? above + "px" : ""), 
            function(a, b) {
                if (a.length != b.length) return;
                for (let i = 0; i < a.length; i++) if (!a[i].compare(b[i])) return;
                return 1;
            }(this.markers, markers) || this.setMarkers(view, markers);
        }
        setMarkers(view, markers) {
            let cls = "cm-gutterElement", domPos = this.dom.firstChild;
            for (let iNew = 0, iOld = 0; ;) {
                let skipTo = iOld, marker = iNew < markers.length ? markers[iNew++] : null, matched = !1;
                if (marker) {
                    var c = marker.elementClass;
                    c && (cls += " " + c);
                    for (let i = iOld; i < this.markers.length; i++) if (this.markers[i].compare(marker)) {
                        skipTo = i, matched = !0;
                        break;
                    }
                } else skipTo = this.markers.length;
                for (;iOld < skipTo; ) {
                    var next = this.markers[iOld++];
                    next.toDOM && (next.destroy(domPos), next = domPos.nextSibling, 
                    domPos.remove(), domPos = next);
                }
                if (!marker) break;
                marker.toDOM && (matched ? domPos = domPos.nextSibling : this.dom.insertBefore(marker.toDOM(view), domPos)), 
                matched && iOld++;
            }
            this.dom.className = cls, this.markers = markers;
        }
        destroy() {
            this.setMarkers(null, []);
        }
    }
    const lineNumberMarkers = Facet.define(), lineNumberConfig = Facet.define({
        combine(values) {
            return combineConfig(values, {
                formatNumber: String,
                domEventHandlers: {}
            }, {
                domEventHandlers(a, b) {
                    var event, result = Object.assign({}, a);
                    for (event in b) {
                        let exists = result[event], add = b[event];
                        result[event] = exists ? (view, line, event) => exists(view, line, event) || add(view, line, event) : add;
                    }
                    return result;
                }
            });
        }
    });
    class NumberMarker extends GutterMarker {
        constructor(number) {
            super(), this.number = number;
        }
        eq(other) {
            return this.number == other.number;
        }
        toDOM() {
            return document.createTextNode(this.number);
        }
    }
    function formatNumber(view, number) {
        return view.state.facet(lineNumberConfig).formatNumber(number, view.state);
    }
    const lineNumberGutter = activeGutters.compute([ lineNumberConfig ], state => ({
        class: "cm-lineNumbers",
        renderEmptyElements: !1,
        markers(view) {
            return view.state.facet(lineNumberMarkers);
        },
        lineMarker(view, line, others) {
            return others.some(m => m.toDOM) ? null : new NumberMarker(formatNumber(view, view.state.doc.lineAt(line.from).number));
        },
        widgetMarker: () => null,
        lineMarkerChange: update => update.startState.facet(lineNumberConfig) != update.state.facet(lineNumberConfig),
        initialSpacer(view) {
            return new NumberMarker(formatNumber(view, maxLineNumber(view.state.doc.lines)));
        },
        updateSpacer(spacer, update) {
            update = formatNumber(update.view, maxLineNumber(update.view.state.doc.lines));
            return update == spacer.number ? spacer : new NumberMarker(update);
        },
        domEventHandlers: state.facet(lineNumberConfig).domEventHandlers
    }));
    function maxLineNumber(lines) {
        let last = 9;
        for (;last < lines; ) last = 10 * last + 9;
        return last;
    }
    const activeLineGutterMarker = new class extends GutterMarker {
        constructor() {
            super(...arguments), this.elementClass = "cm-activeLineGutter";
        }
    }(), activeLineGutterHighlighter = gutterLineClass.compute([ "selection" ], state => {
        let marks = [], last = -1;
        for (var range of state.selection.ranges) {
            range = state.doc.lineAt(range.head).from;
            range > last && (last = range, marks.push(activeLineGutterMarker.range(range)));
        }
        return RangeSet.of(marks);
    });
    let nextPropID = 0;
    class Range {
        constructor(from, to) {
            this.from = from, this.to = to;
        }
    }
    class NodeProp {
        constructor(config = {}) {
            this.id = nextPropID++, this.perNode = !!config.perNode, this.deserialize = config.deserialize || (() => {
                throw new Error("This node type doesn't define a deserialize function");
            });
        }
        add(match) {
            if (this.perNode) throw new RangeError("Can't add per-node props to node types");
            return "function" != typeof match && (match = NodeType.match(match)), 
            type => {
                type = match(type);
                return void 0 === type ? null : [ this, type ];
            };
        }
    }
    NodeProp.closedBy = new NodeProp({
        deserialize: str => str.split(" ")
    }), NodeProp.openedBy = new NodeProp({
        deserialize: str => str.split(" ")
    }), NodeProp.group = new NodeProp({
        deserialize: str => str.split(" ")
    }), NodeProp.isolate = new NodeProp({
        deserialize: value => {
            if (value && "rtl" != value && "ltr" != value && "auto" != value) throw new RangeError("Invalid value for isolate: " + value);
            return value || "auto";
        }
    }), NodeProp.contextHash = new NodeProp({
        perNode: !0
    }), NodeProp.lookAhead = new NodeProp({
        perNode: !0
    }), NodeProp.mounted = new NodeProp({
        perNode: !0
    });
    class MountedTree {
        constructor(tree, overlay, parser) {
            this.tree = tree, this.overlay = overlay, this.parser = parser;
        }
        static get(tree) {
            return tree && tree.props && tree.props[NodeProp.mounted.id];
        }
    }
    const noProps = Object.create(null);
    class NodeType {
        constructor(name, props, id, flags = 0) {
            this.name = name, this.props = props, this.id = id, this.flags = flags;
        }
        static define(spec) {
            var props = spec.props && spec.props.length ? Object.create(null) : noProps, flags = (spec.top ? 1 : 0) | (spec.skipped ? 2 : 0) | (spec.error ? 4 : 0) | (null == spec.name ? 8 : 0), type = new NodeType(spec.name || "", props, spec.id, flags);
            if (spec.props) for (var src of spec.props) if (src = Array.isArray(src) ? src : src(type)) {
                if (src[0].perNode) throw new RangeError("Can't store a per-node prop on a node type");
                props[src[0].id] = src[1];
            }
            return type;
        }
        prop(prop) {
            return this.props[prop.id];
        }
        get isTop() {
            return 0 < (1 & this.flags);
        }
        get isSkipped() {
            return 0 < (2 & this.flags);
        }
        get isError() {
            return 0 < (4 & this.flags);
        }
        get isAnonymous() {
            return 0 < (8 & this.flags);
        }
        is(name) {
            var group;
            return "string" == typeof name ? this.name == name || !!(group = this.prop(NodeProp.group)) && -1 < group.indexOf(name) : this.id == name;
        }
        static match(map) {
            let direct = Object.create(null);
            for (var prop in map) for (var name of prop.split(" ")) direct[name] = map[prop];
            return node => {
                for (let groups = node.prop(NodeProp.group), i = -1; i < (groups ? groups.length : 0); i++) {
                    var found = direct[i < 0 ? node.name : groups[i]];
                    if (found) return found;
                }
            };
        }
    }
    NodeType.none = new NodeType("", Object.create(null), 0, 8);
    class NodeSet {
        constructor(types) {
            this.types = types;
            for (let i = 0; i < types.length; i++) if (types[i].id != i) throw new RangeError("Node type ids should correspond to array positions when creating a node set");
        }
        extend(...props) {
            var type, newTypes = [];
            for (type of this.types) {
                let newProps = null;
                for (var source of props) {
                    source = source(type);
                    source && ((newProps = newProps || Object.assign({}, type.props))[source[0].id] = source[1]);
                }
                newTypes.push(newProps ? new NodeType(type.name, newProps, type.id, type.flags) : type);
            }
            return new NodeSet(newTypes);
        }
    }
    const CachedNode = new WeakMap(), CachedInnerNode = new WeakMap();
    !function(IterMode) {
        IterMode[IterMode.ExcludeBuffers = 1] = "ExcludeBuffers", IterMode[IterMode.IncludeAnonymous = 2] = "IncludeAnonymous", 
        IterMode[IterMode.IgnoreMounts = 4] = "IgnoreMounts", IterMode[IterMode.IgnoreOverlays = 8] = "IgnoreOverlays";
    }(IterMode = IterMode || {});
    class Tree {
        constructor(type, children, positions, length, props) {
            if (this.type = type, this.children = children, this.positions = positions, 
            this.length = length, this.props = null, props && props.length) {
                this.props = Object.create(null);
                for (var [ prop, value ] of props) this.props["number" == typeof prop ? prop : prop.id] = value;
            }
        }
        toString() {
            var ch, mounted = MountedTree.get(this);
            if (mounted && !mounted.overlay) return mounted.tree.toString();
            let children = "";
            for (ch of this.children) {
                var str = ch.toString();
                str && (children && (children += ","), children += str);
            }
            return this.type.name ? (/\W/.test(this.type.name) && !this.type.isError ? JSON.stringify(this.type.name) : this.type.name) + (children.length ? "(" + children + ")" : "") : children;
        }
        cursor(mode = 0) {
            return new TreeCursor(this.topNode, mode);
        }
        cursorAt(pos, side = 0, mode) {
            var scope = CachedNode.get(this) || this.topNode, scope = new TreeCursor(scope);
            return scope.moveTo(pos, side), CachedNode.set(this, scope._tree), scope;
        }
        get topNode() {
            return new TreeNode(this, 0, 0, null);
        }
        resolve(pos, side = 0) {
            pos = resolveNode(CachedNode.get(this) || this.topNode, pos, side, !1);
            return CachedNode.set(this, pos), pos;
        }
        resolveInner(pos, side = 0) {
            pos = resolveNode(CachedInnerNode.get(this) || this.topNode, pos, side, !0);
            return CachedInnerNode.set(this, pos), pos;
        }
        resolveStack(pos, side = 0) {
            return function(tree, pos, side) {
                let inner = tree.resolveInner(pos, side), layers = null;
                for (let scan = inner instanceof TreeNode ? inner : inner.context.parent; scan; scan = scan.parent) {
                    var parent, root;
                    scan.index < 0 ? (parent = scan.parent, (layers = layers || [ inner ]).push(parent.resolve(pos, side)), 
                    scan = parent) : (parent = MountedTree.get(scan.tree)) && parent.overlay && parent.overlay[0].from <= pos && parent.overlay[parent.overlay.length - 1].to >= pos && (root = new TreeNode(parent.tree, parent.overlay[0].from + scan.from, -1, scan), 
                    (layers = layers || [ inner ]).push(resolveNode(root, pos, side, !1)));
                }
                return layers ? iterStack(layers) : inner;
            }(this, pos, side);
        }
        iterate(spec) {
            for (var {
                enter,
                leave,
                from = 0,
                to = this.length
            } = spec, spec = spec.mode || 0, anon = 0 < (spec & IterMode.IncludeAnonymous), c = this.cursor(spec | IterMode.IncludeAnonymous); ;) {
                let entered = !1;
                if (c.from <= to && c.to >= from && (!anon && c.type.isAnonymous || !1 !== enter(c))) {
                    if (c.firstChild()) continue;
                    entered = !0;
                }
                for (;entered && leave && (anon || !c.type.isAnonymous) && leave(c), 
                !c.nextSibling(); ) {
                    if (!c.parent()) return;
                    entered = !0;
                }
            }
        }
        prop(prop) {
            return prop.perNode ? this.props ? this.props[prop.id] : void 0 : this.type.prop(prop);
        }
        get propValues() {
            var result = [];
            if (this.props) for (var id in this.props) result.push([ +id, this.props[id] ]);
            return result;
        }
        balance(config = {}) {
            return this.children.length <= 8 ? this : balanceRange(NodeType.none, this.children, this.positions, 0, this.children.length, 0, this.length, (children, positions, length) => new Tree(this.type, children, positions, length, this.propValues), config.makeTree || ((children, positions, length) => new Tree(NodeType.none, children, positions, length)));
        }
        static build(data) {
            let {
                buffer,
                nodeSet,
                maxBufferLength = 1024,
                reused = [],
                minRepeatType = nodeSet.types.length
            } = data, cursor = Array.isArray(buffer) ? new FlatBufferCursor(buffer, buffer.length) : buffer, types = nodeSet.types, contextHash = 0, lookAhead = 0;
            function takeNode(parentStart, minPos, children, positions, inRepeat, depth) {
                for (var {
                    id,
                    start,
                    end,
                    size
                } = cursor, lookAheadAtStart = lookAhead; size < 0; ) {
                    if (cursor.next(), -1 == size) {
                        let node = reused[id];
                        return children.push(node), void positions.push(start - parentStart);
                    }
                    if (-3 == size) return void (contextHash = id);
                    if (-4 == size) return void (lookAhead = id);
                    throw new RangeError("Unrecognized record size: " + size);
                }
                let type = types[id], node, buffer, startPos = start - parentStart;
                if (end - start <= maxBufferLength && (buffer = function(maxSize, inRepeat) {
                    let fork = cursor.fork(), size = 0, start = 0, skip = 0, minStart = fork.end - maxBufferLength, result = {
                        size: 0,
                        start: 0,
                        skip: 0
                    };
                    scan: for (var minPos = fork.pos - maxSize; fork.pos > minPos; ) {
                        var nodeSize = fork.size;
                        if (fork.id == inRepeat && 0 <= nodeSize) result.size = size, 
                        result.start = start, result.skip = skip, skip += 4, size += 4, 
                        fork.next(); else {
                            var startPos = fork.pos - nodeSize;
                            if (nodeSize < 0 || startPos < minPos || fork.start < minStart) break;
                            let localSkipped = fork.id >= minRepeatType ? 4 : 0;
                            var nodeStart = fork.start;
                            for (fork.next(); fork.pos > startPos; ) {
                                if (fork.size < 0) {
                                    if (-3 != fork.size) break scan;
                                    localSkipped += 4;
                                } else fork.id >= minRepeatType && (localSkipped += 4);
                                fork.next();
                            }
                            start = nodeStart, size += nodeSize, skip += localSkipped;
                        }
                    }
                    (inRepeat < 0 || size == maxSize) && (result.size = size, result.start = start, 
                    result.skip = skip);
                    return 4 < result.size ? result : void 0;
                }(cursor.pos - minPos, inRepeat))) {
                    var data = new Uint16Array(buffer.size - buffer.skip);
                    let endPos = cursor.pos - buffer.size, index = data.length;
                    for (;cursor.pos > endPos; ) index = function copyToBuffer(bufferStart, buffer, index) {
                        let {
                            id,
                            start,
                            end,
                            size
                        } = cursor;
                        cursor.next();
                        if (0 <= size && id < minRepeatType) {
                            let startIndex = index;
                            if (4 < size) {
                                let endPos = cursor.pos - (size - 4);
                                for (;cursor.pos > endPos; ) index = copyToBuffer(bufferStart, buffer, index);
                            }
                            buffer[--index] = startIndex, buffer[--index] = end - bufferStart, 
                            buffer[--index] = start - bufferStart, buffer[--index] = id;
                        } else -3 == size ? contextHash = id : -4 == size && (lookAhead = id);
                        return index;
                    }(buffer.start, data, index);
                    node = new TreeBuffer(data, end - buffer.start, nodeSet), startPos = buffer.start - parentStart;
                } else {
                    var endPos = cursor.pos - size, localChildren = (cursor.next(), 
                    []), localPositions = [], localInRepeat = id >= minRepeatType ? id : -1;
                    let lastGroup = 0, lastEnd = end;
                    for (;cursor.pos > endPos; ) 0 <= localInRepeat && cursor.id == localInRepeat && 0 <= cursor.size ? (cursor.end <= lastEnd - maxBufferLength && (makeRepeatLeaf(localChildren, localPositions, start, lastGroup, cursor.end, lastEnd, localInRepeat, lookAheadAtStart), 
                    lastGroup = localChildren.length, lastEnd = cursor.end), cursor.next()) : 2500 < depth ? function(parentStart, minPos, children, positions) {
                        let nodes = [], nodeCount = 0, stopAt = -1;
                        for (;cursor.pos > minPos; ) {
                            var {
                                id,
                                start,
                                end,
                                size
                            } = cursor;
                            if (!(4 < size)) {
                                if (-1 < stopAt && start < stopAt) break;
                                stopAt < 0 && (stopAt = end - maxBufferLength), 
                                nodes.push(id, start, end), nodeCount++;
                            }
                            cursor.next();
                        }
                        if (nodeCount) {
                            var buffer = new Uint16Array(4 * nodeCount), start = nodes[nodes.length - 2];
                            for (let i = nodes.length - 3, j = 0; 0 <= i; i -= 3) buffer[j++] = nodes[i], 
                            buffer[j++] = nodes[i + 1] - start, buffer[j++] = nodes[i + 2] - start, 
                            buffer[j++] = j;
                            children.push(new TreeBuffer(buffer, nodes[2] - start, nodeSet)), 
                            positions.push(start - parentStart);
                        }
                    }(start, endPos, localChildren, localPositions) : takeNode(start, endPos, localChildren, localPositions, localInRepeat, depth + 1);
                    0 <= localInRepeat && 0 < lastGroup && lastGroup < localChildren.length && makeRepeatLeaf(localChildren, localPositions, start, lastGroup, start, lastEnd, localInRepeat, lookAheadAtStart), 
                    localChildren.reverse(), localPositions.reverse(), node = -1 < localInRepeat && 0 < lastGroup ? (minPos = function(type) {
                        return (children, positions, length) => {
                            let lookAhead = 0, lastI = children.length - 1, last, lookAheadProp;
                            if (0 <= lastI && (last = children[lastI]) instanceof Tree) {
                                if (!lastI && last.type == type && last.length == length) return last;
                                (lookAheadProp = last.prop(NodeProp.lookAhead)) && (lookAhead = positions[lastI] + last.length + lookAheadProp);
                            }
                            return makeTree(type, children, positions, length, lookAhead);
                        };
                    }(type), balanceRange(type, localChildren, localPositions, 0, localChildren.length, 0, end - start, minPos, minPos)) : makeTree(type, localChildren, localPositions, end - start, lookAheadAtStart - end);
                }
                children.push(node), positions.push(startPos);
            }
            function makeRepeatLeaf(children, positions, base, i, from, to, type, lookAhead) {
                for (var localChildren = [], localPositions = []; children.length > i; ) localChildren.push(children.pop()), 
                localPositions.push(positions.pop() + base - from);
                children.push(makeTree(nodeSet.types[type], localChildren, localPositions, to - from, lookAhead - to)), 
                positions.push(from - base);
            }
            function makeTree(type, children, positions, length, lookAhead = 0, props) {
                var pair;
                if (contextHash && (pair = [ NodeProp.contextHash, contextHash ], 
                props = props ? [ pair ].concat(props) : [ pair ]), 25 < lookAhead) {
                    let pair = [ NodeProp.lookAhead, lookAhead ];
                    props = props ? [ pair ].concat(props) : [ pair ];
                }
                return new Tree(type, children, positions, length, props);
            }
            var children = [], positions = [];
            for (;0 < cursor.pos; ) takeNode(data.start || 0, data.bufferStart || 0, children, positions, -1, 0);
            var _a = null != (_a = data.length) ? _a : children.length ? positions[0] + children[0].length : 0;
            return new Tree(types[data.topID], children.reverse(), positions.reverse(), _a);
        }
    }
    Tree.empty = new Tree(NodeType.none, [], [], 0);
    class FlatBufferCursor {
        constructor(buffer, index) {
            this.buffer = buffer, this.index = index;
        }
        get id() {
            return this.buffer[this.index - 4];
        }
        get start() {
            return this.buffer[this.index - 3];
        }
        get end() {
            return this.buffer[this.index - 2];
        }
        get size() {
            return this.buffer[this.index - 1];
        }
        get pos() {
            return this.index;
        }
        next() {
            this.index -= 4;
        }
        fork() {
            return new FlatBufferCursor(this.buffer, this.index);
        }
    }
    class TreeBuffer {
        constructor(buffer, length, set) {
            this.buffer = buffer, this.length = length, this.set = set;
        }
        get type() {
            return NodeType.none;
        }
        toString() {
            var result = [];
            for (let index = 0; index < this.buffer.length; ) result.push(this.childString(index)), 
            index = this.buffer[index + 3];
            return result.join(",");
        }
        childString(index) {
            var id = this.buffer[index], endIndex = this.buffer[index + 3];
            let type = this.set.types[id], result = type.name;
            if (/\W/.test(result) && !type.isError && (result = JSON.stringify(result)), 
            endIndex == (index += 4)) return result;
            for (var children = []; index < endIndex; ) children.push(this.childString(index)), 
            index = this.buffer[index + 3];
            return result + "(" + children.join(",") + ")";
        }
        findChild(startIndex, endIndex, dir, pos, side) {
            let buffer = this["buffer"], pick = -1;
            for (let i = startIndex; i != endIndex && !(checkSide(side, pos, buffer[i + 1], buffer[i + 2]) && (pick = i, 
            0 < dir)); i = buffer[i + 3]);
            return pick;
        }
        slice(startI, endI, from) {
            var b = this.buffer;
            let copy = new Uint16Array(endI - startI), len = 0;
            for (let i = startI, j = 0; i < endI; ) {
                copy[j++] = b[i++], copy[j++] = b[i++] - from;
                var to = copy[j++] = b[i++] - from;
                copy[j++] = b[i++] - startI, len = Math.max(len, to);
            }
            return new TreeBuffer(copy, len, this.set);
        }
    }
    function checkSide(side, pos, from, to) {
        switch (side) {
          case -2:
            return from < pos;

          case -1:
            return pos <= to && from < pos;

          case 0:
            return from < pos && pos < to;

          case 1:
            return from <= pos && pos < to;

          case 2:
            return pos < to;

          case 4:
            return 1;
        }
    }
    function resolveNode(node, pos, side, overlays) {
        for (var _a; node.from == node.to || (side < 1 ? node.from >= pos : node.from > pos) || (-1 < side ? node.to <= pos : node.to < pos); ) {
            var parent = !overlays && node instanceof TreeNode && node.index < 0 ? null : node.parent;
            if (!parent) return node;
            node = parent;
        }
        var mode = overlays ? 0 : IterMode.IgnoreOverlays;
        if (overlays) for (let scan = node, parent = scan.parent; parent; parent = (scan = parent).parent) scan instanceof TreeNode && scan.index < 0 && (null == (_a = parent.enter(pos, side, mode)) ? void 0 : _a.from) != scan.from && (node = parent);
        for (;;) {
            var inner = node.enter(pos, side, mode);
            if (!inner) return node;
            node = inner;
        }
    }
    class BaseNode {
        cursor(mode = 0) {
            return new TreeCursor(this, mode);
        }
        getChild(type, before = null, after = null) {
            type = getChildren(this, type, before, after);
            return type.length ? type[0] : null;
        }
        getChildren(type, before = null, after = null) {
            return getChildren(this, type, before, after);
        }
        resolve(pos, side = 0) {
            return resolveNode(this, pos, side, !1);
        }
        resolveInner(pos, side = 0) {
            return resolveNode(this, pos, side, !0);
        }
        matchContext(context) {
            return matchNodeContext(this, context);
        }
        enterUnfinishedNodesBefore(pos) {
            let scan = this.childBefore(pos), node = this;
            for (;scan; ) {
                var last = scan.lastChild;
                if (!last || last.to != scan.to) break;
                scan = last.type.isError && last.from == last.to ? (node = scan, 
                last.prevSibling) : last;
            }
            return node;
        }
        get node() {
            return this;
        }
        get next() {
            return this.parent;
        }
    }
    class TreeNode extends BaseNode {
        constructor(_tree, from, index, _parent) {
            super(), this._tree = _tree, this.from = from, this.index = index, this._parent = _parent;
        }
        get type() {
            return this._tree.type;
        }
        get name() {
            return this._tree.type.name;
        }
        get to() {
            return this.from + this._tree.length;
        }
        nextChild(i, dir, pos, side, mode = 0) {
            for (let parent = this; ;) {
                for (var {
                    children,
                    positions
                } = parent._tree, e = 0 < dir ? children.length : -1; i != e; i += dir) {
                    var next = children[i], start = positions[i] + parent.from;
                    if (checkSide(side, pos, start, start + next.length)) if (next instanceof TreeBuffer) {
                        if (!(mode & IterMode.ExcludeBuffers)) {
                            var index = next.findChild(0, next.buffer.length, dir, pos - start, side);
                            if (-1 < index) return new BufferNode(new BufferContext(parent, next, i, start), null, index);
                        }
                    } else if (mode & IterMode.IncludeAnonymous || !next.type.isAnonymous || hasChild(next)) {
                        let mounted;
                        return mode & IterMode.IgnoreMounts || !(mounted = MountedTree.get(next)) || mounted.overlay ? (index = new TreeNode(next, start, i, parent), 
                        mode & IterMode.IncludeAnonymous || !index.type.isAnonymous ? index : index.nextChild(dir < 0 ? next.children.length - 1 : 0, dir, pos, side)) : new TreeNode(mounted.tree, start, i, parent);
                    }
                }
                if (mode & IterMode.IncludeAnonymous || !parent.type.isAnonymous) return null;
                if (i = 0 <= parent.index ? parent.index + dir : dir < 0 ? -1 : parent._parent._tree.children.length, 
                !(parent = parent._parent)) return null;
            }
        }
        get firstChild() {
            return this.nextChild(0, 1, 0, 4);
        }
        get lastChild() {
            return this.nextChild(this._tree.children.length - 1, -1, 0, 4);
        }
        childAfter(pos) {
            return this.nextChild(0, 1, pos, 2);
        }
        childBefore(pos) {
            return this.nextChild(this._tree.children.length - 1, -1, pos, -2);
        }
        enter(pos, side, mode = 0) {
            let mounted;
            if (!(mode & IterMode.IgnoreOverlays) && (mounted = MountedTree.get(this._tree)) && mounted.overlay) {
                var from, to, rPos = pos - this.from;
                for ({
                    from,
                    to
                } of mounted.overlay) if ((0 < side ? from <= rPos : from < rPos) && (side < 0 ? to >= rPos : to > rPos)) return new TreeNode(mounted.tree, mounted.overlay[0].from + this.from, -1, this);
            }
            return this.nextChild(0, 1, pos, side, mode);
        }
        nextSignificantParent() {
            let val = this;
            for (;val.type.isAnonymous && val._parent; ) val = val._parent;
            return val;
        }
        get parent() {
            return this._parent ? this._parent.nextSignificantParent() : null;
        }
        get nextSibling() {
            return this._parent && 0 <= this.index ? this._parent.nextChild(this.index + 1, 1, 0, 4) : null;
        }
        get prevSibling() {
            return this._parent && 0 <= this.index ? this._parent.nextChild(this.index - 1, -1, 0, 4) : null;
        }
        get tree() {
            return this._tree;
        }
        toTree() {
            return this._tree;
        }
        toString() {
            return this._tree.toString();
        }
    }
    function getChildren(node, type, before, after) {
        var cur = node.cursor(), result = [];
        if (!cur.firstChild()) return result;
        if (null != before) for (let found = !1; !found; ) if (found = cur.type.is(before), 
        !cur.nextSibling()) return result;
        for (;;) {
            if (null != after && cur.type.is(after)) return result;
            if (cur.type.is(type) && result.push(cur.node), !cur.nextSibling()) return null == after ? result : [];
        }
    }
    function matchNodeContext(node, context, i = context.length - 1) {
        for (let p = node.parent; 0 <= i; p = p.parent) {
            if (!p) return !1;
            if (!p.type.isAnonymous) {
                if (context[i] && context[i] != p.name) return !1;
                i--;
            }
        }
        return !0;
    }
    class BufferContext {
        constructor(parent, buffer, index, start) {
            this.parent = parent, this.buffer = buffer, this.index = index, this.start = start;
        }
    }
    class BufferNode extends BaseNode {
        get name() {
            return this.type.name;
        }
        get from() {
            return this.context.start + this.context.buffer.buffer[this.index + 1];
        }
        get to() {
            return this.context.start + this.context.buffer.buffer[this.index + 2];
        }
        constructor(context, _parent, index) {
            super(), this.context = context, this._parent = _parent, this.index = index, 
            this.type = context.buffer.set.types[context.buffer.buffer[index]];
        }
        child(dir, pos, side) {
            var buffer = this.context["buffer"], buffer = buffer.findChild(this.index + 4, buffer.buffer[this.index + 3], dir, pos - this.context.start, side);
            return buffer < 0 ? null : new BufferNode(this.context, this, buffer);
        }
        get firstChild() {
            return this.child(1, 0, 4);
        }
        get lastChild() {
            return this.child(-1, 0, 4);
        }
        childAfter(pos) {
            return this.child(1, pos, 2);
        }
        childBefore(pos) {
            return this.child(-1, pos, -2);
        }
        enter(pos, side, mode = 0) {
            return mode & IterMode.ExcludeBuffers || (mode = this.context.buffer, 
            (mode = mode.findChild(this.index + 4, mode.buffer[this.index + 3], 0 < side ? 1 : -1, pos - this.context.start, side)) < 0) ? null : new BufferNode(this.context, this, mode);
        }
        get parent() {
            return this._parent || this.context.parent.nextSignificantParent();
        }
        externalSibling(dir) {
            return this._parent ? null : this.context.parent.nextChild(this.context.index + dir, dir, 0, 4);
        }
        get nextSibling() {
            var buffer = this.context["buffer"], after = buffer.buffer[this.index + 3];
            return after < (this._parent ? buffer.buffer[this._parent.index + 3] : buffer.buffer.length) ? new BufferNode(this.context, this._parent, after) : this.externalSibling(1);
        }
        get prevSibling() {
            var buffer = this.context["buffer"], parentStart = this._parent ? this._parent.index + 4 : 0;
            return this.index == parentStart ? this.externalSibling(-1) : new BufferNode(this.context, this._parent, buffer.findChild(parentStart, this.index, -1, 0, 4));
        }
        get tree() {
            return null;
        }
        toTree() {
            var from, children = [], positions = [], buffer = this.context["buffer"], startI = this.index + 4, endI = buffer.buffer[this.index + 3];
            return startI < endI && (from = buffer.buffer[this.index + 1], children.push(buffer.slice(startI, endI, from)), 
            positions.push(0)), new Tree(this.type, children, positions, this.to - this.from);
        }
        toString() {
            return this.context.buffer.childString(this.index);
        }
    }
    function iterStack(heads) {
        if (!heads.length) return null;
        let pick = 0, picked = heads[0];
        for (let i = 1; i < heads.length; i++) {
            var node = heads[i];
            (node.from > picked.from || node.to < picked.to) && (picked = node, 
            pick = i);
        }
        var next = picked instanceof TreeNode && picked.index < 0 ? null : picked.parent, newHeads = heads.slice();
        return next ? newHeads[pick] = next : newHeads.splice(pick, 1), new StackIterator(newHeads, picked);
    }
    class StackIterator {
        constructor(heads, node) {
            this.heads = heads, this.node = node;
        }
        get next() {
            return iterStack(this.heads);
        }
    }
    class TreeCursor {
        get name() {
            return this.type.name;
        }
        constructor(node, mode = 0) {
            if (this.mode = mode, this.buffer = null, this.stack = [], this.index = 0, 
            this.bufferNode = null, node instanceof TreeNode) this.yieldNode(node); else {
                this._tree = node.context.parent, this.buffer = node.context;
                for (let n = node._parent; n; n = n._parent) this.stack.unshift(n.index);
                this.bufferNode = node, this.yieldBuf(node.index);
            }
        }
        yieldNode(node) {
            return !!node && (this._tree = node, this.type = node.type, this.from = node.from, 
            this.to = node.to, !0);
        }
        yieldBuf(index, type) {
            this.index = index;
            var {
                start,
                buffer
            } = this.buffer;
            return this.type = type || buffer.set.types[buffer.buffer[index]], this.from = start + buffer.buffer[index + 1], 
            this.to = start + buffer.buffer[index + 2], !0;
        }
        yield(node) {
            return !!node && (node instanceof TreeNode ? (this.buffer = null, this.yieldNode(node)) : (this.buffer = node.context, 
            this.yieldBuf(node.index, node.type)));
        }
        toString() {
            return this.buffer ? this.buffer.buffer.childString(this.index) : this._tree.toString();
        }
        enterChild(dir, pos, side) {
            var buffer;
            return this.buffer ? (buffer = this.buffer["buffer"], !((buffer = buffer.findChild(this.index + 4, buffer.buffer[this.index + 3], dir, pos - this.buffer.start, side)) < 0) && (this.stack.push(this.index), 
            this.yieldBuf(buffer))) : this.yield(this._tree.nextChild(dir < 0 ? this._tree._tree.children.length - 1 : 0, dir, pos, side, this.mode));
        }
        firstChild() {
            return this.enterChild(1, 0, 4);
        }
        lastChild() {
            return this.enterChild(-1, 0, 4);
        }
        childAfter(pos) {
            return this.enterChild(1, pos, 2);
        }
        childBefore(pos) {
            return this.enterChild(-1, pos, -2);
        }
        enter(pos, side, mode = this.mode) {
            return this.buffer ? !(mode & IterMode.ExcludeBuffers) && this.enterChild(1, pos, side) : this.yield(this._tree.enter(pos, side, mode));
        }
        parent() {
            var parent;
            return this.buffer ? this.stack.length ? this.yieldBuf(this.stack.pop()) : (parent = this.mode & IterMode.IncludeAnonymous ? this.buffer.parent : this.buffer.parent.nextSignificantParent(), 
            this.buffer = null, this.yieldNode(parent)) : this.yieldNode(this.mode & IterMode.IncludeAnonymous ? this._tree._parent : this._tree.parent);
        }
        sibling(dir) {
            if (!this.buffer) return !!this._tree._parent && this.yield(this._tree.index < 0 ? null : this._tree._parent.nextChild(this._tree.index + dir, dir, 0, 4, this.mode));
            var buffer = this.buffer["buffer"], d = this.stack.length - 1;
            if (dir < 0) {
                var parentStart = d < 0 ? 0 : this.stack[d] + 4;
                if (this.index != parentStart) return this.yieldBuf(buffer.findChild(parentStart, this.index, -1, 0, 4));
            } else {
                parentStart = buffer.buffer[this.index + 3];
                if (parentStart < (d < 0 ? buffer.buffer.length : buffer.buffer[this.stack[d] + 3])) return this.yieldBuf(parentStart);
            }
            return d < 0 && this.yield(this.buffer.parent.nextChild(this.buffer.index + dir, dir, 0, 4, this.mode));
        }
        nextSibling() {
            return this.sibling(1);
        }
        prevSibling() {
            return this.sibling(-1);
        }
        atLastNode(dir) {
            let index, parent, buffer = this["buffer"];
            if (buffer) {
                if (0 < dir) {
                    if (this.index < buffer.buffer.buffer.length) return !1;
                } else for (let i = 0; i < this.index; i++) if (buffer.buffer.buffer[i + 3] < this.index) return !1;
                ({
                    index,
                    parent
                } = buffer);
            } else ({
                index,
                _parent: parent
            } = this._tree);
            for (;parent; {
                index,
                _parent: parent
            } = parent) if (-1 < index) for (let i = index + dir, e = dir < 0 ? -1 : parent._tree.children.length; i != e; i += dir) {
                var child = parent._tree.children[i];
                if (this.mode & IterMode.IncludeAnonymous || child instanceof TreeBuffer || !child.type.isAnonymous || hasChild(child)) return !1;
            }
            return !0;
        }
        move(dir, enter) {
            if (enter && this.enterChild(dir, 0, 4)) return !0;
            for (;;) {
                if (this.sibling(dir)) return !0;
                if (this.atLastNode(dir) || !this.parent()) return !1;
            }
        }
        next(enter = !0) {
            return this.move(1, enter);
        }
        prev(enter = !0) {
            return this.move(-1, enter);
        }
        moveTo(pos, side = 0) {
            for (;(this.from == this.to || (side < 1 ? this.from >= pos : this.from > pos) || (-1 < side ? this.to <= pos : this.to < pos)) && this.parent(); );
            for (;this.enterChild(1, pos, side); );
            return this;
        }
        get node() {
            if (!this.buffer) return this._tree;
            let cache = this.bufferNode, result = null, depth = 0;
            if (cache && cache.context == this.buffer) scan: for (let index = this.index, d = this.stack.length; 0 <= d; ) {
                for (let c = cache; c; c = c._parent) if (c.index == index) {
                    if (index == this.index) return c;
                    result = c, depth = d + 1;
                    break scan;
                }
                index = this.stack[--d];
            }
            for (let i = depth; i < this.stack.length; i++) result = new BufferNode(this.buffer, result, this.stack[i]);
            return this.bufferNode = new BufferNode(this.buffer, result, this.index);
        }
        get tree() {
            return this.buffer ? null : this._tree._tree;
        }
        iterate(enter, leave) {
            for (let depth = 0; ;) {
                let mustLeave = !1;
                if (this.type.isAnonymous || !1 !== enter(this)) {
                    if (this.firstChild()) {
                        depth++;
                        continue;
                    }
                    this.type.isAnonymous || (mustLeave = !0);
                }
                for (;mustLeave && leave && leave(this), mustLeave = this.type.isAnonymous, 
                !this.nextSibling(); ) {
                    if (!depth) return;
                    this.parent(), depth--, mustLeave = !0;
                }
            }
        }
        matchContext(context) {
            if (!this.buffer) return matchNodeContext(this.node, context);
            var buffer = this.buffer["buffer"], types = buffer.set["types"];
            for (let i = context.length - 1, d = this.stack.length - 1; 0 <= i; d--) {
                if (d < 0) return matchNodeContext(this.node, context, i);
                var type = types[buffer.buffer[this.stack[d]]];
                if (!type.isAnonymous) {
                    if (context[i] && context[i] != type.name) return !1;
                    i--;
                }
            }
            return !0;
        }
    }
    function hasChild(tree) {
        return tree.children.some(ch => ch instanceof TreeBuffer || !ch.type.isAnonymous || hasChild(ch));
    }
    const nodeSizeCache = new WeakMap();
    function nodeSize(balanceType, node) {
        if (!balanceType.isAnonymous || node instanceof TreeBuffer || node.type != balanceType) return 1;
        let size = nodeSizeCache.get(node);
        if (null == size) {
            size = 1;
            for (var child of node.children) {
                if (child.type != balanceType || !(child instanceof Tree)) {
                    size = 1;
                    break;
                }
                size += nodeSize(balanceType, child);
            }
            nodeSizeCache.set(node, size);
        }
        return size;
    }
    function balanceRange(balanceType, children, positions, from, to, start, length, mkTop, mkTree) {
        let total = 0;
        for (let i = from; i < to; i++) total += nodeSize(balanceType, children[i]);
        let maxChild = Math.ceil(1.5 * total / 8), localChildren = [], localPositions = [];
        return function divide(children, positions, from, to, offset) {
            for (let i = from; i < to; ) {
                let groupFrom = i, groupStart = positions[i], groupSize = nodeSize(balanceType, children[i]);
                for (i++; i < to; i++) {
                    var nextSize = nodeSize(balanceType, children[i]);
                    if (groupSize + nextSize >= maxChild) break;
                    groupSize += nextSize;
                }
                if (i == groupFrom + 1) {
                    if (groupSize > maxChild) {
                        var only = children[groupFrom];
                        divide(only.children, only.positions, 0, only.children.length, positions[groupFrom] + offset);
                        continue;
                    }
                    localChildren.push(children[groupFrom]);
                } else only = positions[i - 1] + children[i - 1].length - groupStart, 
                localChildren.push(balanceRange(balanceType, children, positions, groupFrom, i, groupStart, only, null, mkTree));
                localPositions.push(groupStart + offset - start);
            }
        }(children, positions, from, to, 0), (mkTop || mkTree)(localChildren, localPositions, length);
    }
    class NodeWeakMap {
        constructor() {
            this.map = new WeakMap();
        }
        setBuffer(buffer, index, value) {
            let inner = this.map.get(buffer);
            inner || this.map.set(buffer, inner = new Map()), inner.set(index, value);
        }
        getBuffer(buffer, index) {
            buffer = this.map.get(buffer);
            return buffer && buffer.get(index);
        }
        set(node, value) {
            node instanceof BufferNode ? this.setBuffer(node.context.buffer, node.index, value) : node instanceof TreeNode && this.map.set(node.tree, value);
        }
        get(node) {
            return node instanceof BufferNode ? this.getBuffer(node.context.buffer, node.index) : node instanceof TreeNode ? this.map.get(node.tree) : void 0;
        }
        cursorSet(cursor, value) {
            cursor.buffer ? this.setBuffer(cursor.buffer.buffer, cursor.index, value) : this.map.set(cursor.tree, value);
        }
        cursorGet(cursor) {
            return cursor.buffer ? this.getBuffer(cursor.buffer.buffer, cursor.index) : this.map.get(cursor.tree);
        }
    }
    class TreeFragment {
        constructor(from, to, tree, offset, openStart = !1, openEnd = !1) {
            this.from = from, this.to = to, this.tree = tree, this.offset = offset, 
            this.open = (openStart ? 1 : 0) | (openEnd ? 2 : 0);
        }
        get openStart() {
            return 0 < (1 & this.open);
        }
        get openEnd() {
            return 0 < (2 & this.open);
        }
        static addTree(tree, fragments = [], partial = !1) {
            var f, result = [ new TreeFragment(0, tree.length, tree, 0, !1, partial) ];
            for (f of fragments) f.to > tree.length && result.push(f);
            return result;
        }
        static applyChanges(fragments, changes, minGap = 128) {
            if (!changes.length) return fragments;
            var result = [];
            let fI = 1, nextF = fragments.length ? fragments[0] : null;
            for (let cI = 0, pos = 0, off = 0; ;cI++) {
                var fFrom, fTo, nextC = cI < changes.length ? changes[cI] : null, nextPos = nextC ? nextC.fromA : 1e9;
                if (nextPos - pos >= minGap) for (;nextF && nextF.from < nextPos; ) {
                    let cut = nextF;
                    if ((pos >= cut.from || nextPos <= cut.to || off) && (fFrom = Math.max(cut.from, pos) - off, 
                    fTo = Math.min(cut.to, nextPos) - off, cut = fTo <= fFrom ? null : new TreeFragment(fFrom, fTo, cut.tree, cut.offset + off, 0 < cI, !!nextC)), 
                    cut && result.push(cut), nextF.to > nextPos) break;
                    nextF = fI < fragments.length ? fragments[fI++] : null;
                }
                if (!nextC) break;
                pos = nextC.toA, off = nextC.toA - nextC.toB;
            }
            return result;
        }
    }
    class Parser {
        startParse(input, fragments, ranges) {
            return "string" == typeof input && (input = new StringInput(input)), 
            ranges = ranges ? ranges.length ? ranges.map(r => new Range(r.from, r.to)) : [ new Range(0, 0) ] : [ new Range(0, input.length) ], 
            this.createParse(input, fragments || [], ranges);
        }
        parse(input, fragments, ranges) {
            for (var parse = this.startParse(input, fragments, ranges); ;) {
                var done = parse.advance();
                if (done) return done;
            }
        }
    }
    class StringInput {
        constructor(string) {
            this.string = string;
        }
        get length() {
            return this.string.length;
        }
        chunk(from) {
            return this.string.slice(from);
        }
        get lineChunks() {
            return !1;
        }
        read(from, to) {
            return this.string.slice(from, to);
        }
    }
    function parseMixed(nest) {
        return (parse, input, fragments, ranges) => new MixedParse(parse, nest, input, fragments, ranges);
    }
    class InnerParse {
        constructor(parser, parse, overlay, target, from) {
            this.parser = parser, this.parse = parse, this.overlay = overlay, this.target = target, 
            this.from = from;
        }
    }
    function checkRanges(ranges) {
        if (!ranges.length || ranges.some(r => r.from >= r.to)) throw new RangeError("Invalid inner parse ranges given: " + JSON.stringify(ranges));
    }
    class ActiveOverlay {
        constructor(parser, predicate, mounts, index, start, target, prev) {
            this.parser = parser, this.predicate = predicate, this.mounts = mounts, 
            this.index = index, this.start = start, this.target = target, this.prev = prev, 
            this.depth = 0, this.ranges = [];
        }
    }
    const stoppedInner = new NodeProp({
        perNode: !0
    });
    class MixedParse {
        constructor(base, nest, input, fragments, ranges) {
            this.nest = nest, this.input = input, this.fragments = fragments, this.ranges = ranges, 
            this.inner = [], this.innerDone = 0, this.baseTree = null, this.stoppedAt = null, 
            this.baseParse = base;
        }
        advance() {
            if (this.baseParse) {
                let done = this.baseParse.advance();
                if (!done) return null;
                if (this.baseParse = null, this.baseTree = done, this.startInner(), 
                null != this.stoppedAt) for (let inner of this.inner) inner.parse.stopAt(this.stoppedAt);
            }
            if (this.innerDone == this.inner.length) {
                let result = this.baseTree;
                return result = null != this.stoppedAt ? new Tree(result.type, result.children, result.positions, result.length, result.propValues.concat([ [ stoppedInner, this.stoppedAt ] ])) : result;
            }
            var props, inner = this.inner[this.innerDone], done = inner.parse.advance();
            return done && (this.innerDone++, (props = Object.assign(Object.create(null), inner.target.props))[NodeProp.mounted.id] = new MountedTree(done, inner.overlay, inner.parser), 
            inner.target.props = props), null;
        }
        get parsedPos() {
            if (this.baseParse) return 0;
            let pos = this.input.length;
            for (let i = this.innerDone; i < this.inner.length; i++) this.inner[i].from < pos && (pos = Math.min(pos, this.inner[i].parse.parsedPos));
            return pos;
        }
        stopAt(pos) {
            if (this.stoppedAt = pos, this.baseParse) this.baseParse.stopAt(pos); else for (let i = this.innerDone; i < this.inner.length; i++) this.inner[i].parse.stopAt(pos);
        }
        startInner() {
            var oldMounts, ranges, fragmentCursor = new FragmentCursor$2(this.fragments);
            let overlay = null, covered = null, cursor = new TreeCursor(new TreeNode(this.baseTree, this.ranges[0].from, 0, null), IterMode.IncludeAnonymous | IterMode.IgnoreMounts);
            scan: for (let nest, isCovered; ;) {
                let enter = !0, range;
                if (null != this.stoppedAt && cursor.from >= this.stoppedAt) enter = !1; else if (fragmentCursor.hasNode(cursor)) {
                    if (overlay) {
                        var match = overlay.mounts.find(m => m.frag.from <= cursor.from && m.frag.to >= cursor.to && m.mount.overlay);
                        if (match) for (var r of match.mount.overlay) {
                            let from = r.from + match.pos, to = r.to + match.pos;
                            from >= cursor.from && to <= cursor.to && !overlay.ranges.some(r => r.from < to && r.to > from) && overlay.ranges.push({
                                from: from,
                                to: to
                            });
                        }
                    }
                    enter = !1;
                } else covered && (isCovered = function(covered, from, to) {
                    for (var range of covered) {
                        if (range.from >= to) break;
                        if (range.to > from) return range.from <= from && range.to >= to ? 2 : 1;
                    }
                    return 0;
                }(covered.ranges, cursor.from, cursor.to)) ? enter = 2 != isCovered : !cursor.type.isAnonymous && (nest = this.nest(cursor, this.input)) && (cursor.from < cursor.to || !nest.overlay) ? (cursor.tree || function(cursor) {
                    let node = cursor["node"], stack = [], buffer = node.context.buffer;
                    for (;stack.push(cursor.index), cursor.parent(), !cursor.tree; );
                    let base = cursor.tree, i = base.children.indexOf(buffer), buf = base.children[i], b = buf.buffer, newStack = [ i ];
                    base.children[i] = function split(startI, endI, type, innerOffset, length, stackPos) {
                        var targetI = stack[stackPos], children = [], positions = [], startI = (sliceBuf(buf, startI, targetI, children, positions, innerOffset), 
                        b[targetI + 1]), to = b[targetI + 2], to = (newStack.push(children.length), 
                        stackPos ? split(targetI + 4, b[targetI + 3], buf.set.types[b[targetI]], startI, to - startI, stackPos - 1) : node.toTree());
                        return children.push(to), positions.push(startI - innerOffset), 
                        sliceBuf(buf, b[targetI + 3], endI, children, positions, innerOffset), 
                        new Tree(type, children, positions, length);
                    }(0, b.length, NodeType.none, 0, buf.length, stack.length - 1);
                    for (var index of newStack) {
                        var tree = cursor.tree.children[index], pos = cursor.tree.positions[index];
                        cursor.yield(new TreeNode(tree, pos + cursor.from, index, cursor._tree));
                    }
                }(cursor), oldMounts = fragmentCursor.findMounts(cursor.from, nest.parser), 
                "function" == typeof nest.overlay ? overlay = new ActiveOverlay(nest.parser, nest.overlay, oldMounts, this.inner.length, cursor.from, cursor.tree, overlay) : ((ranges = punchRanges(this.ranges, nest.overlay || (cursor.from < cursor.to ? [ new Range(cursor.from, cursor.to) ] : []))).length && checkRanges(ranges), 
                !ranges.length && nest.overlay || this.inner.push(new InnerParse(nest.parser, ranges.length ? nest.parser.startParse(this.input, enterFragments(oldMounts, ranges), ranges) : nest.parser.startParse(""), nest.overlay ? nest.overlay.map(r => new Range(r.from - cursor.from, r.to - cursor.from)) : null, cursor.tree, (ranges.length ? ranges[0] : cursor).from)), 
                nest.overlay ? ranges.length && (covered = {
                    ranges: ranges,
                    depth: 0,
                    prev: covered
                }) : enter = !1)) : overlay && (range = overlay.predicate(cursor)) && (range = !0 === range ? new Range(cursor.from, cursor.to) : range).from < range.to && overlay.ranges.push(range);
                if (enter && cursor.firstChild()) overlay && overlay.depth++, covered && covered.depth++; else for (;!cursor.nextSibling(); ) {
                    if (!cursor.parent()) break scan;
                    if (overlay && !--overlay.depth) {
                        let ranges = punchRanges(this.ranges, overlay.ranges);
                        ranges.length && (checkRanges(ranges), this.inner.splice(overlay.index, 0, new InnerParse(overlay.parser, overlay.parser.startParse(this.input, enterFragments(overlay.mounts, ranges), ranges), overlay.ranges.map(r => new Range(r.from - overlay.start, r.to - overlay.start)), overlay.target, ranges[0].from))), 
                        overlay = overlay.prev;
                    }
                    covered && !--covered.depth && (covered = covered.prev);
                }
            }
        }
    }
    function sliceBuf(buf, startI, endI, nodes, positions, off) {
        var from;
        startI < endI && (from = buf.buffer[startI + 1], nodes.push(buf.slice(startI, endI, from)), 
        positions.push(from - off));
    }
    class StructureCursor {
        constructor(root, offset) {
            this.offset = offset, this.done = !1, this.cursor = root.cursor(IterMode.IncludeAnonymous | IterMode.IgnoreMounts);
        }
        moveTo(pos) {
            for (var cursor = this["cursor"], p = pos - this.offset; !this.done && cursor.from < p; ) cursor.to >= pos && cursor.enter(p, 1, IterMode.IgnoreOverlays | IterMode.ExcludeBuffers) || cursor.next(!1) || (this.done = !0);
        }
        hasNode(cursor) {
            if (this.moveTo(cursor.from), !this.done && this.cursor.from + this.offset == cursor.from && this.cursor.tree) for (let tree = this.cursor.tree; ;) {
                if (tree == cursor.tree) return !0;
                if (!(tree.children.length && 0 == tree.positions[0] && tree.children[0] instanceof Tree)) break;
                tree = tree.children[0];
            }
            return !1;
        }
    }
    let FragmentCursor$2 = class {
        constructor(fragments) {
            var _a;
            this.fragments = fragments, this.curTo = 0, this.fragI = 0, fragments.length ? (fragments = this.curFrag = fragments[0], 
            this.curTo = null != (_a = fragments.tree.prop(stoppedInner)) ? _a : fragments.to, 
            this.inner = new StructureCursor(fragments.tree, -fragments.offset)) : this.curFrag = this.inner = null;
        }
        hasNode(node) {
            for (;this.curFrag && node.from >= this.curTo; ) this.nextFrag();
            return this.curFrag && this.curFrag.from <= node.from && this.curTo >= node.to && this.inner.hasNode(node);
        }
        nextFrag() {
            var _a, frag;
            this.fragI++, this.fragI == this.fragments.length ? this.curFrag = this.inner = null : (frag = this.curFrag = this.fragments[this.fragI], 
            this.curTo = null != (_a = frag.tree.prop(stoppedInner)) ? _a : frag.to, 
            this.inner = new StructureCursor(frag.tree, -frag.offset));
        }
        findMounts(pos, parser) {
            var _a, result = [];
            if (this.inner) {
                this.inner.cursor.moveTo(pos, 1);
                for (let pos = this.inner.cursor.node; pos; pos = pos.parent) {
                    var mount = null == (_a = pos.tree) ? void 0 : _a.prop(NodeProp.mounted);
                    if (mount && mount.parser == parser) for (let i = this.fragI; i < this.fragments.length; i++) {
                        var frag = this.fragments[i];
                        if (frag.from >= pos.to) break;
                        frag.tree == this.curFrag.tree && result.push({
                            frag: frag,
                            pos: pos.from - frag.offset,
                            mount: mount
                        });
                    }
                }
            }
            return result;
        }
    };
    function punchRanges(outer, ranges) {
        let copy = null, current = ranges;
        for (let i = 1, j = 0; i < outer.length; i++) for (var gapFrom = outer[i - 1].to, gapTo = outer[i].from; j < current.length; j++) {
            var r = current[j];
            if (r.from >= gapTo) break;
            r.to <= gapFrom || (copy || (current = copy = ranges.slice()), r.from < gapFrom ? (copy[j] = new Range(r.from, gapFrom), 
            r.to > gapTo && copy.splice(j + 1, 0, new Range(gapTo, r.to))) : r.to > gapTo ? copy[j--] = new Range(gapTo, r.to) : copy.splice(j--, 1));
        }
        return current;
    }
    function enterFragments(mounts, ranges) {
        var result = [];
        for (let {
            pos,
            mount,
            frag
        } of mounts) {
            var startPos = pos + (mount.overlay ? mount.overlay[0].from : 0), endPos = startPos + mount.tree.length, from = Math.max(frag.from, startPos), to = Math.min(frag.to, endPos);
            if (mount.overlay) {
                var changes = function(a, b, from, to) {
                    let iA = 0, iB = 0, inA = !1, inB = !1, pos = -1e9;
                    for (var result = []; ;) {
                        var start, end, nextA = iA == a.length ? 1e9 : inA ? a[iA].to : a[iA].from, nextB = iB == b.length ? 1e9 : inB ? b[iB].to : b[iB].from;
                        if (inA != inB && (start = Math.max(pos, from)) < (end = Math.min(nextA, nextB, to)) && result.push(new Range(start, end)), 
                        1e9 == (pos = Math.min(nextA, nextB))) break;
                        nextA == pos && (inA ? (inA = !1, iA++) : inA = !0), nextB == pos && (inB ? (inB = !1, 
                        iB++) : inB = !0);
                    }
                    return result;
                }(ranges, mount.overlay.map(r => new Range(r.from + pos, r.to + pos)), from, to);
                for (let i = 0, pos = from; ;i++) {
                    var last = i == changes.length, end = last ? to : changes[i].from;
                    if (end > pos && result.push(new TreeFragment(pos, end, mount.tree, -startPos, frag.from >= pos || frag.openStart, frag.to <= end || frag.openEnd)), 
                    last) break;
                    pos = changes[i].to;
                }
            } else result.push(new TreeFragment(from, to, mount.tree, -startPos, frag.from >= startPos || frag.openStart, frag.to <= endPos || frag.openEnd));
        }
        return result;
    }
    let nextTagID = 0;
    class Tag {
        constructor(set, base, modified) {
            this.set = set, this.base = base, this.modified = modified, this.id = nextTagID++;
        }
        static define(parent) {
            if (null != parent && parent.base) throw new Error("Can not derive from a modified tag");
            var tag = new Tag([], null, []);
            if (tag.set.push(tag), parent) for (var t of parent.set) tag.set.push(t);
            return tag;
        }
        static defineModifier() {
            let mod = new Modifier();
            return tag => -1 < tag.modified.indexOf(mod) ? tag : Modifier.get(tag.base || tag, tag.modified.concat(mod).sort((a, b) => a.id - b.id));
        }
    }
    let nextModifierID = 0;
    class Modifier {
        constructor() {
            this.instances = [], this.id = nextModifierID++;
        }
        static get(base, mods) {
            if (!mods.length) return base;
            var exists = mods[0].instances.find(t => {
                return t.base == base && (a = mods, b = t.modified, a.length == b.length) && a.every((x, i) => x == b[i]);
                var a, b;
            });
            if (exists) return exists;
            var m, set = [], tag = new Tag(set, base, mods);
            for (m of mods) m.instances.push(tag);
            var parent, configs = function(array) {
                var sets = [ [] ];
                for (let i = 0; i < array.length; i++) for (let j = 0, e = sets.length; j < e; j++) sets.push(sets[j].concat(array[i]));
                return sets.sort((a, b) => b.length - a.length);
            }(mods);
            for (parent of base.set) if (!parent.modified.length) for (var config of configs) set.push(Modifier.get(parent, config));
            return tag;
        }
    }
    function styleTags(spec) {
        var prop, byName = Object.create(null);
        for (prop in spec) {
            let tags = spec[prop];
            Array.isArray(tags) || (tags = [ tags ]);
            for (var part of prop.split(" ")) if (part) {
                let pieces = [], mode = 2, rest = part;
                for (let pos = 0; ;) {
                    if ("..." == rest && 0 < pos && pos + 3 == part.length) {
                        mode = 1;
                        break;
                    }
                    var m = /^"(?:[^"\\]|\\.)*?"|[^\/!]+/.exec(rest);
                    if (!m) throw new RangeError("Invalid path: " + part);
                    if (pieces.push("*" == m[0] ? "" : '"' == m[0][0] ? JSON.parse(m[0]) : m[0]), 
                    (pos += m[0].length) == part.length) break;
                    m = part[pos++];
                    if (pos == part.length && "!" == m) {
                        mode = 0;
                        break;
                    }
                    if ("/" != m) throw new RangeError("Invalid path: " + part);
                    rest = part.slice(pos);
                }
                var last = pieces.length - 1, inner = pieces[last];
                if (!inner) throw new RangeError("Invalid path: " + part);
                last = new Rule(tags, mode, 0 < last ? pieces.slice(0, last) : null);
                byName[inner] = last.sort(byName[inner]);
            }
        }
        return ruleNodeProp.add(byName);
    }
    const ruleNodeProp = new NodeProp();
    class Rule {
        constructor(tags, mode, context, next) {
            this.tags = tags, this.mode = mode, this.context = context, this.next = next;
        }
        get opaque() {
            return 0 == this.mode;
        }
        get inherit() {
            return 1 == this.mode;
        }
        sort(other) {
            return !other || other.depth < this.depth ? (this.next = other, this) : (other.next = this.sort(other.next), 
            other);
        }
        get depth() {
            return this.context ? this.context.length : 0;
        }
    }
    function tagHighlighter(tags, options) {
        let map = Object.create(null);
        for (var style of tags) if (Array.isArray(style.tag)) for (var tag of style.tag) map[tag.id] = style.class; else map[style.tag.id] = style.class;
        let {
            scope,
            all = null
        } = options || {};
        return {
            style: tags => {
                let cls = all;
                for (var tag of tags) for (var sub of tag.set) {
                    sub = map[sub.id];
                    if (sub) {
                        cls = cls ? cls + " " + sub : sub;
                        break;
                    }
                }
                return cls;
            },
            scope: scope
        };
    }
    function highlightTree(tree, highlighter, putStyle, from = 0, to = tree.length) {
        highlighter = new HighlightBuilder(from, Array.isArray(highlighter) ? highlighter : [ highlighter ], putStyle);
        highlighter.highlightRange(tree.cursor(), from, to, "", highlighter.highlighters), 
        highlighter.flush(to);
    }
    Rule.empty = new Rule([], 2, null);
    class HighlightBuilder {
        constructor(at, highlighters, span) {
            this.at = at, this.highlighters = highlighters, this.span = span, this.class = "";
        }
        startSpan(at, cls) {
            cls != this.class && (this.flush(at), at > this.at && (this.at = at), 
            this.class = cls);
        }
        flush(to) {
            to > this.at && this.class && this.span(this.at, to, this.class);
        }
        highlightRange(cursor, from, to, inheritedClass, highlighters) {
            let {
                type,
                from: start,
                to: end
            } = cursor;
            if (!(to <= start || end <= from)) {
                type.isTop && (highlighters = this.highlighters.filter(h => !h.scope || h.scope(type)));
                let cls = inheritedClass;
                var rule = function(node) {
                    let rule = node.type.prop(ruleNodeProp);
                    for (;rule && rule.context && !node.matchContext(rule.context); ) rule = rule.next;
                    return rule || null;
                }(cursor) || Rule.empty, tagCls = function(highlighters, tags) {
                    let result = null;
                    for (var highlighter of highlighters) {
                        highlighter = highlighter.style(tags);
                        highlighter && (result = result ? result + " " + highlighter : highlighter);
                    }
                    return result;
                }(highlighters, rule.tags);
                if (tagCls && (cls && (cls += " "), cls += tagCls, 1 == rule.mode) && (inheritedClass += (inheritedClass ? " " : "") + tagCls), 
                this.startSpan(Math.max(from, start), cls), !rule.opaque) {
                    let mounted = cursor.tree && cursor.tree.prop(NodeProp.mounted);
                    if (mounted && mounted.overlay) {
                        var inner = cursor.node.enter(mounted.overlay[0].from + start, 1), innerHighlighters = this.highlighters.filter(h => !h.scope || h.scope(mounted.tree.type)), hasChild = cursor.firstChild();
                        for (let i = 0, pos = start; ;i++) {
                            var next = i < mounted.overlay.length ? mounted.overlay[i] : null, nextPos = next ? next.from + start : end, rangeFrom = Math.max(from, pos), rangeTo = Math.min(to, nextPos);
                            if (rangeFrom < rangeTo && hasChild) for (;cursor.from < rangeTo && (this.highlightRange(cursor, rangeFrom, rangeTo, inheritedClass, highlighters), 
                            this.startSpan(Math.min(rangeTo, cursor.to), cls), !(cursor.to >= nextPos)) && cursor.nextSibling(); );
                            if (!next || to < nextPos) break;
                            (pos = next.to + start) > from && (this.highlightRange(inner.cursor(), Math.max(from, next.from + start), Math.min(to, pos), "", innerHighlighters), 
                            this.startSpan(Math.min(to, pos), cls));
                        }
                        hasChild && cursor.parent();
                    } else if (cursor.firstChild()) {
                        mounted && (inheritedClass = "");
                        do {
                            if (!(cursor.to <= from)) {
                                if (cursor.from >= to) break;
                                this.highlightRange(cursor, from, to, inheritedClass, highlighters), 
                                this.startSpan(Math.min(to, cursor.to), cls);
                            }
                        } while (cursor.nextSibling());
                        cursor.parent();
                    }
                }
            }
        }
    }
    var ie_edge = Tag.define, gecko = ie_edge(), chrome = ie_edge(), ios = ie_edge(chrome), nav = ie_edge(chrome), safari = ie_edge(), webkit = ie_edge(safari), doc = ie_edge(safari), ie = ie_edge(), ie_upto10 = ie_edge(ie), ie_11up = ie_edge(), operator = ie_edge(), punctuation = ie_edge(), bracket = ie_edge(punctuation), meta = ie_edge();
    const tags$1 = {
        comment: gecko,
        lineComment: ie_edge(gecko),
        blockComment: ie_edge(gecko),
        docComment: ie_edge(gecko),
        name: chrome,
        variableName: ie_edge(chrome),
        typeName: ios,
        tagName: ie_edge(ios),
        propertyName: nav,
        attributeName: ie_edge(nav),
        className: ie_edge(chrome),
        labelName: ie_edge(chrome),
        namespace: ie_edge(chrome),
        macroName: ie_edge(chrome),
        literal: safari,
        string: webkit,
        docString: ie_edge(webkit),
        character: ie_edge(webkit),
        attributeValue: ie_edge(webkit),
        number: doc,
        integer: ie_edge(doc),
        float: ie_edge(doc),
        bool: ie_edge(safari),
        regexp: ie_edge(safari),
        escape: ie_edge(safari),
        color: ie_edge(safari),
        url: ie_edge(safari),
        keyword: ie_11up,
        self: ie_edge(ie_11up),
        null: ie_edge(ie_11up),
        atom: ie_edge(ie_11up),
        unit: ie_edge(ie_11up),
        modifier: ie_edge(ie_11up),
        operatorKeyword: ie_edge(ie_11up),
        controlKeyword: ie_edge(ie_11up),
        definitionKeyword: ie_edge(ie_11up),
        moduleKeyword: ie_edge(ie_11up),
        operator: operator,
        derefOperator: ie_edge(operator),
        arithmeticOperator: ie_edge(operator),
        logicOperator: ie_edge(operator),
        bitwiseOperator: ie_edge(operator),
        compareOperator: ie_edge(operator),
        updateOperator: ie_edge(operator),
        definitionOperator: ie_edge(operator),
        typeOperator: ie_edge(operator),
        controlOperator: ie_edge(operator),
        punctuation: punctuation,
        separator: ie_edge(punctuation),
        bracket: bracket,
        angleBracket: ie_edge(bracket),
        squareBracket: ie_edge(bracket),
        paren: ie_edge(bracket),
        brace: ie_edge(bracket),
        content: ie,
        heading: ie_upto10,
        heading1: ie_edge(ie_upto10),
        heading2: ie_edge(ie_upto10),
        heading3: ie_edge(ie_upto10),
        heading4: ie_edge(ie_upto10),
        heading5: ie_edge(ie_upto10),
        heading6: ie_edge(ie_upto10),
        contentSeparator: ie_edge(ie),
        list: ie_edge(ie),
        quote: ie_edge(ie),
        emphasis: ie_edge(ie),
        strong: ie_edge(ie),
        link: ie_edge(ie),
        monospace: ie_edge(ie),
        strikethrough: ie_edge(ie),
        inserted: ie_edge(),
        deleted: ie_edge(),
        changed: ie_edge(),
        invalid: ie_edge(),
        meta: meta,
        documentMeta: ie_edge(meta),
        annotation: ie_edge(meta),
        processingInstruction: ie_edge(meta),
        definition: Tag.defineModifier(),
        constant: Tag.defineModifier(),
        function: Tag.defineModifier(),
        standard: Tag.defineModifier(),
        local: Tag.defineModifier(),
        special: Tag.defineModifier()
    }, languageDataProp = (tagHighlighter([ {
        tag: tags$1.link,
        class: "tok-link"
    }, {
        tag: tags$1.heading,
        class: "tok-heading"
    }, {
        tag: tags$1.emphasis,
        class: "tok-emphasis"
    }, {
        tag: tags$1.strong,
        class: "tok-strong"
    }, {
        tag: tags$1.keyword,
        class: "tok-keyword"
    }, {
        tag: tags$1.atom,
        class: "tok-atom"
    }, {
        tag: tags$1.bool,
        class: "tok-bool"
    }, {
        tag: tags$1.url,
        class: "tok-url"
    }, {
        tag: tags$1.labelName,
        class: "tok-labelName"
    }, {
        tag: tags$1.inserted,
        class: "tok-inserted"
    }, {
        tag: tags$1.deleted,
        class: "tok-deleted"
    }, {
        tag: tags$1.literal,
        class: "tok-literal"
    }, {
        tag: tags$1.string,
        class: "tok-string"
    }, {
        tag: tags$1.number,
        class: "tok-number"
    }, {
        tag: [ tags$1.regexp, tags$1.escape, tags$1.special(tags$1.string) ],
        class: "tok-string2"
    }, {
        tag: tags$1.variableName,
        class: "tok-variableName"
    }, {
        tag: tags$1.local(tags$1.variableName),
        class: "tok-variableName tok-local"
    }, {
        tag: tags$1.definition(tags$1.variableName),
        class: "tok-variableName tok-definition"
    }, {
        tag: tags$1.special(tags$1.variableName),
        class: "tok-variableName2"
    }, {
        tag: tags$1.definition(tags$1.propertyName),
        class: "tok-propertyName tok-definition"
    }, {
        tag: tags$1.typeName,
        class: "tok-typeName"
    }, {
        tag: tags$1.namespace,
        class: "tok-namespace"
    }, {
        tag: tags$1.className,
        class: "tok-className"
    }, {
        tag: tags$1.macroName,
        class: "tok-macroName"
    }, {
        tag: tags$1.propertyName,
        class: "tok-propertyName"
    }, {
        tag: tags$1.operator,
        class: "tok-operator"
    }, {
        tag: tags$1.comment,
        class: "tok-comment"
    }, {
        tag: tags$1.meta,
        class: "tok-meta"
    }, {
        tag: tags$1.invalid,
        class: "tok-invalid"
    }, {
        tag: tags$1.punctuation,
        class: "tok-punctuation"
    } ]), new NodeProp());
    function defineLanguageFacet(baseData) {
        return Facet.define({
            combine: baseData ? values => values.concat(baseData) : void 0
        });
    }
    const sublanguageProp = new NodeProp();
    class Language {
        constructor(data, parser, extraExtensions = [], name = "") {
            this.data = data, this.name = name, EditorState.prototype.hasOwnProperty("tree") || Object.defineProperty(EditorState.prototype, "tree", {
                get() {
                    return syntaxTree(this);
                }
            }), this.parser = parser, this.extension = [ language.of(this), EditorState.languageData.of((state, pos, side) => {
                var top = topNodeAt(state, pos, side), data = top.type.prop(languageDataProp);
                if (!data) return [];
                var base = state.facet(data), data = top.type.prop(sublanguageProp);
                if (data) {
                    var sublang, innerNode = top.resolve(pos - top.from, side);
                    for (sublang of data) if (sublang.test(innerNode, state)) {
                        let data = state.facet(sublang.facet);
                        return "replace" == sublang.type ? data : data.concat(base);
                    }
                }
                return base;
            }) ].concat(extraExtensions);
        }
        isActiveAt(state, pos, side = -1) {
            return topNodeAt(state, pos, side).type.prop(languageDataProp) == this.data;
        }
        findRegions(state) {
            var lang = state.facet(language);
            if ((null == lang ? void 0 : lang.data) == this.data) return [ {
                from: 0,
                to: state.doc.length
            } ];
            if (!lang || !lang.allowsNesting) return [];
            let result = [], explore = (tree, from) => {
                if (tree.prop(languageDataProp) == this.data) result.push({
                    from: from,
                    to: from + tree.length
                }); else {
                    var mount = tree.prop(NodeProp.mounted);
                    if (mount) {
                        if (mount.tree.prop(languageDataProp) == this.data) {
                            if (mount.overlay) for (var r of mount.overlay) result.push({
                                from: r.from + from,
                                to: r.to + from
                            }); else result.push({
                                from: from,
                                to: from + tree.length
                            });
                            return;
                        }
                        if (mount.overlay) {
                            var size = result.length;
                            if (explore(mount.tree, mount.overlay[0].from + from), 
                            result.length > size) return;
                        }
                    }
                    for (let i = 0; i < tree.children.length; i++) {
                        var ch = tree.children[i];
                        ch instanceof Tree && explore(ch, tree.positions[i] + from);
                    }
                }
            };
            return explore(syntaxTree(state), 0), result;
        }
        get allowsNesting() {
            return !0;
        }
    }
    function topNodeAt(state, pos, side) {
        let topLang = state.facet(language), tree = syntaxTree(state).topNode;
        if (!topLang || topLang.allowsNesting) for (let node = tree; node; node = node.enter(pos, side, IterMode.ExcludeBuffers)) node.type.isTop && (tree = node);
        return tree;
    }
    Language.setState = StateEffect.define();
    class LRLanguage extends Language {
        constructor(data, parser, name) {
            super(data, parser, [], name), this.parser = parser;
        }
        static define(spec) {
            let data = defineLanguageFacet(spec.languageData);
            return new LRLanguage(data, spec.parser.configure({
                props: [ languageDataProp.add(type => type.isTop ? data : void 0) ]
            }), spec.name);
        }
        configure(options, name) {
            return new LRLanguage(this.data, this.parser.configure(options), name || this.name);
        }
        get allowsNesting() {
            return this.parser.hasWrappers();
        }
    }
    function syntaxTree(state) {
        state = state.field(Language.state, !1);
        return state ? state.tree : Tree.empty;
    }
    class DocInput {
        constructor(doc) {
            this.doc = doc, this.cursorPos = 0, this.string = "", this.cursor = doc.iter();
        }
        get length() {
            return this.doc.length;
        }
        syncTo(pos) {
            return this.string = this.cursor.next(pos - this.cursorPos).value, this.cursorPos = pos + this.string.length, 
            this.cursorPos - this.string.length;
        }
        chunk(pos) {
            return this.syncTo(pos), this.string;
        }
        get lineChunks() {
            return !0;
        }
        read(from, to) {
            var stringStart = this.cursorPos - this.string.length;
            return from < stringStart || to >= this.cursorPos ? this.doc.sliceString(from, to) : this.string.slice(from - stringStart, to - stringStart);
        }
    }
    let currentContext = null;
    class ParseContext {
        constructor(parser, state, fragments = [], tree, treeLen, viewport, skipped, scheduleOn) {
            this.parser = parser, this.state = state, this.fragments = fragments, 
            this.tree = tree, this.treeLen = treeLen, this.viewport = viewport, 
            this.skipped = skipped, this.scheduleOn = scheduleOn, this.parse = null, 
            this.tempSkipped = [];
        }
        static create(parser, state, viewport) {
            return new ParseContext(parser, state, [], Tree.empty, 0, viewport, [], null);
        }
        startParse() {
            return this.parser.startParse(new DocInput(this.state.doc), this.fragments);
        }
        work(until, upto) {
            return null != upto && upto >= this.state.doc.length && (upto = void 0), 
            this.tree != Tree.empty && this.isDone(null != upto ? upto : this.state.doc.length) ? (this.takeTree(), 
            !0) : this.withContext(() => {
                var _a;
                if ("number" == typeof until) {
                    let endTime = Date.now() + until;
                    until = () => Date.now() > endTime;
                }
                for (this.parse || (this.parse = this.startParse()), null != upto && (null == this.parse.stoppedAt || this.parse.stoppedAt > upto) && upto < this.state.doc.length && this.parse.stopAt(upto); ;) {
                    var done = this.parse.advance();
                    if (done) {
                        if (this.fragments = this.withoutTempSkipped(TreeFragment.addTree(done, this.fragments, null != this.parse.stoppedAt)), 
                        this.treeLen = null != (_a = this.parse.stoppedAt) ? _a : this.state.doc.length, 
                        this.tree = done, this.parse = null, !(this.treeLen < (null != upto ? upto : this.state.doc.length))) return !0;
                        this.parse = this.startParse();
                    }
                    if (until()) return !1;
                }
            });
        }
        takeTree() {
            let pos, tree;
            this.parse && (pos = this.parse.parsedPos) >= this.treeLen && ((null == this.parse.stoppedAt || this.parse.stoppedAt > pos) && this.parse.stopAt(pos), 
            this.withContext(() => {
                for (;!(tree = this.parse.advance()); );
            }), this.treeLen = pos, this.tree = tree, this.fragments = this.withoutTempSkipped(TreeFragment.addTree(this.tree, this.fragments, !0)), 
            this.parse = null);
        }
        withContext(f) {
            var prev = currentContext;
            currentContext = this;
            try {
                return f();
            } finally {
                currentContext = prev;
            }
        }
        withoutTempSkipped(fragments) {
            for (var r; r = this.tempSkipped.pop(); ) fragments = cutFragments(fragments, r.from, r.to);
            return fragments;
        }
        changes(changes, newState) {
            let {
                fragments,
                tree,
                treeLen,
                viewport,
                skipped
            } = this;
            if (this.takeTree(), !changes.empty) {
                let ranges = [];
                if (changes.iterChangedRanges((fromA, toA, fromB, toB) => ranges.push({
                    fromA: fromA,
                    toA: toA,
                    fromB: fromB,
                    toB: toB
                })), fragments = TreeFragment.applyChanges(fragments, ranges), tree = Tree.empty, 
                treeLen = 0, viewport = {
                    from: changes.mapPos(viewport.from, -1),
                    to: changes.mapPos(viewport.to, 1)
                }, this.skipped.length) {
                    skipped = [];
                    for (var r of this.skipped) {
                        var from = changes.mapPos(r.from, 1), r = changes.mapPos(r.to, -1);
                        from < r && skipped.push({
                            from: from,
                            to: r
                        });
                    }
                }
            }
            return new ParseContext(this.parser, newState, fragments, tree, treeLen, viewport, skipped, this.scheduleOn);
        }
        updateViewport(viewport) {
            if (this.viewport.from == viewport.from && this.viewport.to == viewport.to) return !1;
            this.viewport = viewport;
            var startLen = this.skipped.length;
            for (let i = 0; i < this.skipped.length; i++) {
                var {
                    from,
                    to
                } = this.skipped[i];
                from < viewport.to && to > viewport.from && (this.fragments = cutFragments(this.fragments, from, to), 
                this.skipped.splice(i--, 1));
            }
            return !(this.skipped.length >= startLen || (this.reset(), 0));
        }
        reset() {
            this.parse && (this.takeTree(), this.parse = null);
        }
        skipUntilInView(from, to) {
            this.skipped.push({
                from: from,
                to: to
            });
        }
        static getSkippingParser(until) {
            return new class extends Parser {
                createParse(input, fragments, ranges) {
                    let from = ranges[0].from, to = ranges[ranges.length - 1].to;
                    return {
                        parsedPos: from,
                        advance() {
                            var cx = currentContext;
                            if (cx) {
                                for (var r of ranges) cx.tempSkipped.push(r);
                                until && (cx.scheduleOn = cx.scheduleOn ? Promise.all([ cx.scheduleOn, until ]) : until);
                            }
                            return this.parsedPos = to, new Tree(NodeType.none, [], [], to - from);
                        },
                        stoppedAt: null,
                        stopAt() {}
                    };
                }
            }();
        }
        isDone(upto) {
            upto = Math.min(upto, this.state.doc.length);
            var frags = this.fragments;
            return this.treeLen >= upto && frags.length && 0 == frags[0].from && frags[0].to >= upto;
        }
        static get() {
            return currentContext;
        }
    }
    function cutFragments(fragments, from, to) {
        return TreeFragment.applyChanges(fragments, [ {
            fromA: from,
            toA: to,
            fromB: from,
            toB: to
        } ]);
    }
    class LanguageState {
        constructor(context) {
            this.context = context, this.tree = context.tree;
        }
        apply(tr) {
            var newCx;
            return tr.docChanged || this.tree != this.context.tree ? (newCx = this.context.changes(tr.changes, tr.state), 
            tr = this.context.treeLen == tr.startState.doc.length ? void 0 : Math.max(tr.changes.mapPos(this.context.treeLen), newCx.viewport.to), 
            newCx.work(20, tr) || newCx.takeTree(), new LanguageState(newCx)) : this;
        }
        static init(state) {
            var vpTo = Math.min(3e3, state.doc.length), state = ParseContext.create(state.facet(language).parser, state, {
                from: 0,
                to: vpTo
            });
            return state.work(20, vpTo) || state.takeTree(), new LanguageState(state);
        }
    }
    Language.state = StateField.define({
        create: LanguageState.init,
        update(value, tr) {
            for (var e of tr.effects) if (e.is(Language.setState)) return e.value;
            return tr.startState.facet(language) != tr.state.facet(language) ? LanguageState.init(tr.state) : value.apply(tr);
        }
    });
    let requestIdle = callback => {
        let timeout = setTimeout(() => callback(), 500);
        return () => clearTimeout(timeout);
    };
    "undefined" != typeof requestIdleCallback && (requestIdle = callback => {
        let idle = -1, timeout = setTimeout(() => {
            idle = requestIdleCallback(callback, {
                timeout: 400
            });
        }, 100);
        return () => idle < 0 ? clearTimeout(timeout) : cancelIdleCallback(idle);
    });
    const isInputPending = "undefined" != typeof navigator && null != (gecko = navigator.scheduling) && gecko.isInputPending ? () => navigator.scheduling.isInputPending() : null, parseWorker = ViewPlugin.fromClass(class {
        constructor(view) {
            this.view = view, this.working = null, this.workScheduled = 0, this.chunkEnd = -1, 
            this.chunkBudget = -1, this.work = this.work.bind(this), this.scheduleWork();
        }
        update(update) {
            var cx = this.view.state.field(Language.state).context;
            (cx.updateViewport(update.view.viewport) || this.view.viewport.to > cx.treeLen) && this.scheduleWork(), 
            (update.docChanged || update.selectionSet) && (this.view.hasFocus && (this.chunkBudget += 50), 
            this.scheduleWork()), this.checkAsyncSchedule(cx);
        }
        scheduleWork() {
            var state, field;
            this.working || (state = this.view["state"], (field = state.field(Language.state)).tree == field.context.tree && field.context.isDone(state.doc.length)) || (this.working = requestIdle(this.work));
        }
        work(deadline) {
            this.working = null;
            var now = Date.now();
            if (this.chunkEnd < now && (this.chunkEnd < 0 || this.view.hasFocus) && (this.chunkEnd = now + 3e4, 
            this.chunkBudget = 3e3), !(this.chunkBudget <= 0)) {
                var {
                    state,
                    viewport: {
                        to: vpTo
                    }
                } = this.view, field = state.field(Language.state);
                if (field.tree != field.context.tree || !field.context.isDone(vpTo + 1e5)) {
                    let endTime = Date.now() + Math.min(this.chunkBudget, 100, deadline && !isInputPending ? Math.max(25, deadline.timeRemaining() - 5) : 1e9);
                    deadline = field.context.treeLen < vpTo && state.doc.length > vpTo + 1e3, 
                    state = field.context.work(() => isInputPending && isInputPending() || Date.now() > endTime, vpTo + (deadline ? 0 : 1e5));
                    this.chunkBudget -= Date.now() - now, (state || this.chunkBudget <= 0) && (field.context.takeTree(), 
                    this.view.dispatch({
                        effects: Language.setState.of(new LanguageState(field.context))
                    })), 0 < this.chunkBudget && (!state || deadline) && this.scheduleWork(), 
                    this.checkAsyncSchedule(field.context);
                }
            }
        }
        checkAsyncSchedule(cx) {
            cx.scheduleOn && (this.workScheduled++, cx.scheduleOn.then(() => this.scheduleWork()).catch(err => logException(this.view.state, err)).then(() => this.workScheduled--), 
            cx.scheduleOn = null);
        }
        destroy() {
            this.working && this.working();
        }
        isWorking() {
            return !!(this.working || 0 < this.workScheduled);
        }
    }, {
        eventHandlers: {
            focus() {
                this.scheduleWork();
            }
        }
    }), language = Facet.define({
        combine(languages) {
            return languages.length ? languages[0] : null;
        },
        enables: language => [ Language.state, parseWorker, EditorView.contentAttributes.compute([ language ], state => {
            state = state.facet(language);
            return state && state.name ? {
                "data-language": state.name
            } : {};
        }) ]
    });
    class LanguageSupport {
        constructor(language, support = []) {
            this.language = language, this.support = support, this.extension = [ language, support ];
        }
    }
    class LanguageDescription {
        constructor(name, alias, extensions, filename, loadFunc, support = void 0) {
            this.name = name, this.alias = alias, this.extensions = extensions, 
            this.filename = filename, this.loadFunc = loadFunc, this.support = support, 
            this.loading = null;
        }
        load() {
            return this.loading || (this.loading = this.loadFunc().then(support => this.support = support, err => {
                throw this.loading = null, err;
            }));
        }
        static of(spec) {
            let {
                load,
                support
            } = spec;
            if (!load) {
                if (!support) throw new RangeError("Must pass either 'load' or 'support' to LanguageDescription.of");
                load = () => Promise.resolve(support);
            }
            return new LanguageDescription(spec.name, (spec.alias || []).concat(spec.name).map(s => s.toLowerCase()), spec.extensions || [], spec.filename, load, support);
        }
        static matchFilename(descs, filename) {
            for (var d of descs) if (d.filename && d.filename.test(filename)) return d;
            var ext = /\.([^.]+)$/.exec(filename);
            if (ext) for (let d of descs) if (-1 < d.extensions.indexOf(ext[1])) return d;
            return null;
        }
        static matchLanguageName(descs, name, fuzzy = !0) {
            name = name.toLowerCase();
            for (var d of descs) if (d.alias.some(a => a == name)) return d;
            if (fuzzy) for (let d of descs) for (var a of d.alias) {
                var found = name.indexOf(a);
                if (-1 < found && (2 < a.length || !/\w/.test(name[found - 1]) && !/\w/.test(name[found + a.length]))) return d;
            }
            return null;
        }
    }
    const indentService = Facet.define(), indentUnit = Facet.define({
        combine: values => {
            if (!values.length) return "  ";
            let unit = values[0];
            if (!unit || /\S/.test(unit) || Array.from(unit).some(e => e != unit[0])) throw new Error("Invalid indent unit: " + JSON.stringify(values[0]));
            return unit;
        }
    });
    function getIndentUnit(state) {
        var unit = state.facet(indentUnit);
        return 9 == unit.charCodeAt(0) ? state.tabSize * unit.length : unit.length;
    }
    function indentString(state, cols) {
        let result = "", ts = state.tabSize, ch = state.facet(indentUnit)[0];
        if ("\t" == ch) {
            for (;ts <= cols; ) result += "\t", cols -= ts;
            ch = " ";
        }
        for (let i = 0; i < cols; i++) result += ch;
        return result;
    }
    function getIndentation(context, pos) {
        for (var service of (context = context instanceof EditorState ? new IndentContext(context) : context).state.facet(indentService)) {
            service = service(context, pos);
            if (void 0 !== service) return service;
        }
        var tree = syntaxTree(context.state);
        return tree.length >= pos ? function(cx, ast, pos) {
            let stack = ast.resolveStack(pos), inner = stack.node.enterUnfinishedNodesBefore(pos);
            if (inner != stack.node) {
                var add = [];
                for (let cur = inner; cur != stack.node; cur = cur.parent) add.push(cur);
                for (let i = add.length - 1; 0 <= i; i--) stack = {
                    node: add[i],
                    next: stack
                };
            }
            return indentFor(stack, cx, pos);
        }(context, tree, pos) : null;
    }
    class IndentContext {
        constructor(state, options = {}) {
            this.state = state, this.options = options, this.unit = getIndentUnit(state);
        }
        lineAt(pos, bias = 1) {
            var line = this.state.doc.lineAt(pos), {
                simulateBreak,
                simulateDoubleBreak
            } = this.options;
            return null != simulateBreak && simulateBreak >= line.from && simulateBreak <= line.to ? simulateDoubleBreak && simulateBreak == pos ? {
                text: "",
                from: pos
            } : (bias < 0 ? simulateBreak < pos : simulateBreak <= pos) ? {
                text: line.text.slice(simulateBreak - line.from),
                from: simulateBreak
            } : {
                text: line.text.slice(0, simulateBreak - line.from),
                from: line.from
            } : line;
        }
        textAfterPos(pos, bias = 1) {
            var from;
            return this.options.simulateDoubleBreak && pos == this.options.simulateBreak ? "" : ({
                text: bias,
                from
            } = this.lineAt(pos, bias), bias.slice(pos - from, Math.min(bias.length, pos + 100 - from)));
        }
        column(pos, bias = 1) {
            var {
                text: bias,
                from
            } = this.lineAt(pos, bias);
            let result = this.countColumn(bias, pos - from);
            pos = this.options.overrideIndentation ? this.options.overrideIndentation(from) : -1;
            return -1 < pos && (result += pos - this.countColumn(bias, bias.search(/\S|$/))), 
            result;
        }
        countColumn(line, pos = line.length) {
            return countColumn(line, this.state.tabSize, pos);
        }
        lineIndent(pos, bias = 1) {
            var {
                text: pos,
                from: bias
            } = this.lineAt(pos, bias), override = this.options.overrideIndentation;
            if (override) {
                override = override(bias);
                if (-1 < override) return override;
            }
            return this.countColumn(pos, pos.search(/\S|$/));
        }
        get simulatedBreak() {
            return this.options.simulateBreak || null;
        }
    }
    const indentNodeProp = new NodeProp();
    function indentFor(stack, cx, pos) {
        for (let cur = stack; cur; cur = cur.next) {
            var strategy = function(tree) {
                var strategy = tree.type.prop(indentNodeProp);
                if (strategy) return strategy;
                let first = tree.firstChild, close;
                if (first && (close = first.type.prop(NodeProp.closedBy))) {
                    let last = tree.lastChild, closed = last && -1 < close.indexOf(last.name);
                    return cx => delimitedStrategy(cx, !0, 1, void 0, closed && !function(cx) {
                        return cx.pos == cx.options.simulateBreak && cx.options.simulateDoubleBreak;
                    }(cx) ? last.from : void 0);
                }
                return null == tree.parent ? topIndent : null;
            }(cur.node);
            if (strategy) return strategy(TreeIndentContext.create(cx, pos, cur));
        }
        return 0;
    }
    function topIndent() {
        return 0;
    }
    class TreeIndentContext extends IndentContext {
        constructor(base, pos, context) {
            super(base.state, base.options), this.base = base, this.pos = pos, this.context = context;
        }
        get node() {
            return this.context.node;
        }
        static create(base, pos, context) {
            return new TreeIndentContext(base, pos, context);
        }
        get textAfter() {
            return this.textAfterPos(this.pos);
        }
        get baseIndent() {
            return this.baseIndentFor(this.node);
        }
        baseIndentFor(node) {
            let line = this.state.doc.lineAt(node.from);
            for (;;) {
                let atBreak = node.resolve(line.from);
                for (;atBreak.parent && atBreak.parent.from == atBreak.from; ) atBreak = atBreak.parent;
                if (function(parent, of) {
                    for (let cur = of; cur; cur = cur.parent) if (parent == cur) return 1;
                    return;
                }(atBreak, node)) break;
                line = this.state.doc.lineAt(atBreak.from);
            }
            return this.lineIndent(line.from);
        }
        continue() {
            return indentFor(this.context.next, this.base, this.pos);
        }
    }
    function delimitedIndent({
        closing,
        align = !0,
        units = 1
    }) {
        return context => delimitedStrategy(context, align, units, closing);
    }
    function delimitedStrategy(context, align, units, closing, closedAt) {
        var after = context.textAfter, space = after.match(/^\s*/)[0].length, after = closing && after.slice(space, space + closing.length) == closing || closedAt == context.pos + space, closing = align ? function(context) {
            var tree = context.node, openToken = tree.childAfter(tree.from), last = tree.lastChild;
            if (!openToken) return null;
            var sim = context.options.simulateBreak, context = context.state.doc.lineAt(openToken.from), lineEnd = null == sim || sim <= context.from ? context.to : Math.min(context.to, sim);
            for (let pos = openToken.to; ;) {
                var next = tree.childAfter(pos);
                if (!next || next == last) return null;
                if (!next.type.isSkipped) return next.from < lineEnd ? openToken : null;
                pos = next.to;
            }
        }(context) : null;
        return closing ? after ? context.column(closing.from) : context.column(closing.to) : context.baseIndent + (after ? 0 : context.unit * units);
    }
    function continuedIndent({
        except,
        units = 1
    } = {}) {
        return context => {
            var matchExcept = except && except.test(context.textAfter);
            return context.baseIndent + (matchExcept ? 0 : units * context.unit);
        };
    }
    const foldService = Facet.define(), foldNodeProp = new NodeProp();
    function foldInside(node) {
        var first = node.firstChild, last = node.lastChild;
        return first && first.to < last.from ? {
            from: first.to,
            to: last.type.isError ? node.to : last.from
        } : null;
    }
    function foldable(state, lineStart, lineEnd) {
        for (var service of state.facet(foldService)) {
            service = service(state, lineStart, lineEnd);
            if (service) return service;
        }
        return function(state, start, end) {
            var ch, tree = syntaxTree(state);
            if (tree.length < end) return null;
            let found = null;
            for (let iter = tree.resolveStack(end, 1); iter; iter = iter.next) {
                var cur = iter.node;
                if (!(cur.to <= end || cur.from > end)) {
                    if (found && cur.from < start) break;
                    var node, prop = cur.type.prop(foldNodeProp);
                    prop && (cur.to < tree.length - 50 || tree.length == state.doc.length || (ch = void 0, 
                    !(ch = (node = cur).lastChild)) || ch.to != node.to || !ch.type.isError) && (node = prop(cur, state)) && node.from <= end && node.from >= start && node.to > end && (found = node);
                }
            }
            return found;
        }(state, lineStart, lineEnd);
    }
    function mapRange(range, mapping) {
        var from = mapping.mapPos(range.from, 1), mapping = mapping.mapPos(range.to, -1);
        return mapping <= from ? void 0 : {
            from: from,
            to: mapping
        };
    }
    const foldEffect = StateEffect.define({
        map: mapRange
    }), unfoldEffect = StateEffect.define({
        map: mapRange
    });
    function selectedLines(view) {
        var lines = [];
        for (let {
            head
        } of view.state.selection.ranges) lines.some(l => l.from <= head && l.to >= head) || lines.push(view.lineBlockAt(head));
        return lines;
    }
    const foldState = StateField.define({
        create() {
            return Decoration.none;
        },
        update(folded, tr) {
            folded = folded.map(tr.changes);
            for (let e of tr.effects) {
                var preparePlaceholder;
                e.is(foldEffect) && !function(folded, from, to) {
                    let found = !1;
                    return folded.between(from, from, (a, b) => {
                        a == from && b == to && (found = !0);
                    }), found;
                }(folded, e.value.from, e.value.to) ? (preparePlaceholder = tr.state.facet(foldConfig)["preparePlaceholder"], 
                preparePlaceholder = preparePlaceholder ? Decoration.replace({
                    widget: new PreparedFoldWidget(preparePlaceholder(tr.state, e.value))
                }) : foldWidget, folded = folded.update({
                    add: [ preparePlaceholder.range(e.value.from, e.value.to) ]
                })) : e.is(unfoldEffect) && (folded = folded.update({
                    filter: (from, to) => e.value.from != from || e.value.to != to,
                    filterFrom: e.value.from,
                    filterTo: e.value.to
                }));
            }
            if (tr.selection) {
                let onSelection = !1, head = tr.selection.main["head"];
                folded.between(head, head, (a, b) => {
                    a < head && b > head && (onSelection = !0);
                }), onSelection && (folded = folded.update({
                    filterFrom: head,
                    filterTo: head,
                    filter: (a, b) => b <= head || a >= head
                }));
            }
            return folded;
        },
        provide: f => EditorView.decorations.from(f),
        toJSON(folded, state) {
            let ranges = [];
            return folded.between(0, state.doc.length, (from, to) => {
                ranges.push(from, to);
            }), ranges;
        },
        fromJSON(value) {
            if (!Array.isArray(value) || value.length % 2) throw new RangeError("Invalid JSON for fold state");
            var ranges = [];
            for (let i = 0; i < value.length; ) {
                var from = value[i++], to = value[i++];
                if ("number" != typeof from || "number" != typeof to) throw new RangeError("Invalid JSON for fold state");
                ranges.push(foldWidget.range(from, to));
            }
            return Decoration.set(ranges, !0);
        }
    });
    function findFold(state, from, to) {
        let found = null;
        return null != (state = state.field(foldState, !1)) && state.between(from, to, (from, to) => {
            (!found || found.from > from) && (found = {
                from: from,
                to: to
            });
        }), found;
    }
    function maybeEnable(state, other) {
        return state.field(foldState, !1) ? other : other.concat(StateEffect.appendConfig.of(codeFolding()));
    }
    function announceFold(view, range, fold = !0) {
        var lineFrom = view.state.doc.lineAt(range.from).number, range = view.state.doc.lineAt(range.to).number;
        return EditorView.announce.of(`${view.state.phrase(fold ? "Folded lines" : "Unfolded lines")} ${lineFrom} ${view.state.phrase("to")} ${range}.`);
    }
    ios = [ {
        key: "Ctrl-Shift-[",
        mac: "Cmd-Alt-[",
        run: view => {
            for (var line of selectedLines(view)) {
                line = foldable(view.state, line.from, line.to);
                if (line) return view.dispatch({
                    effects: maybeEnable(view.state, [ foldEffect.of(line), announceFold(view, line) ])
                }), !0;
            }
            return !1;
        }
    }, {
        key: "Ctrl-Shift-]",
        mac: "Cmd-Alt-]",
        run: view => {
            if (!view.state.field(foldState, !1)) return !1;
            var line, effects = [];
            for (line of selectedLines(view)) {
                var folded = findFold(view.state, line.from, line.to);
                folded && effects.push(unfoldEffect.of(folded), announceFold(view, folded, !1));
            }
            return effects.length && view.dispatch({
                effects: effects
            }), 0 < effects.length;
        }
    }, {
        key: "Ctrl-Alt-[",
        run: view => {
            var state = view["state"], effects = [];
            for (let pos = 0; pos < state.doc.length; ) {
                var line = view.lineBlockAt(pos), range = foldable(state, line.from, line.to);
                range && effects.push(foldEffect.of(range)), pos = (range ? view.lineBlockAt(range.to) : line).to + 1;
            }
            return effects.length && view.dispatch({
                effects: maybeEnable(view.state, effects)
            }), !!effects.length;
        }
    }, {
        key: "Ctrl-Alt-]",
        run: view => {
            var field = view.state.field(foldState, !1);
            if (!field || !field.size) return !1;
            let effects = [];
            return field.between(0, view.state.doc.length, (from, to) => {
                effects.push(unfoldEffect.of({
                    from: from,
                    to: to
                }));
            }), view.dispatch({
                effects: effects
            }), !0;
        }
    } ];
    const defaultConfig = {
        placeholderDOM: null,
        preparePlaceholder: null,
        placeholderText: "\u2026"
    }, foldConfig = Facet.define({
        combine(values) {
            return combineConfig(values, defaultConfig);
        }
    });
    function codeFolding() {
        return [ foldState, baseTheme$1$1 ];
    }
    function widgetToDOM(view, prepared) {
        var state = view["state"], conf = state.facet(foldConfig), onclick = event => {
            var line = view.lineBlockAt(view.posAtDOM(event.target)), line = findFold(view.state, line.from, line.to);
            line && view.dispatch({
                effects: unfoldEffect.of(line)
            }), event.preventDefault();
        };
        return conf.placeholderDOM ? conf.placeholderDOM(view, onclick, prepared) : ((prepared = document.createElement("span")).textContent = conf.placeholderText, 
        prepared.setAttribute("aria-label", state.phrase("folded code")), prepared.title = state.phrase("unfold"), 
        prepared.className = "cm-foldPlaceholder", prepared.onclick = onclick, prepared);
    }
    const foldWidget = Decoration.replace({
        widget: new class extends WidgetType {
            toDOM(view) {
                return widgetToDOM(view, null);
            }
        }()
    });
    class PreparedFoldWidget extends WidgetType {
        constructor(value) {
            super(), this.value = value;
        }
        eq(other) {
            return this.value == other.value;
        }
        toDOM(view) {
            return widgetToDOM(view, this.value);
        }
    }
    const foldGutterDefaults = {
        openText: "\u2304",
        closedText: "\u203a",
        markerDOM: null,
        domEventHandlers: {},
        foldingChanged: () => !1
    };
    class FoldMarker extends GutterMarker {
        constructor(config, open) {
            super(), this.config = config, this.open = open;
        }
        eq(other) {
            return this.config == other.config && this.open == other.open;
        }
        toDOM(view) {
            var span;
            return this.config.markerDOM ? this.config.markerDOM(this.open) : ((span = document.createElement("span")).textContent = this.open ? this.config.openText : this.config.closedText, 
            span.title = view.state.phrase(this.open ? "Fold line" : "Unfold line"), 
            span);
        }
    }
    const baseTheme$1$1 = EditorView.baseTheme({
        ".cm-foldPlaceholder": {
            backgroundColor: "#eee",
            border: "1px solid #ddd",
            color: "#888",
            borderRadius: ".2em",
            margin: "0 1px",
            padding: "0 1px",
            cursor: "pointer"
        },
        ".cm-foldGutter span": {
            padding: "0 1px",
            cursor: "pointer"
        }
    });
    class HighlightStyle {
        constructor(specs, options) {
            this.specs = specs;
            let modSpec;
            function def(spec) {
                var cls = StyleModule.newName();
                return (modSpec = modSpec || Object.create(null))["." + cls] = spec, 
                cls;
            }
            var all = "string" == typeof options.all ? options.all : options.all ? def(options.all) : void 0;
            const scopeOpt = options.scope;
            this.scope = scopeOpt instanceof Language ? type => type.prop(languageDataProp) == scopeOpt.data : scopeOpt ? type => type == scopeOpt : void 0, 
            this.style = tagHighlighter(specs.map(style => ({
                tag: style.tag,
                class: style.class || def(Object.assign({}, style, {
                    tag: null
                }))
            })), {
                all: all
            }).style, this.module = modSpec ? new StyleModule(modSpec) : null, this.themeType = options.themeType;
        }
        static define(specs, options) {
            return new HighlightStyle(specs, options || {});
        }
    }
    const highlighterFacet = Facet.define(), fallbackHighlighter = Facet.define({
        combine(values) {
            return values.length ? [ values[0] ] : null;
        }
    });
    function getHighlighters(state) {
        var main = state.facet(highlighterFacet);
        return main.length ? main : state.facet(fallbackHighlighter);
    }
    function syntaxHighlighting(highlighter, options) {
        let ext = [ treeHighlighter ], themeType;
        return highlighter instanceof HighlightStyle && (highlighter.module && ext.push(EditorView.styleModule.of(highlighter.module)), 
        themeType = highlighter.themeType), null != options && options.fallback ? ext.push(fallbackHighlighter.of(highlighter)) : themeType ? ext.push(highlighterFacet.computeN([ EditorView.darkTheme ], state => state.facet(EditorView.darkTheme) == ("dark" == themeType) ? [ highlighter ] : [])) : ext.push(highlighterFacet.of(highlighter)), 
        ext;
    }
    class TreeHighlighter {
        constructor(view) {
            this.markCache = Object.create(null), this.tree = syntaxTree(view.state), 
            this.decorations = this.buildDeco(view, getHighlighters(view.state)), 
            this.decoratedTo = view.viewport.to;
        }
        update(update) {
            var tree = syntaxTree(update.state), highlighters = getHighlighters(update.state), styleChange = highlighters != getHighlighters(update.startState), viewport = update.view["viewport"], decoratedToMapped = update.changes.mapPos(this.decoratedTo, 1);
            tree.length < viewport.to && !styleChange && tree.type == this.tree.type && decoratedToMapped >= viewport.to ? (this.decorations = this.decorations.map(update.changes), 
            this.decoratedTo = decoratedToMapped) : (tree != this.tree || update.viewportChanged || styleChange) && (this.tree = tree, 
            this.decorations = this.buildDeco(update.view, highlighters), this.decoratedTo = viewport.to);
        }
        buildDeco(view, highlighters) {
            if (!highlighters || !this.tree.length) return Decoration.none;
            let builder = new RangeSetBuilder();
            for (var {
                from,
                to
            } of view.visibleRanges) highlightTree(this.tree, highlighters, (from, to, style) => {
                builder.add(from, to, this.markCache[style] || (this.markCache[style] = Decoration.mark({
                    class: style
                })));
            }, from, to);
            return builder.finish();
        }
    }
    const treeHighlighter = Prec.high(ViewPlugin.fromClass(TreeHighlighter, {
        decorations: v => v.decorations
    }));
    nav = HighlightStyle.define([ {
        tag: tags$1.meta,
        color: "#404740"
    }, {
        tag: tags$1.link,
        textDecoration: "underline"
    }, {
        tag: tags$1.heading,
        textDecoration: "underline",
        fontWeight: "bold"
    }, {
        tag: tags$1.emphasis,
        fontStyle: "italic"
    }, {
        tag: tags$1.strong,
        fontWeight: "bold"
    }, {
        tag: tags$1.strikethrough,
        textDecoration: "line-through"
    }, {
        tag: tags$1.keyword,
        color: "#708"
    }, {
        tag: [ tags$1.atom, tags$1.bool, tags$1.url, tags$1.contentSeparator, tags$1.labelName ],
        color: "#219"
    }, {
        tag: [ tags$1.literal, tags$1.inserted ],
        color: "#164"
    }, {
        tag: [ tags$1.string, tags$1.deleted ],
        color: "#a11"
    }, {
        tag: [ tags$1.regexp, tags$1.escape, tags$1.special(tags$1.string) ],
        color: "#e40"
    }, {
        tag: tags$1.definition(tags$1.variableName),
        color: "#00f"
    }, {
        tag: tags$1.local(tags$1.variableName),
        color: "#30a"
    }, {
        tag: [ tags$1.typeName, tags$1.namespace ],
        color: "#085"
    }, {
        tag: tags$1.className,
        color: "#167"
    }, {
        tag: [ tags$1.special(tags$1.variableName), tags$1.macroName ],
        color: "#256"
    }, {
        tag: tags$1.definition(tags$1.propertyName),
        color: "#00c"
    }, {
        tag: tags$1.comment,
        color: "#940"
    }, {
        tag: tags$1.invalid,
        color: "#f00"
    } ]), chrome = EditorView.baseTheme({
        "&.cm-focused .cm-matchingBracket": {
            backgroundColor: "#328c8252"
        },
        "&.cm-focused .cm-nonmatchingBracket": {
            backgroundColor: "#bb555544"
        }
    });
    const DefaultScanDist = 1e4, DefaultBrackets = "()[]{}", bracketMatchingConfig = Facet.define({
        combine(configs) {
            return combineConfig(configs, {
                afterCursor: !0,
                brackets: DefaultBrackets,
                maxScanDistance: DefaultScanDist,
                renderMatch: defaultRenderMatch
            });
        }
    }), matchingMark = Decoration.mark({
        class: "cm-matchingBracket"
    }), nonmatchingMark = Decoration.mark({
        class: "cm-nonmatchingBracket"
    });
    function defaultRenderMatch(match) {
        var decorations = [], mark = match.matched ? matchingMark : nonmatchingMark;
        return decorations.push(mark.range(match.start.from, match.start.to)), match.end && decorations.push(mark.range(match.end.from, match.end.to)), 
        decorations;
    }
    const bracketMatchingUnique = [ StateField.define({
        create() {
            return Decoration.none;
        },
        update(deco, tr) {
            if (!tr.docChanged && !tr.selection) return deco;
            let decorations = [];
            var range, match, config = tr.state.facet(bracketMatchingConfig);
            for (range of tr.state.selection.ranges) range.empty && (match = matchBrackets(tr.state, range.head, -1, config) || 0 < range.head && matchBrackets(tr.state, range.head - 1, 1, config) || config.afterCursor && (matchBrackets(tr.state, range.head, 1, config) || range.head < tr.state.doc.length && matchBrackets(tr.state, range.head + 1, -1, config))) && (decorations = decorations.concat(config.renderMatch(match, tr.state)));
            return Decoration.set(decorations, !0);
        },
        provide: f => EditorView.decorations.from(f)
    }), chrome ];
    const bracketMatchingHandle = new NodeProp();
    function matchingNodes(node, dir, brackets) {
        var byProp = node.prop(dir < 0 ? NodeProp.openedBy : NodeProp.closedBy);
        if (byProp) return byProp;
        if (1 == node.name.length) {
            byProp = brackets.indexOf(node.name);
            if (-1 < byProp && byProp % 2 == (dir < 0 ? 1 : 0)) return [ brackets[byProp + dir] ];
        }
        return null;
    }
    function findHandle(node) {
        var hasHandle = node.type.prop(bracketMatchingHandle);
        return hasHandle ? hasHandle(node.node) : node;
    }
    function matchBrackets(state, pos, dir, config = {}) {
        var maxScanDistance = config.maxScanDistance || DefaultScanDist, brackets = config.brackets || DefaultBrackets, config = syntaxTree(state), node = config.resolveInner(pos, dir);
        for (let cur = node; cur; cur = cur.parent) {
            var matches = matchingNodes(cur.type, dir, brackets);
            if (matches && cur.from < cur.to) {
                var handle = findHandle(cur);
                if (handle && (0 < dir ? pos >= handle.from && pos < handle.to : pos > handle.from && pos <= handle.to)) return function(dir, token, handle, matching, brackets) {
                    let parent = token.parent, firstToken = {
                        from: handle.from,
                        to: handle.to
                    }, depth = 0, cursor = null == parent ? void 0 : parent.cursor();
                    if (cursor && (dir < 0 ? cursor.childBefore(token.from) : cursor.childAfter(token.to))) do {
                        if (dir < 0 ? cursor.to <= token.from : cursor.from >= token.to) {
                            var endHandle, endHandle;
                            if (0 == depth && -1 < matching.indexOf(cursor.type.name) && cursor.from < cursor.to) return endHandle = findHandle(cursor), 
                            {
                                start: firstToken,
                                end: endHandle ? {
                                    from: endHandle.from,
                                    to: endHandle.to
                                } : void 0,
                                matched: !0
                            };
                            if (matchingNodes(cursor.type, dir, brackets)) depth++; else if (matchingNodes(cursor.type, -dir, brackets)) {
                                if (0 == depth) return endHandle = findHandle(cursor), 
                                {
                                    start: firstToken,
                                    end: endHandle && endHandle.from < endHandle.to ? {
                                        from: endHandle.from,
                                        to: endHandle.to
                                    } : void 0,
                                    matched: !1
                                };
                                depth--;
                            }
                        }
                    } while (dir < 0 ? cursor.prevSibling() : cursor.nextSibling());
                    return {
                        start: firstToken,
                        matched: !1
                    };
                }(dir, cur, handle, matches, brackets);
            }
        }
        return function(state, pos, dir, tree, tokenType, maxScanDistance, brackets) {
            var startCh = dir < 0 ? state.sliceDoc(pos - 1, pos) : state.sliceDoc(pos, pos + 1), bracket = brackets.indexOf(startCh);
            if (bracket < 0 || bracket % 2 == 0 != 0 < dir) return null;
            let startToken = {
                from: dir < 0 ? pos - 1 : pos,
                to: 0 < dir ? pos + 1 : pos
            }, iter = state.doc.iterRange(pos, 0 < dir ? state.doc.length : 0), depth = 0;
            for (let distance = 0; !iter.next().done && distance <= maxScanDistance; ) {
                var text = iter.value, basePos = (dir < 0 && (distance += text.length), 
                pos + distance * dir);
                for (let pos = 0 < dir ? 0 : text.length - 1, end = 0 < dir ? text.length : -1; pos != end; pos += dir) {
                    var found = brackets.indexOf(text[pos]);
                    if (!(found < 0 || tree.resolveInner(basePos + pos, 1).type != tokenType)) if (found % 2 == 0 == 0 < dir) depth++; else {
                        if (1 == depth) return {
                            start: startToken,
                            end: {
                                from: basePos + pos,
                                to: basePos + pos + 1
                            },
                            matched: found >> 1 == bracket >> 1
                        };
                        depth--;
                    }
                }
                0 < dir && (distance += text.length);
            }
            return iter.done ? {
                start: startToken,
                matched: !1
            } : null;
        }(state, pos, dir, config, node.type, maxScanDistance, brackets);
    }
    var noTokens = Object.create(null);
    const typeArray = [ NodeType.none ], warned = [], byTag = Object.create(null);
    var defaultTable = Object.create(null);
    for (let [ legacyName, name ] of [ [ "variable", "variableName" ], [ "variable-2", "variableName.special" ], [ "string-2", "string.special" ], [ "def", "variableName.definition" ], [ "tag", "tagName" ], [ "attribute", "attributeName" ], [ "type", "typeName" ], [ "builtin", "variableName.standard" ], [ "qualifier", "modifier" ], [ "error", "invalid" ], [ "header", "heading" ], [ "property", "propertyName" ] ]) defaultTable[legacyName] = createTokenType(noTokens, name);
    function warnForPart(part, msg) {
        -1 < warned.indexOf(part) || (warned.push(part), console.warn(msg));
    }
    function createTokenType(extra, tagStr) {
        var key, tags$1$1 = [];
        for (let name of tagStr.split(" ")) {
            let found = [];
            for (var part of name.split(".")) {
                var value = extra[part] || tags$1[part];
                value ? "function" == typeof value ? found.length ? found = found.map(value) : warnForPart(part, `Modifier ${part} used at start of tag`) : found.length ? warnForPart(part, `Tag ${part} used as modifier`) : found = Array.isArray(value) ? value : [ value ] : warnForPart(part, "Unknown highlighting tag " + part);
            }
            for (var tag of found) tags$1$1.push(tag);
        }
        return tags$1$1.length ? (key = (tagStr = tagStr.replace(/ /g, "_")) + " " + tags$1$1.map(t => t.id), 
        (byTag[key] || (key = byTag[key] = NodeType.define({
            id: typeArray.length,
            name: tagStr,
            props: [ styleTags({
                [tagStr]: tags$1$1
            }) ]
        }), typeArray.push(key), key)).id) : 0;
    }
    Direction.RTL, Direction.LTR;
    function command(f, option) {
        return ({
            state,
            dispatch
        }) => {
            var tr;
            return !state.readOnly && !!(tr = f(option, state)) && (dispatch(state.update(tr)), 
            !0);
        };
    }
    const toggleLineComment = command(changeLineComment, 0);
    webkit = command(changeBlockComment, 0);
    const toggleBlockCommentByLine = command((o, s) => changeBlockComment(o, s, function(state) {
        var ranges = [];
        for (var r of state.selection.ranges) {
            var fromLine = state.doc.lineAt(r.from), r = r.to <= fromLine.to ? fromLine : state.doc.lineAt(r.to), last = ranges.length - 1;
            0 <= last && ranges[last].to > fromLine.from ? ranges[last].to = r.to : ranges.push({
                from: fromLine.from + /^\s*/.exec(fromLine.text)[0].length,
                to: r.to
            });
        }
        return ranges;
    }(s)), 0);
    function getConfig(state, pos) {
        state = state.languageDataAt("commentTokens", pos);
        return state.length ? state[0] : {};
    }
    const SearchMargin = 50;
    function changeBlockComment(option, state, ranges = state.selection.ranges) {
        let tokens = ranges.map(r => getConfig(state, r.from).block);
        if (tokens.every(c => c)) {
            let comments = ranges.map((r, i) => function(state, {
                open,
                close
            }, from, to) {
                var textBefore = state.sliceDoc(from - SearchMargin, from), textAfter = state.sliceDoc(to, to + SearchMargin), spaceBefore = /\s*$/.exec(textBefore)[0].length, spaceAfter = /^\s*/.exec(textAfter)[0].length, beforeOff = textBefore.length - spaceBefore;
                if (textBefore.slice(beforeOff - open.length, beforeOff) == open && textAfter.slice(spaceAfter, spaceAfter + close.length) == close) return {
                    open: {
                        pos: from - spaceBefore,
                        margin: spaceBefore && 1
                    },
                    close: {
                        pos: to + spaceAfter,
                        margin: spaceAfter && 1
                    }
                };
                let startText, endText;
                return to - from <= 2 * SearchMargin ? startText = endText = state.sliceDoc(from, to) : (startText = state.sliceDoc(from, from + SearchMargin), 
                endText = state.sliceDoc(to - SearchMargin, to)), textBefore = /^\s*/.exec(startText)[0].length, 
                beforeOff = /\s*$/.exec(endText)[0].length, textAfter = endText.length - beforeOff - close.length, 
                startText.slice(textBefore, textBefore + open.length) == open && endText.slice(textAfter, textAfter + close.length) == close ? {
                    open: {
                        pos: from + textBefore + open.length,
                        margin: /\s/.test(startText.charAt(textBefore + open.length)) ? 1 : 0
                    },
                    close: {
                        pos: to - beforeOff - close.length,
                        margin: /\s/.test(endText.charAt(textAfter - 1)) ? 1 : 0
                    }
                } : null;
            }(state, tokens[i], r.from, r.to));
            if (2 != option && !comments.every(c => c)) return {
                changes: state.changes(ranges.map((range, i) => comments[i] ? [] : [ {
                    from: range.from,
                    insert: tokens[i].open + " "
                }, {
                    from: range.to,
                    insert: " " + tokens[i].close
                } ]))
            };
            if (1 != option && comments.some(c => c)) {
                var token, open, close, changes = [];
                for (let i = 0, comment; i < comments.length; i++) (comment = comments[i]) && (token = tokens[i], 
                {
                    open,
                    close
                } = comment, changes.push({
                    from: open.pos - token.open.length,
                    to: open.pos + open.margin
                }, {
                    from: close.pos - close.margin,
                    to: close.pos + token.close.length
                }));
                return {
                    changes: changes
                };
            }
        }
        return null;
    }
    function changeLineComment(option, state, ranges = state.selection.ranges) {
        var from, to, lines = [];
        let prevLine = -1;
        for ({
            from,
            to
        } of ranges) {
            let startI = lines.length, minIndent = 1e9;
            var token = getConfig(state, from).line;
            if (token) {
                for (let pos = from; pos <= to; ) {
                    var indent, empty, comment, line = state.doc.lineAt(pos);
                    line.from > prevLine && (from == to || to > line.from) && (prevLine = line.from, 
                    empty = (indent = /^\s*/.exec(line.text)[0].length) == line.length, 
                    comment = line.text.slice(indent, indent + token.length) == token ? indent : -1, 
                    indent < line.text.length && indent < minIndent && (minIndent = indent), 
                    lines.push({
                        line: line,
                        comment: comment,
                        token: token,
                        indent: indent,
                        empty: empty,
                        single: !1
                    })), pos = line.to + 1;
                }
                if (minIndent < 1e9) for (let i = startI; i < lines.length; i++) lines[i].indent < lines[i].line.text.length && (lines[i].indent = minIndent);
                lines.length == startI + 1 && (lines[startI].single = !0);
            }
        }
        if (2 != option && lines.some(l => l.comment < 0 && (!l.empty || l.single))) {
            var changes = [];
            for (let {
                line,
                token,
                indent,
                empty,
                single
            } of lines) !single && empty || changes.push({
                from: line.from + indent,
                insert: token + " "
            });
            ranges = state.changes(changes);
            return {
                changes: ranges,
                selection: state.selection.map(ranges, 1)
            };
        }
        if (1 != option && lines.some(l => 0 <= l.comment)) {
            let changes = [];
            for (let {
                line,
                comment,
                token
            } of lines) if (0 <= comment) {
                let from = line.from + comment, to = from + token.length;
                " " == line.text[to - line.from] && to++, changes.push({
                    from: from,
                    to: to
                });
            }
            return {
                changes: changes
            };
        }
        return null;
    }
    const fromHistory = Annotation.define(), isolateHistory = Annotation.define(), invertedEffects = Facet.define(), historyConfig = Facet.define({
        combine(configs) {
            return combineConfig(configs, {
                minDepth: 100,
                newGroupDelay: 500,
                joinToEvent: (_t, isAdjacent) => isAdjacent
            }, {
                minDepth: Math.max,
                newGroupDelay: Math.min,
                joinToEvent: (a, b) => (tr, adj) => a(tr, adj) || b(tr, adj)
            });
        }
    }), historyField_ = StateField.define({
        create() {
            return HistoryState.empty;
        },
        update(state, tr) {
            var config = tr.state.facet(historyConfig), fromHist = tr.annotation(fromHistory);
            if (fromHist) {
                var item = HistEvent.fromTransaction(tr, fromHist.selection), from = fromHist.side;
                let other = 0 == from ? state.undone : state.done;
                return other = item ? updateBranch(other, other.length, config.minDepth, item) : addSelection(other, tr.startState.selection), 
                new HistoryState(0 == from ? fromHist.rest : other, 0 == from ? other : fromHist.rest);
            }
            var userEvent, item = tr.annotation(isolateHistory);
            return "full" != item && "before" != item || (state = state.isolate()), 
            !1 === tr.annotation(Transaction.addToHistory) ? tr.changes.empty ? state : state.addMapping(tr.changes.desc) : (from = HistEvent.fromTransaction(tr), 
            fromHist = tr.annotation(Transaction.time), userEvent = tr.annotation(Transaction.userEvent), 
            from ? state = state.addChanges(from, fromHist, userEvent, config, tr) : tr.selection && (state = state.addSelection(tr.startState.selection, fromHist, userEvent, config.newGroupDelay)), 
            "full" != item && "after" != item ? state : state.isolate());
        },
        toJSON(value) {
            return {
                done: value.done.map(e => e.toJSON()),
                undone: value.undone.map(e => e.toJSON())
            };
        },
        fromJSON(json) {
            return new HistoryState(json.done.map(HistEvent.fromJSON), json.undone.map(HistEvent.fromJSON));
        }
    });
    function cmd(side, selection) {
        return function({
            state,
            dispatch
        }) {
            var historyState;
            return !(!selection && state.readOnly || !(historyState = state.field(historyField_, !1)) || !(historyState = historyState.pop(side, state, selection)) || (dispatch(historyState), 
            0));
        };
    }
    const undo = cmd(0, !1), redo = cmd(1, !1);
    doc = cmd(0, !0), safari = cmd(1, !0);
    class HistEvent {
        constructor(changes, effects, mapped, startSelection, selectionsAfter) {
            this.changes = changes, this.effects = effects, this.mapped = mapped, 
            this.startSelection = startSelection, this.selectionsAfter = selectionsAfter;
        }
        setSelAfter(after) {
            return new HistEvent(this.changes, this.effects, this.mapped, this.startSelection, after);
        }
        toJSON() {
            var _a;
            return {
                changes: null == (_a = this.changes) ? void 0 : _a.toJSON(),
                mapped: null == (_a = this.mapped) ? void 0 : _a.toJSON(),
                startSelection: null == (_a = this.startSelection) ? void 0 : _a.toJSON(),
                selectionsAfter: this.selectionsAfter.map(s => s.toJSON())
            };
        }
        static fromJSON(json) {
            return new HistEvent(json.changes && ChangeSet.fromJSON(json.changes), [], json.mapped && ChangeDesc.fromJSON(json.mapped), json.startSelection && EditorSelection.fromJSON(json.startSelection), json.selectionsAfter.map(EditorSelection.fromJSON));
        }
        static fromTransaction(tr, selection) {
            let effects = none$2;
            for (var invert of tr.startState.facet(invertedEffects)) {
                invert = invert(tr);
                invert.length && (effects = effects.concat(invert));
            }
            return !effects.length && tr.changes.empty ? null : new HistEvent(tr.changes.invert(tr.startState.doc), effects, void 0, selection || tr.startState.selection, none$2);
        }
        static selection(selections) {
            return new HistEvent(void 0, none$2, void 0, void 0, selections);
        }
    }
    function updateBranch(branch, to, maxLen, newEvent) {
        branch = branch.slice(maxLen + 20 < to + 1 ? to - maxLen - 1 : 0, to);
        return branch.push(newEvent), branch;
    }
    function conc(a, b) {
        return a.length ? b.length ? a.concat(b) : a : b;
    }
    const none$2 = [], MaxSelectionsPerEvent = 200;
    function addSelection(branch, selection) {
        var lastEvent, sels;
        return branch.length ? (sels = (lastEvent = branch[branch.length - 1]).selectionsAfter.slice(Math.max(0, lastEvent.selectionsAfter.length - MaxSelectionsPerEvent))).length && sels[sels.length - 1].eq(selection) ? branch : (sels.push(selection), 
        updateBranch(branch, branch.length - 1, 1e9, lastEvent.setSelAfter(sels))) : [ HistEvent.selection([ selection ]) ];
    }
    function addMappingToBranch(branch, mapping) {
        if (!branch.length) return branch;
        let length = branch.length, selections = none$2;
        for (;length; ) {
            var result, event = function(event, mapping, extraSelections) {
                extraSelections = conc(event.selectionsAfter.length ? event.selectionsAfter.map(s => s.map(mapping)) : none$2, extraSelections);
                if (!event.changes) return HistEvent.selection(extraSelections);
                var mappedChanges = event.changes.map(mapping), before = mapping.mapDesc(event.changes, !0), fullMapping = event.mapped ? event.mapped.composeDesc(before) : before;
                return new HistEvent(mappedChanges, StateEffect.mapEffects(event.effects, mapping), fullMapping, event.startSelection.map(before), extraSelections);
            }(branch[length - 1], mapping, selections);
            if (event.changes && !event.changes.empty || event.effects.length) return (result = branch.slice(0, length))[length - 1] = event, 
            result;
            mapping = event.mapped, length--, selections = event.selectionsAfter;
        }
        return selections.length ? [ HistEvent.selection(selections) ] : none$2;
    }
    const joinableUserEvent = /^(input\.type|delete)($|\.)/;
    class HistoryState {
        constructor(done, undone, prevTime = 0, prevUserEvent = void 0) {
            this.done = done, this.undone = undone, this.prevTime = prevTime, this.prevUserEvent = prevUserEvent;
        }
        isolate() {
            return this.prevTime ? new HistoryState(this.done, this.undone) : this;
        }
        addChanges(event, time, userEvent, config, tr) {
            let done = this.done, lastEvent = done[done.length - 1];
            return done = lastEvent && lastEvent.changes && !lastEvent.changes.empty && event.changes && (!userEvent || joinableUserEvent.test(userEvent)) && (!lastEvent.selectionsAfter.length && time - this.prevTime < config.newGroupDelay && config.joinToEvent(tr, function(a, b) {
                let ranges = [], isAdjacent = !1;
                return a.iterChangedRanges((f, t) => ranges.push(f, t)), b.iterChangedRanges((_f, _t, f, t) => {
                    for (let i = 0; i < ranges.length; ) {
                        var from = ranges[i++], to = ranges[i++];
                        from <= t && f <= to && (isAdjacent = !0);
                    }
                }), isAdjacent;
            }(lastEvent.changes, event.changes)) || "input.type.compose" == userEvent) ? updateBranch(done, done.length - 1, config.minDepth, new HistEvent(event.changes.compose(lastEvent.changes), conc(event.effects, lastEvent.effects), lastEvent.mapped, lastEvent.startSelection, none$2)) : updateBranch(done, done.length, config.minDepth, event), 
            new HistoryState(done, none$2, time, userEvent);
        }
        addSelection(selection, time, userEvent, newGroupDelay) {
            var b, last = this.done.length ? this.done[this.done.length - 1].selectionsAfter : none$2;
            return 0 < last.length && time - this.prevTime < newGroupDelay && userEvent == this.prevUserEvent && userEvent && /^select($|\.)/.test(userEvent) && (newGroupDelay = last[last.length - 1], 
            b = selection, newGroupDelay.ranges.length == b.ranges.length) && 0 === newGroupDelay.ranges.filter((r, i) => r.empty != b.ranges[i].empty).length ? this : new HistoryState(addSelection(this.done, selection), this.undone, time, userEvent);
        }
        addMapping(mapping) {
            return new HistoryState(addMappingToBranch(this.done, mapping), addMappingToBranch(this.undone, mapping), this.prevTime, this.prevUserEvent);
        }
        pop(side, state, onlySelection) {
            var branch = 0 == side ? this.done : this.undone;
            if (0 != branch.length) {
                var event = branch[branch.length - 1], selection = event.selectionsAfter[0] || state.selection;
                if (onlySelection && event.selectionsAfter.length) return state.update({
                    selection: event.selectionsAfter[event.selectionsAfter.length - 1],
                    annotations: fromHistory.of({
                        side: side,
                        rest: function(branch) {
                            var last = branch[branch.length - 1], newBranch = branch.slice();
                            return newBranch[branch.length - 1] = last.setSelAfter(last.selectionsAfter.slice(0, last.selectionsAfter.length - 1)), 
                            newBranch;
                        }(branch),
                        selection: selection
                    }),
                    userEvent: 0 == side ? "select.undo" : "select.redo",
                    scrollIntoView: !0
                });
                if (event.changes) {
                    let rest = 1 == branch.length ? none$2 : branch.slice(0, branch.length - 1);
                    return event.mapped && (rest = addMappingToBranch(rest, event.mapped)), 
                    state.update({
                        changes: event.changes,
                        selection: event.startSelection,
                        effects: event.effects,
                        annotations: fromHistory.of({
                            side: side,
                            rest: rest,
                            selection: selection
                        }),
                        filter: !1,
                        userEvent: 0 == side ? "undo" : "redo",
                        scrollIntoView: !0
                    });
                }
            }
            return null;
        }
    }
    HistoryState.empty = new HistoryState(none$2, none$2);
    ie_11up = [ {
        key: "Mod-z",
        run: undo,
        preventDefault: !0
    }, {
        key: "Mod-y",
        mac: "Mod-Shift-z",
        run: redo,
        preventDefault: !0
    }, {
        linux: "Ctrl-Shift-z",
        run: redo,
        preventDefault: !0
    }, {
        key: "Mod-u",
        run: doc,
        preventDefault: !0
    }, {
        key: "Alt-u",
        mac: "Mod-Shift-u",
        run: safari,
        preventDefault: !0
    } ];
    function updateSel(sel, by) {
        return EditorSelection.create(sel.ranges.map(by), sel.mainIndex);
    }
    function setSel(state, selection) {
        return state.update({
            selection: selection,
            scrollIntoView: !0,
            userEvent: "select"
        });
    }
    function moveSel({
        state,
        dispatch
    }, how) {
        how = updateSel(state.selection, how);
        return !how.eq(state.selection, !0) && (dispatch(setSel(state, how)), !0);
    }
    function rangeEnd(range, forward) {
        return EditorSelection.cursor(forward ? range.to : range.from);
    }
    function cursorByChar(view, forward) {
        return moveSel(view, range => range.empty ? view.moveByChar(range, forward) : rangeEnd(range, forward));
    }
    function ltrAtCursor(view) {
        return view.textDirectionAt(view.state.selection.main.head) == Direction.LTR;
    }
    operator = view => cursorByChar(view, !ltrAtCursor(view)), punctuation = view => cursorByChar(view, ltrAtCursor(view));
    function cursorByGroup(view, forward) {
        return moveSel(view, range => range.empty ? view.moveByGroup(range, forward) : rangeEnd(range, forward));
    }
    function moveBySyntax(state, start, forward) {
        let pos = syntaxTree(state).resolveInner(start.head);
        var bracketProp = forward ? NodeProp.closedBy : NodeProp.openedBy;
        for (let at = start.head; ;) {
            var next = forward ? pos.childAfter(at) : pos.childBefore(at);
            if (!next) break;
            !function(state, node, bracketProp) {
                return node.type.prop(bracketProp) || (bracketProp = node.to - node.from) && (2 < bracketProp || /[^\s,.;:]/.test(state.sliceDoc(node.from, node.to))) || node.firstChild;
            }(state, next, bracketProp) ? at = forward ? next.to : next.from : pos = next;
        }
        let bracket = pos.type.prop(bracketProp), match, newPos;
        return newPos = bracket && (match = forward ? matchBrackets(state, pos.from, 1) : matchBrackets(state, pos.to, -1)) && match.matched ? forward ? match.end.to : match.end.from : forward ? pos.to : pos.from, 
        EditorSelection.cursor(newPos, forward ? -1 : 1);
    }
    function cursorByLine(view, forward) {
        return moveSel(view, range => {
            var moved;
            return range.empty ? (moved = view.moveVertically(range, forward)).head != range.head ? moved : view.moveToLineBoundary(range, forward) : rangeEnd(range, forward);
        });
    }
    bracket = view => cursorByLine(view, !1), ie_upto10 = view => cursorByLine(view, !0);
    function pageInfo(view) {
        var selfScroll = view.scrollDOM.clientHeight < view.scrollDOM.scrollHeight - 2;
        let marginTop = 0, marginBottom = 0, height;
        if (selfScroll) {
            for (var source of view.state.facet(EditorView.scrollMargins)) {
                source = source(view);
                null != source && source.top && (marginTop = Math.max(null == source ? void 0 : source.top, marginTop)), 
                null != source && source.bottom && (marginBottom = Math.max(null == source ? void 0 : source.bottom, marginBottom));
            }
            height = view.scrollDOM.clientHeight - marginTop - marginBottom;
        } else height = (view.dom.ownerDocument.defaultView || window).innerHeight;
        return {
            marginTop: marginTop,
            marginBottom: marginBottom,
            selfScroll: selfScroll,
            height: Math.max(view.defaultLineHeight, height - 5)
        };
    }
    function cursorByPage(view, forward) {
        let page = pageInfo(view);
        var startPos, scrollTop, scrollRect, state = view["state"], selection = updateSel(state.selection, range => range.empty ? view.moveVertically(range, forward, page.height) : rangeEnd(range, forward));
        if (selection.eq(state.selection)) return !1;
        let effect;
        return page.selfScroll && (startPos = view.coordsAtPos(state.selection.main.head), 
        scrollTop = (scrollRect = view.scrollDOM.getBoundingClientRect()).top + page.marginTop, 
        scrollRect = scrollRect.bottom - page.marginBottom, startPos) && startPos.top > scrollTop && startPos.bottom < scrollRect && (effect = EditorView.scrollIntoView(selection.main.head, {
            y: "start",
            yMargin: startPos.top - scrollTop
        })), view.dispatch(setSel(state, selection), {
            effects: effect
        }), !0;
    }
    ie = view => cursorByPage(view, !1), ie_edge = view => cursorByPage(view, !0);
    function moveByLineBoundary(view, start, forward) {
        let line = view.lineBlockAt(start.head), moved = view.moveToLineBoundary(start, forward);
        return moved.head == start.head && moved.head != (forward ? line.to : line.from) && (moved = view.moveToLineBoundary(start, forward, !1)), 
        moved = !forward && moved.head == line.from && line.length && (forward = /^\s*/.exec(view.state.sliceDoc(line.from, Math.min(line.from + 100, line.to)))[0].length) && start.head != line.from + forward ? EditorSelection.cursor(line.from + forward) : moved;
    }
    function extendSel(view, how) {
        var selection = updateSel(view.state.selection, range => {
            var head = how(range);
            return EditorSelection.range(range.anchor, head.head, head.goalColumn, head.bidiLevel || void 0);
        });
        return !selection.eq(view.state.selection) && (view.dispatch(setSel(view.state, selection)), 
        !0);
    }
    function selectByChar(view, forward) {
        return extendSel(view, range => view.moveByChar(range, forward));
    }
    meta = view => selectByChar(view, !ltrAtCursor(view)), gecko = view => selectByChar(view, ltrAtCursor(view));
    function selectByGroup(view, forward) {
        return extendSel(view, range => view.moveByGroup(range, forward));
    }
    function selectByLine(view, forward) {
        return extendSel(view, range => view.moveVertically(range, forward));
    }
    chrome = view => selectByLine(view, !1), doc = view => selectByLine(view, !0);
    function selectByPage(view, forward) {
        return extendSel(view, range => view.moveVertically(range, forward, pageInfo(view).height));
    }
    var safari = view => selectByPage(view, !1), selectPageDown = view => selectByPage(view, !0), cursorDocStart = ({
        state,
        dispatch
    }) => (dispatch(setSel(state, {
        anchor: 0
    })), !0), cursorDocEnd = ({
        state,
        dispatch
    }) => (dispatch(setSel(state, {
        anchor: state.doc.length
    })), !0), selectDocStart = ({
        state,
        dispatch
    }) => (dispatch(setSel(state, {
        anchor: state.selection.main.anchor,
        head: 0
    })), !0), selectDocEnd = ({
        state,
        dispatch
    }) => (dispatch(setSel(state, {
        anchor: state.selection.main.anchor,
        head: state.doc.length
    })), !0);
    function deleteBy(target, by) {
        if (target.state.readOnly) return !1;
        let event = "delete.selection", state = target["state"];
        var changes = state.changeByRange(range => {
            let {
                from,
                to
            } = range;
            if (from == to) {
                let towards = by(range);
                towards < from ? (event = "delete.backward", towards = skipAtomic(target, towards, !1)) : towards > from && (event = "delete.forward", 
                towards = skipAtomic(target, towards, !0)), from = Math.min(from, towards), 
                to = Math.max(to, towards);
            } else from = skipAtomic(target, from, !1), to = skipAtomic(target, to, !0);
            return from == to ? {
                range: range
            } : {
                changes: {
                    from: from,
                    to: to
                },
                range: EditorSelection.cursor(from, from < range.head ? -1 : 1)
            };
        });
        return !changes.changes.empty && (target.dispatch(state.update(changes, {
            scrollIntoView: !0,
            userEvent: event,
            effects: "delete.selection" == event ? EditorView.announce.of(state.phrase("Selection deleted")) : void 0
        })), !0);
    }
    function skipAtomic(target, pos, forward) {
        if (target instanceof EditorView) for (var ranges of target.state.facet(EditorView.atomicRanges).map(f => f(target))) ranges.between(pos, pos, (from, to) => {
            from < pos && pos < to && (pos = forward ? to : from);
        });
        return pos;
    }
    const deleteByChar = (target, forward, byIndentUnit) => deleteBy(target, range => {
        let pos = range.from, state = target["state"], line = state.doc.lineAt(pos), before, targetPos;
        if (byIndentUnit && !forward && pos > line.from && pos < line.from + 200 && !/[^ \t]/.test(before = line.text.slice(0, pos - line.from))) {
            if ("\t" == before[before.length - 1]) return pos - 1;
            var drop = countColumn(before, state.tabSize) % getIndentUnit(state) || getIndentUnit(state);
            for (let i = 0; i < drop && " " == before[before.length - 1 - i]; i++) pos--;
            targetPos = pos;
        } else (targetPos = findClusterBreak(line.text, pos - line.from, forward, forward) + line.from) == pos && line.number != (forward ? state.doc.lines : 1) ? targetPos += forward ? 1 : -1 : !forward && /[\ufe00-\ufe0f]/.test(line.text.slice(targetPos - line.from, pos - line.from)) && (targetPos = findClusterBreak(line.text, targetPos - line.from, !1, !1) + line.from);
        return targetPos;
    });
    var deleteCharBackward = view => deleteByChar(view, !1, !0), deleteCharForward = view => deleteByChar(view, !0, !1);
    const deleteByGroup = (target, forward) => deleteBy(target, range => {
        let pos = range.head, state = target["state"], line = state.doc.lineAt(pos);
        var categorize = state.charCategorizer(pos);
        for (let cat = null; ;) {
            if (pos == (forward ? line.to : line.from)) {
                pos == range.head && line.number != (forward ? state.doc.lines : 1) && (pos += forward ? 1 : -1);
                break;
            }
            var next = findClusterBreak(line.text, pos - line.from, forward) + line.from, nextChar = line.text.slice(Math.min(pos, next) - line.from, Math.max(pos, next) - line.from), nextCat = categorize(nextChar);
            if (null != cat && nextCat != cat) break;
            " " == nextChar && pos == range.head || (cat = nextCat), pos = next;
        }
        return pos;
    });
    var deleteGroupBackward = target => deleteByGroup(target, !1);
    function selectedLineBlocks(state) {
        let blocks = [], upto = -1;
        for (var range of state.selection.ranges) {
            let startLine = state.doc.lineAt(range.from), endLine = state.doc.lineAt(range.to);
            var prev;
            range.empty || range.to != endLine.from || (endLine = state.doc.lineAt(range.to - 1)), 
            upto >= startLine.number ? ((prev = blocks[blocks.length - 1]).to = endLine.to, 
            prev.ranges.push(range)) : blocks.push({
                from: startLine.from,
                to: endLine.to,
                ranges: [ range ]
            }), upto = endLine.number + 1;
        }
        return blocks;
    }
    function moveLine(state, dispatch, forward) {
        if (state.readOnly) return !1;
        var block, changes = [], ranges = [];
        for (block of selectedLineBlocks(state)) if (forward ? block.to != state.doc.length : 0 != block.from) {
            var nextLine = state.doc.lineAt(forward ? block.to + 1 : block.from - 1), size = nextLine.length + 1;
            if (forward) {
                changes.push({
                    from: block.to,
                    to: nextLine.to
                }, {
                    from: block.from,
                    insert: nextLine.text + state.lineBreak
                });
                for (var r of block.ranges) ranges.push(EditorSelection.range(Math.min(state.doc.length, r.anchor + size), Math.min(state.doc.length, r.head + size)));
            } else {
                changes.push({
                    from: nextLine.from,
                    to: block.from
                }, {
                    from: block.to,
                    insert: state.lineBreak + nextLine.text
                });
                for (let r of block.ranges) ranges.push(EditorSelection.range(r.anchor - size, r.head - size));
            }
        }
        return !!changes.length && (dispatch(state.update({
            changes: changes,
            scrollIntoView: !0,
            selection: EditorSelection.create(ranges, state.selection.mainIndex),
            userEvent: "move.line"
        })), !0);
    }
    function copyLine(state, dispatch, forward) {
        if (state.readOnly) return !1;
        var block, changes = [];
        for (block of selectedLineBlocks(state)) changes.push(forward ? {
            from: block.from,
            insert: state.doc.slice(block.from, block.to) + state.lineBreak
        } : {
            from: block.to,
            insert: state.lineBreak + state.doc.slice(block.from, block.to)
        });
        return dispatch(state.update({
            changes: changes,
            scrollIntoView: !0,
            userEvent: "input.copyline"
        })), !0;
    }
    function newlineAndIndent(atEof) {
        return ({
            state,
            dispatch
        }) => {
            var changes;
            return !state.readOnly && (changes = state.changeByRange(range => {
                let {
                    from,
                    to
                } = range, line = state.doc.lineAt(from);
                var range = !atEof && from == to && function(state, pos) {
                    if (/\(\)|\[\]|\{\}/.test(state.sliceDoc(pos - 1, pos + 1))) return {
                        from: pos,
                        to: pos
                    };
                    var context = syntaxTree(state).resolveInner(pos);
                    let before = context.childBefore(pos), after = context.childAfter(pos), closedBy;
                    return before && after && before.to <= pos && after.from >= pos && (closedBy = before.type.prop(NodeProp.closedBy)) && -1 < closedBy.indexOf(after.name) && state.doc.lineAt(before.to).from == state.doc.lineAt(after.from).from && !/\S/.test(state.sliceDoc(before.to, after.from)) ? {
                        from: before.to,
                        to: after.from
                    } : null;
                }(state, from), cx = (atEof && (from = to = (to <= line.to ? line : state.doc.lineAt(to)).to), 
                new IndentContext(state, {
                    simulateBreak: from,
                    simulateDoubleBreak: !!range
                }));
                let indent = getIndentation(cx, from);
                for (null == indent && (indent = countColumn(/^\s*/.exec(state.doc.lineAt(from).text)[0], state.tabSize)); to < line.to && /\s/.test(line.text[to - line.from]); ) to++;
                range ? {
                    from,
                    to
                } = range : from > line.from && from < line.from + 100 && !/\S/.test(line.text.slice(0, from)) && (from = line.from);
                var insert = [ "", indentString(state, indent) ];
                return range && insert.push(indentString(state, cx.lineIndent(line.from, -1))), 
                {
                    changes: {
                        from: from,
                        to: to,
                        insert: Text.of(insert)
                    },
                    range: EditorSelection.cursor(from + 1 + insert[1].length)
                };
            }), dispatch(state.update(changes, {
                scrollIntoView: !0,
                userEvent: "input"
            })), !0);
        };
    }
    function changeBySelectedLine(state, f) {
        let atLine = -1;
        return state.changeByRange(range => {
            var changes = [];
            for (let pos = range.from; pos <= range.to; ) {
                var line = state.doc.lineAt(pos);
                line.number > atLine && (range.empty || range.to > line.from) && (f(line, changes, range), 
                atLine = line.number), pos = line.to + 1;
            }
            var changeSet = state.changes(changes);
            return {
                changes: changes,
                range: EditorSelection.range(changeSet.mapPos(range.anchor, 1), changeSet.mapPos(range.head, 1))
            };
        });
    }
    var indentMore = ({
        state,
        dispatch
    }) => !state.readOnly && (dispatch(state.update(changeBySelectedLine(state, (line, changes) => {
        changes.push({
            from: line.from,
            insert: state.facet(indentUnit)
        });
    }), {
        userEvent: "input.indent"
    })), !0), indentLess = ({
        state,
        dispatch
    }) => !state.readOnly && (dispatch(state.update(changeBySelectedLine(state, (line, changes) => {
        var space = /^\s*/.exec(line.text)[0];
        if (space) {
            let col = countColumn(space, state.tabSize), keep = 0;
            for (var insert = indentString(state, Math.max(0, col - getIndentUnit(state))); keep < space.length && keep < insert.length && space.charCodeAt(keep) == insert.charCodeAt(keep); ) keep++;
            changes.push({
                from: line.from + keep,
                to: line.from + space.length,
                insert: insert.slice(keep)
            });
        }
    }), {
        userEvent: "delete.dedent"
    })), !0), webkit = [ {
        key: "Alt-ArrowLeft",
        mac: "Ctrl-ArrowLeft",
        run: view => moveSel(view, range => moveBySyntax(view.state, range, !ltrAtCursor(view))),
        shift: view => extendSel(view, range => moveBySyntax(view.state, range, !ltrAtCursor(view)))
    }, {
        key: "Alt-ArrowRight",
        mac: "Ctrl-ArrowRight",
        run: view => moveSel(view, range => moveBySyntax(view.state, range, ltrAtCursor(view))),
        shift: view => extendSel(view, range => moveBySyntax(view.state, range, ltrAtCursor(view)))
    }, {
        key: "Alt-ArrowUp",
        run: ({
            state,
            dispatch
        }) => moveLine(state, dispatch, !1)
    }, {
        key: "Shift-Alt-ArrowUp",
        run: ({
            state,
            dispatch
        }) => copyLine(state, dispatch, !1)
    }, {
        key: "Alt-ArrowDown",
        run: ({
            state,
            dispatch
        }) => moveLine(state, dispatch, !0)
    }, {
        key: "Shift-Alt-ArrowDown",
        run: ({
            state,
            dispatch
        }) => copyLine(state, dispatch, !0)
    }, {
        key: "Escape",
        run: ({
            state,
            dispatch
        }) => {
            let cur = state.selection, selection = null;
            return 1 < cur.ranges.length ? selection = EditorSelection.create([ cur.main ]) : cur.main.empty || (selection = EditorSelection.create([ EditorSelection.cursor(cur.main.head) ])), 
            !!selection && (dispatch(setSel(state, selection)), !0);
        }
    }, {
        key: "Mod-Enter",
        run: newlineAndIndent(!0)
    }, {
        key: "Alt-l",
        mac: "Ctrl-l",
        run: ({
            state,
            dispatch
        }) => {
            var ranges = selectedLineBlocks(state).map(({
                from,
                to
            }) => EditorSelection.range(from, Math.min(to + 1, state.doc.length)));
            return dispatch(state.update({
                selection: EditorSelection.create(ranges),
                userEvent: "select"
            })), !0;
        }
    }, {
        key: "Mod-i",
        run: ({
            state,
            dispatch
        }) => {
            var selection = updateSel(state.selection, range => {
                var _a;
                for (let cur = syntaxTree(state).resolveStack(range.from, 1); cur; cur = cur.next) {
                    var node = cur["node"];
                    if ((node.from < range.from && node.to >= range.to || node.to > range.to && node.from <= range.from) && null != (_a = node.parent) && _a.parent) return EditorSelection.range(node.to, node.from);
                }
                return range;
            });
            return dispatch(setSel(state, selection)), !0;
        },
        preventDefault: !0
    }, {
        key: "Mod-[",
        run: indentLess
    }, {
        key: "Mod-]",
        run: indentMore
    }, {
        key: "Mod-Alt-\\",
        run: ({
            state,
            dispatch
        }) => {
            if (state.readOnly) return !1;
            let updated = Object.create(null), context = new IndentContext(state, {
                overrideIndentation: start => {
                    start = updated[start];
                    return null == start ? -1 : start;
                }
            });
            var changes = changeBySelectedLine(state, (line, changes, range) => {
                let indent = getIndentation(context, line.from);
                var cur, norm;
                null != indent && (/\S/.test(line.text) || (indent = 0), (cur = /^\s*/.exec(line.text)[0]) != (norm = indentString(state, indent)) || range.from < line.from + cur.length) && (updated[line.from] = indent, 
                changes.push({
                    from: line.from,
                    to: line.from + cur.length,
                    insert: norm
                }));
            });
            return changes.changes.empty || dispatch(state.update(changes, {
                userEvent: "indent"
            })), !0;
        }
    }, {
        key: "Shift-Mod-k",
        run: view => {
            if (view.state.readOnly) return !1;
            let state = view["state"], changes = state.changes(selectedLineBlocks(state).map(({
                from,
                to
            }) => (0 < from ? from-- : to < state.doc.length && to++, {
                from: from,
                to: to
            })));
            var selection = updateSel(state.selection, range => {
                let dist = void 0;
                var block, pos;
                return view.lineWrapping && (block = view.lineBlockAt(range.head), 
                pos = view.coordsAtPos(range.head, range.assoc || 1)) && (dist = block.bottom + view.documentTop - pos.bottom + view.defaultLineHeight / 2), 
                view.moveVertically(range, !0, dist);
            }).map(changes);
            return view.dispatch({
                changes: changes,
                selection: selection,
                scrollIntoView: !0,
                userEvent: "delete.line"
            }), !0;
        }
    }, {
        key: "Shift-Mod-\\",
        run: ({
            state,
            dispatch
        }) => function(state, dispatch) {
            let found = !1, selection = updateSel(state.selection, range => {
                var matching = matchBrackets(state, range.head, -1) || matchBrackets(state, range.head, 1) || 0 < range.head && matchBrackets(state, range.head - 1, 1) || range.head < state.doc.length && matchBrackets(state, range.head + 1, -1);
                if (!matching || !matching.end) return range;
                found = !0;
                range = matching.start.from == range.head ? matching.end.to : matching.end.from;
                return EditorSelection.cursor(range);
            });
            return !!found && (dispatch(setSel(state, selection)), !0);
        }(state, dispatch)
    }, {
        key: "Mod-/",
        run: target => {
            var state = target["state"], state = state.doc.lineAt(state.selection.main.from), state = getConfig(target.state, state.from);
            return state.line ? toggleLineComment(target) : !!state.block && toggleBlockCommentByLine(target);
        }
    }, {
        key: "Alt-A",
        run: webkit
    } ].concat([ {
        key: "ArrowLeft",
        run: operator,
        shift: meta,
        preventDefault: !0
    }, {
        key: "Mod-ArrowLeft",
        mac: "Alt-ArrowLeft",
        run: view => cursorByGroup(view, !ltrAtCursor(view)),
        shift: view => selectByGroup(view, !ltrAtCursor(view)),
        preventDefault: !0
    }, {
        mac: "Cmd-ArrowLeft",
        run: view => moveSel(view, range => moveByLineBoundary(view, range, !ltrAtCursor(view))),
        shift: view => extendSel(view, range => moveByLineBoundary(view, range, !ltrAtCursor(view))),
        preventDefault: !0
    }, {
        key: "ArrowRight",
        run: punctuation,
        shift: gecko,
        preventDefault: !0
    }, {
        key: "Mod-ArrowRight",
        mac: "Alt-ArrowRight",
        run: view => cursorByGroup(view, ltrAtCursor(view)),
        shift: view => selectByGroup(view, ltrAtCursor(view)),
        preventDefault: !0
    }, {
        mac: "Cmd-ArrowRight",
        run: view => moveSel(view, range => moveByLineBoundary(view, range, ltrAtCursor(view))),
        shift: view => extendSel(view, range => moveByLineBoundary(view, range, ltrAtCursor(view))),
        preventDefault: !0
    }, {
        key: "ArrowUp",
        run: bracket,
        shift: chrome,
        preventDefault: !0
    }, {
        mac: "Cmd-ArrowUp",
        run: cursorDocStart,
        shift: selectDocStart
    }, {
        mac: "Ctrl-ArrowUp",
        run: ie,
        shift: safari
    }, {
        key: "ArrowDown",
        run: ie_upto10,
        shift: doc,
        preventDefault: !0
    }, {
        mac: "Cmd-ArrowDown",
        run: cursorDocEnd,
        shift: selectDocEnd
    }, {
        mac: "Ctrl-ArrowDown",
        run: ie_edge,
        shift: selectPageDown
    }, {
        key: "PageUp",
        run: ie,
        shift: safari
    }, {
        key: "PageDown",
        run: ie_edge,
        shift: selectPageDown
    }, {
        key: "Home",
        run: view => moveSel(view, range => moveByLineBoundary(view, range, !1)),
        shift: view => extendSel(view, range => moveByLineBoundary(view, range, !1)),
        preventDefault: !0
    }, {
        key: "Mod-Home",
        run: cursorDocStart,
        shift: selectDocStart
    }, {
        key: "End",
        run: view => moveSel(view, range => moveByLineBoundary(view, range, !0)),
        shift: view => extendSel(view, range => moveByLineBoundary(view, range, !0)),
        preventDefault: !0
    }, {
        key: "Mod-End",
        run: cursorDocEnd,
        shift: selectDocEnd
    }, {
        key: "Enter",
        run: newlineAndIndent(!1)
    }, {
        key: "Mod-a",
        run: ({
            state,
            dispatch
        }) => (dispatch(state.update({
            selection: {
                anchor: 0,
                head: state.doc.length
            },
            userEvent: "select"
        })), !0)
    }, {
        key: "Backspace",
        run: deleteCharBackward,
        shift: deleteCharBackward
    }, {
        key: "Delete",
        run: deleteCharForward
    }, {
        key: "Mod-Backspace",
        mac: "Alt-Backspace",
        run: deleteGroupBackward
    }, {
        key: "Mod-Delete",
        mac: "Alt-Delete",
        run: target => deleteByGroup(target, !0)
    }, {
        mac: "Mod-Backspace",
        run: view => deleteBy(view, range => {
            var lineStart = view.moveToLineBoundary(range, !1).head;
            return range.head > lineStart ? lineStart : Math.max(0, range.head - 1);
        })
    }, {
        mac: "Mod-Delete",
        run: view => deleteBy(view, range => {
            var lineStart = view.moveToLineBoundary(range, !0).head;
            return range.head < lineStart ? lineStart : Math.min(view.state.doc.length, range.head + 1);
        })
    } ].concat([ {
        key: "Ctrl-b",
        run: operator,
        shift: meta,
        preventDefault: !0
    }, {
        key: "Ctrl-f",
        run: punctuation,
        shift: gecko
    }, {
        key: "Ctrl-p",
        run: bracket,
        shift: chrome
    }, {
        key: "Ctrl-n",
        run: ie_upto10,
        shift: doc
    }, {
        key: "Ctrl-a",
        run: view => moveSel(view, range => EditorSelection.cursor(view.lineBlockAt(range.head).from, 1)),
        shift: view => extendSel(view, range => EditorSelection.cursor(view.lineBlockAt(range.head).from))
    }, {
        key: "Ctrl-e",
        run: view => moveSel(view, range => EditorSelection.cursor(view.lineBlockAt(range.head).to, -1)),
        shift: view => extendSel(view, range => EditorSelection.cursor(view.lineBlockAt(range.head).to))
    }, {
        key: "Ctrl-d",
        run: deleteCharForward
    }, {
        key: "Ctrl-h",
        run: deleteCharBackward
    }, {
        key: "Ctrl-k",
        run: view => deleteBy(view, range => {
            var lineEnd = view.lineBlockAt(range.head).to;
            return range.head < lineEnd ? lineEnd : Math.min(view.state.doc.length, range.head + 1);
        })
    }, {
        key: "Ctrl-Alt-h",
        run: deleteGroupBackward
    }, {
        key: "Ctrl-o",
        run: ({
            state,
            dispatch
        }) => {
            var changes;
            return !state.readOnly && (changes = state.changeByRange(range => ({
                changes: {
                    from: range.from,
                    to: range.to,
                    insert: Text.of([ "", "" ])
                },
                range: EditorSelection.cursor(range.from)
            })), dispatch(state.update(changes, {
                scrollIntoView: !0,
                userEvent: "input"
            })), !0);
        }
    }, {
        key: "Ctrl-t",
        run: ({
            state,
            dispatch
        }) => {
            var changes;
            return !state.readOnly && !(changes = state.changeByRange(range => {
                var pos, from, line;
                return range.empty && 0 != range.from && range.from != state.doc.length ? {
                    changes: {
                        from: from = (pos = range.from) == (line = state.doc.lineAt(pos)).from ? pos - 1 : findClusterBreak(line.text, pos - line.from, !1) + line.from,
                        to: line = pos == line.to ? pos + 1 : findClusterBreak(line.text, pos - line.from, !0) + line.from,
                        insert: state.doc.slice(pos, line).append(state.doc.slice(from, pos))
                    },
                    range: EditorSelection.cursor(line)
                } : {
                    range: range
                };
            })).changes.empty && (dispatch(state.update(changes, {
                scrollIntoView: !0,
                userEvent: "move.character"
            })), !0);
        }
    }, {
        key: "Ctrl-v",
        run: ie_edge
    } ].map(b => ({
        mac: b.key,
        run: b.run,
        shift: b.shift
    })))), ie = {
        key: "Tab",
        run: indentMore,
        shift: indentLess
    };
    function crelt(argument_0, argument_1) {
        var value, elt = argument_0, i = ("string" == typeof elt && (elt = document.createElement(elt)), 
        1), next = argument_1;
        if (next && "object" == typeof next && null == next.nodeType && !Array.isArray(next)) {
            for (var name in next) Object.prototype.hasOwnProperty.call(next, name) && ("string" == typeof (value = next[name]) ? elt.setAttribute(name, value) : null != value && (elt[name] = value));
            i++;
        }
        for (;i < arguments.length; i++) !function add(elt, child) {
            if ("string" == typeof child) elt.appendChild(document.createTextNode(child)); else if (null != child) if (null != child.nodeType) elt.appendChild(child); else {
                if (!Array.isArray(child)) throw new RangeError("Unsupported child node: " + child);
                for (var i = 0; i < child.length; i++) add(elt, child[i]);
            }
        }(elt, arguments[i]);
        return elt;
    }
    const basicNormalize = "function" == typeof String.prototype.normalize ? x => x.normalize("NFKD") : x => x;
    class SearchCursor {
        constructor(text, query, from = 0, to = text.length, normalize, test) {
            this.test = test, this.value = {
                from: 0,
                to: 0
            }, this.done = !1, this.matches = [], this.buffer = "", this.bufferPos = 0, 
            this.iter = text.iterRange(from, to), this.bufferStart = from, this.normalize = normalize ? x => normalize(basicNormalize(x)) : basicNormalize, 
            this.query = this.normalize(query);
        }
        peek() {
            if (this.bufferPos == this.buffer.length) {
                if (this.bufferStart += this.buffer.length, this.iter.next(), this.iter.done) return -1;
                this.bufferPos = 0, this.buffer = this.iter.value;
            }
            return codePointAt(this.buffer, this.bufferPos);
        }
        next() {
            for (;this.matches.length; ) this.matches.pop();
            return this.nextOverlapping();
        }
        nextOverlapping() {
            for (;;) {
                var next = this.peek();
                if (next < 0) return this.done = !0, this;
                var str = fromCodePoint(next), start = this.bufferStart + this.bufferPos, norm = (this.bufferPos += next < 65536 ? 1 : 2, 
                this.normalize(str));
                for (let i = 0, pos = start; ;i++) {
                    var code = norm.charCodeAt(i), match = this.match(code, pos, this.bufferPos + this.bufferStart);
                    if (i == norm.length - 1) {
                        if (match) return this.value = match, this;
                        break;
                    }
                    pos == start && i < str.length && str.charCodeAt(i) == code && pos++;
                }
            }
        }
        match(code, pos, end) {
            let match = null;
            for (let i = 0; i < this.matches.length; i += 2) {
                let index = this.matches[i], keep = !1;
                this.query.charCodeAt(index) == code && (index == this.query.length - 1 ? match = {
                    from: this.matches[i + 1],
                    to: end
                } : (this.matches[i]++, keep = !0)), keep || (this.matches.splice(i, 2), 
                i -= 2);
            }
            return this.query.charCodeAt(0) == code && (1 == this.query.length ? match = {
                from: pos,
                to: end
            } : this.matches.push(1, pos)), match = match && this.test && !this.test(match.from, match.to, this.buffer, this.bufferStart) ? null : match;
        }
    }
    "undefined" != typeof Symbol && (SearchCursor.prototype[Symbol.iterator] = function() {
        return this;
    });
    const empty = {
        from: -1,
        to: -1,
        match: /.*/.exec("")
    }, baseFlags = "gm" + (null == /x/.unicode ? "" : "u");
    class RegExpCursor {
        constructor(text, query, options, from = 0, to = text.length) {
            if (this.text = text, this.to = to, this.curLine = "", this.done = !1, 
            this.value = empty, /\\[sWDnr]|\n|\r|\[\^/.test(query)) return new MultilineRegExpCursor(text, query, options, from, to);
            this.re = new RegExp(query, baseFlags + (null != options && options.ignoreCase ? "i" : "")), 
            this.test = null == options ? void 0 : options.test, this.iter = text.iter();
            to = text.lineAt(from);
            this.curLineStart = to.from, this.matchPos = toCharEnd(text, from), 
            this.getLine(this.curLineStart);
        }
        getLine(skip) {
            this.iter.next(skip), this.iter.lineBreak ? this.curLine = "" : (this.curLine = this.iter.value, 
            this.curLineStart + this.curLine.length > this.to && (this.curLine = this.curLine.slice(0, this.to - this.curLineStart)), 
            this.iter.next());
        }
        nextLine() {
            this.curLineStart = this.curLineStart + this.curLine.length + 1, this.curLineStart > this.to ? this.curLine = "" : this.getLine(0);
        }
        next() {
            for (let off = this.matchPos - this.curLineStart; ;) {
                this.re.lastIndex = off;
                var match = this.matchPos <= this.to && this.re.exec(this.curLine);
                if (match) {
                    var from = this.curLineStart + match.index, to = from + match[0].length;
                    if (this.matchPos = toCharEnd(this.text, to + (from == to ? 1 : 0)), 
                    from == this.curLineStart + this.curLine.length && this.nextLine(), 
                    (from < to || from > this.value.to) && (!this.test || this.test(from, to, match))) return this.value = {
                        from: from,
                        to: to,
                        match: match
                    }, this;
                    off = this.matchPos - this.curLineStart;
                } else {
                    if (!(this.curLineStart + this.curLine.length < this.to)) return this.done = !0, 
                    this;
                    this.nextLine(), off = 0;
                }
            }
        }
    }
    const flattened = new WeakMap();
    class FlattenedDoc {
        constructor(from, text) {
            this.from = from, this.text = text;
        }
        get to() {
            return this.from + this.text.length;
        }
        static get(doc, from, to) {
            var flat, cached = flattened.get(doc);
            if (!cached || cached.from >= to || cached.to <= from) return flat = new FlattenedDoc(from, doc.sliceString(from, to)), 
            flattened.set(doc, flat), flat;
            if (cached.from == from && cached.to == to) return cached;
            let {
                text,
                from: cachedFrom
            } = cached;
            return cachedFrom > from && (text = doc.sliceString(from, cachedFrom) + text, 
            cachedFrom = from), cached.to < to && (text += doc.sliceString(cached.to, to)), 
            flattened.set(doc, new FlattenedDoc(cachedFrom, text)), new FlattenedDoc(from, text.slice(from - cachedFrom, to - cachedFrom));
        }
    }
    class MultilineRegExpCursor {
        constructor(text, query, options, from, to) {
            this.text = text, this.to = to, this.done = !1, this.value = empty, 
            this.matchPos = toCharEnd(text, from), this.re = new RegExp(query, baseFlags + (null != options && options.ignoreCase ? "i" : "")), 
            this.test = null == options ? void 0 : options.test, this.flat = FlattenedDoc.get(text, from, this.chunkEnd(from + 5e3));
        }
        chunkEnd(pos) {
            return (pos >= this.to ? this : this.text.lineAt(pos)).to;
        }
        next() {
            for (;;) {
                var off = this.re.lastIndex = this.matchPos - this.flat.from;
                let match = this.re.exec(this.flat.text);
                if (match && !match[0] && match.index == off && (this.re.lastIndex = 1 + off, 
                match = this.re.exec(this.flat.text)), match) {
                    var off = this.flat.from + match.index, to = off + match[0].length;
                    if ((this.flat.to >= this.to || match.index + match[0].length <= this.flat.text.length - 10) && (!this.test || this.test(off, to, match))) return this.value = {
                        from: off,
                        to: to,
                        match: match
                    }, this.matchPos = toCharEnd(this.text, to + (off == to ? 1 : 0)), 
                    this;
                }
                if (this.flat.to == this.to) return this.done = !0, this;
                this.flat = FlattenedDoc.get(this.text, this.flat.from, this.chunkEnd(this.flat.from + 2 * this.flat.text.length));
            }
        }
    }
    function toCharEnd(text, pos) {
        if (!(pos >= text.length)) {
            let line = text.lineAt(pos), next;
            for (;pos < line.to && 56320 <= (next = line.text.charCodeAt(pos - line.from)) && next < 57344; ) pos++;
        }
        return pos;
    }
    function createLineDialog(view) {
        let input = crelt("input", {
            class: "cm-textfield",
            name: "line",
            value: String(view.state.doc.lineAt(view.state.selection.main.head).number)
        });
        function go() {
            var match = /^([+-])?(\d+)?(:\d+)?(%)?$/.exec(input.value);
            if (match) {
                var state = view["state"], startLine = state.doc.lineAt(state.selection.main.head), [ , match, ln, cl, percent ] = match, cl = cl ? +cl.slice(1) : 0;
                let line = ln ? +ln : startLine.number;
                if (ln && percent) {
                    let pc = line / 100;
                    match && (pc = pc * ("-" == match ? -1 : 1) + startLine.number / state.doc.lines), 
                    line = Math.round(state.doc.lines * pc);
                } else ln && match && (line = line * ("-" == match ? -1 : 1) + startLine.number);
                percent = state.doc.line(Math.max(1, Math.min(state.doc.lines, line))), 
                ln = EditorSelection.cursor(percent.from + Math.max(0, Math.min(cl, percent.length)));
                view.dispatch({
                    effects: [ dialogEffect.of(!1), EditorView.scrollIntoView(ln.from, {
                        y: "center"
                    }) ],
                    selection: ln
                }), view.focus();
            }
        }
        return {
            dom: crelt("form", {
                class: "cm-gotoLine",
                onkeydown: event => {
                    27 == event.keyCode ? (event.preventDefault(), view.dispatch({
                        effects: dialogEffect.of(!1)
                    }), view.focus()) : 13 == event.keyCode && (event.preventDefault(), 
                    go());
                },
                onsubmit: event => {
                    event.preventDefault(), go();
                }
            }, crelt("label", view.state.phrase("Go to line"), ": ", input), " ", crelt("button", {
                class: "cm-button",
                type: "submit"
            }, view.state.phrase("go")))
        };
    }
    "undefined" != typeof Symbol && (RegExpCursor.prototype[Symbol.iterator] = MultilineRegExpCursor.prototype[Symbol.iterator] = function() {
        return this;
    });
    const dialogEffect = StateEffect.define(), dialogField = StateField.define({
        create() {
            return !0;
        },
        update(value, tr) {
            for (var e of tr.effects) e.is(dialogEffect) && (value = e.value);
            return value;
        },
        provide: f => showPanel.from(f, val => val ? createLineDialog : null)
    });
    const baseTheme$1 = EditorView.baseTheme({
        ".cm-panel.cm-gotoLine": {
            padding: "2px 6px 4px",
            "& label": {
                fontSize: "80%"
            }
        }
    }), defaultHighlightOptions = {
        highlightWordAroundCursor: !1,
        minSelectionLength: 1,
        maxMatches: 100,
        wholeWords: !1
    }, highlightConfig = Facet.define({
        combine(options) {
            return combineConfig(options, defaultHighlightOptions, {
                highlightWordAroundCursor: (a, b) => a || b,
                minSelectionLength: Math.min,
                maxMatches: Math.min
            });
        }
    });
    const matchDeco = Decoration.mark({
        class: "cm-selectionMatch"
    }), mainMatchDeco = Decoration.mark({
        class: "cm-selectionMatch cm-selectionMatch-main"
    });
    function insideWordBoundaries(check, state, from, to) {
        return !(0 != from && check(state.sliceDoc(from - 1, from)) == CharCategory.Word || to != state.doc.length && check(state.sliceDoc(to, to + 1)) == CharCategory.Word);
    }
    const matchHighlighter = ViewPlugin.fromClass(class {
        constructor(view) {
            this.decorations = this.getDeco(view);
        }
        update(update) {
            (update.selectionSet || update.docChanged || update.viewportChanged) && (this.decorations = this.getDeco(update.view));
        }
        getDeco(view) {
            var conf = view.state.facet(highlightConfig), state = view["state"], sel = state.selection;
            if (1 < sel.ranges.length) return Decoration.none;
            let range = sel.main, query, check = null;
            if (range.empty) {
                if (!conf.highlightWordAroundCursor) return Decoration.none;
                sel = state.wordAt(range.head);
                if (!sel) return Decoration.none;
                check = state.charCategorizer(range.head), query = state.sliceDoc(sel.from, sel.to);
            } else {
                sel = range.to - range.from;
                if (sel < conf.minSelectionLength || 200 < sel) return Decoration.none;
                if (conf.wholeWords) {
                    if (query = state.sliceDoc(range.from, range.to), !insideWordBoundaries(check = state.charCategorizer(range.head), state, range.from, range.to) || !function(check, state, from, to) {
                        return check(state.sliceDoc(from, from + 1)) == CharCategory.Word && check(state.sliceDoc(to - 1, to)) == CharCategory.Word;
                    }(check, state, range.from, range.to)) return Decoration.none;
                } else if (!(query = state.sliceDoc(range.from, range.to))) return Decoration.none;
            }
            var part, deco = [];
            for (part of view.visibleRanges) for (var cursor = new SearchCursor(state.doc, query, part.from, part.to); !cursor.next().done; ) {
                var {
                    from,
                    to
                } = cursor.value;
                if ((!check || insideWordBoundaries(check, state, from, to)) && (range.empty && from <= range.from && to >= range.to ? deco.push(mainMatchDeco.range(from, to)) : (from >= range.to || to <= range.from) && deco.push(matchDeco.range(from, to)), 
                deco.length > conf.maxMatches)) return Decoration.none;
            }
            return Decoration.set(deco);
        }
    }, {
        decorations: v => v.decorations
    }), defaultTheme$1 = EditorView.baseTheme({
        ".cm-selectionMatch": {
            backgroundColor: "#99ff7780"
        },
        ".cm-searchMatch .cm-selectionMatch": {
            backgroundColor: "transparent"
        }
    });
    const searchConfigFacet = Facet.define({
        combine(configs) {
            return combineConfig(configs, {
                top: !1,
                caseSensitive: !1,
                literal: !1,
                regexp: !1,
                wholeWord: !1,
                createPanel: view => new SearchPanel(view),
                scrollToMatch: range => EditorView.scrollIntoView(range)
            });
        }
    });
    class SearchQuery {
        constructor(config) {
            this.search = config.search, this.caseSensitive = !!config.caseSensitive, 
            this.literal = !!config.literal, this.regexp = !!config.regexp, this.replace = config.replace || "", 
            this.valid = !!this.search && (!this.regexp || function(source) {
                try {
                    return new RegExp(source, baseFlags), !0;
                } catch (_a) {
                    return !1;
                }
            }(this.search)), this.unquoted = this.unquote(this.search), this.wholeWord = !!config.wholeWord;
        }
        unquote(text) {
            return this.literal ? text : text.replace(/\\([nrt\\])/g, (_, ch) => "n" == ch ? "\n" : "r" == ch ? "\r" : "t" == ch ? "\t" : "\\");
        }
        eq(other) {
            return this.search == other.search && this.replace == other.replace && this.caseSensitive == other.caseSensitive && this.regexp == other.regexp && this.wholeWord == other.wholeWord;
        }
        create() {
            return new (this.regexp ? RegExpQuery : StringQuery)(this);
        }
        getCursor(state, from = 0, to) {
            state = state.doc ? state : EditorState.create({
                doc: state
            });
            return null == to && (to = state.doc.length), (this.regexp ? regexpCursor : stringCursor)(this, state, from, to);
        }
    }
    class QueryType {
        constructor(spec) {
            this.spec = spec;
        }
    }
    function stringCursor(spec, state, from, to) {
        return new SearchCursor(state.doc, spec.unquoted, from, to, spec.caseSensitive ? void 0 : x => x.toLowerCase(), spec.wholeWord ? (doc = state.doc, 
        categorizer = state.charCategorizer(state.selection.main.head), (from, to, buf, bufPos) => ((from < bufPos || bufPos + buf.length < to) && (bufPos = Math.max(0, from - 2), 
        buf = doc.sliceString(bufPos, Math.min(doc.length, to + 2))), !(categorizer(charBefore(buf, from - bufPos)) == CharCategory.Word && categorizer(charAfter(buf, from - bufPos)) == CharCategory.Word || categorizer(charAfter(buf, to - bufPos)) == CharCategory.Word && categorizer(charBefore(buf, to - bufPos)) == CharCategory.Word))) : void 0);
        var doc, categorizer;
    }
    class StringQuery extends QueryType {
        constructor(spec) {
            super(spec);
        }
        nextMatch(state, curFrom, curTo) {
            let cursor = stringCursor(this.spec, state, curTo, state.doc.length).nextOverlapping();
            return (cursor = cursor.done ? stringCursor(this.spec, state, 0, curFrom).nextOverlapping() : cursor).done ? null : cursor.value;
        }
        prevMatchInRange(state, from, to) {
            for (let pos = to; ;) {
                var start = Math.max(from, pos - 1e4 - this.spec.unquoted.length);
                let cursor = stringCursor(this.spec, state, start, pos), range = null;
                for (;!cursor.nextOverlapping().done; ) range = cursor.value;
                if (range) return range;
                if (start == from) return null;
                pos -= 1e4;
            }
        }
        prevMatch(state, curFrom, curTo) {
            return this.prevMatchInRange(state, 0, curFrom) || this.prevMatchInRange(state, curTo, state.doc.length);
        }
        getReplacement(_result) {
            return this.spec.unquote(this.spec.replace);
        }
        matchAll(state, limit) {
            for (var cursor = stringCursor(this.spec, state, 0, state.doc.length), ranges = []; !cursor.next().done; ) {
                if (limit <= ranges.length) return null;
                ranges.push(cursor.value);
            }
            return ranges;
        }
        highlight(state, from, to, add) {
            for (var cursor = stringCursor(this.spec, state, Math.max(0, from - this.spec.unquoted.length), Math.min(to + this.spec.unquoted.length, state.doc.length)); !cursor.next().done; ) add(cursor.value.from, cursor.value.to);
        }
    }
    function regexpCursor(spec, state, from, to) {
        return new RegExpCursor(state.doc, spec.search, {
            ignoreCase: !spec.caseSensitive,
            test: spec.wholeWord ? (categorizer = state.charCategorizer(state.selection.main.head), 
            (_from, _to, match) => !match[0].length || (categorizer(charBefore(match.input, match.index)) != CharCategory.Word || categorizer(charAfter(match.input, match.index)) != CharCategory.Word) && (categorizer(charAfter(match.input, match.index + match[0].length)) != CharCategory.Word || categorizer(charBefore(match.input, match.index + match[0].length)) != CharCategory.Word)) : void 0
        }, from, to);
        var categorizer;
    }
    function charBefore(str, index) {
        return str.slice(findClusterBreak(str, index, !1), index);
    }
    function charAfter(str, index) {
        return str.slice(index, findClusterBreak(str, index));
    }
    class RegExpQuery extends QueryType {
        nextMatch(state, curFrom, curTo) {
            let cursor = regexpCursor(this.spec, state, curTo, state.doc.length).next();
            return (cursor = cursor.done ? regexpCursor(this.spec, state, 0, curFrom).next() : cursor).done ? null : cursor.value;
        }
        prevMatchInRange(state, from, to) {
            for (let size = 1; ;size++) {
                var start = Math.max(from, to - 1e4 * size);
                let cursor = regexpCursor(this.spec, state, start, to), range = null;
                for (;!cursor.next().done; ) range = cursor.value;
                if (range && (start == from || range.from > start + 10)) return range;
                if (start == from) return null;
            }
        }
        prevMatch(state, curFrom, curTo) {
            return this.prevMatchInRange(state, 0, curFrom) || this.prevMatchInRange(state, curTo, state.doc.length);
        }
        getReplacement(result) {
            return this.spec.unquote(this.spec.replace).replace(/\$([$&\d+])/g, (m, i) => "$" == i ? "$" : "&" == i ? result.match[0] : "0" != i && +i < result.match.length ? result.match[i] : m);
        }
        matchAll(state, limit) {
            for (var cursor = regexpCursor(this.spec, state, 0, state.doc.length), ranges = []; !cursor.next().done; ) {
                if (limit <= ranges.length) return null;
                ranges.push(cursor.value);
            }
            return ranges;
        }
        highlight(state, from, to, add) {
            for (var cursor = regexpCursor(this.spec, state, Math.max(0, from - 250), Math.min(to + 250, state.doc.length)); !cursor.next().done; ) add(cursor.value.from, cursor.value.to);
        }
    }
    const setSearchQuery = StateEffect.define(), togglePanel = StateEffect.define(), searchState = StateField.define({
        create(state) {
            return new SearchState(defaultQuery(state).create(), null);
        },
        update(value, tr) {
            for (var effect of tr.effects) effect.is(setSearchQuery) ? value = new SearchState(effect.value.create(), value.panel) : effect.is(togglePanel) && (value = new SearchState(value.query, effect.value ? createSearchPanel : null));
            return value;
        },
        provide: f => showPanel.from(f, val => val.panel)
    });
    class SearchState {
        constructor(query, panel) {
            this.query = query, this.panel = panel;
        }
    }
    const matchMark = Decoration.mark({
        class: "cm-searchMatch"
    }), selectedMatchMark = Decoration.mark({
        class: "cm-searchMatch cm-searchMatch-selected"
    });
    safari = ViewPlugin.fromClass(class {
        constructor(view) {
            this.view = view, this.decorations = this.highlight(view.state.field(searchState));
        }
        update(update) {
            var state = update.state.field(searchState);
            (state != update.startState.field(searchState) || update.docChanged || update.selectionSet || update.viewportChanged) && (this.decorations = this.highlight(state));
        }
        highlight({
            query,
            panel
        }) {
            if (!panel || !query.spec.valid) return Decoration.none;
            let view = this["view"], builder = new RangeSetBuilder();
            for (let i = 0, ranges = view.visibleRanges, l = ranges.length; i < l; i++) {
                let {
                    from,
                    to
                } = ranges[i];
                for (;i < l - 1 && to > ranges[i + 1].from - 500; ) to = ranges[++i].to;
                query.highlight(view.state, from, to, (from, to) => {
                    var selected = view.state.selection.ranges.some(r => r.from == from && r.to == to);
                    builder.add(from, to, selected ? selectedMatchMark : matchMark);
                });
            }
            return builder.finish();
        }
    }, {
        decorations: v => v.decorations
    });
    function searchCommand(f) {
        return view => {
            var state = view.state.field(searchState, !1);
            return state && state.query.spec.valid ? f(view, state) : openSearchPanel(view);
        };
    }
    const findNext = searchCommand((view, {
        query
    }) => {
        var config, to = view.state.selection.main["to"], query = query.nextMatch(view.state, to, to);
        return !!query && (to = EditorSelection.single(query.from, query.to), config = view.state.facet(searchConfigFacet), 
        view.dispatch({
            selection: to,
            effects: [ announceMatch(view, query), config.scrollToMatch(to.main, view) ],
            userEvent: "select.search"
        }), selectSearchInput(view), !0);
    }), findPrevious = searchCommand((view, {
        query
    }) => {
        var state = view["state"], from = state.selection.main["from"], query = query.prevMatch(state, from, from);
        return !!query && (state = EditorSelection.single(query.from, query.to), 
        from = view.state.facet(searchConfigFacet), view.dispatch({
            selection: state,
            effects: [ announceMatch(view, query), from.scrollToMatch(state.main, view) ],
            userEvent: "select.search"
        }), selectSearchInput(view), !0);
    }), selectMatches = searchCommand((view, {
        query
    }) => {
        query = query.matchAll(view.state, 1e3);
        return !(!query || !query.length || (view.dispatch({
            selection: EditorSelection.create(query.map(r => EditorSelection.range(r.from, r.to))),
            userEvent: "select.search.matches"
        }), 0));
    });
    const replaceNext = searchCommand((view, {
        query
    }) => {
        var state = view["state"], {
            from,
            to
        } = state.selection.main;
        if (state.readOnly) return !1;
        let next = query.nextMatch(state, from, from);
        if (!next) return !1;
        let changes = [], selection, replacement;
        var effects = [];
        return next.from == from && next.to == to && (replacement = state.toText(query.getReplacement(next)), 
        changes.push({
            from: next.from,
            to: next.to,
            insert: replacement
        }), next = query.nextMatch(state, next.from, next.to), effects.push(EditorView.announce.of(state.phrase("replaced match on line $", state.doc.lineAt(from).number) + "."))), 
        next && (to = 0 == changes.length || changes[0].from >= next.to ? 0 : next.to - next.from - replacement.length, 
        selection = EditorSelection.single(next.from - to, next.to - to), effects.push(announceMatch(view, next)), 
        effects.push(state.facet(searchConfigFacet).scrollToMatch(selection.main, view))), 
        view.dispatch({
            changes: changes,
            selection: selection,
            effects: effects,
            userEvent: "input.replace"
        }), !0;
    }), replaceAll = searchCommand((view, {
        query
    }) => {
        var changes, announceText;
        return !view.state.readOnly && !!(changes = query.matchAll(view.state, 1e9).map(match => {
            var {
                from,
                to
            } = match;
            return {
                from: from,
                to: to,
                insert: query.getReplacement(match)
            };
        })).length && (announceText = view.state.phrase("replaced $ matches", changes.length) + ".", 
        view.dispatch({
            changes: changes,
            effects: EditorView.announce.of(announceText),
            userEvent: "input.replace.all"
        }), !0);
    });
    function createSearchPanel(view) {
        return view.state.facet(searchConfigFacet).createPanel(view);
    }
    function defaultQuery(state, fallback) {
        var _a, sel = state.selection.main, sel = sel.empty || sel.to > sel.from + 100 ? "" : state.sliceDoc(sel.from, sel.to);
        return fallback && !sel ? fallback : (state = state.facet(searchConfigFacet), 
        new SearchQuery({
            search: (null != (_a = null == fallback ? void 0 : fallback.literal) ? _a : state.literal) ? sel : sel.replace(/\n/g, "\\n"),
            caseSensitive: null != (_a = null == fallback ? void 0 : fallback.caseSensitive) ? _a : state.caseSensitive,
            literal: null != (sel = null == fallback ? void 0 : fallback.literal) ? sel : state.literal,
            regexp: null != (_a = null == fallback ? void 0 : fallback.regexp) ? _a : state.regexp,
            wholeWord: null != (sel = null == fallback ? void 0 : fallback.wholeWord) ? sel : state.wholeWord
        }));
    }
    function getSearchInput(view) {
        view = getPanel(view, createSearchPanel);
        return view && view.dom.querySelector("[main-field]");
    }
    function selectSearchInput(view) {
        var input = getSearchInput(view);
        input && input == view.root.activeElement && input.select();
    }
    const openSearchPanel = view => {
        var searchInput, query, state = view.state.field(searchState, !1);
        return state && state.panel ? (searchInput = getSearchInput(view)) && searchInput != view.root.activeElement && ((query = defaultQuery(view.state, state.query.spec)).valid && view.dispatch({
            effects: setSearchQuery.of(query)
        }), searchInput.focus(), searchInput.select()) : view.dispatch({
            effects: [ togglePanel.of(!0), state ? setSearchQuery.of(defaultQuery(view.state, state.query.spec)) : StateEffect.appendConfig.of(searchExtensions) ]
        }), !0;
    }, closeSearchPanel = view => {
        var state = view.state.field(searchState, !1);
        return !(!state || !state.panel || ((state = getPanel(view, createSearchPanel)) && state.dom.contains(view.root.activeElement) && view.focus(), 
        view.dispatch({
            effects: togglePanel.of(!1)
        }), 0));
    };
    selectPageDown = [ {
        key: "Mod-f",
        run: openSearchPanel,
        scope: "editor search-panel"
    }, {
        key: "F3",
        run: findNext,
        shift: findPrevious,
        scope: "editor search-panel",
        preventDefault: !0
    }, {
        key: "Mod-g",
        run: findNext,
        shift: findPrevious,
        scope: "editor search-panel",
        preventDefault: !0
    }, {
        key: "Escape",
        run: closeSearchPanel,
        scope: "editor search-panel"
    }, {
        key: "Mod-Shift-l",
        run: ({
            state,
            dispatch
        }) => {
            var sel = state.selection;
            if (1 < sel.ranges.length || sel.main.empty) return !1;
            var {
                from,
                to: sel
            } = sel.main;
            let ranges = [], main = 0;
            for (var cur = new SearchCursor(state.doc, state.sliceDoc(from, sel)); !cur.next().done; ) {
                if (1e3 < ranges.length) return !1;
                cur.value.from == from && (main = ranges.length), ranges.push(EditorSelection.range(cur.value.from, cur.value.to));
            }
            return dispatch(state.update({
                selection: EditorSelection.create(ranges, main),
                userEvent: "select.search.matches"
            })), !0;
        }
    }, {
        key: "Mod-Alt-g",
        run: view => {
            let panel = getPanel(view, createLineDialog);
            var effects;
            return panel || (effects = [ dialogEffect.of(!0) ], null == view.state.field(dialogField, !1) && effects.push(StateEffect.appendConfig.of([ dialogField, baseTheme$1 ])), 
            view.dispatch({
                effects: effects
            }), panel = getPanel(view, createLineDialog)), panel && panel.dom.querySelector("input").select(), 
            !0;
        }
    }, {
        key: "Mod-d",
        run: ({
            state,
            dispatch
        }) => {
            var ranges = state.selection["ranges"];
            if (ranges.some(sel => sel.from === sel.to)) return (({
                state,
                dispatch
            }) => {
                var selection = state["selection"], newSel = EditorSelection.create(selection.ranges.map(range => state.wordAt(range.head) || EditorSelection.cursor(range.head)), selection.mainIndex);
                return !newSel.eq(selection) && (dispatch(state.update({
                    selection: newSel
                })), !0);
            })({
                state: state,
                dispatch: dispatch
            });
            let searchedText = state.sliceDoc(ranges[0].from, ranges[0].to);
            return !state.selection.ranges.some(r => state.sliceDoc(r.from, r.to) != searchedText) && !!(ranges = function(state, query) {
                var {
                    main,
                    ranges
                } = state.selection, word = state.wordAt(main.head), fullWord = word && word.from == main.from && word.to == main.to;
                for (let cycled = !1, cursor = new SearchCursor(state.doc, query, ranges[ranges.length - 1].to); ;) if (cursor.next(), 
                cursor.done) {
                    if (cycled) return null;
                    cursor = new SearchCursor(state.doc, query, 0, Math.max(0, ranges[ranges.length - 1].from - 1)), 
                    cycled = !0;
                } else if (!cycled || !ranges.some(r => r.from == cursor.value.from)) {
                    if (fullWord) {
                        let word = state.wordAt(cursor.value.from);
                        if (!word || word.from != cursor.value.from || word.to != cursor.value.to) continue;
                    }
                    return cursor.value;
                }
            }(state, searchedText)) && (dispatch(state.update({
                selection: state.selection.addRange(EditorSelection.range(ranges.from, ranges.to), !1),
                effects: EditorView.scrollIntoView(ranges.to)
            })), !0);
        },
        preventDefault: !0
    } ];
    class SearchPanel {
        constructor(view) {
            this.view = view;
            var query = this.query = view.state.field(searchState).query.spec;
            function button(name, onclick, content) {
                return crelt("button", {
                    class: "cm-button",
                    name: name,
                    onclick: onclick,
                    type: "button"
                }, content);
            }
            this.commit = this.commit.bind(this), this.searchField = crelt("input", {
                value: query.search,
                placeholder: phrase(view, "Find"),
                "aria-label": phrase(view, "Find"),
                class: "cm-textfield",
                name: "search",
                form: "",
                "main-field": "true",
                onchange: this.commit,
                onkeyup: this.commit
            }), this.replaceField = crelt("input", {
                value: query.replace,
                placeholder: phrase(view, "Replace"),
                "aria-label": phrase(view, "Replace"),
                class: "cm-textfield",
                name: "replace",
                form: "",
                onchange: this.commit,
                onkeyup: this.commit
            }), this.caseField = crelt("input", {
                type: "checkbox",
                name: "case",
                form: "",
                checked: query.caseSensitive,
                onchange: this.commit
            }), this.reField = crelt("input", {
                type: "checkbox",
                name: "re",
                form: "",
                checked: query.regexp,
                onchange: this.commit
            }), this.wordField = crelt("input", {
                type: "checkbox",
                name: "word",
                form: "",
                checked: query.wholeWord,
                onchange: this.commit
            }), this.dom = crelt("div", {
                onkeydown: e => this.keydown(e),
                class: "cm-search"
            }, [ this.searchField, button("next", () => findNext(view), [ phrase(view, "next") ]), button("prev", () => findPrevious(view), [ phrase(view, "previous") ]), button("select", () => selectMatches(view), [ phrase(view, "all") ]), crelt("label", null, [ this.caseField, phrase(view, "match case") ]), crelt("label", null, [ this.reField, phrase(view, "regexp") ]), crelt("label", null, [ this.wordField, phrase(view, "by word") ]), ...view.state.readOnly ? [] : [ crelt("br"), this.replaceField, button("replace", () => replaceNext(view), [ phrase(view, "replace") ]), button("replaceAll", () => replaceAll(view), [ phrase(view, "replace all") ]) ], crelt("button", {
                name: "close",
                onclick: () => closeSearchPanel(view),
                "aria-label": phrase(view, "close"),
                type: "button"
            }, [ "\xd7" ]) ]);
        }
        commit() {
            var query = new SearchQuery({
                search: this.searchField.value,
                caseSensitive: this.caseField.checked,
                regexp: this.reField.checked,
                wholeWord: this.wordField.checked,
                replace: this.replaceField.value
            });
            query.eq(this.query) || (this.query = query, this.view.dispatch({
                effects: setSearchQuery.of(query)
            }));
        }
        keydown(e) {
            var view, event, scope;
            view = this.view, event = e, scope = "search-panel", runHandlers(getKeymap(view.state), event, view, scope) ? e.preventDefault() : 13 == e.keyCode && e.target == this.searchField ? (e.preventDefault(), 
            (e.shiftKey ? findPrevious : findNext)(this.view)) : 13 == e.keyCode && e.target == this.replaceField && (e.preventDefault(), 
            replaceNext(this.view));
        }
        update(update) {
            for (var tr of update.transactions) for (var effect of tr.effects) effect.is(setSearchQuery) && !effect.value.eq(this.query) && this.setQuery(effect.value);
        }
        setQuery(query) {
            this.query = query, this.searchField.value = query.search, this.replaceField.value = query.replace, 
            this.caseField.checked = query.caseSensitive, this.reField.checked = query.regexp, 
            this.wordField.checked = query.wholeWord;
        }
        mount() {
            this.searchField.select();
        }
        get pos() {
            return 80;
        }
        get top() {
            return this.view.state.facet(searchConfigFacet).top;
        }
    }
    function phrase(view, phrase) {
        return view.state.phrase(phrase);
    }
    const AnnounceMargin = 30, Break = /[\s\.,:;?!]/;
    function announceMatch(view, {
        from,
        to
    }) {
        var line = view.state.doc.lineAt(from), lineEnd = view.state.doc.lineAt(to).to, from = Math.max(line.from, from - AnnounceMargin), to = Math.min(lineEnd, to + AnnounceMargin);
        let text = view.state.sliceDoc(from, to);
        if (from != line.from) for (let i = 0; i < AnnounceMargin; i++) if (!Break.test(text[i + 1]) && Break.test(text[i])) {
            text = text.slice(i);
            break;
        }
        if (to != lineEnd) for (let i = text.length - 1; i > text.length - AnnounceMargin; i--) if (!Break.test(text[i - 1]) && Break.test(text[i])) {
            text = text.slice(0, i);
            break;
        }
        return EditorView.announce.of(`${view.state.phrase("current match")}. ${text} ${view.state.phrase("on line")} ${line.number}.`);
    }
    cursorDocStart = EditorView.baseTheme({
        ".cm-panel.cm-search": {
            padding: "2px 6px 4px",
            position: "relative",
            "& [name=close]": {
                position: "absolute",
                top: "0",
                right: "4px",
                backgroundColor: "inherit",
                border: "none",
                font: "inherit",
                padding: 0,
                margin: 0
            },
            "& input, & button, & label": {
                margin: ".2em .6em .2em 0"
            },
            "& input[type=checkbox]": {
                marginRight: ".2em"
            },
            "& label": {
                fontSize: "80%",
                whiteSpace: "pre"
            }
        },
        "&light .cm-searchMatch": {
            backgroundColor: "#ffff0054"
        },
        "&dark .cm-searchMatch": {
            backgroundColor: "#00ffff8a"
        },
        "&light .cm-searchMatch-selected": {
            backgroundColor: "#ff6a0054"
        },
        "&dark .cm-searchMatch-selected": {
            backgroundColor: "#ff00ff8a"
        }
    });
    const searchExtensions = [ searchState, Prec.low(safari), cursorDocStart ];
    class CompletionContext {
        constructor(state, pos, explicit) {
            this.state = state, this.pos = pos, this.explicit = explicit, this.abortListeners = [];
        }
        tokenBefore(types) {
            let token = syntaxTree(this.state).resolveInner(this.pos, -1);
            for (;token && types.indexOf(token.name) < 0; ) token = token.parent;
            return token ? {
                from: token.from,
                to: this.pos,
                text: this.state.sliceDoc(token.from, this.pos),
                type: token.type
            } : null;
        }
        matchBefore(expr) {
            var line = this.state.doc.lineAt(this.pos), start = Math.max(line.from, this.pos - 250), line = line.text.slice(start - line.from, this.pos - line.from), expr = line.search(ensureAnchor(expr, !1));
            return expr < 0 ? null : {
                from: start + expr,
                to: this.pos,
                text: line.slice(expr)
            };
        }
        get aborted() {
            return null == this.abortListeners;
        }
        addEventListener(type, listener) {
            "abort" == type && this.abortListeners && this.abortListeners.push(listener);
        }
    }
    function toSet(chars) {
        let flat = Object.keys(chars).join("");
        chars = /\w/.test(flat);
        return `[${chars ? "\\w" : ""}${(flat = chars ? flat.replace(/\w/g, "") : flat).replace(/[^\w\s]/g, "\\$&")}]`;
    }
    function completeFromList(list) {
        let options = list.map(o => "string" == typeof o ? {
            label: o
        } : o), [ validFor, match ] = options.every(o => /^\w+$/.test(o.label)) ? [ /\w*$/, /\w+$/ ] : function(options) {
            var label, first = Object.create(null), rest = Object.create(null);
            for ({
                label
            } of options) {
                first[label[0]] = !0;
                for (let i = 1; i < label.length; i++) rest[label[i]] = !0;
            }
            return options = toSet(first) + toSet(rest) + "*$", [ new RegExp("^" + options), new RegExp(options) ];
        }(options);
        return context => {
            var token = context.matchBefore(match);
            return token || context.explicit ? {
                from: token ? token.from : context.pos,
                options: options,
                validFor: validFor
            } : null;
        };
    }
    class Option {
        constructor(completion, source, match, score) {
            this.completion = completion, this.source = source, this.match = match, 
            this.score = score;
        }
    }
    function cur(state) {
        return state.selection.main.from;
    }
    function ensureAnchor(expr, start) {
        var source = expr["source"], start = start && "^" != source[0], addEnd = "$" != source[source.length - 1];
        return start || addEnd ? new RegExp(`${start ? "^" : ""}(?:${source})` + (addEnd ? "$" : ""), null != (start = expr.flags) ? start : expr.ignoreCase ? "i" : "") : expr;
    }
    const pickedCompletion = Annotation.define();
    const SourceCache = new WeakMap();
    function asSource(source) {
        if (!Array.isArray(source)) return source;
        let known = SourceCache.get(source);
        return known || SourceCache.set(source, known = completeFromList(source)), 
        known;
    }
    const startCompletionEffect = StateEffect.define(), closeCompletionEffect = StateEffect.define();
    class FuzzyMatcher {
        constructor(pattern) {
            this.pattern = pattern, this.chars = [], this.folded = [], this.any = [], 
            this.precise = [], this.byWord = [], this.score = 0, this.matched = [];
            for (let p = 0; p < pattern.length; ) {
                var char = codePointAt(pattern, p), size = char < 65536 ? 1 : 2, char = (this.chars.push(char), 
                pattern.slice(p, p + size)), upper = char.toUpperCase();
                this.folded.push(codePointAt(upper == char ? char.toLowerCase() : upper, 0)), 
                p += size;
            }
            this.astral = pattern.length != this.chars.length;
        }
        ret(score, matched) {
            return this.score = score, this.matched = matched, this;
        }
        match(word) {
            if (0 == this.pattern.length) return this.ret(-100, []);
            if (word.length < this.pattern.length) return null;
            var {
                chars,
                folded,
                any,
                precise,
                byWord
            } = this;
            if (1 == chars.length) {
                var first = codePointAt(word, 0), firstSize = first < 65536 ? 1 : 2;
                let score = firstSize == word.length ? 0 : -100;
                if (first != chars[0]) {
                    if (first != folded[0]) return null;
                    score += -200;
                }
                return this.ret(score, [ 0, firstSize ]);
            }
            var direct = word.indexOf(this.pattern);
            if (0 == direct) return this.ret(word.length == this.pattern.length ? 0 : -100, [ 0, this.pattern.length ]);
            let len = chars.length, anyTo = 0;
            if (direct < 0) {
                for (let i = 0, e = Math.min(word.length, 200); i < e && anyTo < len; ) {
                    var next = codePointAt(word, i);
                    next != chars[anyTo] && next != folded[anyTo] || (any[anyTo++] = i), 
                    i += next < 65536 ? 1 : 2;
                }
                if (anyTo < len) return null;
            }
            let preciseTo = 0, byWordTo = 0, byWordFolded = !1, adjacentTo = 0, adjacentStart = -1, adjacentEnd = -1, hasLower = /[a-z]/.test(word), wordAdjacent = !0;
            for (let i = 0, e = Math.min(word.length, 200), prevType = 0; i < e && byWordTo < len; ) {
                let next = codePointAt(word, i);
                direct < 0 && (preciseTo < len && next == chars[preciseTo] && (precise[preciseTo++] = i), 
                adjacentTo < len) && (next == chars[adjacentTo] || next == folded[adjacentTo] ? (0 == adjacentTo && (adjacentStart = i), 
                adjacentEnd = i + 1, adjacentTo++) : adjacentTo = 0);
                var ch = next < 255 ? 48 <= next && next <= 57 || 97 <= next && next <= 122 ? 2 : 65 <= next && next <= 90 ? 1 : 0 : (ch = fromCodePoint(next)) != ch.toLowerCase() ? 1 : ch != ch.toUpperCase() ? 2 : 0;
                (!i || 1 == ch && hasLower || 0 == prevType && 0 != ch) && (chars[byWordTo] == next || folded[byWordTo] == next && (byWordFolded = !0) ? byWord[byWordTo++] = i : byWord.length && (wordAdjacent = !1)), 
                prevType = ch, i += codePointSize(next);
            }
            return byWordTo == len && 0 == byWord[0] && wordAdjacent ? this.result((byWordFolded ? -200 : 0) - 100, byWord, word) : adjacentTo == len && 0 == adjacentStart ? this.ret(-200 - word.length + (adjacentEnd == word.length ? 0 : -100), [ 0, adjacentEnd ]) : -1 < direct ? this.ret(-700 - word.length, [ direct, direct + this.pattern.length ]) : adjacentTo == len ? this.ret(-900 - word.length, [ adjacentStart, adjacentEnd ]) : byWordTo == len ? this.result((byWordFolded ? -200 : 0) - 100 - 700 + (wordAdjacent ? 0 : -1100), byWord, word) : 2 == chars.length ? null : this.result((any[0] ? -700 : 0) - 200 - 1100, any, word);
        }
        result(score, positions, word) {
            let result = [], i = 0;
            for (var pos of positions) {
                var to = pos + (this.astral ? codePointSize(codePointAt(word, pos)) : 1);
                i && result[i - 1] == pos ? result[i - 1] = to : (result[i++] = pos, 
                result[i++] = to);
            }
            return this.ret(score - word.length, result);
        }
    }
    class StrictMatcher {
        constructor(pattern) {
            this.pattern = pattern, this.matched = [], this.score = 0, this.folded = pattern.toLowerCase();
        }
        match(word) {
            var start, match;
            return word.length < this.pattern.length || null == (match = (start = word.slice(0, this.pattern.length)) == this.pattern ? 0 : start.toLowerCase() == this.folded ? -200 : null) ? null : (this.matched = [ 0, start.length ], 
            this.score = match + (word.length == this.pattern.length ? 0 : -100), 
            this);
        }
    }
    const completionConfig = Facet.define({
        combine(configs) {
            return combineConfig(configs, {
                activateOnTyping: !0,
                activateOnCompletion: () => !1,
                activateOnTypingDelay: 100,
                selectOnOpen: !0,
                override: null,
                closeOnBlur: !0,
                maxRenderedOptions: 100,
                defaultKeymap: !0,
                tooltipClass: () => "",
                optionClass: () => "",
                aboveCursor: !1,
                icons: !0,
                addToOptions: [],
                positionInfo: defaultPositionInfo,
                filterStrict: !1,
                compareCompletions: (a, b) => a.label.localeCompare(b.label),
                interactionDelay: 75,
                updateSyncTime: 100
            }, {
                defaultKeymap: (a, b) => a && b,
                closeOnBlur: (a, b) => a && b,
                icons: (a, b) => a && b,
                tooltipClass: (a, b) => c => joinClass(a(c), b(c)),
                optionClass: (a, b) => c => joinClass(a(c), b(c)),
                addToOptions: (a, b) => a.concat(b),
                filterStrict: (a, b) => a || b
            });
        }
    });
    function joinClass(a, b) {
        return a ? b ? a + " " + b : a : b;
    }
    function defaultPositionInfo(view, list, option, info, space, tooltip) {
        let rtl = view.textDirection == Direction.RTL, left = rtl, narrow = !1, side = "top", offset, maxWidth;
        var view = list.left - space.left, spaceRight = space.right - list.right, infoWidth = info.right - info.left, info = info.bottom - info.top, view = (left && view < Math.min(infoWidth, spaceRight) ? left = !1 : !left && spaceRight < Math.min(infoWidth, view) && (left = !0), 
        infoWidth <= (left ? view : spaceRight) ? (offset = Math.max(space.top, Math.min(option.top, space.bottom - info)) - list.top, 
        maxWidth = Math.min(400, left ? view : spaceRight)) : (narrow = !0, maxWidth = Math.min(400, (rtl ? list.right : space.right - list.left) - 30), 
        infoWidth = space.bottom - list.bottom, offset = info <= infoWidth || infoWidth > list.top ? option.bottom - list.top : (side = "bottom", 
        list.bottom - option.top)), (list.bottom - list.top) / tooltip.offsetHeight), spaceRight = (list.right - list.left) / tooltip.offsetWidth;
        return {
            style: `${side}: ${offset / view}px; max-width: ${maxWidth / spaceRight}px`,
            class: "cm-completionInfo-" + (narrow ? rtl ? "left-narrow" : "right-narrow" : left ? "left" : "right")
        };
    }
    function rangeAroundSelected(total, selected, max) {
        if (total <= max) return {
            from: 0,
            to: total
        };
        if ((selected = selected < 0 ? 0 : selected) <= total >> 1) {
            let off = Math.floor(selected / max);
            return {
                from: off * max,
                to: (off + 1) * max
            };
        }
        selected = Math.floor((total - selected) / max);
        return {
            from: total - (selected + 1) * max,
            to: total - selected * max
        };
    }
    class CompletionTooltip {
        constructor(view, stateField, applyCompletion) {
            this.view = view, this.stateField = stateField, this.applyCompletion = applyCompletion, 
            this.info = null, this.infoDestroy = null, this.placeInfoReq = {
                read: () => this.measureInfo(),
                write: pos => this.placeInfo(pos),
                key: this
            }, this.space = null, this.currentClass = "";
            var applyCompletion = view.state.field(stateField), {
                options,
                selected
            } = applyCompletion.open, config = view.state.facet(completionConfig);
            this.optionContent = function(config) {
                var content = config.addToOptions.slice();
                return config.icons && content.push({
                    render(completion) {
                        var icon = document.createElement("div");
                        return icon.classList.add("cm-completionIcon"), completion.type && icon.classList.add(...completion.type.split(/\s+/g).map(cls => "cm-completionIcon-" + cls)), 
                        icon.setAttribute("aria-hidden", "true"), icon;
                    },
                    position: 20
                }), content.push({
                    render(completion, _s, _v, match) {
                        var labelElt = document.createElement("span");
                        labelElt.className = "cm-completionLabel";
                        let label = completion.displayLabel || completion.label, off = 0;
                        for (let j = 0; j < match.length; ) {
                            var from = match[j++], to = match[j++], span = (from > off && labelElt.appendChild(document.createTextNode(label.slice(off, from))), 
                            labelElt.appendChild(document.createElement("span")));
                            span.appendChild(document.createTextNode(label.slice(from, to))), 
                            span.className = "cm-completionMatchedText", off = to;
                        }
                        return off < label.length && labelElt.appendChild(document.createTextNode(label.slice(off))), 
                        labelElt;
                    },
                    position: 50
                }, {
                    render(completion) {
                        var detailElt;
                        return completion.detail ? ((detailElt = document.createElement("span")).className = "cm-completionDetail", 
                        detailElt.textContent = completion.detail, detailElt) : null;
                    },
                    position: 80
                }), content.sort((a, b) => a.position - b.position).map(a => a.render);
            }(config), this.optionClass = config.optionClass, this.tooltipClass = config.tooltipClass, 
            this.range = rangeAroundSelected(options.length, selected, config.maxRenderedOptions), 
            this.dom = document.createElement("div"), this.dom.className = "cm-tooltip-autocomplete", 
            this.updateTooltipClass(view.state), this.dom.addEventListener("mousedown", e => {
                var options = view.state.field(stateField).open["options"];
                for (let dom = e.target, match; dom && dom != this.dom; dom = dom.parentNode) if ("LI" == dom.nodeName && (match = /-(\d+)$/.exec(dom.id)) && +match[1] < options.length) return this.applyCompletion(view, options[+match[1]]), 
                void e.preventDefault();
            }), this.dom.addEventListener("focusout", e => {
                var state = view.state.field(this.stateField, !1);
                state && state.tooltip && view.state.facet(completionConfig).closeOnBlur && e.relatedTarget != view.contentDOM && view.dispatch({
                    effects: closeCompletionEffect.of(null)
                });
            }), this.showOptions(options, applyCompletion.id);
        }
        mount() {
            this.updateSel();
        }
        showOptions(options, id) {
            this.list && this.list.remove(), this.list = this.dom.appendChild(this.createListBox(options, id, this.range)), 
            this.list.addEventListener("scroll", () => {
                this.info && this.view.requestMeasure(this.placeInfoReq);
            });
        }
        update(update) {
            var options, selected, disabled, cState = update.state.field(this.stateField), prevState = update.startState.field(this.stateField);
            this.updateTooltipClass(update.state), cState != prevState && ({
                options,
                selected,
                disabled
            } = cState.open, prevState.open && prevState.open.options == options || (this.range = rangeAroundSelected(options.length, selected, update.state.facet(completionConfig).maxRenderedOptions), 
            this.showOptions(options, cState.id)), this.updateSel(), disabled != (null == (selected = prevState.open) ? void 0 : selected.disabled)) && this.dom.classList.toggle("cm-tooltip-autocomplete-disabled", !!disabled);
        }
        updateTooltipClass(state) {
            state = this.tooltipClass(state);
            if (state != this.currentClass) {
                for (var c of this.currentClass.split(" ")) c && this.dom.classList.remove(c);
                for (let c of state.split(" ")) c && this.dom.classList.add(c);
                this.currentClass = state;
            }
        }
        positioned(space) {
            this.space = space, this.info && this.view.requestMeasure(this.placeInfoReq);
        }
        updateSel() {
            let cState = this.view.state.field(this.stateField), open = cState.open;
            if ((-1 < open.selected && open.selected < this.range.from || open.selected >= this.range.to) && (this.range = rangeAroundSelected(open.options.length, open.selected, this.view.state.facet(completionConfig).maxRenderedOptions), 
            this.showOptions(open.options, cState.id)), this.updateSelectedOption(open.selected)) {
                this.destroyInfo();
                let completion = open.options[open.selected]["completion"];
                var info = completion["info"];
                info && (info = "string" == typeof info ? document.createTextNode(info) : info(completion)) && ("then" in info ? info.then(obj => {
                    obj && this.view.state.field(this.stateField, !1) == cState && this.addInfoPane(obj, completion);
                }).catch(e => logException(this.view.state, e, "completion info")) : this.addInfoPane(info, completion));
            }
        }
        addInfoPane(content, completion) {
            this.destroyInfo();
            var destroy, wrap = this.info = document.createElement("div");
            wrap.className = "cm-tooltip cm-completionInfo", null != content.nodeType ? (wrap.appendChild(content), 
            this.infoDestroy = null) : ({
                dom: content,
                destroy
            } = content, wrap.appendChild(content), this.infoDestroy = destroy || null), 
            this.dom.appendChild(wrap), this.view.requestMeasure(this.placeInfoReq);
        }
        updateSelectedOption(selected) {
            let set = null;
            for (let opt = this.list.firstChild, i = this.range.from; opt; opt = opt.nextSibling, 
            i++) "LI" == opt.nodeName && opt.id ? i == selected ? opt.hasAttribute("aria-selected") || (opt.setAttribute("aria-selected", "true"), 
            set = opt) : opt.hasAttribute("aria-selected") && opt.removeAttribute("aria-selected") : i--;
            var container, element, parent, scaleY;
            return set && (container = this.list, element = set, parent = container.getBoundingClientRect(), 
            element = element.getBoundingClientRect(), scaleY = parent.height / container.offsetHeight, 
            element.top < parent.top ? container.scrollTop -= (parent.top - element.top) / scaleY : element.bottom > parent.bottom && (container.scrollTop += (element.bottom - parent.bottom) / scaleY)), 
            set;
        }
        measureInfo() {
            var sel = this.dom.querySelector("[aria-selected]");
            if (!sel || !this.info) return null;
            var win, listRect = this.dom.getBoundingClientRect(), infoRect = this.info.getBoundingClientRect(), sel = sel.getBoundingClientRect();
            let space = this.space;
            return space || (win = this.dom.ownerDocument.defaultView || window, 
            space = {
                left: 0,
                top: 0,
                right: win.innerWidth,
                bottom: win.innerHeight
            }), sel.top > Math.min(space.bottom, listRect.bottom) - 10 || sel.bottom < Math.max(space.top, listRect.top) + 10 ? null : this.view.state.facet(completionConfig).positionInfo(this.view, listRect, sel, infoRect, space, this.dom);
        }
        placeInfo(pos) {
            this.info && (pos ? (pos.style && (this.info.style.cssText = pos.style), 
            this.info.className = "cm-tooltip cm-completionInfo " + (pos.class || "")) : this.info.style.cssText = "top: -1e6px");
        }
        createListBox(options, id, range) {
            var ul = document.createElement("ul");
            ul.id = id, ul.setAttribute("role", "listbox"), ul.setAttribute("aria-expanded", "true"), 
            ul.setAttribute("aria-label", this.view.state.phrase("Completions"));
            let curSection = null;
            for (let i = range.from; i < range.to; i++) {
                var name, source, {
                    completion,
                    match
                } = options[i], section = completion["section"], li = (section && (name = "string" == typeof section ? section : section.name) != curSection && (i > range.from || 0 == range.from) && (curSection = name, 
                "string" != typeof section && section.header ? ul.appendChild(section.header(section)) : ul.appendChild(document.createElement("completion-section")).textContent = name), 
                ul.appendChild(document.createElement("li"))), section = (li.id = id + "-" + i, 
                li.setAttribute("role", "option"), this.optionClass(completion));
                section && (li.className = section);
                for (source of this.optionContent) {
                    var node = source(completion, this.view.state, this.view, match);
                    node && li.appendChild(node);
                }
            }
            return range.from && ul.classList.add("cm-completionListIncompleteTop"), 
            range.to < options.length && ul.classList.add("cm-completionListIncompleteBottom"), 
            ul;
        }
        destroyInfo() {
            this.info && (this.infoDestroy && this.infoDestroy(), this.info.remove(), 
            this.info = null);
        }
        destroy() {
            this.destroyInfo();
        }
    }
    function completionTooltip(stateField, applyCompletion) {
        return view => new CompletionTooltip(view, stateField, applyCompletion);
    }
    function score(option) {
        return 100 * (option.boost || 0) + (option.apply ? 10 : 0) + (option.info ? 5 : 0) + (option.type ? 1 : 0);
    }
    class CompletionDialog {
        constructor(options, attrs, tooltip, timestamp, selected, disabled) {
            this.options = options, this.attrs = attrs, this.tooltip = tooltip, 
            this.timestamp = timestamp, this.selected = selected, this.disabled = disabled;
        }
        setSelected(selected, id) {
            return selected == this.selected || selected >= this.options.length ? this : new CompletionDialog(this.options, makeAttrs(id, selected), this.tooltip, this.timestamp, selected, this.disabled);
        }
        static build(active, state, id, prev, conf) {
            var options = function(active, state) {
                let options = [], sections = null;
                var a, opt, s, addOption = option => {
                    options.push(option);
                    option = option.completion.section;
                    if (option) {
                        sections = sections || [];
                        let name = "string" == typeof option ? option : option.name;
                        sections.some(s => s.name == name) || sections.push("string" == typeof option ? {
                            name: name
                        } : option);
                    }
                }, conf = state.facet(completionConfig);
                for (a of active) if (a.hasResult()) {
                    var getMatch = a.result.getMatch;
                    if (!1 === a.result.filter) for (var option of a.result.options) addOption(new Option(option, a.source, getMatch ? getMatch(option) : [], 1e9 - options.length)); else {
                        var match, matched, pattern = state.sliceDoc(a.from, a.to), matcher = new (conf.filterStrict ? StrictMatcher : FuzzyMatcher)(pattern);
                        for (let option of a.result.options) (match = matcher.match(option.label)) && (matched = option.displayLabel ? getMatch ? getMatch(option, match.matched) : [] : match.matched, 
                        addOption(new Option(option, a.source, matched, match.score + (option.boost || 0))));
                    }
                }
                if (sections) {
                    let sectionOrder = Object.create(null), pos = 0;
                    for (s of sections.sort((a, b) => {
                        var _a;
                        return (null != (_a = a.rank) ? _a : 1e9) - (null != (_a = b.rank) ? _a : 1e9) || (a.name < b.name ? -1 : 1);
                    })) pos -= 1e5, sectionOrder[s.name] = pos;
                    for (let option of options) {
                        var section = option.completion["section"];
                        section && (option.score += sectionOrder["string" == typeof section ? section : section.name]);
                    }
                }
                let result = [], prev = null, compare = conf.compareCompletions;
                for (opt of options.sort((a, b) => b.score - a.score || compare(a.completion, b.completion))) {
                    var cur = opt.completion;
                    !prev || prev.label != cur.label || prev.detail != cur.detail || null != prev.type && null != cur.type && prev.type != cur.type || prev.apply != cur.apply || prev.boost != cur.boost ? result.push(opt) : score(opt.completion) > score(prev) && (result[result.length - 1] = opt), 
                    prev = opt.completion;
                }
                return result;
            }(active, state);
            if (!options.length) return prev && active.some(a => 1 == a.state) ? new CompletionDialog(prev.options, prev.attrs, prev.tooltip, prev.timestamp, prev.selected, !0) : null;
            let selected = state.facet(completionConfig).selectOnOpen ? 0 : -1;
            if (prev && prev.selected != selected && -1 != prev.selected) {
                var selectedValue = prev.options[prev.selected].completion;
                for (let i = 0; i < options.length; i++) if (options[i].completion == selectedValue) {
                    selected = i;
                    break;
                }
            }
            return new CompletionDialog(options, makeAttrs(id, selected), {
                pos: active.reduce((a, b) => b.hasResult() ? Math.min(a, b.from) : a, 1e8),
                create: createTooltip,
                above: conf.aboveCursor
            }, prev ? prev.timestamp : Date.now(), selected, !1);
        }
        map(changes) {
            return new CompletionDialog(this.options, this.attrs, Object.assign(Object.assign({}, this.tooltip), {
                pos: changes.mapPos(this.tooltip.pos)
            }), this.timestamp, this.selected, this.disabled);
        }
    }
    class CompletionState {
        constructor(active, id, open) {
            this.active = active, this.id = id, this.open = open;
        }
        static start() {
            return new CompletionState(none$1, "cm-ac-" + Math.floor(2e6 * Math.random()).toString(36), null);
        }
        update(tr) {
            let state = tr["state"], conf = state.facet(completionConfig);
            var effect;
            let active = (conf.override || state.languageDataAt("autocomplete", cur(state)).map(asSource)).map(source => {
                return (this.active.find(s => s.source == source) || new ActiveSource(source, this.active.some(a => 0 != a.state) ? 1 : 0)).update(tr, conf);
            }), open = (active.length == this.active.length && active.every((a, i) => a == this.active[i]) && (active = this.active), 
            this.open);
            open && tr.docChanged && (open = open.map(tr.changes)), tr.selection || active.some(a => a.hasResult() && tr.changes.touchesRange(a.from, a.to)) || !function(a, b) {
                if (a == b) return 1;
                for (let iA = 0, iB = 0; ;) {
                    for (;iA < a.length && !a[iA].hasResult; ) iA++;
                    for (;iB < b.length && !b[iB].hasResult; ) iB++;
                    var endA = iA == a.length, endB = iB == b.length;
                    if (endA || endB) return endA == endB;
                    if (a[iA++].result != b[iB++].result) return;
                }
            }(active, this.active) ? open = CompletionDialog.build(active, state, this.id, open, conf) : open && open.disabled && !active.some(a => 1 == a.state) && (open = null), 
            !open && active.every(a => 1 != a.state) && active.some(a => a.hasResult()) && (active = active.map(a => a.hasResult() ? new ActiveSource(a.source, 0) : a));
            for (effect of tr.effects) effect.is(setSelectedEffect) && (open = open && open.setSelected(effect.value, this.id));
            return active == this.active && open == this.open ? this : new CompletionState(active, this.id, open);
        }
        get tooltip() {
            return this.open ? this.open.tooltip : null;
        }
        get attrs() {
            return this.open ? this.open.attrs : baseAttrs;
        }
    }
    const baseAttrs = {
        "aria-autocomplete": "list"
    };
    function makeAttrs(id, selected) {
        var result = {
            "aria-autocomplete": "list",
            "aria-haspopup": "listbox",
            "aria-controls": id
        };
        return -1 < selected && (result["aria-activedescendant"] = id + "-" + selected), 
        result;
    }
    const none$1 = [];
    class ActiveSource {
        constructor(source, state, explicitPos = -1) {
            this.source = source, this.state = state, this.explicitPos = explicitPos;
        }
        hasResult() {
            return !1;
        }
        update(tr, conf) {
            let event = function(tr, conf) {
                if (tr.isUserEvent("input.complete")) {
                    var completion = tr.annotation(pickedCompletion);
                    if (completion && conf.activateOnCompletion(completion)) return "input";
                }
                return tr.isUserEvent("input.type") ? "input" : tr.isUserEvent("delete.backward") ? "delete" : null;
            }(tr, conf), value = this;
            event ? value = value.handleUserEvent(tr, event, conf) : tr.docChanged ? value = value.handleChange(tr) : tr.selection && 0 != value.state && (value = new ActiveSource(value.source, 0));
            for (var effect of tr.effects) if (effect.is(startCompletionEffect)) value = new ActiveSource(value.source, 1, effect.value ? cur(tr.state) : -1); else if (effect.is(closeCompletionEffect)) value = new ActiveSource(value.source, 0); else if (effect.is(setActiveEffect)) for (var active of effect.value) active.source == value.source && (value = active);
            return value;
        }
        handleUserEvent(tr, type, conf) {
            return "delete" != type && conf.activateOnTyping ? new ActiveSource(this.source, 1) : this.map(tr.changes);
        }
        handleChange(tr) {
            return tr.changes.touchesRange(cur(tr.startState)) ? new ActiveSource(this.source, 0) : this.map(tr.changes);
        }
        map(changes) {
            return changes.empty || this.explicitPos < 0 ? this : new ActiveSource(this.source, this.state, changes.mapPos(this.explicitPos));
        }
    }
    (class extends ActiveSource {});
    const setActiveEffect = StateEffect.define({
        map(sources, mapping) {
            return sources.map(s => s.map(mapping));
        }
    }), setSelectedEffect = StateEffect.define(), completionState = StateField.define({
        create() {
            return CompletionState.start();
        },
        update(value, tr) {
            return value.update(tr);
        },
        provide: f => [ showTooltip.from(f, val => val.tooltip), EditorView.contentAttributes.from(f, state => state.attrs) ]
    });
    function applyCompletion(view, option) {
        var apply = option.completion.apply || option.completion.label, result = view.state.field(completionState).active.find(a => a.source == option.source);
        return !1 && ("string" == typeof apply ? view.dispatch(Object.assign(Object.assign({}, function(state, text, from, to) {
            let main = state.selection["main"], fromOff = from - main.from, toOff = to - main.from;
            return Object.assign(Object.assign({}, state.changeByRange(range => range != main && from != to && state.sliceDoc(range.from + fromOff, range.from + toOff) != state.sliceDoc(from, to) ? {
                range: range
            } : {
                changes: {
                    from: range.from + fromOff,
                    to: to == main.from ? range.to : range.from + toOff,
                    insert: text
                },
                range: EditorSelection.cursor(range.from + fromOff + text.length)
            })), {
                scrollIntoView: !0,
                userEvent: "input.complete"
            });
        }(view.state, apply, result.from, result.to)), {
            annotations: pickedCompletion.of(option.completion)
        })) : apply(view, option.completion, result.from, result.to), !0);
    }
    const createTooltip = completionTooltip(completionState, applyCompletion);
    function moveCompletionSelection(forward, by = "option") {
        return view => {
            var cState = view.state.field(completionState, !1);
            if (!cState || !cState.open || cState.open.disabled || Date.now() - cState.open.timestamp < view.state.facet(completionConfig).interactionDelay) return !1;
            let step = 1, tooltip;
            "page" == by && (tooltip = function(view, tooltip) {
                return !(view = view.plugin(tooltipPlugin)) || (tooltip = view.manager.tooltips.indexOf(tooltip)) < 0 ? null : view.manager.tooltipViews[tooltip];
            }(view, cState.open.tooltip)) && (step = Math.max(2, Math.floor(tooltip.dom.offsetHeight / tooltip.dom.querySelector("li").offsetHeight) - 1));
            var length = cState.open.options["length"];
            let selected = -1 < cState.open.selected ? cState.open.selected + step * (forward ? 1 : -1) : forward ? 0 : length - 1;
            return selected < 0 ? selected = "page" == by ? 0 : length - 1 : selected >= length && (selected = "page" == by ? length - 1 : 0), 
            view.dispatch({
                effects: setSelectedEffect.of(selected)
            }), !0;
        };
    }
    const baseTheme = EditorView.baseTheme({
        ".cm-tooltip.cm-tooltip-autocomplete": {
            "& > ul": {
                fontFamily: "monospace",
                whiteSpace: "nowrap",
                overflow: "hidden auto",
                maxWidth_fallback: "700px",
                maxWidth: "min(700px, 95vw)",
                minWidth: "250px",
                maxHeight: "10em",
                height: "100%",
                listStyle: "none",
                margin: 0,
                padding: 0,
                "& > li, & > completion-section": {
                    padding: "1px 3px",
                    lineHeight: 1.2
                },
                "& > li": {
                    overflowX: "hidden",
                    textOverflow: "ellipsis",
                    cursor: "pointer"
                },
                "& > completion-section": {
                    display: "list-item",
                    borderBottom: "1px solid silver",
                    paddingLeft: "0.5em",
                    opacity: .7
                }
            }
        },
        "&light .cm-tooltip-autocomplete ul li[aria-selected]": {
            background: "#17c",
            color: "white"
        },
        "&light .cm-tooltip-autocomplete-disabled ul li[aria-selected]": {
            background: "#777"
        },
        "&dark .cm-tooltip-autocomplete ul li[aria-selected]": {
            background: "#347",
            color: "white"
        },
        "&dark .cm-tooltip-autocomplete-disabled ul li[aria-selected]": {
            background: "#444"
        },
        ".cm-completionListIncompleteTop:before, .cm-completionListIncompleteBottom:after": {
            content: '"\xb7\xb7\xb7"',
            opacity: .5,
            display: "block",
            textAlign: "center"
        },
        ".cm-tooltip.cm-completionInfo": {
            position: "absolute",
            padding: "3px 9px",
            width: "max-content",
            maxWidth: "400px",
            boxSizing: "border-box"
        },
        ".cm-completionInfo.cm-completionInfo-left": {
            right: "100%"
        },
        ".cm-completionInfo.cm-completionInfo-right": {
            left: "100%"
        },
        ".cm-completionInfo.cm-completionInfo-left-narrow": {
            right: "30px"
        },
        ".cm-completionInfo.cm-completionInfo-right-narrow": {
            left: "30px"
        },
        "&light .cm-snippetField": {
            backgroundColor: "#00000022"
        },
        "&dark .cm-snippetField": {
            backgroundColor: "#ffffff22"
        },
        ".cm-snippetFieldPosition": {
            verticalAlign: "text-top",
            width: 0,
            height: "1.15em",
            display: "inline-block",
            margin: "0 -0.7px -.7em",
            borderLeft: "1.4px dotted #888"
        },
        ".cm-completionMatchedText": {
            textDecoration: "underline"
        },
        ".cm-completionDetail": {
            marginLeft: "0.5em",
            fontStyle: "italic"
        },
        ".cm-completionIcon": {
            fontSize: "90%",
            width: ".8em",
            display: "inline-block",
            textAlign: "center",
            paddingRight: ".6em",
            opacity: "0.6",
            boxSizing: "content-box"
        },
        ".cm-completionIcon-function, .cm-completionIcon-method": {
            "&:after": {
                content: "'\u0192'"
            }
        },
        ".cm-completionIcon-class": {
            "&:after": {
                content: "'\u25cb'"
            }
        },
        ".cm-completionIcon-interface": {
            "&:after": {
                content: "'\u25cc'"
            }
        },
        ".cm-completionIcon-variable": {
            "&:after": {
                content: "'\ud835\udc65'"
            }
        },
        ".cm-completionIcon-constant": {
            "&:after": {
                content: "'\ud835\udc36'"
            }
        },
        ".cm-completionIcon-type": {
            "&:after": {
                content: "'\ud835\udc61'"
            }
        },
        ".cm-completionIcon-enum": {
            "&:after": {
                content: "'\u222a'"
            }
        },
        ".cm-completionIcon-property": {
            "&:after": {
                content: "'\u25a1'"
            }
        },
        ".cm-completionIcon-keyword": {
            "&:after": {
                content: "'\ud83d\udd11\ufe0e'"
            }
        },
        ".cm-completionIcon-namespace": {
            "&:after": {
                content: "'\u25a2'"
            }
        },
        ".cm-completionIcon-text": {
            "&:after": {
                content: "'abc'",
                fontSize: "50%",
                verticalAlign: "middle"
            }
        }
    });
    class FieldPos {
        constructor(field, line, from, to) {
            this.field = field, this.line = line, this.from = from, this.to = to;
        }
    }
    class FieldRange {
        constructor(field, from, to) {
            this.field = field, this.from = from, this.to = to;
        }
        map(changes) {
            var from = changes.mapPos(this.from, -1, MapMode.TrackDel), changes = changes.mapPos(this.to, 1, MapMode.TrackDel);
            return null == from || null == changes ? null : new FieldRange(this.field, from, changes);
        }
    }
    class Snippet {
        constructor(lines, fieldPositions) {
            this.lines = lines, this.fieldPositions = fieldPositions;
        }
        instantiate(state, pos) {
            let text = [], lineStart = [ pos ];
            var line, lineObj = state.doc.lineAt(pos), baseIndent = /^\s*/.exec(lineObj.text)[0];
            for (line of this.lines) {
                if (text.length) {
                    let indent = baseIndent, tabs = /^\t*/.exec(line)[0].length;
                    for (let i = 0; i < tabs; i++) indent += state.facet(indentUnit);
                    lineStart.push(pos + indent.length - tabs), line = indent + line.slice(tabs);
                }
                text.push(line), pos += line.length + 1;
            }
            lineObj = this.fieldPositions.map(pos => new FieldRange(pos.field, lineStart[pos.line] + pos.from, lineStart[pos.line] + pos.to));
            return {
                text: text,
                ranges: lineObj
            };
        }
        static parse(template) {
            var m, line, esc, fields = [], lines = [], positions = [];
            for (line of template.split(/\r\n?|\n/)) {
                for (;m = /[#$]\{(?:(\d+)(?::([^}]*))?|([^}]*))\}/.exec(line); ) {
                    let seq = m[1] ? +m[1] : null, name = m[2] || m[3] || "", found = -1;
                    for (let i = 0; i < fields.length; i++) (null != seq ? fields[i].seq == seq : name && fields[i].name == name) && (found = i);
                    if (found < 0) {
                        let i = 0;
                        for (;i < fields.length && (null == seq || null != fields[i].seq && fields[i].seq < seq); ) i++;
                        fields.splice(i, 0, {
                            seq: seq,
                            name: name
                        }), found = i;
                        for (var pos of positions) pos.field >= found && pos.field++;
                    }
                    positions.push(new FieldPos(found, lines.length, m.index, m.index + name.length)), 
                    line = line.slice(0, m.index) + name + line.slice(m.index + m[0].length);
                }
                for (;esc = /\\([{}])/.exec(line); ) {
                    line = line.slice(0, esc.index) + esc[1] + line.slice(esc.index + esc[0].length);
                    for (let pos of positions) pos.line == lines.length && pos.from > esc.index && (pos.from--, 
                    pos.to--);
                }
                lines.push(line);
            }
            return new Snippet(lines, positions);
        }
    }
    let fieldMarker = Decoration.widget({
        widget: new class extends WidgetType {
            toDOM() {
                var span = document.createElement("span");
                return span.className = "cm-snippetFieldPosition", span;
            }
            ignoreEvent() {
                return !1;
            }
        }()
    }), fieldRange = Decoration.mark({
        class: "cm-snippetField"
    });
    class ActiveSnippet {
        constructor(ranges, active) {
            this.ranges = ranges, this.active = active, this.deco = Decoration.set(ranges.map(r => (r.from == r.to ? fieldMarker : fieldRange).range(r.from, r.to)));
        }
        map(changes) {
            var r, ranges = [];
            for (r of this.ranges) {
                var mapped = r.map(changes);
                if (!mapped) return null;
                ranges.push(mapped);
            }
            return new ActiveSnippet(ranges, this.active);
        }
        selectionInsideField(sel) {
            return sel.ranges.every(range => this.ranges.some(r => r.field == this.active && r.from <= range.from && r.to >= range.to));
        }
    }
    const setActive = StateEffect.define({
        map(value, changes) {
            return value && value.map(changes);
        }
    }), moveToField = StateEffect.define(), snippetState = StateField.define({
        create() {
            return null;
        },
        update(value, tr) {
            for (var effect of tr.effects) {
                if (effect.is(setActive)) return effect.value;
                if (effect.is(moveToField) && value) return new ActiveSnippet(value.ranges, effect.value);
            }
            return value = (value = value && tr.docChanged ? value.map(tr.changes) : value) && tr.selection && !value.selectionInsideField(tr.selection) ? null : value;
        },
        provide: f => EditorView.decorations.from(f, val => val ? val.deco : Decoration.none)
    });
    function fieldSelection(ranges, field) {
        return EditorSelection.create(ranges.filter(r => r.field == field).map(r => EditorSelection.range(r.from, r.to)));
    }
    function moveField(dir) {
        return ({
            state,
            dispatch
        }) => {
            var active = state.field(snippetState, !1);
            if (!active || dir < 0 && 0 == active.active) return !1;
            let next = active.active + dir, last = 0 < dir && !active.ranges.some(r => r.field == next + dir);
            return dispatch(state.update({
                selection: fieldSelection(active.ranges, next),
                effects: setActive.of(last ? null : new ActiveSnippet(active.ranges, next)),
                scrollIntoView: !0
            })), !0;
        };
    }
    const defaultSnippetKeymap = [ {
        key: "Tab",
        run: moveField(1),
        shift: moveField(-1)
    }, {
        key: "Escape",
        run: ({
            state,
            dispatch
        }) => {
            return !!state.field(snippetState, !1) && (dispatch(state.update({
                effects: setActive.of(null)
            })), !0);
        }
    } ], snippetKeymap = Facet.define({
        combine(maps) {
            return maps.length ? maps[0] : defaultSnippetKeymap;
        }
    }), addSnippetKeymap = Prec.highest(keymap.compute([ snippetKeymap ], state => state.facet(snippetKeymap)));
    function snippetCompletion(template, completion) {
        return Object.assign(Object.assign({}, completion), {
            apply: function(template) {
                let snippet = Snippet.parse(template);
                return (editor, completion, from, to) => {
                    var {
                        text,
                        ranges
                    } = snippet.instantiate(editor.state, from), from = {
                        changes: {
                            from: from,
                            to: to,
                            insert: Text.of(text)
                        },
                        scrollIntoView: !0,
                        annotations: completion ? [ pickedCompletion.of(completion), Transaction.userEvent.of("input.complete") ] : void 0
                    };
                    ranges.length && (from.selection = fieldSelection(ranges, 0)), 
                    ranges.some(r => 0 < r.field) && (to = new ActiveSnippet(ranges, 0), 
                    text = from.effects = [ setActive.of(to) ], void 0 === editor.state.field(snippetState, !1)) && text.push(StateEffect.appendConfig.of([ snippetState, addSnippetKeymap, snippetPointerHandler, baseTheme ])), 
                    editor.dispatch(editor.state.update(from));
                };
            }(template)
        });
    }
    const snippetPointerHandler = EditorView.domEventHandlers({
        mousedown(event, view) {
            let active = view.state.field(snippetState, !1), pos;
            if (!active || null == (pos = view.posAtCoords({
                x: event.clientX,
                y: event.clientY
            }))) return !1;
            let match = active.ranges.find(r => r.from <= pos && r.to >= pos);
            return !(!match || match.field == active.active || (view.dispatch({
                selection: fieldSelection(active.ranges, match.field),
                effects: setActive.of(active.ranges.some(r => r.field > match.field) ? new ActiveSnippet(active.ranges, match.field) : null),
                scrollIntoView: !0
            }), 0));
        }
    }), defaults = {
        brackets: [ "(", "[", "{", "'", '"' ],
        before: ")]}:;>",
        stringPrefixes: []
    }, closeBracketEffect = StateEffect.define({
        map(value, mapping) {
            mapping = mapping.mapPos(value, -1, MapMode.TrackAfter);
            return null == mapping ? void 0 : mapping;
        }
    }), closedBracket = new class extends RangeValue {}(), bracketState = (closedBracket.startSide = 1, 
    closedBracket.endSide = -1, StateField.define({
        create() {
            return RangeSet.empty;
        },
        update(value, tr) {
            if (value = value.map(tr.changes), tr.selection) {
                let line = tr.state.doc.lineAt(tr.selection.main.head);
                value = value.update({
                    filter: from => from >= line.from && from <= line.to
                });
            }
            for (var effect of tr.effects) effect.is(closeBracketEffect) && (value = value.update({
                add: [ closedBracket.range(effect.value, effect.value + 1) ]
            }));
            return value;
        }
    }));
    const definedClosing = "()[]{}<>";
    function closing(ch) {
        for (let i = 0; i < definedClosing.length; i += 2) if (definedClosing.charCodeAt(i) == ch) return definedClosing.charAt(i + 1);
        return fromCodePoint(ch < 128 ? ch : ch + 1);
    }
    function config(state, pos) {
        return state.languageDataAt("closeBrackets", pos)[0] || defaults;
    }
    const android$1 = "object" == typeof navigator && /Android\b/.test(navigator.userAgent), inputHandler = EditorView.inputHandler.of((view, from, to, insert) => {
        var sel;
        return !((android$1 ? view.composing : view.compositionStarted) || view.state.readOnly || (sel = view.state.selection.main, 
        2 < insert.length) || 2 == insert.length && 1 == codePointSize(codePointAt(insert, 0)) || from != sel.from || to != sel.to || !(from = function(state, bracket) {
            var conf = config(state, state.selection.main.head), tokens = conf.brackets || defaults.brackets;
            for (var tok of tokens) {
                var closed = closing(codePointAt(tok, 0));
                if (bracket == tok) return closed == tok ? function(state, token, allowTriple, config) {
                    let stringPrefixes = config.stringPrefixes || defaults.stringPrefixes, dont = null, changes = state.changeByRange(range => {
                        if (!range.empty) return {
                            changes: [ {
                                insert: token,
                                from: range.from
                            }, {
                                insert: token,
                                from: range.to
                            } ],
                            effects: closeBracketEffect.of(range.to + token.length),
                            range: EditorSelection.range(range.anchor + token.length, range.head + token.length)
                        };
                        let pos = range.head, next = nextChar(state.doc, pos), start;
                        if (next == token) {
                            if (nodeStart(state, pos)) return {
                                changes: {
                                    insert: token + token,
                                    from: pos
                                },
                                effects: closeBracketEffect.of(pos + token.length),
                                range: EditorSelection.cursor(pos + token.length)
                            };
                            var content;
                            if (closedBracketAt(state, pos)) return {
                                changes: {
                                    from: pos,
                                    to: pos + (content = allowTriple && state.sliceDoc(pos, pos + 3 * token.length) == token + token + token ? token + token + token : token).length,
                                    insert: content
                                },
                                range: EditorSelection.cursor(pos + content.length)
                            };
                        } else {
                            if (allowTriple && state.sliceDoc(pos - 2 * token.length, pos) == token + token && -1 < (start = canStartStringAt(state, pos - 2 * token.length, stringPrefixes)) && nodeStart(state, start)) return {
                                changes: {
                                    insert: token + token + token + token,
                                    from: pos
                                },
                                effects: closeBracketEffect.of(pos + token.length),
                                range: EditorSelection.cursor(pos + token.length)
                            };
                            if (state.charCategorizer(pos)(next) != CharCategory.Word && -1 < canStartStringAt(state, pos, stringPrefixes) && !function(state, pos, quoteToken, prefixes) {
                                let node = syntaxTree(state).resolveInner(pos, -1), maxPrefix = prefixes.reduce((m, p) => Math.max(m, p.length), 0);
                                for (let i = 0; i < 5; i++) {
                                    var start = state.sliceDoc(node.from, Math.min(node.to, node.from + quoteToken.length + maxPrefix)), quotePos = start.indexOf(quoteToken);
                                    if (!quotePos || -1 < quotePos && -1 < prefixes.indexOf(start.slice(0, quotePos))) {
                                        let first = node.firstChild;
                                        for (;first && first.from == node.from && first.to - first.from > quoteToken.length + quotePos; ) {
                                            if (state.sliceDoc(first.to - quoteToken.length, first.to) == quoteToken) return;
                                            first = first.firstChild;
                                        }
                                        return 1;
                                    }
                                    start = node.to == pos && node.parent;
                                    if (!start) break;
                                    node = start;
                                }
                                return;
                            }(state, pos, token, stringPrefixes)) return {
                                changes: {
                                    insert: token + token,
                                    from: pos
                                },
                                effects: closeBracketEffect.of(pos + token.length),
                                range: EditorSelection.cursor(pos + token.length)
                            };
                        }
                        return {
                            range: dont = range
                        };
                    });
                    return dont ? null : state.update(changes, {
                        scrollIntoView: !0,
                        userEvent: "input.type"
                    });
                }(state, tok, -1 < tokens.indexOf(tok + tok + tok), conf) : function(state, open, close, closeBefore) {
                    let dont = null, changes = state.changeByRange(range => {
                        var next;
                        return range.empty ? !(next = nextChar(state.doc, range.head)) || /\s/.test(next) || -1 < closeBefore.indexOf(next) ? {
                            changes: {
                                insert: open + close,
                                from: range.head
                            },
                            effects: closeBracketEffect.of(range.head + open.length),
                            range: EditorSelection.cursor(range.head + open.length)
                        } : {
                            range: dont = range
                        } : {
                            changes: [ {
                                insert: open,
                                from: range.from
                            }, {
                                insert: close,
                                from: range.to
                            } ],
                            effects: closeBracketEffect.of(range.to + open.length),
                            range: EditorSelection.range(range.anchor + open.length, range.head + open.length)
                        };
                    });
                    return dont ? null : state.update(changes, {
                        scrollIntoView: !0,
                        userEvent: "input.type"
                    });
                }(state, tok, closed, conf.before || defaults.before);
                if (bracket == closed && closedBracketAt(state, state.selection.main.from)) return function(state, close) {
                    let dont = null, changes = state.changeByRange(range => range.empty && nextChar(state.doc, range.head) == close ? {
                        changes: {
                            from: range.head,
                            to: range.head + close.length,
                            insert: close
                        },
                        range: EditorSelection.cursor(range.head + close.length)
                    } : dont = {
                        range: range
                    });
                    return dont ? null : state.update(changes, {
                        scrollIntoView: !0,
                        userEvent: "input.type"
                    });
                }(state, (tok, closed));
            }
            return null;
        }(view.state, insert)) || (view.dispatch(from), 0));
    });
    selectDocStart = [ {
        key: "Backspace",
        run: ({
            state,
            dispatch
        }) => {
            if (state.readOnly) return !1;
            let tokens = config(state, state.selection.main.head).brackets || defaults.brackets, dont = null, changes = state.changeByRange(range => {
                if (range.empty) {
                    var token, before = function(doc, pos) {
                        doc = doc.sliceString(pos - 2, pos);
                        return codePointSize(codePointAt(doc, 0)) == doc.length ? doc : doc.slice(1);
                    }(state.doc, range.head);
                    for (token of tokens) if (token == before && nextChar(state.doc, range.head) == closing(codePointAt(token, 0))) return {
                        changes: {
                            from: range.head - token.length,
                            to: range.head + token.length
                        },
                        range: EditorSelection.cursor(range.head - token.length)
                    };
                }
                return {
                    range: dont = range
                };
            });
            return dont || dispatch(state.update(changes, {
                scrollIntoView: !0,
                userEvent: "delete.backward"
            })), !dont;
        }
    } ];
    function closedBracketAt(state, pos) {
        let found = !1;
        return state.field(bracketState).between(0, state.doc.length, from => {
            from == pos && (found = !0);
        }), found;
    }
    function nextChar(doc, pos) {
        doc = doc.sliceString(pos, pos + 2);
        return doc.slice(0, codePointSize(codePointAt(doc, 0)));
    }
    function nodeStart(state, pos) {
        state = syntaxTree(state).resolveInner(pos + 1);
        return state.parent && state.from == pos;
    }
    function canStartStringAt(state, pos, prefixes) {
        var prefix, charCat = state.charCategorizer(pos);
        if (charCat(state.sliceDoc(pos - 1, pos)) != CharCategory.Word) return pos;
        for (prefix of prefixes) {
            var start = pos - prefix.length;
            if (state.sliceDoc(start, pos) == prefix && charCat(state.sliceDoc(start - 1, start)) != CharCategory.Word) return start;
        }
        return -1;
    }
    cursorDocEnd = [ {
        key: "Ctrl-Space",
        run: view => {
            return !!view.state.field(completionState, !1) && (view.dispatch({
                effects: startCompletionEffect.of(!0)
            }), !0);
        }
    }, {
        key: "Escape",
        run: view => {
            var cState = view.state.field(completionState, !1);
            return !(!cState || !cState.active.some(a => 0 != a.state) || (view.dispatch({
                effects: closeCompletionEffect.of(null)
            }), 0));
        }
    }, {
        key: "ArrowDown",
        run: moveCompletionSelection(!0)
    }, {
        key: "ArrowUp",
        run: moveCompletionSelection(!1)
    }, {
        key: "PageDown",
        run: moveCompletionSelection(!0, "page")
    }, {
        key: "PageUp",
        run: moveCompletionSelection(!1, "page")
    }, {
        key: "Enter",
        run: view => {
            var cState = view.state.field(completionState, !1);
            return !(view.state.readOnly || !cState || !cState.open || cState.open.selected < 0 || cState.open.disabled || Date.now() - cState.open.timestamp < view.state.facet(completionConfig).interactionDelay) && applyCompletion(view, cState.open.options[cState.open.selected]);
        }
    } ], selectDocEnd = [ EditorView.theme({
        "&": {
            color: "#abb2bf",
            backgroundColor: "#282c34"
        },
        ".cm-content": {
            caretColor: "#528bff"
        },
        ".cm-cursor, .cm-dropCursor": {
            borderLeftColor: "#528bff"
        },
        "&.cm-focused > .cm-scroller > .cm-selectionLayer .cm-selectionBackground, .cm-selectionBackground, .cm-content ::selection": {
            backgroundColor: "#3E4451"
        },
        ".cm-panels": {
            backgroundColor: "#21252b",
            color: "#abb2bf"
        },
        ".cm-panels.cm-panels-top": {
            borderBottom: "2px solid black"
        },
        ".cm-panels.cm-panels-bottom": {
            borderTop: "2px solid black"
        },
        ".cm-searchMatch": {
            backgroundColor: "#72a1ff59",
            outline: "1px solid #457dff"
        },
        ".cm-searchMatch.cm-searchMatch-selected": {
            backgroundColor: "#6199ff2f"
        },
        ".cm-activeLine": {
            backgroundColor: "#6699ff0b"
        },
        ".cm-selectionMatch": {
            backgroundColor: "#aafe661a"
        },
        "&.cm-focused .cm-matchingBracket, &.cm-focused .cm-nonmatchingBracket": {
            backgroundColor: "#bad0f847"
        },
        ".cm-gutters": {
            backgroundColor: "#282c34",
            color: "#7d8799",
            border: "none"
        },
        ".cm-activeLineGutter": {
            backgroundColor: "#2c313a"
        },
        ".cm-foldPlaceholder": {
            backgroundColor: "transparent",
            border: "none",
            color: "#ddd"
        },
        ".cm-tooltip": {
            border: "none",
            backgroundColor: "#353a42"
        },
        ".cm-tooltip .cm-tooltip-arrow:before": {
            borderTopColor: "transparent",
            borderBottomColor: "transparent"
        },
        ".cm-tooltip .cm-tooltip-arrow:after": {
            borderTopColor: "#353a42",
            borderBottomColor: "#353a42"
        },
        ".cm-tooltip-autocomplete": {
            "& > ul > li[aria-selected]": {
                backgroundColor: "#2c313a",
                color: "#abb2bf"
            }
        }
    }, {
        dark: !0
    }), syntaxHighlighting(HighlightStyle.define([ {
        tag: tags$1.keyword,
        color: "#c678dd"
    }, {
        tag: [ tags$1.name, tags$1.deleted, tags$1.character, tags$1.propertyName, tags$1.macroName ],
        color: "#e06c75"
    }, {
        tag: [ tags$1.function(tags$1.variableName), tags$1.labelName ],
        color: "#61afef"
    }, {
        tag: [ tags$1.color, tags$1.constant(tags$1.name), tags$1.standard(tags$1.name) ],
        color: "#d19a66"
    }, {
        tag: [ tags$1.definition(tags$1.name), tags$1.separator ],
        color: "#abb2bf"
    }, {
        tag: [ tags$1.typeName, tags$1.className, tags$1.number, tags$1.changed, tags$1.annotation, tags$1.modifier, tags$1.self, tags$1.namespace ],
        color: "#e5c07b"
    }, {
        tag: [ tags$1.operator, tags$1.operatorKeyword, tags$1.url, tags$1.escape, tags$1.regexp, tags$1.link, tags$1.special(tags$1.string) ],
        color: "#56b6c2"
    }, {
        tag: [ tags$1.meta, tags$1.comment ],
        color: "#7d8799"
    }, {
        tag: tags$1.strong,
        fontWeight: "bold"
    }, {
        tag: tags$1.emphasis,
        fontStyle: "italic"
    }, {
        tag: tags$1.strikethrough,
        textDecoration: "line-through"
    }, {
        tag: tags$1.link,
        color: "#7d8799",
        textDecoration: "underline"
    }, {
        tag: tags$1.heading,
        fontWeight: "bold",
        color: "#e06c75"
    }, {
        tag: [ tags$1.atom, tags$1.bool, tags$1.special(tags$1.variableName) ],
        color: "#d19a66"
    }, {
        tag: [ tags$1.processingInstruction, tags$1.string, tags$1.inserted ],
        color: "#98c379"
    }, {
        tag: tags$1.invalid,
        color: "#ffffff"
    } ])) ], operator = HighlightStyle.define([ {
        tag: tags$1.meta,
        color: "#444"
    }, {
        tag: tags$1.link,
        textDecoration: "underline"
    }, {
        tag: tags$1.heading,
        textDecoration: "underline",
        fontWeight: "bold"
    }, {
        tag: tags$1.emphasis,
        fontStyle: "italic"
    }, {
        tag: tags$1.strong,
        fontWeight: "bold"
    }, {
        tag: tags$1.strikethrough,
        textDecoration: "line-through"
    }, {
        tag: tags$1.keyword,
        color: "#444"
    }, {
        tag: [ tags$1.atom, tags$1.bool, tags$1.url, tags$1.contentSeparator, tags$1.labelName ],
        color: "#444"
    }, {
        tag: [ tags$1.literal, tags$1.inserted ],
        color: "#444"
    }, {
        tag: [ tags$1.string, tags$1.deleted ],
        color: "#444"
    }, {
        tag: [ tags$1.regexp, tags$1.escape, tags$1.special(tags$1.string) ],
        color: "#444"
    }, {
        tag: tags$1.definition(tags$1.variableName),
        color: "#444"
    }, {
        tag: tags$1.local(tags$1.variableName),
        color: "#444"
    }, {
        tag: [ tags$1.typeName, tags$1.namespace ],
        color: "#444"
    }, {
        tag: tags$1.className,
        color: "#444"
    }, {
        tag: [ tags$1.special(tags$1.variableName), tags$1.macroName ],
        color: "#444"
    }, {
        tag: tags$1.definition(tags$1.propertyName),
        color: "#444"
    }, {
        tag: tags$1.comment,
        color: "#444"
    }, {
        tag: tags$1.invalid,
        color: "#444"
    } ]), meta = HighlightStyle.define([ {
        tag: tags$1.keyword,
        color: "#170"
    }, {
        tag: [ tags$1.name, tags$1.deleted, tags$1.character, tags$1.propertyName, tags$1.macroName ],
        color: "#219"
    }, {
        tag: [ tags$1.function(tags$1.variableName), tags$1.labelName ],
        color: "#219"
    }, {
        tag: [ tags$1.color, tags$1.constant(tags$1.name), tags$1.standard(tags$1.name) ],
        color: "#30a"
    }, {
        tag: [ tags$1.definition(tags$1.name), tags$1.separator ],
        color: "#888"
    }, {
        tag: [ tags$1.typeName, tags$1.className, tags$1.number, tags$1.changed, tags$1.annotation, tags$1.modifier, tags$1.self, tags$1.namespace ],
        color: "#170"
    }, {
        tag: [ tags$1.operator, tags$1.operatorKeyword, tags$1.url, tags$1.escape, tags$1.regexp, tags$1.link, tags$1.special(tags$1.string) ],
        color: "#05a"
    }, {
        tag: [ tags$1.meta, tags$1.comment ],
        color: "#a50"
    }, {
        tag: tags$1.strong,
        fontWeight: "bold"
    }, {
        tag: tags$1.emphasis,
        fontStyle: "italic"
    }, {
        tag: tags$1.strikethrough,
        textDecoration: "line-through"
    }, {
        tag: tags$1.link,
        color: "#a50",
        textDecoration: "underline"
    }, {
        tag: tags$1.heading,
        fontWeight: "bold",
        color: "#00f"
    }, {
        tag: [ tags$1.atom, tags$1.special(tags$1.variableName) ],
        color: "#219"
    }, {
        tag: [ tags$1.bool ],
        color: "#00f"
    }, {
        tag: [ tags$1.processingInstruction ],
        color: "#888"
    }, {
        tag: [ tags$1.string, tags$1.inserted ],
        color: "#a11"
    }, {
        tag: tags$1.invalid,
        color: "#f00"
    } ]), punctuation = ({
        variant,
        settings,
        styles
    }) => {
        return [ EditorView.theme({
            "&": {
                backgroundColor: settings.background,
                color: settings.foreground
            },
            ".cm-content": {
                caretColor: settings.caret
            },
            ".cm-cursor, .cm-dropCursor": {
                borderLeftColor: settings.caret
            },
            "&.cm-focused .cm-selectionBackgroundm .cm-selectionBackground, .cm-content ::selection": {
                backgroundColor: settings.selection
            },
            ".cm-activeLine": {
                backgroundColor: settings.lineHighlight
            },
            ".cm-gutters": {
                backgroundColor: settings.gutterBackground,
                color: settings.gutterForeground
            },
            ".cm-activeLineGutter": {
                backgroundColor: settings.lineHighlight
            }
        }, {
            dark: "dark" === variant
        }), syntaxHighlighting(HighlightStyle.define(styles)) ];
    }, punctuation({
        variant: "dark",
        settings: {
            background: "#200020",
            foreground: "#D0D0FF",
            caret: "#7070FF",
            selection: "#80000080",
            gutterBackground: "#200020",
            gutterForeground: "#C080C0",
            lineHighlight: "#80000040"
        },
        styles: [ {
            tag: tags$1.comment,
            color: "#404080"
        }, {
            tag: [ tags$1.string, tags$1.regexp ],
            color: "#999999"
        }, {
            tag: tags$1.number,
            color: "#7090B0"
        }, {
            tag: [ tags$1.bool, tags$1.null ],
            color: "#8080A0"
        }, {
            tag: [ tags$1.punctuation, tags$1.derefOperator ],
            color: "#805080"
        }, {
            tag: tags$1.keyword,
            color: "#60B0FF"
        }, {
            tag: tags$1.definitionKeyword,
            color: "#B0FFF0"
        }, {
            tag: tags$1.moduleKeyword,
            color: "#60B0FF"
        }, {
            tag: tags$1.operator,
            color: "#A0A0FF"
        }, {
            tag: [ tags$1.variableName, tags$1.self ],
            color: "#008080"
        }, {
            tag: tags$1.operatorKeyword,
            color: "#A0A0FF"
        }, {
            tag: tags$1.controlKeyword,
            color: "#80A0FF"
        }, {
            tag: tags$1.className,
            color: "#70E080"
        }, {
            tag: [ tags$1.function(tags$1.propertyName), tags$1.propertyName ],
            color: "#50A0A0"
        }, {
            tag: tags$1.tagName,
            color: "#009090"
        }, {
            tag: tags$1.modifier,
            color: "#B0FFF0"
        }, {
            tag: [ tags$1.squareBracket, tags$1.attributeName ],
            color: "#D0D0FF"
        } ]
    }), gecko = punctuation({
        variant: "light",
        settings: {
            background: "#fcfcfc",
            foreground: "#5c6166",
            caret: "#ffaa33",
            selection: "#036dd626",
            gutterBackground: "#fcfcfc",
            gutterForeground: "#8a919966",
            lineHighlight: "#8a91991a"
        },
        styles: [ {
            tag: tags$1.comment,
            color: "#787b8099"
        }, {
            tag: tags$1.string,
            color: "#86b300"
        }, {
            tag: tags$1.regexp,
            color: "#4cbf99"
        }, {
            tag: [ tags$1.number, tags$1.bool, tags$1.null ],
            color: "#ffaa33"
        }, {
            tag: tags$1.variableName,
            color: "#5c6166"
        }, {
            tag: [ tags$1.definitionKeyword, tags$1.modifier ],
            color: "#fa8d3e"
        }, {
            tag: [ tags$1.keyword, tags$1.special(tags$1.brace) ],
            color: "#fa8d3e"
        }, {
            tag: tags$1.operator,
            color: "#ed9366"
        }, {
            tag: tags$1.separator,
            color: "#5c6166b3"
        }, {
            tag: tags$1.punctuation,
            color: "#5c6166"
        }, {
            tag: [ tags$1.definition(tags$1.propertyName), tags$1.function(tags$1.variableName) ],
            color: "#f2ae49"
        }, {
            tag: [ tags$1.className, tags$1.definition(tags$1.typeName) ],
            color: "#22a4e6"
        }, {
            tag: [ tags$1.tagName, tags$1.typeName, tags$1.self, tags$1.labelName ],
            color: "#55b4d4"
        }, {
            tag: tags$1.angleBracket,
            color: "#55b4d480"
        }, {
            tag: tags$1.attributeName,
            color: "#f2ae49"
        } ]
    }), punctuation({
        variant: "dark",
        settings: {
            background: "#15191EFA",
            foreground: "#EEF2F7",
            caret: "#C4C4C4",
            selection: "#90B2D557",
            gutterBackground: "#15191EFA",
            gutterForeground: "#aaaaaa95",
            lineHighlight: "#57575712"
        },
        styles: [ {
            tag: tags$1.comment,
            color: "#6E6E6E"
        }, {
            tag: [ tags$1.string, tags$1.regexp, tags$1.special(tags$1.brace) ],
            color: "#5C81B3"
        }, {
            tag: tags$1.number,
            color: "#C1E1B8"
        }, {
            tag: tags$1.bool,
            color: "#53667D"
        }, {
            tag: [ tags$1.definitionKeyword, tags$1.modifier, tags$1.function(tags$1.propertyName) ],
            color: "#A3D295",
            fontWeight: "bold"
        }, {
            tag: [ tags$1.keyword, tags$1.moduleKeyword, tags$1.operatorKeyword, tags$1.operator ],
            color: "#697A8E",
            fontWeight: "bold"
        }, {
            tag: [ tags$1.variableName, tags$1.attributeName ],
            color: "#708E67"
        }, {
            tag: [ tags$1.function(tags$1.variableName), tags$1.definition(tags$1.propertyName), tags$1.derefOperator ],
            color: "#fff"
        }, {
            tag: tags$1.tagName,
            color: "#A3D295"
        } ]
    }), bracket = punctuation({
        variant: "dark",
        settings: {
            background: "#2e241d",
            foreground: "#BAAE9E",
            caret: "#A7A7A7",
            selection: "#DDF0FF33",
            gutterBackground: "#28211C",
            gutterForeground: "#BAAE9E90",
            lineHighlight: "#FFFFFF08"
        },
        styles: [ {
            tag: tags$1.comment,
            color: "#666666"
        }, {
            tag: [ tags$1.string, tags$1.special(tags$1.brace) ],
            color: "#54BE0D"
        }, {
            tag: tags$1.regexp,
            color: "#E9C062"
        }, {
            tag: tags$1.number,
            color: "#CF6A4C"
        }, {
            tag: [ tags$1.keyword, tags$1.operator ],
            color: "#5EA6EA"
        }, {
            tag: tags$1.variableName,
            color: "#7587A6"
        }, {
            tag: [ tags$1.definitionKeyword, tags$1.modifier ],
            color: "#F9EE98"
        }, {
            tag: [ tags$1.propertyName, tags$1.function(tags$1.variableName) ],
            color: "#937121"
        }, {
            tag: [ tags$1.typeName, tags$1.angleBracket, tags$1.tagName ],
            color: "#9B859D"
        } ]
    }), punctuation({
        variant: "dark",
        settings: {
            background: "#3b2627",
            foreground: "#E6E1C4",
            caret: "#E6E1C4",
            selection: "#16120E",
            gutterBackground: "#3b2627",
            gutterForeground: "#E6E1C490",
            lineHighlight: "#1F1611"
        },
        styles: [ {
            tag: tags$1.comment,
            color: "#6B4E32"
        }, {
            tag: [ tags$1.keyword, tags$1.operator, tags$1.derefOperator ],
            color: "#EF5D32"
        }, {
            tag: tags$1.className,
            color: "#EFAC32",
            fontWeight: "bold"
        }, {
            tag: [ tags$1.typeName, tags$1.propertyName, tags$1.function(tags$1.variableName), tags$1.definition(tags$1.variableName) ],
            color: "#EFAC32"
        }, {
            tag: tags$1.definition(tags$1.typeName),
            color: "#EFAC32",
            fontWeight: "bold"
        }, {
            tag: tags$1.labelName,
            color: "#EFAC32",
            fontWeight: "bold"
        }, {
            tag: [ tags$1.number, tags$1.bool ],
            color: "#6C99BB"
        }, {
            tag: [ tags$1.variableName, tags$1.self ],
            color: "#7DAF9C"
        }, {
            tag: [ tags$1.string, tags$1.special(tags$1.brace), tags$1.regexp ],
            color: "#D9D762"
        }, {
            tag: [ tags$1.angleBracket, tags$1.tagName, tags$1.attributeName ],
            color: "#EFCB43"
        } ]
    }), punctuation({
        variant: "dark",
        settings: {
            background: "#000205",
            foreground: "#FFFFFF",
            caret: "#E60065",
            selection: "#E60C6559",
            gutterBackground: "#000205",
            gutterForeground: "#ffffff90",
            lineHighlight: "#4DD7FC1A"
        },
        styles: [ {
            tag: tags$1.comment,
            color: "#404040"
        }, {
            tag: [ tags$1.string, tags$1.special(tags$1.brace), tags$1.regexp ],
            color: "#00D8FF"
        }, {
            tag: tags$1.number,
            color: "#E62286"
        }, {
            tag: [ tags$1.variableName, tags$1.attributeName, tags$1.self ],
            color: "#E62286",
            fontWeight: "bold"
        }, {
            tag: tags$1.function(tags$1.variableName),
            color: "#fff",
            fontWeight: "bold"
        } ]
    }), chrome = punctuation({
        variant: "light",
        settings: {
            background: "#fff",
            foreground: "#000",
            caret: "#000",
            selection: "#BDD5FC",
            gutterBackground: "#fff",
            gutterForeground: "#00000070",
            lineHighlight: "#FFFBD1"
        },
        styles: [ {
            tag: tags$1.comment,
            color: "#BCC8BA"
        }, {
            tag: [ tags$1.string, tags$1.special(tags$1.brace), tags$1.regexp ],
            color: "#5D90CD"
        }, {
            tag: [ tags$1.number, tags$1.bool, tags$1.null ],
            color: "#46A609"
        }, {
            tag: tags$1.keyword,
            color: "#AF956F"
        }, {
            tag: [ tags$1.definitionKeyword, tags$1.modifier ],
            color: "#C52727"
        }, {
            tag: [ tags$1.angleBracket, tags$1.tagName, tags$1.attributeName ],
            color: "#606060"
        }, {
            tag: tags$1.self,
            color: "#000"
        } ]
    }), ie_upto10 = punctuation({
        variant: "dark",
        settings: {
            background: "#00254b",
            foreground: "#FFFFFF",
            caret: "#FFFFFF",
            selection: "#B36539BF",
            gutterBackground: "#00254b",
            gutterForeground: "#FFFFFF70",
            lineHighlight: "#00000059"
        },
        styles: [ {
            tag: tags$1.comment,
            color: "#0088FF"
        }, {
            tag: tags$1.string,
            color: "#3AD900"
        }, {
            tag: tags$1.regexp,
            color: "#80FFC2"
        }, {
            tag: [ tags$1.number, tags$1.bool, tags$1.null ],
            color: "#FF628C"
        }, {
            tag: [ tags$1.definitionKeyword, tags$1.modifier ],
            color: "#FFEE80"
        }, {
            tag: tags$1.variableName,
            color: "#CCCCCC"
        }, {
            tag: tags$1.self,
            color: "#FF80E1"
        }, {
            tag: [ tags$1.className, tags$1.definition(tags$1.propertyName), tags$1.function(tags$1.variableName), tags$1.definition(tags$1.typeName), tags$1.labelName ],
            color: "#FFDD00"
        }, {
            tag: [ tags$1.keyword, tags$1.operator ],
            color: "#FF9D00"
        }, {
            tag: [ tags$1.propertyName, tags$1.typeName ],
            color: "#80FFBB"
        }, {
            tag: tags$1.special(tags$1.brace),
            color: "#EDEF7D"
        }, {
            tag: tags$1.attributeName,
            color: "#9EFFFF"
        }, {
            tag: tags$1.derefOperator,
            color: "#fff"
        } ]
    }), punctuation({
        variant: "dark",
        settings: {
            background: "#060521",
            foreground: "#E0E0E0",
            caret: "#FFFFFFA6",
            selection: "#122BBB",
            gutterBackground: "#060521",
            gutterForeground: "#E0E0E090",
            lineHighlight: "#FFFFFF0F"
        },
        styles: [ {
            tag: tags$1.comment,
            color: "#AEAEAE"
        }, {
            tag: [ tags$1.string, tags$1.special(tags$1.brace), tags$1.regexp ],
            color: "#8DFF8E"
        }, {
            tag: [ tags$1.className, tags$1.definition(tags$1.propertyName), tags$1.function(tags$1.variableName), tags$1.function(tags$1.definition(tags$1.variableName)), tags$1.definition(tags$1.typeName) ],
            color: "#A3EBFF"
        }, {
            tag: [ tags$1.number, tags$1.bool, tags$1.null ],
            color: "#62E9BD"
        }, {
            tag: [ tags$1.keyword, tags$1.operator ],
            color: "#2BF1DC"
        }, {
            tag: [ tags$1.definitionKeyword, tags$1.modifier ],
            color: "#F8FBB1"
        }, {
            tag: [ tags$1.variableName, tags$1.self ],
            color: "#B683CA"
        }, {
            tag: [ tags$1.angleBracket, tags$1.tagName, tags$1.typeName, tags$1.propertyName ],
            color: "#60A4F1"
        }, {
            tag: tags$1.derefOperator,
            color: "#E0E0E0"
        }, {
            tag: tags$1.attributeName,
            color: "#7BACCA"
        } ]
    }), doc = punctuation({
        variant: "dark",
        settings: {
            background: "#2d2f3f",
            foreground: "#f8f8f2",
            caret: "#f8f8f0",
            selection: "#44475a",
            gutterBackground: "#282a36",
            gutterForeground: "rgb(144, 145, 148)",
            lineHighlight: "#44475a"
        },
        styles: [ {
            tag: tags$1.comment,
            color: "#6272a4"
        }, {
            tag: [ tags$1.string, tags$1.special(tags$1.brace) ],
            color: "#f1fa8c"
        }, {
            tag: [ tags$1.number, tags$1.self, tags$1.bool, tags$1.null ],
            color: "#bd93f9"
        }, {
            tag: [ tags$1.keyword, tags$1.operator ],
            color: "#ff79c6"
        }, {
            tag: [ tags$1.definitionKeyword, tags$1.typeName ],
            color: "#8be9fd"
        }, {
            tag: tags$1.definition(tags$1.typeName),
            color: "#f8f8f2"
        }, {
            tag: [ tags$1.className, tags$1.definition(tags$1.propertyName), tags$1.function(tags$1.variableName), tags$1.attributeName ],
            color: "#50fa7b"
        } ]
    }), deleteCharForward = punctuation({
        variant: "light",
        settings: {
            background: "#FFFFFF",
            foreground: "#000000",
            caret: "#000000",
            selection: "#80C7FF",
            gutterBackground: "#FFFFFF",
            gutterForeground: "#00000070",
            lineHighlight: "#C1E2F8"
        },
        styles: [ {
            tag: tags$1.comment,
            color: "#AAAAAA"
        }, {
            tag: [ tags$1.keyword, tags$1.operator, tags$1.typeName, tags$1.tagName, tags$1.propertyName ],
            color: "#2F6F9F",
            fontWeight: "bold"
        }, {
            tag: [ tags$1.attributeName, tags$1.definition(tags$1.propertyName) ],
            color: "#4F9FD0"
        }, {
            tag: [ tags$1.className, tags$1.string, tags$1.special(tags$1.brace) ],
            color: "#CF4F5F"
        }, {
            tag: tags$1.number,
            color: "#CF4F5F",
            fontWeight: "bold"
        }, {
            tag: tags$1.variableName,
            fontWeight: "bold"
        } ]
    }), deleteCharBackward = punctuation({
        variant: "light",
        settings: {
            background: "#f2f1f8",
            foreground: "#0c006b",
            caret: "#5c49e9",
            selection: "#d5d1f2",
            gutterBackground: "#f2f1f8",
            gutterForeground: "#0c006b70",
            lineHighlight: "#e1def3"
        },
        styles: [ {
            tag: tags$1.comment,
            color: "#9995b7"
        }, {
            tag: tags$1.keyword,
            color: "#ff5792",
            fontWeight: "bold"
        }, {
            tag: [ tags$1.definitionKeyword, tags$1.modifier ],
            color: "#ff5792"
        }, {
            tag: [ tags$1.className, tags$1.tagName, tags$1.definition(tags$1.typeName) ],
            color: "#0094f0"
        }, {
            tag: [ tags$1.number, tags$1.bool, tags$1.null, tags$1.special(tags$1.brace) ],
            color: "#5842ff"
        }, {
            tag: [ tags$1.definition(tags$1.propertyName), tags$1.function(tags$1.variableName) ],
            color: "#0095a8"
        }, {
            tag: tags$1.typeName,
            color: "#b3694d"
        }, {
            tag: [ tags$1.propertyName, tags$1.variableName ],
            color: "#fa8900"
        }, {
            tag: tags$1.operator,
            color: "#ff5792"
        }, {
            tag: tags$1.self,
            color: "#e64100"
        }, {
            tag: [ tags$1.string, tags$1.regexp ],
            color: "#00b368"
        }, {
            tag: [ tags$1.paren, tags$1.bracket ],
            color: "#0431fa"
        }, {
            tag: tags$1.labelName,
            color: "#00bdd6"
        }, {
            tag: tags$1.attributeName,
            color: "#e64100"
        }, {
            tag: tags$1.angleBracket,
            color: "#9995b7"
        } ]
    }), deleteGroupBackward = punctuation({
        variant: "light",
        settings: {
            background: "#faf4ed",
            foreground: "#575279",
            caret: "#575279",
            selection: "#6e6a8614",
            gutterBackground: "#faf4ed",
            gutterForeground: "#57527970",
            lineHighlight: "#6e6a860d"
        },
        styles: [ {
            tag: tags$1.comment,
            color: "#9893a5"
        }, {
            tag: [ tags$1.bool, tags$1.null ],
            color: "#286983"
        }, {
            tag: tags$1.number,
            color: "#d7827e"
        }, {
            tag: tags$1.className,
            color: "#d7827e"
        }, {
            tag: [ tags$1.angleBracket, tags$1.tagName, tags$1.typeName ],
            color: "#56949f"
        }, {
            tag: tags$1.attributeName,
            color: "#907aa9"
        }, {
            tag: tags$1.punctuation,
            color: "#797593"
        }, {
            tag: [ tags$1.keyword, tags$1.modifier ],
            color: "#286983"
        }, {
            tag: [ tags$1.string, tags$1.regexp ],
            color: "#ea9d34"
        }, {
            tag: tags$1.variableName,
            color: "#d7827e"
        } ]
    }), ie_edge = punctuation({
        variant: "light",
        settings: {
            background: "#FFFFFF",
            foreground: "#000000",
            caret: "#000000",
            selection: "#FFFD0054",
            gutterBackground: "#FFFFFF",
            gutterForeground: "#00000070",
            lineHighlight: "#00000008"
        },
        styles: [ {
            tag: tags$1.comment,
            color: "#CFCFCF"
        }, {
            tag: [ tags$1.number, tags$1.bool, tags$1.null ],
            color: "#E66C29"
        }, {
            tag: [ tags$1.className, tags$1.definition(tags$1.propertyName), tags$1.function(tags$1.variableName), tags$1.labelName, tags$1.definition(tags$1.typeName) ],
            color: "#2EB43B"
        }, {
            tag: tags$1.keyword,
            color: "#D8B229"
        }, {
            tag: tags$1.operator,
            color: "#4EA44E",
            fontWeight: "bold"
        }, {
            tag: [ tags$1.definitionKeyword, tags$1.modifier ],
            color: "#925A47"
        }, {
            tag: tags$1.string,
            color: "#704D3D"
        }, {
            tag: tags$1.typeName,
            color: "#2F8996"
        }, {
            tag: [ tags$1.variableName, tags$1.propertyName ],
            color: "#77ACB0"
        }, {
            tag: tags$1.self,
            color: "#77ACB0",
            fontWeight: "bold"
        }, {
            tag: tags$1.regexp,
            color: "#E3965E"
        }, {
            tag: [ tags$1.tagName, tags$1.angleBracket ],
            color: "#BAA827"
        }, {
            tag: tags$1.attributeName,
            color: "#B06520"
        }, {
            tag: tags$1.derefOperator,
            color: "#000"
        } ]
    }), indentMore = punctuation({
        variant: "light",
        settings: {
            background: "#fef7e5",
            foreground: "#586E75",
            caret: "#000000",
            selection: "#073642",
            gutterBackground: "#fef7e5",
            gutterForeground: "#586E7580",
            lineHighlight: "#EEE8D5"
        },
        styles: [ {
            tag: tags$1.comment,
            color: "#93A1A1"
        }, {
            tag: tags$1.string,
            color: "#2AA198"
        }, {
            tag: tags$1.regexp,
            color: "#D30102"
        }, {
            tag: tags$1.number,
            color: "#D33682"
        }, {
            tag: tags$1.variableName,
            color: "#268BD2"
        }, {
            tag: [ tags$1.keyword, tags$1.operator, tags$1.punctuation ],
            color: "#859900"
        }, {
            tag: [ tags$1.definitionKeyword, tags$1.modifier ],
            color: "#073642",
            fontWeight: "bold"
        }, {
            tag: [ tags$1.className, tags$1.self, tags$1.definition(tags$1.propertyName) ],
            color: "#268BD2"
        }, {
            tag: tags$1.function(tags$1.variableName),
            color: "#268BD2"
        }, {
            tag: [ tags$1.bool, tags$1.null ],
            color: "#B58900"
        }, {
            tag: tags$1.tagName,
            color: "#268BD2",
            fontWeight: "bold"
        }, {
            tag: tags$1.angleBracket,
            color: "#93A1A1"
        }, {
            tag: tags$1.attributeName,
            color: "#93A1A1"
        }, {
            tag: tags$1.typeName,
            color: "#859900"
        } ]
    }), indentLess = punctuation({
        variant: "light",
        settings: {
            background: "#FFFFFF",
            foreground: "#4D4D4C",
            caret: "#AEAFAD",
            selection: "#D6D6D6",
            gutterBackground: "#FFFFFF",
            gutterForeground: "#4D4D4C80",
            lineHighlight: "#EFEFEF"
        },
        styles: [ {
            tag: tags$1.comment,
            color: "#8E908C"
        }, {
            tag: [ tags$1.variableName, tags$1.self, tags$1.propertyName, tags$1.attributeName, tags$1.regexp ],
            color: "#C82829"
        }, {
            tag: [ tags$1.number, tags$1.bool, tags$1.null ],
            color: "#F5871F"
        }, {
            tag: [ tags$1.className, tags$1.typeName, tags$1.definition(tags$1.typeName) ],
            color: "#C99E00"
        }, {
            tag: [ tags$1.string, tags$1.special(tags$1.brace) ],
            color: "#718C00"
        }, {
            tag: tags$1.operator,
            color: "#3E999F"
        }, {
            tag: [ tags$1.definition(tags$1.propertyName), tags$1.function(tags$1.variableName) ],
            color: "#4271AE"
        }, {
            tag: tags$1.keyword,
            color: "#8959A8"
        }, {
            tag: tags$1.derefOperator,
            color: "#4D4D4C"
        } ]
    });
    class Stack {
        constructor(p, stack, state, reducePos, pos, score, buffer, bufferBase, curContext, lookAhead = 0, parent) {
            this.p = p, this.stack = stack, this.state = state, this.reducePos = reducePos, 
            this.pos = pos, this.score = score, this.buffer = buffer, this.bufferBase = bufferBase, 
            this.curContext = curContext, this.lookAhead = lookAhead, this.parent = parent;
        }
        toString() {
            return `[${this.stack.filter((_, i) => i % 3 == 0).concat(this.state)}]@` + this.pos + (this.score ? "!" + this.score : "");
        }
        static start(p, state, pos = 0) {
            var cx = p.parser.context;
            return new Stack(p, [], state, pos, pos, 0, [], 0, cx ? new StackContext(cx, cx.start) : null, 0, null);
        }
        get context() {
            return this.curContext ? this.curContext.context : null;
        }
        pushState(state, start) {
            this.stack.push(this.state, start, this.bufferBase + this.buffer.length), 
            this.state = state;
        }
        reduce(action) {
            var depth = action >> 19, type = 65535 & action, parser = this.p["parser"], dPrec = parser.dynamicPrecedence(type);
            if (dPrec && (this.score += dPrec), 0 == depth) this.pushState(parser.getGoto(this.state, type, !0), this.reducePos), 
            type < parser.minRepeatTerm && this.storeNode(type, this.reducePos, this.reducePos, 4, !0), 
            this.reduceContext(type, this.reducePos); else {
                var base = this.stack.length - 3 * (depth - 1) - (262144 & action ? 6 : 0), dPrec = base ? this.stack[base - 2] : this.p.ranges[0].from, depth = this.reducePos - dPrec, _a = (2e3 <= depth && (null == (_a = this.p.parser.nodeSet.types[type]) || !_a.isAnonymous) && (dPrec == this.p.lastBigReductionStart ? (this.p.bigReductionCount++, 
                this.p.lastBigReductionSize = depth) : this.p.lastBigReductionSize < depth && (this.p.bigReductionCount = 1, 
                this.p.lastBigReductionStart = dPrec, this.p.lastBigReductionSize = depth)), 
                base ? this.stack[base - 1] : 0), depth = this.bufferBase + this.buffer.length - _a;
                for ((type < parser.minRepeatTerm || 131072 & action) && (_a = parser.stateFlag(this.state, 1) ? this.pos : this.reducePos, 
                this.storeNode(type, dPrec, _a, 4 + depth, !0)), 262144 & action ? this.state = this.stack[base] : (_a = this.stack[base - 3], 
                this.state = parser.getGoto(_a, type, !0)); this.stack.length > base; ) this.stack.pop();
                this.reduceContext(type, dPrec);
            }
        }
        storeNode(term, start, end, size = 4, isReduce = !1) {
            if (0 == term && (!this.stack.length || this.stack[this.stack.length - 1] < this.buffer.length + this.bufferBase)) {
                let cur = this, top = this.buffer.length;
                if (0 == top && cur.parent && (top = cur.bufferBase - cur.parent.bufferBase, 
                cur = cur.parent), 0 < top && 0 == cur.buffer[top - 4] && -1 < cur.buffer[top - 1]) {
                    if (start == end) return;
                    if (cur.buffer[top - 2] >= start) return void (cur.buffer[top - 2] = end);
                }
            }
            if (isReduce && this.pos != end) {
                let index = this.buffer.length;
                if (0 < index && 0 != this.buffer[index - 4]) for (;0 < index && this.buffer[index - 2] > end; ) this.buffer[index] = this.buffer[index - 4], 
                this.buffer[index + 1] = this.buffer[index - 3], this.buffer[index + 2] = this.buffer[index - 2], 
                this.buffer[index + 3] = this.buffer[index - 1], index -= 4, 4 < size && (size -= 4);
                this.buffer[index] = term, this.buffer[index + 1] = start, this.buffer[index + 2] = end, 
                this.buffer[index + 3] = size;
            } else this.buffer.push(term, start, end, size);
        }
        shift(action, type, start, end) {
            var parser;
            131072 & action ? this.pushState(65535 & action, this.pos) : 0 == (262144 & action) ? (action = action, 
            parser = this.p["parser"], (end > this.pos || type <= parser.maxNode) && (this.pos = end, 
            parser.stateFlag(action, 1) || (this.reducePos = end)), this.pushState(action, start), 
            this.shiftContext(type, start), type <= parser.maxNode && this.buffer.push(type, start, end, 4)) : (this.pos = end, 
            this.shiftContext(type, start), type <= this.p.parser.maxNode && this.buffer.push(type, start, end, 4));
        }
        apply(action, next, nextStart, nextEnd) {
            65536 & action ? this.reduce(action) : this.shift(action, next, nextStart, nextEnd);
        }
        useNode(value, next) {
            let index = this.p.reused.length - 1;
            (index < 0 || this.p.reused[index] != value) && (this.p.reused.push(value), 
            index++);
            var start = this.pos;
            this.reducePos = this.pos = start + value.length, this.pushState(next, start), 
            this.buffer.push(index, start, this.reducePos, -1), this.curContext && this.updateContext(this.curContext.tracker.reuse(this.curContext.context, value, this, this.p.stream.reset(this.pos - value.length)));
        }
        split() {
            let parent = this, off = parent.buffer.length;
            for (;0 < off && parent.buffer[off - 2] > parent.reducePos; ) off -= 4;
            for (var buffer = parent.buffer.slice(off), base = parent.bufferBase + off; parent && base == parent.bufferBase; ) parent = parent.parent;
            return new Stack(this.p, this.stack.slice(), this.state, this.reducePos, this.pos, this.score, buffer, base, this.curContext, this.lookAhead, parent);
        }
        recoverByDelete(next, nextEnd) {
            var isNode = next <= this.p.parser.maxNode;
            isNode && this.storeNode(next, this.pos, nextEnd, 4), this.storeNode(0, this.pos, nextEnd, isNode ? 8 : 4), 
            this.pos = this.reducePos = nextEnd, this.score -= 190;
        }
        canShift(term) {
            for (var sim = new SimulatedStack(this); ;) {
                var action = this.p.parser.stateSlot(sim.state, 4) || this.p.parser.hasAction(sim.state, term);
                if (0 == action) return !1;
                if (0 == (65536 & action)) return !0;
                sim.reduce(action);
            }
        }
        recoverByInsert(next) {
            if (300 <= this.stack.length) return [];
            let nextStates = this.p.parser.nextStates(this.state);
            if (8 < nextStates.length || 120 <= this.stack.length) {
                var best = [];
                for (let i = 0, s; i < nextStates.length; i += 2) (s = nextStates[i + 1]) != this.state && this.p.parser.hasAction(s, next) && best.push(nextStates[i], s);
                if (this.stack.length < 120) for (let i = 0; best.length < 8 && i < nextStates.length; i += 2) {
                    let s = nextStates[i + 1];
                    best.some((v, i) => 1 & i && v == s) || best.push(nextStates[i], s);
                }
                nextStates = best;
            }
            var result = [];
            for (let i = 0; i < nextStates.length && result.length < 4; i += 2) {
                var stack, s = nextStates[i + 1];
                s != this.state && ((stack = this.split()).pushState(s, this.pos), 
                stack.storeNode(0, stack.pos, stack.pos, 4, !0), stack.shiftContext(nextStates[i], this.pos), 
                stack.reducePos = this.pos, stack.score -= 200, result.push(stack));
            }
            return result;
        }
        forceReduce() {
            var parser = this.p["parser"];
            let reduce = parser.stateSlot(this.state, 5);
            if (0 == (65536 & reduce)) return !1;
            if (!parser.validAction(this.state, reduce)) {
                var depth = reduce >> 19, term = 65535 & reduce, depth = this.stack.length - 3 * depth;
                if (depth < 0 || parser.getGoto(this.stack[depth], term, !1) < 0) {
                    parser = this.findForcedReduction();
                    if (null == parser) return !1;
                    reduce = parser;
                }
                this.storeNode(0, this.pos, this.pos, 4, !0), this.score -= 100;
            }
            return this.reducePos = this.pos, this.reduce(reduce), !0;
        }
        findForcedReduction() {
            let parser = this.p["parser"], seen = [], explore = (state, depth) => {
                if (!seen.includes(state)) return seen.push(state), parser.allActions(state, action => {
                    if (!(393216 & action)) if (65536 & action) {
                        var rDepth = (action >> 19) - depth;
                        if (1 < rDepth) {
                            var term = 65535 & action, target = this.stack.length - 3 * rDepth;
                            if (0 <= target && 0 <= parser.getGoto(this.stack[target], term, !1)) return rDepth << 19 | 65536 | term;
                        }
                    } else {
                        target = explore(action, depth + 1);
                        if (null != target) return target;
                    }
                });
            };
            return explore(this.state, 0);
        }
        forceAll() {
            for (;!this.p.parser.stateFlag(this.state, 2); ) if (!this.forceReduce()) {
                this.storeNode(0, this.pos, this.pos, 4, !0);
                break;
            }
            return this;
        }
        get deadEnd() {
            var parser;
            return 3 == this.stack.length && (parser = this.p.parser, 65535 == parser.data[parser.stateSlot(this.state, 1)]) && !parser.stateSlot(this.state, 4);
        }
        restart() {
            this.storeNode(0, this.pos, this.pos, 4, !0), this.state = this.stack[0], 
            this.stack.length = 0;
        }
        sameState(other) {
            if (this.state != other.state || this.stack.length != other.stack.length) return !1;
            for (let i = 0; i < this.stack.length; i += 3) if (this.stack[i] != other.stack[i]) return !1;
            return !0;
        }
        get parser() {
            return this.p.parser;
        }
        dialectEnabled(dialectID) {
            return this.p.parser.dialect.flags[dialectID];
        }
        shiftContext(term, start) {
            this.curContext && this.updateContext(this.curContext.tracker.shift(this.curContext.context, term, this, this.p.stream.reset(start)));
        }
        reduceContext(term, start) {
            this.curContext && this.updateContext(this.curContext.tracker.reduce(this.curContext.context, term, this, this.p.stream.reset(start)));
        }
        emitContext() {
            var last = this.buffer.length - 1;
            (last < 0 || -3 != this.buffer[last]) && this.buffer.push(this.curContext.hash, this.pos, this.pos, -3);
        }
        emitLookAhead() {
            var last = this.buffer.length - 1;
            (last < 0 || -4 != this.buffer[last]) && this.buffer.push(this.lookAhead, this.pos, this.pos, -4);
        }
        updateContext(context) {
            context != this.curContext.context && ((context = new StackContext(this.curContext.tracker, context)).hash != this.curContext.hash && this.emitContext(), 
            this.curContext = context);
        }
        setLookAhead(lookAhead) {
            lookAhead > this.lookAhead && (this.emitLookAhead(), this.lookAhead = lookAhead);
        }
        close() {
            this.curContext && this.curContext.tracker.strict && this.emitContext(), 
            0 < this.lookAhead && this.emitLookAhead();
        }
    }
    class StackContext {
        constructor(tracker, context) {
            this.tracker = tracker, this.context = context, this.hash = tracker.strict ? tracker.hash(context) : 0;
        }
    }
    class SimulatedStack {
        constructor(start) {
            this.start = start, this.state = start.state, this.stack = start.stack, 
            this.base = this.stack.length;
        }
        reduce(action) {
            var term = 65535 & action, action = action >> 19, action = (0 == action ? (this.stack == this.start.stack && (this.stack = this.stack.slice()), 
            this.stack.push(this.state, 0, 0), this.base += 3) : this.base -= 3 * (action - 1), 
            this.start.p.parser.getGoto(this.stack[this.base - 3], term, !0));
            this.state = action;
        }
    }
    class StackBufferCursor {
        constructor(stack, pos, index) {
            this.stack = stack, this.pos = pos, this.index = index, this.buffer = stack.buffer, 
            0 == this.index && this.maybeNext();
        }
        static create(stack, pos = stack.bufferBase + stack.buffer.length) {
            return new StackBufferCursor(stack, pos, pos - stack.bufferBase);
        }
        maybeNext() {
            var next = this.stack.parent;
            null != next && (this.index = this.stack.bufferBase - next.bufferBase, 
            this.stack = next, this.buffer = next.buffer);
        }
        get id() {
            return this.buffer[this.index - 4];
        }
        get start() {
            return this.buffer[this.index - 3];
        }
        get end() {
            return this.buffer[this.index - 2];
        }
        get size() {
            return this.buffer[this.index - 1];
        }
        next() {
            this.index -= 4, this.pos -= 4, 0 == this.index && this.maybeNext();
        }
        fork() {
            return new StackBufferCursor(this.stack, this.pos, this.index);
        }
    }
    function decodeArray(input, Type = Uint16Array) {
        if ("string" != typeof input) return input;
        let array = null;
        for (let pos = 0, out = 0; pos < input.length; ) {
            let value = 0;
            for (;;) {
                let next = input.charCodeAt(pos++), stop = !1;
                if (126 == next) {
                    value = 65535;
                    break;
                }
                92 <= next && next--, 34 <= next && next--;
                let digit = next - 32;
                if (46 <= digit && (digit -= 46, stop = !0), value += digit, stop) break;
                value *= 46;
            }
            array ? array[out++] = value : array = new Type(value);
        }
        return array;
    }
    class CachedToken {
        constructor() {
            this.start = -1, this.value = -1, this.end = -1, this.extended = -1, 
            this.lookAhead = 0, this.mask = 0, this.context = 0;
        }
    }
    const nullToken = new CachedToken();
    class InputStream {
        constructor(input, ranges) {
            this.input = input, this.ranges = ranges, this.chunk = "", this.chunkOff = 0, 
            this.chunk2 = "", this.chunk2Pos = 0, this.next = -1, this.token = nullToken, 
            this.rangeIndex = 0, this.pos = this.chunkPos = ranges[0].from, this.range = ranges[0], 
            this.end = ranges[ranges.length - 1].to, this.readNext();
        }
        resolveOffset(offset, assoc) {
            let range = this.range, index = this.rangeIndex, pos = this.pos + offset;
            for (;pos < range.from; ) {
                if (!index) return null;
                var next = this.ranges[--index];
                pos -= range.from - next.to, range = next;
            }
            for (;assoc < 0 ? pos > range.to : pos >= range.to; ) {
                if (index == this.ranges.length - 1) return null;
                let next = this.ranges[++index];
                pos += next.from - range.to, range = next;
            }
            return pos;
        }
        clipPos(pos) {
            if (pos >= this.range.from && pos < this.range.to) return pos;
            for (var range of this.ranges) if (range.to > pos) return Math.max(pos, range.from);
            return this.end;
        }
        peek(offset) {
            let idx = this.chunkOff + offset, pos, result;
            if (0 <= idx && idx < this.chunk.length) pos = this.pos + offset, result = this.chunk.charCodeAt(idx); else {
                offset = this.resolveOffset(offset, 1);
                if (null == offset) return -1;
                if ((pos = offset) >= this.chunk2Pos && pos < this.chunk2Pos + this.chunk2.length) result = this.chunk2.charCodeAt(pos - this.chunk2Pos); else {
                    let i = this.rangeIndex, range = this.range;
                    for (;range.to <= pos; ) range = this.ranges[++i];
                    this.chunk2 = this.input.chunk(this.chunk2Pos = pos), pos + this.chunk2.length > range.to && (this.chunk2 = this.chunk2.slice(0, range.to - pos)), 
                    result = this.chunk2.charCodeAt(0);
                }
            }
            return pos >= this.token.lookAhead && (this.token.lookAhead = pos + 1), 
            result;
        }
        acceptToken(token, endOffset = 0) {
            endOffset = endOffset ? this.resolveOffset(endOffset, -1) : this.pos;
            if (null == endOffset || endOffset < this.token.start) throw new RangeError("Token end out of bounds");
            this.token.value = token, this.token.end = endOffset;
        }
        acceptTokenTo(token, endPos) {
            this.token.value = token, this.token.end = endPos;
        }
        getChunk() {
            var chunk, chunkPos;
            this.pos >= this.chunk2Pos && this.pos < this.chunk2Pos + this.chunk2.length ? ({
                chunk,
                chunkPos
            } = this, this.chunk = this.chunk2, this.chunkPos = this.chunk2Pos, 
            this.chunk2 = chunk, this.chunk2Pos = chunkPos, this.chunkOff = this.pos - this.chunkPos) : (this.chunk2 = this.chunk, 
            this.chunk2Pos = this.chunkPos, chunk = this.input.chunk(this.pos), 
            chunkPos = this.pos + chunk.length, this.chunk = chunkPos > this.range.to ? chunk.slice(0, this.range.to - this.pos) : chunk, 
            this.chunkPos = this.pos, this.chunkOff = 0);
        }
        readNext() {
            return this.chunkOff >= this.chunk.length && (this.getChunk(), this.chunkOff == this.chunk.length) ? this.next = -1 : this.next = this.chunk.charCodeAt(this.chunkOff);
        }
        advance(n = 1) {
            for (this.chunkOff += n; this.pos + n >= this.range.to; ) {
                if (this.rangeIndex == this.ranges.length - 1) return this.setDone();
                n -= this.range.to - this.pos, this.range = this.ranges[++this.rangeIndex], 
                this.pos = this.range.from;
            }
            return this.pos += n, this.pos >= this.token.lookAhead && (this.token.lookAhead = this.pos + 1), 
            this.readNext();
        }
        setDone() {
            return this.pos = this.chunkPos = this.end, this.range = this.ranges[this.rangeIndex = this.ranges.length - 1], 
            this.chunk = "", this.next = -1;
        }
        reset(pos, token) {
            if (token ? ((this.token = token).start = pos, token.lookAhead = pos + 1, 
            token.value = token.extended = -1) : this.token = nullToken, this.pos != pos) {
                if ((this.pos = pos) == this.end) return this.setDone(), this;
                for (;pos < this.range.from; ) this.range = this.ranges[--this.rangeIndex];
                for (;pos >= this.range.to; ) this.range = this.ranges[++this.rangeIndex];
                pos >= this.chunkPos && pos < this.chunkPos + this.chunk.length ? this.chunkOff = pos - this.chunkPos : (this.chunk = "", 
                this.chunkOff = 0), this.readNext();
            }
            return this;
        }
        read(from, to) {
            if (from >= this.chunkPos && to <= this.chunkPos + this.chunk.length) return this.chunk.slice(from - this.chunkPos, to - this.chunkPos);
            if (from >= this.chunk2Pos && to <= this.chunk2Pos + this.chunk2.length) return this.chunk2.slice(from - this.chunk2Pos, to - this.chunk2Pos);
            if (from >= this.range.from && to <= this.range.to) return this.input.read(from, to);
            let result = "";
            for (var r of this.ranges) {
                if (r.from >= to) break;
                r.to > from && (result += this.input.read(Math.max(r.from, from), Math.min(r.to, to)));
            }
            return result;
        }
    }
    class TokenGroup {
        constructor(data, id) {
            this.data = data, this.id = id;
        }
        token(input, stack) {
            var parser = stack.p["parser"];
            readToken(this.data, input, stack, this.id, parser.data, parser.tokenPrecTable);
        }
    }
    TokenGroup.prototype.contextual = TokenGroup.prototype.fallback = TokenGroup.prototype.extend = !1;
    class LocalTokenGroup {
        constructor(data, precTable, elseToken) {
            this.precTable = precTable, this.elseToken = elseToken, this.data = "string" == typeof data ? decodeArray(data) : data;
        }
        token(input, stack) {
            let start = input.pos, skipped = 0;
            for (;;) {
                var atEof = input.next < 0, nextPos = input.resolveOffset(1, 1);
                if (readToken(this.data, input, stack, 0, this.data, this.precTable), 
                -1 < input.token.value) break;
                if (null == this.elseToken) return;
                if (atEof || skipped++, null == nextPos) break;
                input.reset(nextPos, input.token);
            }
            skipped && (input.reset(start, input.token), input.acceptToken(this.elseToken, skipped));
        }
    }
    LocalTokenGroup.prototype.contextual = TokenGroup.prototype.fallback = TokenGroup.prototype.extend = !1;
    class ExternalTokenizer {
        constructor(token, options = {}) {
            this.token = token, this.contextual = !!options.contextual, this.fallback = !!options.fallback, 
            this.extend = !!options.extend;
        }
    }
    function readToken(data, input, stack, group, precTable, precOffset) {
        let state = 0, groupMask = 1 << group, dialect = stack.p.parser["dialect"];
        scan: for (;0 != (groupMask & data[state]); ) {
            var accEnd = data[state + 1];
            for (let i = state + 3; i < accEnd; i += 2) if (0 < (data[i + 1] & groupMask)) {
                var term = data[i];
                if (dialect.allows(term) && (-1 == input.token.value || input.token.value == term || function(token, prev, tableData, tableOffset) {
                    prev = findOffset(tableData, tableOffset, prev);
                    return prev < 0 || findOffset(tableData, tableOffset, token) < prev;
                }(term, input.token.value, precTable, precOffset))) {
                    input.acceptToken(term);
                    break;
                }
            }
            let next = input.next, low = 0, high = data[state + 2];
            if (!(input.next < 0 && high > low && 65535 == data[accEnd + 3 * high - 3])) {
                for (;low < high; ) {
                    var mid = low + high >> 1, index = accEnd + mid + (mid << 1), from = data[index], to = data[index + 1] || 65536;
                    if (next < from) high = mid; else {
                        if (!(to <= next)) {
                            state = data[index + 2], input.advance();
                            continue scan;
                        }
                        low = 1 + mid;
                    }
                }
                break;
            }
            state = data[accEnd + 3 * high - 1];
        }
    }
    function findOffset(data, start, term) {
        for (let i = start, next; 65535 != (next = data[i]); i++) if (next == term) return i - start;
        return -1;
    }
    const verbose = "undefined" != typeof process && process.env && /\bparse\b/.test(process.env.LOG);
    let stackIDs = null;
    function cutAt(tree, pos, side) {
        var cursor = tree.cursor(IterMode.IncludeAnonymous);
        for (cursor.moveTo(pos); ;) if (!(side < 0 ? cursor.childBefore(pos) : cursor.childAfter(pos))) for (;;) {
            if ((side < 0 ? cursor.to < pos : cursor.from > pos) && !cursor.type.isError) return side < 0 ? Math.max(0, Math.min(cursor.to - 1, pos - 25)) : Math.min(tree.length, Math.max(cursor.from + 1, pos + 25));
            if (side < 0 ? cursor.prevSibling() : cursor.nextSibling()) break;
            if (!cursor.parent()) return side < 0 ? 0 : tree.length;
        }
    }
    let FragmentCursor$1 = class {
        constructor(fragments, nodeSet) {
            this.fragments = fragments, this.nodeSet = nodeSet, this.i = 0, this.fragment = null, 
            this.safeFrom = -1, this.safeTo = -1, this.trees = [], this.start = [], 
            this.index = [], this.nextFragment();
        }
        nextFragment() {
            var fr = this.fragment = this.i == this.fragments.length ? null : this.fragments[this.i++];
            if (fr) {
                for (this.safeFrom = fr.openStart ? cutAt(fr.tree, fr.from + fr.offset, 1) - fr.offset : fr.from, 
                this.safeTo = fr.openEnd ? cutAt(fr.tree, fr.to + fr.offset, -1) - fr.offset : fr.to; this.trees.length; ) this.trees.pop(), 
                this.start.pop(), this.index.pop();
                this.trees.push(fr.tree), this.start.push(-fr.offset), this.index.push(0), 
                this.nextStart = this.safeFrom;
            } else this.nextStart = 1e9;
        }
        nodeAt(pos) {
            if (pos < this.nextStart) return null;
            for (;this.fragment && this.safeTo <= pos; ) this.nextFragment();
            if (!this.fragment) return null;
            for (;;) {
                var last = this.trees.length - 1;
                if (last < 0) return this.nextFragment(), null;
                var top = this.trees[last], index = this.index[last];
                if (index == top.children.length) this.trees.pop(), this.start.pop(), 
                this.index.pop(); else {
                    var next = top.children[index], top = this.start[last] + top.positions[index];
                    if (pos < top) return this.nextStart = top, null;
                    if (next instanceof Tree) {
                        if (top == pos) {
                            if (top < this.safeFrom) return null;
                            index = top + next.length;
                            if (index <= this.safeTo) {
                                var lookAhead = next.prop(NodeProp.lookAhead);
                                if (!lookAhead || index + lookAhead < this.fragment.to) return next;
                            }
                        }
                        this.index[last]++, top + next.length >= Math.max(this.safeFrom, pos) && (this.trees.push(next), 
                        this.start.push(top), this.index.push(0));
                    } else this.index[last]++, this.nextStart = top + next.length;
                }
            }
        }
    };
    class TokenCache {
        constructor(parser, stream) {
            this.stream = stream, this.tokens = [], this.mainToken = null, this.actions = [], 
            this.tokens = parser.tokenizers.map(_ => new CachedToken());
        }
        getActions(stack) {
            let actionIndex = 0, main = null;
            var parser = stack.p["parser"], tokenizers = parser["tokenizers"], mask = parser.stateSlot(stack.state, 3), context = stack.curContext ? stack.curContext.hash : 0;
            let lookAhead = 0;
            for (let i = 0; i < tokenizers.length; i++) if (0 != (1 << i & mask)) {
                var tokenizer = tokenizers[i], token = this.tokens[i];
                if ((!main || tokenizer.fallback) && (!tokenizer.contextual && token.start == stack.pos && token.mask == mask && token.context == context || (this.updateCachedToken(token, tokenizer, stack), 
                token.mask = mask, token.context = context), token.lookAhead > token.end + 25 && (lookAhead = Math.max(token.lookAhead, lookAhead)), 
                0 != token.value)) {
                    var startIndex = actionIndex;
                    if (-1 < token.extended && (actionIndex = this.addActions(stack, token.extended, token.end, actionIndex)), 
                    actionIndex = this.addActions(stack, token.value, token.end, actionIndex), 
                    !tokenizer.extend && (main = token, actionIndex > startIndex)) break;
                }
            }
            for (;this.actions.length > actionIndex; ) this.actions.pop();
            return lookAhead && stack.setLookAhead(lookAhead), main || stack.pos != this.stream.end || ((main = new CachedToken()).value = stack.p.parser.eofTerm, 
            main.start = main.end = stack.pos, actionIndex = this.addActions(stack, main.value, main.end, actionIndex)), 
            this.mainToken = main, this.actions;
        }
        getMainToken(stack) {
            var main, p;
            return this.mainToken || ({
                pos: stack,
                p
            } = stack, (main = new CachedToken()).start = stack, main.end = Math.min(stack + 1, p.stream.end), 
            main.value = stack == p.stream.end ? p.parser.eofTerm : 0, main);
        }
        updateCachedToken(token, tokenizer, stack) {
            var start = this.stream.clipPos(stack.pos);
            if (tokenizer.token(this.stream.reset(start, token), stack), -1 < token.value) {
                var parser = stack.p["parser"];
                for (let i = 0; i < parser.specialized.length; i++) if (parser.specialized[i] == token.value) {
                    var result = parser.specializers[i](this.stream.read(token.start, token.end), stack);
                    if (0 <= result && stack.p.parser.dialect.allows(result >> 1)) {
                        0 == (1 & result) ? token.value = result >> 1 : token.extended = result >> 1;
                        break;
                    }
                }
            } else token.value = 0, token.end = this.stream.clipPos(start + 1);
        }
        putAction(action, token, end, index) {
            for (let i = 0; i < index; i += 3) if (this.actions[i] == action) return index;
            return this.actions[index++] = action, this.actions[index++] = token, 
            this.actions[index++] = end, index;
        }
        addActions(stack, token, end, index) {
            var state = stack["state"], parser = stack.p["parser"], data = parser["data"];
            for (let set = 0; set < 2; set++) for (let i = parser.stateSlot(state, set ? 2 : 1); ;i += 3) {
                if (65535 == data[i]) {
                    if (1 != data[i + 1]) {
                        0 == index && 2 == data[i + 1] && (index = this.putAction(pair(data, i + 2), token, end, index));
                        break;
                    }
                    i = pair(data, i + 2);
                }
                data[i] == token && (index = this.putAction(pair(data, i + 1), token, end, index));
            }
            return index;
        }
    }
    class Parse {
        constructor(parser, input, fragments, ranges) {
            this.parser = parser, this.input = input, this.ranges = ranges, this.recovering = 0, 
            this.nextStackID = 9812, this.minStackPos = 0, this.reused = [], this.stoppedAt = null, 
            this.lastBigReductionStart = -1, this.lastBigReductionSize = 0, this.bigReductionCount = 0, 
            this.stream = new InputStream(input, ranges), this.tokens = new TokenCache(parser, this.stream), 
            this.topTerm = parser.top[1];
            input = ranges[0].from;
            this.stacks = [ Stack.start(this, parser.top[0], input) ], this.fragments = fragments.length && this.stream.end - input > 4 * parser.bufferLength ? new FragmentCursor$1(fragments, parser.nodeSet) : null;
        }
        get parsedPos() {
            return this.minStackPos;
        }
        advance() {
            let stacks = this.stacks, pos = this.minStackPos;
            var newStacks = this.stacks = [];
            let stopped, stoppedTokens;
            if (300 < this.bigReductionCount && 1 == stacks.length) {
                for (var [ s ] = stacks; s.forceReduce() && s.stack.length && s.stack[s.stack.length - 2] >= this.lastBigReductionStart; );
                this.bigReductionCount = this.lastBigReductionSize = 0;
            }
            for (let i = 0; i < stacks.length; i++) for (var stack = stacks[i]; ;) {
                if (this.tokens.mainToken = null, stack.pos > pos) newStacks.push(stack); else {
                    if (this.advanceStack(stack, newStacks, stacks)) continue;
                    stopped || (stopped = [], stoppedTokens = []), stopped.push(stack);
                    var tok = this.tokens.getMainToken(stack);
                    stoppedTokens.push(tok.value, tok.end);
                }
                break;
            }
            if (!newStacks.length) {
                var finished = stopped && function(stacks) {
                    let best = null;
                    for (var stack of stacks) {
                        var stopped = stack.p.stoppedAt;
                        (stack.pos == stack.p.stream.end || null != stopped && stack.pos > stopped) && stack.p.parser.stateFlag(stack.state, 2) && (!best || best.score < stack.score) && (best = stack);
                    }
                    return best;
                }(stopped);
                if (finished) return verbose && console.log("Finish with " + this.stackID(finished)), 
                this.stackToTree(finished);
                if (this.parser.strict) throw verbose && stopped && console.log("Stuck with token " + (this.tokens.mainToken ? this.parser.getName(this.tokens.mainToken.value) : "none")), 
                new SyntaxError("No parse at " + pos);
                this.recovering || (this.recovering = 5);
            }
            if (this.recovering && stopped) {
                let finished = null != this.stoppedAt && stopped[0].pos > this.stoppedAt ? stopped[0] : this.runRecovery(stopped, stoppedTokens, newStacks);
                if (finished) return verbose && console.log("Force-finish " + this.stackID(finished)), 
                this.stackToTree(finished.forceAll());
            }
            if (this.recovering) {
                var maxRemaining = 1 == this.recovering ? 1 : 3 * this.recovering;
                if (newStacks.length > maxRemaining) for (newStacks.sort((a, b) => b.score - a.score); newStacks.length > maxRemaining; ) newStacks.pop();
                newStacks.some(s => s.reducePos > pos) && this.recovering--;
            } else if (1 < newStacks.length) {
                outer: for (let i = 0; i < newStacks.length - 1; i++) {
                    let stack = newStacks[i];
                    for (let j = i + 1; j < newStacks.length; j++) {
                        var other = newStacks[j];
                        if (stack.sameState(other) || 500 < stack.buffer.length && 500 < other.buffer.length) {
                            if (!(0 < (stack.score - other.score || stack.buffer.length - other.buffer.length))) {
                                newStacks.splice(i--, 1);
                                continue outer;
                            }
                            newStacks.splice(j--, 1);
                        }
                    }
                }
                12 < newStacks.length && newStacks.splice(12, newStacks.length - 12);
            }
            this.minStackPos = newStacks[0].pos;
            for (let i = 1; i < newStacks.length; i++) newStacks[i].pos < this.minStackPos && (this.minStackPos = newStacks[i].pos);
            return null;
        }
        stopAt(pos) {
            if (null != this.stoppedAt && this.stoppedAt < pos) throw new RangeError("Can't move stoppedAt forward");
            this.stoppedAt = pos;
        }
        advanceStack(stack, stacks, split) {
            var start = stack.pos, parser = this["parser"], base = verbose ? this.stackID(stack) + " -> " : "";
            if (null != this.stoppedAt && start > this.stoppedAt) return stack.forceReduce() ? stack : null;
            if (this.fragments) {
                var strictCx = stack.curContext && stack.curContext.tracker.strict, cxHash = strictCx ? stack.curContext.hash : 0;
                for (let cached = this.fragments.nodeAt(start); cached; ) {
                    var match = this.parser.nodeSet.types[cached.type.id] == cached.type ? parser.getGoto(stack.state, cached.type.id) : -1;
                    if (-1 < match && cached.length && (!strictCx || (cached.prop(NodeProp.contextHash) || 0) == cxHash)) return stack.useNode(cached, match), 
                    verbose && console.log(base + this.stackID(stack) + ` (via reuse of ${parser.getName(cached.type.id)})`), 
                    !0;
                    if (!(cached instanceof Tree) || 0 == cached.children.length || 0 < cached.positions[0]) break;
                    match = cached.children[0];
                    if (!(match instanceof Tree && 0 == cached.positions[0])) break;
                    cached = match;
                }
            }
            var defaultReduce = parser.stateSlot(stack.state, 4);
            if (0 < defaultReduce) return stack.reduce(defaultReduce), verbose && console.log(base + this.stackID(stack) + ` (via always-reduce ${parser.getName(65535 & defaultReduce)})`), 
            !0;
            if (8400 <= stack.stack.length) for (;6e3 < stack.stack.length && stack.forceReduce(); );
            var actions = this.tokens.getActions(stack);
            for (let i = 0; i < actions.length; ) {
                var action = actions[i++], term = actions[i++], end = actions[i++], last = i == actions.length || !split, localStack = last ? stack : stack.split(), main = this.tokens.mainToken;
                if (localStack.apply(action, term, main ? main.start : localStack.pos, end), 
                verbose && console.log(base + this.stackID(localStack) + ` (via ${0 == (65536 & action) ? "shift" : "reduce of " + parser.getName(65535 & action)} for ${parser.getName(term)} @ ${start}${localStack == stack ? "" : ", split"})`), 
                last) return !0;
                (localStack.pos > start ? stacks : split).push(localStack);
            }
            return !1;
        }
        advanceFully(stack, newStacks) {
            for (var pos = stack.pos; ;) {
                if (!this.advanceStack(stack, null, null)) return !1;
                if (stack.pos > pos) return pushStackDedup(stack, newStacks), !0;
            }
        }
        runRecovery(stacks, tokens, newStacks) {
            let finished = null, restarted = !1;
            for (let i = 0; i < stacks.length; i++) {
                let stack = stacks[i], token = tokens[i << 1], tokenEnd = tokens[1 + (i << 1)];
                var insert, base = verbose ? this.stackID(stack) + " -> " : "";
                if (stack.deadEnd) {
                    if (restarted) continue;
                    if (restarted = !0, stack.restart(), verbose && console.log(base + this.stackID(stack) + " (restarted)"), 
                    this.advanceFully(stack, newStacks)) continue;
                }
                let force = stack.split(), forceBase = base;
                for (let j = 0; force.forceReduce() && j < 10; j++) {
                    verbose && console.log(forceBase + this.stackID(force) + " (via force-reduce)");
                    let done = this.advanceFully(force, newStacks);
                    if (done) break;
                    verbose && (forceBase = this.stackID(force) + " -> ");
                }
                for (insert of stack.recoverByInsert(token)) verbose && console.log(base + this.stackID(insert) + " (via recover-insert)"), 
                this.advanceFully(insert, newStacks);
                this.stream.end > stack.pos ? (tokenEnd == stack.pos && (tokenEnd++, 
                token = 0), stack.recoverByDelete(token, tokenEnd), verbose && console.log(base + this.stackID(stack) + ` (via recover-delete ${this.parser.getName(token)})`), 
                pushStackDedup(stack, newStacks)) : (!finished || finished.score < stack.score) && (finished = stack);
            }
            return finished;
        }
        stackToTree(stack) {
            return stack.close(), Tree.build({
                buffer: StackBufferCursor.create(stack),
                nodeSet: this.parser.nodeSet,
                topID: this.topTerm,
                maxBufferLength: this.parser.bufferLength,
                reused: this.reused,
                start: this.ranges[0].from,
                length: stack.pos - this.ranges[0].from,
                minRepeatType: this.parser.minRepeatTerm
            });
        }
        stackID(stack) {
            let id = (stackIDs = stackIDs || new WeakMap()).get(stack);
            return id || stackIDs.set(stack, id = String.fromCodePoint(this.nextStackID++)), 
            id + stack;
        }
    }
    function pushStackDedup(stack, newStacks) {
        for (let i = 0; i < newStacks.length; i++) {
            var other = newStacks[i];
            if (other.pos == stack.pos && other.sameState(stack)) return void (newStacks[i].score < stack.score && (newStacks[i] = stack));
        }
        newStacks.push(stack);
    }
    class Dialect {
        constructor(source, flags, disabled) {
            this.source = source, this.flags = flags, this.disabled = disabled;
        }
        allows(term) {
            return !this.disabled || 0 == this.disabled[term];
        }
    }
    const id = x => x;
    class ContextTracker {
        constructor(spec) {
            this.start = spec.start, this.shift = spec.shift || id, this.reduce = spec.reduce || id, 
            this.reuse = spec.reuse || id, this.hash = spec.hash || (() => 0), this.strict = !1 !== spec.strict;
        }
    }
    class LRParser extends Parser {
        constructor(spec) {
            if (super(), this.wrappers = [], 14 != spec.version) throw new RangeError(`Parser version (${spec.version}) doesn't match runtime version (14)`);
            var nodeNames = spec.nodeNames.split(" ");
            this.minRepeatTerm = nodeNames.length;
            for (let i = 0; i < spec.repeatNodeCount; i++) nodeNames.push("");
            let topTerms = Object.keys(spec.topRules).map(r => spec.topRules[r][1]), nodeProps = [];
            for (let i = 0; i < nodeNames.length; i++) nodeProps.push([]);
            function setProp(nodeID, prop, value) {
                nodeProps[nodeID].push([ prop, prop.deserialize(String(value)) ]);
            }
            if (spec.nodeProps) for (var propSpec of spec.nodeProps) {
                let prop = propSpec[0];
                "string" == typeof prop && (prop = NodeProp[prop]);
                for (let i = 1; i < propSpec.length; ) {
                    var next = propSpec[i++];
                    if (0 <= next) setProp(next, prop, propSpec[i++]); else {
                        var value = propSpec[i + -next];
                        for (let j = -next; 0 < j; j--) setProp(propSpec[i++], prop, value);
                        i++;
                    }
                }
            }
            this.nodeSet = new NodeSet(nodeNames.map((name, i) => NodeType.define({
                name: i >= this.minRepeatTerm ? void 0 : name,
                id: i,
                props: nodeProps[i],
                top: -1 < topTerms.indexOf(i),
                error: 0 == i,
                skipped: spec.skippedNodes && -1 < spec.skippedNodes.indexOf(i)
            }))), spec.propSources && (this.nodeSet = this.nodeSet.extend(...spec.propSources)), 
            this.strict = !1, this.bufferLength = 1024;
            let tokenArray = decodeArray(spec.tokenData);
            this.context = spec.context, this.specializerSpecs = spec.specialized || [], 
            this.specialized = new Uint16Array(this.specializerSpecs.length);
            for (let i = 0; i < this.specializerSpecs.length; i++) this.specialized[i] = this.specializerSpecs[i].term;
            this.specializers = this.specializerSpecs.map(getSpecializer), this.states = decodeArray(spec.states, Uint32Array), 
            this.data = decodeArray(spec.stateData), this.goto = decodeArray(spec.goto), 
            this.maxTerm = spec.maxTerm, this.tokenizers = spec.tokenizers.map(value => "number" == typeof value ? new TokenGroup(tokenArray, value) : value), 
            this.topRules = spec.topRules, this.dialects = spec.dialects || {}, 
            this.dynamicPrecedences = spec.dynamicPrecedences || null, this.tokenPrecTable = spec.tokenPrec, 
            this.termNames = spec.termNames || null, this.maxNode = this.nodeSet.types.length - 1, 
            this.dialect = this.parseDialect(), this.top = this.topRules[Object.keys(this.topRules)[0]];
        }
        createParse(input, fragments, ranges) {
            let parse = new Parse(this, input, fragments, ranges);
            for (var w of this.wrappers) parse = w(parse, input, fragments, ranges);
            return parse;
        }
        getGoto(state, term, loose = !1) {
            var table = this.goto;
            if (term >= table[0]) return -1;
            for (let pos = table[term + 1]; ;) {
                var groupTag = table[pos++], last = 1 & groupTag, target = table[pos++];
                if (last && loose) return target;
                for (var end = pos + (groupTag >> 1); pos < end; pos++) if (table[pos] == state) return target;
                if (last) return -1;
            }
        }
        hasAction(state, terminal) {
            var data = this.data;
            for (let set = 0; set < 2; set++) for (let i = this.stateSlot(state, set ? 2 : 1), next; ;i += 3) {
                if (65535 == (next = data[i])) {
                    if (1 != data[i + 1]) {
                        if (2 == data[i + 1]) return pair(data, i + 2);
                        break;
                    }
                    next = data[i = pair(data, i + 2)];
                }
                if (next == terminal || 0 == next) return pair(data, i + 1);
            }
            return 0;
        }
        stateSlot(state, slot) {
            return this.states[6 * state + slot];
        }
        stateFlag(state, flag) {
            return 0 < (this.stateSlot(state, 0) & flag);
        }
        validAction(state, action) {
            return !!this.allActions(state, a => a == action || null);
        }
        allActions(state, action) {
            var deflt = this.stateSlot(state, 4);
            let result = deflt ? action(deflt) : void 0;
            for (let i = this.stateSlot(state, 1); null == result; i += 3) {
                if (65535 == this.data[i]) {
                    if (1 != this.data[i + 1]) break;
                    i = pair(this.data, i + 2);
                }
                result = action(pair(this.data, i + 1));
            }
            return result;
        }
        nextStates(state) {
            var result = [];
            for (let i = this.stateSlot(state, 1); ;i += 3) {
                if (65535 == this.data[i]) {
                    if (1 != this.data[i + 1]) break;
                    i = pair(this.data, i + 2);
                }
                if (0 == (1 & this.data[i + 2])) {
                    let value = this.data[i + 1];
                    result.some((v, i) => 1 & i && v == value) || result.push(this.data[i], value);
                }
            }
            return result;
        }
        configure(config) {
            let copy = Object.assign(Object.create(LRParser.prototype), this);
            if (config.props && (copy.nodeSet = this.nodeSet.extend(...config.props)), 
            config.top) {
                var info = this.topRules[config.top];
                if (!info) throw new RangeError("Invalid top rule name " + config.top);
                copy.top = info;
            }
            return config.tokenizers && (copy.tokenizers = this.tokenizers.map(t => {
                var found = config.tokenizers.find(r => r.from == t);
                return found ? found.to : t;
            })), config.specializers && (copy.specializers = this.specializers.slice(), 
            copy.specializerSpecs = this.specializerSpecs.map((s, i) => {
                var found = config.specializers.find(r => r.from == s.external);
                return found ? (found = Object.assign(Object.assign({}, s), {
                    external: found.to
                }), copy.specializers[i] = getSpecializer(found), found) : s;
            })), config.contextTracker && (copy.context = config.contextTracker), 
            config.dialect && (copy.dialect = this.parseDialect(config.dialect)), 
            null != config.strict && (copy.strict = config.strict), config.wrap && (copy.wrappers = copy.wrappers.concat(config.wrap)), 
            null != config.bufferLength && (copy.bufferLength = config.bufferLength), 
            copy;
        }
        hasWrappers() {
            return 0 < this.wrappers.length;
        }
        getName(term) {
            return this.termNames ? this.termNames[term] : String(term <= this.maxNode && this.nodeSet.types[term].name || term);
        }
        get eofTerm() {
            return this.maxNode + 1;
        }
        get topNode() {
            return this.nodeSet.types[this.top[1]];
        }
        dynamicPrecedence(term) {
            var prec = this.dynamicPrecedences;
            return null != prec && prec[term] || 0;
        }
        parseDialect(dialect) {
            var values = Object.keys(this.dialects), flags = values.map(() => !1);
            if (dialect) for (var part of dialect.split(" ")) {
                part = values.indexOf(part);
                0 <= part && (flags[part] = !0);
            }
            let disabled = null;
            for (let i = 0; i < values.length; i++) if (!flags[i]) for (let j = this.dialects[values[i]], id; 65535 != (id = this.data[j++]); ) (disabled = disabled || new Uint8Array(this.maxTerm + 1))[id] = 1;
            return new Dialect(dialect, flags, disabled);
        }
        static deserialize(spec) {
            return new LRParser(spec);
        }
    }
    function pair(data, off) {
        return data[off] | data[off + 1] << 16;
    }
    function getSpecializer(spec) {
        if (spec.external) {
            let mask = spec.extend ? 1 : 0;
            return (value, stack) => spec.external(value, stack) << 1 | mask;
        }
        return spec.get;
    }
    const TagName = 22, Attribute = 23, AttributeName = 24, AttributeValue = 26, UnquotedAttributeValue = 27, selfClosers$1 = {
        area: !0,
        base: !0,
        br: !0,
        col: !0,
        command: !0,
        embed: !0,
        frame: !0,
        hr: !0,
        img: !0,
        input: !0,
        keygen: !0,
        link: !0,
        meta: !0,
        param: !0,
        source: !0,
        track: !0,
        wbr: !0,
        menuitem: !0
    }, implicitlyClosed = {
        dd: !0,
        li: !0,
        optgroup: !0,
        option: !0,
        p: !0,
        rp: !0,
        rt: !0,
        tbody: !0,
        td: !0,
        tfoot: !0,
        th: !0,
        tr: !0
    }, closeOnOpen = {
        dd: {
            dd: !0,
            dt: !0
        },
        dt: {
            dd: !0,
            dt: !0
        },
        li: {
            li: !0
        },
        option: {
            option: !0,
            optgroup: !0
        },
        optgroup: {
            optgroup: !0
        },
        p: {
            address: !0,
            article: !0,
            aside: !0,
            blockquote: !0,
            dir: !0,
            div: !0,
            dl: !0,
            fieldset: !0,
            footer: !0,
            form: !0,
            h1: !0,
            h2: !0,
            h3: !0,
            h4: !0,
            h5: !0,
            h6: !0,
            header: !0,
            hgroup: !0,
            hr: !0,
            menu: !0,
            nav: !0,
            ol: !0,
            p: !0,
            pre: !0,
            section: !0,
            table: !0,
            ul: !0
        },
        rp: {
            rp: !0,
            rt: !0
        },
        rt: {
            rp: !0,
            rt: !0
        },
        tbody: {
            tbody: !0,
            tfoot: !0
        },
        td: {
            td: !0,
            th: !0
        },
        tfoot: {
            tbody: !0
        },
        th: {
            td: !0,
            th: !0
        },
        thead: {
            tbody: !0,
            tfoot: !0
        },
        tr: {
            tr: !0
        }
    };
    function isSpace$1(ch) {
        return 9 == ch || 10 == ch || 13 == ch || 32 == ch;
    }
    let cachedName = null, cachedInput = null, cachedPos = 0;
    function tagNameAfter(input, offset) {
        var ch, pos = input.pos + offset;
        if (cachedPos == pos && cachedInput == input) return cachedName;
        let next = input.peek(offset);
        for (;isSpace$1(next); ) next = input.peek(++offset);
        let name = "";
        for (;45 == (ch = next) || 46 == ch || 58 == ch || 65 <= ch && ch <= 90 || 95 == ch || 97 <= ch && ch <= 122 || 161 <= ch; ) name += String.fromCharCode(next), 
        next = input.peek(++offset);
        return cachedInput = input, cachedPos = pos, cachedName = name ? name.toLowerCase() : 63 == next || 33 == next ? void 0 : null;
    }
    function ElementContext(name, parent) {
        this.name = name, this.parent = parent, this.hash = parent ? parent.hash : 0;
        for (let i = 0; i < name.length; i++) this.hash += (this.hash << 4) + name.charCodeAt(i) + (name.charCodeAt(i) << 8);
    }
    const startTagTerms = [ 6, 10, 7, 8, 9 ];
    safari = new ContextTracker({
        start: null,
        shift(context, term, stack, input) {
            return -1 < startTagTerms.indexOf(term) ? new ElementContext(tagNameAfter(input, 1) || "", context) : context;
        },
        reduce(context, term) {
            return 20 == term && context ? context.parent : context;
        },
        reuse(context, node, stack, input) {
            node = node.type.id;
            return 6 == node || 36 == node ? new ElementContext(tagNameAfter(input, 1) || "", context) : context;
        },
        hash(context) {
            return context ? context.hash : 0;
        },
        strict: !1
    }), cursorDocStart = new ExternalTokenizer((input, stack) => {
        if (60 != input.next) input.next < 0 && stack.context && input.acceptToken(57); else {
            input.advance();
            var close = 47 == input.next, name = (close && input.advance(), tagNameAfter(input, 0));
            if (void 0 !== name) {
                if (!name) return input.acceptToken(close ? 14 : 6);
                var parent = stack.context ? stack.context.name : null;
                if (!close) return "script" == name ? input.acceptToken(7) : "style" == name ? input.acceptToken(8) : "textarea" == name ? input.acceptToken(9) : selfClosers$1.hasOwnProperty(name) ? input.acceptToken(10) : void (parent && closeOnOpen[parent] && closeOnOpen[parent][name] ? input.acceptToken(57, -1) : input.acceptToken(6));
                if (name == parent) return input.acceptToken(11);
                if (parent && implicitlyClosed[parent]) return input.acceptToken(57, -2);
                if (stack.dialectEnabled(0)) return input.acceptToken(12);
                for (let cx = stack.context; cx; cx = cx.parent) if (cx.name == name) return;
                input.acceptToken(13);
            }
        }
    }, {
        contextual: !0
    }), punctuation = new ExternalTokenizer(input => {
        for (let dashes = 0, i = 0; ;i++) {
            if (input.next < 0) {
                i && input.acceptToken(58);
                break;
            }
            if (45 == input.next) dashes++; else {
                if (62 == input.next && 2 <= dashes) {
                    3 <= i && input.acceptToken(58, -2);
                    break;
                }
                dashes = 0;
            }
            input.advance();
        }
    });
    var endTag = new ExternalTokenizer((input, stack) => {
        47 == input.next && 62 == input.peek(1) ? (stack = stack.dialectEnabled(1) || function(context) {
            for (;context; context = context.parent) if ("svg" == context.name || "math" == context.name) return !0;
            return !1;
        }(stack.context), input.acceptToken(stack ? 5 : 4, 2)) : 62 == input.next && input.acceptToken(4, 1);
    });
    function contentTokenizer(tag, textToken, endToken) {
        let lastState = 2 + tag.length;
        return new ExternalTokenizer(input => {
            for (let state = 0, matchedLen = 0, i = 0; ;i++) {
                if (input.next < 0) {
                    i && input.acceptToken(textToken);
                    break;
                }
                if (0 == state && 60 == input.next || 1 == state && 47 == input.next || 2 <= state && state < lastState && input.next == tag.charCodeAt(state - 2)) state++, 
                matchedLen++; else if (2 != state && state != lastState || !isSpace$1(input.next)) {
                    if (state == lastState && 62 == input.next) {
                        i > matchedLen ? input.acceptToken(textToken, -matchedLen) : input.acceptToken(endToken, -(matchedLen - 2));
                        break;
                    }
                    if ((10 == input.next || 13 == input.next) && i) {
                        input.acceptToken(textToken, 1);
                        break;
                    }
                    state = matchedLen = 0;
                } else matchedLen++;
                input.advance();
            }
        });
    }
    var scriptTokens = contentTokenizer("script", 54, 1), styleTokens = contentTokenizer("style", 55, 2), textareaTokens = contentTokenizer("textarea", 56, 3), htmlHighlighting = styleTags({
        "Text RawText": tags$1.content,
        "StartTag StartCloseTag SelfClosingEndTag EndTag": tags$1.angleBracket,
        TagName: tags$1.tagName,
        "MismatchedCloseTag/TagName": [ tags$1.tagName, tags$1.invalid ],
        AttributeName: tags$1.attributeName,
        "AttributeValue UnquotedAttributeValue": tags$1.attributeValue,
        Is: tags$1.definitionOperator,
        "EntityReference CharacterReference": tags$1.character,
        Comment: tags$1.blockComment,
        ProcessingInst: tags$1.processingInstruction,
        DoctypeDecl: tags$1.documentMeta
    }), safari = LRParser.deserialize({
        version: 14,
        states: ",xOVO!rOOO!WQ#tO'#CqO!]Q#tO'#CzO!bQ#tO'#C}O!gQ#tO'#DQO!lQ#tO'#DSO!qOaO'#CpO!|ObO'#CpO#XOdO'#CpO$eO!rO'#CpOOO`'#Cp'#CpO$lO$fO'#DTO$tQ#tO'#DVO$yQ#tO'#DWOOO`'#Dk'#DkOOO`'#DY'#DYQVO!rOOO%OQ&rO,59]O%ZQ&rO,59fO%fQ&rO,59iO%qQ&rO,59lO%|Q&rO,59nOOOa'#D^'#D^O&XOaO'#CxO&dOaO,59[OOOb'#D_'#D_O&lObO'#C{O&wObO,59[OOOd'#D`'#D`O'POdO'#DOO'[OdO,59[OOO`'#Da'#DaO'dO!rO,59[O'kQ#tO'#DROOO`,59[,59[OOOp'#Db'#DbO'pO$fO,59oOOO`,59o,59oO'xQ#|O,59qO'}Q#|O,59rOOO`-E7W-E7WO(SQ&rO'#CsOOQW'#DZ'#DZO(bQ&rO1G.wOOOa1G.w1G.wOOO`1G/Y1G/YO(mQ&rO1G/QOOOb1G/Q1G/QO(xQ&rO1G/TOOOd1G/T1G/TO)TQ&rO1G/WOOO`1G/W1G/WO)`Q&rO1G/YOOOa-E7[-E7[O)kQ#tO'#CyOOO`1G.v1G.vOOOb-E7]-E7]O)pQ#tO'#C|OOOd-E7^-E7^O)uQ#tO'#DPOOO`-E7_-E7_O)zQ#|O,59mOOOp-E7`-E7`OOO`1G/Z1G/ZOOO`1G/]1G/]OOO`1G/^1G/^O*PQ,UO,59_OOQW-E7X-E7XOOOa7+$c7+$cOOO`7+$t7+$tOOOb7+$l7+$lOOOd7+$o7+$oOOO`7+$r7+$rO*[Q#|O,59eO*aQ#|O,59hO*fQ#|O,59kOOO`1G/X1G/XO*kO7[O'#CvO*|OMhO'#CvOOQW1G.y1G.yOOO`1G/P1G/POOO`1G/S1G/SOOO`1G/V1G/VOOOO'#D['#D[O+_O7[O,59bOOQW,59b,59bOOOO'#D]'#D]O+pOMhO,59bOOOO-E7Y-E7YOOQW1G.|1G.|OOOO-E7Z-E7Z",
        stateData: ",]~O!^OS~OUSOVPOWQOXROYTO[]O][O^^O`^Oa^Ob^Oc^Ox^O{_O!dZO~OfaO~OfbO~OfcO~OfdO~OfeO~O!WfOPlP!ZlP~O!XiOQoP!ZoP~O!YlORrP!ZrP~OUSOVPOWQOXROYTOZqO[]O][O^^O`^Oa^Ob^Oc^Ox^O!dZO~O!ZrO~P#dO![sO!euO~OfvO~OfwO~OS|OT}OhyO~OS!POT}OhyO~OS!ROT}OhyO~OS!TOT}OhyO~OS}OT}OhyO~O!WfOPlX!ZlX~OP!WO!Z!XO~O!XiOQoX!ZoX~OQ!ZO!Z!XO~O!YlORrX!ZrX~OR!]O!Z!XO~O!Z!XO~P#dOf!_O~O![sO!e!aO~OS!bO~OS!cO~Oi!dOSgXTgXhgX~OS!fOT!gOhyO~OS!hOT!gOhyO~OS!iOT!gOhyO~OS!jOT!gOhyO~OS!gOT!gOhyO~Of!kO~Of!lO~Of!mO~OS!nO~Ok!qO!`!oO!b!pO~OS!rO~OS!sO~OS!tO~Oa!uOb!uOc!uO!`!wO!a!uO~Oa!xOb!xOc!xO!b!wO!c!xO~Oa!uOb!uOc!uO!`!{O!a!uO~Oa!xOb!xOc!xO!b!{O!c!xO~OT~bac!dx{!d~",
        goto: "%p!`PPPPPPPPPPPPPPPPPPPP!a!gP!mPP!yP!|#P#S#Y#]#`#f#i#l#r#x!aP!a!aP$O$U$l$r$x%O%U%[%bPPPPPPPP%hX^OX`pXUOX`pezabcde{!O!Q!S!UR!q!dRhUR!XhXVOX`pRkVR!XkXWOX`pRnWR!XnXXOX`pQrXR!XpXYOX`pQ`ORx`Q{aQ!ObQ!QcQ!SdQ!UeZ!e{!O!Q!S!UQ!v!oR!z!vQ!y!pR!|!yQgUR!VgQjVR!YjQmWR![mQpXR!^pQtZR!`tS_O`ToXp",
        nodeNames: "\u26a0 StartCloseTag StartCloseTag StartCloseTag EndTag SelfClosingEndTag StartTag StartTag StartTag StartTag StartTag StartCloseTag StartCloseTag StartCloseTag IncompleteCloseTag Document Text EntityReference CharacterReference InvalidEntity Element OpenTag TagName Attribute AttributeName Is AttributeValue UnquotedAttributeValue ScriptText CloseTag OpenTag StyleText CloseTag OpenTag TextareaText CloseTag OpenTag CloseTag SelfClosingTag Comment ProcessingInst MismatchedCloseTag CloseTag DoctypeDecl",
        maxTerm: 67,
        context: safari,
        nodeProps: [ [ "closedBy", -10, 1, 2, 3, 7, 8, 9, 10, 11, 12, 13, "EndTag", 6, "EndTag SelfClosingEndTag", -4, 21, 30, 33, 36, "CloseTag" ], [ "openedBy", 4, "StartTag StartCloseTag", 5, "StartTag", -4, 29, 32, 35, 37, "OpenTag" ], [ "group", -9, 14, 17, 18, 19, 20, 39, 40, 41, 42, "Entity", 16, "Entity TextContent", -3, 28, 31, 34, "TextContent Entity" ], [ "isolate", -11, 21, 29, 30, 32, 33, 35, 36, 37, 38, 41, 42, "ltr", -3, 26, 27, 39, "" ] ],
        propSources: [ htmlHighlighting ],
        skippedNodes: [ 0 ],
        repeatNodeCount: 9,
        tokenData: "!<p!aR!YOX$qXY,QYZ,QZ[$q[]&X]^,Q^p$qpq,Qqr-_rs3_sv-_vw3}wxHYx}-_}!OH{!O!P-_!P!Q$q!Q![-_![!]Mz!]!^-_!^!_!$S!_!`!;x!`!a&X!a!c-_!c!}Mz!}#R-_#R#SMz#S#T1k#T#oMz#o#s-_#s$f$q$f%W-_%W%oMz%o%p-_%p&aMz&a&b-_&b1pMz1p4U-_4U4dMz4d4e-_4e$ISMz$IS$I`-_$I`$IbMz$Ib$Kh-_$Kh%#tMz%#t&/x-_&/x&EtMz&Et&FV-_&FV;'SMz;'S;:j!#|;:j;=`3X<%l?&r-_?&r?AhMz?Ah?BY$q?BY?MnMz?MnO$q!Z$|c`PkW!a`!cpOX$qXZ&XZ[$q[^&X^p$qpq&Xqr$qrs&}sv$qvw+Pwx(tx!^$q!^!_*V!_!a&X!a#S$q#S#T&X#T;'S$q;'S;=`+z<%lO$q!R&bX`P!a`!cpOr&Xrs&}sv&Xwx(tx!^&X!^!_*V!_;'S&X;'S;=`*y<%lO&Xq'UV`P!cpOv&}wx'kx!^&}!^!_(V!_;'S&};'S;=`(n<%lO&}P'pT`POv'kw!^'k!_;'S'k;'S;=`(P<%lO'kP(SP;=`<%l'kp([S!cpOv(Vx;'S(V;'S;=`(h<%lO(Vp(kP;=`<%l(Vq(qP;=`<%l&}a({W`P!a`Or(trs'ksv(tw!^(t!^!_)e!_;'S(t;'S;=`*P<%lO(t`)jT!a`Or)esv)ew;'S)e;'S;=`)y<%lO)e`)|P;=`<%l)ea*SP;=`<%l(t!Q*^V!a`!cpOr*Vrs(Vsv*Vwx)ex;'S*V;'S;=`*s<%lO*V!Q*vP;=`<%l*V!R*|P;=`<%l&XW+UYkWOX+PZ[+P^p+Pqr+Psw+Px!^+P!a#S+P#T;'S+P;'S;=`+t<%lO+PW+wP;=`<%l+P!Z+}P;=`<%l$q!a,]``P!a`!cp!^^OX&XXY,QYZ,QZ]&X]^,Q^p&Xpq,Qqr&Xrs&}sv&Xwx(tx!^&X!^!_*V!_;'S&X;'S;=`*y<%lO&X!_-ljhS`PkW!a`!cpOX$qXZ&XZ[$q[^&X^p$qpq&Xqr-_rs&}sv-_vw/^wx(tx!P-_!P!Q$q!Q!^-_!^!_*V!_!a&X!a#S-_#S#T1k#T#s-_#s$f$q$f;'S-_;'S;=`3X<%l?Ah-_?Ah?BY$q?BY?Mn-_?MnO$q[/ebhSkWOX+PZ[+P^p+Pqr/^sw/^x!P/^!P!Q+P!Q!^/^!a#S/^#S#T0m#T#s/^#s$f+P$f;'S/^;'S;=`1e<%l?Ah/^?Ah?BY+P?BY?Mn/^?MnO+PS0rXhSqr0msw0mx!P0m!Q!^0m!a#s0m$f;'S0m;'S;=`1_<%l?Ah0m?BY?Mn0mS1bP;=`<%l0m[1hP;=`<%l/^!V1vchS`P!a`!cpOq&Xqr1krs&}sv1kvw0mwx(tx!P1k!P!Q&X!Q!^1k!^!_*V!_!a&X!a#s1k#s$f&X$f;'S1k;'S;=`3R<%l?Ah1k?Ah?BY&X?BY?Mn1k?MnO&X!V3UP;=`<%l1k!_3[P;=`<%l-_!Z3hV!`h`P!cpOv&}wx'kx!^&}!^!_(V!_;'S&};'S;=`(n<%lO&}!_4WihSkWc!ROX5uXZ7SZ[5u[^7S^p5uqr8trs7Sst>]tw8twx7Sx!P8t!P!Q5u!Q!]8t!]!^/^!^!a7S!a#S8t#S#T;{#T#s8t#s$f5u$f;'S8t;'S;=`>V<%l?Ah8t?Ah?BY5u?BY?Mn8t?MnO5u!Z5zbkWOX5uXZ7SZ[5u[^7S^p5uqr5urs7Sst+Ptw5uwx7Sx!]5u!]!^7w!^!a7S!a#S5u#S#T7S#T;'S5u;'S;=`8n<%lO5u!R7VVOp7Sqs7St!]7S!]!^7l!^;'S7S;'S;=`7q<%lO7S!R7qOa!R!R7tP;=`<%l7S!Z8OYkWa!ROX+PZ[+P^p+Pqr+Psw+Px!^+P!a#S+P#T;'S+P;'S;=`+t<%lO+P!Z8qP;=`<%l5u!_8{ihSkWOX5uXZ7SZ[5u[^7S^p5uqr8trs7Sst/^tw8twx7Sx!P8t!P!Q5u!Q!]8t!]!^:j!^!a7S!a#S8t#S#T;{#T#s8t#s$f5u$f;'S8t;'S;=`>V<%l?Ah8t?Ah?BY5u?BY?Mn8t?MnO5u!_:sbhSkWa!ROX+PZ[+P^p+Pqr/^sw/^x!P/^!P!Q+P!Q!^/^!a#S/^#S#T0m#T#s/^#s$f+P$f;'S/^;'S;=`1e<%l?Ah/^?Ah?BY+P?BY?Mn/^?MnO+P!V<QchSOp7Sqr;{rs7Sst0mtw;{wx7Sx!P;{!P!Q7S!Q!];{!]!^=]!^!a7S!a#s;{#s$f7S$f;'S;{;'S;=`>P<%l?Ah;{?Ah?BY7S?BY?Mn;{?MnO7S!V=dXhSa!Rqr0msw0mx!P0m!Q!^0m!a#s0m$f;'S0m;'S;=`1_<%l?Ah0m?BY?Mn0m!V>SP;=`<%l;{!_>YP;=`<%l8t!_>dhhSkWOX@OXZAYZ[@O[^AY^p@OqrBwrsAYswBwwxAYx!PBw!P!Q@O!Q!]Bw!]!^/^!^!aAY!a#SBw#S#TE{#T#sBw#s$f@O$f;'SBw;'S;=`HS<%l?AhBw?Ah?BY@O?BY?MnBw?MnO@O!Z@TakWOX@OXZAYZ[@O[^AY^p@Oqr@OrsAYsw@OwxAYx!]@O!]!^Az!^!aAY!a#S@O#S#TAY#T;'S@O;'S;=`Bq<%lO@O!RA]UOpAYq!]AY!]!^Ao!^;'SAY;'S;=`At<%lOAY!RAtOb!R!RAwP;=`<%lAY!ZBRYkWb!ROX+PZ[+P^p+Pqr+Psw+Px!^+P!a#S+P#T;'S+P;'S;=`+t<%lO+P!ZBtP;=`<%l@O!_COhhSkWOX@OXZAYZ[@O[^AY^p@OqrBwrsAYswBwwxAYx!PBw!P!Q@O!Q!]Bw!]!^Dj!^!aAY!a#SBw#S#TE{#T#sBw#s$f@O$f;'SBw;'S;=`HS<%l?AhBw?Ah?BY@O?BY?MnBw?MnO@O!_DsbhSkWb!ROX+PZ[+P^p+Pqr/^sw/^x!P/^!P!Q+P!Q!^/^!a#S/^#S#T0m#T#s/^#s$f+P$f;'S/^;'S;=`1e<%l?Ah/^?Ah?BY+P?BY?Mn/^?MnO+P!VFQbhSOpAYqrE{rsAYswE{wxAYx!PE{!P!QAY!Q!]E{!]!^GY!^!aAY!a#sE{#s$fAY$f;'SE{;'S;=`G|<%l?AhE{?Ah?BYAY?BY?MnE{?MnOAY!VGaXhSb!Rqr0msw0mx!P0m!Q!^0m!a#s0m$f;'S0m;'S;=`1_<%l?Ah0m?BY?Mn0m!VHPP;=`<%lE{!_HVP;=`<%lBw!ZHcW!bx`P!a`Or(trs'ksv(tw!^(t!^!_)e!_;'S(t;'S;=`*P<%lO(t!aIYlhS`PkW!a`!cpOX$qXZ&XZ[$q[^&X^p$qpq&Xqr-_rs&}sv-_vw/^wx(tx}-_}!OKQ!O!P-_!P!Q$q!Q!^-_!^!_*V!_!a&X!a#S-_#S#T1k#T#s-_#s$f$q$f;'S-_;'S;=`3X<%l?Ah-_?Ah?BY$q?BY?Mn-_?MnO$q!aK_khS`PkW!a`!cpOX$qXZ&XZ[$q[^&X^p$qpq&Xqr-_rs&}sv-_vw/^wx(tx!P-_!P!Q$q!Q!^-_!^!_*V!_!`&X!`!aMS!a#S-_#S#T1k#T#s-_#s$f$q$f;'S-_;'S;=`3X<%l?Ah-_?Ah?BY$q?BY?Mn-_?MnO$q!TM_X`P!a`!cp!eQOr&Xrs&}sv&Xwx(tx!^&X!^!_*V!_;'S&X;'S;=`*y<%lO&X!aNZ!ZhSfQ`PkW!a`!cpOX$qXZ&XZ[$q[^&X^p$qpq&Xqr-_rs&}sv-_vw/^wx(tx}-_}!OMz!O!PMz!P!Q$q!Q![Mz![!]Mz!]!^-_!^!_*V!_!a&X!a!c-_!c!}Mz!}#R-_#R#SMz#S#T1k#T#oMz#o#s-_#s$f$q$f$}-_$}%OMz%O%W-_%W%oMz%o%p-_%p&aMz&a&b-_&b1pMz1p4UMz4U4dMz4d4e-_4e$ISMz$IS$I`-_$I`$IbMz$Ib$Je-_$Je$JgMz$Jg$Kh-_$Kh%#tMz%#t&/x-_&/x&EtMz&Et&FV-_&FV;'SMz;'S;:j!#|;:j;=`3X<%l?&r-_?&r?AhMz?Ah?BY$q?BY?MnMz?MnO$q!a!$PP;=`<%lMz!R!$ZY!a`!cpOq*Vqr!$yrs(Vsv*Vwx)ex!a*V!a!b!4t!b;'S*V;'S;=`*s<%lO*V!R!%Q]!a`!cpOr*Vrs(Vsv*Vwx)ex}*V}!O!%y!O!f*V!f!g!']!g#W*V#W#X!0`#X;'S*V;'S;=`*s<%lO*V!R!&QX!a`!cpOr*Vrs(Vsv*Vwx)ex}*V}!O!&m!O;'S*V;'S;=`*s<%lO*V!R!&vV!a`!cp!dPOr*Vrs(Vsv*Vwx)ex;'S*V;'S;=`*s<%lO*V!R!'dX!a`!cpOr*Vrs(Vsv*Vwx)ex!q*V!q!r!(P!r;'S*V;'S;=`*s<%lO*V!R!(WX!a`!cpOr*Vrs(Vsv*Vwx)ex!e*V!e!f!(s!f;'S*V;'S;=`*s<%lO*V!R!(zX!a`!cpOr*Vrs(Vsv*Vwx)ex!v*V!v!w!)g!w;'S*V;'S;=`*s<%lO*V!R!)nX!a`!cpOr*Vrs(Vsv*Vwx)ex!{*V!{!|!*Z!|;'S*V;'S;=`*s<%lO*V!R!*bX!a`!cpOr*Vrs(Vsv*Vwx)ex!r*V!r!s!*}!s;'S*V;'S;=`*s<%lO*V!R!+UX!a`!cpOr*Vrs(Vsv*Vwx)ex!g*V!g!h!+q!h;'S*V;'S;=`*s<%lO*V!R!+xY!a`!cpOr!+qrs!,hsv!+qvw!-Swx!.[x!`!+q!`!a!/j!a;'S!+q;'S;=`!0Y<%lO!+qq!,mV!cpOv!,hvx!-Sx!`!,h!`!a!-q!a;'S!,h;'S;=`!.U<%lO!,hP!-VTO!`!-S!`!a!-f!a;'S!-S;'S;=`!-k<%lO!-SP!-kO{PP!-nP;=`<%l!-Sq!-xS!cp{POv(Vx;'S(V;'S;=`(h<%lO(Vq!.XP;=`<%l!,ha!.aX!a`Or!.[rs!-Ssv!.[vw!-Sw!`!.[!`!a!.|!a;'S!.[;'S;=`!/d<%lO!.[a!/TT!a`{POr)esv)ew;'S)e;'S;=`)y<%lO)ea!/gP;=`<%l!.[!R!/sV!a`!cp{POr*Vrs(Vsv*Vwx)ex;'S*V;'S;=`*s<%lO*V!R!0]P;=`<%l!+q!R!0gX!a`!cpOr*Vrs(Vsv*Vwx)ex#c*V#c#d!1S#d;'S*V;'S;=`*s<%lO*V!R!1ZX!a`!cpOr*Vrs(Vsv*Vwx)ex#V*V#V#W!1v#W;'S*V;'S;=`*s<%lO*V!R!1}X!a`!cpOr*Vrs(Vsv*Vwx)ex#h*V#h#i!2j#i;'S*V;'S;=`*s<%lO*V!R!2qX!a`!cpOr*Vrs(Vsv*Vwx)ex#m*V#m#n!3^#n;'S*V;'S;=`*s<%lO*V!R!3eX!a`!cpOr*Vrs(Vsv*Vwx)ex#d*V#d#e!4Q#e;'S*V;'S;=`*s<%lO*V!R!4XX!a`!cpOr*Vrs(Vsv*Vwx)ex#X*V#X#Y!+q#Y;'S*V;'S;=`*s<%lO*V!R!4{Y!a`!cpOr!4trs!5ksv!4tvw!6Vwx!8]x!a!4t!a!b!:]!b;'S!4t;'S;=`!;r<%lO!4tq!5pV!cpOv!5kvx!6Vx!a!5k!a!b!7W!b;'S!5k;'S;=`!8V<%lO!5kP!6YTO!a!6V!a!b!6i!b;'S!6V;'S;=`!7Q<%lO!6VP!6lTO!`!6V!`!a!6{!a;'S!6V;'S;=`!7Q<%lO!6VP!7QOxPP!7TP;=`<%l!6Vq!7]V!cpOv!5kvx!6Vx!`!5k!`!a!7r!a;'S!5k;'S;=`!8V<%lO!5kq!7yS!cpxPOv(Vx;'S(V;'S;=`(h<%lO(Vq!8YP;=`<%l!5ka!8bX!a`Or!8]rs!6Vsv!8]vw!6Vw!a!8]!a!b!8}!b;'S!8];'S;=`!:V<%lO!8]a!9SX!a`Or!8]rs!6Vsv!8]vw!6Vw!`!8]!`!a!9o!a;'S!8];'S;=`!:V<%lO!8]a!9vT!a`xPOr)esv)ew;'S)e;'S;=`)y<%lO)ea!:YP;=`<%l!8]!R!:dY!a`!cpOr!4trs!5ksv!4tvw!6Vwx!8]x!`!4t!`!a!;S!a;'S!4t;'S;=`!;r<%lO!4t!R!;]V!a`!cpxPOr*Vrs(Vsv*Vwx)ex;'S*V;'S;=`*s<%lO*V!R!;uP;=`<%l!4t!V!<TXiS`P!a`!cpOr&Xrs&}sv&Xwx(tx!^&X!^!_*V!_;'S&X;'S;=`*y<%lO&X",
        tokenizers: [ scriptTokens, styleTokens, textareaTokens, endTag, cursorDocStart, punctuation, 0, 1, 2, 3, 4, 5 ],
        topRules: {
            Document: [ 0, 15 ]
        },
        dialects: {
            noMatch: 0,
            selfClosing: 509
        },
        tokenPrec: 511
    });
    function getAttrs(openTag, input) {
        var att, attrs = Object.create(null);
        for (att of openTag.getChildren(Attribute)) {
            var name = att.getChild(AttributeName), value = att.getChild(AttributeValue) || att.getChild(UnquotedAttributeValue);
            name && (attrs[input.read(name.from, name.to)] = value ? value.type.id == AttributeValue ? input.read(value.from + 1, value.to - 1) : input.read(value.from, value.to) : "");
        }
        return attrs;
    }
    function findTagName(openTag, input) {
        openTag = openTag.getChild(TagName);
        return openTag ? input.read(openTag.from, openTag.to) : " ";
    }
    function maybeNest(node, input, tags) {
        let attrs;
        for (var tag of tags) if (!tag.attrs || tag.attrs(attrs = attrs || getAttrs(node.node.parent.firstChild, input))) return {
            parser: tag.parser
        };
        return null;
    }
    function configureNesting(tags = [], attributes = []) {
        let script = [], style = [], textarea = [], other = [];
        for (var tag of tags) ("script" == tag.tag ? script : "style" == tag.tag ? style : "textarea" == tag.tag ? textarea : other).push(tag);
        let attrs = attributes.length ? Object.create(null) : null;
        for (var attr of attributes) (attrs[attr.name] || (attrs[attr.name] = [])).push(attr);
        return parseMixed((node, input) => {
            var id = node.type.id;
            if (28 == id) return maybeNest(node, input, script);
            if (31 == id) return maybeNest(node, input, style);
            if (34 == id) return maybeNest(node, input, textarea);
            if (20 == id && other.length) {
                let n = node.node, open = n.firstChild, tagName = open && findTagName(open, input), attrs;
                if (tagName) for (var tag of other) if (tag.tag == tagName && (!tag.attrs || tag.attrs(attrs = attrs || getAttrs(n, input)))) {
                    var close = n.lastChild, close = 37 == close.type.id ? close.from : n.to;
                    if (close > open.to) return {
                        parser: tag.parser,
                        overlay: [ {
                            from: open.to,
                            to: close
                        } ]
                    };
                }
            }
            if (attrs && id == Attribute) {
                var n = node.node;
                if (id = n.firstChild) {
                    node = attrs[input.read(id.from, id.to)];
                    if (node) for (var attr of node) if (!attr.tagName || attr.tagName == findTagName(n.parent, input)) {
                        var value = n.lastChild;
                        if (value.type.id == AttributeValue) {
                            var from = value.from + 1;
                            let last = value.lastChild, to = value.to - (last && last.isError ? 0 : 1);
                            if (to > from) return {
                                parser: attr.parser,
                                overlay: [ {
                                    from: from,
                                    to: to
                                } ]
                            };
                        } else if (value.type.id == UnquotedAttributeValue) return {
                            parser: attr.parser,
                            overlay: [ {
                                from: value.from,
                                to: value.to
                            } ]
                        };
                    }
                }
            }
            return null;
        });
    }
    const space$2 = [ 9, 10, 11, 12, 13, 32, 133, 160, 5760, 8192, 8193, 8194, 8195, 8196, 8197, 8198, 8199, 8200, 8201, 8202, 8232, 8233, 8239, 8287, 12288 ];
    function isAlpha(ch) {
        return 65 <= ch && ch <= 90 || 97 <= ch && ch <= 122 || 161 <= ch;
    }
    function isDigit(ch) {
        return 48 <= ch && ch <= 57;
    }
    htmlHighlighting = new ExternalTokenizer((input, stack) => {
        for (let inside = !1, dashes = 0, i = 0; ;i++) {
            var next = input["next"];
            if (isAlpha(next) || 45 == next || 95 == next || inside && isDigit(next)) !inside && (45 != next || 0 < i) && (inside = !0), 
            dashes === i && 45 == next && dashes++, input.advance(); else {
                if (92 != next || 10 == input.peek(1)) {
                    inside && input.acceptToken(40 == next ? 100 : 2 == dashes && stack.canShift(2) ? 2 : 101);
                    break;
                }
                input.advance(), -1 < input.next && input.advance(), inside = !0;
            }
        }
    }), scriptTokens = new ExternalTokenizer(input => {
        var next;
        space$2.includes(input.peek(-1)) && (next = input["next"], isAlpha(next) || 95 == next || 35 == next || 46 == next || 91 == next || 58 == next && isAlpha(input.peek(1)) || 45 == next || 38 == next) && input.acceptToken(99);
    }), styleTokens = new ExternalTokenizer(input => {
        if (!space$2.includes(input.peek(-1))) {
            var next = input["next"];
            if (37 == next && (input.advance(), input.acceptToken(1)), isAlpha(next)) {
                for (;input.advance(), isAlpha(input.next) || isDigit(input.next); );
                input.acceptToken(1);
            }
        }
    }), textareaTokens = styleTags({
        "AtKeyword import charset namespace keyframes media supports": tags$1.definitionKeyword,
        "from to selector": tags$1.keyword,
        NamespaceName: tags$1.namespace,
        KeyframeName: tags$1.labelName,
        KeyframeRangeName: tags$1.operatorKeyword,
        TagName: tags$1.tagName,
        ClassName: tags$1.className,
        PseudoClassName: tags$1.constant(tags$1.className),
        IdName: tags$1.labelName,
        "FeatureName PropertyName": tags$1.propertyName,
        AttributeName: tags$1.attributeName,
        NumberLiteral: tags$1.number,
        KeywordQuery: tags$1.keyword,
        UnaryQueryOp: tags$1.operatorKeyword,
        "CallTag ValueName": tags$1.atom,
        VariableName: tags$1.variableName,
        Callee: tags$1.operatorKeyword,
        Unit: tags$1.unit,
        "UniversalSelector NestingSelector": tags$1.definitionOperator,
        MatchOp: tags$1.compareOperator,
        "ChildOp SiblingOp, LogicOp": tags$1.logicOperator,
        BinOp: tags$1.arithmeticOperator,
        Important: tags$1.modifier,
        Comment: tags$1.blockComment,
        ColorLiteral: tags$1.color,
        "ParenthesizedContent StringLiteral": tags$1.string,
        ":": tags$1.punctuation,
        "PseudoOp #": tags$1.derefOperator,
        "; ,": tags$1.separator,
        "( )": tags$1.paren,
        "[ ]": tags$1.squareBracket,
        "{ }": tags$1.brace
    });
    const spec_callee = {
        __proto__: null,
        lang: 32,
        "nth-child": 32,
        "nth-last-child": 32,
        "nth-of-type": 32,
        "nth-last-of-type": 32,
        dir: 32,
        "host-context": 32,
        url: 60,
        "url-prefix": 60,
        domain: 60,
        regexp: 60,
        selector: 138
    }, spec_AtKeyword = {
        __proto__: null,
        "@import": 118,
        "@media": 142,
        "@charset": 146,
        "@namespace": 150,
        "@keyframes": 156,
        "@supports": 168
    }, spec_identifier$1 = {
        __proto__: null,
        not: 132,
        only: 132
    };
    endTag = LRParser.deserialize({
        version: 14,
        states: ":^QYQ[OOO#_Q[OOP#fOWOOOOQP'#Cd'#CdOOQP'#Cc'#CcO#kQ[O'#CfO$_QXO'#CaO$fQ[O'#ChO$qQ[O'#DTO$vQ[O'#DWOOQP'#Em'#EmO${QdO'#DgO%jQ[O'#DtO${QdO'#DvO%{Q[O'#DxO&WQ[O'#D{O&`Q[O'#ERO&nQ[O'#ETOOQS'#El'#ElOOQS'#EW'#EWQYQ[OOO&uQXO'#CdO'jQWO'#DcO'oQWO'#EsO'zQ[O'#EsQOQWOOP(UO#tO'#C_POOO)C@[)C@[OOQP'#Cg'#CgOOQP,59Q,59QO#kQ[O,59QO(aQ[O'#E[O({QWO,58{O)TQ[O,59SO$qQ[O,59oO$vQ[O,59rO(aQ[O,59uO(aQ[O,59wO(aQ[O,59xO)`Q[O'#DbOOQS,58{,58{OOQP'#Ck'#CkOOQO'#DR'#DROOQP,59S,59SO)gQWO,59SO)lQWO,59SOOQP'#DV'#DVOOQP,59o,59oOOQO'#DX'#DXO)qQ`O,59rOOQS'#Cp'#CpO${QdO'#CqO)yQvO'#CsO+ZQtO,5:ROOQO'#Cx'#CxO)lQWO'#CwO+oQWO'#CyO+tQ[O'#DOOOQS'#Ep'#EpOOQO'#Dj'#DjO+|Q[O'#DqO,[QWO'#EtO&`Q[O'#DoO,jQWO'#DrOOQO'#Eu'#EuO)OQWO,5:`O,oQpO,5:bOOQS'#Dz'#DzO,wQWO,5:dO,|Q[O,5:dOOQO'#D}'#D}O-UQWO,5:gO-ZQWO,5:mO-cQWO,5:oOOQS-E8U-E8UO${QdO,59}O-kQ[O'#E^O-xQWO,5;_O-xQWO,5;_POOO'#EV'#EVP.TO#tO,58yPOOO,58y,58yOOQP1G.l1G.lO.zQXO,5:vOOQO-E8Y-E8YOOQS1G.g1G.gOOQP1G.n1G.nO)gQWO1G.nO)lQWO1G.nOOQP1G/Z1G/ZO/XQ`O1G/^O/rQXO1G/aO0YQXO1G/cO0pQXO1G/dO1WQWO,59|O1]Q[O'#DSO1dQdO'#CoOOQP1G/^1G/^O${QdO1G/^O1kQpO,59]OOQS,59_,59_O${QdO,59aO1sQWO1G/mOOQS,59c,59cO1xQ!bO,59eOOQS'#DP'#DPOOQS'#EY'#EYO2QQ[O,59jOOQS,59j,59jO2YQWO'#DjO2eQWO,5:VO2jQWO,5:]O&`Q[O,5:XO&`Q[O'#E_O2rQWO,5;`O2}QWO,5:ZO(aQ[O,5:^OOQS1G/z1G/zOOQS1G/|1G/|OOQS1G0O1G0OO3`QWO1G0OO3eQdO'#EOOOQS1G0R1G0ROOQS1G0X1G0XOOQS1G0Z1G0ZO3pQtO1G/iOOQO,5:x,5:xO4WQ[O,5:xOOQO-E8[-E8[O4eQWO1G0yPOOO-E8T-E8TPOOO1G.e1G.eOOQP7+$Y7+$YOOQP7+$x7+$xO${QdO7+$xOOQS1G/h1G/hO4pQXO'#ErO4wQWO,59nO4|QtO'#EXO5tQdO'#EoO6OQWO,59ZO6TQpO7+$xOOQS1G.w1G.wOOQS1G.{1G.{OOQS7+%X7+%XO6]QWO1G/POOQS-E8W-E8WOOQS1G/U1G/UO${QdO1G/qOOQO1G/w1G/wOOQO1G/s1G/sO6bQWO,5:yOOQO-E8]-E8]O6pQXO1G/xOOQS7+%j7+%jO6wQYO'#CsOOQO'#EQ'#EQO7SQ`O'#EPOOQO'#EP'#EPO7_QWO'#E`O7gQdO,5:jOOQS,5:j,5:jO7rQtO'#E]O${QdO'#E]O8sQdO7+%TOOQO7+%T7+%TOOQO1G0d1G0dO9WQpO<<HdO9`QWO,5;^OOQP1G/Y1G/YOOQS-E8V-E8VO${QdO'#EZO9hQWO,5;ZOOQT1G.u1G.uOOQP<<Hd<<HdOOQS7+$k7+$kO9pQdO7+%]OOQO7+%d7+%dOOQO,5:k,5:kO3hQdO'#EaO7_QWO,5:zOOQS,5:z,5:zOOQS-E8^-E8^OOQS1G0U1G0UO9wQtO,5:wOOQS-E8Z-E8ZOOQO<<Ho<<HoOOQPAN>OAN>OO:xQdO,5:uOOQO-E8X-E8XOOQO<<Hw<<HwOOQO,5:{,5:{OOQO-E8_-E8_OOQS1G0f1G0f",
        stateData: ";[~O#ZOS#[QQ~OUYOXYO]VO^VOqXOxWO![aO!]ZO!i[O!k]O!m^O!p_O!v`O#XRO#bTO~OQfOUYOXYO]VO^VOqXOxWO![aO!]ZO!i[O!k]O!m^O!p_O!v`O#XeO#bTO~O#U#gP~P!ZO#[jO~O#XlO~O]qO^qOqsOtoOxrO!OtO!RvO#VuO#bnO~O!TwO~P#pO`}O#WzO#XyO~O#X!OO~O#X!QO~OQ![Ob!TOf![Oh![On!YOq!ZO#W!WO#X!SO#e!UO~Ob!^O!d!`O!g!aO#X!]O!T#hP~Oh!fOn!YO#X!eO~Oh!hO#X!hO~Ob!^O!d!`O!g!aO#X!]O~O!Y#hP~P%jO]WX]!WX^WXqWXtWXxWX!OWX!RWX!TWX#VWX#bWX~O]!mO~O!Y!nO#U#gX!S#gX~O#U#gX!S#gX~P!ZO#]!qO#^!qO#_!sO~OUYOXYO]VO^VOqXOxWO#XRO#bTO~OtoO!TwO~O`!zO#WzO#XyO~O!S#gP~P!ZOb#RO~Ob#SO~Op#TO|#UO~OP#WObgXjgX!YgX!dgX!ggX#XgXagXQgXfgXhgXngXqgXtgX!XgX#UgX#WgX#egXpgX!SgX~Ob!^Oj#XO!d!`O!g!aO#X!]O!Y#hP~Ob#[O~Op#`O#X#]O~Ob!^O!d!`O!g!aO#X#aO~Ot#eO!b#dO!T#hX!Y#hX~Ob#hO~Oj#XO!Y#jO~O!Y#kO~Oh#lOn!YO~O!T#mO~O!TwO!b#dO~O!TwO!Y#pO~O!Y#QX#U#QX!S#QX~P!ZO!Y!nO#U#ga!S#ga~O#]!qO#^!qO#_#wO~O]qO^qOqsOxrO!OtO!RvO#VuO#bnO~Ot#Oa!T#Oaa#Oa~P.`Op#yO|#zO~O]qO^qOqsOxrO#bnO~Ot}i!O}i!R}i!T}i#V}ia}i~P/aOt!Pi!O!Pi!R!Pi!T!Pi#V!Pia!Pi~P/aOt!Qi!O!Qi!R!Qi!T!Qi#V!Qia!Qi~P/aO!S#{O~Oa#fP~P(aOa#cP~P${Oa$SOj#XO~O!Y$UO~Oh$VOo$VO~Op$XO#X#]O~O]!`Xa!^X!b!^X~O]$YO~Oa$ZO!b#dO~Ot#eO!T#ha!Y#ha~O!b#dOt!ca!T!ca!Y!caa!ca~O!Y$`O~O!S$gO#X$bO#e$aO~Oj#XOt$iO!X$kO!Y!Vi#U!Vi!S!Vi~P${O!Y#Qa#U#Qa!S#Qa~P!ZO!Y!nO#U#gi!S#gi~Oa#fX~P#pOa$oO~Oj#XOQ!{Xa!{Xb!{Xf!{Xh!{Xn!{Xq!{Xt!{X#W!{X#X!{X#e!{X~Ot$qOa#cX~P${Oa$sO~Oj#XOp$tO~Oa$uO~O!b#dOt#Ra!T#Ra!Y#Ra~Oa$wO~P.`OP#WOtgX!TgX~O#e$aOt!sX!T!sX~Ot$yO!TwO~O!S$}O#X$bO#e$aO~Oj#XOQ#PXb#PXf#PXh#PXn#PXq#PXt#PX!X#PX!Y#PX#U#PX#W#PX#X#PX#e#PX!S#PX~Ot$iO!X%QO!Y!Vq#U!Vq!S!Vq~P${Oj#XOp%RO~OtoOa#fa~Ot$qOa#ca~Oa%UO~P${Oj#XOQ#Pab#Paf#Pah#Pan#Paq#Pat#Pa!X#Pa!Y#Pa#U#Pa#W#Pa#X#Pa#e#Pa!S#Pa~Oa!}at!}a~P${O#Zo#[#ej!R#e~",
        goto: "-g#jPPP#kP#nP#w$WP#w$g#wPP$mPPP$s$|$|P%`P$|P$|%z&^PPPP$|&vP&z'Q#wP'W#w'^P#wP#w#wPPP'd'y(WPP#nPP(_(_(i(_P(_P(_(_P#nP#nP#nP(l#nP(o(r(u(|#nP#nP)R)X)h)v)|*S*^*d*n*t*zPPPPPPPPPP+Q+ZP+v+yP,o,r,x-RRkQ_bOPdhw!n#skYOPdhotuvw!n#R#h#skSOPdhotuvw!n#R#h#sQmTR!tnQ{VR!xqQ!x}Q#Z!XR#x!zq![Z]!T!m#S#U#X#q#z$P$Y$i$j$q$v%Sp![Z]!T!m#S#U#X#q#z$P$Y$i$j$q$v%SU$d#m$f$yR$x$cq!XZ]!T!m#S#U#X#q#z$P$Y$i$j$q$v%Sp![Z]!T!m#S#U#X#q#z$P$Y$i$j$q$v%SQ!f^R#l!gT#^!Z#_Q|VR!yqQ!x|R#x!yQ!PWR!{rQ!RXR!|sQxUQ!wpQ#i!cQ#o!jQ#p!kQ${$eR%X$zSgPwQ!phQ#r!nR$l#sZfPhw!n#sa!b[`a!V!^!`#d#eR#b!^R!g^R!i_R#n!iS$e#m$fR%V$yV$c#m$f$yQ!rjR#v!rQdOShPwU!ldh#sR#s!nQ$P#SU$p$P$v%SQ$v$YR%S$qQ#_!ZR$W#_Q$r$PR%T$rQpUS!vp$nR$n#|Q$j#qR%P$jQ!ogS#t!o#uR#u!pQ#f!_R$^#fQ$f#mR$|$fQ$z$eR%W$z_cOPdhw!n#s^UOPdhw!n#sQ!uoQ!}tQ#OuQ#PvQ#|#RR$_#hR$Q#SQ!VZQ!d]Q#V!TQ#q!m[$O#S$P$Y$q$v%SQ$R#UQ$T#XS$h#q$jQ$m#zR%O$iR#}#RQiPR#QwQ!c[Q!kaR#Y!VU!_[a!VQ!j`Q#c!^Q#g!`Q$[#dR$]#e",
        nodeNames: "\u26a0 Unit VariableName Comment StyleSheet RuleSet UniversalSelector TagSelector TagName NestingSelector ClassSelector ClassName PseudoClassSelector : :: PseudoClassName PseudoClassName ) ( ArgList ValueName ParenthesizedValue ColorLiteral NumberLiteral StringLiteral BinaryExpression BinOp CallExpression Callee CallLiteral CallTag ParenthesizedContent ] [ LineNames LineName , PseudoClassName ArgList IdSelector # IdName AttributeSelector AttributeName MatchOp ChildSelector ChildOp DescendantSelector SiblingSelector SiblingOp } { Block Declaration PropertyName Important ; ImportStatement AtKeyword import KeywordQuery FeatureQuery FeatureName BinaryQuery LogicOp UnaryQuery UnaryQueryOp ParenthesizedQuery SelectorQuery selector MediaStatement media CharsetStatement charset NamespaceStatement namespace NamespaceName KeyframesStatement keyframes KeyframeName KeyframeList KeyframeSelector KeyframeRangeName SupportsStatement supports AtRule Styles",
        maxTerm: 117,
        nodeProps: [ [ "isolate", -2, 3, 24, "" ], [ "openedBy", 17, "(", 32, "[", 50, "{" ], [ "closedBy", 18, ")", 33, "]", 51, "}" ] ],
        propSources: [ textareaTokens ],
        skippedNodes: [ 0, 3, 87 ],
        repeatNodeCount: 11,
        tokenData: "J^~R!^OX$}X^%u^p$}pq%uqr)Xrs.Rst/utu6duv$}vw7^wx7oxy9^yz9oz{9t{|:_|}?Q}!O?c!O!P@Q!P!Q@i!Q![Ab![!]B]!]!^CX!^!_$}!_!`Cj!`!aC{!a!b$}!b!cDw!c!}$}!}#OFa#O#P$}#P#QFr#Q#R6d#R#T$}#T#UGT#U#c$}#c#dHf#d#o$}#o#pH{#p#q6d#q#rI^#r#sIo#s#y$}#y#z%u#z$f$}$f$g%u$g#BY$}#BY#BZ%u#BZ$IS$}$IS$I_%u$I_$I|$}$I|$JO%u$JO$JT$}$JT$JU%u$JU$KV$}$KV$KW%u$KW&FU$}&FU&FV%u&FV;'S$};'S;=`JW<%lO$}`%QSOy%^z;'S%^;'S;=`%o<%lO%^`%cSo`Oy%^z;'S%^;'S;=`%o<%lO%^`%rP;=`<%l%^~%zh#Z~OX%^X^'f^p%^pq'fqy%^z#y%^#y#z'f#z$f%^$f$g'f$g#BY%^#BY#BZ'f#BZ$IS%^$IS$I_'f$I_$I|%^$I|$JO'f$JO$JT%^$JT$JU'f$JU$KV%^$KV$KW'f$KW&FU%^&FU&FV'f&FV;'S%^;'S;=`%o<%lO%^~'mh#Z~o`OX%^X^'f^p%^pq'fqy%^z#y%^#y#z'f#z$f%^$f$g'f$g#BY%^#BY#BZ'f#BZ$IS%^$IS$I_'f$I_$I|%^$I|$JO'f$JO$JT%^$JT$JU'f$JU$KV%^$KV$KW'f$KW&FU%^&FU&FV'f&FV;'S%^;'S;=`%o<%lO%^l)[UOy%^z#]%^#]#^)n#^;'S%^;'S;=`%o<%lO%^l)sUo`Oy%^z#a%^#a#b*V#b;'S%^;'S;=`%o<%lO%^l*[Uo`Oy%^z#d%^#d#e*n#e;'S%^;'S;=`%o<%lO%^l*sUo`Oy%^z#c%^#c#d+V#d;'S%^;'S;=`%o<%lO%^l+[Uo`Oy%^z#f%^#f#g+n#g;'S%^;'S;=`%o<%lO%^l+sUo`Oy%^z#h%^#h#i,V#i;'S%^;'S;=`%o<%lO%^l,[Uo`Oy%^z#T%^#T#U,n#U;'S%^;'S;=`%o<%lO%^l,sUo`Oy%^z#b%^#b#c-V#c;'S%^;'S;=`%o<%lO%^l-[Uo`Oy%^z#h%^#h#i-n#i;'S%^;'S;=`%o<%lO%^l-uS!X[o`Oy%^z;'S%^;'S;=`%o<%lO%^~.UWOY.RZr.Rrs.ns#O.R#O#P.s#P;'S.R;'S;=`/o<%lO.R~.sOh~~.vRO;'S.R;'S;=`/P;=`O.R~/SXOY.RZr.Rrs.ns#O.R#O#P.s#P;'S.R;'S;=`/o;=`<%l.R<%lO.R~/rP;=`<%l.Rn/zYxQOy%^z!Q%^!Q![0j![!c%^!c!i0j!i#T%^#T#Z0j#Z;'S%^;'S;=`%o<%lO%^l0oYo`Oy%^z!Q%^!Q![1_![!c%^!c!i1_!i#T%^#T#Z1_#Z;'S%^;'S;=`%o<%lO%^l1dYo`Oy%^z!Q%^!Q![2S![!c%^!c!i2S!i#T%^#T#Z2S#Z;'S%^;'S;=`%o<%lO%^l2ZYf[o`Oy%^z!Q%^!Q![2y![!c%^!c!i2y!i#T%^#T#Z2y#Z;'S%^;'S;=`%o<%lO%^l3QYf[o`Oy%^z!Q%^!Q![3p![!c%^!c!i3p!i#T%^#T#Z3p#Z;'S%^;'S;=`%o<%lO%^l3uYo`Oy%^z!Q%^!Q![4e![!c%^!c!i4e!i#T%^#T#Z4e#Z;'S%^;'S;=`%o<%lO%^l4lYf[o`Oy%^z!Q%^!Q![5[![!c%^!c!i5[!i#T%^#T#Z5[#Z;'S%^;'S;=`%o<%lO%^l5aYo`Oy%^z!Q%^!Q![6P![!c%^!c!i6P!i#T%^#T#Z6P#Z;'S%^;'S;=`%o<%lO%^l6WSf[o`Oy%^z;'S%^;'S;=`%o<%lO%^d6gUOy%^z!_%^!_!`6y!`;'S%^;'S;=`%o<%lO%^d7QS|So`Oy%^z;'S%^;'S;=`%o<%lO%^b7cSXQOy%^z;'S%^;'S;=`%o<%lO%^~7rWOY7oZw7owx.nx#O7o#O#P8[#P;'S7o;'S;=`9W<%lO7o~8_RO;'S7o;'S;=`8h;=`O7o~8kXOY7oZw7owx.nx#O7o#O#P8[#P;'S7o;'S;=`9W;=`<%l7o<%lO7o~9ZP;=`<%l7on9cSb^Oy%^z;'S%^;'S;=`%o<%lO%^~9tOa~n9{UUQjWOy%^z!_%^!_!`6y!`;'S%^;'S;=`%o<%lO%^n:fWjW!RQOy%^z!O%^!O!P;O!P!Q%^!Q![>T![;'S%^;'S;=`%o<%lO%^l;TUo`Oy%^z!Q%^!Q![;g![;'S%^;'S;=`%o<%lO%^l;nYo`#e[Oy%^z!Q%^!Q![;g![!g%^!g!h<^!h#X%^#X#Y<^#Y;'S%^;'S;=`%o<%lO%^l<cYo`Oy%^z{%^{|=R|}%^}!O=R!O!Q%^!Q![=j![;'S%^;'S;=`%o<%lO%^l=WUo`Oy%^z!Q%^!Q![=j![;'S%^;'S;=`%o<%lO%^l=qUo`#e[Oy%^z!Q%^!Q![=j![;'S%^;'S;=`%o<%lO%^l>[[o`#e[Oy%^z!O%^!O!P;g!P!Q%^!Q![>T![!g%^!g!h<^!h#X%^#X#Y<^#Y;'S%^;'S;=`%o<%lO%^n?VSt^Oy%^z;'S%^;'S;=`%o<%lO%^l?hWjWOy%^z!O%^!O!P;O!P!Q%^!Q![>T![;'S%^;'S;=`%o<%lO%^n@VU#bQOy%^z!Q%^!Q![;g![;'S%^;'S;=`%o<%lO%^~@nTjWOy%^z{@}{;'S%^;'S;=`%o<%lO%^~AUSo`#[~Oy%^z;'S%^;'S;=`%o<%lO%^lAg[#e[Oy%^z!O%^!O!P;g!P!Q%^!Q![>T![!g%^!g!h<^!h#X%^#X#Y<^#Y;'S%^;'S;=`%o<%lO%^bBbU]QOy%^z![%^![!]Bt!];'S%^;'S;=`%o<%lO%^bB{S^Qo`Oy%^z;'S%^;'S;=`%o<%lO%^nC^S!Y^Oy%^z;'S%^;'S;=`%o<%lO%^dCoS|SOy%^z;'S%^;'S;=`%o<%lO%^bDQU!OQOy%^z!`%^!`!aDd!a;'S%^;'S;=`%o<%lO%^bDkS!OQo`Oy%^z;'S%^;'S;=`%o<%lO%^bDzWOy%^z!c%^!c!}Ed!}#T%^#T#oEd#o;'S%^;'S;=`%o<%lO%^bEk[![Qo`Oy%^z}%^}!OEd!O!Q%^!Q![Ed![!c%^!c!}Ed!}#T%^#T#oEd#o;'S%^;'S;=`%o<%lO%^nFfSq^Oy%^z;'S%^;'S;=`%o<%lO%^nFwSp^Oy%^z;'S%^;'S;=`%o<%lO%^bGWUOy%^z#b%^#b#cGj#c;'S%^;'S;=`%o<%lO%^bGoUo`Oy%^z#W%^#W#XHR#X;'S%^;'S;=`%o<%lO%^bHYS!bQo`Oy%^z;'S%^;'S;=`%o<%lO%^bHiUOy%^z#f%^#f#gHR#g;'S%^;'S;=`%o<%lO%^fIQS!TUOy%^z;'S%^;'S;=`%o<%lO%^nIcS!S^Oy%^z;'S%^;'S;=`%o<%lO%^fItU!RQOy%^z!_%^!_!`6y!`;'S%^;'S;=`%o<%lO%^`JZP;=`<%l$}",
        tokenizers: [ scriptTokens, styleTokens, htmlHighlighting, 1, 2, 3, 4, new LocalTokenGroup("m~RRYZ[z{a~~g~aO#^~~dP!P!Qg~lO#_~~", 28, 105) ],
        topRules: {
            StyleSheet: [ 0, 4 ],
            Styles: [ 1, 86 ]
        },
        specialized: [ {
            term: 100,
            get: value => spec_callee[value] || -1
        }, {
            term: 58,
            get: value => spec_AtKeyword[value] || -1
        }, {
            term: 101,
            get: value => spec_identifier$1[value] || -1
        } ],
        tokenPrec: 1200
    });
    let _properties = null;
    function properties() {
        if (!_properties && "object" == typeof document && document.body) {
            var prop, style = document.body["style"], names = [], seen = new Set();
            for (prop in style) "cssText" != prop && "cssFloat" != prop && "string" == typeof style[prop] && (/[A-Z]/.test(prop) && (prop = prop.replace(/[A-Z]/g, ch => "-" + ch.toLowerCase())), 
            seen.has(prop) || (names.push(prop), seen.add(prop)));
            _properties = names.sort().map(name => ({
                type: "property",
                label: name
            }));
        }
        return _properties || [];
    }
    const pseudoClasses = [ "active", "after", "any-link", "autofill", "backdrop", "before", "checked", "cue", "default", "defined", "disabled", "empty", "enabled", "file-selector-button", "first", "first-child", "first-letter", "first-line", "first-of-type", "focus", "focus-visible", "focus-within", "fullscreen", "has", "host", "host-context", "hover", "in-range", "indeterminate", "invalid", "is", "lang", "last-child", "last-of-type", "left", "link", "marker", "modal", "not", "nth-child", "nth-last-child", "nth-last-of-type", "nth-of-type", "only-child", "only-of-type", "optional", "out-of-range", "part", "placeholder", "placeholder-shown", "read-only", "read-write", "required", "right", "root", "scope", "selection", "slotted", "target", "target-text", "valid", "visited", "where" ].map(name => ({
        type: "class",
        label: name
    })), values = [ "above", "absolute", "activeborder", "additive", "activecaption", "after-white-space", "ahead", "alias", "all", "all-scroll", "alphabetic", "alternate", "always", "antialiased", "appworkspace", "asterisks", "attr", "auto", "auto-flow", "avoid", "avoid-column", "avoid-page", "avoid-region", "axis-pan", "background", "backwards", "baseline", "below", "bidi-override", "blink", "block", "block-axis", "bold", "bolder", "border", "border-box", "both", "bottom", "break", "break-all", "break-word", "bullets", "button", "button-bevel", "buttonface", "buttonhighlight", "buttonshadow", "buttontext", "calc", "capitalize", "caps-lock-indicator", "caption", "captiontext", "caret", "cell", "center", "checkbox", "circle", "cjk-decimal", "clear", "clip", "close-quote", "col-resize", "collapse", "color", "color-burn", "color-dodge", "column", "column-reverse", "compact", "condensed", "contain", "content", "contents", "content-box", "context-menu", "continuous", "copy", "counter", "counters", "cover", "crop", "cross", "crosshair", "currentcolor", "cursive", "cyclic", "darken", "dashed", "decimal", "decimal-leading-zero", "default", "default-button", "dense", "destination-atop", "destination-in", "destination-out", "destination-over", "difference", "disc", "discard", "disclosure-closed", "disclosure-open", "document", "dot-dash", "dot-dot-dash", "dotted", "double", "down", "e-resize", "ease", "ease-in", "ease-in-out", "ease-out", "element", "ellipse", "ellipsis", "embed", "end", "ethiopic-abegede-gez", "ethiopic-halehame-aa-er", "ethiopic-halehame-gez", "ew-resize", "exclusion", "expanded", "extends", "extra-condensed", "extra-expanded", "fantasy", "fast", "fill", "fill-box", "fixed", "flat", "flex", "flex-end", "flex-start", "footnotes", "forwards", "from", "geometricPrecision", "graytext", "grid", "groove", "hand", "hard-light", "help", "hidden", "hide", "higher", "highlight", "highlighttext", "horizontal", "hsl", "hsla", "hue", "icon", "ignore", "inactiveborder", "inactivecaption", "inactivecaptiontext", "infinite", "infobackground", "infotext", "inherit", "initial", "inline", "inline-axis", "inline-block", "inline-flex", "inline-grid", "inline-table", "inset", "inside", "intrinsic", "invert", "italic", "justify", "keep-all", "landscape", "large", "larger", "left", "level", "lighter", "lighten", "line-through", "linear", "linear-gradient", "lines", "list-item", "listbox", "listitem", "local", "logical", "loud", "lower", "lower-hexadecimal", "lower-latin", "lower-norwegian", "lowercase", "ltr", "luminosity", "manipulation", "match", "matrix", "matrix3d", "medium", "menu", "menutext", "message-box", "middle", "min-intrinsic", "mix", "monospace", "move", "multiple", "multiple_mask_images", "multiply", "n-resize", "narrower", "ne-resize", "nesw-resize", "no-close-quote", "no-drop", "no-open-quote", "no-repeat", "none", "normal", "not-allowed", "nowrap", "ns-resize", "numbers", "numeric", "nw-resize", "nwse-resize", "oblique", "opacity", "open-quote", "optimizeLegibility", "optimizeSpeed", "outset", "outside", "outside-shape", "overlay", "overline", "padding", "padding-box", "painted", "page", "paused", "perspective", "pinch-zoom", "plus-darker", "plus-lighter", "pointer", "polygon", "portrait", "pre", "pre-line", "pre-wrap", "preserve-3d", "progress", "push-button", "radial-gradient", "radio", "read-only", "read-write", "read-write-plaintext-only", "rectangle", "region", "relative", "repeat", "repeating-linear-gradient", "repeating-radial-gradient", "repeat-x", "repeat-y", "reset", "reverse", "rgb", "rgba", "ridge", "right", "rotate", "rotate3d", "rotateX", "rotateY", "rotateZ", "round", "row", "row-resize", "row-reverse", "rtl", "run-in", "running", "s-resize", "sans-serif", "saturation", "scale", "scale3d", "scaleX", "scaleY", "scaleZ", "screen", "scroll", "scrollbar", "scroll-position", "se-resize", "self-start", "self-end", "semi-condensed", "semi-expanded", "separate", "serif", "show", "single", "skew", "skewX", "skewY", "skip-white-space", "slide", "slider-horizontal", "slider-vertical", "sliderthumb-horizontal", "sliderthumb-vertical", "slow", "small", "small-caps", "small-caption", "smaller", "soft-light", "solid", "source-atop", "source-in", "source-out", "source-over", "space", "space-around", "space-between", "space-evenly", "spell-out", "square", "start", "static", "status-bar", "stretch", "stroke", "stroke-box", "sub", "subpixel-antialiased", "svg_masks", "super", "sw-resize", "symbolic", "symbols", "system-ui", "table", "table-caption", "table-cell", "table-column", "table-column-group", "table-footer-group", "table-header-group", "table-row", "table-row-group", "text", "text-bottom", "text-top", "textarea", "textfield", "thick", "thin", "threeddarkshadow", "threedface", "threedhighlight", "threedlightshadow", "threedshadow", "to", "top", "transform", "translate", "translate3d", "translateX", "translateY", "translateZ", "transparent", "ultra-condensed", "ultra-expanded", "underline", "unidirectional-pan", "unset", "up", "upper-latin", "uppercase", "url", "var", "vertical", "vertical-text", "view-box", "visible", "visibleFill", "visiblePainted", "visibleStroke", "visual", "w-resize", "wait", "wave", "wider", "window", "windowframe", "windowtext", "words", "wrap", "wrap-reverse", "x-large", "x-small", "xor", "xx-large", "xx-small" ].map(name => ({
        type: "keyword",
        label: name
    })).concat([ "aliceblue", "antiquewhite", "aqua", "aquamarine", "azure", "beige", "bisque", "black", "blanchedalmond", "blue", "blueviolet", "brown", "burlywood", "cadetblue", "chartreuse", "chocolate", "coral", "cornflowerblue", "cornsilk", "crimson", "cyan", "darkblue", "darkcyan", "darkgoldenrod", "darkgray", "darkgreen", "darkkhaki", "darkmagenta", "darkolivegreen", "darkorange", "darkorchid", "darkred", "darksalmon", "darkseagreen", "darkslateblue", "darkslategray", "darkturquoise", "darkviolet", "deeppink", "deepskyblue", "dimgray", "dodgerblue", "firebrick", "floralwhite", "forestgreen", "fuchsia", "gainsboro", "ghostwhite", "gold", "goldenrod", "gray", "grey", "green", "greenyellow", "honeydew", "hotpink", "indianred", "indigo", "ivory", "khaki", "lavender", "lavenderblush", "lawngreen", "lemonchiffon", "lightblue", "lightcoral", "lightcyan", "lightgoldenrodyellow", "lightgray", "lightgreen", "lightpink", "lightsalmon", "lightseagreen", "lightskyblue", "lightslategray", "lightsteelblue", "lightyellow", "lime", "limegreen", "linen", "magenta", "maroon", "mediumaquamarine", "mediumblue", "mediumorchid", "mediumpurple", "mediumseagreen", "mediumslateblue", "mediumspringgreen", "mediumturquoise", "mediumvioletred", "midnightblue", "mintcream", "mistyrose", "moccasin", "navajowhite", "navy", "oldlace", "olive", "olivedrab", "orange", "orangered", "orchid", "palegoldenrod", "palegreen", "paleturquoise", "palevioletred", "papayawhip", "peachpuff", "peru", "pink", "plum", "powderblue", "purple", "rebeccapurple", "red", "rosybrown", "royalblue", "saddlebrown", "salmon", "sandybrown", "seagreen", "seashell", "sienna", "silver", "skyblue", "slateblue", "slategray", "snow", "springgreen", "steelblue", "tan", "teal", "thistle", "tomato", "turquoise", "violet", "wheat", "white", "whitesmoke", "yellow", "yellowgreen" ].map(name => ({
        type: "constant",
        label: name
    }))), tags = [ "a", "abbr", "address", "article", "aside", "b", "bdi", "bdo", "blockquote", "body", "br", "button", "canvas", "caption", "cite", "code", "col", "colgroup", "dd", "del", "details", "dfn", "dialog", "div", "dl", "dt", "em", "figcaption", "figure", "footer", "form", "header", "hgroup", "h1", "h2", "h3", "h4", "h5", "h6", "hr", "html", "i", "iframe", "img", "input", "ins", "kbd", "label", "legend", "li", "main", "meter", "nav", "ol", "output", "p", "pre", "ruby", "section", "select", "small", "source", "span", "strong", "sub", "summary", "sup", "table", "tbody", "td", "template", "textarea", "tfoot", "th", "thead", "tr", "u", "ul" ].map(name => ({
        type: "type",
        label: name
    })), identifier$1 = /^(\w[\w-]*|-\w[\w-]*|)$/, variable = /^-(-[\w-]*)?$/;
    const VariablesByNode = new NodeWeakMap(), declSelector = [ "Declaration" ];
    const cssCompletionSource = (isVariable => context => {
        var {
            state,
            pos
        } = context, node = syntaxTree(state).resolveInner(pos, -1), isDash = node.type.isError && node.from == node.to - 1 && "-" == state.doc.sliceString(node.from, node.to);
        if ("PropertyName" == node.name || (isDash || "TagName" == node.name) && /^(Block|Styles)$/.test(node.resolve(node.to).name)) return {
            from: node.from,
            options: properties(),
            validFor: identifier$1
        };
        if ("ValueName" == node.name) return {
            from: node.from,
            options: values,
            validFor: identifier$1
        };
        if ("PseudoClassName" == node.name) return {
            from: node.from,
            options: pseudoClasses,
            validFor: identifier$1
        };
        if (isVariable(node) || (context.explicit || isDash) && function(node, doc) {
            return "ArgList" == (node = "(" != node.name && !node.type.isError ? node : node.parent || node).name && "Callee" == (null == (node = null == (node = node.parent) ? void 0 : node.firstChild) ? void 0 : node.name) ? "var" == doc.sliceString(node.from, node.to) : void 0;
        }(node, state.doc)) return {
            from: isVariable(node) || isDash ? node.from : pos,
            options: function variableNames(doc, node, isVariable) {
                if (4096 < node.to - node.from) {
                    var known = VariablesByNode.get(node);
                    if (known) return known;
                    var result = [], seen = new Set(), cursor = node.cursor(IterMode.IncludeAnonymous);
                    if (cursor.firstChild()) do {
                        for (var option of variableNames(doc, cursor.node, isVariable)) seen.has(option.label) || (seen.add(option.label), 
                        result.push(option));
                    } while (cursor.nextSibling());
                    return VariablesByNode.set(node, result), result;
                }
                {
                    let result = [], seen = new Set();
                    return node.cursor().iterate(node => {
                        var _a;
                        isVariable(node) && node.matchContext(declSelector) && ":" == (null == (_a = node.node.nextSibling) ? void 0 : _a.name) && (_a = doc.sliceString(node.from, node.to), 
                        seen.has(_a) || (seen.add(_a), result.push({
                            label: _a,
                            type: "variable"
                        })));
                    }), result;
                }
            }(state.doc, function(node) {
                for (let cur = node; ;) {
                    if (cur.type.isTop) return cur;
                    if (!(cur = cur.parent)) return node;
                }
            }(node), isVariable),
            validFor: variable
        };
        if ("TagName" != node.name) return context.explicit ? (state = (isDash = node.resolve(pos)).childBefore(pos)) && ":" == state.name && "PseudoClassSelector" == isDash.name ? {
            from: pos,
            options: pseudoClasses,
            validFor: identifier$1
        } : state && ":" == state.name && "Declaration" == isDash.name || "ArgList" == isDash.name ? {
            from: pos,
            options: values,
            validFor: identifier$1
        } : "Block" == isDash.name || "Styles" == isDash.name ? {
            from: pos,
            options: properties(),
            validFor: identifier$1
        } : null : null;
        for (let parent = node["parent"]; parent; parent = parent.parent) if ("Block" == parent.name) return {
            from: node.from,
            options: properties(),
            validFor: identifier$1
        };
        return {
            from: node.from,
            options: tags,
            validFor: identifier$1
        };
    })(n => "VariableName" == n.name), cssLanguage = LRLanguage.define({
        name: "css",
        parser: endTag.configure({
            props: [ indentNodeProp.add({
                Declaration: continuedIndent()
            }), foldNodeProp.add({
                "Block KeyframeList": foldInside
            }) ]
        }),
        languageData: {
            commentTokens: {
                block: {
                    open: "/*",
                    close: "*/"
                }
            },
            indentOnInput: /^\s*\}$/,
            wordChars: "-"
        }
    });
    function css() {
        return new LanguageSupport(cssLanguage, cssLanguage.data.of({
            autocomplete: cssCompletionSource
        }));
    }
    const space$1 = [ 9, 10, 11, 12, 13, 32, 133, 160, 5760, 8192, 8193, 8194, 8195, 8196, 8197, 8198, 8199, 8200, 8201, 8202, 8232, 8233, 8239, 8287, 12288 ];
    cursorDocStart = new ContextTracker({
        start: !1,
        shift(context, term) {
            return 5 == term || 6 == term || 315 == term ? context : 316 == term;
        },
        strict: !1
    }), punctuation = new ExternalTokenizer((input, stack) => {
        var next = input["next"];
        125 != next && -1 != next && !stack.context || input.acceptToken(313);
    }, {
        contextual: !0,
        fallback: !0
    }), textareaTokens = new ExternalTokenizer((input, stack) => {
        var after, next = input["next"];
        -1 < space$1.indexOf(next) || 47 == next && (47 == (after = input.peek(1)) || 42 == after) || 125 == next || 59 == next || -1 == next || stack.context || input.acceptToken(312);
    }, {
        contextual: !0
    }), scriptTokens = new ExternalTokenizer((input, stack) => {
        var next = input["next"];
        43 == next || 45 == next ? (input.advance(), next == input.next && (input.advance(), 
        stack = !stack.context && stack.canShift(1), input.acceptToken(stack ? 1 : 2))) : 63 == next && 46 == input.peek(1) && (input.advance(), 
        input.advance(), input.next < 48 || 57 < input.next) && input.acceptToken(3);
    }, {
        contextual: !0
    });
    function identifierChar(ch, start) {
        return 65 <= ch && ch <= 90 || 97 <= ch && ch <= 122 || 95 == ch || 192 <= ch || !start && 48 <= ch && ch <= 57;
    }
    styleTokens = new ExternalTokenizer((input, stack) => {
        if (60 == input.next && stack.dialectEnabled(0) && (input.advance(), 47 != input.next)) {
            let back = 0;
            for (;-1 < space$1.indexOf(input.next); ) input.advance(), back++;
            if (identifierChar(input.next, !0)) {
                for (input.advance(), back++; identifierChar(input.next, !1); ) input.advance(), 
                back++;
                for (;-1 < space$1.indexOf(input.next); ) input.advance(), back++;
                if (44 == input.next) return;
                for (let i = 0; ;i++) {
                    if (7 == i) {
                        if (identifierChar(input.next, !0)) break;
                        return;
                    }
                    if (input.next != "extends".charCodeAt(i)) break;
                    input.advance(), back++;
                }
            }
            input.acceptToken(4, -back);
        }
    }), htmlHighlighting = styleTags({
        "get set async static": tags$1.modifier,
        "for while do if else switch try catch finally return throw break continue default case": tags$1.controlKeyword,
        "in of await yield void typeof delete instanceof": tags$1.operatorKeyword,
        "let var const using function class extends": tags$1.definitionKeyword,
        "import export from": tags$1.moduleKeyword,
        "with debugger as new": tags$1.keyword,
        TemplateString: tags$1.special(tags$1.string),
        super: tags$1.atom,
        BooleanLiteral: tags$1.bool,
        this: tags$1.self,
        null: tags$1.null,
        Star: tags$1.modifier,
        VariableName: tags$1.variableName,
        "CallExpression/VariableName TaggedTemplateExpression/VariableName": tags$1.function(tags$1.variableName),
        VariableDefinition: tags$1.definition(tags$1.variableName),
        Label: tags$1.labelName,
        PropertyName: tags$1.propertyName,
        PrivatePropertyName: tags$1.special(tags$1.propertyName),
        "CallExpression/MemberExpression/PropertyName": tags$1.function(tags$1.propertyName),
        "FunctionDeclaration/VariableDefinition": tags$1.function(tags$1.definition(tags$1.variableName)),
        "ClassDeclaration/VariableDefinition": tags$1.definition(tags$1.className),
        PropertyDefinition: tags$1.definition(tags$1.propertyName),
        PrivatePropertyDefinition: tags$1.definition(tags$1.special(tags$1.propertyName)),
        UpdateOp: tags$1.updateOperator,
        "LineComment Hashbang": tags$1.lineComment,
        BlockComment: tags$1.blockComment,
        Number: tags$1.number,
        String: tags$1.string,
        Escape: tags$1.escape,
        ArithOp: tags$1.arithmeticOperator,
        LogicOp: tags$1.logicOperator,
        BitOp: tags$1.bitwiseOperator,
        CompareOp: tags$1.compareOperator,
        RegExp: tags$1.regexp,
        Equals: tags$1.definitionOperator,
        Arrow: tags$1.function(tags$1.punctuation),
        ": Spread": tags$1.punctuation,
        "( )": tags$1.paren,
        "[ ]": tags$1.squareBracket,
        "{ }": tags$1.brace,
        "InterpolationStart InterpolationEnd": tags$1.special(tags$1.brace),
        ".": tags$1.derefOperator,
        ", ;": tags$1.separator,
        "@": tags$1.meta,
        TypeName: tags$1.typeName,
        TypeDefinition: tags$1.definition(tags$1.typeName),
        "type enum interface implements namespace module declare": tags$1.definitionKeyword,
        "abstract global Privacy readonly override": tags$1.modifier,
        "is keyof unique infer": tags$1.operatorKeyword,
        JSXAttributeValue: tags$1.attributeValue,
        JSXText: tags$1.content,
        "JSXStartTag JSXStartCloseTag JSXSelfCloseEndTag JSXEndTag": tags$1.angleBracket,
        "JSXIdentifier JSXNameSpacedName": tags$1.tagName,
        "JSXAttribute/JSXIdentifier JSXAttribute/JSXNameSpacedName": tags$1.attributeName,
        "JSXBuiltin/JSXIdentifier": tags$1.standard(tags$1.tagName)
    });
    const spec_identifier = {
        __proto__: null,
        export: 20,
        as: 25,
        from: 33,
        default: 36,
        async: 41,
        function: 42,
        extends: 54,
        this: 58,
        true: 66,
        false: 66,
        null: 78,
        void: 82,
        typeof: 86,
        super: 102,
        new: 136,
        delete: 148,
        yield: 157,
        await: 161,
        class: 166,
        public: 229,
        private: 229,
        protected: 229,
        readonly: 231,
        instanceof: 250,
        satisfies: 253,
        in: 254,
        const: 256,
        import: 290,
        keyof: 345,
        unique: 349,
        infer: 355,
        is: 391,
        abstract: 411,
        implements: 413,
        type: 415,
        let: 418,
        var: 420,
        using: 423,
        interface: 429,
        enum: 433,
        namespace: 439,
        module: 441,
        declare: 445,
        global: 449,
        for: 468,
        of: 477,
        while: 480,
        with: 484,
        do: 488,
        if: 492,
        else: 494,
        switch: 498,
        case: 504,
        try: 510,
        catch: 514,
        finally: 518,
        return: 522,
        throw: 526,
        break: 530,
        continue: 534,
        debugger: 538
    }, spec_word = {
        __proto__: null,
        async: 123,
        get: 125,
        set: 127,
        declare: 189,
        public: 191,
        private: 191,
        protected: 191,
        static: 193,
        abstract: 195,
        override: 197,
        readonly: 203,
        accessor: 205,
        new: 395
    }, spec_LessThan = {
        __proto__: null,
        "<": 187
    };
    endTag = LRParser.deserialize({
        version: 14,
        states: "$=dO%TQ^OOO%[Q^OOO'_Q`OOP(lOWOOO*zQ?NdO'#CiO+RO!bO'#CjO+aO#tO'#CjO+oO!0LbO'#D^O.QQ^O'#DdO.bQ^O'#DoO%[Q^O'#DwO0fQ^O'#EPOOQ?Mr'#EX'#EXO1PQWO'#EUOOQO'#Em'#EmOOQO'#Ih'#IhO1XQWO'#GpO1dQWO'#ElO1iQWO'#ElO3hQ?NdO'#JmO6[Q?NdO'#JnO6uQWO'#F[O6zQ&jO'#FsOOQ?Mr'#Fe'#FeO7VO,YO'#FeO7eQ7[O'#FzO9RQWO'#FyOOQ?Mr'#Jn'#JnOOQ?Mp'#Jm'#JmO9WQWO'#GtOOQU'#KZ'#KZO9cQWO'#IUO9hQ?MxO'#IVOOQU'#JZ'#JZOOQU'#IZ'#IZQ`Q^OOO`Q^OOO9pQMnO'#DsO9wQ^O'#D{O:OQ^O'#D}O9^QWO'#GpO:VQ7[O'#CoO:eQWO'#EkO:pQWO'#EvO:uQ7[O'#FdO;dQWO'#GpOOQO'#K['#K[O;iQWO'#K[O;wQWO'#GxO;wQWO'#GyO;wQWO'#G{O9^QWO'#HOO<nQWO'#HRO>VQWO'#CeO>gQWO'#H_O>oQWO'#HeO>oQWO'#HgO`Q^O'#HiO>oQWO'#HkO>oQWO'#HnO>tQWO'#HtO>yQ?MyO'#HzO%[Q^O'#H|O?UQ?MyO'#IOO?aQ?MyO'#IQO9hQ?MxO'#ISO?lQ?NdO'#CiO@nQ`O'#DiQOQWOOO%[Q^O'#D}OAUQWO'#EQO:VQ7[O'#EkOAaQWO'#EkOAlQpO'#FdOOQU'#Cg'#CgOOQ?Mp'#Dn'#DnOOQ?Mp'#Jq'#JqO%[Q^O'#JqOOQO'#Jt'#JtOOQO'#Id'#IdOBlQ`O'#EdOOQ?Mp'#Ec'#EcOOQ?Mp'#Jx'#JxOChQ?NQO'#EdOCrQ`O'#ETOOQO'#Js'#JsODWQ`O'#JtOEeQ`O'#ETOCrQ`O'#EdPErO#@ItO'#CbPOOO)CDx)CDxOOOO'#I['#I[OE}O!bO,59UOOQ?Mr,59U,59UOOOO'#I]'#I]OF]O#tO,59UO%[Q^O'#D`OOOO'#I_'#I_OFkO!0LbO,59xOOQ?Mr,59x,59xOFyQ^O'#I`OG^QWO'#JoOI]QrO'#JoO+}Q^O'#JoOIdQWO,5:OOIzQWO'#EmOJXQWO'#KOOJdQWO'#J}OJdQWO'#J}OJlQWO,5;ZOJqQWO'#J|OOQ?Mv,5:Z,5:ZOJxQ^O,5:ZOLvQ?NdO,5:cOMgQWO,5:kONQQ?MxO'#J{ONXQWO'#JzO9WQWO'#JzONmQWO'#JzONuQWO,5;YONzQWO'#JzO!#PQrO'#JnOOQ?Mr'#Ci'#CiO%[Q^O'#EPO!#oQrO,5:pOOQQ'#Ju'#JuOOQO-E<f-E<fO9^QWO,5=[O!$VQWO,5=[O!$[Q^O,5;WO!&_Q7[O'#EhO!'xQWO,5;WO!'}Q^O'#DvO!(XQ`O,5;aO!(aQ`O,5;aO%[Q^O,5;aOOQU'#FS'#FSOOQU'#FU'#FUO%[Q^O,5;bO%[Q^O,5;bO%[Q^O,5;bO%[Q^O,5;bO%[Q^O,5;bO%[Q^O,5;bO%[Q^O,5;bO%[Q^O,5;bO%[Q^O,5;bO%[Q^O,5;bO%[Q^O,5;bOOQU'#FY'#FYO!(oQ^O,5;sOOQ?Mr,5;x,5;xOOQ?Mr,5;y,5;yOOQ?Mr,5;{,5;{O%[Q^O'#IlO!*rQ?MxO,5<gO!&_Q7[O,5;bO!+aQ7[O,5;bO!-RQ7[O'#EZO%[Q^O,5;vOOQ?Mr,5;z,5;zO!-YQ&jO'#FiO!.VQ&jO'#KSO!-qQ&jO'#KSO!.^Q&jO'#KSOOQO'#KS'#KSO!.rQ&jO,5<ROOOS,5<_,5<_O!/TQ^O'#FuOOOS'#Ik'#IkO7VO,YO,5<PO!/[Q&jO'#FwOOQ?Mr,5<P,5<PO!/{Q!LQO'#CvOOQ?Mr'#Cz'#CzO!0`QWO'#CzO!0eO!0LbO'#DOO!1RQ7[O,5<dO!1YQWO,5<fO!2uQ$ISO'#GVO!3SQWO'#GWO!3XQWO'#GWO!4wQ$ISO'#G[O!5sQ`O'#G`OOQO'#Gk'#GkO!+hQ7[O'#GjOOQO'#Gm'#GmO!+hQ7[O'#GlO!6fQ!LQO'#JgOOQ?Mr'#Jg'#JgO!6pQWO'#JfO!7OQWO'#JeO!7WQWO'#CuOOQ?Mr'#Cx'#CxOOQ?Mr'#DS'#DSOOQ?Mr'#DU'#DUO1SQWO'#DWO!+hQ7[O'#F}O!+hQ7[O'#GPO!7`QWO'#GRO!7eQWO'#GSO!3XQWO'#GYO!+hQ7[O'#G_O!7jQWO'#EnO!8XQWO,5<eOOQ?Mp'#Cr'#CrO!8aQWO'#EoO!9ZQ`O'#EpOOQ?Mp'#J|'#J|O!9bQ?MxO'#K]O9hQ?MxO,5=`O`Q^O,5>pOOQU'#Jc'#JcOOQU,5>q,5>qOOQU-E<X-E<XO!;aQ?NdO,5:_O!9UQ`O,5:]O!=zQ?NdO,5:gO%[Q^O,5:gO!@bQ?NdO,5:iOOQO,5@v,5@vO!ARQ7[O,5=[O!AaQ?MxO'#JdO9RQWO'#JdO!ArQ?MxO,59ZO!A}Q`O,59ZO!BVQ7[O,59ZO:VQ7[O,59ZO!BbQWO,5;WO!BjQWO'#H^O!COQWO'#K`O%[Q^O,5;|O!9UQ`O,5<OO!CWQWO,5=wO!C]QWO,5=wO!CbQWO,5=wO9hQ?MxO,5=wO;wQWO,5=gOOQO'#Cv'#CvO!CpQ`O,5=dO!CxQ7[O,5=eO!DTQWO,5=gO!DYQpO,5=jO!DbQWO'#K[O>tQWO'#HTO9^QWO'#HVO!DgQWO'#HVO:VQ7[O'#HXO!DlQWO'#HXOOQU,5=m,5=mO!DqQWO'#HYO!ESQWO'#CoO!EXQWO,59PO!EcQWO,59PO!GhQ^O,59POOQU,59P,59PO!GxQ?MxO,59PO%[Q^O,59PO!JTQ^O'#HaOOQU'#Hb'#HbOOQU'#Hc'#HcO`Q^O,5=yO!JkQWO,5=yO`Q^O,5>PO`Q^O,5>RO!JpQWO,5>TO`Q^O,5>VO!JuQWO,5>YO!JzQ^O,5>`OOQU,5>f,5>fO%[Q^O,5>fO9hQ?MxO,5>hOOQU,5>j,5>jO# UQWO,5>jOOQU,5>l,5>lO# UQWO,5>lOOQU,5>n,5>nO# rQ`O'#D[O%[Q^O'#JqO# |Q`O'#JqO#!kQ`O'#DjO#!|Q`O'#DjO#%_Q^O'#DjO#%fQWO'#JpO#%nQWO,5:TO#%sQWO'#EqO#&RQWO'#KPO#&ZQWO,5;[O#&`Q`O'#DjO#&mQ`O'#ESOOQ?Mr,5:l,5:lO%[Q^O,5:lO#&tQWO,5:lO>tQWO,5;VO!A}Q`O,5;VO!BVQ7[O,5;VO:VQ7[O,5;VO#&|QWO,5@]O#'RQ(CYO,5:pOOQO-E<b-E<bO#(XQ?NQO,5;OOCrQ`O,5:oO#(cQ`O,5:oOCrQ`O,5;OO!ArQ?MxO,5:oOOQ?Mp'#Eg'#EgOOQO,5;O,5;OO%[Q^O,5;OO#(pQ?MxO,5;OO#({Q?MxO,5;OO!A}Q`O,5:oOOQO,5;U,5;UO#)ZQ?MxO,5;OPOOO'#IY'#IYP#)oO#@ItO,58|POOO,58|,58|OOOO-E<Y-E<YOOQ?Mr1G.p1G.pOOOO-E<Z-E<ZO#)zQpO,59zOOOO-E<]-E<]OOQ?Mr1G/d1G/dO#*PQrO,5>zO+}Q^O,5>zOOQO,5?Q,5?QO#*ZQ^O'#I`OOQO-E<^-E<^O#*hQWO,5@ZO#*pQrO,5@ZO#*wQWO,5@iOOQ?Mr1G/j1G/jO%[Q^O,5@jO#+PQWO'#IfOOQO-E<d-E<dO#*wQWO,5@iOOQ?Mp1G0u1G0uOOQ?Mv1G/u1G/uOOQ?Mv1G0V1G0VO%[Q^O,5@gO#+eQ?MxO,5@gO#+vQ?MxO,5@gO#+}QWO,5@fO9WQWO,5@fO#,VQWO,5@fO#,eQWO'#IiO#+}QWO,5@fOOQ?Mp1G0t1G0tO!(XQ`O,5:rO!(dQ`O,5:rOOQQ,5:t,5:tO#-VQYO,5:tO#-_Q7[O1G2vO9^QWO1G2vOOQ?Mr1G0r1G0rO#-mQ?NdO1G0rO#.rQ?NbO,5;SOOQ?Mr'#GU'#GUO#/`Q?NdO'#JgO!$[Q^O1G0rO#1hQrO'#JrO%[Q^O'#JrO#1rQWO,5:bOOQ?Mr'#D['#D[OOQ?Mr1G0{1G0{O%[Q^O1G0{OOQ?Mr1G1e1G1eO#1wQWO1G0{O#4]Q?NdO1G0|O#4dQ?NdO1G0|O#6zQ?NdO1G0|O#7RQ?NdO1G0|O#9YQ?NdO1G0|O#9pQ?NdO1G0|O#<gQ?NdO1G0|O#<nQ?NdO1G0|O#?OQ?NdO1G0|O#?]Q?NdO1G0|O#AWQ?NdO1G0|O#DWQ07bO'#CiO#FRQ07bO1G1_O#FYQ07bO'#JnO#FmQ?NdO,5?WOOQ?Mp-E<j-E<jO#GaQ?NdO1G0|OOQ?Mr1G0|1G0|O#IiQ7[O'#JwO#IsQWO,5:uO#IxQ?NdO1G1bO#JlQ&jO,5<VO#JtQ&jO,5<WO#J|Q&jO'#FnO#KeQWO'#FmOOQO'#KT'#KTOOQO'#Ij'#IjO#KjQ&jO1G1mOOQ?Mr1G1m1G1mOOOS1G1x1G1xO#K{Q07bO'#JmO#LVQWO,5<aO!(oQ^O,5<aOOOS-E<i-E<iOOQ?Mr1G1k1G1kO#L[Q`O'#KSOOQ?Mr,5<c,5<cO#LdQ`O,5<cOOQ?Mr,59f,59fO!&_Q7[O'#DQOOOO'#I^'#I^O#LiO!0LbO,59jOOQ?Mr,59j,59jO%[Q^O1G2OO!7eQWO'#InO#LtQ7[O,5<xOOQ?Mr,5<u,5<uO!+hQ7[O'#IqO#MdQ7[O,5=UO!+hQ7[O'#IsO#NVQ7[O,5=WO!&_Q7[O,5=YOOQO1G2Q1G2QO#NaQpO'#CrO#NtQ$ISO'#EoO$ sQ`O'#G`O$!aQpO,5<qO$!hQWO'#KWO9WQWO'#KWO$!vQWO,5<sO!+hQ7[O,5<rO$!{QWO'#GXO$#^QWO,5<rO$#cQpO'#GUO$#pQpO'#KXO$#zQWO'#KXO!&_Q7[O'#KXO$$PQWO,5<vO$$UQ`O'#GaO!5nQ`O'#GaO$$gQWO'#GcO$$lQWO'#GeO!3XQWO'#GhO$$qQ?MxO'#IpO$$|Q`O,5<zOOQ?Mv,5<z,5<zO$%TQ`O'#GaO$%cQ`O'#GbO$%kQ`O'#GbO$%pQ7[O,5=UO$&QQ7[O,5=WOOQ?Mr,5=Z,5=ZO!+hQ7[O,5@QO!+hQ7[O,5@QO$&bQWO'#IuO$&mQWO,5@PO$&uQWO,59aO$'iQ!LSO,59rOOQ?Mr'#Jk'#JkO$([Q7[O,5<iO$(}Q7[O,5<kO@fQWO,5<mOOQ?Mr,5<n,5<nO$)XQWO,5<tO$)^Q7[O,5<yO$)nQWO'#JzO!$[Q^O1G2PO$)sQWO1G2PO9WQWO'#J}O9WQWO'#EqO%[Q^O'#EqO9WQWO'#IwO$)xQ?MxO,5@wOOQU1G2z1G2zOOQU1G4[1G4[OOQ?Mr1G/y1G/yOOQ?Mr1G/w1G/wO$+zQ?NdO1G0ROOQU1G2v1G2vO!&_Q7[O1G2vO%[Q^O1G2vO#-bQWO1G2vO$.OQ7[O'#EhOOQ?Mp,5@O,5@OO$.YQ?MxO,5@OOOQU1G.u1G.uO!ArQ?MxO1G.uO!A}Q`O1G.uO!BVQ7[O1G.uO$.kQWO1G0rO$.pQWO'#CiO$.{QWO'#KaO$/TQWO,5=xO$/YQWO'#KaO$/_QWO'#KaO$/mQWO'#I}O$/{QWO,5@zO$0TQrO1G1hOOQ?Mr1G1j1G1jO9^QWO1G3cO@fQWO1G3cO$0[QWO1G3cO$0aQWO1G3cOOQU1G3c1G3cO!DTQWO1G3RO!&_Q7[O1G3OO$0fQWO1G3OOOQU1G3P1G3PO!&_Q7[O1G3PO$0kQWO1G3PO$0sQ`O'#G}OOQU1G3R1G3RO!5nQ`O'#IyO!DYQpO1G3UOOQU1G3U1G3UOOQU,5=o,5=oO$0{Q7[O,5=qO9^QWO,5=qO$$lQWO,5=sO9RQWO,5=sO!A}Q`O,5=sO!BVQ7[O,5=sO:VQ7[O,5=sO$1ZQWO'#K_O$1fQWO,5=tOOQU1G.k1G.kO$1kQ?MxO1G.kO@fQWO1G.kO$1vQWO1G.kO9hQ?MxO1G.kO$4OQrO,5@|O$4]QWO,5@|O9WQWO,5@|O$4hQ^O,5={O$4oQWO,5={OOQU1G3e1G3eO`Q^O1G3eOOQU1G3k1G3kOOQU1G3m1G3mO>oQWO1G3oO$4tQ^O1G3qO$8xQ^O'#HpOOQU1G3t1G3tO$9VQWO'#HvO>tQWO'#HxOOQU1G3z1G3zO$9_Q^O1G3zO9hQ?MxO1G4QOOQU1G4S1G4SOOQ?Mp'#G]'#G]O9hQ?MxO1G4UO9hQ?MxO1G4WO$=fQWO,5@]O!(oQ^O,5;]O9WQWO,5;]O>tQWO,5:UO!(oQ^O,5:UO!A}Q`O,5:UO$=kQ07bO,5:UOOQO,5;],5;]O$=uQ`O'#IaO$>]QWO,5@[OOQ?Mr1G/o1G/oO$>eQ`O'#IgO$>oQWO,5@kOOQ?Mp1G0v1G0vO#!|Q`O,5:UOOQO'#Ic'#IcO$>wQ`O,5:nOOQ?Mv,5:n,5:nO#&wQWO1G0WOOQ?Mr1G0W1G0WO%[Q^O1G0WOOQ?Mr1G0q1G0qO>tQWO1G0qO!A}Q`O1G0qO!BVQ7[O1G0qOOQ?Mp1G5w1G5wO!ArQ?MxO1G0ZOOQO1G0j1G0jO%[Q^O1G0jO$?OQ?MxO1G0jO$?ZQ?MxO1G0jO!A}Q`O1G0ZOCrQ`O1G0ZO$?iQ?MxO1G0jOOQO1G0Z1G0ZO$?}Q?NdO1G0jPOOO-E<W-E<WPOOO1G.h1G.hOOOO1G/f1G/fO$@XQpO,5<gO$@aQrO1G4fOOQO1G4l1G4lO%[Q^O,5>zO$@kQWO1G5uO$@sQWO1G6TO$@{QrO1G6UO9WQWO,5?QO$AVQ?NdO1G6RO%[Q^O1G6RO$AgQ?MxO1G6RO$AxQWO1G6QO$AxQWO1G6QO9WQWO1G6QO$BQQWO,5?TO9WQWO,5?TOOQO,5?T,5?TO$BfQWO,5?TO$)nQWO,5?TOOQO-E<g-E<gOOQQ1G0^1G0^OOQQ1G0`1G0`O#-YQWO1G0`OOQU7+(b7+(bO!&_Q7[O7+(bO%[Q^O7+(bO$BtQWO7+(bO$CPQ7[O7+(bO$C_Q?NdO,5=UO$EgQ?NdO,5=WO$GoQ?NdO,5=UO$I}Q?NdO,5=WO$L]Q?NdO,59rO$NbQ?NdO,5<iO%!jQ?NdO,5<kO%$rQ?NdO,5<yOOQ?Mr7+&^7+&^O%'QQ?NdO7+&^O%'tQ^O'#IbO%(RQWO,5@^O%(ZQrO,5@^OOQ?Mr1G/|1G/|O%(eQWO7+&gOOQ?Mr7+&g7+&gO%(jQ07bO,5:cO%[Q^O7+&yO%(tQ07bO,5:_O%)RQ07bO,5:gO%)]Q07bO,5:iO%)gQ7[O'#IeO%)qQWO,5@cOOQ?Mr1G0a1G0aOOQO1G1q1G1qOOQO1G1r1G1rO%)yQtO,5<YO!(oQ^O,5<XOOQO-E<h-E<hOOQ?Mr7+'X7+'XOOOS7+'d7+'dOOOS1G1{1G1{O%*UQWO1G1{OOQ?Mr1G1}1G1}O%*ZQpO,59lOOOO-E<[-E<[OOQ?Mr1G/U1G/UO%*bQ?NdO7+'jOOQ?Mr,5?Y,5?YO%+UQpO,5?YOOQ?Mr1G2d1G2dP!&_Q7[O'#InPOQ?Mr-E<l-E<lO%+tQ7[O,5?]OOQ?Mr-E<o-E<oO%,gQ7[O,5?_OOQ?Mr-E<q-E<qO%,qQpO1G2tO%,xQpO'#CrO%-`Q7[O'#J}O%-gQ^O'#EqOOQ?Mr1G2]1G2]O%-qQWO'#ImO%.VQWO,5@rO%.VQWO,5@rO%._QWO,5@rO%.jQWO,5@rOOQO1G2_1G2_O%.xQ7[O1G2^O!+hQ7[O1G2^O%/YQ$ISO'#IoO%/gQWO,5@sO!&_Q7[O,5@sO%/oQpO,5@sOOQ?Mr1G2b1G2bOOQ?Mp,5<{,5<{OOQ?Mp,5<|,5<|O$)nQWO,5<|OCcQWO,5<|O!A}Q`O,5<{OOQO'#Gd'#GdO%/yQWO,5<}OOQ?Mp,5=P,5=PO$)nQWO,5=SOOQO,5?[,5?[OOQO-E<n-E<nOOQ?Mv1G2f1G2fO!5nQ`O,5<{O%0RQWO,5<|O$$gQWO,5<}O!5nQ`O,5<|O!+hQ7[O'#IqO%0uQ7[O1G2pO!+hQ7[O'#IsO%1hQ7[O1G2rO%1rQ7[O1G5lO%1|Q7[O1G5lOOQO,5?a,5?aOOQO-E<s-E<sOOQO1G.{1G.{O!9UQ`O,59tO%[Q^O,59tOOQ?Mr,5<h,5<hO%2ZQWO1G2XO!+hQ7[O1G2`O%2`Q?NdO7+'kOOQ?Mr7+'k7+'kO!$[Q^O7+'kO%3SQWO,5;]OOQ?Mp,5?c,5?cOOQ?Mp-E<u-E<uO%3XQpO'#KYO#&wQWO7+(bO4UQrO7+(bO$BwQWO7+(bO%3cQ?NbO'#CiO%3vQ?NbO,5=QO%4hQWO,5=QOOQ?Mp1G5j1G5jOOQU7+$a7+$aO!ArQ?MxO7+$aO!A}Q`O7+$aO!$[Q^O7+&^O%4mQWO'#I|O%5UQWO,5@{OOQO1G3d1G3dO9^QWO,5@{O%5UQWO,5@{O%5^QWO,5@{OOQO,5?i,5?iOOQO-E<{-E<{OOQ?Mr7+'S7+'SO%5cQWO7+(}O9hQ?MxO7+(}O9^QWO7+(}O@fQWO7+(}OOQU7+(m7+(mO%5hQ?NbO7+(jO!&_Q7[O7+(jO%5rQpO7+(kOOQU7+(k7+(kO!&_Q7[O7+(kO%5yQWO'#K^O%6UQWO,5=iOOQO,5?e,5?eOOQO-E<w-E<wOOQU7+(p7+(pO%7eQ`O'#HWOOQU1G3]1G3]O!&_Q7[O1G3]O%[Q^O1G3]O%7lQWO1G3]O%7wQ7[O1G3]O9hQ?MxO1G3_O$$lQWO1G3_O9RQWO1G3_O!A}Q`O1G3_O!BVQ7[O1G3_O%8VQWO'#I{O%8kQWO,5@yO%8sQ`O,5@yOOQ?Mp1G3`1G3`OOQU7+$V7+$VO@fQWO7+$VO9hQ?MxO7+$VO%9OQWO7+$VO%[Q^O1G6hO%[Q^O1G6iO%9TQ?MxO1G6hO%9_Q^O1G3gO%9fQWO1G3gO%9kQ^O1G3gOOQU7+)P7+)PO9hQ?MxO7+)ZO`Q^O7+)]OOQU'#Kd'#KdOOQU'#JO'#JOO%9rQ^O,5>[OOQU,5>[,5>[O%[Q^O'#HqO%:PQWO'#HsOOQU,5>b,5>bO9WQWO,5>bOOQU,5>d,5>dOOQU7+)f7+)fOOQU7+)l7+)lOOQU7+)p7+)pOOQU7+)r7+)rO%:UQ`O1G5wO%:jQ07bO1G0wO%:tQWO1G0wOOQO1G/p1G/pO%;PQ07bO1G/pO>tQWO1G/pO!(oQ^O'#DjOOQO,5>{,5>{OOQO-E<_-E<_OOQO,5?R,5?ROOQO-E<e-E<eO!A}Q`O1G/pOOQO-E<a-E<aOOQ?Mv1G0Y1G0YOOQ?Mr7+%r7+%rO#&wQWO7+%rOOQ?Mr7+&]7+&]O>tQWO7+&]O!A}Q`O7+&]OOQO7+%u7+%uO$?}Q?NdO7+&UOOQO7+&U7+&UO%[Q^O7+&UO%;ZQ?MxO7+&UO!ArQ?MxO7+%uO!A}Q`O7+%uO%;fQ?MxO7+&UO%;tQ?NdO7++mO%[Q^O7++mO%<UQWO7++lO%<UQWO7++lOOQO1G4o1G4oO9WQWO1G4oO%<^QWO1G4oOOQQ7+%z7+%zO#&wQWO<<K|O4UQrO<<K|O%<lQWO<<K|OOQU<<K|<<K|O!&_Q7[O<<K|O%[Q^O<<K|O%<tQWO<<K|O%=PQ?NdO,5?]O%?XQ?NdO,5?_O%AaQ?NdO1G2^O%CoQ?NdO1G2pO%EwQ?NdO1G2rO%HPQrO,5>|O%[Q^O,5>|OOQO-E<`-E<`O%HZQWO1G5xOOQ?Mr<<JR<<JRO%HcQ07bO1G0rO%JjQ07bO1G0|O%JqQ07bO1G0|O%LrQ07bO1G0|O%LyQ07bO1G0|O%NkQ07bO1G0|O& RQ07bO1G0|O&#cQ07bO1G0|O&#jQ07bO1G0|O&%eQ07bO1G0|O&%rQ07bO1G0|O&'mQ07bO1G0|O&(QQ?NdO<<JeO&)VQ07bO1G0|O&*xQ07bO'#JgO&,{Q07bO1G1bO&-YQ07bO1G0RO&-dQ7[O,5?POOQO-E<c-E<cO!(oQ^O'#FpOOQO'#KU'#KUOOQO1G1t1G1tO&-nQWO1G1sO&-sQ07bO,5?WOOOS7+'g7+'gOOOO1G/W1G/WOOQ?Mr1G4t1G4tO!+hQ7[O7+(`O&0TQrO'#CiO&0_QWO,5?XO9WQWO,5?XOOQO-E<k-E<kO&0mQWO1G6^O&0mQWO1G6^O&0uQWO1G6^O&1QQ7[O7+'xO&1bQpO,5?ZO&1lQWO,5?ZO!&_Q7[O,5?ZOOQO-E<m-E<mO&1qQpO1G6_O&1{QWO1G6_OOQ?Mp1G2h1G2hO$)nQWO1G2hOOQ?Mp1G2g1G2gO&2TQWO1G2iO!&_Q7[O1G2iOOQ?Mp1G2n1G2nO!A}Q`O1G2gOCcQWO1G2hO&2YQWO1G2iO&2bQWO1G2hO&3UQ7[O,5?]OOQ?Mr-E<p-E<pO&3wQ7[O,5?_OOQ?Mr-E<r-E<rO!+hQ7[O7++WOOQ?Mr1G/`1G/`O&4RQWO1G/`OOQ?Mr7+'s7+'sO&4WQ7[O7+'zO&4hQ?NdO<<KVOOQ?Mr<<KV<<KVO&5[QWO1G0wO!&_Q7[O'#IvO&5aQWO,5@tO&7cQrO<<K|O!&_Q7[O1G2lOOQU<<G{<<G{O!ArQ?MxO<<G{O&7jQ?NdO<<IxOOQ?Mr<<Ix<<IxOOQO,5?h,5?hO&8^QWO,5?hO&8cQWO,5?hOOQO-E<z-E<zO&8qQWO1G6gO&8qQWO1G6gO9^QWO1G6gO@fQWO<<LiOOQU<<Li<<LiO&8yQWO<<LiO9hQ?MxO<<LiOOQU<<LU<<LUO%5hQ?NbO<<LUOOQU<<LV<<LVO%5rQpO<<LVO&9OQ`O'#IxO&9ZQWO,5@xO!(oQ^O,5@xOOQU1G3T1G3TO%-gQ^O'#JqOOQO'#Iz'#IzO9hQ?MxO'#IzO&9cQ`O,5=rOOQU,5=r,5=rO&9jQ`O'#EdO&:OQWO7+(wO&:TQWO7+(wOOQU7+(w7+(wO!&_Q7[O7+(wO%[Q^O7+(wO&:]QWO7+(wOOQU7+(y7+(yO9hQ?MxO7+(yO$$lQWO7+(yO9RQWO7+(yO!A}Q`O7+(yO&:hQWO,5?gOOQO-E<y-E<yOOQO'#HZ'#HZO&:sQWO1G6eO9hQ?MxO<<GqOOQU<<Gq<<GqO@fQWO<<GqO&:{QWO7+,SO&;QQWO7+,TO%[Q^O7+,SO%[Q^O7+,TOOQU7+)R7+)RO&;VQWO7+)RO&;[Q^O7+)RO&;cQWO7+)ROOQU<<Lu<<LuOOQU<<Lw<<LwOOQU-E<|-E<|OOQU1G3v1G3vO&;hQWO,5>]OOQU,5>_,5>_O&;mQWO1G3|O9WQWO7+&cO!(oQ^O7+&cOOQO7+%[7+%[O&;rQ07bO1G6UO>tQWO7+%[OOQ?Mr<<I^<<I^OOQ?Mr<<Iw<<IwO>tQWO<<IwOOQO<<Ip<<IpO$?}Q?NdO<<IpO%[Q^O<<IpOOQO<<Ia<<IaO!ArQ?MxO<<IaO&;|Q?MxO<<IpO&<XQ?NdO<= XO&<iQWO<= WOOQO7+*Z7+*ZO9WQWO7+*ZOOQUANAhANAhO&<qQrOANAhO!&_Q7[OANAhO#&wQWOANAhO4UQrOANAhO&<xQWOANAhO%[Q^OANAhO&=QQ?NdO7+'xO&?`Q?NdO,5?]O&AhQ?NdO,5?_O&CpQ?NdO7+'zO&FOQrO1G4hO&FYQ07bO7+&^O&HZQ07bO,5=UO&J_Q07bO,5=WO&JoQ07bO,5=UO&KPQ07bO,5=WO&KaQ07bO,59rO&MdQ07bO,5<iO' dQ07bO,5<kO'#dQ07bO,5<yO'%VQ07bO7+'jO'%dQ07bO7+'kO'%qQWO,5<[OOQO7+'_7+'_O'%vQ7[O<<KzOOQO1G4s1G4sO'%}QWO1G4sO'&YQWO1G4sO'&hQWO7++xO'&hQWO7++xO!&_Q7[O1G4uO'&pQpO1G4uO'&zQWO7++yOOQ?Mp7+(S7+(SO$)nQWO7+(TO''SQpO7+(TOOQ?Mp7+(R7+(RO$)nQWO7+(SO''ZQWO7+(TO!&_Q7[O7+(TOCcQWO7+(SO''`Q7[O<<NrOOQ?Mr7+$z7+$zO''jQpO,5?bOOQO-E<t-E<tO''tQ?NbO7+(WOOQUAN=gAN=gO9^QWO1G5SOOQO1G5S1G5SO'(UQWO1G5SO'(ZQWO7+,RO'(ZQWO7+,RO9hQ?MxOANBTO@fQWOANBTOOQUANBTANBTOOQUANApANApOOQUANAqANAqO'(cQWO,5?dOOQO-E<v-E<vO'(nQ07bO1G6dOOQO,5?f,5?fOOQO-E<x-E<xOOQU1G3^1G3^O%-gQ^O,5<}OOQU<<Lc<<LcO!&_Q7[O<<LcO&:OQWO<<LcO'(xQWO<<LcO%[Q^O<<LcOOQU<<Le<<LeO9hQ?MxO<<LeO$$lQWO<<LeO9RQWO<<LeO')QQ`O1G5RO')]QWO7+,POOQUAN=]AN=]O9hQ?MxOAN=]OOQU<= n<= nOOQU<= o<= oO')eQWO<= nO')jQWO<= oOOQU<<Lm<<LmO')oQWO<<LmO')tQ^O<<LmOOQU1G3w1G3wO>tQWO7+)hO'){QWO<<I}O'*WQ07bO<<I}OOQO<<Hv<<HvOOQ?MrAN?cAN?cOOQOAN?[AN?[O$?}Q?NdOAN?[OOQOAN>{AN>{O%[Q^OAN?[OOQO<<Mu<<MuOOQUG27SG27SO!&_Q7[OG27SO#&wQWOG27SO'*bQrOG27SO4UQrOG27SO'*iQWOG27SO'*qQ07bO<<JeO'+OQ07bO1G2^O',qQ07bO,5?]O'.qQ07bO,5?_O'0qQ07bO1G2pO'2qQ07bO1G2rO'4qQ07bO<<KVO'5OQ07bO<<IxOOQO1G1v1G1vO!+hQ7[OANAfOOQO7+*_7+*_O'5]QWO7+*_O'5hQWO<= dO'5pQpO7+*aOOQ?Mp<<Ko<<KoO$)nQWO<<KoOOQ?Mp<<Kn<<KnO'5zQpO<<KoO$)nQWO<<KnOOQO7+*n7+*nO9^QWO7+*nO'6RQWO<= mOOQUG27oG27oO9hQ?MxOG27oO!(oQ^O1G5OO'6ZQWO7+,OO&:OQWOANA}OOQUANA}ANA}O!&_Q7[OANA}O'6cQWOANA}OOQUANBPANBPO9hQ?MxOANBPO$$lQWOANBPOOQO'#H['#H[OOQO7+*m7+*mOOQUG22wG22wOOQUANEYANEYOOQUANEZANEZOOQUANBXANBXO'6kQWOANBXOOQU<<MS<<MSO!(oQ^OAN?iOOQOG24vG24vO$?}Q?NdOG24vO#&wQWOLD,nOOQULD,nLD,nO!&_Q7[OLD,nO'6pQrOLD,nO'6wQ07bO7+'xO'8jQ07bO,5?]O':jQ07bO,5?_O'<jQ07bO7+'zO'>]Q7[OG27QOOQO<<My<<MyOOQ?MpANAZANAZO$)nQWOANAZOOQ?MpANAYANAYOOQO<<NY<<NYOOQULD-ZLD-ZO'>mQ07bO7+*jOOQUG27iG27iO&:OQWOG27iO!&_Q7[OG27iOOQUG27kG27kO9hQ?MxOG27kOOQUG27sG27sO'>wQ07bOG25TOOQOLD*bLD*bOOQU!$(!Y!$(!YO#&wQWO!$(!YO!&_Q7[O!$(!YO'?RQ?NdOG27QOOQ?MpG26uG26uOOQULD-TLD-TO&:OQWOLD-TOOQULD-VLD-VOOQU!)9Et!)9EtO#&wQWO!)9EtOOQU!$(!o!$(!oOOQU!.K;`!.K;`O'AaQ07bOG27QO!(oQ^O'#DwO1PQWO'#EUO'CSQrO'#JmO'CZQMnO'#DsO'CbQ^O'#D{O'CiQrO'#CiO'FPQrO'#CiO!(oQ^O'#D}O'FaQ^O,5;WO!(oQ^O,5;bO!(oQ^O,5;bO!(oQ^O,5;bO!(oQ^O,5;bO!(oQ^O,5;bO!(oQ^O,5;bO!(oQ^O,5;bO!(oQ^O,5;bO!(oQ^O,5;bO!(oQ^O,5;bO!(oQ^O,5;bO!(oQ^O'#IlO'HdQWO,5<gO'HlQ7[O,5;bO'JVQ7[O,5;bO!(oQ^O,5;vO!&_Q7[O'#GjO'HlQ7[O'#GjO!&_Q7[O'#GlO'HlQ7[O'#GlO1SQWO'#DWO1SQWO'#DWO!&_Q7[O'#F}O'HlQ7[O'#F}O!&_Q7[O'#GPO'HlQ7[O'#GPO!&_Q7[O'#G_O'HlQ7[O'#G_O!(oQ^O,5:gO'J^Q`O'#D[O!(oQ^O,5@jO'FaQ^O1G0rO'JhQ07bO'#CiO!(oQ^O1G2OO!&_Q7[O'#IqO'HlQ7[O'#IqO!&_Q7[O'#IsO'HlQ7[O'#IsO'JrQpO'#CrO!&_Q7[O,5<rO'HlQ7[O,5<rO'FaQ^O1G2PO!(oQ^O7+&yO!&_Q7[O1G2^O'HlQ7[O1G2^O!&_Q7[O'#IqO'HlQ7[O'#IqO!&_Q7[O'#IsO'HlQ7[O'#IsO!&_Q7[O1G2`O'HlQ7[O1G2`O'FaQ^O7+'kO'FaQ^O7+&^O!&_Q7[OANAfO'HlQ7[OANAfO'KVQWO'#ElO'K[QWO'#ElO'KdQWO'#F[O'KiQWO'#EvO'KnQWO'#KOO'KyQWO'#J|O'LUQWO,5;WO'LZQ7[O,5<dO'LbQWO'#GWO'LgQWO'#GWO'LlQWO,5<eO'LtQWO,5;WO'L|Q07bO1G1_O'MTQWO,5<rO'MYQWO,5<rO'M_QWO,5<tO'MdQWO,5<tO'MiQWO1G2PO'MnQWO1G0rO'MsQ7[O<<KzO'MzQ7[O<<KzO7eQ7[O'#FzO9RQWO'#FyOAaQWO'#EkO!(oQ^O,5;sO!3XQWO'#GWO!3XQWO'#GWO!3XQWO'#GYO!3XQWO'#GYO!+hQ7[O7+(`O!+hQ7[O7+(`O%,qQpO1G2tO%,qQpO1G2tO!&_Q7[O,5=YO!&_Q7[O,5=Y",
        stateData: "( O~O'wOS'xOSTOS'yRQ~OPYOQYOSfOY!VOaqOdzOeyOmkOoYOpkOqkOwkOyYO{YO!PWO!TkO!UkO![XO!fuO!iZO!lYO!mYO!nYO!pvO!rwO!uxO!y]O#t!PO$V|O%e}O%g!QO%i!OO%j!OO%k!OO%n!RO%p!SO%s!TO%t!TO%v!UO&S!WO&Y!XO&[!YO&^!ZO&`![O&c!]O&i!^O&o!_O&q!`O&s!aO&u!bO&w!cO(OSO(QTO(TUO([VO(j[O(yiO~OWtO~P`OPYOQYOSfOd!jOe!iOmkOoYOpkOqkOwkOyYO{YO!PWO!TkO!UkO![!eO!fuO!iZO!lYO!mYO!nYO!pvO!r!gO!u!hO$V!kO(O!dO(QTO(TUO([VO(j[O(yiO~Oa!wOp!nO!P!oO!_!yO!`!vO!a!vO!y:lO#Q!pO#R!pO#S!xO#T!pO#U!pO#X!zO#Y!zO(P!lO(QTO(TUO(`!mO(j!sO~O'y!{O~OP]XR]X[]Xa]Xo]X}]X!P]X!Y]X!i]X!m]X#O]X#P]X#]]X#hfX#k]X#l]X#m]X#n]X#o]X#p]X#q]X#r]X#s]X#u]X#w]X#y]X#z]X$P]X'u]X([]X(m]X(t]X(u]X~O!d%PX~P(qO_!}O(Q#PO(R!}O(S#PO~O_#QO(S#PO(T#PO(U#QO~Ou#SO!R#TO(]#TO(^#VO~OPYOQYOSfOd!jOe!iOmkOoYOpkOqkOwkOyYO{YO!PWO!TkO!UkO![!eO!fuO!iZO!lYO!mYO!nYO!pvO!r!gO!u!hO$V!kO(O:pO(QTO(TUO([VO(j[O(yiO~O!X#ZO!Y#WO!V(cP!V(qP~P+}O!Z#cO~P`OPYOQYOSfOd!jOe!iOoYOpkOqkOwkOyYO{YO!PWO!TkO!UkO![!eO!fuO!iZO!lYO!mYO!nYO!pvO!r!gO!u!hO$V!kO(QTO(TUO([VO(j[O(yiO~Om#mO!X#iO!y]O#f#lO#g#iO(O:qO!h(nP~P.iO!i#oO(O#nO~O!u#sO!y]O%e#tO~O#h#uO~O!d#vO#h#uO~OP$]OR#zO[$cOo$QO}#yO!P#{O!Y$`O!i#xO!m$]O#O$SO#k$OO#l$PO#m$PO#n$PO#o$RO#p$SO#q$SO#r$bO#s$SO#u$TO#w$VO#y$XO#z$YO([VO(m$ZO(t#|O(u#}O~Oa(aX'u(aX's(aX!h(aX!V(aX![(aX%f(aX!d(aX~P1qO#P$dO#]$eO$P$eOP(bXR(bX[(bXo(bX}(bX!P(bX!Y(bX!i(bX!m(bX#O(bX#k(bX#l(bX#m(bX#n(bX#o(bX#p(bX#q(bX#r(bX#s(bX#u(bX#w(bX#y(bX#z(bX([(bX(m(bX(t(bX(u(bX![(bX%f(bX~Oa(bX'u(bX's(bX!V(bX!h(bXs(bX!d(bX~P4UO#]$eO~O$[$hO$^$gO$e$mO~OSfO![$nO$h$oO$j$qO~Oh%WOm%XOo$uOp$tOq$tOw%YOy%ZO{%[O!P$|O![$}O!f%aO!i$yO#g%bO$V%_O$r%]O$t%^O$w%`O(O$sO(QTO(TUO([$vO(t%OO(u%QOg(XP~O!i%cO~O!P%fO![%gO(O%eO~O!d%kO~Oa%lO'u%lO~O}%pO~P%[O(P!lO~P%[O%k%tO~P%[Oh%WO!i%cO(O%eO(P!lO~Oe%{O!i%cO(O%eO~O#s$SO~O}&QO![%}O!i&PO%g&TO(O%eO(P!lO(QTO(TUO`)SP~O!u#sO~O%p&VO!P)OX![)OX(O)OX~O(O&WO~O!r&]O#t!PO%g!QO%i!OO%j!OO%k!OO%n!RO%p!SO%s!TO%t!TO~Od&bOe&aO!u&_O%e&`O%x&^O~P;|Od&eOeyO![&dO!r&]O!uxO!y]O#t!PO%e}O%i!OO%j!OO%k!OO%n!RO%p!SO%s!TO%t!TO%v!UO~Ob&hO#]&kO%g&fO(P!lO~P=RO!i&lO!r&pO~O!i#oO~O![XO~Oa%lO't&xO'u%lO~Oa%lO't&{O'u%lO~Oa%lO't&}O'u%lO~O's]X!V]Xs]X!h]X&W]X![]X%f]X!d]X~P(qO!_'[O!`'TO!a'TO(P!lO(QTO(TUO~Op'RO!P'QO!X'UO(`'PO!Z(dP!Z(sP~P@YOk'_O![']O(O%eO~Oe'dO!i%cO(O%eO~O}&QO!i&PO~Op!nO!P!oO!y:lO#Q!pO#R!pO#T!pO#U!pO(P!lO(QTO(TUO(`!mO(j!sO~O!_'jO!`'iO!a'iO#S!pO#X'kO#Y'kO~PAtOa%lOh%WO!d#vO!i%cO'u%lO(m'mO~O!m'qO#]'oO~PCSOp!nO!P!oO(QTO(TUO(`!mO(j!sO~O![XOp(hX!P(hX!_(hX!`(hX!a(hX!y(hX#Q(hX#R(hX#S(hX#T(hX#U(hX#X(hX#Y(hX(P(hX(Q(hX(T(hX(`(hX(j(hX~O!`'iO!a'iO(P!lO~PCrO'z'uO'{'uO'|'wO~O_!}O(Q'yO(R!}O(S'yO~O_#QO(S'yO(T'yO(U#QO~Ou#SO!R#TO(]#TO(^'}O~O!X(PO!V'SX!V'YX!Y'SX!Y'YX~P+}O!Y(RO!V(cX~OP$]OR#zO[$cOo$QO}#yO!P#{O!Y(RO!i#xO!m$]O#O$SO#k$OO#l$PO#m$PO#n$PO#o$RO#p$SO#q$SO#r$bO#s$SO#u$TO#w$VO#y$XO#z$YO([VO(m$ZO(t#|O(u#}O~O!V(cX~PGfO!V(WO~O!V(pX!Y(pX!d(pX!h(pX(m(pX~O#](pX#h#aX!Z(pX~PIiO#](XO!V(rX!Y(rX~O!Y(YO!V(qX~O!V(]O~O#]$eO~PIiO!Z(^O~P`OR#zO}#yO!P#{O!i#xO([VOP!ka[!kao!ka!Y!ka!m!ka#O!ka#k!ka#l!ka#m!ka#n!ka#o!ka#p!ka#q!ka#r!ka#s!ka#u!ka#w!ka#y!ka#z!ka(m!ka(t!ka(u!ka~Oa!ka'u!ka's!ka!V!ka!h!kas!ka![!ka%f!ka!d!ka~PKPO!h(_O~O!d#vO#](`O(m'mO!Y(oXa(oX'u(oX~O!h(oX~PMlO!P%fO![%gO!y]O#f(eO#g(dO(O%eO~O!Y(fO!h(nX~O!h(hO~O!P%fO![%gO#g(dO(O%eO~OP(bXR(bX[(bXo(bX}(bX!P(bX!Y(bX!i(bX!m(bX#O(bX#k(bX#l(bX#m(bX#n(bX#o(bX#p(bX#q(bX#r(bX#s(bX#u(bX#w(bX#y(bX#z(bX([(bX(m(bX(t(bX(u(bX~O!d#vO!h(bX~P! YOR(jO}(iO!i#xO#P$dO!y!xa!P!xa~O!u!xa%e!xa![!xa#f!xa#g!xa(O!xa~P!#ZO!u(nO~OPYOQYOSfOd!jOe!iOmkOoYOpkOqkOwkOyYO{YO!PWO!TkO!UkO![XO!fuO!iZO!lYO!mYO!nYO!pvO!r!gO!u!hO$V!kO(O!dO(QTO(TUO([VO(j[O(yiO~Oh%WOm%XOo$uOp$tOq$tOw%YOy%ZO{;YO!P$|O![$}O!f<jO!i$yO#g;`O$V%_O$r;[O$t;^O$w%`O(O(rO(QTO(TUO([$vO(t%OO(u%QO~O#h(tO~O!X(vO!h(fP~P%[O(`(xO(j[O~O!P(zO!i#xO(`(xO(j[O~OP:kOQ:kOSfOd<fOe!iOmkOo:kOpkOqkOwkOy:kO{:kO!PWO!TkO!UkO![!eO!f:nO!iZO!l:kO!m:kO!n:kO!p:oO!r:rO!u!hO$V!kO(O)YO(QTO(TUO([VO(j[O(y<dO~O!Y$`Oa$oa'u$oa's$oa!h$oa!V$oa![$oa%f$oa!d$oa~O#t)`O~P!&_Oh%WOm%XOo$uOp$tOq$tOw%YOy%ZO{%[O!P$|O![$}O!f%aO!i$yO#g%bO$V%_O$r%]O$t%^O$w%`O(O(rO(QTO(TUO([$vO(t%OO(u%QO~Og(kP~P!+hO})eO!d)dO![$]X$Y$]X$[$]X$^$]X$e$]X~O!d)dO![(vX$Y(vX$[(vX$^(vX$e(vX~O})eO~P!-qO})eO![(vX$Y(vX$[(vX$^(vX$e(vX~O![)gO$Y)kO$[)fO$^)fO$e)lO~O!X)oO~P!(oO$[$hO$^$gO$e)sO~Ok$xX}$xX!P$xX#P$xX(t$xX(u$xX~OgjXg$xXkjX!YjX#]jX~P!/gOp)uO~Ou)vO(])wO(^)yO~Ok*SO}){O!P)|O(t%OO(u%QO~Og)zO~P!0pOg*TO~Oh%WOm%XOo$uOp$tOq$tOw%YOy%ZO{;YO!P*VO![*WO!f<jO!i$yO#g;`O$V%_O$r;[O$t;^O$w%`O(QTO(TUO([$vO(t%OO(u%QO~O!X*ZO(O*UO!h(zP~P!1_O#h*]O~O!i*^O~Oh%WOm%XOo$uOp$tOq$tOw%YOy%ZO{;YO!P$|O![$}O!f<jO!i$yO#g;`O$V%_O$r;[O$t;^O$w%`O(O*`O(QTO(TUO([$vO(t%OO(u%QO~O!X*cO!V({P~P!3^Oo*oO!P*gO!_*mO!`*fO!a*fO!i*^O#X*nO%]*iO(P!lO(`!mO~O!Z*lO~P!5RO#P$dOk(ZX}(ZX!P(ZX(t(ZX(u(ZX!Y(ZX#](ZX~Og(ZX#}(ZX~P!5zOk*tO#]*sOg(YX!Y(YX~O!Y*uOg(XX~O(O&WOg(XP~O!i*|O~O(O(rO~Om+QO!P%fO!X#iO![%gO!y]O#f#lO#g#iO(O%eO!h(nP~O!d#vO#h+RO~O!P%fO!X+TO!Y(YO![%gO(O%eO!V(qP~Op'XO!P+VO!X+UO(QTO(TUO(`(xO~O!Z(sP~P!8uO!Y+WOa)PX'u)PX~OP$]OR#zO[$cOo$QO}#yO!P#{O!i#xO!m$]O#O$SO#k$OO#l$PO#m$PO#n$PO#o$RO#p$SO#q$SO#r$bO#s$SO#u$TO#w$VO#y$XO#z$YO([VO(m$ZO(t#|O(u#}O~Oa!ga!Y!ga'u!ga's!ga!V!ga!h!gas!ga![!ga%f!ga!d!ga~P!9mOR#zO}#yO!P#{O!i#xO([VOP!oa[!oao!oa!Y!oa!m!oa#O!oa#k!oa#l!oa#m!oa#n!oa#o!oa#p!oa#q!oa#r!oa#s!oa#u!oa#w!oa#y!oa#z!oa(m!oa(t!oa(u!oa~Oa!oa'u!oa's!oa!V!oa!h!oas!oa![!oa%f!oa!d!oa~P!<TOR#zO}#yO!P#{O!i#xO([VOP!qa[!qao!qa!Y!qa!m!qa#O!qa#k!qa#l!qa#m!qa#n!qa#o!qa#p!qa#q!qa#r!qa#s!qa#u!qa#w!qa#y!qa#z!qa(m!qa(t!qa(u!qa~Oa!qa'u!qa's!qa!V!qa!h!qas!qa![!qa%f!qa!d!qa~P!>kOh%WOk+aO![']O%f+`O~O!d+cOa(WX![(WX'u(WX!Y(WX~Oa%lO![XO'u%lO~Oh%WO!i%cO~Oh%WO!i%cO(O%eO~O!d#vO#h(tO~Ob+nO%g+oO(O+kO(QTO(TUO!Z)TP~O!Y+pO`)SX~O[+tO~O`+uO~O![%}O(O%eO(P!lO`)SP~Oh%WO#]+zO~Oh%WOk+}O![$}O~O![,PO~O},RO![XO~O%k%tO~O!u,WO~Oe,]O~Ob,^O(O#nO(QTO(TUO!Z)RP~Oe%{O~O%g!QO(O&WO~P=RO[,cO`,bO~OPYOQYOSfOdzOeyOmkOoYOpkOqkOwkOyYO{YO!PWO!TkO!UkO!fuO!iZO!lYO!mYO!nYO!pvO!uxO!y]O%e}O(QTO(TUO([VO(j[O(yiO~O![!eO!r!gO$V!kO(O!dO~P!EkO`,bOa%lO'u%lO~OPYOQYOSfOd!jOe!iOmkOoYOpkOqkOwkOyYO{YO!PWO!TkO!UkO![!eO!fuO!iZO!lYO!mYO!nYO!pvO!u!hO$V!kO(O!dO(QTO(TUO([VO(j[O(yiO~Oa,hO!rwO#t!OO%i!OO%j!OO%k!OO~P!HTO!i&lO~O&Y,nO~O![,pO~O&k,rO&m,sOP&haQ&haS&haY&haa&had&hae&ham&hao&hap&haq&haw&hay&ha{&ha!P&ha!T&ha!U&ha![&ha!f&ha!i&ha!l&ha!m&ha!n&ha!p&ha!r&ha!u&ha!y&ha#t&ha$V&ha%e&ha%g&ha%i&ha%j&ha%k&ha%n&ha%p&ha%s&ha%t&ha%v&ha&S&ha&Y&ha&[&ha&^&ha&`&ha&c&ha&i&ha&o&ha&q&ha&s&ha&u&ha&w&ha's&ha(O&ha(Q&ha(T&ha([&ha(j&ha(y&ha!Z&ha&a&hab&ha&f&ha~O(O,xO~Oh!bX!Y!OX!Z!OX!d!OX!d!bX!i!bX#]!OX~O!Y!bX!Z!bX~P# ZO!d,}O#],|Oh(eX!Y#eX!Y(eX!Z#eX!Z(eX!d(eX!i(eX~Oh%WO!d-PO!i%cO!Y!^X!Z!^X~Op!nO!P!oO(QTO(TUO(`!mO~OP:kOQ:kOSfOd<fOe!iOmkOo:kOpkOqkOwkOy:kO{:kO!PWO!TkO!UkO![!eO!f:nO!iZO!l:kO!m:kO!n:kO!p:oO!r:rO!u!hO$V!kO(QTO(TUO([VO(j[O(y<dO~O(O;fO~P##_O!Y-TO!Z(dX~O!Z-VO~O!d,}O#],|O!Y#eX!Z#eX~O!Y-WO!Z(sX~O!Z-YO~O!`-ZO!a-ZO(P!lO~P#!|O!Z-^O~P'_Ok-aO![']O~O!V-fO~Op!xa!_!xa!`!xa!a!xa#Q!xa#R!xa#S!xa#T!xa#U!xa#X!xa#Y!xa(P!xa(Q!xa(T!xa(`!xa(j!xa~P!#ZO!m-kO#]-iO~PCSO!`-mO!a-mO(P!lO~PCrOa%lO#]-iO'u%lO~Oa%lO!d#vO#]-iO'u%lO~Oa%lO!d#vO!m-kO#]-iO'u%lO(m'mO~O'z'uO'{'uO'|-rO~Os-sO~O!V'Sa!Y'Sa~P!9mO!X-wO!V'SX!Y'SX~P%[O!Y(RO!V(ca~O!V(ca~PGfO!Y(YO!V(qa~O!P%fO!X-{O![%gO(O%eO!V'YX!Y'YX~O#]-}O!Y(oa!h(oaa(oa'u(oa~O!d#vO~P#+eO!Y(fO!h(na~O!P%fO![%gO#g.RO(O%eO~Om.WO!P%fO!X.TO![%gO!y]O#f.VO#g.TO(O%eO!Y']X!h']X~OR.[O!i#xO~Oh%WOk._O![']O%f.^O~Oa#`i!Y#`i'u#`i's#`i!V#`i!h#`is#`i![#`i%f#`i!d#`i~P!9mOk<pO}){O!P)|O(t%OO(u%QO~O#h#[aa#[a#]#[a'u#[a!Y#[a!h#[a![#[a!V#[a~P#.aO#h(ZXP(ZXR(ZX[(ZXa(ZXo(ZX!i(ZX!m(ZX#O(ZX#k(ZX#l(ZX#m(ZX#n(ZX#o(ZX#p(ZX#q(ZX#r(ZX#s(ZX#u(ZX#w(ZX#y(ZX#z(ZX'u(ZX([(ZX(m(ZX!h(ZX!V(ZX's(ZXs(ZX![(ZX%f(ZX!d(ZX~P!5zO!Y.lO!h(fX~P!9mO!h.oO~O!V.qO~OP$]OR#zO}#yO!P#{O!i#xO!m$]O([VO[#jia#jio#ji!Y#ji#O#ji#l#ji#m#ji#n#ji#o#ji#p#ji#q#ji#r#ji#s#ji#u#ji#w#ji#y#ji#z#ji'u#ji(m#ji(t#ji(u#ji's#ji!V#ji!h#jis#ji![#ji%f#ji!d#ji~O#k#ji~P#1|O#k$OO~P#1|OP$]OR#zO}#yO!P#{O!i#xO!m$]O#k$OO#l$PO#m$PO#n$PO([VO[#jia#ji!Y#ji#O#ji#o#ji#p#ji#q#ji#r#ji#s#ji#u#ji#w#ji#y#ji#z#ji'u#ji(m#ji(t#ji(u#ji's#ji!V#ji!h#jis#ji![#ji%f#ji!d#ji~Oo#ji~P#4kOo$QO~P#4kOP$]OR#zOo$QO}#yO!P#{O!i#xO!m$]O#k$OO#l$PO#m$PO#n$PO#o$RO([VOa#ji!Y#ji#u#ji#w#ji#y#ji#z#ji'u#ji(m#ji(t#ji(u#ji's#ji!V#ji!h#jis#ji![#ji%f#ji!d#ji~O[#ji#O#ji#p#ji#q#ji#r#ji#s#ji~P#7YO[$cO#O$SO#p$SO#q$SO#r$bO#s$SO~P#7YOP$]OR#zO[$cOo$QO}#yO!P#{O!i#xO!m$]O#O$SO#k$OO#l$PO#m$PO#n$PO#o$RO#p$SO#q$SO#r$bO#s$SO#u$TO([VO(u#}Oa#ji!Y#ji#y#ji#z#ji'u#ji(m#ji(t#ji's#ji!V#ji!h#jis#ji![#ji%f#ji!d#ji~O#w$VO~P#:WO#w#ji~P#:WOP$]OR#zO[$cOo$QO}#yO!P#{O!i#xO!m$]O#O$SO#k$OO#l$PO#m$PO#n$PO#o$RO#p$SO#q$SO#r$bO#s$SO#u$TO([VOa#ji!Y#ji#y#ji#z#ji'u#ji(m#ji's#ji!V#ji!h#jis#ji![#ji%f#ji!d#ji~O#w#ji(t#ji(u#ji~P#<uO#w$VO(t#|O(u#}O~P#<uOP$]OR#zO[$cOo$QO}#yO!P#{O!i#xO!m$]O#O$SO#k$OO#l$PO#m$PO#n$PO#o$RO#p$SO#q$SO#r$bO#s$SO#u$TO#w$VO#y$XO([VO(t#|O(u#}O~Oa#ji!Y#ji#z#ji'u#ji(m#ji's#ji!V#ji!h#jis#ji![#ji%f#ji!d#ji~P#?jOP]XR]X[]Xo]X}]X!P]X!i]X!m]X#O]X#P]X#]]X#hfX#k]X#l]X#m]X#n]X#o]X#p]X#q]X#r]X#s]X#u]X#w]X#y]X#z]X$P]X([]X(m]X(t]X(u]X!Y]X!Z]X~O#}]X~P#BQOP$]OR#zO[;SOo:vO}#yO!P#{O!i#xO!m$]O#O:xO#k:tO#l:uO#m:uO#n:uO#o:wO#p:xO#q:xO#r;RO#s:xO#u:yO#w:{O#y:}O#z;OO([VO(m$ZO(t#|O(u#}O~O#}.sO~P#D_O#P$dO#];TO$P;TO#}(bX!Z(bX~P! YOa'`a!Y'`a'u'`a's'`a!h'`a!V'`as'`a!['`a%f'`a!d'`a~P!9mOP#jiR#ji[#jia#jio#ji!Y#ji!i#ji!m#ji#O#ji#k#ji#l#ji#m#ji#n#ji#o#ji#p#ji#q#ji#r#ji#s#ji#u#ji#w#ji#y#ji#z#ji'u#ji([#ji(m#ji's#ji!V#ji!h#jis#ji![#ji%f#ji!d#ji~P#.aO!Y.wOg(kX~P!0pOg.yO~Oa$Oi!Y$Oi'u$Oi's$Oi!V$Oi!h$Ois$Oi![$Oi%f$Oi!d$Oi~P!9mO$[.zO$^.zO~O$[.{O$^.{O~O!d)dO#].|O![$bX$Y$bX$[$bX$^$bX$e$bX~O!X.}O~O![)gO$Y/PO$[)fO$^)fO$e/QO~O!Y;PO!Z(aX~P#D_O!Z/RO~O!d)dO$e(vX~O$e/TO~Ou)vO(])wO(^/WO~O!V/[O~P!&_O(t%OOk%^a}%^a!P%^a(u%^a!Y%^a#]%^a~Og%^a#}%^a~P#L{O(u%QOk%`a}%`a!P%`a(t%`a!Y%`a#]%`a~Og%`a#}%`a~P#MnO!YfX!dfX!hfX!h$xX(mfX~P!/gO!X/eO!Y(YO(O/dO!V(qP!V({P~P!1_Oo*oO!_*mO!`*fO!a*fO!i*^O#X*nO%]*iO(P!lO~Op'XO!P/fO!X+UO!Z*lO(QTO(TUO(`;cO!Z(sP~P$ XO!h/gO~P#.aO!Y/hO!d#vO(m'mO!h(zX~O!h/mO~O!P%fO!X*ZO![%gO(O%eO!h(zP~O#h/oO~O!V$xX!Y$xX!d%PX~P!/gO!Y/pO!V({X~P#.aO!d/rO~O!V/tO~Oh%WOo/xO!d#vO!i%cO(m'mO~O(O/zO~O!d+cO~Oa%lO!Y0OO'u%lO~O!Z0QO~P!5RO!`0RO!a0RO(P!lO(`!mO~O!P0TO(`!mO~O#X0UO~Og%^a!Y%^a#]%^a#}%^a~P!0pOg%`a!Y%`a#]%`a#}%`a~P!0pO(O&WOg'iX!Y'iX~O!Y*uOg(Xa~Og0_O~OR0`O}0`O!P0aO#P$dOkza(tza(uza!Yza#]za~Ogza#}za~P$&zO}){O!P)|Ok$qa(t$qa(u$qa!Y$qa#]$qa~Og$qa#}$qa~P$'sO}){O!P)|Ok$sa(t$sa(u$sa!Y$sa#]$sa~Og$sa#}$sa~P$(fO#h0dO~Og%Ra!Y%Ra#]%Ra#}%Ra~P!0pO!d#vO~O#h0gO~O!Y+WOa)Pa'u)Pa~OR#zO}#yO!P#{O!i#xO([VOP!oi[!oio!oi!Y!oi!m!oi#O!oi#k!oi#l!oi#m!oi#n!oi#o!oi#p!oi#q!oi#r!oi#s!oi#u!oi#w!oi#y!oi#z!oi(m!oi(t!oi(u!oi~Oa!oi'u!oi's!oi!V!oi!h!ois!oi![!oi%f!oi!d!oi~P$*TOh%WOo$uOp$tOq$tOw%YOy%ZO{;YO!P$|O![$}O!f<jO!i$yO#g;`O$V%_O$r;[O$t;^O$w%`O(QTO(TUO([$vO(t%OO(u%QO~Om0pO(O0oO~P$,kO!d+cOa(Wa![(Wa'u(Wa!Y(Wa~O#h0vO~O[]X!YfX!ZfX~O!Y0wO!Z)TX~O!Z0yO~O[0zO~Ob0|O(O+kO(QTO(TUO~O![%}O(O%eO`'qX!Y'qX~O!Y+pO`)Sa~O!h1PO~P!9mO[1SO~O`1TO~O#]1WO~Ok1ZO![$}O~O(`(xO!Z)QP~Oh%WOk1dO![1aO%f1cO~O[1nO!Y1lO!Z)RX~O!Z1oO~O`1qOa%lO'u%lO~O(O#nO(QTO(TUO~O#P$dO#]$eO$P$eOP(bXR(bX[(bXo(bX}(bX!P(bX!Y(bX!i(bX!m(bX#O(bX#k(bX#l(bX#m(bX#n(bX#o(bX#p(bX#q(bX#r(bX#u(bX#w(bX#y(bX#z(bX([(bX(m(bX(t(bX(u(bX~O#s1tO&W1uOa(bX~P$2RO#]$eO#s1tO&W1uO~Oa1wO~P%[Oa1yO~O&a1|OP&_iQ&_iS&_iY&_ia&_id&_ie&_im&_io&_ip&_iq&_iw&_iy&_i{&_i!P&_i!T&_i!U&_i![&_i!f&_i!i&_i!l&_i!m&_i!n&_i!p&_i!r&_i!u&_i!y&_i#t&_i$V&_i%e&_i%g&_i%i&_i%j&_i%k&_i%n&_i%p&_i%s&_i%t&_i%v&_i&S&_i&Y&_i&[&_i&^&_i&`&_i&c&_i&i&_i&o&_i&q&_i&s&_i&u&_i&w&_i's&_i(O&_i(Q&_i(T&_i([&_i(j&_i(y&_i!Z&_ib&_i&f&_i~Ob2SO!Z2QO&f2RO~P`O![XO!i2UO~O&m,sOP&hiQ&hiS&hiY&hia&hid&hie&him&hio&hip&hiq&hiw&hiy&hi{&hi!P&hi!T&hi!U&hi![&hi!f&hi!i&hi!l&hi!m&hi!n&hi!p&hi!r&hi!u&hi!y&hi#t&hi$V&hi%e&hi%g&hi%i&hi%j&hi%k&hi%n&hi%p&hi%s&hi%t&hi%v&hi&S&hi&Y&hi&[&hi&^&hi&`&hi&c&hi&i&hi&o&hi&q&hi&s&hi&u&hi&w&hi's&hi(O&hi(Q&hi(T&hi([&hi(j&hi(y&hi!Z&hi&a&hib&hi&f&hi~O!V2[O~O!Y!^a!Z!^a~P#D_Op!nO!P!oO!X2bO(`!mO!Y'TX!Z'TX~P@YO!Y-TO!Z(da~O!Y'ZX!Z'ZX~P!8uO!Y-WO!Z(sa~O!Z2iO~P'_Oa%lO#]2rO'u%lO~Oa%lO!d#vO#]2rO'u%lO~Oa%lO!d#vO!m2vO#]2rO'u%lO(m'mO~Oa%lO'u%lO~P!9mO!Y$`Os$oa~O!V'Si!Y'Si~P!9mO!Y(RO!V(ci~O!Y(YO!V(qi~O!V(ri!Y(ri~P!9mO!Y(oi!h(oia(oi'u(oi~P!9mO#]2xO!Y(oi!h(oia(oi'u(oi~O!Y(fO!h(ni~O!P%fO![%gO!y]O#f2}O#g2|O(O%eO~O!P%fO![%gO#g2|O(O%eO~Ok3UO![']O%f3TO~Oh%WOk3UO![']O%f3TO~O#h%^aP%^aR%^a[%^aa%^ao%^a!i%^a!m%^a#O%^a#k%^a#l%^a#m%^a#n%^a#o%^a#p%^a#q%^a#r%^a#s%^a#u%^a#w%^a#y%^a#z%^a'u%^a([%^a(m%^a!h%^a!V%^a's%^as%^a![%^a%f%^a!d%^a~P#L{O#h%`aP%`aR%`a[%`aa%`ao%`a!i%`a!m%`a#O%`a#k%`a#l%`a#m%`a#n%`a#o%`a#p%`a#q%`a#r%`a#s%`a#u%`a#w%`a#y%`a#z%`a'u%`a([%`a(m%`a!h%`a!V%`a's%`as%`a![%`a%f%`a!d%`a~P#MnO#h%^aP%^aR%^a[%^aa%^ao%^a!Y%^a!i%^a!m%^a#O%^a#k%^a#l%^a#m%^a#n%^a#o%^a#p%^a#q%^a#r%^a#s%^a#u%^a#w%^a#y%^a#z%^a'u%^a([%^a(m%^a!h%^a!V%^a's%^a#]%^as%^a![%^a%f%^a!d%^a~P#.aO#h%`aP%`aR%`a[%`aa%`ao%`a!Y%`a!i%`a!m%`a#O%`a#k%`a#l%`a#m%`a#n%`a#o%`a#p%`a#q%`a#r%`a#s%`a#u%`a#w%`a#y%`a#z%`a'u%`a([%`a(m%`a!h%`a!V%`a's%`a#]%`as%`a![%`a%f%`a!d%`a~P#.aO#hzaPza[zaazaoza!iza!mza#Oza#kza#lza#mza#nza#oza#pza#qza#rza#sza#uza#wza#yza#zza'uza([za(mza!hza!Vza'szasza![za%fza!dza~P$&zO#h$qaP$qaR$qa[$qaa$qao$qa!i$qa!m$qa#O$qa#k$qa#l$qa#m$qa#n$qa#o$qa#p$qa#q$qa#r$qa#s$qa#u$qa#w$qa#y$qa#z$qa'u$qa([$qa(m$qa!h$qa!V$qa's$qas$qa![$qa%f$qa!d$qa~P$'sO#h$saP$saR$sa[$saa$sao$sa!i$sa!m$sa#O$sa#k$sa#l$sa#m$sa#n$sa#o$sa#p$sa#q$sa#r$sa#s$sa#u$sa#w$sa#y$sa#z$sa'u$sa([$sa(m$sa!h$sa!V$sa's$sas$sa![$sa%f$sa!d$sa~P$(fO#h%RaP%RaR%Ra[%Raa%Rao%Ra!Y%Ra!i%Ra!m%Ra#O%Ra#k%Ra#l%Ra#m%Ra#n%Ra#o%Ra#p%Ra#q%Ra#r%Ra#s%Ra#u%Ra#w%Ra#y%Ra#z%Ra'u%Ra([%Ra(m%Ra!h%Ra!V%Ra's%Ra#]%Ras%Ra![%Ra%f%Ra!d%Ra~P#.aOa#`q!Y#`q'u#`q's#`q!V#`q!h#`qs#`q![#`q%f#`q!d#`q~P!9mO!X3^O!Y'UX!h'UX~P%[O!Y.lO!h(fa~O!Y.lO!h(fa~P!9mO!V3aO~O#}!ka!Z!ka~PKPO#}!ga!Y!ga!Z!ga~P#D_O#}!oa!Z!oa~P!<TO#}!qa!Z!qa~P!>kOg'XX!Y'XX~P!+hO!Y.wOg(ka~OSfO![3uO$c3vO~O!Z3zO~Os3{O~P#.aOa$lq!Y$lq'u$lq's$lq!V$lq!h$lqs$lq![$lq%f$lq!d$lq~P!9mO!V3|O~P#.aO}){O!P)|O(u%QOk'ea(t'ea!Y'ea#]'ea~Og'ea#}'ea~P%+]O}){O!P)|Ok'ga(t'ga(u'ga!Y'ga#]'ga~Og'ga#}'ga~P%,OO(m$ZO~P#.aO!VfX!V$xX!YfX!Y$xX!d%PX#]fX~P!/gO(O;lO~P!1_OmkO(O4OO~P.iO!P%fO!X4QO![%gO(O%eO!Y'aX!h'aX~O!Y/hO!h(za~O!Y/hO!d#vO!h(za~O!Y/hO!d#vO(m'mO!h(za~Og$zi!Y$zi#]$zi#}$zi~P!0pO!X4YO!V'cX!Y'cX~P!3^O!Y/pO!V({a~O!Y/pO!V({a~P#.aO!d#vO#s4bO~Oo4eO!d#vO(m'mO~O(t%OOk%^i}%^i!P%^i(u%^i!Y%^i#]%^i~Og%^i#}%^i~P%0^O(u%QOk%`i}%`i!P%`i(t%`i!Y%`i#]%`i~Og%`i#}%`i~P%1POg(Yi!Y(Yi~P!0pO#]4lOg(Yi!Y(Yi~P!0pO!h4oO~Oa$mq!Y$mq'u$mq's$mq!V$mq!h$mqs$mq![$mq%f$mq!d$mq~P!9mO!V4sO~O!Y4tO![(|X~P#.aOa$xX![$xX%Z]X'u$xX!Y$xX~P!/gO%Z4wOalXklX}lX!PlX![lX'ulX(tlX(ulX!YlX~O%Z4wO~Ob4}O%g5OO(O+kO(QTO(TUO!Y'pX!Z'pX~O!Y0wO!Z)Ta~O[5SO~O`5TO~Oa%lO'u%lO~P#.aO![$}O~P#.aO!Y5]O#]5_O!Z)QX~O!Z5`O~Op!nO!P5aO!_!yO!`!vO!a!vO!y:lO#Q!pO#R!pO#S!pO#T!pO#U!pO#X5fO#Y!zO(P!lO(QTO(TUO(`!mO(j!sO~O!Z5eO~P%6ZOk5kO![1aO%f5jO~Oh%WOk5kO![1aO%f5jO~Ob5rO(O#nO(QTO(TUO!Y'oX!Z'oX~O!Y1lO!Z)Ra~O(QTO(TUO(`5tO~O`5xO~O#s5{O&W5|O~PMlO!h5}O~P%[Oa6PO~Oa6PO~P%[Ob2SO!Z6UO&f2RO~P`O!d6WO~O!d6YOh(ei!Y(ei!Z(ei!d(ei!i(ei~O!Y#ei!Z#ei~P#D_O#]6ZO!Y#ei!Z#ei~O!Y!^i!Z!^i~P#D_Oa%lO#]6dO'u%lO~Oa%lO!d#vO#]6dO'u%lO~O!Y(oq!h(oqa(oq'u(oq~P!9mO!Y(fO!h(nq~O!P%fO![%gO#g6kO(O%eO~O![']O%f6nO~Ok6rO![']O%f6nO~O#h'eaP'eaR'ea['eaa'eao'ea!i'ea!m'ea#O'ea#k'ea#l'ea#m'ea#n'ea#o'ea#p'ea#q'ea#r'ea#s'ea#u'ea#w'ea#y'ea#z'ea'u'ea(['ea(m'ea!h'ea!V'ea's'eas'ea!['ea%f'ea!d'ea~P%+]O#h'gaP'gaR'ga['gaa'gao'ga!i'ga!m'ga#O'ga#k'ga#l'ga#m'ga#n'ga#o'ga#p'ga#q'ga#r'ga#s'ga#u'ga#w'ga#y'ga#z'ga'u'ga(['ga(m'ga!h'ga!V'ga's'gas'ga!['ga%f'ga!d'ga~P%,OO#h$ziP$ziR$zi[$zia$zio$zi!Y$zi!i$zi!m$zi#O$zi#k$zi#l$zi#m$zi#n$zi#o$zi#p$zi#q$zi#r$zi#s$zi#u$zi#w$zi#y$zi#z$zi'u$zi([$zi(m$zi!h$zi!V$zi's$zi#]$zis$zi![$zi%f$zi!d$zi~P#.aO#h%^iP%^iR%^i[%^ia%^io%^i!i%^i!m%^i#O%^i#k%^i#l%^i#m%^i#n%^i#o%^i#p%^i#q%^i#r%^i#s%^i#u%^i#w%^i#y%^i#z%^i'u%^i([%^i(m%^i!h%^i!V%^i's%^is%^i![%^i%f%^i!d%^i~P%0^O#h%`iP%`iR%`i[%`ia%`io%`i!i%`i!m%`i#O%`i#k%`i#l%`i#m%`i#n%`i#o%`i#p%`i#q%`i#r%`i#s%`i#u%`i#w%`i#y%`i#z%`i'u%`i([%`i(m%`i!h%`i!V%`i's%`is%`i![%`i%f%`i!d%`i~P%1PO!Y'Ua!h'Ua~P!9mO!Y.lO!h(fi~O#}#`i!Y#`i!Z#`i~P#D_OP$]OR#zO}#yO!P#{O!i#xO!m$]O([VO[#jio#ji#O#ji#l#ji#m#ji#n#ji#o#ji#p#ji#q#ji#r#ji#s#ji#u#ji#w#ji#y#ji#z#ji#}#ji(m#ji(t#ji(u#ji!Y#ji!Z#ji~O#k#ji~P%HpO#k:tO~P%HpOP$]OR#zO}#yO!P#{O!i#xO!m$]O#k:tO#l:uO#m:uO#n:uO([VO[#ji#O#ji#o#ji#p#ji#q#ji#r#ji#s#ji#u#ji#w#ji#y#ji#z#ji#}#ji(m#ji(t#ji(u#ji!Y#ji!Z#ji~Oo#ji~P%JxOo:vO~P%JxOP$]OR#zOo:vO}#yO!P#{O!i#xO!m$]O#k:tO#l:uO#m:uO#n:uO#o:wO([VO#u#ji#w#ji#y#ji#z#ji#}#ji(m#ji(t#ji(u#ji!Y#ji!Z#ji~O[#ji#O#ji#p#ji#q#ji#r#ji#s#ji~P%MQO[;SO#O:xO#p:xO#q:xO#r;RO#s:xO~P%MQOP$]OR#zO[;SOo:vO}#yO!P#{O!i#xO!m$]O#O:xO#k:tO#l:uO#m:uO#n:uO#o:wO#p:xO#q:xO#r;RO#s:xO#u:yO([VO(u#}O#y#ji#z#ji#}#ji(m#ji(t#ji!Y#ji!Z#ji~O#w:{O~P& iO#w#ji~P& iOP$]OR#zO[;SOo:vO}#yO!P#{O!i#xO!m$]O#O:xO#k:tO#l:uO#m:uO#n:uO#o:wO#p:xO#q:xO#r;RO#s:xO#u:yO([VO#y#ji#z#ji#}#ji(m#ji!Y#ji!Z#ji~O#w#ji(t#ji(u#ji~P&#qO#w:{O(t#|O(u#}O~P&#qOP$]OR#zO[;SOo:vO}#yO!P#{O!i#xO!m$]O#O:xO#k:tO#l:uO#m:uO#n:uO#o:wO#p:xO#q:xO#r;RO#s:xO#u:yO#w:{O#y:}O([VO(t#|O(u#}O~O#z#ji#}#ji(m#ji!Y#ji!Z#ji~P&&POa#{y!Y#{y'u#{y's#{y!V#{y!h#{ys#{y![#{y%f#{y!d#{y~P!9mOk<qO}){O!P)|O(t%OO(u%QO~OP#jiR#ji[#jio#ji!i#ji!m#ji#O#ji#k#ji#l#ji#m#ji#n#ji#o#ji#p#ji#q#ji#r#ji#s#ji#u#ji#w#ji#y#ji#z#ji#}#ji([#ji(m#ji!Y#ji!Z#ji~P&(tO#P$dOP(ZXR(ZX[(ZXk(ZXo(ZX}(ZX!P(ZX!i(ZX!m(ZX#O(ZX#k(ZX#l(ZX#m(ZX#n(ZX#o(ZX#p(ZX#q(ZX#r(ZX#s(ZX#u(ZX#w(ZX#y(ZX#z(ZX#}(ZX([(ZX(m(ZX(t(ZX(u(ZX!Y(ZX!Z(ZX~O#}$Oi!Y$Oi!Z$Oi~P#D_O#}!oi!Z!oi~P$*TOg'Xa!Y'Xa~P!0pO!Z7UO~O!Y'`a!Z'`a~P#D_OP]XR]X[]Xo]X}]X!P]X!V]X!Y]X!i]X!m]X#O]X#P]X#]]X#hfX#k]X#l]X#m]X#n]X#o]X#p]X#q]X#r]X#s]X#u]X#w]X#y]X#z]X$P]X([]X(m]X(t]X(u]X~O!d%WX#s%WX~P&-}O!d#vO(m'mO!Y'aa!h'aa~O!Y/hO!h(zi~O!Y/hO!d#vO!h(zi~Og$zq!Y$zq#]$zq#}$zq~P!0pO!V'ca!Y'ca~P#.aO!d7]O~O!Y/pO!V({i~P#.aO!Y/pO!V({i~O!V7aO~O!d#vO#s7fO~Oo7gO!d#vO(m'mO~O}){O!P)|O(u%QOk'fa(t'fa!Y'fa#]'fa~Og'fa#}'fa~P&2mO}){O!P)|Ok'ha(t'ha(u'ha!Y'ha#]'ha~Og'ha#}'ha~P&3`O!V7iO~Og$|q!Y$|q#]$|q#}$|q~P!0pOa$my!Y$my'u$my's$my!V$my!h$mys$my![$my%f$my!d$my~P!9mO!d6YO~O!Y4tO![(|a~O![']OP$SaR$Sa[$Sao$Sa}$Sa!P$Sa!Y$Sa!i$Sa!m$Sa#O$Sa#k$Sa#l$Sa#m$Sa#n$Sa#o$Sa#p$Sa#q$Sa#r$Sa#s$Sa#u$Sa#w$Sa#y$Sa#z$Sa([$Sa(m$Sa(t$Sa(u$Sa~O%f6nO~P&5iOa#`y!Y#`y'u#`y's#`y!V#`y!h#`ys#`y![#`y%f#`y!d#`y~P!9mO[7nO~Ob7pO(O+kO(QTO(TUO~O!Y0wO!Z)Ti~O`7tO~O(`(xO!Y'lX!Z'lX~O!Y5]O!Z)Qa~O!Z7}O~P%6ZOp!nO!P8OO(QTO(TUO(`!mO(j!sO~O![1aO~O![1aO%f8QO~Ok8TO![1aO%f8QO~O[8YO!Y'oa!Z'oa~O!Y1lO!Z)Ri~O!h8^O~O!h8_O~O!h8bO~O!h8bO~P%[Oa8dO~O!d8eO~O!h8fO~O!Y(ri!Z(ri~P#D_Oa%lO#]8nO'u%lO~O!Y(oy!h(oya(oy'u(oy~P!9mO!Y(fO!h(ny~O%f8qO~P&5iO![']O%f8qO~O#h$zqP$zqR$zq[$zqa$zqo$zq!Y$zq!i$zq!m$zq#O$zq#k$zq#l$zq#m$zq#n$zq#o$zq#p$zq#q$zq#r$zq#s$zq#u$zq#w$zq#y$zq#z$zq'u$zq([$zq(m$zq!h$zq!V$zq's$zq#]$zqs$zq![$zq%f$zq!d$zq~P#.aO#h'faP'faR'fa['faa'fao'fa!i'fa!m'fa#O'fa#k'fa#l'fa#m'fa#n'fa#o'fa#p'fa#q'fa#r'fa#s'fa#u'fa#w'fa#y'fa#z'fa'u'fa(['fa(m'fa!h'fa!V'fa's'fas'fa!['fa%f'fa!d'fa~P&2mO#h'haP'haR'ha['haa'hao'ha!i'ha!m'ha#O'ha#k'ha#l'ha#m'ha#n'ha#o'ha#p'ha#q'ha#r'ha#s'ha#u'ha#w'ha#y'ha#z'ha'u'ha(['ha(m'ha!h'ha!V'ha's'has'ha!['ha%f'ha!d'ha~P&3`O#h$|qP$|qR$|q[$|qa$|qo$|q!Y$|q!i$|q!m$|q#O$|q#k$|q#l$|q#m$|q#n$|q#o$|q#p$|q#q$|q#r$|q#s$|q#u$|q#w$|q#y$|q#z$|q'u$|q([$|q(m$|q!h$|q!V$|q's$|q#]$|qs$|q![$|q%f$|q!d$|q~P#.aO!Y'Ui!h'Ui~P!9mO#}#`q!Y#`q!Z#`q~P#D_O(t%OOP%^aR%^a[%^ao%^a!i%^a!m%^a#O%^a#k%^a#l%^a#m%^a#n%^a#o%^a#p%^a#q%^a#r%^a#s%^a#u%^a#w%^a#y%^a#z%^a#}%^a([%^a(m%^a!Y%^a!Z%^a~Ok%^a}%^a!P%^a(u%^a~P&FgO(u%QOP%`aR%`a[%`ao%`a!i%`a!m%`a#O%`a#k%`a#l%`a#m%`a#n%`a#o%`a#p%`a#q%`a#r%`a#s%`a#u%`a#w%`a#y%`a#z%`a#}%`a([%`a(m%`a!Y%`a!Z%`a~Ok%`a}%`a!P%`a(t%`a~P&HkOk<qO}){O!P)|O(u%QO~P&FgOk<qO}){O!P)|O(t%OO~P&HkOR0`O}0`O!P0aO#P$dOPza[zakzaoza!iza!mza#Oza#kza#lza#mza#nza#oza#pza#qza#rza#sza#uza#wza#yza#zza#}za([za(mza(tza(uza!Yza!Zza~O}){O!P)|OP$qaR$qa[$qak$qao$qa!i$qa!m$qa#O$qa#k$qa#l$qa#m$qa#n$qa#o$qa#p$qa#q$qa#r$qa#s$qa#u$qa#w$qa#y$qa#z$qa#}$qa([$qa(m$qa(t$qa(u$qa!Y$qa!Z$qa~O}){O!P)|OP$saR$sa[$sak$sao$sa!i$sa!m$sa#O$sa#k$sa#l$sa#m$sa#n$sa#o$sa#p$sa#q$sa#r$sa#s$sa#u$sa#w$sa#y$sa#z$sa#}$sa([$sa(m$sa(t$sa(u$sa!Y$sa!Z$sa~OP%RaR%Ra[%Rao%Ra!i%Ra!m%Ra#O%Ra#k%Ra#l%Ra#m%Ra#n%Ra#o%Ra#p%Ra#q%Ra#r%Ra#s%Ra#u%Ra#w%Ra#y%Ra#z%Ra#}%Ra([%Ra(m%Ra!Y%Ra!Z%Ra~P&(tO#}$lq!Y$lq!Z$lq~P#D_O#}$mq!Y$mq!Z$mq~P#D_O!Z9OO~O#}9PO~P!0pO!d#vO!Y'ai!h'ai~O!d#vO(m'mO!Y'ai!h'ai~O!Y/hO!h(zq~O!V'ci!Y'ci~P#.aO!Y/pO!V({q~O!V9VO~P#.aO!V9VO~Og(Yy!Y(Yy~P!0pO!Y'ja!['ja~P#.aOa%Yq![%Yq'u%Yq!Y%Yq~P#.aO[9[O~O!Y0wO!Z)Tq~O#]9`O!Y'la!Z'la~O!Y5]O!Z)Qi~P#D_O![1aO%f9dO~O(QTO(TUO(`9iO~O!Y1lO!Z)Rq~O!h9lO~O!h9mO~O!h9nO~O!h9nO~P%[O#]9qO!Y#ey!Z#ey~O!Y#ey!Z#ey~P#D_O%f9vO~P&5iO![']O%f9vO~O#}#{y!Y#{y!Z#{y~P#D_OP$ziR$zi[$zio$zi!i$zi!m$zi#O$zi#k$zi#l$zi#m$zi#n$zi#o$zi#p$zi#q$zi#r$zi#s$zi#u$zi#w$zi#y$zi#z$zi#}$zi([$zi(m$zi!Y$zi!Z$zi~P&(tO}){O!P)|O(u%QOP'eaR'ea['eak'eao'ea!i'ea!m'ea#O'ea#k'ea#l'ea#m'ea#n'ea#o'ea#p'ea#q'ea#r'ea#s'ea#u'ea#w'ea#y'ea#z'ea#}'ea(['ea(m'ea(t'ea!Y'ea!Z'ea~O}){O!P)|OP'gaR'ga['gak'gao'ga!i'ga!m'ga#O'ga#k'ga#l'ga#m'ga#n'ga#o'ga#p'ga#q'ga#r'ga#s'ga#u'ga#w'ga#y'ga#z'ga#}'ga(['ga(m'ga(t'ga(u'ga!Y'ga!Z'ga~O(t%OOP%^iR%^i[%^ik%^io%^i}%^i!P%^i!i%^i!m%^i#O%^i#k%^i#l%^i#m%^i#n%^i#o%^i#p%^i#q%^i#r%^i#s%^i#u%^i#w%^i#y%^i#z%^i#}%^i([%^i(m%^i(u%^i!Y%^i!Z%^i~O(u%QOP%`iR%`i[%`ik%`io%`i}%`i!P%`i!i%`i!m%`i#O%`i#k%`i#l%`i#m%`i#n%`i#o%`i#p%`i#q%`i#r%`i#s%`i#u%`i#w%`i#y%`i#z%`i#}%`i([%`i(m%`i(t%`i!Y%`i!Z%`i~O#}$my!Y$my!Z$my~P#D_O#}#`y!Y#`y!Z#`y~P#D_O!d#vO!Y'aq!h'aq~O!Y/hO!h(zy~O!V'cq!Y'cq~P#.aO!V:PO~P#.aO!Y0wO!Z)Ty~O!Y5]O!Z)Qq~O![1aO%f:WO~O!h:ZO~O%f:`O~P&5iOP$zqR$zq[$zqo$zq!i$zq!m$zq#O$zq#k$zq#l$zq#m$zq#n$zq#o$zq#p$zq#q$zq#r$zq#s$zq#u$zq#w$zq#y$zq#z$zq#}$zq([$zq(m$zq!Y$zq!Z$zq~P&(tO}){O!P)|O(u%QOP'faR'fa['fak'fao'fa!i'fa!m'fa#O'fa#k'fa#l'fa#m'fa#n'fa#o'fa#p'fa#q'fa#r'fa#s'fa#u'fa#w'fa#y'fa#z'fa#}'fa(['fa(m'fa(t'fa!Y'fa!Z'fa~O}){O!P)|OP'haR'ha['hak'hao'ha!i'ha!m'ha#O'ha#k'ha#l'ha#m'ha#n'ha#o'ha#p'ha#q'ha#r'ha#s'ha#u'ha#w'ha#y'ha#z'ha#}'ha(['ha(m'ha(t'ha(u'ha!Y'ha!Z'ha~OP$|qR$|q[$|qo$|q!i$|q!m$|q#O$|q#k$|q#l$|q#m$|q#n$|q#o$|q#p$|q#q$|q#r$|q#s$|q#u$|q#w$|q#y$|q#z$|q#}$|q([$|q(m$|q!Y$|q!Z$|q~P&(tOg%b!Z!Y%b!Z#]%b!Z#}%b!Z~P!0pO!Y'lq!Z'lq~P#D_O!Y#e!Z!Z#e!Z~P#D_O#h%b!ZP%b!ZR%b!Z[%b!Za%b!Zo%b!Z!Y%b!Z!i%b!Z!m%b!Z#O%b!Z#k%b!Z#l%b!Z#m%b!Z#n%b!Z#o%b!Z#p%b!Z#q%b!Z#r%b!Z#s%b!Z#u%b!Z#w%b!Z#y%b!Z#z%b!Z'u%b!Z([%b!Z(m%b!Z!h%b!Z!V%b!Z's%b!Z#]%b!Zs%b!Z![%b!Z%f%b!Z!d%b!Z~P#.aOP%b!ZR%b!Z[%b!Zo%b!Z!i%b!Z!m%b!Z#O%b!Z#k%b!Z#l%b!Z#m%b!Z#n%b!Z#o%b!Z#p%b!Z#q%b!Z#r%b!Z#s%b!Z#u%b!Z#w%b!Z#y%b!Z#z%b!Z#}%b!Z([%b!Z(m%b!Z!Y%b!Z!Z%b!Z~P&(tOs(aX~P1qO}%pO~P!(oO(P!lO~P!(oO!VfX!YfX#]fX~P&-}OP]XR]X[]Xo]X}]X!P]X!Y]X!YfX!i]X!m]X#O]X#P]X#]]X#]fX#hfX#k]X#l]X#m]X#n]X#o]X#p]X#q]X#r]X#s]X#u]X#w]X#y]X#z]X$P]X([]X(m]X(t]X(u]X~O!dfX!h]X!hfX(mfX~P'CvOP:kOQ:kOSfOd<fOe!iOmkOo:kOpkOqkOwkOy:kO{:kO!PWO!TkO!UkO![XO!f:nO!iZO!l:kO!m:kO!n:kO!p:oO!r:rO!u!hO$V!kO(O)YO(QTO(TUO([VO(j[O(y<dO~O!Y;PO!Z$oa~Oh%WOm%XOo$uOp$tOq$tOw%YOy%ZO{;ZO!P$|O![$}O!f<kO!i$yO#g;aO$V%_O$r;]O$t;_O$w%`O(O(rO(QTO(TUO([$vO(t%OO(u%QO~O#t)`O~P'HlOo!bX(m!bX~P# ZO!Z]X!ZfX~P'CvO!VfX!V$xX!YfX!Y$xX#]fX~P!/gO#h:sO~O!d#vO#h:sO~O#];TO~O#s:xO~O#];dO!Y(rX!Z(rX~O#];TO!Y(pX!Z(pX~O#h;eO~Og;gO~P!0pO#h;mO~O#h;nO~O!d#vO#h;oO~O!d#vO#h;eO~O#};pO~P#D_O#h;qO~O#h;rO~O#h;wO~O#h;xO~O#h;yO~O#h;zO~O#};{O~P!0pO#};|O~P!0pO#P#Q#R#T#U#X#f#g#r(y$r$t$w%Z%e%f%g%n%p%s%t%v%x~'yT#l!U'w(P#mp#k#no}'x$['x(O$^(`~",
        goto: "$2y)XPPPPPP)YPP)]P)nP+O/PPPPP5wPP6_PP<U?kP@OP@OPPP@OPBOP@OP@OP@OPBSPBXPBvPGoPPPGsPPPPGsJuPPPJ{KwPGsPGsPPNVGsPPPGsPGsP!!^GsP!%s!&x!'RP!'u!'y!'u!+VPPPPPPP!+v!&xPP!,W!-QP!/tGsGs!/y!3U!7l!7l!;jPPP!;rGsPPPPPPPPPPP!?QP!@_PPGs!ApPGsPGsGsGsGsGsPGs!CSP!F]P!IbP!If!Ip!It!ItP!FYP!Ix!IxP!L}P!MRGsGs!MX#!]BS@OP@OP@O@OP##i@O@O#%s@O#(c@O#*g@O@O#+V#-c#-c#-h#-q#-c#-zP#-cP@O#.d@O#2T@O@O5wPPP#5zPPP#6e#6eP#6eP#6{#6ePP#7RP#6xP#6x#7f#6x#8Q#8W5t)]#8Z)]P#8b#8b#8bP)]P)]P)]P)]PP)]P#8h#8kP#8k)]P#8oP#8rP)]P)]P)]P)]P)]P)])]PP#8x#9O#9Z#9a#9g#9m#9s#:R#:X#:c#:i#:s#:y#;Z#;a#<R#<e#<k#<q#=P#=f#?T#?c#?j#AO#A^#Bx#CW#C^#Cd#Cj#Ct#Cz#DQ#D[#Dn#DtPPPPPPPPPP#DzPPPPPPP#Eo#Hv#JV#J^#JfPPP$ lP$ u$$m$+V$+Y$+]$+x$+{$,S$,[P$,b$,eP$-R$-V$-}$/]$/b$/xPP$/}$0T$0XP$0[$0`$0d$1Y$1q$2Y$2^$2a$2d$2j$2m$2q$2uR!|RoqOXst!Z#d%k&o&q&r&t,k,p1|2PY!vQ']-]1a5dQ%rvQ%zyQ&R|Q&g!VS'T!e-TQ'c!iS'i!r!yU*f$}*W*kQ+i%{Q+v&TQ,[&aQ-Z'[Q-e'dQ-m'jQ0R*mQ1k,]R;b:o%QdOPWXYZstuvw!Z!`!g!o#S#W#Z#d#o#u#x#{$O$P$Q$R$S$T$U$V$W$X$Y$`$e%k%r&P&h&k&o&q&r&t&x'Q'_'o(P(R(X(`(t(v(z)z+R+V,h,k,p-a-i-w-}.l.s/f0a0g0v1d1t1u1w1y1|2P2R2r2x3^5a5k5{5|6P6d8O8T8d8nS#q]:l!r)[$[$n'U)o,|-P.}2b3u5_6Z9`9q:k:n:o:r:s:t:u:v:w:x:y:z:{:|:};O;P;T;b;d;e;g;o;p;y;z<gU*y%[;Y;ZQ+n%}Q,^&dQ,e&lQ0m+aQ0q+cQ0|+oQ1s,cQ3Q._Q4}0wQ5r1lQ6p3UQ7p5OR8t6r'OkOPWXYZstuvw!Z!`!g!o#S#W#Z#d#o#u#x#{$O$P$Q$R$S$T$U$V$W$X$Y$[$`$e$n%k%r&P&h&k&l&o&q&r&t&x'Q'U'_'o(P(R(X(`(t(v(z)o)z+R+V+a,h,k,p,|-P-a-i-w-}._.l.s.}/f0a0g0v1d1t1u1w1y1|2P2R2b2r2x3U3^3u5_5a5k5{5|6P6Z6d6r8O8T8d8n9`9q:k:n:o:r:s:t:u:v:w:x:y:z:{:|:};O;P;T;b;d;e;g;o;p;y;z<gt!nQ!r!v!y!z'T'[']'i'j'k-T-Z-]-m1a5d5f$z$ti#v$b$c$d$y$|%P%R%]%^%b)v)|*O*Q*S*V*]*c*s*t+`+c+z+}.^.w/]/e/o/p/r0V0X0d1W1Z1c3T3}4Y4b4l4t4w5j6n7]7f8Q8q9P9d9v:W:`;R;S;U;V;W;X;[;];^;_;`;a;h;i;j;k;m;n;q;r;s;t;u;v;w;x;{;|<d<l<m<p<qQ&U|Q'R!eU'X%g*W-WQ+n%}Q,^&dQ0c*|Q0|+oQ1R+uQ1r,bQ1s,cQ4}0wQ5W1TQ5r1lQ5u1nQ5v1qQ7p5OQ7s5TQ8]5xQ9_7tR9j8YrnOXst!V!Z#d%k&f&o&q&r&t,k,p1|2PR,`&h&x^OPXYstuvwz!Z!`!g!j!o#S#d#o#u#x#{$O$P$Q$R$S$T$U$V$W$X$Y$[$`$e$n%k%r&P&h&k&l&o&q&r&t&x'Q'_'o(R(X(`(t(v(z)o)z+R+V+a,h,k,p,|-P-a-i-w-}._.l.s.}/f0a0g0v1d1t1u1w1y1|2P2R2b2r2x3U3^3u5_5a5k5{5|6P6Z6d6r8O8T8d8n9`9q:k:n:o:r:s:t:u:v:w:x:y:z:{:|:};O;P;T;b;d;e;g;o;p;y;z<f<g[#]WZ#W#Z'U(P!b%hm#h#i#l$y%c%f(Y(d(e(f*V*Z*^+T+U+W,g,}-{.R.S.T.V/e/h2U2|2}4Q6Y6kQ%uxQ%yyS&O|&TQ&[!TQ'`!hQ'b!iQ(m#sS+h%z%{Q+l%}Q,V&_Q,Z&aS-d'c'dQ.a(nQ0u+iQ0{+oQ0}+pQ1Q+tQ1f,WS1j,[,]Q2n-eQ4|0wQ5Q0zQ5V1SQ5q1kQ7o5OQ7r5SQ9Z7nR:R9[!O${i$d%P%R%]%^%b*O*Q*]*s*t.w/o0V0X0d3}4l9P<d<l<m!S%wy!i!u%y%z%{'S'b'c'd'h'r*e+h+i-Q-d-e-l/y0u2g2n2u4dQ+b%uQ+{&XQ,O&YQ,Y&aQ.`(mQ1e,VU1i,Z,[,]Q3V.aQ5l1fS5p1j1kQ8X5q#[<h#v$b$c$y$|)v)|*S*V*c+`+c+z+}.^/]/e/p/r1W1Z1c3T4Y4b4t4w5j6n7]7f8Q8q9d9v:W:`;U;W;[;^;`;h;j;m;q;s;u;w;{<p<qo<i;R;S;V;X;];_;a;i;k;n;r;t;v;x;|W%Ui%W*u<dS&X!Q&fQ&Y!RQ&Z!SR+y&V${%Ti#v$b$c$d$y$|%P%R%]%^%b)v)|*O*Q*S*V*]*c*s*t+`+c+z+}.^.w/]/e/o/p/r0V0X0d1W1Z1c3T3}4Y4b4l4t4w5j6n7]7f8Q8q9P9d9v:W:`;R;S;U;V;W;X;[;];^;_;`;a;h;i;j;k;m;n;q;r;s;t;u;v;w;x;{;|<d<l<m<p<qT)w$v)xV*y%[;Y;ZW'X!e%g*W-WS(y#y#zQ+]%pQ+s&QS.Y(i(jQ1[,PQ4m0`R7x5]'OkOPWXYZstuvw!Z!`!g!o#S#W#Z#d#o#u#x#{$O$P$Q$R$S$T$U$V$W$X$Y$[$`$e$n%k%r&P&h&k&l&o&q&r&t&x'Q'U'_'o(P(R(X(`(t(v(z)o)z+R+V+a,h,k,p,|-P-a-i-w-}._.l.s.}/f0a0g0v1d1t1u1w1y1|2P2R2b2r2x3U3^3u5_5a5k5{5|6P6Z6d6r8O8T8d8n9`9q:k:n:o:r:s:t:u:v:w:x:y:z:{:|:};O;P;T;b;d;e;g;o;p;y;z<g$i$_c#Y#e%o%q%s(O(U(p(u(})O)P)Q)R)S)T)U)V)W)X)Z)])c)m+^+r-R-p-u-z-|.k.n.r.t.u.v/X0e2]2`2p2w3]3b3c3d3e3f3g3h3i3j3k3l3m3n3q3r3y4q4z6]6c6h6w6x7R7S7z8h8l8v8|8}9s:T:[:m<ZT#TV#U'PkOPWXYZstuvw!Z!`!g!o#S#W#Z#d#o#u#x#{$O$P$Q$R$S$T$U$V$W$X$Y$[$`$e$n%k%r&P&h&k&l&o&q&r&t&x'Q'U'_'o(P(R(X(`(t(v(z)o)z+R+V+a,h,k,p,|-P-a-i-w-}._.l.s.}/f0a0g0v1d1t1u1w1y1|2P2R2b2r2x3U3^3u5_5a5k5{5|6P6Z6d6r8O8T8d8n9`9q:k:n:o:r:s:t:u:v:w:x:y:z:{:|:};O;P;T;b;d;e;g;o;p;y;z<gQ'V!eR2c-Tv!nQ!e!r!v!y!z'T'[']'i'j'k-T-Z-]-m1a5d5fU*e$}*W*kS/y*f*mQ0S*nQ1^,RQ4d0RR4g0UnqOXst!Z#d%k&o&q&r&t,k,p1|2PQ&v!^Q's!xS(o#u:sQ+f%xQ,T&[Q,U&^Q-b'aQ-o'lS.j(t;eS0f+R;oQ0s+gQ1`,SQ2T,rQ2V,sQ2_-OQ2l-cQ2o-gS4r0g;yQ4x0tS4{0v;zQ6[2aQ6`2mQ6e2tQ7m4yQ8i6^Q8j6aQ8m6fR9p8f$d$^c#Y#e%q%s(O(U(p(u(})O)P)Q)R)S)T)U)V)W)X)Z)])c)m+^+r-R-p-u-z-|.k.n.r.u.v/X0e2]2`2p2w3]3b3c3d3e3f3g3h3i3j3k3l3m3n3q3r3y4q4z6]6c6h6w6x7R7S7z8h8l8v8|8}9s:T:[:m<ZS(k#p'fQ({#zS+[%o.tS.Z(j(lR3O.['OkOPWXYZstuvw!Z!`!g!o#S#W#Z#d#o#u#x#{$O$P$Q$R$S$T$U$V$W$X$Y$[$`$e$n%k%r&P&h&k&l&o&q&r&t&x'Q'U'_'o(P(R(X(`(t(v(z)o)z+R+V+a,h,k,p,|-P-a-i-w-}._.l.s.}/f0a0g0v1d1t1u1w1y1|2P2R2b2r2x3U3^3u5_5a5k5{5|6P6Z6d6r8O8T8d8n9`9q:k:n:o:r:s:t:u:v:w:x:y:z:{:|:};O;P;T;b;d;e;g;o;p;y;z<gS#q]:lQ&q!XQ&r!YQ&t![Q&u!]R1{,nQ'^!hQ+_%uQ-`'`S.](m+bQ2j-_W3S.`.a0l0nQ6_2kW6l3P3R3V4vU8p6m6o6qU9u8r8s8uS:^9t9wQ:f:_R:i:gU!wQ']-]T5b1a5d!Q_OXZ`st!V!Z#d#h%c%k&f&h&o&q&r&t(f,k,p.S1|2P]!pQ!r']-]1a5dT#q]:l%[{OPWXYZstuvw!Z!`!g!o#S#W#Z#d#o#u#x#{$O$P$Q$R$S$T$U$V$W$X$Y$`$e%k%r&P&h&k&l&o&q&r&t&x'Q'_'o(P(R(X(`(t(v(z)z+R+V+a,h,k,p-a-i-w-}._.l.s/f0a0g0v1d1t1u1w1y1|2P2R2r2x3U3^5a5k5{5|6P6d6r8O8T8d8nS(y#y#zS.Y(i(j!s<Q$[$n'U)o,|-P.}2b3u5_6Z9`9q:k:n:o:r:s:t:u:v:w:x:y:z:{:|:};O;P;T;b;d;e;g;o;p;y;z<gU$fd)[,eS(l#p'fU*r%S(s3pU0b*x.f6}Q4v0mQ6m3QQ8s6pR9w8tm!tQ!r!v!y!z']'i'j'k-]-m1a5d5fQ'q!uS(b#g1vS-k'h'tQ/k*YQ/w*eQ2v-nQ4U/lS4_/x0SQ7X4PS7d4e4gQ9R7YR9Y7gQ#wbQ'p!uS(a#g1vS(c#m+QQ+S%dQ+d%vQ+j%|U-j'h'q'tQ.O(bQ/j*YQ/v*eQ/|*hQ0r+eQ1g,XS2s-k-nQ2{.WS4T/k/lS4^/w0SQ4a/{Q4c/}Q5n1hQ6g2vQ7W4PQ7[4US7`4_4gQ7e4fQ8V5oS9Q7X7YQ9U7aQ9W7dQ9g8WQ9}9RQ:O9VQ:Q9YQ:Y9hQ:b:PQ<T<OQ<`<XR<a<YV!wQ']-]%[aOPWXYZstuvw!Z!`!g!o#S#W#Z#d#o#u#x#{$O$P$Q$R$S$T$U$V$W$X$Y$`$e%k%r&P&h&k&l&o&q&r&t&x'Q'_'o(P(R(X(`(t(v(z)z+R+V+a,h,k,p-a-i-w-}._.l.s/f0a0g0v1d1t1u1w1y1|2P2R2r2x3U3^5a5k5{5|6P6d6r8O8T8d8nS#wz!j!r;}$[$n'U)o,|-P.}2b3u5_6Z9`9q:k:n:o:r:s:t:u:v:w:x:y:z:{:|:};O;P;T;b;d;e;g;o;p;y;z<gR<T<f%[bOPWXYZstuvw!Z!`!g!o#S#W#Z#d#o#u#x#{$O$P$Q$R$S$T$U$V$W$X$Y$`$e%k%r&P&h&k&l&o&q&r&t&x'Q'_'o(P(R(X(`(t(v(z)z+R+V+a,h,k,p-a-i-w-}._.l.s/f0a0g0v1d1t1u1w1y1|2P2R2r2x3U3^5a5k5{5|6P6d6r8O8T8d8nQ%dj!S%vy!i!u%y%z%{'S'b'c'd'h'r*e+h+i-Q-d-e-l/y0u2g2n2u4dS%|z!jQ+e%wQ,X&aW1h,Y,Z,[,]U5o1i1j1kS8W5p5qQ9h8X!r<O$[$n'U)o,|-P.}2b3u5_6Z9`9q:k:n:o:r:s:t:u:v:w:x:y:z:{:|:};O;P;T;b;d;e;g;o;p;y;z<gQ<X<eR<Y<f%OeOPXYstuvw!Z!`!g!o#S#d#o#u#x#{$O$P$Q$R$S$T$U$V$W$X$Y$`$e%k%r&P&h&k&o&q&r&t&x'Q'_'o(R(X(`(t(v(z)z+R+V+a,h,k,p-a-i-w-}._.l.s/f0a0g0v1d1t1u1w1y1|2P2R2r2x3U3^5a5k5{5|6P6d6r8O8T8d8nY#bWZ#W#Z(P!b%hm#h#i#l$y%c%f(Y(d(e(f*V*Z*^+T+U+W,g,}-{.R.S.T.V/e/h2U2|2}4Q6Y6kQ,f&l!p<P$[$n)o,|-P.}2b3u5_6Z9`9q:k:n:o:r:s:t:u:v:w:x:y:z:{:|:};O;P;T;b;d;e;g;o;p;y;z<gR<S'UU'Y!e%g*WR2e-W%QdOPWXYZstuvw!Z!`!g!o#S#W#Z#d#o#u#x#{$O$P$Q$R$S$T$U$V$W$X$Y$`$e%k%r&P&h&k&o&q&r&t&x'Q'_'o(P(R(X(`(t(v(z)z+R+V,h,k,p-a-i-w-}.l.s/f0a0g0v1d1t1u1w1y1|2P2R2r2x3^5a5k5{5|6P6d8O8T8d8n!r)[$[$n'U)o,|-P.}2b3u5_6Z9`9q:k:n:o:r:s:t:u:v:w:x:y:z:{:|:};O;P;T;b;d;e;g;o;p;y;z<gQ,e&lQ0m+aQ3Q._Q6p3UR8t6r!b$Uc#Y%o(O(U(p(u)W)X)])c+r-p-u-z-|.k.n/X0e2p2w3]3n4q4z6c6h6w8l9s:m!P:z)Z)m-R.t2]2`3b3l3m3q3y6]6x7R7S7z8h8v8|8}:T:[<Z!f$Wc#Y%o(O(U(p(u)T)U)W)X)])c+r-p-u-z-|.k.n/X0e2p2w3]3n4q4z6c6h6w8l9s:m!T:|)Z)m-R.t2]2`3b3i3j3l3m3q3y6]6x7R7S7z8h8v8|8}:T:[<Z!^$[c#Y%o(O(U(p(u)])c+r-p-u-z-|.k.n/X0e2p2w3]3n4q4z6c6h6w8l9s:mQ3}/cz<g)Z)m-R.t2]2`3b3q3y6]6x7R7S7z8h8v8|8}:T:[<ZQ<l<nR<m<o'OkOPWXYZstuvw!Z!`!g!o#S#W#Z#d#o#u#x#{$O$P$Q$R$S$T$U$V$W$X$Y$[$`$e$n%k%r&P&h&k&l&o&q&r&t&x'Q'U'_'o(P(R(X(`(t(v(z)o)z+R+V+a,h,k,p,|-P-a-i-w-}._.l.s.}/f0a0g0v1d1t1u1w1y1|2P2R2b2r2x3U3^3u5_5a5k5{5|6P6Z6d6r8O8T8d8n9`9q:k:n:o:r:s:t:u:v:w:x:y:z:{:|:};O;P;T;b;d;e;g;o;p;y;z<gS$oh$pR3v.|'VgOPWXYZhstuvw!Z!`!g!o#S#W#Z#d#o#u#x#{$O$P$Q$R$S$T$U$V$W$X$Y$[$`$e$n$p%k%r&P&h&k&l&o&q&r&t&x'Q'U'_'o(P(R(X(`(t(v(z)o)z+R+V+a,h,k,p,|-P-a-i-w-}._.l.s.|.}/f0a0g0v1d1t1u1w1y1|2P2R2b2r2x3U3^3u5_5a5k5{5|6P6Z6d6r8O8T8d8n9`9q:k:n:o:r:s:t:u:v:w:x:y:z:{:|:};O;P;T;b;d;e;g;o;p;y;z<gT$kf$qQ$ifS)f$l)jR)r$qT$jf$qT)h$l)j'VhOPWXYZhstuvw!Z!`!g!o#S#W#Z#d#o#u#x#{$O$P$Q$R$S$T$U$V$W$X$Y$[$`$e$n$p%k%r&P&h&k&l&o&q&r&t&x'Q'U'_'o(P(R(X(`(t(v(z)o)z+R+V+a,h,k,p,|-P-a-i-w-}._.l.s.|.}/f0a0g0v1d1t1u1w1y1|2P2R2b2r2x3U3^3u5_5a5k5{5|6P6Z6d6r8O8T8d8n9`9q:k:n:o:r:s:t:u:v:w:x:y:z:{:|:};O;P;T;b;d;e;g;o;p;y;z<gT$oh$pQ$rhR)q$p%[jOPWXYZstuvw!Z!`!g!o#S#W#Z#d#o#u#x#{$O$P$Q$R$S$T$U$V$W$X$Y$`$e%k%r&P&h&k&l&o&q&r&t&x'Q'_'o(P(R(X(`(t(v(z)z+R+V+a,h,k,p-a-i-w-}._.l.s/f0a0g0v1d1t1u1w1y1|2P2R2r2x3U3^5a5k5{5|6P6d6r8O8T8d8n!s<e$[$n'U)o,|-P.}2b3u5_6Z9`9q:k:n:o:r:s:t:u:v:w:x:y:z:{:|:};O;P;T;b;d;e;g;o;p;y;z<g#elOPXZst!Z!`!o#S#d#o#{$n%k&h&k&l&o&q&r&t&x'Q'_(z)o+V+a,h,k,p-a._.}/f0a1d1t1u1w1y1|2P2R3U3u5a5k5{5|6P6r8O8T8d!O%Si$d%P%R%]%^%b*O*Q*]*s*t.w/o0V0X0d3}4l9P<d<l<m#[(s#v$b$c$y$|)v)|*S*V*c+`+c+z+}.^/]/e/p/r1W1Z1c3T4Y4b4t4w5j6n7]7f8Q8q9d9v:W:`;U;W;[;^;`;h;j;m;q;s;u;w;{<p<qQ*}%`Q/Y){o3p;R;S;V;X;];_;a;i;k;n;r;t;v;x;|!O$zi$d%P%R%]%^%b*O*Q*]*s*t.w/o0V0X0d3}4l9P<d<l<mQ*_${U*h$}*W*kQ+O%aQ/}*i#[<V#v$b$c$y$|)v)|*S*V*c+`+c+z+}.^/]/e/p/r1W1Z1c3T4Y4b4t4w5j6n7]7f8Q8q9d9v:W:`;U;W;[;^;`;h;j;m;q;s;u;w;{<p<qn<W;R;S;V;X;];_;a;i;k;n;r;t;v;x;|Q<[<hQ<]<iQ<^<jR<_<k!O%Si$d%P%R%]%^%b*O*Q*]*s*t.w/o0V0X0d3}4l9P<d<l<m#[(s#v$b$c$y$|)v)|*S*V*c+`+c+z+}.^/]/e/p/r1W1Z1c3T4Y4b4t4w5j6n7]7f8Q8q9d9v:W:`;U;W;[;^;`;h;j;m;q;s;u;w;{<p<qo3p;R;S;V;X;];_;a;i;k;n;r;t;v;x;|noOXst!Z#d%k&o&q&r&t,k,p1|2PS*b$|*VQ,y&{Q,z&}R4X/p$z%Ti#v$b$c$d$y$|%P%R%]%^%b)v)|*O*Q*S*V*]*c*s*t+`+c+z+}.^.w/]/e/o/p/r0V0X0d1W1Z1c3T3}4Y4b4l4t4w5j6n7]7f8Q8q9P9d9v:W:`;R;S;U;V;W;X;[;];^;_;`;a;h;i;j;k;m;n;q;r;s;t;u;v;w;x;{;|<d<l<m<p<qQ+|&YQ1Y,OQ5Z1XR7w5[V*j$}*W*kU*j$}*W*kT5c1a5dU/{*g/f5aT4f0T8OQ+d%vQ/|*hQ0r+eQ1g,XQ5n1hQ8V5oQ9g8WR:Y9h!O%Pi$d%P%R%]%^%b*O*Q*]*s*t.w/o0V0X0d3}4l9P<d<l<mr*O$w)a*P*q+P/n0Z0[3s4V4p7V7h9|<U<b<cS0V*p0W#[;U#v$b$c$y$|)v)|*S*V*c+`+c+z+}.^/]/e/p/r1W1Z1c3T4Y4b4t4w5j6n7]7f8Q8q9d9v:W:`;U;W;[;^;`;h;j;m;q;s;u;w;{<p<qn;V;R;S;V;X;];_;a;i;k;n;r;t;v;x;|!^;h(q)_*X*a.b.e.i/U/Z/c/s0k1V1X3Y4W4[5Y5[6s6v7^7b7j7l9T9X:a<n<o`;i3o6y6|7Q8w9x9{:jS;s.d3ZT;t6{8z!O%Ri$d%P%R%]%^%b*O*Q*]*s*t.w/o0V0X0d3}4l9P<d<l<mv*Q$w)a*R*p+P/_/n0Z0[3s4V4h4p7V7h9|<U<b<cS0X*q0Y#[;W#v$b$c$y$|)v)|*S*V*c+`+c+z+}.^/]/e/p/r1W1Z1c3T4Y4b4t4w5j6n7]7f8Q8q9d9v:W:`;U;W;[;^;`;h;j;m;q;s;u;w;{<p<qn;X;R;S;V;X;];_;a;i;k;n;r;t;v;x;|!b;j(q)_*X*a.c.d.i/U/Z/c/s0k1V1X3W3Y4W4[5Y5[6s6t6v7^7b7j7l9T9X:a<n<od;k3o6z6{7Q8w8x9x9y9{:jS;u.e3[T;v6|8{rnOXst!V!Z#d%k&f&o&q&r&t,k,p1|2PQ&c!UR,h&lrnOXst!V!Z#d%k&f&o&q&r&t,k,p1|2PR&c!UQ,Q&ZR1U+ysnOXst!V!Z#d%k&f&o&q&r&t,k,p1|2PQ1b,VS5i1e1fU8P5g5h5lS9c8R8SS:U9b9eQ:c:VR:h:dQ&j!VR,a&fR5u1nS&O|&TR0}+pQ&o!WR,k&pR,q&uT1},p2PR,u&vQ,t&vR2W,uQ'v!{R-q'vSsOtQ#dXT%ns#dQ#OTR'x#OQ#RUR'z#RQ)x$vR/V)xQ#UVR'|#UQ#XWU(S#X(T-xQ(T#YR-x(UQ-U'VR2d-UQ.m(uS3_.m3`R3`.nQ-]']R2h-]Y!rQ']-]1a5dR'g!rQ.x)aR3t.xU#_W%f*VU(Z#_([-yQ([#`R-y(VQ-X'YR2f-Xt`OXst!V!Z#d%k&f&h&o&q&r&t,k,p1|2PS#hZ%cU#r`#h.SR.S(fQ(g#jQ.P(cW.X(g.P2y6iQ2y.QR6i2zQ)j$lR/O)jQ$phR)p$pQ$acU)^$a-t;QQ-t:mR;Q)mQ/i*YW4R/i4S7Z9SU4S/j/k/lS7Z4T4UR9S7[$X)}$w(q)_)a*X*a*p*q*z*{+P.d.e.g.h.i/U/Z/_/a/c/n/s0Z0[0k1V1X3W3X3Y3o3s4V4W4[4h4j4p5Y5[6s6t6u6v6{6|7O7P7Q7V7^7b7h7j7l8w8x8y9T9X9x9y9z9{9|:a:j<U<b<c<n<oQ/q*aU4Z/q4]7_Q4]/sR7_4[S*k$}*WR0P*kr*P$w)a*p*q+P/n0Z0[3s4V4p7V7h9|<U<b<c!^.b(q)_*X*a.d.e.i/U/Z/c/s0k1V1X3Y4W4[5Y5[6s6v7^7b7j7l9T9X:a<n<oU/`*P.b6ya6y3o6{6|7Q8w9x9{:jQ0W*pQ3Z.dU4i0W3Z8zR8z6{v*R$w)a*p*q+P/_/n0Z0[3s4V4h4p7V7h9|<U<b<c!b.c(q)_*X*a.d.e.i/U/Z/c/s0k1V1X3W3Y4W4[5Y5[6s6t6v7^7b7j7l9T9X:a<n<oU/b*R.c6ze6z3o6{6|7Q8w8x9x9y9{:jQ0Y*qQ3[.eU4k0Y3[8{R8{6|Q*v%VR0^*vQ4u0kR7k4uQ+X%iR0j+XQ5^1[S7y5^9aR9a7zQ,S&[R1_,SQ5d1aR7|5dQ1m,^S5s1m8ZR8Z5uQ0x+lW5P0x5R7q9]Q5R0{Q7q5QR9]7rQ+q&OR1O+qQ2P,pR6T2PYrOXst#dQ&s!ZQ+Z%kQ,j&oQ,l&qQ,m&rQ,o&tQ1z,kS1},p2PR6S1|Q%mpQ&w!_Q&z!aQ&|!bQ'O!cQ'n!uQ+Y%jQ+f%xQ+x&UQ,`&jQ,w&yW-h'h'p'q'tQ-o'lQ0O*jQ0s+gS1p,a,dQ2X,vQ2Y,yQ2Z,zQ2o-gW2q-j-k-n-pQ4x0tQ5U1RQ5X1VQ5m1gQ5w1rQ6R1{U6b2p2s2vQ6e2tQ7m4yQ7u5WQ7v5YQ7{5cQ8U5nQ8[5vS8k6c6gQ8m6fQ9^7sQ9f8VQ9k8]Q9r8lQ:S9_Q:X9gQ:]9sR:e:YQ%xyQ'a!iQ'l!uU+g%y%z%{Q-O'SU-c'b'c'dS-g'h'rQ/u*eS0t+h+iQ2a-QS2m-d-eQ2t-lQ4`/yQ4y0uQ6^2gQ6a2nQ6f2uR7c4dS$xi<dR*w%WU%Vi%W<dR0]*uQ$wiS(q#v+cS)_$b$cQ)a$dQ*X$yS*a$|*VQ*p%PQ*q%RQ*z%]Q*{%^Q+P%bQ.d;UQ.e;WQ.g;[Q.h;^Q.i;`Q/U)vS/Z)|/]Q/_*OQ/a*QQ/c*SQ/n*]S/s*c/eQ0Z*sQ0[*th0k+`.^1c3T5j6n8Q8q9d9v:W:`Q1V+zQ1X+}Q3W;hQ3X;jQ3Y;mS3o;R;SQ3s.wQ4V/oQ4W/pQ4[/rQ4h0VQ4j0XQ4p0dQ5Y1WQ5[1ZQ6s;qQ6t;sQ6u;uQ6v;wQ6{;VQ6|;XQ7O;]Q7P;_Q7Q;aQ7V3}Q7^4YQ7b4bQ7h4lQ7j4tQ7l4wQ8w;nQ8x;iQ8y;kQ9T7]Q9X7fQ9x;rQ9y;tQ9z;vQ9{;xQ9|9PQ:a;{Q:j;|Q<U<dQ<b<lQ<c<mQ<n<pR<o<qQ*x%[Q.f;YR6};ZnpOXst!Z#d%k&o&q&r&t,k,p1|2PQ!fPS#fZ#oQ&y!`U'e!o5a8OQ'{#SQ(|#{Q)n$nS,d&h&kQ,i&lQ,v&xQ,{'QQ-_'_Q.p(zQ/S)oS0h+V/fQ0n+aQ1x,hQ2k-aQ3R._Q3x.}Q4n0aQ5h1dQ5y1tQ5z1uQ6O1wQ6Q1yQ6V2RQ6q3UQ7T3uQ8S5kQ8`5{Q8a5|Q8c6PQ8u6rQ9e8TR9o8d#YcOPXZst!Z!`!o#d#o#{%k&h&k&l&o&q&r&t&x'Q'_(z+V+a,h,k,p-a._/f0a1d1t1u1w1y1|2P2R3U5a5k5{5|6P6r8O8T8dQ#YWQ#eYQ%ouQ%qvS%sw!gS(O#W(RQ(U#ZQ(p#uQ(u#xQ(}$OQ)O$PQ)P$QQ)Q$RQ)R$SQ)S$TQ)T$UQ)U$VQ)V$WQ)W$XQ)X$YQ)Z$[Q)]$`Q)c$eW)m$n)o.}3uQ+^%rQ+r&PS-R'U2bQ-p'oS-u(P-wQ-z(XQ-|(`Q.k(tQ.n(vQ.r:kQ.t:nQ.u:oQ.v:rQ/X)zQ0e+RQ2],|Q2`-PQ2p-iQ2w-}Q3].lQ3b:sQ3c:tQ3d:uQ3e:vQ3f:wQ3g:xQ3h:yQ3i:zQ3j:{Q3k:|Q3l:}Q3m;OQ3n.sQ3q;TQ3r;bQ3y;PQ4q0gQ4z0vQ6];dQ6c2rQ6h2xQ6w3^Q6x;eQ7R;gQ7S;oQ7z5_Q8h6ZQ8l6dQ8v;pQ8|;yQ8};zQ9s8nQ:T9`Q:[9qQ:m#SR<Z<gR#[WR'W!el!tQ!r!v!y!z']'i'j'k-]-m1a5d5fS'S!e-TS-Q'T'[R2g-ZR(w#xQ!fQT-[']-]]!qQ!r']-]1a5dQ#p]R'f:lR)b$dY!uQ']-]1a5dQ'h!rS'r!v!yS't!z5fS-l'i'jQ-n'kR2u-mT#kZ%cS#jZ%cS%im,gU(c#h#i#lS.Q(d(eQ.U(fQ0i+WQ2z.RU2{.S.T.VS6j2|2}R8o6kd#^W#W#Z%f(P(Y*V+T-{/er#gZm#h#i#l%c(d(e(f+W.R.S.T.V2|2}6kS*Y$y*^Q/l*ZQ1v,gQ2^,}Q4P/hQ6X2UQ7Y4QQ8g6YT<R'U+UV#aW%f*VU#`W%f*VS(Q#W(YU(V#Z+T/eS-S'U+UT-v(P-{V'Z!e%g*WQ$lfR)t$qT)i$l)jR3w.|T*[$y*^T*d$|*VQ0l+`Q3P.^Q5g1cQ6o3TQ8R5jQ8r6nQ9b8QQ9t8qQ:V9dQ:_9vQ:d:WR:g:`nqOXst!Z#d%k&o&q&r&t,k,p1|2PQ&i!VR,`&ftmOXst!U!V!Z#d%k&f&o&q&r&t,k,p1|2PR,g&lT%jm,gR1],PR,_&dQ&S|R+w&TR+m%}T&m!W&pT&n!W&pT2O,p2P",
        nodeNames: "\u26a0 ArithOp ArithOp ?. JSXStartTag LineComment BlockComment Script Hashbang ExportDeclaration export Star as VariableName String Escape from ; default FunctionDeclaration async function VariableDefinition > < TypeParamList TypeDefinition extends ThisType this LiteralType ArithOp Number BooleanLiteral TemplateType InterpolationEnd Interpolation InterpolationStart NullType null VoidType void TypeofType typeof MemberExpression . PropertyName [ TemplateString Escape Interpolation super RegExp ] ArrayExpression Spread , } { ObjectExpression Property async get set PropertyDefinition Block : NewTarget new NewExpression ) ( ArgList UnaryExpression delete LogicOp BitOp YieldExpression yield AwaitExpression await ParenthesizedExpression ClassExpression class ClassBody MethodDeclaration Decorator @ MemberExpression PrivatePropertyName CallExpression TypeArgList CompareOp < declare Privacy static abstract override PrivatePropertyDefinition PropertyDeclaration readonly accessor Optional TypeAnnotation Equals StaticBlock FunctionExpression ArrowFunction ParamList ParamList ArrayPattern ObjectPattern PatternProperty Privacy readonly Arrow MemberExpression BinaryExpression ArithOp ArithOp ArithOp ArithOp BitOp CompareOp instanceof satisfies in const CompareOp BitOp BitOp BitOp LogicOp LogicOp ConditionalExpression LogicOp LogicOp AssignmentExpression UpdateOp PostfixExpression CallExpression InstantiationExpression TaggedTemplateExpression DynamicImport import ImportMeta JSXElement JSXSelfCloseEndTag JSXSelfClosingTag JSXIdentifier JSXBuiltin JSXIdentifier JSXNamespacedName JSXMemberExpression JSXSpreadAttribute JSXAttribute JSXAttributeValue JSXEscape JSXEndTag JSXOpenTag JSXFragmentTag JSXText JSXEscape JSXStartCloseTag JSXCloseTag PrefixCast ArrowFunction TypeParamList SequenceExpression InstantiationExpression KeyofType keyof UniqueType unique ImportType InferredType infer TypeName ParenthesizedType FunctionSignature ParamList NewSignature IndexedType TupleType Label ArrayType ReadonlyType ObjectType MethodType PropertyType IndexSignature PropertyDefinition CallSignature TypePredicate is NewSignature new UnionType LogicOp IntersectionType LogicOp ConditionalType ParameterizedType ClassDeclaration abstract implements type VariableDeclaration let var using TypeAliasDeclaration InterfaceDeclaration interface EnumDeclaration enum EnumBody NamespaceDeclaration namespace module AmbientDeclaration declare GlobalDeclaration global ClassDeclaration ClassBody AmbientFunctionDeclaration ExportGroup VariableName VariableName ImportDeclaration ImportGroup ForStatement for ForSpec ForInSpec ForOfSpec of WhileStatement while WithStatement with DoStatement do IfStatement if else SwitchStatement switch SwitchBody CaseLabel case DefaultLabel TryStatement try CatchClause catch FinallyClause finally ReturnStatement return ThrowStatement throw BreakStatement break ContinueStatement continue DebuggerStatement debugger LabeledStatement ExpressionStatement SingleExpression SingleClassItem",
        maxTerm: 376,
        context: cursorDocStart,
        nodeProps: [ [ "isolate", -8, 5, 6, 14, 34, 36, 48, 50, 52, "" ], [ "group", -26, 9, 17, 19, 65, 204, 208, 212, 213, 215, 218, 221, 231, 233, 239, 241, 243, 245, 248, 254, 260, 262, 264, 266, 268, 270, 271, "Statement", -34, 13, 14, 29, 32, 33, 39, 48, 51, 52, 54, 59, 67, 69, 73, 77, 79, 81, 82, 107, 108, 117, 118, 135, 138, 140, 141, 142, 143, 144, 146, 147, 166, 167, 169, "Expression", -23, 28, 30, 34, 38, 40, 42, 171, 173, 175, 176, 178, 179, 180, 182, 183, 184, 186, 187, 188, 198, 200, 202, 203, "Type", -3, 85, 100, 106, "ClassItem" ], [ "openedBy", 23, "<", 35, "InterpolationStart", 53, "[", 57, "{", 70, "(", 159, "JSXStartCloseTag" ], [ "closedBy", 24, ">", 37, "InterpolationEnd", 47, "]", 58, "}", 71, ")", 164, "JSXEndTag" ] ],
        propSources: [ htmlHighlighting ],
        skippedNodes: [ 0, 5, 6, 274 ],
        repeatNodeCount: 37,
        tokenData: "$Fq07[R!bOX%ZXY+gYZ-yZ[+g[]%Z]^.c^p%Zpq+gqr/mrs3cst:_tuEruvJSvwLkwx! Yxy!'iyz!(sz{!)}{|!,q|}!.O}!O!,q!O!P!/Y!P!Q!9j!Q!R#:O!R![#<_![!]#I_!]!^#Jk!^!_#Ku!_!`$![!`!a$$v!a!b$*T!b!c$,r!c!}Er!}#O$-|#O#P$/W#P#Q$4o#Q#R$5y#R#SEr#S#T$7W#T#o$8b#o#p$<r#p#q$=h#q#r$>x#r#s$@U#s$f%Z$f$g+g$g#BYEr#BY#BZ$A`#BZ$ISEr$IS$I_$A`$I_$I|Er$I|$I}$Dk$I}$JO$Dk$JO$JTEr$JT$JU$A`$JU$KVEr$KV$KW$A`$KW&FUEr&FU&FV$A`&FV;'SEr;'S;=`I|<%l?HTEr?HT?HU$A`?HUOEr(n%d_$h&j(Rp(U!bOY%ZYZ&cZr%Zrs&}sw%Zwx(rx!^%Z!^!_*g!_#O%Z#O#P&c#P#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z&j&hT$h&jO!^&c!_#o&c#p;'S&c;'S;=`&w<%lO&c&j&zP;=`<%l&c'|'U]$h&j(U!bOY&}YZ&cZw&}wx&cx!^&}!^!_'}!_#O&}#O#P&c#P#o&}#o#p'}#p;'S&};'S;=`(l<%lO&}!b(SU(U!bOY'}Zw'}x#O'}#P;'S'};'S;=`(f<%lO'}!b(iP;=`<%l'}'|(oP;=`<%l&}'[(y]$h&j(RpOY(rYZ&cZr(rrs&cs!^(r!^!_)r!_#O(r#O#P&c#P#o(r#o#p)r#p;'S(r;'S;=`*a<%lO(rp)wU(RpOY)rZr)rs#O)r#P;'S)r;'S;=`*Z<%lO)rp*^P;=`<%l)r'[*dP;=`<%l(r#S*nX(Rp(U!bOY*gZr*grs'}sw*gwx)rx#O*g#P;'S*g;'S;=`+Z<%lO*g#S+^P;=`<%l*g(n+dP;=`<%l%Z07[+rq$h&j(Rp(U!b'w0/lOX%ZXY+gYZ&cZ[+g[p%Zpq+gqr%Zrs&}sw%Zwx(rx!^%Z!^!_*g!_#O%Z#O#P&c#P#o%Z#o#p*g#p$f%Z$f$g+g$g#BY%Z#BY#BZ+g#BZ$IS%Z$IS$I_+g$I_$JT%Z$JT$JU+g$JU$KV%Z$KV$KW+g$KW&FU%Z&FU&FV+g&FV;'S%Z;'S;=`+a<%l?HT%Z?HT?HU+g?HUO%Z07[.ST(S#S$h&j'x0/lO!^&c!_#o&c#p;'S&c;'S;=`&w<%lO&c07[.n_$h&j(Rp(U!b'x0/lOY%ZYZ&cZr%Zrs&}sw%Zwx(rx!^%Z!^!_*g!_#O%Z#O#P&c#P#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z)3p/x`$h&j!m),Q(Rp(U!bOY%ZYZ&cZr%Zrs&}sw%Zwx(rx!^%Z!^!_*g!_!`0z!`#O%Z#O#P&c#P#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z(KW1V`#u(Ch$h&j(Rp(U!bOY%ZYZ&cZr%Zrs&}sw%Zwx(rx!^%Z!^!_*g!_!`2X!`#O%Z#O#P&c#P#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z(KW2d_#u(Ch$h&j(Rp(U!bOY%ZYZ&cZr%Zrs&}sw%Zwx(rx!^%Z!^!_*g!_#O%Z#O#P&c#P#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z'At3l_(Q':f$h&j(U!bOY4kYZ5qZr4krs7nsw4kwx5qx!^4k!^!_8p!_#O4k#O#P5q#P#o4k#o#p8p#p;'S4k;'S;=`:X<%lO4k(^4r_$h&j(U!bOY4kYZ5qZr4krs7nsw4kwx5qx!^4k!^!_8p!_#O4k#O#P5q#P#o4k#o#p8p#p;'S4k;'S;=`:X<%lO4k&z5vX$h&jOr5qrs6cs!^5q!^!_6y!_#o5q#o#p6y#p;'S5q;'S;=`7h<%lO5q&z6jT$c`$h&jO!^&c!_#o&c#p;'S&c;'S;=`&w<%lO&c`6|TOr6yrs7]s;'S6y;'S;=`7b<%lO6y`7bO$c``7eP;=`<%l6y&z7kP;=`<%l5q(^7w]$c`$h&j(U!bOY&}YZ&cZw&}wx&cx!^&}!^!_'}!_#O&}#O#P&c#P#o&}#o#p'}#p;'S&};'S;=`(l<%lO&}!r8uZ(U!bOY8pYZ6yZr8prs9hsw8pwx6yx#O8p#O#P6y#P;'S8p;'S;=`:R<%lO8p!r9oU$c`(U!bOY'}Zw'}x#O'}#P;'S'};'S;=`(f<%lO'}!r:UP;=`<%l8p(^:[P;=`<%l4k%9[:hh$h&j(Rp(U!bOY%ZYZ&cZq%Zqr<Srs&}st%ZtuCruw%Zwx(rx!^%Z!^!_*g!_!c%Z!c!}Cr!}#O%Z#O#P&c#P#R%Z#R#SCr#S#T%Z#T#oCr#o#p*g#p$g%Z$g;'SCr;'S;=`El<%lOCr(r<__WS$h&j(Rp(U!bOY<SYZ&cZr<Srs=^sw<Swx@nx!^<S!^!_Bm!_#O<S#O#P>`#P#o<S#o#pBm#p;'S<S;'S;=`Cl<%lO<S(Q=g]WS$h&j(U!bOY=^YZ&cZw=^wx>`x!^=^!^!_?q!_#O=^#O#P>`#P#o=^#o#p?q#p;'S=^;'S;=`@h<%lO=^&n>gXWS$h&jOY>`YZ&cZ!^>`!^!_?S!_#o>`#o#p?S#p;'S>`;'S;=`?k<%lO>`S?XSWSOY?SZ;'S?S;'S;=`?e<%lO?SS?hP;=`<%l?S&n?nP;=`<%l>`!f?xWWS(U!bOY?qZw?qwx?Sx#O?q#O#P?S#P;'S?q;'S;=`@b<%lO?q!f@eP;=`<%l?q(Q@kP;=`<%l=^'`@w]WS$h&j(RpOY@nYZ&cZr@nrs>`s!^@n!^!_Ap!_#O@n#O#P>`#P#o@n#o#pAp#p;'S@n;'S;=`Bg<%lO@ntAwWWS(RpOYApZrAprs?Ss#OAp#O#P?S#P;'SAp;'S;=`Ba<%lOAptBdP;=`<%lAp'`BjP;=`<%l@n#WBvYWS(Rp(U!bOYBmZrBmrs?qswBmwxApx#OBm#O#P?S#P;'SBm;'S;=`Cf<%lOBm#WCiP;=`<%lBm(rCoP;=`<%l<S%9[C}i$h&j(j%1l(Rp(U!bOY%ZYZ&cZr%Zrs&}st%ZtuCruw%Zwx(rx!Q%Z!Q![Cr![!^%Z!^!_*g!_!c%Z!c!}Cr!}#O%Z#O#P&c#P#R%Z#R#SCr#S#T%Z#T#oCr#o#p*g#p$g%Z$g;'SCr;'S;=`El<%lOCr%9[EoP;=`<%lCr07[FRk$h&j(Rp(U!b$[#t(O,2j(`$I[OY%ZYZ&cZr%Zrs&}st%ZtuEruw%Zwx(rx}%Z}!OGv!O!Q%Z!Q![Er![!^%Z!^!_*g!_!c%Z!c!}Er!}#O%Z#O#P&c#P#R%Z#R#SEr#S#T%Z#T#oEr#o#p*g#p$g%Z$g;'SEr;'S;=`I|<%lOEr+dHRk$h&j(Rp(U!b$[#tOY%ZYZ&cZr%Zrs&}st%ZtuGvuw%Zwx(rx}%Z}!OGv!O!Q%Z!Q![Gv![!^%Z!^!_*g!_!c%Z!c!}Gv!}#O%Z#O#P&c#P#R%Z#R#SGv#S#T%Z#T#oGv#o#p*g#p$g%Z$g;'SGv;'S;=`Iv<%lOGv+dIyP;=`<%lGv07[JPP;=`<%lEr(KWJ_`$h&j(Rp(U!b#m(ChOY%ZYZ&cZr%Zrs&}sw%Zwx(rx!^%Z!^!_*g!_!`Ka!`#O%Z#O#P&c#P#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z(KWKl_$h&j$P(Ch(Rp(U!bOY%ZYZ&cZr%Zrs&}sw%Zwx(rx!^%Z!^!_*g!_#O%Z#O#P&c#P#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z,#xLva(u+JY$h&j(Rp(U!bOY%ZYZ&cZr%Zrs&}sv%ZvwM{wx(rx!^%Z!^!_*g!_!`Ka!`#O%Z#O#P&c#P#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z(KWNW`$h&j#y(Ch(Rp(U!bOY%ZYZ&cZr%Zrs&}sw%Zwx(rx!^%Z!^!_*g!_!`Ka!`#O%Z#O#P&c#P#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z'At! c_(T';W$h&j(RpOY!!bYZ!#hZr!!brs!#hsw!!bwx!$xx!^!!b!^!_!%z!_#O!!b#O#P!#h#P#o!!b#o#p!%z#p;'S!!b;'S;=`!'c<%lO!!b'l!!i_$h&j(RpOY!!bYZ!#hZr!!brs!#hsw!!bwx!$xx!^!!b!^!_!%z!_#O!!b#O#P!#h#P#o!!b#o#p!%z#p;'S!!b;'S;=`!'c<%lO!!b&z!#mX$h&jOw!#hwx6cx!^!#h!^!_!$Y!_#o!#h#o#p!$Y#p;'S!#h;'S;=`!$r<%lO!#h`!$]TOw!$Ywx7]x;'S!$Y;'S;=`!$l<%lO!$Y`!$oP;=`<%l!$Y&z!$uP;=`<%l!#h'l!%R]$c`$h&j(RpOY(rYZ&cZr(rrs&cs!^(r!^!_)r!_#O(r#O#P&c#P#o(r#o#p)r#p;'S(r;'S;=`*a<%lO(r!Q!&PZ(RpOY!%zYZ!$YZr!%zrs!$Ysw!%zwx!&rx#O!%z#O#P!$Y#P;'S!%z;'S;=`!']<%lO!%z!Q!&yU$c`(RpOY)rZr)rs#O)r#P;'S)r;'S;=`*Z<%lO)r!Q!'`P;=`<%l!%z'l!'fP;=`<%l!!b/5|!'t_!i/.^$h&j(Rp(U!bOY%ZYZ&cZr%Zrs&}sw%Zwx(rx!^%Z!^!_*g!_#O%Z#O#P&c#P#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z#&U!)O_!h!Lf$h&j(Rp(U!bOY%ZYZ&cZr%Zrs&}sw%Zwx(rx!^%Z!^!_*g!_#O%Z#O#P&c#P#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z-!n!*[b$h&j(Rp(U!b(P%&f#n(ChOY%ZYZ&cZr%Zrs&}sw%Zwx(rxz%Zz{!+d{!^%Z!^!_*g!_!`Ka!`#O%Z#O#P&c#P#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z(KW!+o`$h&j(Rp(U!b#k(ChOY%ZYZ&cZr%Zrs&}sw%Zwx(rx!^%Z!^!_*g!_!`Ka!`#O%Z#O#P&c#P#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z+;x!,|`$h&j(Rp(U!bo+4YOY%ZYZ&cZr%Zrs&}sw%Zwx(rx!^%Z!^!_*g!_!`Ka!`#O%Z#O#P&c#P#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z,$U!.Z_!Y+Jf$h&j(Rp(U!bOY%ZYZ&cZr%Zrs&}sw%Zwx(rx!^%Z!^!_*g!_#O%Z#O#P&c#P#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z07[!/ec$h&j(Rp(U!b}.2^OY%ZYZ&cZr%Zrs&}sw%Zwx(rx!O%Z!O!P!0p!P!Q%Z!Q![!3Y![!^%Z!^!_*g!_#O%Z#O#P&c#P#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z#%|!0ya$h&j(Rp(U!bOY%ZYZ&cZr%Zrs&}sw%Zwx(rx!O%Z!O!P!2O!P!^%Z!^!_*g!_#O%Z#O#P&c#P#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z#%|!2Z_!X!L^$h&j(Rp(U!bOY%ZYZ&cZr%Zrs&}sw%Zwx(rx!^%Z!^!_*g!_#O%Z#O#P&c#P#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z'Ad!3eg$h&j(Rp(U!bp'9tOY%ZYZ&cZr%Zrs&}sw%Zwx(rx!Q%Z!Q![!3Y![!^%Z!^!_*g!_!g%Z!g!h!4|!h#O%Z#O#P&c#P#R%Z#R#S!3Y#S#X%Z#X#Y!4|#Y#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z'Ad!5Vg$h&j(Rp(U!bOY%ZYZ&cZr%Zrs&}sw%Zwx(rx{%Z{|!6n|}%Z}!O!6n!O!Q%Z!Q![!8S![!^%Z!^!_*g!_#O%Z#O#P&c#P#R%Z#R#S!8S#S#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z'Ad!6wc$h&j(Rp(U!bOY%ZYZ&cZr%Zrs&}sw%Zwx(rx!Q%Z!Q![!8S![!^%Z!^!_*g!_#O%Z#O#P&c#P#R%Z#R#S!8S#S#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z'Ad!8_c$h&j(Rp(U!bp'9tOY%ZYZ&cZr%Zrs&}sw%Zwx(rx!Q%Z!Q![!8S![!^%Z!^!_*g!_#O%Z#O#P&c#P#R%Z#R#S!8S#S#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z07[!9uf$h&j(Rp(U!b#l(ChOY!;ZYZ&cZr!;Zrs!<nsw!;Zwx!Lcxz!;Zz{#-}{!P!;Z!P!Q#/d!Q!^!;Z!^!_#(i!_!`#7S!`!a#8i!a!}!;Z!}#O#,f#O#P!Dy#P#o!;Z#o#p#(i#p;'S!;Z;'S;=`#-w<%lO!;Z?O!;fb$h&j(Rp(U!b!U7`OY!;ZYZ&cZr!;Zrs!<nsw!;Zwx!Lcx!P!;Z!P!Q#&`!Q!^!;Z!^!_#(i!_!}!;Z!}#O#,f#O#P!Dy#P#o!;Z#o#p#(i#p;'S!;Z;'S;=`#-w<%lO!;Z>^!<w`$h&j(U!b!U7`OY!<nYZ&cZw!<nwx!=yx!P!<n!P!Q!Eq!Q!^!<n!^!_!Gr!_!}!<n!}#O!KS#O#P!Dy#P#o!<n#o#p!Gr#p;'S!<n;'S;=`!L]<%lO!<n<z!>Q^$h&j!U7`OY!=yYZ&cZ!P!=y!P!Q!>|!Q!^!=y!^!_!@c!_!}!=y!}#O!CW#O#P!Dy#P#o!=y#o#p!@c#p;'S!=y;'S;=`!Ek<%lO!=y<z!?Td$h&j!U7`O!^&c!_#W&c#W#X!>|#X#Z&c#Z#[!>|#[#]&c#]#^!>|#^#a&c#a#b!>|#b#g&c#g#h!>|#h#i&c#i#j!>|#j#k!>|#k#m&c#m#n!>|#n#o&c#p;'S&c;'S;=`&w<%lO&c7`!@hX!U7`OY!@cZ!P!@c!P!Q!AT!Q!}!@c!}#O!Ar#O#P!Bq#P;'S!@c;'S;=`!CQ<%lO!@c7`!AYW!U7`#W#X!AT#Z#[!AT#]#^!AT#a#b!AT#g#h!AT#i#j!AT#j#k!AT#m#n!AT7`!AuVOY!ArZ#O!Ar#O#P!B[#P#Q!@c#Q;'S!Ar;'S;=`!Bk<%lO!Ar7`!B_SOY!ArZ;'S!Ar;'S;=`!Bk<%lO!Ar7`!BnP;=`<%l!Ar7`!BtSOY!@cZ;'S!@c;'S;=`!CQ<%lO!@c7`!CTP;=`<%l!@c<z!C][$h&jOY!CWYZ&cZ!^!CW!^!_!Ar!_#O!CW#O#P!DR#P#Q!=y#Q#o!CW#o#p!Ar#p;'S!CW;'S;=`!Ds<%lO!CW<z!DWX$h&jOY!CWYZ&cZ!^!CW!^!_!Ar!_#o!CW#o#p!Ar#p;'S!CW;'S;=`!Ds<%lO!CW<z!DvP;=`<%l!CW<z!EOX$h&jOY!=yYZ&cZ!^!=y!^!_!@c!_#o!=y#o#p!@c#p;'S!=y;'S;=`!Ek<%lO!=y<z!EnP;=`<%l!=y>^!Ezl$h&j(U!b!U7`OY&}YZ&cZw&}wx&cx!^&}!^!_'}!_#O&}#O#P&c#P#W&}#W#X!Eq#X#Z&}#Z#[!Eq#[#]&}#]#^!Eq#^#a&}#a#b!Eq#b#g&}#g#h!Eq#h#i&}#i#j!Eq#j#k!Eq#k#m&}#m#n!Eq#n#o&}#o#p'}#p;'S&};'S;=`(l<%lO&}8r!GyZ(U!b!U7`OY!GrZw!Grwx!@cx!P!Gr!P!Q!Hl!Q!}!Gr!}#O!JU#O#P!Bq#P;'S!Gr;'S;=`!J|<%lO!Gr8r!Hse(U!b!U7`OY'}Zw'}x#O'}#P#W'}#W#X!Hl#X#Z'}#Z#[!Hl#[#]'}#]#^!Hl#^#a'}#a#b!Hl#b#g'}#g#h!Hl#h#i'}#i#j!Hl#j#k!Hl#k#m'}#m#n!Hl#n;'S'};'S;=`(f<%lO'}8r!JZX(U!bOY!JUZw!JUwx!Arx#O!JU#O#P!B[#P#Q!Gr#Q;'S!JU;'S;=`!Jv<%lO!JU8r!JyP;=`<%l!JU8r!KPP;=`<%l!Gr>^!KZ^$h&j(U!bOY!KSYZ&cZw!KSwx!CWx!^!KS!^!_!JU!_#O!KS#O#P!DR#P#Q!<n#Q#o!KS#o#p!JU#p;'S!KS;'S;=`!LV<%lO!KS>^!LYP;=`<%l!KS>^!L`P;=`<%l!<n=l!Ll`$h&j(Rp!U7`OY!LcYZ&cZr!Lcrs!=ys!P!Lc!P!Q!Mn!Q!^!Lc!^!_# o!_!}!Lc!}#O#%P#O#P!Dy#P#o!Lc#o#p# o#p;'S!Lc;'S;=`#&Y<%lO!Lc=l!Mwl$h&j(Rp!U7`OY(rYZ&cZr(rrs&cs!^(r!^!_)r!_#O(r#O#P&c#P#W(r#W#X!Mn#X#Z(r#Z#[!Mn#[#](r#]#^!Mn#^#a(r#a#b!Mn#b#g(r#g#h!Mn#h#i(r#i#j!Mn#j#k!Mn#k#m(r#m#n!Mn#n#o(r#o#p)r#p;'S(r;'S;=`*a<%lO(r8Q# vZ(Rp!U7`OY# oZr# ors!@cs!P# o!P!Q#!i!Q!}# o!}#O#$R#O#P!Bq#P;'S# o;'S;=`#$y<%lO# o8Q#!pe(Rp!U7`OY)rZr)rs#O)r#P#W)r#W#X#!i#X#Z)r#Z#[#!i#[#])r#]#^#!i#^#a)r#a#b#!i#b#g)r#g#h#!i#h#i)r#i#j#!i#j#k#!i#k#m)r#m#n#!i#n;'S)r;'S;=`*Z<%lO)r8Q#$WX(RpOY#$RZr#$Rrs!Ars#O#$R#O#P!B[#P#Q# o#Q;'S#$R;'S;=`#$s<%lO#$R8Q#$vP;=`<%l#$R8Q#$|P;=`<%l# o=l#%W^$h&j(RpOY#%PYZ&cZr#%Prs!CWs!^#%P!^!_#$R!_#O#%P#O#P!DR#P#Q!Lc#Q#o#%P#o#p#$R#p;'S#%P;'S;=`#&S<%lO#%P=l#&VP;=`<%l#%P=l#&]P;=`<%l!Lc?O#&kn$h&j(Rp(U!b!U7`OY%ZYZ&cZr%Zrs&}sw%Zwx(rx!^%Z!^!_*g!_#O%Z#O#P&c#P#W%Z#W#X#&`#X#Z%Z#Z#[#&`#[#]%Z#]#^#&`#^#a%Z#a#b#&`#b#g%Z#g#h#&`#h#i%Z#i#j#&`#j#k#&`#k#m%Z#m#n#&`#n#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z9d#(r](Rp(U!b!U7`OY#(iZr#(irs!Grsw#(iwx# ox!P#(i!P!Q#)k!Q!}#(i!}#O#+`#O#P!Bq#P;'S#(i;'S;=`#,`<%lO#(i9d#)th(Rp(U!b!U7`OY*gZr*grs'}sw*gwx)rx#O*g#P#W*g#W#X#)k#X#Z*g#Z#[#)k#[#]*g#]#^#)k#^#a*g#a#b#)k#b#g*g#g#h#)k#h#i*g#i#j#)k#j#k#)k#k#m*g#m#n#)k#n;'S*g;'S;=`+Z<%lO*g9d#+gZ(Rp(U!bOY#+`Zr#+`rs!JUsw#+`wx#$Rx#O#+`#O#P!B[#P#Q#(i#Q;'S#+`;'S;=`#,Y<%lO#+`9d#,]P;=`<%l#+`9d#,cP;=`<%l#(i?O#,o`$h&j(Rp(U!bOY#,fYZ&cZr#,frs!KSsw#,fwx#%Px!^#,f!^!_#+`!_#O#,f#O#P!DR#P#Q!;Z#Q#o#,f#o#p#+`#p;'S#,f;'S;=`#-q<%lO#,f?O#-tP;=`<%l#,f?O#-zP;=`<%l!;Z07[#.[b$h&j(Rp(U!b'y0/l!U7`OY!;ZYZ&cZr!;Zrs!<nsw!;Zwx!Lcx!P!;Z!P!Q#&`!Q!^!;Z!^!_#(i!_!}!;Z!}#O#,f#O#P!Dy#P#o!;Z#o#p#(i#p;'S!;Z;'S;=`#-w<%lO!;Z07[#/o_$h&j(Rp(U!bT0/lOY#/dYZ&cZr#/drs#0nsw#/dwx#4Ox!^#/d!^!_#5}!_#O#/d#O#P#1p#P#o#/d#o#p#5}#p;'S#/d;'S;=`#6|<%lO#/d06j#0w]$h&j(U!bT0/lOY#0nYZ&cZw#0nwx#1px!^#0n!^!_#3R!_#O#0n#O#P#1p#P#o#0n#o#p#3R#p;'S#0n;'S;=`#3x<%lO#0n05W#1wX$h&jT0/lOY#1pYZ&cZ!^#1p!^!_#2d!_#o#1p#o#p#2d#p;'S#1p;'S;=`#2{<%lO#1p0/l#2iST0/lOY#2dZ;'S#2d;'S;=`#2u<%lO#2d0/l#2xP;=`<%l#2d05W#3OP;=`<%l#1p01O#3YW(U!bT0/lOY#3RZw#3Rwx#2dx#O#3R#O#P#2d#P;'S#3R;'S;=`#3r<%lO#3R01O#3uP;=`<%l#3R06j#3{P;=`<%l#0n05x#4X]$h&j(RpT0/lOY#4OYZ&cZr#4Ors#1ps!^#4O!^!_#5Q!_#O#4O#O#P#1p#P#o#4O#o#p#5Q#p;'S#4O;'S;=`#5w<%lO#4O00^#5XW(RpT0/lOY#5QZr#5Qrs#2ds#O#5Q#O#P#2d#P;'S#5Q;'S;=`#5q<%lO#5Q00^#5tP;=`<%l#5Q05x#5zP;=`<%l#4O01p#6WY(Rp(U!bT0/lOY#5}Zr#5}rs#3Rsw#5}wx#5Qx#O#5}#O#P#2d#P;'S#5};'S;=`#6v<%lO#5}01p#6yP;=`<%l#5}07[#7PP;=`<%l#/d)3h#7ab$h&j$P(Ch(Rp(U!b!U7`OY!;ZYZ&cZr!;Zrs!<nsw!;Zwx!Lcx!P!;Z!P!Q#&`!Q!^!;Z!^!_#(i!_!}!;Z!}#O#,f#O#P!Dy#P#o!;Z#o#p#(i#p;'S!;Z;'S;=`#-w<%lO!;ZAt#8vb$Y#t$h&j(Rp(U!b!U7`OY!;ZYZ&cZr!;Zrs!<nsw!;Zwx!Lcx!P!;Z!P!Q#&`!Q!^!;Z!^!_#(i!_!}!;Z!}#O#,f#O#P!Dy#P#o!;Z#o#p#(i#p;'S!;Z;'S;=`#-w<%lO!;Z'Ad#:Zp$h&j(Rp(U!bp'9tOY%ZYZ&cZr%Zrs&}sw%Zwx(rx!O%Z!O!P!3Y!P!Q%Z!Q![#<_![!^%Z!^!_*g!_!g%Z!g!h!4|!h#O%Z#O#P&c#P#R%Z#R#S#<_#S#U%Z#U#V#?i#V#X%Z#X#Y!4|#Y#b%Z#b#c#>_#c#d#Bq#d#l%Z#l#m#Es#m#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z'Ad#<jk$h&j(Rp(U!bp'9tOY%ZYZ&cZr%Zrs&}sw%Zwx(rx!O%Z!O!P!3Y!P!Q%Z!Q![#<_![!^%Z!^!_*g!_!g%Z!g!h!4|!h#O%Z#O#P&c#P#R%Z#R#S#<_#S#X%Z#X#Y!4|#Y#b%Z#b#c#>_#c#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z'Ad#>j_$h&j(Rp(U!bp'9tOY%ZYZ&cZr%Zrs&}sw%Zwx(rx!^%Z!^!_*g!_#O%Z#O#P&c#P#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z'Ad#?rd$h&j(Rp(U!bOY%ZYZ&cZr%Zrs&}sw%Zwx(rx!Q%Z!Q!R#AQ!R!S#AQ!S!^%Z!^!_*g!_#O%Z#O#P&c#P#R%Z#R#S#AQ#S#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z'Ad#A]f$h&j(Rp(U!bp'9tOY%ZYZ&cZr%Zrs&}sw%Zwx(rx!Q%Z!Q!R#AQ!R!S#AQ!S!^%Z!^!_*g!_#O%Z#O#P&c#P#R%Z#R#S#AQ#S#b%Z#b#c#>_#c#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z'Ad#Bzc$h&j(Rp(U!bOY%ZYZ&cZr%Zrs&}sw%Zwx(rx!Q%Z!Q!Y#DV!Y!^%Z!^!_*g!_#O%Z#O#P&c#P#R%Z#R#S#DV#S#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z'Ad#Dbe$h&j(Rp(U!bp'9tOY%ZYZ&cZr%Zrs&}sw%Zwx(rx!Q%Z!Q!Y#DV!Y!^%Z!^!_*g!_#O%Z#O#P&c#P#R%Z#R#S#DV#S#b%Z#b#c#>_#c#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z'Ad#E|g$h&j(Rp(U!bOY%ZYZ&cZr%Zrs&}sw%Zwx(rx!Q%Z!Q![#Ge![!^%Z!^!_*g!_!c%Z!c!i#Ge!i#O%Z#O#P&c#P#R%Z#R#S#Ge#S#T%Z#T#Z#Ge#Z#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z'Ad#Gpi$h&j(Rp(U!bp'9tOY%ZYZ&cZr%Zrs&}sw%Zwx(rx!Q%Z!Q![#Ge![!^%Z!^!_*g!_!c%Z!c!i#Ge!i#O%Z#O#P&c#P#R%Z#R#S#Ge#S#T%Z#T#Z#Ge#Z#b%Z#b#c#>_#c#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z*)x#Il_!d$b$h&j#})Lv(Rp(U!bOY%ZYZ&cZr%Zrs&}sw%Zwx(rx!^%Z!^!_*g!_#O%Z#O#P&c#P#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z)[#Jv_al$h&j(Rp(U!bOY%ZYZ&cZr%Zrs&}sw%Zwx(rx!^%Z!^!_*g!_#O%Z#O#P&c#P#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z04f#LS^h#)`#O-<U(Rp(U!b(y7`OY*gZr*grs'}sw*gwx)rx!P*g!P!Q#MO!Q!^*g!^!_#Mt!_!`$ f!`#O*g#P;'S*g;'S;=`+Z<%lO*g(n#MXX$j&j(Rp(U!bOY*gZr*grs'}sw*gwx)rx#O*g#P;'S*g;'S;=`+Z<%lO*g(El#M}Z#o(Ch(Rp(U!bOY*gZr*grs'}sw*gwx)rx!_*g!_!`#Np!`#O*g#P;'S*g;'S;=`+Z<%lO*g(El#NyX$P(Ch(Rp(U!bOY*gZr*grs'}sw*gwx)rx#O*g#P;'S*g;'S;=`+Z<%lO*g(El$ oX#p(Ch(Rp(U!bOY*gZr*grs'}sw*gwx)rx#O*g#P;'S*g;'S;=`+Z<%lO*g*)x$!ga#]*!Y$h&j(Rp(U!bOY%ZYZ&cZr%Zrs&}sw%Zwx(rx!^%Z!^!_*g!_!`0z!`!a$#l!a#O%Z#O#P&c#P#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z(K[$#w_#h(Cl$h&j(Rp(U!bOY%ZYZ&cZr%Zrs&}sw%Zwx(rx!^%Z!^!_*g!_#O%Z#O#P&c#P#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z*)x$%Vag!*r#p(Ch$e#|$h&j(Rp(U!bOY%ZYZ&cZr%Zrs&}sw%Zwx(rx!^%Z!^!_*g!_!`$&[!`!a$'f!a#O%Z#O#P&c#P#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z(KW$&g_#p(Ch$h&j(Rp(U!bOY%ZYZ&cZr%Zrs&}sw%Zwx(rx!^%Z!^!_*g!_#O%Z#O#P&c#P#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z(KW$'qa#o(Ch$h&j(Rp(U!bOY%ZYZ&cZr%Zrs&}sw%Zwx(rx!^%Z!^!_*g!_!`Ka!`!a$(v!a#O%Z#O#P&c#P#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z(KW$)R`#o(Ch$h&j(Rp(U!bOY%ZYZ&cZr%Zrs&}sw%Zwx(rx!^%Z!^!_*g!_!`Ka!`#O%Z#O#P&c#P#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z(Kd$*`a(m(Ct$h&j(Rp(U!bOY%ZYZ&cZr%Zrs&}sw%Zwx(rx!^%Z!^!_*g!_!a%Z!a!b$+e!b#O%Z#O#P&c#P#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z(KW$+p`$h&j#z(Ch(Rp(U!bOY%ZYZ&cZr%Zrs&}sw%Zwx(rx!^%Z!^!_*g!_!`Ka!`#O%Z#O#P&c#P#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z%#`$,}_!y$Ip$h&j(Rp(U!bOY%ZYZ&cZr%Zrs&}sw%Zwx(rx!^%Z!^!_*g!_#O%Z#O#P&c#P#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z04f$.X_!P0,v$h&j(Rp(U!bOY%ZYZ&cZr%Zrs&}sw%Zwx(rx!^%Z!^!_*g!_#O%Z#O#P&c#P#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z(n$/]Z$h&jO!^$0O!^!_$0f!_#i$0O#i#j$0k#j#l$0O#l#m$2^#m#o$0O#o#p$0f#p;'S$0O;'S;=`$4i<%lO$0O(n$0VT_#S$h&jO!^&c!_#o&c#p;'S&c;'S;=`&w<%lO&c#S$0kO_#S(n$0p[$h&jO!Q&c!Q![$1f![!^&c!_!c&c!c!i$1f!i#T&c#T#Z$1f#Z#o&c#o#p$3|#p;'S&c;'S;=`&w<%lO&c(n$1kZ$h&jO!Q&c!Q![$2^![!^&c!_!c&c!c!i$2^!i#T&c#T#Z$2^#Z#o&c#p;'S&c;'S;=`&w<%lO&c(n$2cZ$h&jO!Q&c!Q![$3U![!^&c!_!c&c!c!i$3U!i#T&c#T#Z$3U#Z#o&c#p;'S&c;'S;=`&w<%lO&c(n$3ZZ$h&jO!Q&c!Q![$0O![!^&c!_!c&c!c!i$0O!i#T&c#T#Z$0O#Z#o&c#p;'S&c;'S;=`&w<%lO&c#S$4PR!Q![$4Y!c!i$4Y#T#Z$4Y#S$4]S!Q![$4Y!c!i$4Y#T#Z$4Y#q#r$0f(n$4lP;=`<%l$0O#1[$4z_!V#)l$h&j(Rp(U!bOY%ZYZ&cZr%Zrs&}sw%Zwx(rx!^%Z!^!_*g!_#O%Z#O#P&c#P#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z(KW$6U`#w(Ch$h&j(Rp(U!bOY%ZYZ&cZr%Zrs&}sw%Zwx(rx!^%Z!^!_*g!_!`Ka!`#O%Z#O#P&c#P#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z+;p$7c_$h&j(Rp(U!b([+4QOY%ZYZ&cZr%Zrs&}sw%Zwx(rx!^%Z!^!_*g!_#O%Z#O#P&c#P#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z07[$8qk$h&j(Rp(U!b(O,2j$^#t(`$I[OY%ZYZ&cZr%Zrs&}st%Ztu$8buw%Zwx(rx}%Z}!O$:f!O!Q%Z!Q![$8b![!^%Z!^!_*g!_!c%Z!c!}$8b!}#O%Z#O#P&c#P#R%Z#R#S$8b#S#T%Z#T#o$8b#o#p*g#p$g%Z$g;'S$8b;'S;=`$<l<%lO$8b+d$:qk$h&j(Rp(U!b$^#tOY%ZYZ&cZr%Zrs&}st%Ztu$:fuw%Zwx(rx}%Z}!O$:f!O!Q%Z!Q![$:f![!^%Z!^!_*g!_!c%Z!c!}$:f!}#O%Z#O#P&c#P#R%Z#R#S$:f#S#T%Z#T#o$:f#o#p*g#p$g%Z$g;'S$:f;'S;=`$<f<%lO$:f+d$<iP;=`<%l$:f07[$<oP;=`<%l$8b#Jf$<{X![#Hb(Rp(U!bOY*gZr*grs'}sw*gwx)rx#O*g#P;'S*g;'S;=`+Z<%lO*g,#x$=sa(t+JY$h&j(Rp(U!bOY%ZYZ&cZr%Zrs&}sw%Zwx(rx!^%Z!^!_*g!_!`Ka!`#O%Z#O#P&c#P#o%Z#o#p*g#p#q$+e#q;'S%Z;'S;=`+a<%lO%Z(Kd$?V_!Z(Cds`$h&j(Rp(U!bOY%ZYZ&cZr%Zrs&}sw%Zwx(rx!^%Z!^!_*g!_#O%Z#O#P&c#P#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z?O$@a_!n7`$h&j(Rp(U!bOY%ZYZ&cZr%Zrs&}sw%Zwx(rx!^%Z!^!_*g!_#O%Z#O#P&c#P#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z07[$Aq|$h&j(Rp(U!b'w0/l$[#t(O,2j(`$I[OX%ZXY+gYZ&cZ[+g[p%Zpq+gqr%Zrs&}st%ZtuEruw%Zwx(rx}%Z}!OGv!O!Q%Z!Q![Er![!^%Z!^!_*g!_!c%Z!c!}Er!}#O%Z#O#P&c#P#R%Z#R#SEr#S#T%Z#T#oEr#o#p*g#p$f%Z$f$g+g$g#BYEr#BY#BZ$A`#BZ$ISEr$IS$I_$A`$I_$JTEr$JT$JU$A`$JU$KVEr$KV$KW$A`$KW&FUEr&FU&FV$A`&FV;'SEr;'S;=`I|<%l?HTEr?HT?HU$A`?HUOEr07[$D|k$h&j(Rp(U!b'x0/l$[#t(O,2j(`$I[OY%ZYZ&cZr%Zrs&}st%ZtuEruw%Zwx(rx}%Z}!OGv!O!Q%Z!Q![Er![!^%Z!^!_*g!_!c%Z!c!}Er!}#O%Z#O#P&c#P#R%Z#R#SEr#S#T%Z#T#oEr#o#p*g#p$g%Z$g;'SEr;'S;=`I|<%lOEr",
        tokenizers: [ textareaTokens, scriptTokens, styleTokens, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, punctuation, new LocalTokenGroup("$S~RRtu[#O#Pg#S#T#|~_P#o#pb~gOu~~jVO#i!P#i#j!U#j#l!P#l#m!q#m;'S!P;'S;=`#v<%lO!P~!UO!R~~!XS!Q![!e!c!i!e#T#Z!e#o#p#Z~!hR!Q![!q!c!i!q#T#Z!q~!tR!Q![!}!c!i!}#T#Z!}~#QR!Q![!P!c!i!P#T#Z!P~#^R!Q![#g!c!i#g#T#Z#g~#jS!Q![#g!c!i#g#T#Z#g#q#r!P~#yP;=`<%l!P~$RO(^~~", 141, 335), new LocalTokenGroup("j~RQYZXz{^~^O'{~~aP!P!Qd~iO'|~~", 25, 318) ],
        topRules: {
            Script: [ 0, 7 ],
            SingleExpression: [ 1, 272 ],
            SingleClassItem: [ 2, 273 ]
        },
        dialects: {
            jsx: 0,
            ts: 14769
        },
        dynamicPrecedences: {
            77: 1,
            79: 1,
            91: 1,
            167: 1,
            196: 1
        },
        specialized: [ {
            term: 322,
            get: value => spec_identifier[value] || -1
        }, {
            term: 338,
            get: value => spec_word[value] || -1
        }, {
            term: 92,
            get: value => spec_LessThan[value] || -1
        } ],
        tokenPrec: 14793
    });
    const snippets = [ snippetCompletion("function ${name}(${params}) {\n\t${}\n}", {
        label: "function",
        detail: "definition",
        type: "keyword"
    }), snippetCompletion("for (let ${index} = 0; ${index} < ${bound}; ${index}++) {\n\t${}\n}", {
        label: "for",
        detail: "loop",
        type: "keyword"
    }), snippetCompletion("for (let ${name} of ${collection}) {\n\t${}\n}", {
        label: "for",
        detail: "of loop",
        type: "keyword"
    }), snippetCompletion("do {\n\t${}\n} while (${})", {
        label: "do",
        detail: "loop",
        type: "keyword"
    }), snippetCompletion("while (${}) {\n\t${}\n}", {
        label: "while",
        detail: "loop",
        type: "keyword"
    }), snippetCompletion("try {\n\t${}\n} catch (${error}) {\n\t${}\n}", {
        label: "try",
        detail: "/ catch block",
        type: "keyword"
    }), snippetCompletion("if (${}) {\n\t${}\n}", {
        label: "if",
        detail: "block",
        type: "keyword"
    }), snippetCompletion("if (${}) {\n\t${}\n} else {\n\t${}\n}", {
        label: "if",
        detail: "/ else block",
        type: "keyword"
    }), snippetCompletion("class ${name} {\n\tconstructor(${params}) {\n\t\t${}\n\t}\n}", {
        label: "class",
        detail: "definition",
        type: "keyword"
    }), snippetCompletion('import {${names}} from "${module}"\n${}', {
        label: "import",
        detail: "named",
        type: "keyword"
    }), snippetCompletion('import ${name} from "${module}"\n${}', {
        label: "import",
        detail: "default",
        type: "keyword"
    }) ], typescriptSnippets = snippets.concat([ snippetCompletion("interface ${name} {\n\t${}\n}", {
        label: "interface",
        detail: "definition",
        type: "keyword"
    }), snippetCompletion("type ${name} = ${type}", {
        label: "type",
        detail: "definition",
        type: "keyword"
    }), snippetCompletion("enum ${name} {\n\t${}\n}", {
        label: "enum",
        detail: "definition",
        type: "keyword"
    }) ]), cache = new NodeWeakMap(), ScopeNodes = new Set([ "Script", "Block", "FunctionExpression", "FunctionDeclaration", "ArrowFunction", "MethodDeclaration", "ForStatement" ]);
    function defID(type) {
        return (node, def) => {
            node = node.node.getChild("VariableDefinition");
            return node && def(node, type), !0;
        };
    }
    const functionContext = [ "FunctionDeclaration" ], gatherCompletions = {
        FunctionDeclaration: defID("function"),
        ClassDeclaration: defID("class"),
        ClassExpression: () => !0,
        EnumDeclaration: defID("constant"),
        TypeAliasDeclaration: defID("type"),
        NamespaceDeclaration: defID("namespace"),
        VariableDefinition(node, def) {
            node.matchContext(functionContext) || def(node, "variable");
        },
        TypeDefinition(node, def) {
            def(node, "type");
        },
        __proto__: null
    };
    const Identifier = /^[\w$\xa1-\uffff][\w$\d\xa1-\uffff]*$/, dontComplete = [ "TemplateString", "String", "RegExp", "LineComment", "BlockComment", "VariableDefinition", "TypeDefinition", "Label", "PropertyDefinition", "PropertyName", "PrivatePropertyDefinition", "PrivatePropertyName", ".", "?." ];
    function localCompletionSource(context) {
        var inner = syntaxTree(context.state).resolveInner(context.pos, -1);
        if (-1 < dontComplete.indexOf(inner.name)) return null;
        var isWord = "VariableName" == inner.name || inner.to - inner.from < 20 && Identifier.test(context.state.sliceDoc(inner.from, inner.to));
        if (!isWord && !context.explicit) return null;
        let options = [];
        for (let pos = inner; pos; pos = pos.parent) ScopeNodes.has(pos.name) && (options = options.concat(function getScope(doc, node) {
            var cached = cache.get(node);
            if (cached) return cached;
            let completions = [], top = !0;
            function def(node, type) {
                node = doc.sliceString(node.from, node.to), completions.push({
                    label: node,
                    type: type
                });
            }
            return node.cursor(IterMode.IncludeAnonymous).iterate(node => {
                if (top) top = !1; else if (node.name) {
                    var gather = gatherCompletions[node.name];
                    if (gather && gather(node, def) || ScopeNodes.has(node.name)) return !1;
                } else if (8192 < node.to - node.from) {
                    for (var c of getScope(doc, node.node)) completions.push(c);
                    return !1;
                }
            }), cache.set(node, completions), completions;
        }(context.state.doc, pos)));
        return {
            options: options,
            from: isWord ? inner.from : context.pos,
            validFor: Identifier
        };
    }
    const javascriptLanguage = LRLanguage.define({
        name: "javascript",
        parser: endTag.configure({
            props: [ indentNodeProp.add({
                IfStatement: continuedIndent({
                    except: /^\s*({|else\b)/
                }),
                TryStatement: continuedIndent({
                    except: /^\s*({|catch\b|finally\b)/
                }),
                LabeledStatement: context => context.baseIndent,
                SwitchBody: context => {
                    var after = context.textAfter, closed = /^\s*\}/.test(after), after = /^\s*(case|default)\b/.test(after);
                    return context.baseIndent + (closed ? 0 : after ? 1 : 2) * context.unit;
                },
                Block: delimitedIndent({
                    closing: "}"
                }),
                ArrowFunction: cx => cx.baseIndent + cx.unit,
                "TemplateString BlockComment": () => null,
                "Statement Property": continuedIndent({
                    except: /^{/
                }),
                JSXElement(context) {
                    var closed = /^\s*<\//.test(context.textAfter);
                    return context.lineIndent(context.node.from) + (closed ? 0 : context.unit);
                },
                JSXEscape(context) {
                    var closed = /\s*\}/.test(context.textAfter);
                    return context.lineIndent(context.node.from) + (closed ? 0 : context.unit);
                },
                "JSXOpenTag JSXSelfClosingTag"(context) {
                    return context.column(context.node.from) + context.unit;
                }
            }), foldNodeProp.add({
                "Block ClassBody SwitchBody EnumBody ObjectExpression ArrayExpression ObjectType": foldInside,
                BlockComment(tree) {
                    return {
                        from: tree.from + 2,
                        to: tree.to - 2
                    };
                }
            }) ]
        }),
        languageData: {
            closeBrackets: {
                brackets: [ "(", "[", "{", "'", '"', "`" ]
            },
            commentTokens: {
                line: "//",
                block: {
                    open: "/*",
                    close: "*/"
                }
            },
            indentOnInput: /^\s*(?:case |default:|\{|\}|<\/)$/,
            wordChars: "$"
        }
    }), jsxSublanguage = {
        test: node => /^JSX/.test(node.name),
        facet: defineLanguageFacet({
            commentTokens: {
                block: {
                    open: "{/*",
                    close: "*/}"
                }
            }
        })
    }, typescriptLanguage = javascriptLanguage.configure({
        dialect: "ts"
    }, "typescript"), jsxLanguage = javascriptLanguage.configure({
        dialect: "jsx",
        props: [ sublanguageProp.add(n => n.isTop ? [ jsxSublanguage ] : void 0) ]
    }), tsxLanguage = javascriptLanguage.configure({
        dialect: "jsx ts",
        props: [ sublanguageProp.add(n => n.isTop ? [ jsxSublanguage ] : void 0) ]
    }, "typescript");
    cursorDocStart = name => ({
        label: name,
        type: "keyword"
    });
    const keywords$1 = "break case const continue default delete export extends false finally in instanceof let new return static super switch this throw true typeof var yield".split(" ").map(cursorDocStart), typescriptKeywords = keywords$1.concat([ "declare", "implements", "private", "protected", "public" ].map(cursorDocStart));
    function javascript(config = {}) {
        var nodes, source, lang = config.jsx ? config.typescript ? tsxLanguage : jsxLanguage : config.typescript ? typescriptLanguage : javascriptLanguage, completions = config.typescript ? typescriptSnippets.concat(typescriptKeywords) : snippets.concat(keywords$1);
        return new LanguageSupport(lang, [ javascriptLanguage.data.of({
            autocomplete: (nodes = dontComplete, source = completeFromList(completions), 
            context => {
                for (let pos = syntaxTree(context.state).resolveInner(context.pos, -1); pos; pos = pos.parent) {
                    if (-1 < nodes.indexOf(pos.name)) return null;
                    if (pos.type.isTop) break;
                }
                return source(context);
            })
        }), javascriptLanguage.data.of({
            autocomplete: localCompletionSource
        }), config.jsx ? autoCloseTags$1 : [] ]);
    }
    function elementName$1(doc, tree, max = doc.length) {
        for (let ch = null == tree ? void 0 : tree.firstChild; ch; ch = ch.nextSibling) if ("JSXIdentifier" == ch.name || "JSXBuiltin" == ch.name || "JSXNamespacedName" == ch.name || "JSXMemberExpression" == ch.name) return doc.sliceString(ch.from, Math.min(ch.to, max));
        return "";
    }
    const android = "object" == typeof navigator && /Android\b/.test(navigator.userAgent), autoCloseTags$1 = EditorView.inputHandler.of((view, from, to, text, defaultInsert) => {
        if ((android ? view.composing : view.compositionStarted) || view.state.readOnly || from != to || ">" != text && "/" != text || !javascriptLanguage.isActiveAt(view.state, from, -1)) return !1;
        let base = defaultInsert(), state = base["state"];
        to = state.changeByRange(range => {
            let head = range["head"], around = syntaxTree(state).resolveInner(head - 1, -1), name;
            if ("JSXStartTag" == around.name && (around = around.parent), !(state.doc.sliceString(head - 1, head) != text || "JSXAttributeValue" == around.name && around.to > head)) {
                if (">" == text && "JSXFragmentTag" == around.name) return {
                    range: range,
                    changes: {
                        from: head,
                        insert: "</>"
                    }
                };
                if ("/" == text && "JSXStartCloseTag" == around.name) {
                    var empty = around.parent, base = empty.parent;
                    if (base && empty.from == head - 2 && ((name = elementName$1(state.doc, base.firstChild, head)) || "JSXFragmentTag" == (null == (empty = base.firstChild) ? void 0 : empty.name))) return base = name + ">", 
                    {
                        range: EditorSelection.cursor(head + base.length, -1),
                        changes: {
                            from: head,
                            insert: base
                        }
                    };
                } else if (">" == text) {
                    empty = function(node) {
                        for (;;) {
                            if ("JSXOpenTag" == node.name || "JSXSelfClosingTag" == node.name || "JSXFragmentTag" == node.name) return node;
                            if ("JSXEscape" == node.name || !node.parent) return null;
                            node = node.parent;
                        }
                    }(around);
                    if (empty && "JSXOpenTag" == empty.name && !/^\/?>|^<\//.test(state.doc.sliceString(head, head + 2)) && (name = elementName$1(state.doc, empty, head))) return {
                        range: range,
                        changes: {
                            from: head,
                            insert: `</${name}>`
                        }
                    };
                }
            }
            return {
                range: range
            };
        });
        return !to.changes.empty && (view.dispatch([ base, state.update(to, {
            userEvent: "input.complete",
            scrollIntoView: !0
        }) ]), !0);
    });
    htmlHighlighting = [ "_blank", "_self", "_top", "_parent" ], textareaTokens = [ "ascii", "utf-8", "utf-16", "latin1", "latin1" ], 
    scriptTokens = [ "get", "post", "put", "delete" ], styleTokens = [ "application/x-www-form-urlencoded", "multipart/form-data", "text/plain" ], 
    punctuation = [ "true", "false" ], endTag = {};
    const Tags = {
        a: {
            attrs: {
                href: null,
                ping: null,
                type: null,
                media: null,
                target: htmlHighlighting,
                hreflang: null
            }
        },
        abbr: endTag,
        address: endTag,
        area: {
            attrs: {
                alt: null,
                coords: null,
                href: null,
                target: null,
                ping: null,
                media: null,
                hreflang: null,
                type: null,
                shape: [ "default", "rect", "circle", "poly" ]
            }
        },
        article: endTag,
        aside: endTag,
        audio: {
            attrs: {
                src: null,
                mediagroup: null,
                crossorigin: [ "anonymous", "use-credentials" ],
                preload: [ "none", "metadata", "auto" ],
                autoplay: [ "autoplay" ],
                loop: [ "loop" ],
                controls: [ "controls" ]
            }
        },
        b: endTag,
        base: {
            attrs: {
                href: null,
                target: htmlHighlighting
            }
        },
        bdi: endTag,
        bdo: endTag,
        blockquote: {
            attrs: {
                cite: null
            }
        },
        body: endTag,
        br: endTag,
        button: {
            attrs: {
                form: null,
                formaction: null,
                name: null,
                value: null,
                autofocus: [ "autofocus" ],
                disabled: [ "autofocus" ],
                formenctype: styleTokens,
                formmethod: scriptTokens,
                formnovalidate: [ "novalidate" ],
                formtarget: htmlHighlighting,
                type: [ "submit", "reset", "button" ]
            }
        },
        canvas: {
            attrs: {
                width: null,
                height: null
            }
        },
        caption: endTag,
        center: endTag,
        cite: endTag,
        code: endTag,
        col: {
            attrs: {
                span: null
            }
        },
        colgroup: {
            attrs: {
                span: null
            }
        },
        command: {
            attrs: {
                type: [ "command", "checkbox", "radio" ],
                label: null,
                icon: null,
                radiogroup: null,
                command: null,
                title: null,
                disabled: [ "disabled" ],
                checked: [ "checked" ]
            }
        },
        data: {
            attrs: {
                value: null
            }
        },
        datagrid: {
            attrs: {
                disabled: [ "disabled" ],
                multiple: [ "multiple" ]
            }
        },
        datalist: {
            attrs: {
                data: null
            }
        },
        dd: endTag,
        del: {
            attrs: {
                cite: null,
                datetime: null
            }
        },
        details: {
            attrs: {
                open: [ "open" ]
            }
        },
        dfn: endTag,
        div: endTag,
        dl: endTag,
        dt: endTag,
        em: endTag,
        embed: {
            attrs: {
                src: null,
                type: null,
                width: null,
                height: null
            }
        },
        eventsource: {
            attrs: {
                src: null
            }
        },
        fieldset: {
            attrs: {
                disabled: [ "disabled" ],
                form: null,
                name: null
            }
        },
        figcaption: endTag,
        figure: endTag,
        footer: endTag,
        form: {
            attrs: {
                action: null,
                name: null,
                "accept-charset": textareaTokens,
                autocomplete: [ "on", "off" ],
                enctype: styleTokens,
                method: scriptTokens,
                novalidate: [ "novalidate" ],
                target: htmlHighlighting
            }
        },
        h1: endTag,
        h2: endTag,
        h3: endTag,
        h4: endTag,
        h5: endTag,
        h6: endTag,
        head: {
            children: [ "title", "base", "link", "style", "meta", "script", "noscript", "command" ]
        },
        header: endTag,
        hgroup: endTag,
        hr: endTag,
        html: {
            attrs: {
                manifest: null
            }
        },
        i: endTag,
        iframe: {
            attrs: {
                src: null,
                srcdoc: null,
                name: null,
                width: null,
                height: null,
                sandbox: [ "allow-top-navigation", "allow-same-origin", "allow-forms", "allow-scripts" ],
                seamless: [ "seamless" ]
            }
        },
        img: {
            attrs: {
                alt: null,
                src: null,
                ismap: null,
                usemap: null,
                width: null,
                height: null,
                crossorigin: [ "anonymous", "use-credentials" ]
            }
        },
        input: {
            attrs: {
                alt: null,
                dirname: null,
                form: null,
                formaction: null,
                height: null,
                list: null,
                max: null,
                maxlength: null,
                min: null,
                name: null,
                pattern: null,
                placeholder: null,
                size: null,
                src: null,
                step: null,
                value: null,
                width: null,
                accept: [ "audio/*", "video/*", "image/*" ],
                autocomplete: [ "on", "off" ],
                autofocus: [ "autofocus" ],
                checked: [ "checked" ],
                disabled: [ "disabled" ],
                formenctype: styleTokens,
                formmethod: scriptTokens,
                formnovalidate: [ "novalidate" ],
                formtarget: htmlHighlighting,
                multiple: [ "multiple" ],
                readonly: [ "readonly" ],
                required: [ "required" ],
                type: [ "hidden", "text", "search", "tel", "url", "email", "password", "datetime", "date", "month", "week", "time", "datetime-local", "number", "range", "color", "checkbox", "radio", "file", "submit", "image", "reset", "button" ]
            }
        },
        ins: {
            attrs: {
                cite: null,
                datetime: null
            }
        },
        kbd: endTag,
        keygen: {
            attrs: {
                challenge: null,
                form: null,
                name: null,
                autofocus: [ "autofocus" ],
                disabled: [ "disabled" ],
                keytype: [ "RSA" ]
            }
        },
        label: {
            attrs: {
                for: null,
                form: null
            }
        },
        legend: endTag,
        li: {
            attrs: {
                value: null
            }
        },
        link: {
            attrs: {
                href: null,
                type: null,
                hreflang: null,
                media: null,
                sizes: [ "all", "16x16", "16x16 32x32", "16x16 32x32 64x64" ]
            }
        },
        map: {
            attrs: {
                name: null
            }
        },
        mark: endTag,
        menu: {
            attrs: {
                label: null,
                type: [ "list", "context", "toolbar" ]
            }
        },
        meta: {
            attrs: {
                content: null,
                charset: textareaTokens,
                name: [ "viewport", "application-name", "author", "description", "generator", "keywords" ],
                "http-equiv": [ "content-language", "content-type", "default-style", "refresh" ]
            }
        },
        meter: {
            attrs: {
                value: null,
                min: null,
                low: null,
                high: null,
                max: null,
                optimum: null
            }
        },
        nav: endTag,
        noscript: endTag,
        object: {
            attrs: {
                data: null,
                type: null,
                name: null,
                usemap: null,
                form: null,
                width: null,
                height: null,
                typemustmatch: [ "typemustmatch" ]
            }
        },
        ol: {
            attrs: {
                reversed: [ "reversed" ],
                start: null,
                type: [ "1", "a", "A", "i", "I" ]
            },
            children: [ "li", "script", "template", "ul", "ol" ]
        },
        optgroup: {
            attrs: {
                disabled: [ "disabled" ],
                label: null
            }
        },
        option: {
            attrs: {
                disabled: [ "disabled" ],
                label: null,
                selected: [ "selected" ],
                value: null
            }
        },
        output: {
            attrs: {
                for: null,
                form: null,
                name: null
            }
        },
        p: endTag,
        param: {
            attrs: {
                name: null,
                value: null
            }
        },
        pre: endTag,
        progress: {
            attrs: {
                value: null,
                max: null
            }
        },
        q: {
            attrs: {
                cite: null
            }
        },
        rp: endTag,
        rt: endTag,
        ruby: endTag,
        samp: endTag,
        script: {
            attrs: {
                type: [ "text/javascript" ],
                src: null,
                async: [ "async" ],
                defer: [ "defer" ],
                charset: textareaTokens
            }
        },
        section: endTag,
        select: {
            attrs: {
                form: null,
                name: null,
                size: null,
                autofocus: [ "autofocus" ],
                disabled: [ "disabled" ],
                multiple: [ "multiple" ]
            }
        },
        slot: {
            attrs: {
                name: null
            }
        },
        small: endTag,
        source: {
            attrs: {
                src: null,
                type: null,
                media: null
            }
        },
        span: endTag,
        strong: endTag,
        style: {
            attrs: {
                type: [ "text/css" ],
                media: null,
                scoped: null
            }
        },
        sub: endTag,
        summary: endTag,
        sup: endTag,
        table: endTag,
        tbody: endTag,
        td: {
            attrs: {
                colspan: null,
                rowspan: null,
                headers: null
            }
        },
        template: endTag,
        textarea: {
            attrs: {
                dirname: null,
                form: null,
                maxlength: null,
                name: null,
                placeholder: null,
                rows: null,
                cols: null,
                autofocus: [ "autofocus" ],
                disabled: [ "disabled" ],
                readonly: [ "readonly" ],
                required: [ "required" ],
                wrap: [ "soft", "hard" ]
            }
        },
        tfoot: endTag,
        th: {
            attrs: {
                colspan: null,
                rowspan: null,
                headers: null,
                scope: [ "row", "col", "rowgroup", "colgroup" ]
            }
        },
        thead: endTag,
        time: {
            attrs: {
                datetime: null
            }
        },
        title: endTag,
        tr: endTag,
        track: {
            attrs: {
                src: null,
                label: null,
                default: null,
                kind: [ "subtitles", "captions", "descriptions", "chapters", "metadata" ],
                srclang: null
            }
        },
        ul: {
            children: [ "li", "script", "template", "ul", "ol" ]
        },
        var: endTag,
        video: {
            attrs: {
                src: null,
                poster: null,
                width: null,
                height: null,
                crossorigin: [ "anonymous", "use-credentials" ],
                preload: [ "auto", "metadata", "none" ],
                autoplay: [ "autoplay" ],
                mediagroup: [ "movie" ],
                muted: [ "muted" ],
                controls: [ "controls" ]
            }
        },
        wbr: endTag
    }, GlobalAttrs = {
        accesskey: null,
        class: null,
        contenteditable: punctuation,
        contextmenu: null,
        dir: [ "ltr", "rtl", "auto" ],
        draggable: [ "true", "false", "auto" ],
        dropzone: [ "copy", "move", "link", "string:", "file:" ],
        hidden: [ "hidden" ],
        id: null,
        inert: [ "inert" ],
        itemid: null,
        itemprop: null,
        itemref: null,
        itemscope: [ "itemscope" ],
        itemtype: null,
        lang: [ "ar", "bn", "de", "en-GB", "en-US", "es", "fr", "hi", "id", "ja", "pa", "pt", "ru", "tr", "zh" ],
        spellcheck: punctuation,
        autocorrect: punctuation,
        autocapitalize: punctuation,
        style: null,
        tabindex: null,
        title: null,
        translate: [ "yes", "no" ],
        rel: [ "stylesheet", "alternate", "author", "bookmark", "help", "license", "next", "nofollow", "noreferrer", "prefetch", "prev", "search", "tag" ],
        role: "alert application article banner button cell checkbox complementary contentinfo dialog document feed figure form grid gridcell heading img list listbox listitem main navigation region row rowgroup search switch tab table tabpanel textbox timer".split(" "),
        "aria-activedescendant": null,
        "aria-atomic": punctuation,
        "aria-autocomplete": [ "inline", "list", "both", "none" ],
        "aria-busy": punctuation,
        "aria-checked": [ "true", "false", "mixed", "undefined" ],
        "aria-controls": null,
        "aria-describedby": null,
        "aria-disabled": punctuation,
        "aria-dropeffect": null,
        "aria-expanded": [ "true", "false", "undefined" ],
        "aria-flowto": null,
        "aria-grabbed": [ "true", "false", "undefined" ],
        "aria-haspopup": punctuation,
        "aria-hidden": punctuation,
        "aria-invalid": [ "true", "false", "grammar", "spelling" ],
        "aria-label": null,
        "aria-labelledby": null,
        "aria-level": null,
        "aria-live": [ "off", "polite", "assertive" ],
        "aria-multiline": punctuation,
        "aria-multiselectable": punctuation,
        "aria-owns": null,
        "aria-posinset": null,
        "aria-pressed": [ "true", "false", "mixed", "undefined" ],
        "aria-readonly": punctuation,
        "aria-relevant": null,
        "aria-required": punctuation,
        "aria-selected": [ "true", "false", "undefined" ],
        "aria-setsize": null,
        "aria-sort": [ "ascending", "descending", "none", "other" ],
        "aria-valuemax": null,
        "aria-valuemin": null,
        "aria-valuenow": null,
        "aria-valuetext": null
    };
    var a, cursorDocStart = "beforeunload copy cut dragstart dragover dragleave dragenter dragend drag paste focus blur change click load mousedown mouseenter mouseleave mouseup keydown keyup resize scroll unload".split(" ").map(n => "on" + n);
    for (a of cursorDocStart) GlobalAttrs[a] = null;
    class Schema {
        constructor(extraTags, extraAttrs) {
            this.tags = Object.assign(Object.assign({}, Tags), extraTags), this.globalAttrs = Object.assign(Object.assign({}, GlobalAttrs), extraAttrs), 
            this.allTags = Object.keys(this.tags), this.globalAttrNames = Object.keys(this.globalAttrs);
        }
    }
    function elementName(doc, tree, max = doc.length) {
        return (tree = (tree = tree && tree.firstChild) && tree.getChild("TagName")) ? doc.sliceString(tree.from, Math.min(tree.to, max)) : "";
    }
    function findParentElement(tree, skip = !1) {
        for (;tree; tree = tree.parent) if ("Element" == tree.name) {
            if (!skip) return tree;
            skip = !1;
        }
        return null;
    }
    function allowedChildren(doc, tree, schema) {
        doc = schema.tags[elementName(doc, findParentElement(tree))];
        return (null == doc ? void 0 : doc.children) || schema.allTags;
    }
    function openTags(doc, tree) {
        var open = [];
        for (let parent = findParentElement(tree); parent && !parent.type.isTop; parent = findParentElement(parent.parent)) {
            var tagName = elementName(doc, parent);
            if (tagName && "CloseTag" == parent.lastChild.name) break;
            tagName && open.indexOf(tagName) < 0 && ("EndTag" == tree.name || tree.from >= parent.firstChild.to) && open.push(tagName);
        }
        return open;
    }
    Schema.default = new Schema();
    const identifier = /^[:\-\.\w\u00b7-\uffff]*$/;
    function completeTag(state, schema, tree, from, to) {
        let end = /\s*>/.test(state.sliceDoc(to, to + 5)) ? "" : ">";
        var parent = findParentElement(tree, !0);
        return {
            from: from,
            to: to,
            options: allowedChildren(state.doc, parent, schema).map(tagName => ({
                label: tagName,
                type: "type"
            })).concat(openTags(state.doc, tree).map((tag, i) => ({
                label: "/" + tag,
                apply: "/" + tag + end,
                type: "type",
                boost: 99 - i
            }))),
            validFor: /^\/?[:\-\.\w\u00b7-\uffff]*$/
        };
    }
    function completeCloseTag(state, tree, from, to) {
        let end = /\s*>/.test(state.sliceDoc(to, to + 5)) ? "" : ">";
        return {
            from: from,
            to: to,
            options: openTags(state.doc, tree).map((tag, i) => ({
                label: tag,
                apply: tag + end,
                type: "type",
                boost: 99 - i
            })),
            validFor: identifier
        };
    }
    function htmlCompletionFor(schema, context) {
        let {
            state,
            pos
        } = context, tree = syntaxTree(state).resolveInner(pos, -1), around = tree.resolve(pos);
        for (let scan = pos, before; around == tree && (before = tree.childBefore(scan)); ) {
            var last = before.lastChild;
            if (!last || !last.type.isError || last.from < last.to) break;
            around = tree = before, scan = last.from;
        }
        return "TagName" == tree.name ? tree.parent && /CloseTag$/.test(tree.parent.name) ? completeCloseTag(state, tree, tree.from, pos) : completeTag(state, schema, tree, tree.from, pos) : "StartTag" == tree.name ? completeTag(state, schema, tree, pos, pos) : "StartCloseTag" == tree.name || "IncompleteCloseTag" == tree.name ? completeCloseTag(state, tree, pos, pos) : "OpenTag" == tree.name || "SelfClosingTag" == tree.name || "AttributeName" == tree.name ? function(state, schema, tree, from, to) {
            return tree = findParentElement(tree), state = tree ? schema.tags[elementName(state.doc, tree)] : null, 
            tree = state && state.attrs ? Object.keys(state.attrs) : [], {
                from: from,
                to: to,
                options: (state && !1 === state.globalAttrs ? tree : tree.length ? tree.concat(schema.globalAttrNames) : schema.globalAttrNames).map(attrName => ({
                    label: attrName,
                    type: "property"
                })),
                validFor: identifier
            };
        }(state, schema, tree, "AttributeName" == tree.name ? tree.from : pos, pos) : "Is" == tree.name || "AttributeValue" == tree.name || "UnquotedAttributeValue" == tree.name ? function(state, schema, tree, from, to) {
            var _a = null == (_a = tree.parent) ? void 0 : _a.getChild("AttributeName");
            let options = [], token = void 0;
            if (_a) {
                _a = state.sliceDoc(_a.from, _a.to);
                let attrs = schema.globalAttrs[_a];
                if (attrs || (schema = (tree = findParentElement(tree)) ? schema.tags[elementName(state.doc, tree)] : null, 
                attrs = (null == schema ? void 0 : schema.attrs) && schema.attrs[_a]), 
                attrs) {
                    let base = state.sliceDoc(from, to).toLowerCase(), quoteStart = '"', quoteEnd = '"';
                    /^['"]/.test(base) ? (token = '"' == base[0] ? /^[^"]*$/ : /^[^']*$/, 
                    quoteStart = "", quoteEnd = state.sliceDoc(to, to + 1) == base[0] ? "" : base[0], 
                    base = base.slice(1), from++) : token = /^[^\s<>='"]*$/;
                    for (var value of attrs) options.push({
                        label: value,
                        apply: quoteStart + value + quoteEnd,
                        type: "constant"
                    });
                }
            }
            return {
                from: from,
                to: to,
                options: options,
                validFor: token
            };
        }(state, schema, tree, "Is" == tree.name ? pos : tree.from, pos) : !context.explicit || "Element" != around.name && "Text" != around.name && "Document" != around.name ? null : function(state, schema, tree, pos) {
            let options = [], level = 0;
            for (var tagName of allowedChildren(state.doc, tree, schema)) options.push({
                label: "<" + tagName,
                type: "type"
            });
            for (var open of openTags(state.doc, tree)) options.push({
                label: "</" + open + ">",
                type: "type",
                boost: 99 - level++
            });
            return {
                from: pos,
                to: pos,
                options: options,
                validFor: /^<\/?[:\-\.\w\u00b7-\uffff]*$/
            };
        }(state, schema, tree, pos);
    }
    const defaultNesting = [ {
        tag: "script",
        attrs: attrs => "text/typescript" == attrs.type || "ts" == attrs.lang,
        parser: typescriptLanguage.parser
    }, {
        tag: "script",
        attrs: attrs => "text/babel" == attrs.type || "text/jsx" == attrs.type,
        parser: jsxLanguage.parser
    }, {
        tag: "script",
        attrs: attrs => "text/typescript-jsx" == attrs.type,
        parser: tsxLanguage.parser
    }, {
        tag: "script",
        attrs(attrs) {
            return /^(importmap|speculationrules|application\/(.+\+)?json)$/i.test(attrs.type);
        },
        parser: javascriptLanguage.parser.configure({
            top: "SingleExpression"
        })
    }, {
        tag: "script",
        attrs(attrs) {
            return !attrs.type || /^(?:text|application)\/(?:x-)?(?:java|ecma)script$|^module$|^$/i.test(attrs.type);
        },
        parser: javascriptLanguage.parser
    }, {
        tag: "style",
        attrs(attrs) {
            return (!attrs.lang || "css" == attrs.lang) && (!attrs.type || /^(text\/)?(x-)?(stylesheet|css)$/i.test(attrs.type));
        },
        parser: cssLanguage.parser
    } ], defaultAttrs = [ {
        name: "style",
        parser: cssLanguage.parser.configure({
            top: "Styles"
        })
    } ].concat(cursorDocStart.map(name => ({
        name: name,
        parser: javascriptLanguage.parser
    }))), htmlPlain = LRLanguage.define({
        name: "html",
        parser: safari.configure({
            props: [ indentNodeProp.add({
                Element(context) {
                    var after = /^(\s*)(<\/)?/.exec(context.textAfter);
                    return context.node.to <= context.pos + after[0].length ? context.continue() : context.lineIndent(context.node.from) + (after[2] ? 0 : context.unit);
                },
                "OpenTag CloseTag SelfClosingTag"(context) {
                    return context.column(context.node.from) + context.unit;
                },
                Document(context) {
                    if (context.pos + /\s*/.exec(context.textAfter)[0].length < context.node.to) return context.continue();
                    let endElt = null, close;
                    for (let cur = context.node; ;) {
                        var last = cur.lastChild;
                        if (!last || "Element" != last.name || last.to != cur.to) break;
                        endElt = cur = last;
                    }
                    return endElt && (!(close = endElt.lastChild) || "CloseTag" != close.name && "SelfClosingTag" != close.name) ? context.lineIndent(endElt.from) + context.unit : null;
                }
            }), foldNodeProp.add({
                Element(node) {
                    var first = node.firstChild, last = node.lastChild;
                    return first && "OpenTag" == first.name ? {
                        from: first.to,
                        to: "CloseTag" == last.name ? last.from : node.to
                    } : null;
                }
            }), bracketMatchingHandle.add({
                "OpenTag CloseTag": node => node.getChild("TagName")
            }) ]
        }),
        languageData: {
            commentTokens: {
                block: {
                    open: "\x3c!--",
                    close: "--\x3e"
                }
            },
            indentOnInput: /^\s*<\/\w+\W$/,
            wordChars: "-._"
        }
    }), htmlLanguage = htmlPlain.configure({
        wrap: configureNesting(defaultNesting, defaultAttrs)
    });
    function html(config = {}) {
        let dialect = "", wrap;
        !1 === config.matchClosingTags && (dialect = "noMatch"), !0 === config.selfClosingTags && (dialect = (dialect ? dialect + " " : "") + "selfClosing");
        var lang = (wrap = config.nestedLanguages && config.nestedLanguages.length || config.nestedAttributes && config.nestedAttributes.length ? configureNesting((config.nestedLanguages || []).concat(defaultNesting), (config.nestedAttributes || []).concat(defaultAttrs)) : wrap) ? htmlPlain.configure({
            wrap: wrap,
            dialect: dialect
        }) : dialect ? htmlLanguage.configure({
            dialect: dialect
        }) : htmlLanguage;
        return new LanguageSupport(lang, [ htmlLanguage.data.of({
            autocomplete: function(config) {
                var {
                    extraTags: config,
                    extraGlobalAttributes: extraAttrs
                } = config;
                let schema = extraAttrs || config ? new Schema(config, extraAttrs) : Schema.default;
                return context => htmlCompletionFor(schema, context);
            }(config)
        }), !1 !== config.autoCloseTags ? autoCloseTags : [], javascript().support, css().support ]);
    }
    const selfClosers = new Set("area base br col command embed frame hr img input keygen link meta param source track wbr menuitem".split(" ")), autoCloseTags = EditorView.inputHandler.of((view, from, to, text, insertTransaction) => {
        if (view.composing || view.state.readOnly || from != to || ">" != text && "/" != text || !htmlLanguage.isActiveAt(view.state, from, -1)) return !1;
        let base = insertTransaction(), state = base["state"];
        to = state.changeByRange(range => {
            var _a, didType = state.doc.sliceString(range.from - 1, range.to) == text;
            let head = range["head"], after = syntaxTree(state).resolveInner(head, -1), name;
            if (didType && ">" == text && "EndTag" == after.name) {
                var tag = after.parent;
                if ("CloseTag" != (null == (_a = null == (_a = tag.parent) ? void 0 : _a.lastChild) ? void 0 : _a.name) && (name = elementName(state.doc, tag.parent, head)) && !selfClosers.has(name)) return {
                    range: range,
                    changes: {
                        from: head,
                        to: head + (">" === state.doc.sliceString(head, head + 1) ? 1 : 0),
                        insert: `</${name}>`
                    }
                };
            } else if (didType && "/" == text && "IncompleteCloseTag" == after.name) {
                let tag = after.parent;
                if (after.from == head - 2 && "CloseTag" != (null == (_a = tag.lastChild) ? void 0 : _a.name) && (name = elementName(state.doc, tag, head)) && !selfClosers.has(name)) {
                    let to = head + (">" === state.doc.sliceString(head, head + 1) ? 1 : 0), insert = name + ">";
                    return {
                        range: EditorSelection.cursor(head + insert.length, -1),
                        changes: {
                            from: head,
                            to: to,
                            insert: insert
                        }
                    };
                }
            }
            return {
                range: range
            };
        });
        return !to.changes.empty && (view.dispatch([ base, state.update(to, {
            userEvent: "input.complete",
            scrollIntoView: !0
        }) ]), !0);
    }), keywordMap = {
        abstract: 4,
        and: 5,
        array: 6,
        as: 7,
        true: 8,
        false: 8,
        break: 9,
        case: 10,
        catch: 11,
        clone: 12,
        const: 13,
        continue: 14,
        declare: 16,
        default: 15,
        do: 17,
        echo: 18,
        else: 19,
        elseif: 20,
        enddeclare: 21,
        endfor: 22,
        endforeach: 23,
        endif: 24,
        endswitch: 25,
        endwhile: 26,
        enum: 27,
        extends: 28,
        final: 29,
        finally: 30,
        fn: 31,
        for: 32,
        foreach: 33,
        from: 34,
        function: 35,
        global: 36,
        goto: 37,
        if: 38,
        implements: 39,
        include: 40,
        include_once: 41,
        instanceof: 42,
        insteadof: 43,
        interface: 44,
        list: 45,
        match: 46,
        namespace: 47,
        new: 48,
        null: 49,
        or: 50,
        print: 51,
        require: 52,
        require_once: 53,
        return: 54,
        switch: 55,
        throw: 56,
        trait: 57,
        try: 58,
        unset: 59,
        use: 60,
        var: 61,
        public: 62,
        private: 62,
        protected: 62,
        while: 63,
        xor: 64,
        yield: 65,
        __proto__: null
    };
    function keywords(name) {
        name = keywordMap[name.toLowerCase()];
        return null == name ? -1 : name;
    }
    function isSpace(ch) {
        return 9 == ch || 10 == ch || 13 == ch || 32 == ch;
    }
    function isASCIILetter(ch) {
        return 97 <= ch && ch <= 122 || 65 <= ch && ch <= 90;
    }
    function isIdentifierStart(ch) {
        return 95 == ch || 128 <= ch || isASCIILetter(ch);
    }
    function isHex(ch) {
        return 48 <= ch && ch <= 55 || 97 <= ch && ch <= 102 || 65 <= ch && ch <= 70;
    }
    const castTypes = {
        int: !0,
        integer: !0,
        bool: !0,
        boolean: !0,
        float: !0,
        double: !0,
        real: !0,
        string: !0,
        array: !0,
        object: !0,
        unset: !0,
        __proto__: null
    };
    styleTokens = new ExternalTokenizer(input => {
        if (40 == input.next) {
            input.advance();
            let peek = 0;
            for (;isSpace(input.peek(peek)); ) peek++;
            let name = "", next;
            for (;isASCIILetter(next = input.peek(peek)); ) name += String.fromCharCode(next), 
            peek++;
            for (;isSpace(input.peek(peek)); ) peek++;
            41 == input.peek(peek) && castTypes[name.toLowerCase()] && input.acceptToken(1);
        } else if (60 == input.next && 60 == input.peek(1) && 60 == input.peek(2)) {
            for (let i = 0; i < 3; i++) input.advance();
            for (;32 == input.next || 9 == input.next; ) input.advance();
            var quoted = 39 == input.next;
            if (quoted && input.advance(), isIdentifierStart(input.next)) {
                let tag = String.fromCharCode(input.next);
                for (;input.advance(), isIdentifierStart(input.next) || 48 <= input.next && input.next <= 55; ) tag += String.fromCharCode(input.next);
                if (quoted) {
                    if (39 != input.next) return;
                    input.advance();
                }
                if (10 == input.next || 13 == input.next) for (;;) {
                    var lineStart = 10 == input.next || 13 == input.next;
                    if (input.advance(), input.next < 0) return;
                    if (lineStart) {
                        for (;32 == input.next || 9 == input.next; ) input.advance();
                        let match = !0;
                        for (let i = 0; i < tag.length; i++) {
                            if (input.next != tag.charCodeAt(i)) {
                                match = !1;
                                break;
                            }
                            input.advance();
                        }
                        if (match) return input.acceptToken(2);
                    }
                }
            }
        }
    }), scriptTokens = new ExternalTokenizer(input => {
        input.next < 0 && input.acceptToken(266);
    }), htmlHighlighting = new ExternalTokenizer((input, stack) => {
        63 == input.next && stack.canShift(265) && 62 == input.peek(1) && input.acceptToken(265);
    });
    textareaTokens = new ExternalTokenizer((input, stack) => {
        let content = !1;
        for (;!(34 == input.next || input.next < 0 || 36 == input.next && (isIdentifierStart(input.peek(1)) || 123 == input.peek(1)) || 123 == input.next && 36 == input.peek(1)); content = !0) {
            if (92 == input.next) {
                var escaped = function(input) {
                    var after = input.peek(1);
                    if (110 == after || 114 == after || 116 == after || 118 == after || 101 == after || 102 == after || 92 == after || 36 == after || 34 == after || 123 == after) return 2;
                    if (48 <= after && after <= 55) {
                        let size = 2, next;
                        for (;size < 5 && 48 <= (next = input.peek(size)) && next <= 55; ) size++;
                        return size;
                    }
                    if (120 == after && isHex(input.peek(2))) return isHex(input.peek(3)) ? 4 : 3;
                    if (117 == after && 123 == input.peek(2)) for (let size = 3; ;size++) {
                        var next = input.peek(size);
                        if (125 == next) return 2 == size ? 0 : size + 1;
                        if (!isHex(next)) break;
                    }
                    return 0;
                }(input);
                if (escaped) {
                    if (content) break;
                    return input.acceptToken(3, escaped);
                }
            } else if (!content && (91 == input.next || 45 == input.next && 62 == input.peek(1) && isIdentifierStart(input.peek(2)) || 63 == input.next && 45 == input.peek(1) && 62 == input.peek(2) && isIdentifierStart(input.peek(3))) && stack.canShift(264)) break;
            input.advance();
        }
        content && input.acceptToken(263);
    }), endTag = styleTags({
        "Visibility abstract final static": tags$1.modifier,
        "for foreach while do if else elseif switch try catch finally return throw break continue default case": tags$1.controlKeyword,
        "endif endfor endforeach endswitch endwhile declare enddeclare goto match": tags$1.controlKeyword,
        "and or xor yield unset clone instanceof insteadof": tags$1.operatorKeyword,
        "function fn class trait implements extends const enum global interface use var": tags$1.definitionKeyword,
        "include include_once require require_once namespace": tags$1.moduleKeyword,
        "new from echo print array list as": tags$1.keyword,
        null: tags$1.null,
        Boolean: tags$1.bool,
        VariableName: tags$1.variableName,
        "NamespaceName/...": tags$1.namespace,
        "NamedType/...": tags$1.typeName,
        Name: tags$1.name,
        "CallExpression/Name": tags$1.function(tags$1.variableName),
        "LabelStatement/Name": tags$1.labelName,
        "MemberExpression/Name": tags$1.propertyName,
        "MemberExpression/VariableName": tags$1.special(tags$1.propertyName),
        "ScopedExpression/ClassMemberName/Name": tags$1.propertyName,
        "ScopedExpression/ClassMemberName/VariableName": tags$1.special(tags$1.propertyName),
        "CallExpression/MemberExpression/Name": tags$1.function(tags$1.propertyName),
        "CallExpression/ScopedExpression/ClassMemberName/Name": tags$1.function(tags$1.propertyName),
        "MethodDeclaration/Name": tags$1.function(tags$1.definition(tags$1.variableName)),
        "FunctionDefinition/Name": tags$1.function(tags$1.definition(tags$1.variableName)),
        "ClassDeclaration/Name": tags$1.definition(tags$1.className),
        UpdateOp: tags$1.updateOperator,
        ArithOp: tags$1.arithmeticOperator,
        LogicOp: tags$1.logicOperator,
        BitOp: tags$1.bitwiseOperator,
        CompareOp: tags$1.compareOperator,
        ControlOp: tags$1.controlOperator,
        AssignOp: tags$1.definitionOperator,
        "$ ConcatOp": tags$1.operator,
        LineComment: tags$1.lineComment,
        BlockComment: tags$1.blockComment,
        Integer: tags$1.integer,
        Float: tags$1.float,
        String: tags$1.string,
        ShellExpression: tags$1.special(tags$1.string),
        "=> ->": tags$1.punctuation,
        "( )": tags$1.paren,
        "#[ [ ]": tags$1.squareBracket,
        "${ { }": tags$1.brace,
        "-> ?->": tags$1.derefOperator,
        ", ; :: : \\": tags$1.separator,
        "PhpOpen PhpClose": tags$1.processingInstruction
    });
    const spec_Name = {
        __proto__: null,
        static: 311,
        STATIC: 311,
        class: 333,
        CLASS: 333
    };
    var Type, punctuation = LRParser.deserialize({
        version: 14,
        states: "$GSQ`OWOOQhQaOOP%oO`OOOOO#t'#H_'#H_O%tO#|O'#DtOOO#u'#Dw'#DwQ&SOWO'#DwO&XO$VOOOOQ#u'#Dx'#DxO&lQaO'#D|O(mQdO'#E}O(tQdO'#EQO*kQaO'#EWO,zQ`O'#ETO-PQ`O'#E^O/nQaO'#E^O/uQ`O'#EfO/zQ`O'#EoO*kQaO'#EoO0VQ`O'#HhO0[Q`O'#E{O0[Q`O'#E{OOQS'#Ic'#IcO0aQ`O'#EvOOQS'#IZ'#IZO2oQdO'#IWO6tQeO'#FUO*kQaO'#FeO*kQaO'#FfO*kQaO'#FgO*kQaO'#FhO*kQaO'#FhO*kQaO'#FkOOQO'#Id'#IdO7RQ`O'#FqOOQO'#Hi'#HiO7ZQ`O'#HOO7uQ`O'#FlO8QQ`O'#H]O8]Q`O'#FvO8eQaO'#FwO*kQaO'#GVO*kQaO'#GYO8}OrO'#G]OOQS'#Iq'#IqOOQS'#Ip'#IpOOQS'#IW'#IWO,zQ`O'#GdO,zQ`O'#GfO,zQ`O'#GkOhQaO'#GmO9UQ`O'#GnO9ZQ`O'#GqO9`Q`O'#GtO9eQeO'#GuO9eQeO'#GvO9eQeO'#GwO9oQ`O'#GxO9tQ`O'#GzO9yQaO'#G{O<YQ`O'#G|O<_Q`O'#G}O<dQ`O'#G}O9oQ`O'#HOO<iQ`O'#HQO<nQ`O'#HRO<sQ`O'#HSO<xQ`O'#HVO=TQ`O'#HWO9yQaO'#H[OOQ#u'#IV'#IVOOQ#u'#Ha'#HaQhQaOOO=fQ`O'#HPO7pQ`O'#HPO=kO#|O'#DrPOOO)CCw)CCwOOO#t-E;]-E;]OOO#u,5:c,5:cOOO#u'#H`'#H`O&XO$VOOO=vQ$VO'#IUOOOO'#IU'#IUQOOOOOOOQ#y,5:h,5:hO=}QaO,5:hOOQ#u,5:j,5:jO@eQaO,5:mO@lQaO,5;UO*kQaO,5;UO@sQ`O,5;VOCbQaO'#EsOOQS,5;^,5;^OCiQ`O,5;jOOQP'#F]'#F]O*kQaO,5;qO*kQaO,5;qO*kQaO,5;qO*kQaO,5;qO*kQaO,5;qO*kQaO,5;qO*kQaO,5;qO*kQaO,5;qO*kQaO,5;qO*kQaO,5;qO*kQaO,5;qO*kQaO,5;qO*kQaO,5;qO*kQaO,5;qO*kQaO,5;qO*kQaO,5;qOOQ#u'#Im'#ImOOQS,5<q,5<qOOQ#u,5:l,5:lOEbQ`O,5:rOEiQdO'#E}OF]Q`O'#FlOFeQ`O'#FlOFmQ`O,5:oOFrQaO'#E_OOQS,5:x,5:xOHyQ`O'#I]O9yQaO'#EaO9yQaO'#I]OOQS'#I]'#I]OIQQ`O'#I[OIYQ`O,5:xO-UQaO,5:xOI_QaO'#EgOOQS,5;Q,5;QOOQS,5;Z,5;ZOIiQ`O,5;ZOOQO,5>S,5>SOJ[QdO,5;gOOQO-E;f-E;fOL^Q`O,5;gOLcQpO,5;bO0aQ`O'#EyOLkQtO'#E}OOQS'#Ez'#EzOOQS'#Ib'#IbOM`QaO,5:wO*kQaO,5;nOOQS,5;p,5;pO*kQaO,5;pOMgQdO,5<POMwQdO,5<QONXQdO,5<RONiQdO,5<SO!!sQdO,5<SO!!zQdO,5<VO!#[Q`O'#FrO!#gQ`O'#IgO!#oQ`O,5<]OOQO-E;g-E;gO!#tQ`O'#IoO<_Q`O,5=iO!#|Q`O,5=iO9oQ`O,5=jO!$RQ`O,5=nO!$WQ`O,5=kO!$]Q`O,5=kO!$bQ`O'#FnO!$xQ`O,5<WO!%TQ`O,5<WO!%WQ`O,5?ZO!%]Q`O,5<WO!%eQ`O,5<bO!%mQdO'#GPO!%{QdO'#InO!&WQdO,5=wO!&`Q`O,5<bO!%WQ`O,5<bO!&hQdO,5<cO!&xQ`O,5<cO!'lQdO,5<qO!)nQdO,5<tO!*OOrO'#HsOOOQ'#It'#ItO*kQaO'#GbOOOQ'#Hs'#HsO!*pOrO,5<wOOQS,5<w,5<wO!*wQaO,5=OO!+OQ`O,5=QO!+WQeO,5=VO!+bQ`O,5=XO!+gQaO'#GoO!+WQeO,5=YO9yQaO'#GrO!+WQeO,5=]O!&WQdO,5=`O(tQdO,5=aOOQ#u,5=a,5=aO(tQdO,5=bOOQ#u,5=b,5=bO(tQdO,5=cOOQ#u,5=c,5=cO!+nQ`O,5=dO!+vQ`O,5=fO!+{QdO'#IvOOQS'#Iv'#IvO!&WQdO,5=gO>UQaO,5=hO!-eQ`O'#F}O!-jQdO'#IlO!&WQdO,5=iOOQ#u,5=j,5=jO!-uQ`O,5=lO!-xQ`O,5=mO!-}Q`O,5=nO!.YQdO,5=qOOQ#u,5=q,5=qO!.eQ`O,5=rO!.eQ`O,5=rO!.mQdO'#IwO!.{Q`O'#HXO!&WQdO,5=rO!/ZQ`O,5=rO!/fQdO'#IYO!&WQdO,5=vOOQ#u-E;_-E;_O!1RQ`O,5=kOOO#u,5:^,5:^O!1^O#|O,5:^OOO#u-E;^-E;^OOOO,5>p,5>pOOQ#y1G0S1G0SO!1fQ`O1G0XO*kQaO1G0XO!2xQ`O1G0pOOQS1G0p1G0pO!4[Q`O1G0pOOQS'#I_'#I_O*kQaO'#I_OOQS1G0q1G0qO!4cQ`O'#IaO!7lQ`O'#E}O!7yQaO'#EuOOQO'#Ia'#IaO!8TQ`O'#I`O!8]Q`O,5;_OOQS'#FQ'#FQOOQS1G1U1G1UO!8bQdO1G1]O!:dQdO1G1]O!<PQdO1G1]O!=lQdO1G1]O!?XQdO1G1]O!@tQdO1G1]O!BaQdO1G1]O!C|QdO1G1]O!EiQdO1G1]O!GUQdO1G1]O!HqQdO1G1]O!J^QdO1G1]O!KyQdO1G1]O!MfQdO1G1]O# RQdO1G1]O#!nQdO1G1]OOQT1G0^1G0^O!%WQ`O,5<WO#$ZQaO'#EXOOQS1G0Z1G0ZO#$bQ`O,5:yOFuQaO,5:yO#$gQaO,5:}O#$nQdO,5:{O#&jQdO,5>wO#(fQaO'#HdO#(vQ`O,5>vOOQS1G0d1G0dO#)OQ`O1G0dO#)TQ`O'#I^O#*mQ`O'#I^O#*uQ`O,5;ROIbQaO,5;ROOQS1G0u1G0uPOQO'#E}'#E}O#+fQdO1G1RO0aQ`O'#HgO#-hQtO,5;cO#.YQaO1G0|OOQS,5;e,5;eO#0iQtO,5;gO#0vQdO1G0cO*kQaO1G0cO#2cQdO1G1YO#4OQdO1G1[OOQO,5<^,5<^O#4`Q`O'#HjO#4nQ`O,5?ROOQO1G1w1G1wO#4vQ`O,5?ZO!&WQdO1G3TO<_Q`O1G3TOOQ#u1G3U1G3UO#4{Q`O1G3YO!1RQ`O1G3VO#5WQ`O1G3VO#5]QpO'#FoO#5kQ`O'#FoO#5{Q`O'#FoO#6WQ`O'#FoO#6`Q`O'#FsO#6eQ`O'#FtOOQO'#If'#IfO#6lQ`O'#IeO#6tQ`O,5<YOOQS1G1r1G1rO0aQ`O1G1rO#6yQ`O1G1rO#7OQ`O1G1rO!%WQ`O1G4uO#7ZQdO1G4uO!%WQ`O1G1rO#7iQ`O1G1|O!%WQ`O1G1|O9yQaO,5<kO#7qQdO'#HqO#8PQdO,5?YOOQ#u1G3c1G3cO*kQaO1G1|O0aQ`O1G1|O#8[QdO1G1}O7RQ`O'#FyO7RQ`O'#FzO#:nQ`O'#F{OOQS1G1}1G1}O!-xQ`O1G1}O!1UQ`O1G1}O!1RQ`O1G1}O#;eO`O,5<xO#;jO`O,5<xO#;uO!bO,5<yO#<TQ`O,5<|OOOQ-E;q-E;qOOQS1G2c1G2cO#<[QaO'#GeO#<uQ$VO1G2jO#AuQ`O1G2jO#BQQ`O'#GgO#B]Q`O'#GjOOQ#u1G2l1G2lO#BhQ`O1G2lOOQ#u'#Gl'#GlOOQ#u'#Iu'#IuOOQ#u1G2q1G2qO#BmQ`O1G2qO,zQ`O1G2sO#BrQaO,5=ZO#ByQ`O,5=ZOOQ#u1G2t1G2tO#COQ`O1G2tO#CTQ`O,5=^OOQ#u1G2w1G2wO#DgQ`O1G2wOOQ#u1G2z1G2zOOQ#u1G2{1G2{OOQ#u1G2|1G2|OOQ#u1G2}1G2}O#DlQ`O'#HxO9oQ`O'#HxO#DqQ$VO1G3OO#IwQ`O1G3QO9yQaO'#HwO#I|QdO,5=[OOQ#u1G3R1G3RO#JXQ`O1G3SO9yQaO,5<iO#J^QdO'#HpO#JlQdO,5?WOOQ#u1G3T1G3TOOQ#u1G3W1G3WO!-xQ`O1G3WOOQ#u1G3X1G3XO#KfQ`O'#HTOOQ#u1G3Y1G3YO#KmQ`O1G3YO0aQ`O1G3YOOQ#u1G3]1G3]O!&WQdO1G3^O#KrQ`O1G3^O#KzQdO'#HzO#L]QdO,5?cO#LhQ`O,5?cO#LmQ`O'#HYO7RQ`O'#HYO#LxQ`O'#IxO#MQQ`O,5=sOOQ#u1G3^1G3^O!.eQ`O1G3^O!.eQ`O1G3^O#MVQeO'#HbO#MgQdO,5>tOOQ#u1G3b1G3bOOQ#u1G3V1G3VO!-xQ`O1G3VO!1UQ`O1G3VOOO#u1G/x1G/xO*kQaO7+%sO#MuQdO7+%sOOQS7+&[7+&[O$ bQ`O,5>yO>UQaO,5;`O$ iQ`O,5;aO$#OQaO'#HfO$#YQ`O,5>zOOQS1G0y1G0yO$#bQ`O'#EYO$#gQ`O'#IXO$#oQ`O,5:sOOQS1G0e1G0eO$#tQ`O1G0eO$#yQ`O1G0iO9yQaO1G0iOOQO,5>O,5>OOOQO-E;b-E;bOOQS7+&O7+&OO>UQaO,5;SO$%`QaO'#HeO$%jQ`O,5>xOOQS1G0m1G0mO$%rQ`O1G0mOOQS,5>R,5>ROOQS-E;e-E;eO$%wQdO7+&hO$'yQtO1G1RO$(WQdO7+%}OOQS1G0i1G0iOOQO,5>U,5>UOOQO-E;h-E;hOOQ#u7+(o7+(oO!&WQdO7+(oOOQ#u7+(t7+(tO#KmQ`O7+(tO0aQ`O7+(tOOQ#u7+(q7+(qO!-xQ`O7+(qO!1UQ`O7+(qO!1RQ`O7+(qO$)sQ`O,5<ZO$*OQ`O,5<ZO$*WQ`O,5<_O$*]QpO,5<ZO>UQaO,5<ZOOQO,5<_,5<_O$*kQpO,5<`O$*sQ`O,5<`O$+OQ`O'#HkO$+iQ`O,5?POOQS1G1t1G1tO$+qQpO7+'^O$+yQ`O'#FuO$,UQ`O7+'^OOQS7+'^7+'^O0aQ`O7+'^O#6yQ`O7+'^O$,^QdO7+*aO0aQ`O7+*aO$,lQ`O7+'^O*kQaO7+'hO0aQ`O7+'hO$,wQ`O7+'hO$-PQdO1G2VOOQS,5>],5>]OOQS-E;o-E;oO$.iQdO7+'hO$.yQpO7+'hO$/RQdO'#IiOOQO,5<e,5<eOOQO,5<f,5<fO$/dQpO'#GOO$/lQ`O'#GOOOQO'#Ik'#IkOOQO'#Ho'#HoO$0]Q`O'#GOO<_Q`O'#F|O!&WQdO'#GOO!.YQdO'#GQO7RQ`O'#GROOQO'#Ij'#IjOOQO'#Hn'#HnO$0yQ`O,5<gOOQ#y,5<g,5<gOOQS7+'i7+'iO!-xQ`O7+'iO!1UQ`O7+'iOOOQ1G2d1G2dO$1pO`O1G2dO$1uO!bO1G2eO$2TO`O'#G`O$2YO`O1G2eOOOQ1G2h1G2hO$2_QaO,5=PO,zQ`O'#HtO$2xQ$VO7+(UOhQaO7+(UO,zQ`O'#HuO$7xQ`O7+(UO!&WQdO7+(UO$8TQ`O7+(UO$8YQaO'#GhO$:iQ`O'#GiOOQO'#Hv'#HvO$:qQ`O,5=ROOQ#u,5=R,5=RO$:|Q`O,5=UO!&WQdO7+(WO!&WQdO7+(]O!&WQdO7+(_O$;XQaO1G2uO$;`Q`O1G2uO$;eQaO1G2uO!&WQdO7+(`O9yQaO1G2xO!&WQdO7+(cO0aQ`O'#GyO9oQ`O,5>dOOQ#u,5>d,5>dOOQ#u-E;v-E;vO$;lQaO7+(lO$<TQdO,5>cOOQS-E;u-E;uO!&WQdO7+(nO$=mQdO1G2TOOQS,5>[,5>[OOQS-E;n-E;nOOQ#u7+(r7+(rO$?nQ`O'#GQO$?uQ`O'#GQO$@ZQ`O'#HUOOQO'#Hy'#HyO$@`Q`O,5=oOOQ#u,5=o,5=oO$@gQpO7+(tOOQ#u7+(x7+(xO!&WQdO7+(xO$@rQdO,5>fOOQS-E;x-E;xO$AQQdO1G4}O$A]Q`O,5=tO$AbQ`O,5=tO$AmQ`O'#H{O$BRQ`O,5?dOOQS1G3_1G3_O#KrQ`O7+(xO$BZQdO,5=|OOQS-E;`-E;`O$CvQdO<<I_OOQS1G4e1G4eO$EcQ`O1G0zOOQO,5>Q,5>QOOQO-E;d-E;dO$8YQaO,5:tO$FxQaO'#HcO$GVQ`O,5>sOOQS1G0_1G0_OOQS7+&P7+&PO$G_Q`O7+&TO$HtQ`O1G0nO$JZQ`O,5>POOQO,5>P,5>POOQO-E;c-E;cOOQS7+&X7+&XOOQS7+&T7+&TOOQ#u<<LZ<<LZOOQ#u<<L`<<L`O$@gQpO<<L`OOQ#u<<L]<<L]O!-xQ`O<<L]O!1UQ`O<<L]O>UQaO1G1uO$KsQ`O1G1uO$LOQ`O1G1yOOQO1G1y1G1yO$LTQ`O1G1uO$L]Q`O1G1uO$MrQ`O1G1zO>UQaO1G1zOOQO,5>V,5>VOOQO-E;i-E;iOOQS<<Jx<<JxO$M}Q`O'#IhO$NVQ`O'#IhO$N[Q`O,5<aO0aQ`O<<JxO$+qQpO<<JxO$NaQ`O<<JxO0aQ`O<<M{O$NiQtO<<M{O#6yQ`O<<JxO$NwQdO<<KSO% XQpO<<KSO*kQaO<<KSO0aQ`O<<KSO% aQdO'#HmO% xQdO,5?TO!&WQdO,5<jO$/dQpO,5<jO%!ZQ`O,5<jO<_Q`O,5<hO!.YQdO,5<lOOQO-E;m-E;mO!&WQdO,5<hOOQO,5<j,5<jOOQO,5<l,5<lO%!tQdO,5<mOOQO-E;l-E;lOOQ#y1G2R1G2ROOQS<<KT<<KTO!-xQ`O<<KTOOOQ7+(O7+(OO%#PO`O7+(POOOO,5<z,5<zOOOQ7+(P7+(POhQaO,5>`OOQ#u-E;r-E;rOhQaO<<KpOOQ#u<<Kp<<KpO$8TQ`O,5>aOOQO-E;s-E;sO!&WQdO<<KpO$8TQ`O<<KpO%#UQ`O<<KpO%#ZQ`O,5=SO%$pQaO,5=TOOQO-E;t-E;tOOQ#u1G2m1G2mOOQ#u<<Kr<<KrOOQ#u<<Kw<<KwOOQ#u<<Ky<<KyOOQT7+(a7+(aO%%QQ`O7+(aO%%VQaO7+(aO%%^Q`O7+(aOOQ#u<<Kz<<KzO%%cQ`O7+(dO%&xQ`O7+(dOOQ#u<<K}<<K}O%&}QpO,5=eOOQ#u1G4O1G4OO%'YQ`O<<LWOOQ#u<<LY<<LYO$?uQ`O,5<lO%'_Q`O,5=pO%'dQdO,5=pOOQO-E;w-E;wOOQ#u1G3Z1G3ZO#KmQ`O<<L`OOQ#u<<Ld<<LdO%'oQ`O1G4QO%'tQdO7+*iOOQO1G3`1G3`O%(PQ`O1G3`O%(UQ`O'#HZO7RQ`O'#HZOOQO,5>g,5>gOOQO-E;y-E;yO!&WQdO<<LdO%(aQ`O1G0`OOQO,5=},5=}OOQO-E;a-E;aO>UQaO,5;TOOQ#uANAzANAzO#KmQ`OANAzOOQ#uANAwANAwO!-xQ`OANAwO%)vQ`O7+'aO>UQaO7+'aOOQO7+'e7+'eO%+]Q`O7+'aO%+hQ`O7+'eO>UQaO7+'fO%+mQ`O7+'fO%-SQ`O'#HlO%-bQ`O,5?SO%-bQ`O,5?SOOQO1G1{1G1{O$+qQpOAN@dOOQSAN@dAN@dO0aQ`OAN@dO%-jQtOANCgO%-xQ`OAN@dO*kQaOAN@nO%.QQdOAN@nO%.bQpOAN@nOOQS,5>X,5>XOOQS-E;k-E;kOOQO1G2U1G2UO!&WQdO1G2UO$/dQpO1G2UO<_Q`O1G2SO!.YQdO1G2WO!&WQdO1G2SOOQO1G2W1G2WOOQO1G2S1G2SO%.jQaO'#GSOOQO1G2X1G2XOOQSAN@oAN@oOOOQ<<Kk<<KkOOQ#u1G3z1G3zOOQ#uANA[ANA[OOQO1G3{1G3{O%0iQ`OANA[O!&WQdOANA[O%0nQaO1G2nO%1OQaO1G2oOOQT<<K{<<K{O%1`Q`O<<K{O%1eQaO<<K{O*kQaO,5=_OOQT<<LO<<LOOOQO1G3P1G3PO%1lQ`O1G3PO!+WQeOANArO%1qQdO1G3[OOQO1G3[1G3[O%1|Q`O1G3[OOQS7+)l7+)lOOQO7+(z7+(zO%2UQ`O,5=uO%2ZQ`O,5=uOOQ#uANBOANBOO%2fQ`O1G0oOOQ#uG27fG27fOOQ#uG27cG27cO%3{Q`O<<J{O>UQaO<<J{OOQO<<KP<<KPO%5bQ`O<<KQOOQO,5>W,5>WO%6wQ`O,5>WOOQO-E;j-E;jO%6|Q`O1G4nOOQSG26OG26OO$+qQpOG26OO0aQ`OG26OO%7UQdOG26YO*kQaOG26YOOQO7+'p7+'pO!&WQdO7+'pO!&WQdO7+'nOOQO7+'r7+'rOOQO7+'n7+'nO%7fQ`OLD+tO%8uQ`O'#E}O%9PQ`O'#IZO!&WQdO'#HrO%:|QaO,5<nOOQO,5<n,5<nO!&WQdOG26vOOQ#uG26vG26vO%<{QaO7+(YOOQTANAgANAgO%=]Q`OANAgO%=bQ`O1G2yOOQO7+(k7+(kOOQ#uG27^G27^O%=iQ`OG27^OOQO7+(v7+(vO%=nQ`O7+(vO!&WQdO7+(vOOQO1G3a1G3aO%=vQ`O1G3aO%={Q`OAN@gOOQO1G3r1G3rOOQSLD+jLD+jO$+qQpOLD+jO%?bQdOLD+tOOQO<<K[<<K[OOQO<<KY<<KYO%?rQ`O,5<oO%?wQ`O,5<pOOQP,5>^,5>^OOQP-E;p-E;pOOQO1G2Y1G2YOOQ#uLD,bLD,bOOQTG27RG27RO!&WQdOLD,xO!&WQdO<<LbOOQO<<Lb<<LbOOQO7+({7+({OOQS!$( U!$( UOOQS1G2Z1G2ZOOQS1G2[1G2[O%@PQdO1G2[OOQ#u!$(!d!$(!dOOQOANA|ANA|OOQS7+'v7+'vO%@[Q`O'#E{O%@[Q`O'#E{O%@aQ`O,5;gO%@fQdO,5<cO%BbQaO,5:}O*kQaO1G0iO%BiQaO'#FwO#.YQaO'#GVO#.YQaO'#GYO#.YQaO,5;qO#.YQaO,5;qO#.YQaO,5;qO#.YQaO,5;qO#.YQaO,5;qO#.YQaO,5;qO#.YQaO,5;qO#.YQaO,5;qO#.YQaO,5;qO#.YQaO,5;qO#.YQaO,5;qO#.YQaO,5;qO#.YQaO,5;qO#.YQaO,5;qO#.YQaO,5;qO#.YQaO,5;qO%BpQdO'#I]O%D`QdO'#I]O#.YQaO'#EaO#.YQaO'#I]O%FbQaO,5:wO#.YQaO,5;nO#.YQaO,5;pO%FiQdO,5<PO%HeQdO,5<QO%JaQdO,5<RO%L]QdO,5<SO%NXQdO,5<SO%NoQdO,5<VO&!kQdO,5<tO#.YQaO1G0XO&$gQdO1G1]O&&cQdO1G1]O&(_QdO1G1]O&*ZQdO1G1]O&,VQdO1G1]O&.RQdO1G1]O&/}QdO1G1]O&1yQdO1G1]O&3uQdO1G1]O&5qQdO1G1]O&7mQdO1G1]O&9iQdO1G1]O&;eQdO1G1]O&=aQdO1G1]O&?]QdO1G1]O&AXQdO,5:{O&CTQdO,5>wO&EPQdO1G0cO#.YQaO1G0cO&F{QdO1G1YO&HwQdO1G1[O#.YQaO1G1|O#.YQaO7+%sO&JsQdO7+%sO&LoQdO7+%}O#.YQaO7+'hO&NkQdO7+'hO'!gQdO<<I_O'$cQdO<<KSO#.YQaO<<KSO#.YQaOAN@nO'&_QdOAN@nO'(ZQdOG26YO#.YQaOG26YO'*VQdOLD+tO',RQaO,5:}O'.QQaO1G0iO'/|QdO'#IWO'0aQeO'#FUO'4aQeO'#FUO#.YQaO'#FeO'.QQaO'#FeO#.YQaO'#FfO'.QQaO'#FfO#.YQaO'#FgO'.QQaO'#FgO#.YQaO'#FhO'.QQaO'#FhO#.YQaO'#FhO'.QQaO'#FhO#.YQaO'#FkO'.QQaO'#FkO'8gQaO,5:mO'8nQ`O,5<bO'8vQ`O1G0XO'.QQaO1G0|O':YQ`O1G1|O':bQ`O7+'hO':jQpO7+'hO':rQpO<<KSO':zQpOAN@nO';SQaO'#FwO'.QQaO'#GVO'.QQaO'#GYO'.QQaO,5;qO'.QQaO,5;qO'.QQaO,5;qO'.QQaO,5;qO'.QQaO,5;qO'.QQaO,5;qO'.QQaO,5;qO'.QQaO,5;qO'.QQaO,5;qO'.QQaO,5;qO'.QQaO,5;qO'.QQaO,5;qO'.QQaO,5;qO'.QQaO,5;qO'.QQaO,5;qO'.QQaO,5;qO'.QQaO'#EaO'.QQaO'#I]O'=RQaO,5:wO'.QQaO,5;nO'.QQaO,5;pO'?QQdO,5<PO'ASQdO,5<QO'CUQdO,5<RO'EWQdO,5<SO'GYQdO,5<SO'GvQdO,5<VO'IxQdO,5<tO'.QQaO1G0XO'KzQdO1G1]O'M|QdO1G1]O(!OQdO1G1]O($QQdO1G1]O(&SQdO1G1]O((UQdO1G1]O(*WQdO1G1]O(,YQdO1G1]O(.[QdO1G1]O(0^QdO1G1]O(2`QdO1G1]O(4bQdO1G1]O(6dQdO1G1]O(8fQdO1G1]O(:hQdO1G1]O(<jQdO,5:{O(>lQdO,5>wO(@nQdO1G0cO'.QQaO1G0cO(BpQdO1G1YO(DrQdO1G1[O'.QQaO1G1|O'.QQaO7+%sO(FtQdO7+%sO(HvQdO7+%}O'.QQaO7+'hO(JxQdO7+'hO(LzQdO<<I_O(N|QdO<<KSO'.QQaO<<KSO'.QQaOAN@nO)#OQdOAN@nO)%QQdOG26YO'.QQaOG26YO)'SQdOLD+tO))UQaO,5:}O#.YQaO1G0iO))]Q`O'#FvO))eQpO,5;bO))mQ`O,5<bO!%WQ`O,5<bO!%WQ`O1G1|O0aQ`O1G1|O0aQ`O7+'hO0aQ`O<<KSO))uQdO,5<cO)+wQdO'#I]O)-vQdO'#IWO).aQaO,5:mO).hQ`O,5<bO).pQ`O1G0XO)0SQ`O1G1|O)0[Q`O7+'hO)0dQpO7+'hO)0lQpO<<KSO)0tQpOAN@nO0aQ`O'#EvO9yQaO'#FeO9yQaO'#FfO9yQaO'#FgO9yQaO'#FhO9yQaO'#FhO9yQaO'#FkO)0|QaO'#FwO9yQaO'#GVO9yQaO'#GYO9yQaO,5;qO9yQaO,5;qO9yQaO,5;qO9yQaO,5;qO9yQaO,5;qO9yQaO,5;qO9yQaO,5;qO9yQaO,5;qO9yQaO,5;qO9yQaO,5;qO9yQaO,5;qO9yQaO,5;qO9yQaO,5;qO9yQaO,5;qO9yQaO,5;qO9yQaO,5;qO)1TQ`O'#FlO*kQaO'#EaO*kQaO'#I]O)1]QaO,5:wO9yQaO,5;nO9yQaO,5;pO)1dQdO,5<PO)3`QdO,5<QO)5[QdO,5<RO)7WQdO,5<SO)9SQdO,5<SO)9jQdO,5<VO);fQdO,5<cO)=bQdO,5<tO)?^Q`O'#IvO)@sQ`O'#IYO9yQaO1G0XO)BYQdO1G1]O)DUQdO1G1]O)FQQdO1G1]O)G|QdO1G1]O)IxQdO1G1]O)KtQdO1G1]O)MpQdO1G1]O* lQdO1G1]O*#hQdO1G1]O*%dQdO1G1]O*'`QdO1G1]O*)[QdO1G1]O*+WQdO1G1]O*-SQdO1G1]O*/OQdO1G1]O*0zQaO,5:}O*1RQdO,5:{O*1cQdO,5>wO*1sQaO'#HdO*2TQ`O,5>vO*2]QdO1G0cO9yQaO1G0cO*4XQdO1G1YO*6TQdO1G1[O9yQaO1G1|O>UQaO'#HwO*8PQ`O,5=[O*8XQaO'#HbO*8cQ`O,5>tO9yQaO7+%sO*8kQdO7+%sO*:gQ`O1G0iO>UQaO1G0iO*;|QdO7+%}O9yQaO7+'hO*=xQdO7+'hO*?tQ`O,5>cO*AZQ`O,5=|O*BpQdO<<I_O*DlQ`O7+&TO*FRQdO<<KSO9yQaO<<KSO9yQaOAN@nO*G}QdOAN@nO*IyQdOG26YO9yQaOG26YO*KuQdOLD+tO*MqQaO,5:}O9yQaO1G0iO*MxQdO'#I]O*NcQ`O'#FvO*NkQ`O,5<bO!%WQ`O,5<bO!%WQ`O1G1|O0aQ`O1G1|O0aQ`O7+'hO0aQ`O<<KSO*NsQdO'#IWO+ ^QeO'#FUO+ zQaO'#FUO+#sQaO'#FUO+%`QaO'#FUO>UQaO'#FeO>UQaO'#FfO>UQaO'#FgO>UQaO'#FhO>UQaO'#FhO>UQaO'#FkO+'XQaO'#FwO>UQaO'#GVO>UQaO'#GYO+'`QaO,5:mO>UQaO,5;qO>UQaO,5;qO>UQaO,5;qO>UQaO,5;qO>UQaO,5;qO>UQaO,5;qO>UQaO,5;qO>UQaO,5;qO>UQaO,5;qO>UQaO,5;qO>UQaO,5;qO>UQaO,5;qO>UQaO,5;qO>UQaO,5;qO>UQaO,5;qO>UQaO,5;qO+'gQ`O'#I]O$8YQaO'#EaO+)PQaOG26YO$8YQaO'#I]O+*{Q`O'#I[O++TQaO,5:wO>UQaO,5;nO>UQaO,5;pO++[Q`O,5<PO+,wQ`O,5<QO+.dQ`O,5<RO+0PQ`O,5<SO+1lQ`O,5<SO+3XQ`O,5<VO+4tQ`O,5<bO+4|Q`O,5<cO+6iQ`O,5<tO+8UQ`O1G0XO>UQaO1G0XO+9hQ`O1G1]O+;TQ`O1G1]O+<pQ`O1G1]O+>]Q`O1G1]O+?xQ`O1G1]O+AeQ`O1G1]O+CQQ`O1G1]O+DmQ`O1G1]O+FYQ`O1G1]O+GuQ`O1G1]O+IbQ`O1G1]O+J}Q`O1G1]O+LjQ`O1G1]O+NVQ`O1G1]O, rQ`O1G1]O,#_Q`O1G0cO>UQaO1G0cO,$zQ`O1G1YO,&gQ`O1G1[O,(SQ`O1G1|O>UQaO1G1|O>UQaO7+%sO,([Q`O7+%sO,)wQ`O7+%}O>UQaO7+'hO,+dQ`O7+'hO,+lQ`O7+'hO,-XQpO7+'hO,-aQ`O<<I_O,.|Q`O<<KSO,0iQpO<<KSO>UQaO<<KSO>UQaOAN@nO,0qQ`OAN@nO,2^QpOAN@nO,2fQ`OG26YO>UQaOG26YO,4RQ`OLD+tO,5nQaO,5:}O>UQaO1G0iO,5uQ`O'#I]O$8YQaO'#FeO$8YQaO'#FfO$8YQaO'#FgO$8YQaO'#FhO$8YQaO'#FhO+)PQaO'#FhO$8YQaO'#FkO,6SQaO'#FwO,6ZQaO'#FwO$8YQaO'#GVO+)PQaO'#GVO$8YQaO'#GYO$8YQaO,5;qO+)PQaO,5;qO$8YQaO,5;qO+)PQaO,5;qO$8YQaO,5;qO+)PQaO,5;qO$8YQaO,5;qO+)PQaO,5;qO$8YQaO,5;qO+)PQaO,5;qO$8YQaO,5;qO+)PQaO,5;qO$8YQaO,5;qO+)PQaO,5;qO$8YQaO,5;qO+)PQaO,5;qO$8YQaO,5;qO+)PQaO,5;qO$8YQaO,5;qO+)PQaO,5;qO$8YQaO,5;qO+)PQaO,5;qO$8YQaO,5;qO+)PQaO,5;qO$8YQaO,5;qO+)PQaO,5;qO$8YQaO,5;qO+)PQaO,5;qO$8YQaO,5;qO+)PQaO,5;qO$8YQaO,5;qO+)PQaO,5;qO,8YQ`O'#FlO>UQaO'#EaO>UQaO'#I]O,8bQaO,5:wO,8iQaO,5:wO$8YQaO,5;nO+)PQaO,5;nO$8YQaO,5;pO,:hQ`O,5<PO,<TQ`O,5<QO,=pQ`O,5<RO,?]Q`O,5<SO,@xQ`O,5<SO,BeQ`O,5<SO,CtQ`O,5<VO,EaQ`O,5<cO%7fQ`O,5<cO,F|Q`O,5<tO$8YQaO1G0XO+)PQaO1G0XO,HiQ`O1G1]O,JUQ`O1G1]O,KeQ`O1G1]O,MQQ`O1G1]O,NaQ`O1G1]O- |Q`O1G1]O-#]Q`O1G1]O-$xQ`O1G1]O-&XQ`O1G1]O-'tQ`O1G1]O-)TQ`O1G1]O-*pQ`O1G1]O-,PQ`O1G1]O--lQ`O1G1]O-.{Q`O1G1]O-0hQ`O1G1]O-1wQ`O1G1]O-3dQ`O1G1]O-4sQ`O1G1]O-6`Q`O1G1]O-7oQ`O1G1]O-9[Q`O1G1]O-:kQ`O1G1]O-<WQ`O1G1]O-=gQ`O1G1]O-?SQ`O1G1]O-@cQ`O1G1]O-BOQ`O1G1]O-C_Q`O1G1]O-DzQ`O1G1]O-FZQ`O,5:{O-GvQ`O,5>wO-IcQ`O1G0cO-KOQ`O1G0cO$8YQaO1G0cO+)PQaO1G0cO-L_Q`O1G1YO-MzQ`O1G1YO. ZQ`O1G1[O$8YQaO1G1|O$8YQaO7+%sO+)PQaO7+%sO.!vQ`O7+%sO.$cQ`O7+%sO.%rQ`O7+%}O.'_Q`O7+%}O$8YQaO7+'hO.(nQ`O7+'hO.*ZQ`O<<I_O.+vQ`O<<I_O.-VQ`O<<KSO$8YQaO<<KSO$8YQaOAN@nO..rQ`OAN@nO.0_Q`OG26YO$8YQaOG26YO.1zQ`OLD+tO.3gQaO,5:}O.3nQaO,5:}O$8YQaO1G0iO+)PQaO1G0iO.5mQ`O'#I]O.7PQ`O'#I]O.:fQ`O'#IWO.:vQ`O'#FvO.;OQaO,5:mO.;VQ`O,5<bO.;_Q`O,5<bO!%WQ`O,5<bO.;gQ`O1G0XO.<yQ`O,5:{O.>fQ`O,5>wO.@RQ`O1G1|O!%WQ`O1G1|O0aQ`O1G1|O0aQ`O7+'hO.@ZQ`O7+'hO.@cQpO7+'hO.@kQpO<<KSO0aQ`O<<KSO.@sQpOAN@nO.@{Q`O'#IWO.A]Q`O'#IWO.CSQaO,5:mO.CZQaO,5:mO.CbQ`O,5<bO.CjQ`O7+'hO.CrQ`O1G0XO.EUQ`O1G0XO.FhQ`O1G1|O.FpQ`O7+'hO.FxQpO7+'hO.GQQpOAN@nO.GYQpO<<KSO.GbQpOAN@nO.GjQ`O'#FvO.GrQ`O'#FlO.GzQ`O,5<bO!%WQ`O,5<bO!%WQ`O1G1|O0aQ`O1G1|O0aQ`O7+'hO0aQ`O<<KSO.HSQ`O'#FvO.H[Q`O,5<bO.HdQ`O,5<bO!%WQ`O,5<bO!%WQ`O1G1|O!%WQ`O1G1|O0aQ`O1G1|O0aQ`O<<KSO0aQ`O7+'hO0aQ`O<<KSO.HlQ`O'#FlO.HtQ`O'#FlO.H|Q`O'#Fl",
        stateData: ".Ic~O!dOS!eOS&vOS!gQQ~O!iTO&wRO~OPgOQ|OS!lOU^OW}OX!XO[mO]!_O^!WO`![Oa!SOb!]Ok!dOm!lOowOp!TOq!UOsuOt!gOu!VOv!POxkOykO|!bO}`O!O]O!P!eO!QxO!R}O!TpO!UlO!VlO!W!YO!X!QO!YzO!Z!cO![!ZO!]!^O!^!fO!`!`O!a!RO!cjO!mWO!oXO!sYO!y[O#W_O#bhO#daO#ebO#peO$ToO$]nO$^oO$aqO$drO$l!kO$zyO${!OO$}}O%O}O%V|O'g{O~O!g!mO~O&wRO!i!hX&p!hX&t!hX~O!i!pO~O!d!qO!e!qO!g!mO&t!tO&v!qO~PhO!n!vO~PhOT'VXz'VX!S'VX!b'VX!m'VX!o'VX!v'VX!y'VX#S'VX#W'VX#`'VX#a'VX#p#qX#s'VX#z'VX#{'VX#|'VX#}'VX$O'VX$Q'VX$R'VX$S'VX$T'VX$U'VX$V'VX$W'VX$z'VX&s'VX~O!q!xO~P&sOT#TOz#RO!S#UO!b#VO!m#cO!o!{O!v!yO!y!}O#S#QO#W!zO#`!|O#a!|O#s#PO#z#SO#{#WO#|#XO#}#YO$O#ZO$Q#]O$R#^O$S#_O$T#`O$U#aO$V#bO$W#bO$z#dO&s#cO~OPgOQ|OU^OW}O[mOowOs#hOxkOykO}`O!O]O!QxO!R}O!TpO!UlO!VlO!YzO!cjO!s#gO!y[O#W_O#bhO#daO#ebO#peO$ToO$]nO$^oO$aqO$zyO${!OO$}}O%O}O%V|O'g{O~O!y[O~O!y#kO~OP6]OQ|OU^OW}O[6`Oo=YOs#hOx6^Oy6^O}`O!O]O!Q6dO!R}O!T6cO!U6_O!V6_O!Y6fO!c8fO!s#gO!y[O#S#oO#U#nO#W_O#bhO#daO#ebO#peO$T6bO$]6aO$^6bO$aqO$z6eO${!OO$}}O%O}O%V|O'g{O#X'OP~O!}#sO~P-UO!y#tO~O#b#vO#daO#ebO~O#p#xO~O!s#yO~OU$PO!R$PO!s$OO!v#}O#p2XO~OT&zXz&zX!S&zX!b&zX!m&zX!o&zX!v&zX!y&zX#S&zX#W&zX#`&zX#a&zX#s&zX#z&zX#{&zX#|&zX#}&zX$O&zX$Q&zX$R&zX$S&zX$T&zX$U&zX$V&zX$W&zX$z&zX&s&zX!x&zX!n&zX~O#u$RO#w$SO~P0rOP6]OQ|OU^OW}O[6`Oo=YOs#hOx6^Oy6^O}`O!O]O!Q6dO!R}O!T6cO!U6_O!V6_O!Y6fO!c8fO!s#gO!y[O#W_O#bhO#daO#ebO#peO$T6bO$]6aO$^6bO$aqO$z6eO${!OO$}}O%O}O%V|O'g{OT#xXz#xX!S#xX!b#xX!m#xX!o#xX!v#xX#`#xX#a#xX#s#xX#z#xX#{#xX#|#xX#}#xX$O#xX$Q#xX$R#xX$S#xX$U#xX$V#xX$W#xX&s#xX!x#xX!n#xX~Or$UO#S6yO#U6xO~P2yO!s#gO#peO~OS$gO]$bOk$eOm$gOs$aO!`$cO$drO$l$fO~O!s$kO!y$hO#S$jO~Oo$mOs$lO#b$nO~O!y$hO#S$rO~O$l$tO~P*kOR$zO!o$yO#b$xO#e$yO&q$zO~O'f$|O~P8lO!y%RO~O!y%TO~O!s%VO~O!m#cO&s#cO~P*kO!oXO~O!y%_O~OP6]OQ|OU^OW}O[6`Oo=YOs#hOx6^Oy6^O}`O!O]O!Q6dO!R}O!T6cO!U6_O!V6_O!Y6fO!c8fO!s#gO!y[O#W_O#bhO#daO#ebO#peO$T6bO$]6aO$^6bO$aqO$z6eO${!OO$}}O%O}O%V|O'g{O~O!y%cO~O!s%dO~O]$bO~O!s%hO~O!s%iO~O!s%jO~O!oXO!s#gO#peO~O]%rOs%rO!o%pO!s#gO#p%nO~O!s%vO~O!i%wO&t%wO&wRO~O&t%zO~PhO!n%{O~PhOPgOQ|OU^OW}O[8lOo=yOs#hOx8jOy8jO}`O!O]O!Q8pO!R}O!T8oO!U8kO!V8kO!Y8rO!c8iO!s#gO!y[O#W_O#bhO#daO#ebO#peO$T8nO$]8mO$^8nO$aqO$z8qO${!OO$}}O%O}O%V|O'g{O~O!q%}O~P>UO#X&PO~P>UO!o&SO!s&RO#b&RO~OPgOQ|OU^OW}O[8lOo=yOs#hOx8jOy8jO}`O!O]O!Q8pO!R}O!T8oO!U8kO!V8kO!Y8rO!c8iO!s&VO!y[O#U&WO#W_O#bhO#daO#ebO#peO$T8nO$]8mO$^8nO$aqO$z8qO${!OO$}}O%O}O%V|O'g{O~O!x'SP~PAOO!s&[O#b&[O~OT#TOz#RO!S#UO!b#VO!o!{O!v!yO!y!}O#S#QO#W!zO#`!|O#a!|O#s#PO#z#SO#{#WO#|#XO#}#YO$O#ZO$Q#]O$R#^O$S#_O$T#`O$U#aO$V#bO$W#bO$z#dO~O!x&nO~PCqO!x'VX!}'VX#O'VX#X'VX!n'VXV'VX!q'VX#u'VX#w'VXw'VX~P&sO!y$hO#S&oO~Oo$mOs$lO~O!o&pO~O!}&sO#S;dO#U;cO!x'OP~P9yOT6iOz6gO!S6jO!b6kO!o!{O!v8sO!y!}O#S#QO#W!zO#`!|O#a!|O#s#PO#z6hO#{6lO#|6mO#}6nO$O6oO$Q6qO$R6rO$S6sO$T6tO$U6uO$V6vO$W6vO$z#dO!}'PX#X'PX~O#O&tO~PGSO!}&wO#X'OX~O#X&yO~O!}'OO!x'QP~P9yO!n'PO~PCqO!m#oa!o#oa#S#oa#p#qX&s#oa!x#oa#O#oaw#oa~OT#oaz#oa!S#oa!b#oa!v#oa!y#oa#W#oa#`#oa#a#oa#s#oa#z#oa#{#oa#|#oa#}#oa$O#oa$Q#oa$R#oa$S#oa$T#oa$U#oa$V#oa$W#oa$z#oa!}#oa#X#oa!n#oaV#oa!q#oa#u#oa#w#oa~PIpO!s'RO~O!x'UO#l'SO~O!x'VX#l'VX#p#qX#S'VX#U'VX#b'VX!o'VX#O'VXw'VX!m'VX&s'VX~O#S'YO~P*kO!m$Xa&s$Xa!x$Xa!n$Xa~PCqO!m$Ya&s$Ya!x$Ya!n$Ya~PCqO!m$Za&s$Za!x$Za!n$Za~PCqO!m$[a&s$[a!x$[a!n$[a~PCqO!o!{O!y!}O#W!zO#`!|O#a!|O#s#PO$z#dOT$[a!S$[a!b$[a!m$[a!v$[a#S$[a#z$[a#{$[a#|$[a#}$[a$O$[a$Q$[a$R$[a$S$[a$T$[a$U$[a$V$[a$W$[a&s$[a!x$[a!n$[a~Oz#RO~PNyO!m$_a&s$_a!x$_a!n$_a~PCqO!y!}O!}$fX#X$fX~O!}'^O#X'ZX~O#X'`O~O!s$kO#S'aO~O]'cO~O!s'eO~O!s'fO~O$l'gO~O!`'mO#S'kO#U'lO#b'jO$drO!x'XP~P0aO!^'sO!oXO!q'rO~O!s'uO!y$hO~O!y$hO#S'wO~O!y$hO#S'yO~O#u'zO!m$sX!}$sX&s$sX~O!}'{O!m'bX&s'bX~O!m#cO&s#cO~O!q(PO#O(OO~O!m$ka&s$ka!x$ka!n$ka~PCqOl(ROw(SO!o(TO!y!}O~O!o!{O!y!}O#W!zO#`!|O#a!|O#s#PO~OT$yaz$ya!S$ya!b$ya!m$ya!v$ya#S$ya#z$ya#{$ya#|$ya#}$ya$O$ya$Q$ya$R$ya$S$ya$T$ya$U$ya$V$ya$W$ya$z$ya&s$ya!x$ya!}$ya#O$ya#X$ya!n$ya!q$yaV$ya#u$ya#w$ya~P!'WO!m$|a&s$|a!x$|a!n$|a~PCqO#W([O#`(YO#a(YO&r(ZOR&gX!o&gX#b&gX#e&gX&q&gX'f&gX~O'f(_O~P8lO!q(`O~PhO!o(cO!q(dO~O!q(`O&s(gO~PhO!a(kO~O!m(lO~P9yOZ(wOn(xO~O!s(zO~OT6iOz6gO!S6jO!b6kO!v8sO!}({O#S#QO#z6hO#{6lO#|6mO#}6nO$O6oO$Q6qO$R6rO$S6sO$T6tO$U6uO$V6vO$W6vO$z#dO!m'jX&s'jX~P!'WO#u)PO~O!})QO!m'`X&s'`X~Ol(RO!o(TO~Ow(SO!o)WO!q)ZO~O!m#cO!oXO&s#cO~O!o%pO!s#yO~OV)aO!})_O!m'kX&s'kX~O])cOs)cO!s#gO#peO~O!o%pO!s#gO#p)hO~OT6iOz6gO!S6jO!b6kO!v8sO!})iO#S#QO#z6hO#{6lO#|6mO#}6nO$O6oO$Q6qO$R6rO$S6sO$T6tO$U6uO$V6vO$W6vO$z#dO!m&|X&s&|X#O&|X~P!'WOl(ROw(SO!o(TO~O!i)oO&t)oO~OT8vOz8tO!S8wO!b8xO!q)pO!v=ZO#S#QO#z8uO#{8yO#|8zO#}8{O$O8|O$Q9OO$R9PO$S9QO$T9RO$U9SO$V9TO$W9TO$z#dO~P!'WOT8vOz8tO!S8wO!b8xO!v=ZO#S#QO#X)rO#z8uO#{8yO#|8zO#}8{O$O8|O$Q9OO$R9PO$S9QO$T9RO$U9SO$V9TO$W9TO$z#dO~P!'WO!n)rO~PCqOT8vOz8tO!S8wO!b8xO!v=ZO#S#QO#z8uO#{8yO#|8zO#}8{O$O8|O$Q9OO$R9PO$S9QO$T9RO$U9SO$V9TO$W9TO$z#dO!x'TX!}'TX~P!'WOT'VXz'VX!S'VX!b'VX!o'VX!v'VX!y'VX#S'VX#W'VX#`'VX#a'VX#p#qX#s'VX#z'VX#{'VX#|'VX#}'VX$O'VX$Q'VX$R'VX$S'VX$T'VX$U'VX$V'VX$W'VX$z'VX~O!q)tO!x'VX!}'VX~P!5xO!x#iX!}#iX~P>UO!})vO!x'SX~O!x)xO~O$z#dOT#yiz#yi!S#yi!b#yi!m#yi!v#yi#S#yi#z#yi#{#yi#|#yi#}#yi$O#yi$Q#yi$R#yi$S#yi$T#yi$U#yi$V#yi$W#yi&s#yi!x#yi!}#yi#O#yi#X#yi!n#yi!q#yiV#yi#u#yi#w#yi~P!'WOz#RO#S#QO#z#SO#{#WO#|#XO#}#YO$O#ZO$Q#]O$R#^O$S#_O$T#`O$U#aO$V#bO$W#bO$z#dOT#yi!S#yi!b#yi!m#yi!v#yi&s#yi!x#yi!n#yi~P!'WOz#RO!v!yO#S#QO#z#SO#{#WO#|#XO#}#YO$O#ZO$Q#]O$R#^O$S#_O$T#`O$U#aO$V#bO$W#bO$z#dOT#yi!S#yi!b#yi!m#yi&s#yi!x#yi!n#yi~P!'WOT#TOz#RO!b#VO!v!yO#S#QO#z#SO#{#WO#|#XO#}#YO$O#ZO$Q#]O$R#^O$S#_O$T#`O$U#aO$V#bO$W#bO$z#dO!S#yi!m#yi&s#yi!x#yi!n#yi~P!'WOT#TOz#RO!v!yO#S#QO#z#SO#{#WO#|#XO#}#YO$O#ZO$Q#]O$R#^O$S#_O$T#`O$U#aO$V#bO$W#bO$z#dO!S#yi!b#yi!m#yi&s#yi!x#yi!n#yi~P!'WOz#RO#S#QO#|#XO#}#YO$O#ZO$Q#]O$R#^O$S#_O$T#`O$U#aO$V#bO$W#bO$z#dOT#yi!S#yi!b#yi!m#yi!v#yi#z#yi#{#yi&s#yi!x#yi!n#yi~P!'WOz#RO#S#QO#}#YO$O#ZO$Q#]O$R#^O$S#_O$T#`O$U#aO$V#bO$W#bO$z#dOT#yi!S#yi!b#yi!m#yi!v#yi#z#yi#{#yi#|#yi&s#yi!x#yi!n#yi~P!'WOz#RO#S#QO$O#ZO$Q#]O$R#^O$S#_O$T#`O$U#aO$V#bO$W#bO$z#dOT#yi!S#yi!b#yi!m#yi!v#yi#z#yi#{#yi#|#yi#}#yi&s#yi!x#yi!n#yi~P!'WOz#RO#S#QO$Q#]O$R#^O$S#_O$T#`O$U#aO$V#bO$W#bO$z#dOT#yi!S#yi!b#yi!m#yi!v#yi#z#yi#{#yi#|#yi#}#yi$O#yi&s#yi!x#yi!n#yi~P!'WOz#RO$Q#]O$R#^O$S#_O$T#`O$U#aO$V#bO$W#bO$z#dOT#yi!S#yi!b#yi!m#yi!v#yi#S#yi#z#yi#{#yi#|#yi#}#yi$O#yi&s#yi!x#yi!n#yi~P!'WOz#RO$R#^O$S#_O$T#`O$U#aO$V#bO$W#bO$z#dOT#yi!S#yi!b#yi!m#yi!v#yi#S#yi#z#yi#{#yi#|#yi#}#yi$O#yi$Q#yi&s#yi!x#yi!n#yi~P!'WOz#RO$S#_O$T#`O$U#aO$V#bO$W#bO$z#dOT#yi!S#yi!b#yi!m#yi!v#yi#S#yi#z#yi#{#yi#|#yi#}#yi$O#yi$Q#yi$R#yi&s#yi!x#yi!n#yi~P!'WOz#RO$T#`O$V#bO$W#bO$z#dOT#yi!S#yi!b#yi!m#yi!v#yi#S#yi#z#yi#{#yi#|#yi#}#yi$O#yi$Q#yi$R#yi$S#yi$U#yi&s#yi!x#yi!n#yi~P!'WOz#RO$V#bO$W#bO$z#dOT#yi!S#yi!b#yi!m#yi!v#yi#S#yi#z#yi#{#yi#|#yi#}#yi$O#yi$Q#yi$R#yi$S#yi$T#yi$U#yi&s#yi!x#yi!n#yi~P!'WOz#RO$S#_O$T#`O$V#bO$W#bO$z#dOT#yi!S#yi!b#yi!m#yi!v#yi#S#yi#z#yi#{#yi#|#yi#}#yi$O#yi$Q#yi$R#yi$U#yi&s#yi!x#yi!n#yi~P!'WOz#RO$W#bO$z#dOT#yi!S#yi!b#yi!m#yi!v#yi#S#yi#z#yi#{#yi#|#yi#}#yi$O#yi$Q#yi$R#yi$S#yi$T#yi$U#yi$V#yi&s#yi!x#yi!n#yi~P!'WO_)yO~P9yO!x)|O~O#S*PO~P9yOT6iOz6gO!S6jO!b6kO!v8sO#S#QO#z6hO#{6lO#|6mO#}6nO$O6oO$Q6qO$R6rO$S6sO$T6tO$U6uO$V6vO$W6vO$z#dO!}#Ta#X#Ta#O#Ta!m#Ta&s#Ta!x#Ta!n#TaV#Ta!q#Ta~P!'WOT6iOz6gO!S6jO!b6kO!v8sO#S#QO#z6hO#{6lO#|6mO#}6nO$O6oO$Q6qO$R6rO$S6sO$T6tO$U6uO$V6vO$W6vO$z#dO!}'Pa#X'Pa#O'Pa!m'Pa&s'Pa!x'Pa!n'PaV'Pa!q'Pa~P!'WO#S#oO#U#nO!}&WX#X&WX~P9yO!}&wO#X'Oa~O#X*SO~OT6iOz6gO!S6jO!b6kO!v8sO!}*UO#O*TO#S#QO#z6hO#{6lO#|6mO#}6nO$O6oO$Q6qO$R6rO$S6sO$T6tO$U6uO$V6vO$W6vO$z#dO!x'QX~P!'WO!}*UO!x'QX~O!x*WO~O!m#oi!o#oi#S#oi#p#qX&s#oi!x#oi#O#oiw#oi~OT#oiz#oi!S#oi!b#oi!v#oi!y#oi#W#oi#`#oi#a#oi#s#oi#z#oi#{#oi#|#oi#}#oi$O#oi$Q#oi$R#oi$S#oi$T#oi$U#oi$V#oi$W#oi$z#oi!}#oi#X#oi!n#oiV#oi!q#oi#u#oi#w#oi~P#*zO#l'SO!x#ka#S#ka#U#ka#b#ka!o#ka#O#kaw#ka!m#ka&s#ka~OPgOQ|OU^OW}O[4OOo5xOs#hOx3zOy3zO}`O!O]O!Q2^O!R}O!T4UO!U3|O!V3|O!Y2`O!c3xO!s#gO!y[O#W_O#bhO#daO#ebO#peO$T4SO$]4QO$^4SO$aqO$z2_O${!OO$}}O%O}O%V|O'g{O~O#l#oa#U#oa#b#oa~PIpOz#RO!v!yO#S#QO#z#SO#{#WO#|#XO#}#YO$O#ZO$Q#]O$R#^O$S#_O$T#`O$U#aO$V#bO$W#bO$z#dOT#Pi!S#Pi!b#Pi!m#Pi&s#Pi!x#Pi!n#Pi~P!'WOz#RO!v!yO#S#QO#z#SO#{#WO#|#XO#}#YO$O#ZO$Q#]O$R#^O$S#_O$T#`O$U#aO$V#bO$W#bO$z#dOT#vi!S#vi!b#vi!m#vi&s#vi!x#vi!n#vi~P!'WO!m#xi&s#xi!x#xi!n#xi~PCqO!s#gO#peO!}&^X#X&^X~O!}'^O#X'Za~O!s'uO~Ow(SO!o)WO!q*fO~O!s*jO~O#S*lO#U*mO#b*kO#l'SO~O#S*lO#U*mO#b*kO$drO~P0aO#u*oO!x$cX!}$cX~O#U*mO#b*kO~O#b*pO~O#b*rO~P0aO!}*sO!x'XX~O!x*uO~O!y*wO~O!^*{O!oXO!q*zO~O!q*}O!o'ci!m'ci&s'ci~O!q+QO#O+PO~O#b$nO!m&eX!}&eX&s&eX~O!}'{O!m'ba&s'ba~OT$kiz$ki!S$ki!b$ki!m$ki!o$ki!v$ki!y$ki#S$ki#W$ki#`$ki#a$ki#s$ki#u#fa#w#fa#z$ki#{$ki#|$ki#}$ki$O$ki$Q$ki$R$ki$S$ki$T$ki$U$ki$V$ki$W$ki$z$ki&s$ki!x$ki!}$ki#O$ki#X$ki!n$ki!q$kiV$ki~OS+^O]+aOm+^Os$aO!^+dO!_+^O!`+^O!n+hO#b$nO$aqO$drO~P0aO!s+lO~O#W+nO#`+mO#a+mO~O!s+pO#b+pO$}+pO%T+oO~O!n+qO~PCqOc%XXd%XXh%XXj%XXf%XXg%XXe%XX~PhOc+uOd+sOP%WiQ%WiS%WiU%WiW%WiX%Wi[%Wi]%Wi^%Wi`%Wia%Wib%Wik%Wim%Wio%Wip%Wiq%Wis%Wit%Wiu%Wiv%Wix%Wiy%Wi|%Wi}%Wi!O%Wi!P%Wi!Q%Wi!R%Wi!T%Wi!U%Wi!V%Wi!W%Wi!X%Wi!Y%Wi!Z%Wi![%Wi!]%Wi!^%Wi!`%Wi!a%Wi!c%Wi!m%Wi!o%Wi!s%Wi!y%Wi#W%Wi#b%Wi#d%Wi#e%Wi#p%Wi$T%Wi$]%Wi$^%Wi$a%Wi$d%Wi$l%Wi$z%Wi${%Wi$}%Wi%O%Wi%V%Wi&p%Wi'g%Wi&t%Wi!n%Wih%Wij%Wif%Wig%WiY%Wi_%Wii%Wie%Wi~Oc+yOd+vOh+xO~OY+zO_+{O!n,OO~OY+zO_+{Oi%^X~Oi,QO~Oj,RO~O!m,TO~P9yO!m,VO~Of,WO~OT6iOV,XOz6gO!S6jO!b6kO!v8sO#S#QO#z6hO#{6lO#|6mO#}6nO$O6oO$Q6qO$R6rO$S6sO$T6tO$U6uO$V6vO$W6vO$z#dO~P!'WOg,YO~O!y,ZO~OZ(wOn(xOP%liQ%liS%liU%liW%liX%li[%li]%li^%li`%lia%lib%lik%lim%lio%lip%liq%lis%lit%liu%liv%lix%liy%li|%li}%li!O%li!P%li!Q%li!R%li!T%li!U%li!V%li!W%li!X%li!Y%li!Z%li![%li!]%li!^%li!`%li!a%li!c%li!m%li!o%li!s%li!y%li#W%li#b%li#d%li#e%li#p%li$T%li$]%li$^%li$a%li$d%li$l%li$z%li${%li$}%li%O%li%V%li&p%li'g%li&t%li!n%lic%lid%lih%lij%lif%lig%liY%li_%lii%lie%li~O#u,_O~O!}({O!m%da&s%da~O!x,bO~O!s%dO!m&dX!}&dX&s&dX~O!})QO!m'`a&s'`a~OS+^OY,iOm+^Os$aO!^+dO!_+^O!`+^O$aqO$drO~O!n,lO~P#JwO!o)WO~O!o%pO!s'RO~O!s#gO#peO!m&nX!}&nX&s&nX~O!})_O!m'ka&s'ka~O!s,rO~OV,sO!n%|X!}%|X~O!},uO!n'lX~O!n,wO~O!m&UX!}&UX&s&UX#O&UX~P9yO!})iO!m&|a&s&|a#O&|a~Oz#RO#S#QO#z#SO#{#WO#|#XO#}#YO$O#ZO$Q#]O$R#^O$S#_O$T#`O$U#aO$V#bO$W#bO$z#dOT!uq!S!uq!b!uq!m!uq!v!uq&s!uq!x!uq!n!uq~P!'WO!n,|O~PCqOT8vOz8tO!S8wO!b8xO!v=ZO#S#QO#z8uO#{8yO#|8zO#}8{O$O8|O$Q9OO$R9PO$S9QO$T9RO$U9SO$V9TO$W9TO$z#dO!x#ia!}#ia~P!'WO!x&YX!}&YX~PAOO!})vO!x'Sa~O#O-QO~O!}-RO!n&{X~O!n-TO~O!x-UO~OT6iOz6gO!S6jO!b6kO!v8sO#S#QO#z6hO#{6lO#|6mO#}6nO$O6oO$Q6qO$R6rO$S6sO$T6tO$U6uO$V6vO$W6vO$z#dO!}#Vi#X#Vi~P!'WO!x&XX!}&XX~P9yO!}*UO!x'Qa~O!x-[O~OT#jqz#jq!S#jq!b#jq!m#jq!v#jq#S#jq#u#jq#w#jq#z#jq#{#jq#|#jq#}#jq$O#jq$Q#jq$R#jq$S#jq$T#jq$U#jq$V#jq$W#jq$z#jq&s#jq!x#jq!}#jq#O#jq#X#jq!n#jq!q#jqV#jq~P!'WO#l#oi#U#oi#b#oi~P#*zOz#RO!v!yO#S#QO#z#SO#{#WO#|#XO#}#YO$O#ZO$Q#]O$R#^O$S#_O$T#`O$U#aO$V#bO$W#bO$z#dOT#Pq!S#Pq!b#Pq!m#Pq&s#Pq!x#Pq!n#Pq~P!'WO#u-dO!x$ca!}$ca~O#U-fO#b-eO~O#b-gO~O#S-hO#U-fO#b-eO#l'SO~O#b-jO#l'SO~O#u-kO!x$ha!}$ha~O!`'mO#S'kO#U'lO#b'jO$drO!x&_X!}&_X~P0aO!}*sO!x'Xa~O!oXO#l'SO~O#S-pO#b-oO!x'[P~O!oXO!q-rO~O!q-uO!o'cq!m'cq&s'cq~O!^-wO!oXO!q-rO~O!q-{O#O-zO~OT6iOz6gO!S6jO!b6kO!v8sO#S#QO#z6hO#{6lO#|6mO#}6nO$O6oO$Q6qO$R6rO$S6sO$T6tO$U6uO$V6vO$W6vO$z#dO!m$si!}$si&s$si~P!'WO!m$jq&s$jq!x$jq!n$jq~PCqO#O-zO#l'SO~O!}-|Ow']X!o']X!m']X&s']X~O#b$nO#l'SO~OS+^O].ROm+^Os$aO!_+^O!`+^O#b$nO$aqO$drO~P0aOS+^O].ROm+^Os$aO!_+^O!`+^O#b$nO$aqO~P0aOS+^O]+aOm+^Os$aO!^+dO!_+^O!`+^O!n.ZO#b$nO$aqO$drO~P0aO!s.^O~O!s._O#b._O$}._O%T+oO~O$}.`O~O#X.aO~Oc%Xad%Xah%Xaj%Xaf%Xag%Xae%Xa~PhOc.dOd+sOP%WqQ%WqS%WqU%WqW%WqX%Wq[%Wq]%Wq^%Wq`%Wqa%Wqb%Wqk%Wqm%Wqo%Wqp%Wqq%Wqs%Wqt%Wqu%Wqv%Wqx%Wqy%Wq|%Wq}%Wq!O%Wq!P%Wq!Q%Wq!R%Wq!T%Wq!U%Wq!V%Wq!W%Wq!X%Wq!Y%Wq!Z%Wq![%Wq!]%Wq!^%Wq!`%Wq!a%Wq!c%Wq!m%Wq!o%Wq!s%Wq!y%Wq#W%Wq#b%Wq#d%Wq#e%Wq#p%Wq$T%Wq$]%Wq$^%Wq$a%Wq$d%Wq$l%Wq$z%Wq${%Wq$}%Wq%O%Wq%V%Wq&p%Wq'g%Wq&t%Wq!n%Wqh%Wqj%Wqf%Wqg%WqY%Wq_%Wqi%Wqe%