<?php

/**
 * @package Helix Ultimate Framework
 * @author JoomShaper https://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2020 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or Later
 */

defined('JPATH_BASE') or die();

use Joomla\CMS\Language\Text;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Layout\LayoutHelper;

$intro = (isset($displayData['intro']) && $displayData['intro']) ? $displayData['intro'] : false;
$displayData['articleView'] = ($intro) ? 'intro' : 'details';
$blockPosition = $displayData['params']->get('info_block_position', 0);

?>
<div class="article-author-info d-flex justify-content-between align-items-center">

	<?php if (
		$displayData['position'] === 'above' && ($blockPosition == 0 || $blockPosition == 2)
		|| $displayData['position'] === 'below' && ($blockPosition == 1)
	) : ?>

		<?php if ($displayData['params']->get('show_author') && !empty($displayData['item']->author)) : ?>
			<?php echo $this->sublayout('author', $displayData); ?>
		<?php endif; ?>

		<?php if ($intro) : ?>
			<?php echo LayoutHelper::render('joomla.content.blog.comments.count', $displayData); ?>
		<?php endif; ?>

	<?php endif; ?>

	<span class="create" title="<?php echo Text::sprintf('COM_CONTENT_CREATED_DATE_ON', HTMLHelper::_('date', $displayData['item']->created, Text::_('DATE_FORMAT_LC3'))); ?>">
		<time datetime="<?php echo HTMLHelper::_('date', $displayData['item']->created, 'c'); ?>">
			<?php echo Text::_("HELIX_ULTIMATE_PUBLISHED_ON"); ?> <?php echo HTMLHelper::_('date', $displayData['item']->created, Text::_('DATE_FORMAT_LC3')); ?>
		</time>	
	</span>
</div>